<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only translates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release


// ### Note for translators about translation of text ending with punctuation
// ###
// ### The current list of concerned punctuation can be found in 'lib/init/tra.php'
// ### On 2009-03-02, it is: (':', '!', ';', '.', ',', '?')
// ### For clarity, we explain here only for colons: ':' but it is the same for the rest
// ###
// ### Short version: it is not a problem that string "Login:" has no translation. Only "Login" needs to be translated.
// ###
// ### Technical justification:
// ### If a string ending with colon needs translating (like "{tr}Login:{/tr}")
// ### then TikiWiki tries to translate 'Login' and ':' separately.
// ### This allows to have only one translation for "{tr}Login{/tr}" and "{tr}Login:{/tr}"
// ### and it still allows to translate ":" as "&nbsp;:" for languages that
// ### need it (like french)

$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"You do not have permission to use this feature." => "شما حق دسترسي كافي براي استفاده از اين خصيصه را نداريد.",
"Process %s is imported" => "فرايند %s وارد شد",
"uploaded by" => "بارگذاري شده به‌وسيله‌ي",
"not specified" => "نامشخص",
"There was a problem with your upload." => "مشكلي در بارگذاري شما بوجود آمده است.",
"The file you are trying to upload is too big." => "پرونده‌اي كه مي‌خواهيد بارگذاري كنيد، بسيار حجيم است",
"The file you are trying to upload was only partially uploaded." => "پرونده‌اي كه مي‌خواستيد بارگذاري كنيد، نيمه‌كاره بارگذاري شد!",
"You must select a file for upload." => "شما بايد يك پرونده براي بارگذاري انتخاب كنيد.",
" line " => " خط ",
"Error: No" => "خطاي شماره‌ي:",
"permission." => "حقوق دسترسي.",
"Error: Invalid" => "خطا: بي اعتباري",
"Error: Call to hw_page_fetch_by_id failed!" => "خطا: صدازدن hw_page_fetch_by_id موفق نبود!",
"%s is an empty archive file" => "%s يك پرونده‌ي بايگاني خالي است",
"Invalid remote file on url %s" => "پرونده‌ي راه‌دور در آدرس %s معتبر نيست",
"Project Group for " => "گروه پروژه براي ",
"Project Admin Group for " => "گروه مديريت پروژه براي ",
"%A %d of %B, %Y" => "%A %d از %B, %Y",
"%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %d از %B, %Y[%H:%M:%S %Z]",
"%H:%M:%S %Z" => "%H:%M:%S %Z",
"%a %d of %b, %Y" => "%a %d از %b, %Y",
"%a %d of %b, %Y[%H:%M %Z]" => "%a %d از %b, %Y[%H:%M %Z]",
"no description" => "بدون شرح",
"Updated" => "به‌روز رساني شد",
"User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login." => "اختيارات: از اختيارات براي تغذيه‌ي خودكار ستون استفاده كنيد. مي‌توانيد از 1 براي مولف و 2 براي تغييردهنده استفاده كنيد.",
"Category options: parentId" => "اختيارات: parentId",
"Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing" => "اختيارات: trackerId,fieldId,linkToItem پيوند به اقلامي از trackerid هستند كه fielded معادل محتويات اين ستون است. linkToItem 0و1 براي ايجاد يك پيوند به فقره در حالت نمايش و تغيير.",
"~np~{~/np~ARTICLES(max=>3,topic=>topicName)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,topic=>topicName)}{ARTICLES} درج مقاله‌ها در يك صفحه‌ي ويكي",
"num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link." => "شماره(num) اختياري است و ترتيب ضمايم را در فهرست مشخص مي‌كند. اگر وارد نشود، فهرستي از تمام ضمايم نمايش داده مي‌شود. Inline باعث مي‌شود نظر به متن پيوند تبديل شود.",
"~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} درج خروجي تغذيه‌ي RSS در يك صفحه‌ي ويكي",
"You need to supply information for : " => "شما بايد در اين خصوص اطلاعات بيشتري فراهم كنيد: ",
"missing tracker ID for plugin TRACKER" => "براي Plugin مربوط به tracker، شناسه‌ي tracker مفقود است",
"User \$a_user can not receive messages" => "كاربر \$a_user نتوانست پيغام را دريافت كند",
"Invalid user: \$a_user" => "كاربر: \$a_user معتبر نيست",
"delete" => "حذف",
"show categories" => "طبقات را نمايش بده",
"Tip: hold down CTRL to select multiple categories" => "نكته: براي انتخاب چندين طبقه، دكمه‌ي CTRL را نگه‌داريد‌‌",
"Tip: uncheck the above checkbox to uncategorize this page/object" => "نكته: براي از طبقه‌بندي در آوردن اين شيء، گزينه‌ي بالا را رفع انتخاب كنيد",
"author" => "مؤلف",
"user level" => "سطح كاربر",
"send email to user" => "ارسال پست الكترونيكي به كاربر",
"score" => "امتياز",
"delete selected" => "انتخاب شده‌ها را حذف كن",
"move" => "انتقال",
"Posted messages" => "پيغام‌هاي الصاق شده",
"set" => "تغيير بده",
"replies" => "پاسخ داده‌شده",
"new reply" => "پاسخ جديد",
"post" => "الصاق",
"cancel" => "لغو",
"add" => "اضافه كن",
"Click here to create it" => "براي ساخت اين‌جا را كليك كنيد",
"To the event:" => "به اين رويداد:",
"Event:" => "رويداد:",
"You can unsubscribe from this event following this link" => "با دنبال كردن اين پيوند، مي‌توانيد از اين رويداد لغو اشتراك كنيد",
"Welcome to our event!" => "به رويدادهاي ما خوش‌آمديد!",
"someone coming from IP Address" => "كسي از اين آدرس مي‌آيد",
"requested a reminder of the password for the" => "درخواست يادآوري كلمه‌ي عبور براي",
"since this is your registered email address we inform that the" => "از آن‌جايي كه اين آدرس پست الكترونيكي ثبت شده‌ي شما است، به اطلاع مي‌رساند كه",
"password for this account is" => "كلمه‌ي عبور اين حساب عبارت است از",
"Information:" => "اطلاعات:",
"The page {\$mail_page} was changed by {\$mail_user} at\n{\$mail_date|tiki_short_datetime}" => "صفحه‌ي {\$mail_page} به‌وسيله‌ي{\$mail_user}  در\n{\$mail_date|tiki_short_datetime} تغيير كرد",
"You can view the page by following this link:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}" => "با دنبال كردن اين پيوند، مي‌توانيد اين صفحه را مشاهده كنيد:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}",
"You can edit the page by following this link:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}" => "با دنبال كردن اين پيوند مي‌توانيد اين صفحه را ويرايش كنيد::\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}",
"You can view a diff back to the previous version by following\nthis link:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}" => "با دنبال كردن اين پيوند مي‌توانيد تفاوت اين نسخه با نسخه‌ي قبلي را مشاهده كنيد \nاين صفحه:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}",
"stop monitoring this map" => "ديده‌باني اين نقشه را متوقف كن",
"create" => "ايحاد كن",
"save" => "ذخيره كن",
"DATE-of" => "ام",
"edit template" => "ويرايش الگو",
"send" => "بفرست",
"up" => "انتقال به بالا",
"down" => "انتقال به پايين",
"Projects Menu" => "منوي پروژه‌ها",
"Register New Project" => "ثبت پروژه‌ي جديد",
"HomeworkMenu" => "منوي مشق شب",
"List Courses" => "فهرست دوه‌ها",
"Admin->Modules" => "مديريت -> ماژول‌ها",
"Last visitors" => "آخرين بازديد كنندگان",
"register" => "ثبت‌نام",
"standard" => "معمولي",
"secure" => "امن",
"stay in ssl mode" => "در باب ssl بمان",
"go" => "برو",
"cache" => "زمان نگهداري در نهانگان(Cache)",
"use" => "استفاده از ساختار",
"refresh" => "بازيابي كن",
"print" => "چاپش كن",
"create pdf" => "ساخت PDF",
"monitor this page" => "اين صفحه را ديده‌باني كن",
"stop monitoring this page" => "ديده‌باني اين صفحه را متوقف كن",
"backlinks" => "پيوند به‌عقب‌ها",
"last modification" => "آخرين تغييرات",
"rename" => "تغيير نام",
"unlock" => "بازكردن قفل",
"lock" => "قفلش كن",
"perms" => "حقوق دسترسي‌ها",
"history" => "تاريخچه",
"similar" => "مشابهات",
"undo" => "برگشت عمل",
"slides" => "اسلايدها",
"export" => "صدور",
"discuss" => "بحث",
"add comment" => "افزودن نظريه",
"attach file" => "ضميمه‌كردن پرونده",
"translation" => "ترجمه",
"attachments" => "ضمايم",
"stats" => "آمار",
"last changes" => "آخرين تغييرات",
"list pages" => "فهرست صفحات",
"back to homepage" => "بازگشت به صفحه‌ي مبدا",
"Please" => "لطفا",
"log in" => "به برنامه وارد شويد",
"to access full functionalities" => "تا به تمام خصايص دسترسي پيدا كنيد",
"cancel edit" => "تغييرات را لغو كن",
"No attachments for this page" => "اين صفحه، ضميمه‌اي ندارد",
"Skip to navigation" => "پرش به ناوبري",
"reads" => "تعداد دفعات مشاهده",
"cached" => "cache شده",
"Jukebox" => "Jukebox",
"Site Calendar" => "تقويم پايگاه",
"to add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or" => "براي اضافه/حذف بلاگ‌ها، در فهرست استفاده به قسمت 'ساخت/ويرايش بلاگ' در بخش 'بلاگ‌ها' برويد، ويا",
"Blog settings" => "تنظيمات بلاگ",
"ok" => "قبول",
"Users see and add events in their timezone" => "كاربران رويدادها را در ساعت محلي خود ببينند و ايجاد كننده",
"look under \"Articles\" on the application menu for links to" => "براي پيوندهايي اين‌چنين، بخش \"مقالات\" را پيوييد",
"Friendship network" => "شبكه‌ي رفاقت",
"Allow permissions for friendship network" => "حقوق دسترسي براي شبكه‌ي رفاقت اعمال شود",
"Max friendship distance" => "حداكثر فاصله‌ي رفاقت",
"to configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or" => "براي پيكربندي پوشه‌ي خود،  \"مديريت پوشه\" را تحت  \"پوشه\" در منوي برنامه بيابيد، يا",
"to add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "براي حذف/اضافه‌ي FAQ\tها، دنبال \"مديريت FAQها\" تحت \"FAQها\" در منوي برنامه بگرديد، يا",
"FAQs settings" => "تنظيمات FAQ",
"FAQ comments" => "نظرات مربوط به بخش سئوالات متداول",
"TikiTabs" => "برگه‌هاي تيكي",
"Best language" => "بهترين زبان",
"Tiki Projects" => "پروژه‌هاي تيكي",
"to add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "براي حذف/اضافه كردن سرسراها، به 'سرسراهاي پرونده' در منو برنامه مراجعه كنيد، يا",
"to add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "براي حذف/اضافه كردن انجمن‌ها دنبال \"مديريت انجمن\" زير \"انجمن‌ها\"در منوي برنامه بگرديد، يا",
"to add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "براي حذف/اضافه كردن سرسراهاي تصاوير، سراغ \"سرسراهاي تصاوير\" در منوي برنامه برويد، يا",
"PHP error reporting level for non-admin:" => "سطح گزارش خطاي PHP براي غير سرپرست‌ها",
"Report PHP errors only for admin" => "خطاهاي PHP رو فقط براي سرپرست گزارش بده",
"Server name (for absolute URIs)" => "نام سرور(server)-(براي URIهاي مطلق)",
"HTTPS Server" => "سرور HTTPS",
"Automatic (uses HTTPS variable)" => "خودكار (از متغييرهاي HTTPS استفاده كن)",
"Wiki_Tiki_Title" => "عنوان تيكي‌ويكي",
"Jukebox settings" => "تنظيمات jukebox",
"Jukebox tracks location" => "محل آثار(tracks)‌‌ jukebox",
"Jukebox features" => "خصيصه‌ها jukebox",
"Default ordering for album listing" => "ترتيب پيش‌فرض براي فهرست كردن آلبوم‌ها",
"Album title (asc)" => "تيتر آلبوم(صعودي)",
"Number of tracks (desc)" => "تعداد آثار(tracks) (نزولي)",
"In album listing show user as" => "در فهرست آلبوم‌ها، كاربر را با اين عنوان نشان بده",
"Jukebox listing configuration (when listing available albums)" => "پيكربندي فهرست جوك‌باكس (هنگامي كه آلبوم‌هاي موجود فهرست مي‌شوند)",
"Tracks" => "Trackها",
"Genre" => "قسم",
"Create a group for each user <br />(with the same\nname as the user)" => "براي هر كاربر، يك گروه همنام خودش بساز",
"Validate email address (may not work)" => "آدرس پست الكترونيكي را تاييد اعتبار كن(ممكن است كار نكند)",
"Remind passwords by email" => "كلمه‌ي عبور را به كمك پست الكترونيكي يادآوري كن",
"Require HTTP Basic authentication" => "نياز به تصديق هويت ابتدايي HTTP است",
"HTTP server name" => "نام خدمت رسان HTTP",
"HTTP URL prefix" => "پيشوند آدرس URL مربوط به HTTP",
"HTTPS server name" => "نام خدمت‌رسان HTTPS",
"HTTPS URL prefix" => " پيشوند آدرس URL مربوط به HTTPS ",
"Only for users" => "تنها براي كاربران",
"Users and admins" => "كاربران و مديران",
"to add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "براي حذف/اضافه كردن 'راي‌گيري‌ها'، دنبال \"راي‌گيري‌ها\" تحت بخش \"مديريت\" در منوي برنامه برويد، يا",
"Poll settings" => "تنظيمات راي‌گيري‌ها",
"Users choose project categories" => "كاربران طبقات پروژه را انتخاب مي‌كنند",
"Prefix for Project Admin groups" => "پيشوند براي گروه‌هاي مديريت پروژه",
"Prefix for Project groups" => "پيشوند براي گروه‌هاي پروژه",
"Prefix for Wiki project home page" => "پيشوند براي صفحه‌ي مبدا پروژه‌ي ويكي",
"Prefix for File Galleries" => "پيشنود براي سرسراهاي پرونده",
"Project Admins group template" => "الگوي گروه‌هاي مديريت پروژه",
"Create New Group" => "ساخت گروه جديد",
"Project Members group template" => "الگوي گروه‌هاي اعضاي پروژه",
"<b>Title</b>" => "<b>عنوان</b>",
"<b>Description</b>" => "<b>شرح</b>",
"Append CSS file to feed urls" => "پرونده‌هاي CSS را به URLهاي تغذيه، اضافه كن",
"Publisher" => "ناشر",
"you can see users rank by score in the module users_rank, for that go to" => "مي‌توانيد رتبه‌ي كاربران را امتياز آن‌ها در ماژول users_rank ببينيد، براي اين‌كار به اين‌جا مراجعه كنيد",
"Full Text Search" => "جستجوي متني كامل",
"Dont forget to use feature you will need to enable it on the <a href=\"tiki-admin.php?page=features\">Features</a> icon." => "فراموش نكنيد كه از اين خصيصيه استفاده كنيد، بايد آن را در  <a href=\"tiki-admin.php?page=features\">خصيصه‌ها</a> فعال كنيد.",
"Site Identity Settings" => "تنظيمات هويت پايگاه",
"Site logo" => "نماد پايگاه",
"Site logo source" => "آدرس پرونده‌ي نماد پايگاه",
"Site ads and banners" => "درفش‌ها و تنليغات پايگاه",
"to configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "براي پيكربندي trackerهاي خود، به دنبال \"مديريت trackerها\" تحت \"trackerها\" در منوي برنامه بگرديد، يا",
"Manage attachment preferences" => "مديريت تنظيمات ضمايم",
"Wiki page list configuration" => "پيكربندي فهرست صفحات ويكي",
"HTML in Wiki Pages" => "HTML در صفحات ويكي",
"Like pages" => "پيوند صفحات",
"Enable Feature" => "فعال باشد",
"admin banning tpl" => "الگوي مديريت تحريم‌ها",
"List Calendars" => "فهرست تقويم‌ها",
"loc" => "مكان",
"cat" => "طبقه",
"lang" => "زبان",
"prio" => "اولويت",
"event" => "رويداد",
"perso" => "شخصي",
"permissions" => "دسترسي‌ها",
"Custom Events" => "رويدادهاي متناسب",
"admin categories" => "مديريت طبقه‌بندي‌ها",
"admin categories tpl" => "الگوي مديريت طبقه‌بندي‌ها",
"create new" => "ساخت جديد",
"edit chart" => "ويرايش نمودار",
"update" => "به‌روز رساني كن",
"admin charts template" => "مديريت الگوي نمودارها",
"admin content templates" => "مديريت الگوهاي محتوي",
"admin content templates template" => "مديريت الگوي 'اگوهاي محتوي'",
"use in cms" => "استفاده در سامانه‌ي مديريت محتوا",
"use in wiki" => "استفاده در ويكي",
"use in newsletters" => "استفاده در خبرنامه‌ها؟",
"use in events" => "استفاده در رويدادها؟",
"use in HTML pages" => "استفاده در اين صفحات HTML",
"last modif" => "تاريخ آخرين تغيير",
"sections" => "بخش‌ها",
"admin FortuneCookie" => "مديريت كوكي بخت",
"admin FortuneCookie tpl" => "الگوي مديريت كوكي بخت",
"upload" => "بارگذاري",
"admin Drawings" => "مديريت نقاشي‌ها",
"admin Drawings tpl" => "الگوي مديريت نقاشي‌ها",
"dsn" => "dsn",
"Admin event subscriptions" => "مديريت عضويت رويدادها",
"list events" => "فهرست رويدادها",
"admin events" => "مديريت رويدادها",
"send events" => "ارسال رويدادها",
"Add a subscription event" => "افزودن به عضويت رويدادها",
"Add all your site users to this event (broadcast)" => "تمام كاربران پايگاه خود را به اين رويداد اضافه كنيد (خبرگزاي)",
"Add all users" => "اضافه كردن تمام كاربران",
"fname" => "نام كوچك",
"lname" => "نام خانوادگي",
"company" => "شركت",
"admin events template" => "مديريت الگوي رويدادها",
"Create/edit events" => "ايجاد/ويرايش رويدادها",
"There are individual permissions set for this event" => "حقوق دسترسي فردي براي اين رويداد تنظيم شده است",
"Add unsubscribe instructions to each event" => "اطلاعات مربوط به لغو عضويت را به تمام رويدادها اضافه كن",
"editions" => "نسخه‌ها",
"last sent" => "آخرين ارسال",
"send event" => "ارسال رويداد",
"admin External Wikis" => "سرپرستي ويكي‌هاي خارجي",
"extwiki" => "ويكي خارجي",
"admin forums template" => "مديريت الگوي انجمن‌ها",
"Edit existing forums" => "ويرايش انجمن‌هاي كنوني",
"flag" => "پرچم",
"posts" => "الصاق‌ها",
"online" => "روي خط",
"topics" => "عناوين",
"coms" => "نظرات",
"age" => "سن",
"ppd" => "ppd",
"last post" => "آخرين الصاق",
"Assign Permissions (Active)" => "تخصيص حقوق دسترسي (فعال)",
"Click here to delete this forum" => "براي حذف اين انجمن اين‌جا را كليك كنيد",
"admin hotwords" => "مديريت واژگان آتشين",
"admin hotwords template" => "مديريت الگوي واژگان آتشين",
"admin HTML page dynamic zones" => "مديريت قلمرو پوياي صفحات HTML",
"admin Html Pages" => "مديريت صفحات HTML",
"admin Html Pages template" => "مديريت الگوي صفحات HTML",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => " از {literal}{{/literal}ed شناسه=نام} يا {literal}{{/literal}ted شناسه=نام} براي ايجاد قلمروهاي پويا استفاده كنيد",
"list repositories" => "فهرست مخازن",
"new repository" => "مخزن جديد",
"view repository" => "مشاهده‌ي مخزن",
"view this repository" => "مشاهده‌ي اين مخزن",
"new rule" => "قانون جديد",
"admin featured links" => "مديريت پيوندهاي خاص",
"admin featured links template" => "الگوي مديريت پيوندهاي خاص",
"position" => "موقعيت",
"admin Webmail" => "مديريت پست تحت وب",
"admin mailin template" => "مديريت الگوي دريافت پست الكترونيكي",
"section" => "بخش",
"sorted section" => "بخش‌هاي مرتب شده",
"admin menu builder" => "مديريت سازنده‌ي منو",
"admin menus template" => "الگوي مديريت منوها",
"options" => "اختيارات",
"admin modules" => "مديريت ماژول‌ها",
"admin modules template" => "الگوي مديريت ماژول‌ها",
"assign module" => "تخصيص ماژول‌ها",
"left modules" => "ماژول‌هاي سمت چپ",
"right modules" => "ماژول‌هاي سمت راست",
"edit/create" => "ويرايش/ايجاد ",
"clear cache" => "پاك‌سازي حافظه نهان(cache)",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>نكته 1</b>درصورتي كه با كاربران اجازه‌ي پيكربندي ماژول‌ها را بدهيد، آن‌گاه 'ماژول‌هاي تخصيص‌داده شده' در صفحه نمايش داده نخواهد شد، مگر آن‌كه آن‌ها را در 'تيكي من -> ماژول‌ها' پيكربندي كنيد.<br />\n<b>نكته 2</b>: درصورتي كه ماژولي را به گروه خاصي اختصاص مي‌دهيد، به‌خاظر داشته باشيد كه گزينه‌ي 'نمايش همواره‌ي ماژول‌ها به تمام گروه‌ها' را در 'مديريت -> عمومي' غيرفعال كنيد.",
"assign" => "اختصاص بده",
"left" => "راست",
"right" => "چپ",
"parameters" => "پارامترها",
"order" => "ترتيب",
"create/edit" => "ايجاد/حذف",
"use poll" => "از اين راي‌گيري استفاده كن",
"use gallery" => "از اين سرسراها استفاده كن",
"use dynamic  content" => "از محتوي پويا استفاده كن",
"use rss module" => "از اين ماژول RSS استفاده كن",
"use menu" => "از اين فهرست استفاده كن",
"use phplayermenu" => "از اين فهرست لايه‌اي PHP استفاده كن ",
"use banner zone" => "از قلمرو درفش استفاده كن",
"list newsletters" => "فهرست خبرنامه‌ها",
"admin newsletters" => "مديريت خبرنامه‌ها",
"send newsletters" => "ارسال خبرنامه‌ها",
"admin newsletters template" => "مديريت الگوي خبرنامه‌ها",
"send newsletter" => "خبرنامه را بفرست",
"admin Email Notifications" => "مديريت اطلاع‌رساني‌هاي پست الكترونيكي",
"admin notifications template" => "مديريت الگوي اطلاع‌رساني‌ها",
"use admin email" => "از پست الكترونيك سرپرست استفاده كن",
"admin polls" => "مديريت راي‌گيري‌ها",
"admin polls template" => "مديريت الگوي راي‌گيري‌ها",
"admin QuickTags" => " مديريت تگ‌هاي سريع ",
"label" => "برچسب",
"Category: wiki, tracker, etc." => "طبقه: ويكي، tracker، ساير",
"admin RSS Modules" => "مديريت ماژول RSS",
"admin RSSmodules template" => "مديريت الگوي ماژول RSS",
"edit tpl" => "ويرايش الگو",
"admin shoutbox words" => "مديريت كلمات فريادگاه",
"admin shoutbox words template" => "الگوي مديريت كلمات فريادگاه",
"admin structures template" => "سرپرستي الگوي ساختارها",
"export pages" => "صدور صفحه",
"dump tree" => "dumpكردن درختواره",
"create webhelp" => "ساخت كمك وبي",
"view webhelp" => "مشاهده‌ي كمك وبي",
"tree" => "درختواره",
"create new structure" => "ايجاد ساختار جديد",
"survey stats" => "آمار نظرسنجي‌",
"edit this survey" => "ويرايش اين نظرسنجي‌",
"admin surveys" => "مديريت نظرسنجي‌ها",
"list surveys" => "فهرست نظرسنجي‌ها",
"questions" => "سئوالات",
"files" => "پرونده",
"admin topics template" => "الگوي مديريت عناوين",
"Field is public? (for use thru trackerlist plugin)" => "ستون عمومي است؟ (براي استفاده در pluginهاي trackerها)",
"admin Trackers tpl" => "مديريت الگوي trackerها",
"Edit fields for tracker" => "ويرايش ستون‌هاي trackerها",
"items" => "اقلام",
"version" => "نسخه",
"admin groups" => "مديريت گروه‌هاي كاربري",
"admin groups template" => "الگوي مديريت گروه‌هاي كاربري",
"assign permissions" => "تخصيص حقوق دسترسي به ",
"admin" => "مديريت تقويم‌ها",
"admin users" => "مديريت كاربران",
"admin users template" => "الگوي مديريت كاربران",
"edit account settings" => "ويرايش تنظيمات حساب كاربر",
"assign to groups" => "انتصاب به گروه‌ها",
"Added users" => "كاربران اضافه شده",
"edit article tpl" => "الگوي ويرايش مقالات",
"all" => "همه موارد",
"Assign user" => "تخصيص كاربر",
"Available groups" => "گروه‌هاي موجود",
"assign perms to this group" => "حقوق دسترسي اختصاص يافته به اين گروه",
"save_to" => "to",
"admin backups" => "مديريت نسخ پشتيبان",
"admin admin tpl" => "مديريت الگوي مديريت",
"List of available backups" => "فهرست نسخ پشتيبان موجود",
"Restoring a backup" => "بازيابي يك نسخه‌ي پشتيبان",
"Warning!" => "اخطار!",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "بازيابي يك نسخه‌ي پشتيبان، تمام اطلاعات بانك اطلاعاتي تيكي شما را نابود خواهد كرد. تمام جداول شما با اطلاعات موجود در نسخه‌ي پشتيبان جايگزين خواهند شد",
"Click here to confirm restoring" => "براي تاييد بازيابي نسخه‌ي پشتيبان، اين‌جا را كليك كنيد",
"Create new backup" => "تهيه‌ي يك نسخه‌ي پشتيبان جديد",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "تهيه‌ي نسخ پشتيبان ممكن است مدت زمان زيادي به طول انجامد. اگر فرايند تكميل نشود، شما يك صفحه‌ي خالي مشاهده خالي كرد. بهتر از حداكثر زمان اجراي دستخط(script)ها را در پرونده‌ي php.ini خود بالا ببريد.",
"Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP." => "منبع ذخيره‌ي سراسري تصاوير شما بر روي  \"{\$gal_use_dir}\", تنظيم شده است. بايد از ظريق FTP يا SCP از آن پشتيبان تهيه كنيد",
"Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP." => "منبع ذخيره‌ي سراسري پرونده‌ي شما بر روي  \"{\$fgal_use_dir}\", تنظيم شده است. بايد از ظريق FTP يا SCP از آن پشتيبان تهيه كنيد",
"If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP." => "درصورتي كه انجمن‌هاي شما پرونده‌هايي خارج از بانك اطلاعاتي دارند، بايد از آن‌ها به كمك FTP با SCP به‌صورت جداگانه پشتيبان تهيه كنيد.",
"Upload a backup" => "بارگذاري يك نسخه‌ي پشتيبان",
"Upload backup" => "بارگذاري نسخ پشتيبان",
"view blog" => "مشاهده‌ي بلاگ",
"list blogs" => "فهرست بلاگ‌ها",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor" => "نكته: براي استفاده از تصاوير، لطفا متن خود را الصاق كنيد تا قادر به ايجاد/ويرايش تصاوير شويد. از &lt;img&gt براي قرار دادن تصوير در متن نوشته شده‌ي خود و يا از URL تصوير براي افزودن تصاوير در ` WYSIWYG استفاده كنيد.",
"save and exit" => "ذخيره كن و خارج شو",
"admin category" => "مديريت طبقه",
"search category" => "طبقه را بگرد",
"deep" => "عميق",
"edit gallery" => "ويرايش سرسرا",
"rebuild thumbnails" => "تصويرك‌ها را مجددا بساز",
"upload image" => "بارگذاري تصوير",
"list gallery" => "نمايش اقلام",
"hit" => "ضربه(hit)",
"original size" => "اندازه‌ي سازمان",
"return to gallery" => "بازگشت به سرسرا",
"edit image" => "ويرايش تصوير",
"smaller" => "كوچكتر",
"bigger" => "بزرگتر",
"prev image" => "تصوير قبلي",
"next image" => "تصوير بعدي",
"popup window" => "پنجره‌ي popup",
"add item" => "افزودن فقره",
"or create a new category" => "يا يك طبقه‌ي جديد ايجاد كنيد",
"or create a new location" => "يا يك محل جديد ايجاد كنيد",
"comma separated usernames" => "نام‌هاي كاربر(جداشده به‌وسيله‌ي كاما)",
"comma separated username:role" => "نام‌هاي كاربر(جداشده به‌وسيله‌ي كاما): قانون",
"with roles" => "؛با قوانين",
"Chair" => "مقر",
"Optional" => "اختياري",
"Format: mm/dd/yyyy hh:mm<br />...See strtotime php function" => "شكل: mm/dd/yyyy hh:mm<br />...تابع strtotime php را ببينيد",
"Format: mm/dd/yyy hh:mm" => "شكل: mm/dd/yyy hh:mm",
"Event ID" => "شناسه‌ي رويداد",
"Add Calendar Item" => "افزوردن فقره در تقويم",
"Calendrier" => "تقويم‌وار!",
"permission" => "حقوق دسترسي",
"remove from this category &amp; all its children" => "از اين طبقه و طبقات فرزندش حذف كن",
"remove from this category only" => "تنها از اين طبقه حذفش كن",
"Textheight" => "ارتفاع متن",
"Height of top Heading" => "ارتفاع سرصفحه‌ي بالايي",
"Height of mid Heading" => "ارتفاع سرصفحه‌ي وسطي",
"Height of inner Heading" => "ارتفاع سرصفحه‌ي مياني",
"tbheight" => "ارتفاع جدول",
"imagescale" => "مقياس تصوير",
"Automatic Page Breaks" => "جدا كردن خودكار صفحات",
"remove page" => "صفحه را حذف كن",
"admin directory tpl" => "الگوي مديريت پوشه",
"browse" => "مرور",
"related" => "مرتبط",
"validate" => "تاييد",
"admin directory categories tpl" => "الگوي مديريت طبقات پوشه",
"add a site" => "اضافه كردن يك پاگاه",
"search" => "جستجو",
"list articles" => "فهرست مقالات",
"view articles" => "مشاهده‌ي مقالات",
"create zone" => "ايجاد قلمرو",
"save the banner" => "درفش را ذخيره كن",
"edit blog tpl" => "ويرايش الگوي بلاگ",
"try" => "تلاش",
"display" => "نمايش",
"wiki help" => "كمك از ويكي",
"For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>" => "براي اطلاعات بيشتر، لطفا نگاهي به <a href=\"{\$helpurl}WikiSyntax\">نحو ويكي</a> بياندازيد",
"Emphasis" => "تاكيد",
"italics" => "مورب",
"both" => "هردو",
"use ...page... to separate pages" => "از ...page... براي جاسازس صفحات استفاده كن",
"make_headings" => "ساخت سرصفحه‌ها",
"underlines text" => "متن را زيرخط دار كن",
"make a line break" => "يك خط افقي بكش",
"creates an editable drawing named foo" => "يك نقاشي قابل ويرايش با نام foo بساز",
"Simple box" => "جعبه‌ي ساده",
"Will display using the indicated HTML color" => "با كمك رنگ مشخص شده‌ي HTML نمايش داده مي‌شود",
"Will display the text centered" => "متن را در مركز نمايش خواهد داد",
"Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done)." => "كد/متن‌هاي از پيش شكل گرفته را نمايش بده. هيچ پردازشي توسط ويكي داخل اين بخش انجام نخواهد شد.",
"Insert Module Output" => "درج خروجي ماژول",
"{literal}{MODULE(module=>some_module)}text{MODULE}{/literal}  can be used to insert the output of module \"some_module\" into your Wiki page. See <a href=\"{\$helpurl}PluginModule\">PluginModule</a> for more information. " => "{literal}{MODULE(module=>يك ماژول)}متن{MODULE}{/literal} مي‌تواند براي درج خروجي ماژول \"يك ماژول\" در صفحه‌ي ويكي شما استفاده شود. براي اطلاعات بيشتر، <a href=\"{\$helpurl}PluginModule\">PluginModule</a> را ببينيد.",
"Rendering Program Code" => "ترجمه‌ي كد برنامه",
"{literal}{CODE()}some code{CODE} {/literal} will render \"some code\" as program code. This plugin has other options; see <a href=\"{\$helpurl}PluginCode\">PluginCode</a>." => "{literal}{CODE()}يك‌سري كد{CODE} {/literal}، \"يك‌سري كد\" را به عنوان برنامه ترجمه خواهند كرد. اين Plugin  اختيارات ديگري نيز دارد؛ <a href=\"{\$helpurl}PluginCode\">كد Plugin</a> را ببينيد.",
"admin quicktags" => "مديريت تگ‌هاي سريع",
"create new block" => "يك بلوك جديد ايجاد كن",
"Project Object Created Successfully" => "شيء پروژه با موفقيت ساخته شد",
"Project Name:" => "نام پروژه:",
"Project Description:" => "توضيحات پروژه",
"Project Active" => "پروژه فعال است",
"Current Objects:" => "اشياء جاري:",
"Add a File Gallery" => "افزودن يك سرسراي پرونده",
"Project Admin" => "مدير پروژه",
"Project Members" => "اعضاي پروژه",
"Not Set" => "تنظيم نشده است",
"list quizzes" => "فهرست آزمون‌ها",
"quiz stats" => "وضعيت آزمون",
"edit this quiz" => "اين آزمون را ويرايش كن",
"admin quizzes" => "مديريت آزمون‌ها",
"admin quizzes tpl" => "الگوي مديريت آزمون‌ها",
"results" => "نتايج",
"edit quiz questions" => "سئوالات آزمون را ويرايش كن",
"edit quiz questions tpl" => "الگوي ويرايش سئوالات آزمون",
"create page" => "ساخت صفحه",
"Edit Submissions" => "ويرايش ارائه‌ها",
"edit submissions tpl" => "الگوي ويرايش ارائه‌ها",
"list submissions" => "فهرست ارائه‌ها",
"<b>زيرنويس</b>=small line below Title" => "<b>Subtitle</b>=خط كوچك بايين تيتر",
"edit translations" => "ويرايش ترجمه‌ها",
"edit translations template" => "الگوي ويرايش ترجمه‌ها",
"add to the set" => "افزودن به مجموعه",
"Admin ephemerides" => "مديريت سالنامه‌ها",
"admin Ephemerides tpl" => "مديريت الگوي سالنامه‌ها",
"All ephemerides" => "تمام سالنامه‌ها",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No events will be sent to you until the subscription is confirmed." => "از عضويت شما متشكريم. به‌زودي براي تاييد عضويت خود يك پيام دريافت خواهيد كرد. تا زماني كه عضوت را تاييد نكرده‌اي، هيچ رويدادي براي شما ارسال نخواهد شد.",
"Subscribe to event" => "عضويت در رويداد",
"First Name:" => "نام:",
"Last Name:" => "نام خانوادگي:",
"Company:" => "سازمان:",
"new question" => "سئوال جديد",
"approve" => "تاييد",
"configure listing" => "پيكربندي فهرست‌ها",
"create new gallery" => "ايجاد سرسراي جديد",
"topic" => "موضوع",
"save and approve" => "ذخيره و تاييد",
"new topic" => "عنوان جديد",
"reject" => "مردود",
"visits" => "بازديدها",
"create new user" => "ايجاد كاربر جديد",
"accept" => "قبول مي‌كنم",
"refuse" => "رد مي‌كنم",
"switch" => "گزينه",
"add new" => "جديد",
"add role" => "قانون را اضافه كن",
"new minor" => "كهاد جديد",
"new major" => "مهاد جديد",
"admin processes" => "مديريت فرايندها",
"admin activities" => "مديريت فعاليت‌ها",
"admin roles" => "مديريت قوانين",
"edit this process" => "اين فرايند را ويرايش كن",
"monitor" => "ديده‌باني",
"Activs" => "فعال",
"Ins" => "درج",
"time" => "زمان",
"send instance" => "نمونه را ارسال كن",
"stop" => "توقف",
"Wiki quick help" => "كمك سريع ويكي",
"Quicklinks" => "پيوندهاي سريع",
"Last Edit:" => "آخرين ويرايش",
"Grade Paper" => "كاغذ درجه‌بندي",
"Due Date:" => "تاريخ انجام",
"Comparing versions" => "مقايسه‌ي نسخ",
"Actual_version" => "نسخه‌ي واقعي",
"Diff to version" => "متفاوت از نسخه‌ي",
"source" => "منبع",
"Assignments List" => "فهرست منصوبات",
"My Work" => "كارهاي من",
"Assignment" => "منصوبات",
"Due Date" => "تاريخ انجام",
"Grading Queue " => "صف درجه‌بندي ",
"paper" => "كاغذ",
"papers" => "كاغذ",
"Edit Assignment" => "ويرايش منصوبات",
"list assignments" => "فهرست منصوبات",
"Due" => "مقرر",
"create assignment" => "ايجاد منصوبات",
"Import A PHPBB Dump" => "يك PHPBB Dump وارد كن",
"tiki-import_phpbb tpl" => "الگوي واردات PHP تيكي",
"Name of the SQL dump file (relative to\ntiki basedir, e.g. dump/phpbb_db_backup.sql )" => "نام پرونده‌ي SQL Dump (نسبت به پوشه‌ي منبع تيكي، مثلا: dump/phpbb_db_backup.sql)",
"Overwrite existing threads if the name is\nthe same" => "درصورتي كه رگه‌اي با همين نام وجود دارد، روي آن بنويس",
"Excerpt" => "گلچين كردن",
"result" => "نتيجه",
"edit repository" => "مخزن را ويرايش كن",
"list articles tpl" => "الگوي فهرست مقالات",
"edit new article" => "ويرايش مقاله‌ي جديد",
"admin Banners" => "مديريت درفش‌ها",
"admin Banners tpl" => "الگوي مديريت درفش‌ها",
"create new blog" => "يك بلاگ جديد ايجاد كن",
"admin cache" => "مديريت Cache",
"admin cache tpl" => "الگوي مديريت Cashe",
"admin DynamicContent" => "مديريت محتوي پويا",
"admin DynamicContent tpl" => "الگوي مديريت محتوي پويا",
"list faqs tpl" => "الگوي فهرست سئوالات متداول",
"upload file" => "بارگذاري پرونده",
"Edit a file using this form" => "با استفاده از اين فرم، يك پرونده را ويرايش كن",
"delete selected files" => "پرونده‌هاي انتخاب شده را حذف كن",
"browse gallery" => "مرور سرسرا",
"Flash binary (.sqf or .dcr)" => "فلاش‌هاي دودويي (.sqf or .dcr)",
"list posts tpl" => "الگوي فهرست الصاق‌ها",
"edit blog" => "ويرايش بلاگ",
"Number Members" => "تعداد اعضا",
"Number Admins" => "تعداد مديران",
"No projects found" => "پروژه‌اي پيدا نشد.",
"list quizzes tpl" => "الگوي فهرست آزمون‌ها",
"edit new submission" => "ويرايش ارائه‌ي جديد",
"edit quiz stats tpl" => "ويرايش الگوي آمار آزمون",
"actions" => "اعمال",
"take survey" => "به اجرا گذاشتن",
"adm" => "مديريت",
"list trackers tpl" => "الگوي فهرست trackerها",
"admin live support tpl" => "الگوي مديريت پشتيباني زنده",
"set as operator" => "به عنوان پشتيبان قرارش بده",
"add topic" => "افزودن موضوع",
"install" => "نصب",
"The newsletter was sent to {\$edition.users} email addresses" => "خبرنامه به اين آدرس‌هاي الكترونيكي ارسال شد: {\$edition.users}",
"wiki create" => "ساخت ويكي",
"wiki overwrite" => "نوشتن ويكي(جايگزيني روي قبلي‌ها)",
"back" => "بازگشت",
"Assign permissions to page" => " تخصيص حقوق دسترسي به صفحه‌ي",
"Current permissions for this page" => "حقوق دسترسي كنوني براي اين صفحه",
"remove from this page" => "از اين صفحه حذفش كن",
"remove from this structure" => "از اين ساختار حذف كن",
"No individual permissions; category or global permissions apply" => "حقوق دسترسي فردي تنظيم نشده است، دسترسي‌هاي طبقه يا دسترسي‌هاي عمومي اعمال خواهند شد.",
"this page" => "اين صفحه",
"this structure" => "اين ساختار",
"Current permissions for categories that this page belongs to" => "دسترسي‌هاي جاري براي طبقه‌هايي كه اين صفحه به آن‌ها تعلق دارد",
"Send email notifications when this page changes to" => "هنگامي كه اين صفحه تغيير مي‌كند، به اين آدرس‌ها پست الكترونيكي بفرست",
"add email" => "آدرس پست الكترونيكي",
"Notifications" => "آگاه‌سازي‌ها",
"view comments" => "مشاهده‌ي نظرها",
"clear" => "پاك كن",
"Project Created:" => "پروژه ساخته شده:",
"Project Info" => "اطلاعات پروژه",
"Project Admins:" => "مديريت پروژه:",
"Project Members:" => "اعضاي پروژه:",
"Edit Project" => "ويرايش پروژه",
"Add Blog" => "افزودن بلاگ",
"Add Articles" => "افزودن مقاله",
"Add Calendar" => "افزودن تقويم",
"Add FAQ" => "افزودن FAQ",
"Add File Gallery" => "افزودن سرسراي پرونده",
"Add Forum" => "افزودن انجمن",
"Add Image Gallery" => "افزودن سرسراي تصوير",
"Add Newsletter" => "افزودن خبرنامه",
"Add URL" => "افزودن URL",
"Project Registration" => "ثبت‌نام",
"Your project was successfully submitted.  It may be subject\nto approval. Once available, you can create/link your project objects\nto your project page." => "پروژه‌ي شما با موفقيت ارائه شد. بايد در معرض تصويب قرار بگيرد. هنگامي كه تاييد شد مي‌توانيد در صفحه‌ي پروژه‌ي خود اشياء پروژه را بسازيد و براي آن‌ها پيوند ايجاد كنيد",
"List all projects" => "فهرست تمام پروژه‌ها",
"Take care when you register your project, the project name\ncannot be changed afterwards. Please also provide an accurate \nproject description. If you havent worked out these details please\ndo so before your register the project." => "هنگامي كه پروژه‌ي خود را ثبت مي‌كنيد، مراقب باشيد، نام پروژه پس از ثبت نمي‌تواند تغيير كند. اگر هنوز در خصوص آن تصميم نگرفته‌ايد، قبل از ثبت پروژه ترتيب آن را بدهيد.",
"Please choose your project categories carefully. You can\nhowever change this later on your project admin panel." => "لطفا طبقات پروژه‌ي خود را با دقت انتخاب كنيد. هرچند مي‌توانيد در بخش مديريت پروژه آن‌ها را تغيير دهيد.",
"All project names are converted to lowercase." => "نام تمام پروژه‌ها به حروف كوچك تبديل خواهد شد.",
"clear stats" => "آمار را پاك كن",
"Communcation Center" => "مركز ارتباطات",
"Edit received page" => "ويرايش صفحات دريافت شده",
"admin Referer stats" => "آمار مراجعات به سرپرست",
"admin Referer stats tpl" => "الگوي آمار مراجعات به سرپرست",
"last" => "آخرين بار",
"send me my password" => "براي من كلمه‌ي عبورم را ارسال كن",
"searched" => "جستجو شد",
"galleries" => "سرسراها",
"images" => "تصاوير",
"blog posts" => "الصاق‌هاي بلاگ",
"The event was sent to {\$sent} email addresses" => "اين رويداد براي آدرس‌هاي پست الكترونيكي {\$sent} ارسال شد",
"This event will be sent to {\$subscribers} email addresses." => "اين رويداد براي آدرس‌هاي پست الكترونيكي {\$subscribers} ارسال خواهد شد",
"Prepare a event to be sent" => "آماده‌سازي يك رويداد براي ارسال",
"Send Events" => "رويداد را بفرست",
"admin send objects tpl" => "الگوي مديريت ارسال اشياء",
"site" => "نام پايگاه",
"path" => "مسير",
"add article" => "مقاله را اضافه كن",
"create new sheet" => "ساخت ورق جديد",
"admin Tiki Shoutbox" => "مديريت فريادگاه تيكي",
"admin Tiki Shoutbox tpl" => "الگوي مديريت فريادگاه تيكي",
"Search : " => "جستجو:",
"first" => "اولين",
"send answers" => "پاسخ‌ها را ارسال كن",
"{if \$editFileId}Edit File: {\$fileInfo.filename}{else}Upload File{/if}" => "{if \$editFileId}ويرايش پرونده‌ي: {\$fileInfo.filename}{else}بارگذاري پرونده{/if}",
"move to right column" => "انتقال به ستون چپ",
"unassign" => "حذف",
"move to left column" => "انتقال به ستون راست",
"remove folder" => "پوشه را حذف كنت",
"refresh cache" => "بازيابي cache",
"General preferences" => "تنظيمات عمومي",
"Other preferences" => "ساير تنظيمات",
"HomePage" => "صفحه‌ي مبدا",
"Edit information" => "ويرايش اطلاعات",
"Change information" => "تغيير اطلاعات",
"empty trash" => "تخليه‌ي خاكرويه",
"remove from trash" => "از خاكروبه هم حذفش كن",
"Maked as deleted" => "با عنوان حذف شده علامت بخورند",
"reload" => "باركردن مجدد",
"trash" => "خاكروبه",
"edit user files" => "ويرايش پرونده‌هاي كاربر",
"no comments" => "بدون شرح",
"stop monitoring this blog" => "ديده‌باني اين بلاگ را متوقف كن",
"edit items" => "ويرايش اقلام",
"list charts" => "فهرست نمودارها",
"last chart" => "آخرين نمودار",
"perm" => "قطعيت",
"item" => "قلم",
"view faq" => "مشاهده‌ي FAQ",
"view faq tpl" => "الگوي مشاهده‌ي FAQ",
"admin menus tpl" => "الگوي مديريت منوها",
"add suggestion" => "افزودن پيشنهاد",
"monitor this forum" => "اين انجمن را ديده‌باني كن",
"stop monitoring this forum" => "ديده‌باني اين انجمن را متوقف كن",
"delete selected topics" => "عناوين منتخب را حذف كن",
"topics in this forum" => "عناوين اين انجمن",
"stop monitoring this topic" => "ديده‌باني اين عنوان با متوقف كن",
"Comments below your current threshold" => "نظرات پايين‌تر از حد آستانه‌ي شما",
"list attachments" => "فهرست ضمايم",
"Editing tracker item" => "ويرايش فقره tracker",
"Not rated yet" => "هنوز رتبه‌بندي نشده است.",
"add contacts" => "افزودن گيرنده",
"No event indicated" => "هيچ رويداد مشخص نشده است.",
"This is not a Tikiwiki File. Check if this file was uploaded and if it is dangerous." => "اين يك پرونده‌ي تيك ويكي نيست. بررسي كنيد كه آيا پرونده بارگزاي شده است يا خير و اين‌كه خطرناك نباشد.",
"This file is modified." => "اين پرونده تغيير كرده است.",
"The passwords dont match" => "كلمه‌ي عبور با تكرارش همخواني ندارد",
"Removed %s from group %s" => "%s از %s حذف شد",
"The passwords didn't match" => "كلمه‌ي عبور هم‌خواني ندارد",
"No project reference assigned" => "هيچ ارجاع پروژه‌اي منصوب نشده است",
"File Gallery successfully added to the project." => "سرسراي پرونده با موفقيت به پروژه اضافه شد.",
"You do not have permission to write the template" => "متاسفانه شما حقوق دسترسي كافي براي نوشتن الگو نداريد",
"You cannot edit this page because it is a user personal page" => "از آن‌جايي كه اين صفحه، يك صفحه‌ي شخصي كاربر است، شما نمي‌توانيد اين صفحه را ويرايش كنيد",
"You must be logged in to subscribe to events" => "براي عضويت در رويدادها بايد ابتدا وارد سامانه شويد.",
"Go to your <a href=\"tiki-friends.php\">friendship network</a> to accept or refuse this request" => "براي پذيرش يا رد كردن اين درخواست به <a href=\"tiki-friends.php\">شبكه‌ي رفاقت خود</a> برويد.",
"Frienship request sent to %s" => "درخواست رفاقت براي %s ارسال شد",
"Individual Order" => "ترتيب فردي",
"You must be a student to edit homework pages." => "براي ويرايش صفحات مشق شب، شما بايد دانش‌آموز باشيد",
"No assignment indicated" => "هيچ انتصابي مشخصي نشده است.",
"Error: Invalid id for hw_pages table." => "خطا: شناسه‌ي نامعتبر براي جدول hw_pages.",
"Error: This page is being edited by another user." => "خطا: كاربر ديگري در حال ويرياش اين صفحه است",
"Permission denied: Students may only view or edit their own work." => "دسترسي ممنوع است: دانش‌آموزان تنها مي‌توانند تكاليف خود را مشاهده يا ويرايش كنند",
"Error: Assignment not found." => "خطا: انتصاب يافت نشد.",
"Permission denied: Students may NOT edit their work after the due date." => "دسترسي ممنوع است: دانش‌آموزان نمي‌توانند تكاليف خود را پس از تاريخ انجام تغيير دهند",
"Permission denied: The teacher must wait until the due date to edit students' work." => "دسترسي ممنوع است: معلم بايد تا پايان زمان انجام تكليف صبر كند تا بتواند كار دانش‌آموزان را ويرايش كنيد",
"No entries available yet!" => "هنوز هيچ فقره‌اي ثبت نشده است!",
"Permission denied: you must be a teacher to access this page." => "دسترسي ممنوع است: براي دسترسي به اين صفحه بايد معلم باشيد",
"Error: No assignment indicated." => "خطا: هيچ انتصابي يافت نشد",
"Error: assignment not found." => "خطا: انتصاب يافت نشد",
"You must be a student to view this page." => "براي مشاهده‌ي اين صفحه، شما بايد يك دانش‌آموز باشيد",
" is not a student." => " يك دانش‌آموزي نيست",
"specified." => "مشخص شده است.",
"Assignment not found" => "انتصاب پيدا نشد",
"Anonymous Grader" => "مصحح بي‌نام",
"Anonymous Peer Reviewer" => "مروركننده‌ي همتاي بي‌نام",
"No homework page indicated!" => "هيچ صفحه‌ي مشق شبي مشخص نشده است!",
"Error: Could not fetch page" => "خطا: نمي‌توانيم صفحه را واكشسي كنم",
"You must be a student to view this page!" => "براي ديدن اين صفحه بايد يك دانش‌آموزي باشيد!",
"Students may only view their own work!" => "دانش‌آموزيين تنها مي‌توانند كار خود را ببينند!",
"This function is deprecated in favor of the improved quizzes outside of the Homework feature." => "اين تابع باتوجه به آزمون‌هاي بهبوديافته‌ي خارج از خصيصه‌ي مشق شب، منسوخ شده است",
"Permission denied: You cannot rollback this page." => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد اين صفحه را به حالت قبل برگردانيد.",
"No hw page indicated" => "هيچ صفحه‌ي مشق شبي مشخص نشده است.",
"Error: nonexistant version specified." => "خطا: نسخه‌ي مشخص شده وجود ندارد.",
"Error: Could not fetch assignment " => "خطا: نمي‌توانم انتصاب را واكشي كنم ",
"You must be a student to view homework assignments." => "براي مشاهده‌ي انتصابات مشق شب بايد يك دانش‌آموز باشيد.",
"Permission denied you must be a student to view assignments." => "دسترسي ممنوع است: شما بايد يك دانش‌آموزي باشيد تا بتوانيد انتصاب‌ها را مشاهده كنيد",
"You must be a teacher or grader to access this page." => "براي دسترسي به اين صفحه، شما بايد يك معلم يا مصحح باشيد",
"Permission denied: You must be a teacher to edit assignments." => "دسترسي ممنوع است: براي ويرايش انتصابات شما بايد يك معلم باشيد.",
" error: Can not find assignment " => " خطا: نتوانستم پيدا كنم: ",
"updated by the phpbb import process" => "به‌روز رساني شده توسط فرايند واردات phpbb",
"created from phpbb import" => "ساخت شده از واردات phpbb",
"You dont have permission to use this feature" => "متاسفانه شما حقوق دسترسي كافي براي استفاده از اين خصيصه را نداريد",
"Sorry, \"\$page\" has not been created." => "متاسفم، صفحه‌ي  \"\$page\" ايجاد نشد هاست",
"Permission denied you cannot assign permissions for this page" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد براي اين صفحه تخصيص حقوق دسترسي كنيد",
"You must provide a project name" => "بايد يك نام براي پروژه فراهم كنيد",
"You must provide a project description" => "بايد يك توضيح براي پروژه فراهم كنيد",
"A project with that name already exists" => "پروژه‌اي با اين نام قبلا ايجاد شده بود",
"A new password and your IP address has been sent " => "آدرس Ip شما و يك كلمه‌ب عبور جديد ارسال شد",
"Tiki RSS Feed Error Message" => "پيغام‌هاي خطاي تغذيه‌ي RSS تيكي",
"You have to type a searchword" => "شما بايد يك كلمه براي جستجو وارد كنيد",
"Invalid variable value : " => "مقدار متغيير نامعتبر است : ",
"You do not have permission to edit messages" => "متاسفانه شما حقوق دسترسي كافي براي ويرايش پيام‌ها را نداريد",
"Cannot read file" => "نمي‌توانم پرونده را بخوانم",
"File update was succesful" => "پرونده با موفقيت به‌روز رساني شد",
"Permission denied you cannot upload files" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد پرونده‌اي بارگذاري كنيد",
"cannot process upload" => "اشكال در بارگذاري تصوير(cannot process upload)",
"You have to provide a name to the image" => "بايد براي اين تصوير يك نام فراهم كنيد",
"Sorry this problems by writing into the database" => "متاسفانه در نوشتن در بانك اطلاعات با اشكال روبرو شدم",
"forum_post_topic" => "عنوان الصاق انجمن",
"wiki_page_changed" => "صفحه‌ي ويكي تغيير كرده است",
"forum_post_thread" => "رگه‌ي الصاق انجمن",
"Your email address has been removed from the list of addresses monitoring this tracker" => "آدرس پست الكترونيكي شما از فهرست ديده‌بانان اين tracker حذف شد",
"Your email address has been added to the list of addresses monitoring this tracker" => "آدرس پست الكترونيكي شما به فهرست ديده‌بانان اين tracker اضافه شد",
"Cancel monitoring" => "لغو ديده‌باني",
"Your email address has been removed from the list of addresses monitoring this item" => "آدرسي الكترونيكي شما از فهرست ديده‌بانان اين فقره حذف شد",
"Your email address has been added to the list of addresses monitoring this item" => "آدرس پست الكترونيكي شما به فهرست ديده‌بانان اين فقره اضافه شد",
"wiki pages" => "صفحات ويكي",
"Allow trackback pings" => "اجازه‌ي pingهاي مسيريابي معكوس را بده(trackback pings)",
"Admin Mods" => "مديريت ماژول‌ها",
"remove users and their userpages" => "كاربران و صفحات آن‌ها را حذف كن",
"structure" => "",
"must be turned on and notification is sent to the admin's" => "بايد روشن باشد، آگاه‌سازها براي سرپرستان ارسال مي‌شود",
"inter-user message inbox" => "صندوق پستي بين كاربري",
"Auth Type" => "گونه‌ي تصديق هويت",
"IMAP/POP3/LDAP Host" => "ميزبان IMAP/POP3/LDAP",
"IMAP/POP3/LDAP Port" => "درگاه IMAP/POP3/LDAP",
"IMAP/POP3 BaseDSN" => "DSN پايه درIMAP/POP3/LDAP",
"Dec" => "دسامبر",
"Nov" => "نوامبر",
"list galleries" => "فهرست سرسراها",
"Enable cache images to all galleries" => "براي تمام سرسراها، نهانگاه(cache) تصاوير فعال باشد",
"Images cache directory" => "پوشه‌ي نهانگاه تصاوير(cache dir)",
"Wiki attachments preferences" => "تنظيمات ضمايم ويكي",
"Wiki syntax used when a page contains HTML" => "نحو ويكي، هنگامي كه صفحه‌اي شامل كدهاي HTML است",
"full" => "كامل",
"partial" => "ناقص",
"Custom Code" => "كد متناسب‌سازي",
"Site breadcrumbs" => "خرده نان فعال باشد",
"Site search bar" => "نوار جستجوي پايگاه",
"Site Menu" => "منو پايگاه",
"Note: This feature also requires phplayers to be turned on in Admin->Features" => " نكته: اين خصيصه نياز به فعال بودن لايه‌هاي PHP يا همان PHPLayers در بخش 'مديريت->خصيصه‌ها' نيز دارد.",
"add a category" => "اضافه كردن يك طبقه",
"The tracker needs a text field named Subject" => "(tracker احتياج به يك رشته‌ي متني به‌نام Subject دارد)",
"n" => "خير",
"list view" => "نمايش فهرستي",
"participants" => "شركت‌كنندگان",
"subscription" => "اشتراك",
"Subscription List" => "فهرست اشتراك",
"Layer Management" => "مديريت لايه‌ها",
"reply to" => "پاسخ داده‌شده",
"admin mode" => "حالت سرپرستي",
"use start date and time" => "از تاريخ و ساعت شروع استفاده كن",
"use end date and time" => "از تاريخ و ساعت پايان استفاده كن",
"use google map locator" => "از نقشه‌ياب گوگل استفاده كن",
"file_galleries" => "سرسراهاي پرونده",
"html_pages" => "صفحات HTML",
"user_messages" => "پيغام‌هاي كاربر",
"mytiki" => "تيكي من",
"surveys" => "نظرسنجي‌ها",
"featured_links" => "پيوندهاي خاص",
"newsreader" => "اخبارگو",
"workflow" => "گردش كار",
"webmail" => "پست تحت وب",
"offline since" => "از اين زمان روي خط نيامده است",
"Jan" => "ژانويه",
"cms" => "سامانه‌ي مديريت محتوا",
"save only in the theme:" => "ذخيره فقط براي قيافه‌ي ",
"currency" => "پول",
"currency_us" => "پول_كانادا",
"currency_ca" => "پول_آمريكا",
"Activity start is interactive so it must use the \$instance->complete() method" => "فعاليت آغاز تعاملي است، لذا بايد بدين شكل باشد: \$instance->complete() method",
"Note: It is not possible to delete an active process. To delete a process, deactivate it first." => "نكته: يك فرايند فعال را نمي‌توانيد حذف كنيد. براي حذف يك فرايند بايد ابتدا آن را غيرفعال سازيد.",
"UserPageadmin" => "مديريت صفحه‌ي كاربر",
"Note: You have to import security data via installation process (tiki-install.php). Import the *secdb* update files in your database" => "نكته: شما بايد داده‌هاي امنيتي را با فرايند نصب وارد كنيد (tiki-install.php). پرونده‌هاي به‌روز رسان *secdb* را به بانك اطلاعات خود وارد كنيد.",
"WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely." => "اخطار: trackerهاي جديد و قديمي، همزمان نمي‌توانند وجود داشته باشند. Trackerهايي كه با كتابخانه‌هاي جديد ساخته مي‌شوند با كتابخانه‌هاي قديمي كار نخواهند كرد، و برعكس.",
"Php GD library required" => "PHP GD مورد نياز است",
"GZIP Disabled" => "GZIP غيرفعال است",
"Exact match" => "دقيقا مانند",
"Tiki initialization" => "آماده‌سازي تيكي",
"Russian Federation" => "روسيه",
"new image uploaded by" => "تصوير جديد، بارگذاري شده به‌وسيله‌ي:",
"new subscriptions" => "اشتراك جديد",
"new item in tracker" => "يك فقره‌ي جديد در tracker",
"show" => "نمايش بده",
"hide" => "مخفي كن",
"Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode." => "اختيارات متني: options,width,height,max Option 0 يا 1 است، widthوheight حجم به حرف و خط هستند و max بيشينه مقدار تعداد حروف است كه مي‌توان ذخيره كرد.",
"Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag" => "اختيارات: 1و2 كه 1 تنها نمايش دهنده‌ي نام كشور و 2 تنها نمايش دهنده‌ي پرچم كشور. به‌صورت پيش‌فرض، هم نام و هم پرچم نمايش داده مي‌شود.",
"message" => "پيغام",
"Include all post in a blog" => "شامل تمام الصاق‌هاي يك بلاگ",
"Include an article" => "شامل يك مقاله",
"no such attachment on this page" => "چنين پميمه‌اي در اين صفحه وجود ندارد",
"select all" => "انتخاب همه",
"filter" => "فيلتر",
"missing fields list" => "فهرست ستون‌ها مفقود است",
"move %s in %s" => "%s را به %s منتقل كن",
"no such file" => "چنين فايلي وجود نداشت",
"downloads" => "دريافت",
"download" => "دريافت",
"attach" => "ضميمه",
"monitor this blog" => "اين بلاگ را ديده‌باني كن",
"hide categories" => "طبقات را مخفي كن",
"Admin categories" => "مديريت طبقات",
"browse category" => "مرور طبقه",
"reply" => "پاسخ",
"monitor this topic" => "اين عنوان را ديده‌باني كن",
"active perms" => "حقوق دسترسي فعال",
"with checked" => "تيك خورده‌ها را...",
"Dls" => "دريافت‌ها",
"move selected files" => "پرونده‌هاي انتخاب شده را منتقل كن",
"Thank you for you registration. You may log in now." => "از ثبت‌نام شما سپاس‌گزاريم. هم‌اكنون شما مي‌توانيم وارد سامانه شويد.",
"Zoom out x4" => "بزرگنمايي 4برابر",
"Zoom out x3" => "بزرگنمايي 3برابر",
"Zoom in x3" => "بزرگنمايي 3برابر",
"Zoom in x4" => "بزرگنمايي 4برابر",
"from\nthe mapfile:" => "از \nthe پرونده‌ي نقشه‌ي:",
"compare" => "مقايسه كن",
"diff" => "تغييرات",
"older version" => "نسخ قبلي",
"Click the :: options in the Menu for more options." => "براي اختيارهاي بيشتر روي اختيار :: در منو كليك كنيد",
"Please, also see" => "لطفا نگاهي هم بياندازيد به",
"for more setup details." => "براي جزئيات بيشتر نصب و برپاسازي.",
"You can remove this module in" => "اين ماژول را مي‌توانيد در اين‌جا حذف كنيد",
"as well as assign or edit many others." => "همان‌گونه كه مي‌توانيد بسياري ماژول‌هاي ديگر را تخصيص دهيد يا ويرايش كنيد.",
"del" => "حذف",
"Create pdf" => "ساخت PDF",
"pdf" => "PDF",
"1 file attached" => "1 پرونده ضميمه شد",
"categories" => "طبقه",
"List pages where I am a creator" => "فهرست صفحاتي را كه من ايجاد كرده‌ام، نمايش بده",
"by creator" => "به‌وسيله‌ي ايجاد كننده",
"List pages where I am a modificator" => "فهرست صفحاتي را كه من تغيير داده‌ام، نمايش بده",
"by modificator" => "به‌وسيله‌ي تغيير دهنده",
"at tracker" => "در tracker",
"check / uncheck all" => "انتخاب همه/هيچكدام",
"Tiki sections and features" => "خصيصه‌ها و بخش‌هاي تيكي",
"tikiwiki.org help" => "كمك در tikiwiki.org",
"Site Logo and Identity" => "هويت و نماد پايگاه",
"please read" => "لطفا بخوانيد",
"yes" => "بله",
"Click here for more details." => "براي جزئيات بيشتر اين‌جا را كليك كنيد",
"Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)" => "بيشينه مقدار حروف ويكي در بانك اطلاعاتي، به‌صورت پيش‌فرض 250 حرف تعيين گرديده است كه به محتواي كد متناسب‌سازي شده نيز اعمال مي‌شود. اگر مي‌خواهيد بيش از از اين تعداد حرف وارد كنيد، اين گزينه را انتخاب كنيد. (گرچه افزايش اين مقدار بر روي mysql آزمايش شده و نتيجه‌ي مطلوبي داشته، پيشنهاد مي‌شود كه قبل از تغيير در بانك اطلاعاتي، به‌صورت دستي از اطلاعات خود نسخه‌ي پشتيبان تهيه كنيد.)",
"Users &amp; groups" => "كاربران و تيم‌هاي كاري",
"UTC" => "ساعت هماهنگ فراگير(UTC)",
"private" => "شخصي",
"<b>Item</b>" => "<b>مورد</b>",
"<b>Value</b>" => "<b>مقدار</b>",
"This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS Modules\" on the application menu, or" => "اين صفحه براي پيكربندي تنظيمات تغذيه‌هاي توليد/صادر شده به‌وسيله‌ي تيكي است. براي خواندن/وارد كردن تغذيه‌هاي RSS، به دنبال \"ماژول‌هاي RSS\" در منوي برنامه بگرديد. يا",
"<b>Feed</b>" => "<b>تغذيه</b>",
"<b>enable/disable</b>" => "<b>فعال/غيرفعال</b>",
"<b>Max number of items</b>" => "<b>بيشينه تعداد اقلام</b>",
"Feed for Articles" => "تغذيه براي مقالات",
"Feed for Weblogs" => "تغذيه براي وبلاگ‌ها",
"Feed for Image Galleries" => "تغذيه براي سرسراهاي تصاوير",
"Feed for File Galleries" => "تغذيه براي سرسراهاي پرونده‌ها",
"Feed for the Wiki" => "تغذيه براي ويكي",
"Feed for individual Image Galleries" => "تغذيه براي تك تك سرسرهاي تصوير",
"Feed for individual File Galleries" => "تغذيه براي تك تك سرسرهاي پرونده",
"Feed for individual weblogs" => "تغذيه براي تك تك وبلاگ‌ها",
"Feed for individual forums" => "تغديه براي تك تك انجمن‌ها",
"Feed for mapfiles" => "تغذيه براي پرنده‌هاي نقشه",
"Feed for directories" => "تغذيه براي پوشه‌ها",
"Caching time :" => "زمان Cache",
"Prefix breadcrumbs with 'Location:' label?" => "آيا برچسب 'مكان:' پيشوند خرده‌نان‌ها باشد؟",
"Site Search" => "جستجوي پايگاه",
"Change style only" => "فقط سبك(Style) رو تغيير بده",
"PDF generation" => "توليد PDF",
"IP not displayed in history" => "آدرس اينترنتي(IP) در تاريخچه نمايش داده نشود",
"Use in CMS" => "استفاده در سامانه‌ي مديريت محتوا",
"Use in Wiki" => "استفاده در ويكي",
"Use in newsletters" => "استفاده در خبرنامه‌ها؟",
"Use in events" => "استفاده در رويدادها؟",
"Use in HTML pages" => "استفاده در اين صفحات HTML",
"Edit Existing Forums" => "انجمن كنوني را ويرايش كن",
"Refresh rate (if dynamic) [secs]" => "نرخ تازه كردن-Refresh- (در صورت پويا بودن) [ثانيه]",
"configure repositories" => "پيكربندي مخازن",
"configure this repository" => "پيكربيندي اين مخزن",
"copy rules" => "كپي قوانين",
"Create/edit newsletters" => "ايجاد/تغيير خبرنامه‌ها",
"subscriptions" => "مشتركين",
"archives" => "بايگاني‌ها",
"Use Admin Email" => "از پست الكترونيك سرپرست استفاده كن",
"Edit or add poll options" => "افزودن يا ويرايش اختيارات راي‌گيري‌ها",
"configure polls" => "پيكربندي راي‌گيري‌ها",
"Create/edit Polls" => "ايجاد/ويرايش راي‌گيري",
"Rss channels" => "كانال‌هاي RSS",
"show pubdate" => "تاريخ انتشار را نمايش بده",
"activate" => "فعال‌سازي",
"Admin tracker" => "مديريت tracker",
"Edit this tracker" => "ويرايش اين tracker",
"View this tracker items" => "نمايش اقلام اين tracker",
"Edit tracker fields" => "ويرايش ستون‌هاي tracker",
"visible by admin only" => "تنها به‌وسيله‌ي سرپرست قابل مشاهده است",
"Import/export trackers fields" => "وارد/صادر كردن ستون‌هاي tracker",
"Edit tracker" => "ويرايش tracker",
"Create trackers" => "ايجاد trackerها",
"Import/export" => "واردات/صادرات",
"fields" => "ستون‌ها",
"active permissions" => "حقوق دسترسي فعال",
"Create/edit trackers" => "ايجاد/ويرايش trackerها",
"filename" => "نام پرونده",
"filesize" => "حجم پرونده",
"filetype" => "نوع پرونده",
"longdesc" => "توضيحات",
"Add a new group" => "افزودن يك گروه جديد",
"Edit item" => "ويرايش فقره",
"List all members" => "فهرست تمام اعضا",
"Add a new user" => "اضافه كردن يك كاربر جديد",
"manage group assignments" => "عضويت گروه‌هايشان رو مديريت كن",
"set default groups" => "غضو گروه‌هاي كاربري پيش‌فرض كن",
"Popup Window" => "پنجره‌ي popup",
"details" => "جزئيات",
"change focus" => "تغيير تمركز",
"quater" => "يك چهارم",
"quarter" => "چهارم",
"semester" => "نيم‌سال",
"No individual permissions global permissions apply" => "بدون حقوق دسترسي فردي. حقوق دسترسي عمومي اعمال مي‌شوند.",
"Welcome to the Tiki Chat Rooms" => "به اتاق‌هاي گفتگوي تيكي خوش‌آمديد‌",
"Please select a chat channel" => "لطفا يك كانال گپ‌زني انتخاب كنيد",
"enter chat room" => "وارد اتاق گپ‌زني شو",
"There are no channels setup, please contact a site admin" => "هيج كانالي آماده نيست، لطفا با مدير پايگاه تماس بگيريد",
"Chatroom" => "اتاق گپ‌زني",
"Active Channels" => "كانال‌هاي فعال",
"Users in this channel" => "كاربران اين كانال",
"Channel Information" => "اطلاعات كانال",
"Channel" => "كانال",
"Ratio" => "نرخ",
"Use :nickname:message for private messages" => "براي پيغام‌هاي شخصي، از تركيب :نام متسعار:پيغام استفاده كنيد.",
"Use [URL|description] or [URL] for links" => "براي پيوندها از [URL|description] يا [URL] استفاده كنيد.",
"Use (:smileyname:) for smileys" => "براي صورتك‌ها از (:نام صورتك:) استفاده كنيد:",
"Create PDF" => "ساخت PDF",
"PDF Settings" => "تنظيمات PDF",
"Select Wiki Pages" => "انتخاب صفحات ويكي",
"Remove Page" => "صفحه را حذف كن",
"click here to send us an email" => "براي ارسال يك پست الكترونيكي به ما، اين‌جا را كليك كنيد",
"Add or edit a site" => "افزودن يا ويرايش يك پايگاه وب",
"sites" => "پايگاه‌ها",
"cool sites" => "پايگاه‌هاي بامزه(cool)",
"Use ...page... to separate pages in a multi-page article" => "از ...page... براي جداكردن صفحات در يك مقاله‌ي چندصفحه‌اي استفاده كنيد",
"Create Zone" => "ايجاد قلمرو",
"use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!)." => "از كروشه براي ويكي‌هاي خارجي استفاده كن: [URL] يا [URL|توضيح پيوند] يا [URL|توضيح|nocache] (كه مورد آخر از cache كردن صفحه توسط ويكي محلي جلوگيري مي‌كند؛ لطفا براي صفحات بزرگ از اين گزينه استفاده كنيد!).",
"browse image" => "مرور تصوير",
"translate" => "ترجمه كن",
"Create or edit content" => "ساخت يا ايجاد محتوي",
"this quiz stats" => "آمار اين آزمون",
"answer" => "پاسخ",
"Edit Translation:" => "ويررايش ترجمه:",
"Use this section to set the language of the version you are currently working on." => "از اين بخش براي تنظيم نسخه‌ي از زبان كه برروي آن كار مي‌كنيد استفاده كنيد",
"Set of Translations" => "مجموعه‌ي ترجمه‌ها",
"Select the article for which the current article is the translation." => "مقاله‌اي كه اين مقاله ترجمه‌ي آن است را انتخاب كنيد",
"Translation of:" => "ترجمه‌ي",
"Enter the name of the page for which the current page is the translation." => "نام صفحه‌اي كه اين صفحه ترجمه‌ي آن است را وارد كنيد",
"Add to the Set" => "افزودن به مجموعه",
"graph" => "نگار(نمودار)",
"Edit FAQ questions" => "ويرايش سئوالات اين FAQ",
"Edit this file gallery:" => "ويرايش اين سرسراي پرونده:",
"icon" => "تمثال",
"Other users can upload files to this gallery" => "ساير كاربران مي‌توانند به اين سرسرا پرونده اضافه كنند",
"Available File Galleries" => "سرسراهاي پرونده‌ي موجود",
"configure forum" => "پيكربندي انجمن‌ها",
"start" => "آغاز",
"end" => "پايان",
"roles" => "قوانين",
"Add role" => "افزودن قانون",
"active process" => "فرايندهاي فعال",
"invalid" => "نامعتبر",
"invalid process" => "فرايند نامعتبر",
"valid process" => "فرايند معتبر",
"activities" => "فعاليت‌ها",
"aborted" => "منقطع شده",
"value" => "مقدار",
"proc" => "فرايند",
"exceptions" => "استثنا",
"rollback" => "عقب‌گرد",
"Create or edit content block" => "ايجاد يا ويرايش بلاك محتوي",
"Listing Gallery" => "فهرست كردن سرسراها",
"Gallery Files" => "پروده‌هاي سرسرا",
"Last ver" => "آخرين نسخه",
"Com" => "نوع",
"Vers" => "نسخ",
"subscribe" => "عضويت",
"Sent edition" => "ويرايشات ارسال شده",
"Subscribe to newsletter" => "عضويت در خبرنامه",
"Add or edit a news server" => "افزودن يا ويرايش يك سرور اخبار",
"Print Wiki Pages" => "چاپ صفحات ويكي",
"add page" => "صفحه را اضافه كن",
"entire site" => "تمام پايگاه",
"click to navigate" => "براي هدايت اين‌جا را كليك كنيد",
"Total threads" => "مجموع رگه‌ها",
"Average threads per topic" => "متوسط رگه‌ها در هر موضوع",
"You can include the file in an HTML/Tiki page using" => "بدين‌وسيله مي‌توانيد پرونده‌اي را در يك صفحه‌ي HTML يا تيكي بگنجانيد",
"Now enter the file URL" => "هم اكنون URL پرونده را وارد كنيد",
" or upload a local file from your disk" => " يا يك پرونده از دستگاه خود بارگذاري كنيد",
"Add or edit folder" => "افزودن يا ويرايش پوشه",
"Add or edit a URL" => "افزودن يا ويرايش يك URL",
"received" => "دريافت شده‌ها",
"submitted" => "ارائه شده",
"shared" => "مشترك",
"accepted by task user and creator" => "پذيرفته شده از طرف كاربر وظيفه و ايجاد كننده",
"not accepted by one user" => "از طرف يك كاربر پذيرفته شده است",
"waiting for me" => "منتظر من هستند",
"waiting for other user" => "منتظر ساير كاربران",
"move into trash" => "انتقال به خاكروبه",
"waiting / not started" => "درحال انتظار/هنوز آغاز نشده است",
"waiting" => "انتظار",
"shared for group" => "مشترك براي گروه",
"accepted by user" => "پذيرفته شده از طرف كاربر",
"no / rejected" => "خير / رد شده",
"accepted by creator" => "پذيرفته شده از طرف ايجاد كننده",
"priority" => "اولويت",
"select one" => "يكي را انتخاب كنيد",
"undo trash" => "بازگشت از خاكروبه",
"show:" => "نمايش بده:",
"all shared tasks" => "تمام وظايف مشترك",
"previous chart" => "نمودار قبلي",
"next chart" => "نمودار بعدي",
"pos" => "رديف",
"pre" => "قبلي",
"permanency" => "قطعيت",
"avg" => "معدل",
"post new comment" => "الصاق نظريه جديد",
"Post New Comment" => "الصاق نظريه جديد",
"HTML tags are not allowed inside comments" => "تگ‌هاي HTML درون نظرات مجاز نيستند",
"moderator actions" => "اعمال ناظم",
"move selected topics" => "عناوين منتخب را انتقال بده",
"unlock selected topics" => "قفل عنواين منتخب را باز كن",
"lock selected topics" => "عناوين منتخب را قفل كن",
"merge" => "ادغام",
"merge selected topics" => "عناوين منتخب را اذغام كن",
"reported messages:" => "پيغام‌هاي گزارش شده:",
"queued messages:" => "پيغام‌هاي در صف",
"emot" => "احساسات",
"Edit fields" => "ويرايش ستون‌ها",
"View item" => "مشاهده‌ي فقره",
"Add a comment" => "ايراد نظر",
"account" => "حساب",
"pop" => "درگاه pop",
"Projects" => "پروژه‌ها",
"Site Identity features" => "خصيصه‌هاي عينيت پايگاه",
"Click here to delete this category" => "براي حذف اين طبقه، اين‌جا را كليك كنيد",
"Group doesnt exist" => "گروه وجود ندارد",
"User doesnt exist" => "كاربر وجود ندارد",
"Event without Name" => "رويداد بدون نام",
"Invalid old password" => "كلمه‌ي عبور قبلي اشتباه است",
"No channel indicated" => "هيچ كانالي مشخص نشده است.",
"No nickname indicated" => "هيچ نام مستعاري مشخص نشده است.",
"No permission to view the page" => "حقوق دسترسي‌اي براي ديدن اين صفحه وجود ندارد",
"I have refused your friendship request!" => "من درخواست رفاقت شما را رد كرده‌ام!",
"Please create a directory named \$map_path to hold your map files." => "لطفا يك پوشه با عنوان \$map_path براي نگه‌داري پرونده‌هاي نقشه‌ها بسازيد.",
"Permision denied" => "دسترسي ممنوع",
"Phillippines" => "فيليپين",
"sender" => "فرستنده",
"subject" => "موضوع",
"date" => "تاريخ",
"flagged" => "علامت‌دار",
"mark" => "علامت بزن",
"find replied message" => "پاسخ ارسالي را بياب",
"Click" => "كليك",
"posted by" => "الصاق شده توسط",
"email this post" => "اين الصاق را با پست الكترونيكي بفرست",
"Tag name" => "نام برچسب",
"Anonymous editors must input anti-bot code" => "ويراستاران بي‌نام، بايد كدهاي ضد-روباتيكي را وارد كنند",
"Edit idle timeout" => "مهلت ويرايش",
"Use page description" => "از شرح صفحه استفاده كن",
"Show page title" => "عنوان صفحه را نمايش بده",
"Show page ID" => "شناسه‌ي صفحه را نمايش بده",
"Users can lock pages (if perm)" => "كاربران مي‌توانند صفحات را قفل كنند(اگر دسترسي داشته باشند)",
"Use WikiWords" => "از ويكي-كلمه استفاده كن",
"Use Wiki paragraph formatting" => "از شكل‌سازي پاراگراف‌هاي ويكي استفاده كن",
"Use external link icons" => "از تمثال پيوند خارجي استفاده كن",
"User's Page" => "صفحات كاربران",
"UserPage prefix" => "پيشوند صفحات كاربران",
"Print Page" => "چاپ صفحه",
"Maximum number of versions for history" => "بيشينه تعداد نسخ براي تاريخچه",
"Never delete versions younger than days" => "هرگز صفحات جديدتر از اين تعداد روز را حذف نكن",
"Diff style" => "سبك تفاوت",
"Old vers" => "نسخ قديمي",
"Add or edit event" => "افزودن يا ويرايش رويداد",
"merge selected notes into" => "يادداشت‌هاي انتخابي را ادغام كن و بريز داخل",
"Faq Stats" => "آمار سئوالات متداول",
"Edit User Files" => "ويرايش پرونده‌هاي كاربر",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "پيغام شما براي تاييد در صف قرار گرفته است و پس از تاييد ناظم الصاق خواهد شد.",
"Webmail Doc" => "مستندات پست تحت وب",
"Webmail Doc template" => "الگوي مستندات پست تحت وب",
"settings" => "تنظيمات",
"mailbox" => "صندوق پستي",
"compose" => "تهيه‌ي نامه",
"contacts" => "تماس‌ها",
"clip" => "كليپ",
"back to mailbox" => "بازگشت به صندوق پستي",
"full headers" => "سرصفحه‌هاي كامل",
"normal headers" => "سرصفحه‌هاي معمولي",
"reply all" => "پايه به همه",
"forward" => "ارجاع",
"select from address book" => "از كتابچه‌ي آدرس انتخاب كن",
"cc" => "رونوشت",
"Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "اختيارات رشته‌ي متني: 1، size، prepend،append،max. حجم(size)، به تعداد حرف؛ افزودن به ابتدا(prepend)، اطلاعات را به ابتداي ستون اضافه مي‌كند؛ افزودن به انتها(append)، اطلاعات را به انتهاي ستون اضافه مي‌كند؛ بيشينه(max)، بيشينه تعداد حروفي كه مي‌تواند ذخيره شود. 1 اوليه مشخص كننده‌ي اين مطلب كه ستون بعدي در همين سطر است",
"Checkbox options: put 1 if you need that next field is on the same row." => "انتخاب: برابر يك قرار دهيد اگر اين گزينه در همان ستون است.",
"Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "اختيارات: 1، size، prepend،append،max. حجم(size)، به تعداد حرف؛ افزودن به ابتدا(prepend)، اطلاعات را به ابتداي ستون اضافه مي‌كند؛ افزودن به انتها(append)، اطلاعات را به انتهاي ستون اضافه مي‌كند؛ بيشينه(max)، بيشينه تعداد حروفي كه مي‌تواند ذخيره شود. 1 اوليه مشخص كننده‌ي اين مطلب كه ستون بعدي در همين سطر است",
"Dropdown options: list of items separated with commas." => "اختيارات ستون كركره‌اي: فهرست اقلام با كاما جدا مي‌شوند.",
"Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "اختيارات: از اختياراتبراي تغذيه‌ي خودكار ستون استفاده كنيد. مي‌توانيد از 1 براي گروه كاربري ايجاد كننده و 2 براي گروه كاربري تغييردهنده استفاده كنيد. گروه اگر گروه كاربري پيش‌فرض تنظيم نشده باشد، اولين گروه كاربري براي هر كاربر استفاده مي‌شود و يا گروه پيش‌فرض 'ثبت‌نام كرده‌هاست'.",
"Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels." => "اختيارات: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale همه به پيكسل.",
"Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "اختيارات: Label,post,tiki-index.php,page. page:نام پرونده، highlight=متن",
"Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing" => "اختيارات: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere  نمايش‌گر فهرست displayFieldIdThere هستند كه اقلام در tracker مشخص‌شده با trackerId، كه fieldIdThere معادل fieldIdHere باشد.",
"Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "اختيارات: 0،1و2. كه 0 آدرس را با عنوان متن ساده قرار مي‌دهد، 1 يك پست با كدهاي شانزده‌تايي قرار مي‌دهد(براي spamها و spiderها كار مشكل‌تر مي‌شود)، و 2 يك كد mailto با صورت عادي href قرار مي‌دهد.",
"new sites" => "پايگاه‌هاي جديد",
"Message Broadcast" => "ارسال همگاني پيغام",
"Paramaters" => "پارامترها",
"Are you sure you want to remove this module?" => "آيا مطمئن هستيد مي‌خواهيد اين ماژول را حذف كنيد؟",
"database queries used" => "درخواست ارسالي به بانك اطلاعاتي",
"{\$atts_cnt} files attached" => "{\$atts_cnt} پرونده ضميمه شد",
"pass" => "كلمه عبور",
"Page generated in" => "صفحه توليد شده در",
"sent" => "ارسال شده در",
"Homework" => "مشق شب",
"Assignments" => "انتصاب‌ها",
"Favorites" => "علاقه‌مندي‌ها",
"Member list" => "فهرست اعضا",
"Back to Homepage" => "بازگشت به صفحه‌ي مبدا",
"Edit Summary" => "خلاصه‌ي ويرايش",
"Minor" => "كوچك",
"Last update from CVS" => "آخرين به‌روز رساني از CVS",
"Translate in" => "ترجمه شده به",
"babelfish it" => "با babelfish ترجمه‌اش كن",
"Welcome to" => "خير مقدم",
"Content Features" => "خصيصه‌هاي محتوا",
"Contact Us (Anonymous)" => "تماس با ما(بي‌نام)",
"Prevent automatic/robot registration" => "از ثبت‌نام خودكار(ماشيني) جلوگيري كن",
"Site Logo" => "نماد پايگاه",
"Admin Groups Template" => "الگوي مديريت گروه‌هاي كاربري",
"Admin banning tpl" => "الگوي مديريت تحريم‌ها",
"Create/edit Calendars" => "ايجاد/ويرايش تقويم",
"Admin Categories tpl" => "الگوي مديريت طبقه‌بندي‌ها",
"charts" => "نمودارها",
"Admin Charts Template" => "مديريت الگوي نمودارها",
"Chat Administration" => "مديريت گپ‌زني",
"Chat Admin" => "مديريت گپ‌زني",
"Chat Admin tpl" => "الگوي مديريت گپ‌زني",
"Create/edit channel" => "ايجاد/ويرايش كانال",
"Half a second" => "نيم ثانيه",
"second" => "ثانيه",
"Chat channels" => "كانال‌هاي گپ‌زني",
"Admin Content Templates Template" => "مديريت الگوي 'اگوهاي محتوي'",
"Admin DSN" => " مديريتDSN",
"tiki-admin_dsn tpl" => "الگوي مديريت DSN تيكي",
"Admin Forums Template" => "مديريت الگوي انجمن‌ها",
"Admin Hotwords Template" => "مديريت الگوي واژگان آتشين",
"Admin Featured Links" => "مديريت پيوندهاي خاص",
"Admin Featured Links Template" => "الگوي مديريت پيوندهاي خاص",
"Admin Webmail" => "مديريت پست تحت وب",
"Admin Mailing Template" => "مديريت الگوي دريافت پست الكترونيكي",
"Admin Menu Builder" => "مديريت سازنده‌ي منو",
"Admin Menus Template" => "الگوي مديريت منوها",
"Admin Modules Template" => "الگوي مديريت ماژول‌ها",
"Assign Module" => "تخصيص ماژول‌ها",
"subscribed" => "عضو شد",
"Admin Newsletters Template" => "مديريت الگوي خبرنامه‌ها",
"Admin Notifications Template" => "مديريت الگوي اطلاع‌رساني‌ها",
"Admin Polls Template" => "مديريت الگوي راي‌گيري‌ها",
"Configure Polls" => "پيكربندي راي‌گيري‌ها",
"tiki admin quicktags template" => "الگوي مديريت تگ‌هاي سريع تيكي",
"Score System" => "سامانه‌ي امتيازدهي",
"security admin" => "مديريت امنيت",
"security admin tpl" => "الگوي مديريت امنيت",
"Admin Shoutbox Words Template" => "الگوي مديريت كلمات فريادگاه",
"Edit survey questions" => "ويرايش سئوالات نظرسنجي‌",
"administer surveys template" => "اداره كردن الگوي نظرسنجي‌ها",
"system admin" => "مديريت سيستم",
"system admin tpl" => "الگوي مديريت سامانه",
"Admin Topics Template" => "الگوي مديريت عناوين",
"Admin Tracker" => "مديريت tracker",
"Admin Users Template" => "الگوي مديريت كاربران",
"Again" => "تكرار كلمه‌ي عبور",
"Article Types tpl" => "الگوي انواع مقالات",
"Assign permissions to group" => "تخصيص حقوق دسترسي به گروه كاربري ",
"Edit Article Tpl" => "الگوي ويرايش مقالات",
"Browsing Gallery" => "مرور سرسرا",
"Admin Directory tpl" => "الگوي مديريت پوشه",
"Admin Directory Categories tpl" => "الگوي مديريت طبقات پوشه",
"Admin Directory Related" => "مديريت پوشه‌هاي مرتبط",
"directory admin related tpl" => "الگوي مديريت پوشه‌ي مرتبط",
"Admin Directory Sites" => "مديريت پايگاه‌هاي پوشه",
"Admin Directory Sites tpl" => "مديريت الگوي پايگاه‌هاي پوشه",
"Validate Sites" => "پايگاه را تاييد اعتبار كنيد",
"directory validate sites tpl" => "الگوي پايگاه تاييد اعتبار پوشه",
"Edit Article" => "ويرايش مقاله",
"Edit Blog Tpl" => "ويرايش الگوي بلاگ",
"Show Plugins Help" => "نمايش كمك در مورد Pluginها",
"Show Text Formatting Rules" => "قوانين شكل‌دهي متون را نمايش بده",
"Program dynamic content for block" => "محتواي پوياي برنامه براي بلوك",
"Admin quizzes" => "مديريت آزمون‌ها",
"Admin Quizzes tpl" => "الگوي مديريت آزمون‌ها",
"Edit Quiz Questions" => "سئوالات آزمون را ويرايش كن",
"Edit Quiz Questions Tpl" => "الگوي ويرايش سئوالات آزمون",
"Edit Submissions Tpl" => "الگوي ويرايش ارائه‌ها",
"EditTemplates" => "ويرايش الگوها",
"EditTemplates tpl" => "الگوي ويرايش الگوها",
"Edit Translations" => "ويرايش ترجمه‌ها",
"Edit Translations Template" => "الگوي ويرايش ترجمه‌ها",
"Message queue for" => "صف پيغام براي",
"back to forum" => "بازگشت به انجمن",
"Reported messages for" => "پيغام‌هاي گزارش شده براي",
"friends tpl" => "الگوي رفقا",
"galleries tpl" => "الگوي سرسراها",
"ImportingPagesPhpWikiPageAdmin" => "صفحه‌ي مديريت واردات صفحه‌ي ويكي PHP",
"tiki-import_phpwiki tpl" => "الگوي واردات PHP ويكي",
"hist" => "تاريخچه",
"List Articles Tpl" => "الگوي فهرست مقالات",
"Admin Cache" => "مديريت Cache",
"Admin Cache tpl" => "الگوي مديريت Cashe",
"List FAQs Tpl" => "الگوي فهرست سئوالات متداول",
"games tpl" => "الگوي بازي‌ها",
"List Posts Tpl" => "الگوي فهرست الصاق‌ها",
"List Quizzes Tpl" => "الگوي فهرست آزمون‌ها",
"Edit Quiz Stats Tpl" => "ويرايش الگوي آمار آزمون",
"List Trackers Tpl" => "الگوي فهرست trackerها",
"Admin Live Support tpl" => "الگوي مديريت پشتيباني زنده",
"back to admin" => "بازگشت به مديريت",
"User Calendar" => "تقويم كاربر",
"User Calendar Doc tpl" => "الگوي مستندات تقويم جيبي",
"User Calendar Doc" => "مستندات تقويم جيبي",
"User Calendar Preferences Doc tpl" => "از الگوي مستندات تنظيمات تقويم جيبي استفاده كن",
"my tiki tpl" => "الگوي تيكي من",
"Subscribe to This Newsletter" => "عضويت",
"Stats for quiz" => "آمار آزمون",
"Received Articles" => "مقالات دريافت شده",
"received articles tpl" => "الگوي مقالات دريافت شده",
"received pages tpl" => "الگوي صفحات دريافت شده",
"Rename page" => "تغيير نام",
"to_version" => "به نسخه‌ي",
"search stats tpl" => "الگوي آمار جستجو",
"Admin Send Objects tpl" => "الگوي مديريت ارسال اشياء",
"sheets tpl" => "الگوي اوراق",
"Stats for survey" => "آمار نظرسنجي",
"system logs" => "ثبت‌وقايع سامانه",
"system logs tpl" => "الگوي ثبت‌وقايع سامانه",
"Theme Control Center: categories" => "مركز كنترل قيافه‌ها: طبقات",
"ThemeControl" => "كنترل قيافه",
"ThemeControl tpl" => "الگوي كنترل قيافه",
"ThemeControl Objects" => "اشياء كنترل قيافه",
"theme control objects tpl" => "الگوي اشياء كنترل قيافه‌ها",
"Theme Control Center: sections" => "مركز كنترل قيافه: بخش‌ها",
"theme control sections tpl" => "الگوي مركز قيافه‌ي بخش‌ها",
"File Title" => "عنوان پرونده",
"Image Gallery tpl" => "الگوي سرسراي تصوير",
"User Assigned Modules" => "ماژول‌هاي تخصيص يافته‌ي كاربر",
"User Assigned Modules tpl" => "الگوي ماژول‌هاي تخصيص يافته‌ي كاربر",
"User Bookmarks tpl" => "الگوي صفحه‌ياب‌هاي كاربر",
"UserPreferences tpl" => "الگوي تنظيمات كاربر",
"User Tasks tpl" => "الگوي وظايف كاربر",
"User Watches tpl" => "الگوي ديده‌بان‌هاي كاربر",
"View FAQ Tpl" => "الگوي مشاهده‌ي FAQ",
"Admin Menus tpl" => "الگوي مديريت منوها",
"IRC log" => "ثبت وقايع IRC",
"Add new mail account" => "اضافه كردن يك حساب پست الكترونيكي",
"User accounts" => "حساب‌هاي كاربران",
"View All" => "مشاهده‌ي همه",
"Msg" => "پيغام",
"Can't parse remote HTML page" => "نمي‌توانم صفحه‌ي راه‌دور HTML را تجزيه كنم",
"Permission denied you cannot remove pages" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد صفحات را حذف كنيد",
"Cannot write to this file" => "نمي‌توانم در اين پرونده بنويسم",
"Missing title or body when trying to post a comment" => "عنوان يا متن هنكام الصاق مفقود شده است",
"\\n for rows" => "\\n براي ستون‌ها",
"Use this thread to discuss the %s page." => "از اين رگه براي مطرح كردن صفحه‌ي %s استفاده كنيد",
"Newsletter subscription information at " => "اطلاعات مربوط به اشتراك خبرنامه در",
"Changes" => "تغييرات",
"categorize this object" => "اين شيء را طبقه‌بندي كن",
"Your account request have been stored and will be activated by the admin as soon as possible." => "Your account request has been stored and will be activated by the admin as soon as possible.",
"New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "الصاق مقاله‌ي جديد: {\$mail_title} به‌وسيله‌ي {\$mail_user} در {\$mail_date|tiki_short_datetime}",
"New article post at %s" => "الصاق مقاله‌ي جديد در %s",
"Syntax highlighting" => "برجسته‌سازي نحو",
"MyTiki Home" => "مبدا تيكي من",
"My Files" => "پرونده‌هاي من",
"Mini calendar" => "تقويم جيبي",
"FriendsMenu" => "منو رفيقان",
"User list" => "فهرست كاربران",
"Dump" => "تخليه(dump)",
"Send Pages" => "ارسال صفحات",
"Received pages" => "صفحات دريافت شده",
"Admin Posts" => "الصاق‌هاي سرپرست",
"Submit a New Link" => "ارائه‌ي يك پيوند جديد",
"Browse directory" => "مرور پوشه",
"Admin Directory" => "مديريت پوشه",
"List quizzes" => "فهرست آزمون‌ها",
"ShtMenu" => "منوي كوتا",
"List trackers" => "فهرست trackerها",
"Ephemerides Admin" => "مديريت سالنامه",
"Charts Admin" => "مديريت نمودارها",
"I forgot my pass" => "من كلمه‌ي عبورم را فراموش كرده‌ام",
"Send trackback pings to:" => "pingهاي trackback را به اين URIها بفرست:",
"(comma separated list of URIs)" => "URIها را با كاما(؛)از هم جدا كنيد",
"This is" => "اين يك",
"by the" => "توسط",
"Tiki community" => "اجتماع تيكي",
"User identity features" => "خصيصه‌هاي عينيت كاربر",
"Use URI as Home Page" => "از اين URI به‌عنوان صحفه‌ي مبدا استفاده كن",
"OS" => "سيستم عامل",
"Default charset for sending mail:" => "كاراكتر سي پيش‌فرض براي ارسال پست الكترونيكي:",
"Mail end of line:" => "انتهاي خط در پست‌هاي الكترونيكي:",
"Disallow access to the site (except for those with permission)" => "دسترسي به اين پايگاه را -مگر براي كساني كه دسترسي دارند- ممكن نساز",
"Message to display when site is closed" => "پيغامي كه بايد هنگام تعطيل بودن پايگاه نمايش داده شود",
"Disallow access when load is above the threshold (except for those with permission)" => "هنگامي كه بار پايگاه پيش از حد مجاز مي‌شود، دسترسي به اين پايگاه را -مگر براي كساني كه دسترسي دارند- ممكن نساز",
"Max average server load threshold in the last minute" => "بيشينه بار متوسط سرور(Server Load) در دقيقه‌ي گذشته",
"Message to display when server is too busy" => "پيغامي كه بايد هنگام مشغول بودن بيش‌از حد سرور نمايش داده شود",
"Use cache for external images" => "تصاوير خارجي را در حافظه‌ي خود نگه‌دار",
"Use gzipped output" => "از خروجي‌ها gzipped استفاده كن",
"output compression is active." => "فشرده‌يسازي خروجي‌ها فعال است.",
"compression is handled by" => "فشرده‌سازي بدين‌وسيله اداره مي‌شود",
"Sender Email" => "پست الكترونيكي فرستنده",
"Allow anonymous users to \"Contact Us\"" => "بي‌نام، امكان 'تماس با ما' را فراهم كن",
"contact feature disabled" => "امكان 'تماس' غيرفعال شد",
"Session lifetime in minutes" => "عمر session به دقيقه",
"Proxy Host" => "ميزبان پروكسي",
"Locations separator" => "جداساز مكان‌ها",
"User registration and login" => "ثبت‌نام كاربران و ورود آن‌ها",
"Use WebServer authentication for Tiki" => "براي تيكي از تصديق هويت وب‌سرور استفاده كن",
"... but need admin validation" => "…اما به تاييد اعتبار مديريت نياز دارند",
"Use tracker for more user information" => "از پيوندننده(tracker) براي اطلاعات بيشتر در مورد كاربران استفاده كن",
"Use tracker for more group information" => " از پيوندننده(tracker) براي اطلاعات بيشتر در مورد گروه‌ها استفاده كن ",
"Request passcode to register" => "براي ثبت‌نام درخواست اسم رمز(passcode) كن",
"Validate users by email" => "به كمك پست الكترونيكي، كاربر را تاييد اعتبار كن",
"Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email" => "اگر 'نگهداري كلمات عبور به‌صورت كدنشده' فعال است، كلمات‌عبور را بنا به درخواست به پست الكترونيكي بفرست، در غير اين صورت، به كمك پست الكترونيكي آن‌ها را عوض كن",
"Store plaintext passwords" => "كلمات عبور را به‌صورت كدنشده نگهداري كن",
"Reg users can change password" => "كاربران ثبت‌نام كرده، مي‌توانند كلمات عبور خود را تغير دهند",
"Reg users can change language" => "كاربان ثبت‌نام كرده، مي‌توانند زبان مربوط به خود را تغيير دهند",
"Restrict available languages" => "زبان‌هاي موجود را محدود كن",
"Available languages:" => "زبان‌هاي موجود:",
"Force to use chars and nums in passwords" => "استفاده از اعداد و حروف در كلمه‌ي عبور اجباري است",
"Minimum password length" => "حداقل طول كلمه‌ي عبور",
"Password invalid after days" => "تعداد روزهاي معتبر بودن كلمه‌ي عبور",
"Remember me feature" => "خصيصه‌ي 'مرا به‌خاطر بسپار' فعال باشد",
"Remember me name" => "نام 'مرا به‌خاطر بسپار'",
"Remember me domain" => "domain  'مرا به‌خاطر بسپار'",
"Remember me path" => "آدرس 'مرا به‌خاطر بسپار'",
"Protect against CSRF with a confirmation step" => "به كمك يك مرحله تصديق، در برابر CSRF حفاظت كن",
"Highlight Group" => "گروه برجسته",
"Create user if not in Tiki?" => "كاربر را بساز، اگر در تيكي نبود",
"Create user if not in Auth?" => "كاربر را بساز، اگر در Auth نبود",
"Just use Tiki auth for admin?" => "تنها از تصديق هويت تيكي براي مديران استفاده كن",
"LDAP URL<br />(if set, this will override the Host and Port below)" => "LDAP URL<br />(اگر تنظيم شود، ميزبان و درگاه مذكور در پايين را باطل مي‌كند)",
"LDAP Host" => "ميزبان LDAP",
"LDAP Port" => "درگاه LDAP",
"LDAP Scope" => " محدوده -scope- براي LDAP ",
"LDAP Base DN" => "DN پايه در LDAP",
"LDAP User DN" => "DN كاربر در LDAP",
"LDAP User Attribute" => " خصوصيت(Attribute) كاربر در LDAP ",
"LDAP User OC" => "OC كاربر در LDAP",
"LDAP Group DN" => "DN  گروه در LDAP",
"LDAP Group Attribute" => " خصوصيت(Attribute) گروه در LDAP ",
"LDAP Group OC" => " OC گروه در LDAP ",
"LDAP Member Attribute" => " خصوصيت(Attribute) عضو در LDAP ",
"LDAP Member Is DN" => "اعضاي LDAP در DN",
"LDAP Admin User" => "نام كاربري سرپرست LDAP",
"LDAP Admin Pwd" => "كلمه‌ي عبور سرپرست LDAP",
"CAS server hostname" => "نام سرور ميزبان CAS",
"CAS server port" => "درگاه سرور CAS",
"CAS server path" => "آدرس سرور CAS",
"Change CAS preferences" => "تنظيمات CAS را اعمال كن",
"Meta Keywords" => "كليدواژه",
"Meta Description" => "فرا شرح(meta desc)",
"Meta Author" => "مؤلف",
"Geourl" => "آدرس جغرافيايي",
"meta robots" => "دستگاه خودكار",
"revisit after" => "مشاهده‌ي مجدد بعد از",
"Allow Smileys" => "استفاده از صورتك‌ها(Smiley) مجاز است",
"Hotwords in New Windows" => "واژگان آتشين در صفحات جديد",
"Trackers attachments preferences" => "تنظيمات ضمايم Trackerها",
"Trackers attachments" => "ضمايم trackerها",
"Create a Tag for the Current Wiki" => "براي ويكي كنوني يك برچسب درست كن",
"Restore the Wiki" => "بازگرداني(restore) ويكي",
"restore" => "برگردان",
"Remove a Tag" => "حذف يك برچسب",
"Wiki Comments Settings" => "تنظيمات 'نظرات' ويكي",
"Wiki Administration" => "مديريت ويكي",
"Wiki Home Page" => "صفحه‌ي مبدا ويكي",
"Wiki Discussion" => "مناظره‌ي ويكي",
"Wiki Link Format" => "شكل پيوندهاي ويكي",
"Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "از دو پرانتز براي تشخيص دنباله‌هاي ويكي استفاده مي‌شود <i>((نام صفحه))</i>.",
"Wiki Features" => "خصيصه‌هاي ويكي",
"Wiki History" => "تارخچه‌ي ويكي",
"Wiki Watch" => "ديده‌بان ويكي",
"Admin Charts" => "نمودارهاي سرپرست",
"Add new rule" => "افزودن قانون جديد",
"EMail notifications" => "آگاه‌ساز‌هاي پست الكترونيكي‌اي",
"Edit this RSS module:" => "اين ماژول RSS را ويرايش كن",
"Create new RSS module" => "يك ماژول جديد RSS ايجاد كن",
"Tikiwiki settings" => "تنظيمات تيكي‌ويكي",
"Create/edit questions for survey" => "ساخت/ويرايش سئوال براي نظرسنجي‌",
"Active?" => "فعال؟",
"Create Trackers" => "ايجاد trackerها",
"Create/Edit Trackers" => "ايجاد/ويرايش trackerها",
"Create item" => "ايجاد فقره",
"Assign to Groups" => "انتصاب به گروه‌ها",
"Delete this type" => "حذف اين نوع",
"Browse gallery" => "مرور سرسرا",
"Upload from disk" => " بارگذاري از دستگاه",
"Browsing Image" => "مرور تصوير",
"Again please" => "دوباره لطفا",
"Admin category relationships" => "مديريت ارتباط طبقات",
"Validate links" => "تاييد اعتبار پيوندها",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "پرونده‌هايي كه با -{\$user} آغاز مي‌شوند، قابل تغيير هستند، باقي تنها قابل كپي‌كردن و استفاده به عنوان مدل هستند.",
"Im- Export Languages" => "واردات، صادرات زبان‌ها",
"disable" => "غيرفعال شده‌است",
"Create a file gallery" => "ايجاد يك سرسراي پرونده",
"Support tickets" => "بليط‌هاي پشتيباني",
"Return to HomePage" => "بازگشت به صفحه‌ي مبدا",
"Stats for this survey Questions " => "آمار اين نظرسنجي",
"SysLog" => "ثبت وقايع",
"Batch upload" => " بارگذاري دسته‌اي(Batch upload)",
"1 suggestion" => "1 پيشنهاد",
"suggestions" => "پيشنهاد",
"Minor Edit" => "كوچك",
"You can not download files" => "شما نمي‌توانيد پرونده دريافت كنيد",
"cannot be found" => "پيدا نشد",
"Invalid password.  Your current password is required to change administrative information" => "كلمه‌ي عبور نامعتبر. براي تغيير اطلاعات سرپرستي كلمه‌ي عبور كنوني شما مورد نياز است",
"Please wait 2 minutes between posts" => "لطفا بين هر دو الصاق، 2دقيقه صبر كنيد‌",
"hr" => "hr",
"The text in RED is" => "متن قرمز عبارتست از",
"Show Categories" => "طبقات را نمايش بده",
"Hide Categories" => "طبقات را مخفي كن",
"Wiki page %s changed" => "صفحه‌ي %s ويكي تغيير كرده است",
"Blog features" => "خصيصه‌هاي بلاگ",
"Blog level comments" => "دسترسي براي دادن نظر(comment) در سطح بلاگ‌",
"Post level comments" => "دسترسي براي دادن نظر(comment) در سطح هر الصاق",
"Trackbacks Pings" => "pingهاي trackbackها",
"Post level trackback pings" => "pingهاي مسيريابي معكوس در سطح هر الصاق",
"Spellchecking" => "بررسي املايي",
"Default ordering for blog listing" => "ترتيب پيش‌فرض در فهرست بلاگ‌ها",
"Blog listing configuration (when listing available blogs)" => "پيگربندي فهرست بلاگ(در بلاگ‌هاي قابل فهرست شدن)",
"Last modification time" => "زمان آخرين تغييرات",
"Blog comments settings" => "تنظيمات 'نظرات' بلاگ",
"Group calendar sticky popup" => "popupهاي پسبان تقويم را در گروه قرار بده",
"Group calendar item view tab" => "برگ مشاهده‌ي اقلام تقويم را گروه‌‌بندي كن",
"Calendar manual selection of time/date" => "انتخاب دستي زمان/تاريخ تقويم",
"Show Category Path" => "آدرس طبقه را نشان بده",
"Show Category Objects" => "اشياء طبقه را نمايش بده",
"Search may show forbidden results. Much better performance though." => "جستجو شامل موارد ممنوع هم باشد. كارايي به شدت افزايش مي‌يابد",
"CMS features" => "خصيصه‌هاي سامانه‌ي مديريت محتوا(CMS)",
"Use templates" => "از الگوها استفاده كن",
"Print article" => "امكان چاپ مقالات",
"Settings for page articles home" => "تنظيمات صفحه‌ي مبدا مقالات",
"Maximum number of articles in home" => "بيشينه تعداد مقالات در صفحه‌ي مبدا",
"Article comments settings" => "تنظيمات مربوط 'نظرات' مقالات",
"Fields to display on page" => "موارد نمايش داده شده در صفحه‌ي ",
"Expire Date" => "تاريخ انقضا",
"Copyright Management" => "مديريت حق چاپ",
"License Page" => "صفحه‌ي پروانه",
"Submit Notice" => "اخطار ارائه شود",
"Uploaded filenames cannot match regex" => "نام پرونده‌هاي بارگذاري شده نبايد با اين اصطلاح همخواني داشته باشد",
"File galleries comments settings" => "تنظيمات 'نظرات' سرسراهاي پرونده‌ها",
"File galleries search indexing" => "ساخت راهنماي جستجوي سرسراهاي پرونده‌ها",
"Leave command blank to delete handler" => "خط فرمان را براي حذف handler، خالي بگذاريد",
"Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => " از %1 براي جابگزيني نام پرونده‌هاي دروني استفاده كنيد (مثال: براي تبديل سند به متن با كمك دستور unix، از اين فرمان استفاده كنيد: \"strings %1\")",
"Enable auto indexing on file upload or change" => "راهنماي جسنجو(indexing) براي پرونده‌هاي بارگذاري شده يا تغيير كرده فعال باشد",
"System command" => "فرمان",
"Home Forum" => "مبدا انجمن‌ها",
"Forums features" => "خصيصه‌هاي انجمن‌ها",
"Forum quick jumps" => "پرش سريع(quick jump) در انجمن",
"Ordering for forums in the forum listing" => "ترتيب انجمن‌ها در فهرست انجمن‌ها",
"Forum listing configuration" => "پيكربندي فهرست انجمن‌ها",
"I18n setup" => "برپاسازي i18n",
"Show Babelfish Translation URLs" => "از URLهاي ترجمه‌ي Babelfish استفاده كن",
"Show Babelfish Translation Logo" => "از نماد ترجمه‌ي Babelfish استفاده كن",
"Show Module Controls" => "كنترل‌هاي ماژول‌ها را نمايش بده",
"Users can Configure Modules" => "كاربر مي‌تواند ماژول‌ها را پيكربندي كند",
"Users can Shade Modules" => "كاربران مي‌توانند ماژول‌ها را زير و بم كنند",
"module decides" => "بنا به ماژول",
"Allow Anonymous Poll Voting" => "كاربران بي‌نام هم اجازه‌ي راي‌دادن دارند",
"seconds (0 = cache inactive)" => "ثانيه (0 معادل غيرفعال است) ",
"Performance issues" => "موارد كارايي",
"Search features" => "خصيصه‌هاي جستجو",
"SearchStats" => "آمار جستجو",
"Settings for searching content" => "تنظيمات محتواي جستجو",
"Search refresh rate" => "نرخ تازه‌كردن جستجو",
"this survey stats" => "وضعيت اين نظرسنجي‌",
"bold" => "پررنگ",
"italic" => "مورب",
"underline" => "زيرخط دار",
"Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"./setup.sh\" for example)." => "آپاچي(Apache) اجازه‌ي نوشتن در پرونده‌هاي شما را دارد، كه اين امر نصب، حذف و به‌روز رساني بسته‌ها را ممكن مي‌سازد. هنگامي كه كار شما با اين اعمال به پايان رسيد، به‌خاطر داشته باشيد كه حقوق دسترسي مربوط را به حالت امن برگردانيد(مثلا با استفاده از \"./setup.sh\")",
"To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"./setup.sh open\" to set it up). After installation you need to remove that permission (using \"./setup.sh\")." => "به منظور نصب، حذف و به‌روز رساني بسته‌ها بايد به آپاچي(Apache) اجازه‌ي نوشتن در پرونده‌هاي خود را بدهيد.(مي‌توانيد از \"./setup.sh open\" بهره بگيريد). پس از نصب، بايد اين دسترسي را از اين كاربر صلب كنيد.(مثلا با استفاده از \"./setup.sh\")",
"You have {\$unread} unread private messages" => "شما {\$unread} عدد پيغام نخوانده‌ي شخصي داريد",
"unread private messages" => "پيغام شخصي خوانده نشده",
"This module requires parameters trackerId and name set" => "اين ماژول نياز به تنظيم پارامترهاي trackerid و name دارد",
"you or someone registered this email address at" => "شما يا شخص ديگري اين آدرس پست الكترونيكي را در اين‌جا ثبت كرده است:",
"Your Tiki information registration" => "اطلاعات ثبت‌نام تيكي شما",
"Your registration" => "اطلاعات ثبت‌نام تيكي شما",
"left/right" => "چپ/راست",
"Unassign module" => "ماژول تخصيص داده نشده",
"home" => "مبدا",
"chat" => "گپ‌زني(chat)",
"contact us" => "تماس با ما",
"debugger console" => "ميزكار اشكال زدايي",
"MyMenu" => "فهرست‌هاي انتخاب من",
"User menu" => "منوي كاربر",
"WfMenu" => "منوي WF",
"WikiMenu" => "منو ويكي",
"dump" => " تخليه(dump)",
"rankings" => "رتبه‌بندي‌ها",
"orphan pages" => "صفحات يتيم",
"sandbox" => "دست‌گرمي",
"received pages" => "صفحات دريافت شده",
"structures" => "ساختارها",
"GalMenu" => "منوي سرسراها",
"Articles Home" => "مبدا مقالات",
"Send articles" => "مقالات را بفرست",
"Create/Edit Blog" => "ساخت/ويرايش بلاگ‌",
"ForMenu" => "منوي انجمن",
"DirMenu" => "منوي پوشه",
"Browse Directory" => "مرور پوشه(شايدم پوشه‌ي مرور!)",
"FileGalMenu" => "منوي سرسراي پرونده",
"Admin FAQs" => "مديريت سئوالات متداول",
"Edit mapfiles" => "ويرايش پرونده‌هاي نقشه",
"QuizMenu" => "منوي آزمون",
"Admin quiz" => "مديريت آزمون‌ها",
"TrkMenu" => "منوي tracker",
"Admin trackers" => "مديريت trackerها",
"SrvMenu" => "منوي نظرسنجي",
"Send newsletters" => "ارسال خيرنامه‌ها",
"Send events" => "رويدادهاي را بفرست",
"Admin events" => "مديريت رويدادها",
"EphMenu" => "منوي سالمانه",
"Ephemerides" => "سالنامه",
"ChartMenu" => "فهرست نمودار",
"AdmMenu" => "منو سرپرست",
"Admin home" => "مديريت",
"Backups" => "پشتيبان‌گيري",
"Edit languages" => "ويرايش زبان‌ها",
"External wikis" => "ويكي‌هاي خارجي",
"Mods Admin" => "مديريت ماژول‌ها",
"UsrMenu" => "منو كاربر",
"Click here to manage your personal menu" => "براي مديريت منو شخصي خود، اين‌جا را كليك كنيد.",
"Quick edit a Wiki page" => "ويرايش سريع يك صفحه‌ي ويكي",
"Language: " => "زبان: ",
"Sort posts by:" => "الصاق‌ها را براين اساس مرتب كن:",
"read more" => "اطلاعات بيشتر",
"Pass" => "كلمه عبور",
"System Admin" => "مديريت سامانه",
"Displays an miniquiz" => "يك نيم‌چه آزمون نمايش مي‌دهد",
"some text" => "برخي متون",
"Creates a box with the data" => "يك جعبه با داده بساز",
"creates a title bar" => "يك ميله‌ي عنوان مي‌سازد",
"creates a table" => "يك جدول مي‌سازد",
"makes a horizontal rule" => "يك قانون افقي ايجاد كن",
"page|desc" => "صفحه|توضحيات",
"displays an image" => "يك تصوير نمايش مي‌دهد",
"Non cacheable images" => "تصاوير غيرقابل Cache شدن",
"height width desc link and align are optional" => "پيوند توضيحات ارتفاع و عرض صف كردن‌ها اختياري‌اند",
"displays rss feed with id=n maximum=m items" => "تغذيه‌هاي RSS اي كه شناسه‌اش برابر n و حداكثر m فقره است را نمايش مي‍دهد",
"Will be replaced by the actual value of the dynamic content block with id=n" => "به‌وسيله‌ي بلاك محتواي پويا با شناسه‌ي برابر n جايگزين خواهد شد",
"\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" فهرست محتويات صفحه‌ي جاري را مبني بر ساختار ()toc يا سرصفحه‌ي (maketoc) چاپ خواهد كرد.",
"Misc" => "متنوع",
"/" => "/",
"This instance of activity is already complete" => "اين نمونه از فعاليت هم‌اكنون تكميل شده است‌‌‌",
"Fatal error: cannot execute automatic activity \$activityId" => "يك خطاي مهلك رخ داد: نمي‌توانم فعاليت خودكار \$activityId را اجرا كنم.",
"Fatal error: setting next activity to an unexisting activity" => "يك خطاي مهلك رخ داد: سعي در قرار دادن فعاليتي كه وجود ندارد به عنوان فعاليت بعدي.",
"Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "يك خطاي مهلك رخ داد: در مسيريابي خودكار فعاليع‌ها، هيچ نامزد مناسبي به عنوان فعاليت بعدي(nextActivitu) پيدا نشد.",
"Fatal error: non-deterministic decision for autorouting activity" => "يك خطاي مهلك رخ داد: تصميم غيرقطعي براي فعاليت مسيريابي خودكار",
"Fatal error: trying to send an instance to an activity but no transition found" => "يك خطاي مهلك رخ داد: هنگام تلاش براي ارسال يك نمونه به يك فعاليت، هيچ تراكنشي يافت نشد.",
"Cannot add transition only split activities can have more than one outbound transition" => "نمي‌توانم تراكنش را اضافه كنم. تنها فعاليت‌هاي انشعابي(split) مي‌توانند بيش از يك تراكنش خروجي داشته باشند.",
"Circular reference found some activity has a transition leading to itself" => "حلقه‌ي بازگشتي پيدا شد. برخي از فعاليت‌ها تراكنشي دارند كه به خود آن‌ها باز مي‌گردد!",
"Process does not have a start activity" => "فرايند، فعاليت آغازين ندارد!",
"Process does not have exactly one end activity" => "فرايند بايد تنها يك تراكنش پاياني داشته باشد!",
"End activity is not reachable from start activity" => "فعاليت پاياني از طريق فعاليت آغازين قابل دسترس نيست!",
"is interactive but has no role assigned" => "تعاملي است، اما هيچ قانوني به آن تخصيص داده نشده است!",
"is non-interactive and non-autorouted but has no role assigned" => "غيرتعاملي وبا مسيريابي دستي(غير خودكار) است اما هيچ قانوني به آن تخصيص داده نشده است!",
"is standalone but has transitions" => "خودمختار(standalone) است اما شامل تراكنش شده است!",
"Role" => "قانون",
"is not mapped" => "نگاشت نشده است.",
"Activity '.\$res['name'].' is standalone and is using the \$instance object" => "فعاليت '.\$res['name'].' خودمختار است و از شيئ \$instance بهره مي‌گيرد.",
"Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "فعاليت '.\$res['name'].' تعاملي است و بايد ازاسلوب \$instance->complete() استفاده كند.",
"Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "فعاليت غيرتعاملي‌است لذا نبايد از اسلوب استفاده كند",
"Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "فعاليت '.\$res['name'].' انتخاب(switch) شده‌است لذا بايد از اسلوب \$instance->setNextActivity(\$actname) استفاده كند.",
"Process %d has been activated" => "فرايند %d فعال شد",
"Process %d has been deactivated" => "فرايند %d غيرفعال شد",
"Process %s removed" => "فرايند %s حذف شد",
"Process %s has been updated" => "فرايند %s بروز رساني شد",
"Process %s has been created" => "فرايند %s فعال شد",
"<return> for rows" => "\\n براي ستون‌ها",
"Any 2 versions" => "هر 2 نسخه",
"latin" => "لاتين",
"english" => "انگليسي",
"Report all errors except notices" => "بجز آگاه‌سازها(Notices)، تمام خطاها را گزارش بده",
"1 day" => "1 روز",
"1 week" => "1 هفته",
"1 month" => "1 ماه",
"Just Tiki" => "فقط تيكي",
"Tiki and PEAR::Auth" => " تيكي و تصديق هويت كمكي",
"choose a group ..." => "يك گروه انتخاب كنيد...",
"%s enabled" => "%s فعال شد",
"%s disabled" => "%s غيرفعال شد",
"Charts" => "نمودارها",
"Forums last topics" => "آخرين عناوين انجمن‌ها",
"An error occured in a database query!" => "خطايي در يكي از درخواست‌ها به بانك اطلاعاتي رخ داد!",
"games" => "بازي‌ها",
"Altering database table failed" => "دگرگون‌سازي(Altering) جدول بانك اطلاعاتي ناموفق بود",
"Insert a division block on wiki page" => "يك بلاك تقسيم در صفحه‌ي ويكي قرار بده",
"drawing not found" => "نقاشي پيدا نشد",
"heads and cells separated by ~|~" => "راس‌ها و سلول‌ها با  ~|~ از هم جدا مي‌شوند",
"Please provide an Id" => "لطفا يك شناسه فراهم كنيد",
"Quicktags" => "تگ‌هاي سريع",
"Listing configuration" => "پيكربندي فهرست‌سازي",
"best regards" => "با احترام",
"your Tikiwiki" => "تيكي-ويكي شما",
"Tiki User Registration Request" => "درخواست عضويت كاربر در تيكي",
"Tiki email notification" => "آگاه‌ساز پست الكترونيكي تيكي",
"Your Tiki account information for %s" => "اطلاعات حساب تيكي شما براي %s",
"New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "الصاق جديد در بلاگ: {\$mail_title}, \"{\$mail_post_title}\", به‌وسيله‌ي {\$mail_user} در {\$mail_date|tiki_short_datetime}",
"QuickTags" => "تگ‌هاي سريع",
"TikiWiki Assistant" => "دستيار تيكي‌ويكي",
"Recently visited pages" => "صفحاتي كه به تازگي روئيت شده‌اند",
"Last `\$module_rows` Sites" => "آخرين پايگاه‌هاي `\$module_rows`",
"Last Sites" => "آخرين پايگاه‌ها",
"Directory Stats" => "آمار پوشه",
"Sites to validate" => "پايگاهي كه بايد تعيين اعتبار شود",
"Visited links" => "پيوندهاي مشاهده شده",
"Top \$module_rows Sites" => "\$module_rows پايگاه برتر",
"Top Sites" => "پايگاه‌هاي برتر",
"Top `\$module_rows` topics" => "موضوعات `\$module_rows` فوقاني",
"Last `\$module_rows` forum posts" => "آخرين `\$module_rows` الصاق انجمن",
"Last `\$module_rows` forum topics" => "آخرين `\$module_rows` موضوعات انجمن",
"Last `\$module_rows` actions" => "آخرين `\$module_rows` عمل",
"Last `\$module_rows` articles" => "آخرين `\$module_rows` مقاله",
"Last articles" => "آخرين مقالات",
"Last `\$module_rows` blog posts" => "آخرين `\$module_rows` الصاق بلاگ",
"Last `\$module_rows` Created blogs" => "آخرين `\$module_rows` بلاگ‌ها ساخته شده",
"Last `\$module_rows` Created FAQs" => "آخرين `\$module_rows` FAQي ايجاد شده",
"Last `\$module_rows` Created Quizzes" => "آخرين `\$module_rows` آزمون ايجاد شده",
"Last `\$module_rows` modified file galleries" => "آخرين `\$module_rows` سرسراي پرونده‌ي تغيير يافته",
"Last `\$module_rows` Files" => "`\$module_rows` پرونده‌ي آخر",
"Last `\$module_rows` galleries" => "`\$module_rows` سرسراي آخر",
"Last galleries" => "آخرين سرسراها",
"Last `\$module_rows` Images" => "`\$module_rows` تصوير آخر",
"Last `\$module_rows` modified events" => "آخرين `\$module_rows` رويداد تغيير كرده",
"Last `\$module_rows` changes" => "`\$module_rows` تغيير آخر",
"Last `\$module_rows` Modified Items" => "آخرين `\$module_rows` اقلام تغيير كرده",
"Last `\$module_rows` Modified blogs" => "آخرين `\$module_rows` بلاگ تغيير كرده‌",
"Last `\$module_rows` submissions" => "`\$module_rows` ارائه‌ي آخر",
"Last `\$module_rows` Items" => "`\$module_rows` فقره‌ي آخر",
"Menu" => "منو",
"New Messages" => "پيغام‌هاي جديد داريد",
"New Message" => "پيغام جديد داريد",
"Top `\$module_rows` articles" => "`\$module_rows` مقاله‌ي برتر",
"Top `\$module_rows` File Galleries" => "`\$module_rows` سرسراي پرونده‌ي برتر",
"Top `\$module_rows` files" => "`\$module_rows` پرونده‌ي برتر",
"Top `\$module_rows` Forum Posters" => "`\$module_rows` آگهي برتر انجمن",
"Top `\$module_rows` games" => "`\$module_rows` بازي برتر",
"Top games" => "بازي‌هاي برتر",
"Top `\$module_rows` galleries" => "Top `\$module_rows` Galleries",
"Top `\$module_rows` Images" => "`\$module_rows` تصوير برتر",
"Top `\$module_rows` Pages" => "`\$module_rows` صفحات برتر",
"Top `\$module_rows` Quizzes" => "`\$module_rows` آزمون برتر",
"Most `\$module_rows` visited blogs" => "بيشترين `\$module_rows` بلاگ‌هاي ديده‌شده",
"Top `\$module_rows` Visited FAQs" => "`\$module_rows` FAQ پربيننده",
"Whats related" => "What's related",
"Last `\$module_rows` wiki comments" => "`\$module_rows` نظر آخرين ويكي",
"show structures" => "ساختارها را نمايش بده",
"hide structures" => "ساختارها را پنهان كن",
"Creation date" => "تاريخ ايجاد",
"My workflow" => "جريان كاري من",
"Feature" => "خصيصه",
"Number of columns per page when listing categories" => "تعداد ستون‌ها در هر صفحه هنگام نمايش فهرست طبقه‌بندي‌ها",
"enable cool sites" => "پايگاه‌هاي بامزه فعال باشد",
"Featured Help" => "كمك خاص",
"JsCalendar" => "تقويم js",
"PhpLayers Dynamic menus" => "منو پوياي لايه‌هايPHP",
"Tiki Sheet" => "صفحات تيكي",
"Drawings" => "نقاشي‌ها",
"Games" => "بازي‌ها",
"Administration Features" => "خصيصه‌هاي مديريتي",
"Banning System" => "سامانه‌ي تحريم‌",
"User Features" => "خصيصه‌هاي كاربران",
"Newsreader" => "اخبارگو",
"Workflow" => "گردش كار",
"Workflow engine" => "موتور گردش كار",
"Unix" => "يونيكس(Unix)",
"Windows" => "ويندوز(Windows)",
"Unknown/Other" => "نامشخص يا غيره",
"(standard)" => "(استاندارد)",
"(some Unix MTA)" => "(برخي از MTAهاي يونيكس)",
"Tikiwiki.org help" => "كمك در tikiwiki.org",
"Store session data in database" => "اطلاعات session را در بانك اطلاعاتي نگه‌دار",
"Long date format" => "شكل تاريخ طويل",
"Short date format" => "شكل تاريخ كوتاه",
"Long time format" => "شكل زمان طويل(long time)",
"Short time format" => "شكل زمان كوتا(short time)",
"New password" => "كلمه‌ي عبور جديد",
"You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :" => "براي اين پايگاه احتياج به درخواست يك 'كليد نقشه‌ي گوگل' داريد. به سادگي مي‌توانيد براي اين domain يكي در اين آدرس تهيه كنيد:",
"Google Map Key" => "كليد نقشه گوگل",
"PEAR::Auth" => "تصديق هويت كمكي",
"HTTP port" => "درگاه HTTP",
"HTTPS port" => "درگاه HTTPS",
"PAM service" => "خدمات PAM",
"CAS server version" => "نسخه‌ي سرور CAS",
"Reg users can change theme" => "كاربران ثبت‌نام كرده، مي‌توانند قيافه(theme)ي خود را تغيير دهند",
"Slideshows theme" => "قيافه(Theme) نمايش اسلايدها",
"Template Viewing" => "مشاهده‌ي الگوها",
"Site logo background color" => "رنگ پيش‌ضمينه‌ي نماد پايگاه",
"Site logo title (on mouse over)" => "عنوان نماد پايگاه (هنگام اشاره‌ي موش‌واره)",
"Site Breadcrumbs" => "خرده نان‌هاي پايگاه",
"at top of page" => "بالاي صفحه",
"at top of center column" => "بالاي ستون مركزي",
"entire location" => "تمام محل",
"page name" => "نام صفحه",
"Default RDF version" => "نسخه‌ي پيش‌فرض RDF",
"Editor" => "ويراستار",
"Webmaster" => "كارفرماي وب(webmaster)",
"hits" => " ضربت‌ها(Hits)",
"Individual cache" => "cache تك-تك",
"Perms inherited from closest parent if possible or from global perms" => "درصورت امكان، حقوق دسترسي از نزديك‌ترين والد به ارث مي‌رسد، وگرنه از حقوق دسترسي‌هاي عمومي",
"Assign permissions automatically" => "حقوق دسترسي را به‌صورت خودكار اختصاص بده",
"recommended for best performance" => "براي دستيابي به بهترين عملكر، پيشنهاد مي‌شود",
"image gal" => "سرسراي تصوير",
"file gal" => "سرسراي پرونده",
"Admin chart items" => "مديريت اقلام نمودارها",
"Edit Chart" => "ويرايش نمودار",
"Chart items" => "اقلام نمودار",
"No items defined yet" => "هنوز هيچ فقره‌اي تعريف نشده است.",
"Add or edit a chart" => "افزوردن يا تغيير يك نمودار",
"Users can vote for only one item from this chart per period" => "كاربران مي‌توانند در هر دوره تنها به يك قلم از اين نمودار راي دهند",
"Prevent users from voting for the same item more than once" => "از راي دادن بيش از يك‌بار كاربران به يك قلم جلوگيري كن",
"Users can suggest new items" => "كاربران مي‌توانند قلم جديدي را پيشنهاد كنند",
"Auto validate user suggestions" => "اعتبار پيشنهادات كاربران را به صورت خودكار كنترل كن",
"Ranking shows" => "نمايش رتبه بندي‌ها",
"All items" => "تمام اقلام",
"Top 10 items" => "10 قلم برتر",
"Top 20 items" => "20 قلم برتر",
"Top 40 items" => "40 قلم برتر",
"Top 50 items" => "50 قلم برتر",
"Top 100 items" => "100 قلم برتر",
"Top 250 items" => "250 قلم برتر",
"Voting system" => "سامانه‌ي راي گيري",
"Vote items" => "اقلام راي",
"Rank 1..5" => "امتياز 5..1 ",
"Rank 1..10" => "امتياز 10..1",
"Ranking frequency" => "تناوب امتيازدهي",
"Realtime" => "در لحظه",
"Each 5 minutes" => "هر 5 دقيقه",
"Show Average" => "متوسط را نمايش بده",
"Show Votes" => "راي‌ها را نمايش بده",
"Use Cookies for unregistered users" => "كوكي‌هاي كاربران ثبت‌نام نكرده را نمايش بده",
"Users can vote again after" => "بعد از چه مدت كاربران مي‌توانند مجدداد راي دهند؟",
"Anytime" => "مهم نيست",
"Ranks" => "امتيازها",
"No charts defined yet" => "هنوز هيچ نموداري تعريف نشده است",
"Admin drawings" => "مديريت Drawings",
"Available drawings" => "نقاشي‌هاي موجود",
"Ver" => "نسخه",
"no display" => "هيچ",
"Available polls" => "راي‌گيري‌هاي موجود",
"Random image from" => "تصوير تصادفي از",
"Dynamic content blocks" => "بلوك محتواي پويا",
"phpLayersMenus" => "فهرست‌هاي لايه‌اي PHP",
"Banner zones" => "قلمرو درفش‌ها(Banner Zones)",
"Group users" => "كاربران گروه",
"Admin Quicktags" => " مديريت تگ‌هاي سريع ",
"Create/Edit QuickTags" => "ايجاد/ويرايش تگ‌هاي سريع",
"Insert (use 'text' for figuring the selection)" => "درج (از 'متن' براي مشخص كردن محدوده‌ انتخاب استفاده كنيد)",
"Path to the tag icon" => "مسير تمثال برچسب",
"Admin RSS Modules" => "مديريت ماژول RSS",
"show feed title" => "عنوان تغذيه را نمايش بده",
"show publish date" => "تاريخ انتشار را نمايش بده",
"Templates compiler" => "گردآوري كننده‌ي الگوها",
"Compile" => "گردآوري كن(compile)",
"Member of the default group of creator can modify items?" => "اعضاي گروه پيش‌فرض كاربران ايجاد كننده مي‌توانند اقلام را ويرايش كنند؟",
"Group Homepage" => "صفحه‌ي مبدا گروه‌",
"Members List" => "فهرست اعضا",
"Rejected users" => "كاربران رد اعتبار شده",
"Edit Account Settings" => "ويرايش تنظيمات حساب كاربر",
"Set the default group of the selected users to" => "گروه پيش‌فرض كاربران منتخب را به اين گزينه تنظيم كن",
"Default Group" => "گروه پيش‌فرض",
"Old password" => "كلمه‌ي عبور قبلي",
"Parent category" => "طبقه‌ي مادر",
"Most visited sub-categories" => "پر بيننده‌ترين زيرطبقات",
"Category description" => "شرح طبقه",
"Random sub-categories" => "زيرطبقات تصادفي",
"Allow sites in this category" => "پايگاه‌ها در اين طبقه مجازند",
"Show number of sites in this category" => "تعداد پايگاه‌ها در اين طبقه را نمايش بده",
"Subcategories" => "زيرطبقات",
"Admin related categories" => "مديريت طبقات مرتبط",
"Add a related category" => "افزودن يك طبقه‌ي مرتبط",
"Related categories" => "طبقات مرتبط",
"Add a Category" => "اضافه كردن يك طبقه",
"in current category" => "در بين طبقه‌ي جاري",
"Total categories" => "مجموع طبقهها",
"table" => "جدول",
"table new" => "جدول جديد",
"external link" => "پيوند خارجي",
"wiki link'" => "پيوند ويكي'",
"heading1" => "سرصفحه‌ي 1",
"title bar" => "نوار عنوان",
"box" => "جعبه",
"rss feed" => "تعذيه‌ي RSS",
"dynamic content" => "محتواي پويا",
"tagline" => "خط برچسب(tagline)",
"center text" => "متن در وسط",
"colored text" => "متن رنگي",
"dynamic variable" => "متغيير پويا",
"New wms Metadata" => "فراداده‌ي WMS جديد",
"New Class" => "كلاس جديد",
"New Projection" => "افكنش جديد",
"New Query" => "درخواست جديد",
"New Scalebar" => "نوار مقياس جديد",
"New Layer" => "لايه‌ي جديد",
"New Label" => "برچسب جديد",
"New Reference" => "مرجع جديد",
"New Legend" => "فهرست علائم جديد",
"New Web" => "وب جديد",
"New Outputformat" => "شكل خروجي جديد",
"New Mapfile" => "پرونده‌ي نقشه‌ي جديد",
"special chars" => "حروف خاص",
"special characters" => "حروف خاص",
"Questions per page" => "تعداد سئوالات در هر صفحه",
"Activity completed" => "فعاليت به اتمام رسيد",
"Admin process activities" => "مديريت فعاليت‌هاي فرايند",
"Add or edit an activity" => "افزودن يا ويرايش يك فعاليت",
"activity" => "فعاليت",
"split" => "انشعاب",
"join" => "اتصال",
"standalone" => "خودمختار",
"interactive" => "تعاملي",
"auto routed" => "خودمسيرياب است",
"Expiration Time" => "تاريخ انقضا",
"Years" => "سال",
"Months" => "ماه",
"Minutes" => "دقيقه",
"Add transitions" => "افزودن تراكنش",
"Add transition from:" => "تراكنش ها را از اين‌جا اضافه كن:",
"Add transition to:" => "تراكنش‌ها را به اين‌جا اضافه كن:",
"No roles associated to this activity" => "هيچ قانوني به اين فعاليت تخصيص نگرفته است",
"Add Role" => "قانون را اضافه كن",
"Add New" => "جديد",
"Process activities" => "فعاليت‌هاي فرايند",
"Int" => "تعامل",
"Routing" => "مسيريابي",
"Interactive" => "تعاملي",
"Automatic" => "خودكار",
"Auto routed" => "خودكار",
"Manual" => "دستي",
"inter" => "تعامل",
"route" => "مسيريابي",
"(no roles)" => "(بدون قانون)",
"No activities defined yet" => "هنوز هيچ فعاليت تعريف نشده است.",
"Process Transitions" => "تراكنش‌هاي فعاليت",
"List of transitions" => "فهرست تراكنش‌ها",
"Origin" => "سرچشمه",
"No transitions defined yet" => "هنوز هيچ تراكنشي تعريف نشده است.",
"Add a transition" => "افزودن يك تراكنش",
"Process Graph" => "نودار فرايند",
"Galaxia Admin Graph" => "نگار مديريت گالكسي",
"Galaxia Admin Graph tpl" => "الگوي نگار مديريت گالكسي",
"Edit Tpl" => "ويرايش الگو",
"This process is invalid" => "اين فرايند نامعتبر است",
"Process Graph for" => "نگار براي فرايند",
"No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "هيچ نموداري موجود نيست. يا فرايند شامل خطا است و يا نموداري هنوز توليد نشده است و يا <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> به درستي نصب نگرديده است.",
"List of processes" => "فهرست فرايندها",
"Inactive" => "غيرفعال",
"val" => "معتبر؟",
"Active Process" => "فرايندهاي فعال",
"Invalid Process" => "فرايند نامعتبر",
"Valid Process" => "فرايند معتبر",
"Activities" => "فعاليت‌ها",
"New Minor" => "كهاد جديد",
"New Major" => "مهاد جديد",
"No processes defined yet" => "هنوز هيچ فرايندي تعريف نشده است.",
"Admin instance" => "مديريت نمونه‌ها",
"Process:" => "فرايند",
"Instance" => "نمونه",
"Workitems" => "اقلام كاري",
"exception" => "استثنا",
"completed" => "تكميل شده",
"Send all to" => "ارسال به همه",
"Don't move" => "حركت نكن",
"Act status" => "وضعيت كنش",
"Ended" => "پايان يافته",
"Not Defined" => "تعريف نشده",
"Not Interactive" => "غيرتعاملي",
"Not Ended" => "پايان نپذيرفته",
"Property" => "خاصيت",
"Add property" => "افزودن خصوصيت",
"run instance" => "اجراي نمونه",
"Executed" => "اجرا",
"erase" => "پاكش كن",
"Admin processes" => "مديريت فرايندها",
"Galaxia Admin Processes" => "فرايندهاي مديريت گالكسي",
"Galaxia Admin Processes tpl" => "الگوي فرايندهاي مديريت گالكسي",
"Add or edit a process" => "افزودن يا ويرايش كردن يك فرايند",
"Process Name" => "نام فرايند",
"ver:" => "نگارش:",
"is active?" => "آيا فعال است؟",
"Or upload a process using this form" => "يا به كمك اين ورقه يك فرايند بارگذاري كنيد",
"Admin process roles" => "مديريت قوانين فرايند",
"Add or edit a role" => "ايجاد يا ويرايش يك قانون",
"Process roles" => "قوانين فرايند",
"No roles defined yet" => "هنوز هيچ قانوني تعريف نشده است.",
"Map users to roles" => "نگاشتن كاربران به قوانين",
"map" => "بنگار",
"Map groups to roles" => "نگاشت گروه‌هاي كاربري به قوانين",
"Operation" => "عمل",
"No roles are defined yet so no roles can be mapped" => "هنوز هيچ قانوني تعريف نشده است، لذا هيچ قانوني قابل نگاشت نيست.",
"List of mappings" => "فهرست نگاشت‌ها",
"No mappings defined yet" => "هنوز هيچ نگاشتي تعريف نشده است.",
"Admin process sources" => "مديريت منابع فرايندها",
"select source" => "انتخاب منبع",
"Shared code" => "دستورالعمل(كد)هاي به اشتراك گذاشته شده",
"Set next user" => "تنظيم كاربر بعدي(Set next user)",
"Get property" => "دريافت خصوصيت(Get property)",
"Set property" => "تنظيم خصوصيت(Set property)",
"Process form" => "فرم فرايند",
"Set Next act" => "تنظيم عمل بعدي",
"If:SetNextact" => "اگر:تنظيم‌فعالت‌بعدي",
"Switch construct" => "تعويض ساختار",
"Map process roles" => "نگاشت قوانين فرايند",
"Admin Processes" => "مديريت فرايندها",
"Admin Activities" => "مديريت فعاليت‌ها",
"Admin Roles" => "مديريت قوانين",
"Edit this Process" => "اين فرايند را ويرايش كن",
"Monitor Activities" => "ديده‌باني فعاليت‌ها",
"Galaxia Monitor Activities" => "ديده‌باني فعاليت‌هاي گالكسي",
"Galaxia Monitor Activities tpl" => "الگوي ديده‌باني فعاليت‌هاي گالكسي",
"List of activities" => "فهرست فعاليت‌ها",
"Proc" => "فرايند",
"auto" => "مسيريابي",
"int" => "تعاملي",
"routing" => "خودمسيرياب",
"Instances" => "نمونه‌ها",
"run" => "اجرا",
"run activity" => "اجراي فعاليت",
"Enter the name of this instance" => "نام اين نمونه را وارد كنيد",
"The name is not valid. Please, enter the name again" => "نام معتبر نبود، لطفا مجددا سعي كنيد",
"monitor processes" => "ديده‌باني فرايندها",
"monitor activities" => "ديده‌باني فعاليت‌ها",
"monitor instances" => "ديده‌باني نمونه‌ها",
"monitor workitems" => "ديده‌باني اقلام كاري",
"Monitor Instances" => "ديده‌باني نمونه‌ها",
"Galaxia Monitor Instances" => "ديده‌باني نمونه‌هاي گالگسي",
"Galaxia Monitor Instances tpl" => "ديده‌باني نمونه‌هاي گالگسي",
"List of instances" => "فهرست نمونه‌ها",
"Not ended" => "تمام نشده",
"No instances created yet" => "هيچ نمونه‌اي هنوز ايجاد نشده است.",
"Monitor Processes" => "ديده‌باني فرايندها",
"Galaxia Monitor Processes" => "ديده‌باني فرايندهاي گالكسي",
"Galaxia Monitor Processes tpl" => "الگوي ديده‌باني فرايندهاي گالكسي",
"processes" => "فرايند",
"being run" => "آغاز شده",
"Exceptions" => "استثنا",
"Monitor workitems" => "ديده‌باني اقلام كاري",
"List of workitems" => "فهرست اقلام كاري",
"instance" => "نمونه",
"Instance Id" => "شناسه‌ي نمونه",
"Instance Name" => "نام نمونه",
"Instance Status" => "وضعيت نمونه",
"Elapsed time" => "زمان صرف شده",
"My activities" => "فعاليت‌هاي من",
"Current Activity" => "فعاليت‌هاي جاري",
"Assigned To" => "منصوب به",
"exception instance" => "نمونه‌ي استثنا",
"exceptions instance" => "نمونه‌هاي استثنا",
"Send Instance" => "نمونه را ارسال كن",
"abort instance" => "نمونه را متوقف كن",
"grab instance" => "نمونه را بگير",
"release instance" => "نمونه را رها كن",
"No activities found" => "هيچ فعاليتي يافت نشد.",
"My instances" => "نمونه‌هاي من",
"No instances found" => "هيچ نمونه‌اي يافت نشد.",
"User Activities" => "فعاليت‌هاي كاربر",
"Galaxia User Activities" => "فعاليت‌هاي كاربر گالكسي",
"Galaxia User Activities tpl" => "الگوي فعاليت‌هاي كاربر گالكسي",
"process" => "فرايند",
"No processes defined or activated yet" => "هنوز هيچ فرايندي تعريف ويا فعال نشده است.",
"user processes" => "فرايندهاي كاربر",
"user activities" => "فعاليت‌هاي كاربر",
"user instances" => "نمونه‌هاي كاربر",
"User Instances" => "نمونه‌هاي كاربر",
"Galaxia User Instances" => "نمونه‌ي كاربر Galaxia",
"Galaxia User Instances tpl" => "الگوي نمونه‌هاي كاربر گالكسي",
"Inst Status" => "وضعيت نمونه",
"Not defined" => "تعريف نشده",
"No instances defined yet" => "هنوز هيچ نمونه‌اي تعريف نشده است.",
"User Processes" => "فرايندهاي كاربر",
"Galaxia User Processes" => "فرايندهاي كاربر گالكسي",
"Galaxia User Processes tpl" => "الگوي فرايندهاي كاربر گالكسي",
"Browsing Workitem" => "مرور اقلام كاري",
"Workitem information" => "اطلاعات اقلام كاري",
"Use cache for external pages" => "صفحات خارجي را در حافظه‌ي خود نگه‌دار",
"All games are from" => "تمام بازي‌ها از اين پايگاه هستند:",
"visit the site for more games and fun" => "براي ساير بازي‌ها و سرگرمي‌ها، نگاهي به اون پايگاه بندازيد.",
"Upload a game" => "يك بازي بارگذاري كنيد",
"Upload a new game" => "بارگذاري يك بازي جديد",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "تصويرك (اگر بازي foo.swf باشد، نام تصويرك بايد foo.swf.gif يا foo.swf.png يا foo.swf.jpg شود)",
"Edit game" => "ويرايش بازي",
"Played" => "بازي شده",
"If you can't see the game then you need a flash plugin for your browser" => "اگر نمي‌توانيد بازي را ببينيد، به plugin مربوط به flash براي مرورگر خود نياز داريد",
"Accepted requests" => "درخواست‌هاي پذيرفته شده",
"since" => "از",
"Assigned items" => "اقلام تخصيص داده شده",
"Select news group" => "انتخاب گروه خبري",
"Back to servers" => "بازگشت به سرورها",
"Msgs" => "پيغام‌ها",
"News from" => "اخبار از",
"Back to groups" => "بازگشت به گروه‌ها",
"Save position" => "موقعيت را ذخيره كن",
"Reading article from" => "خوانده مقاله از",
"Back to list of articles" => "بازگشت به فهرست مقالات",
"Newsgroup" => "خبرنامه",
"Configure news servers" => "پيكربندي سرورهاي اخبار",
"Configure Newsreader" => "پيكربندي اخبارگو",
"configure newsreader server tpl" => "الگوي پيكربندي سرور اخبارگو",
"Select a news server to browse" => "يك سرور اخبار گو براي مرور انتخاب كنيد",
"server" => "سرور",
"Read the news" => "مشاهده‌ي اخبار",
"News server" => "سرور اخبار",
"Current permissions for this object" => "حقوق دسترسي كنوني براي اين شيئ",
"No category permissions; global permissions apply" => "بدون حقوق دسترسي طبقه‌اي، حقوق دسترسي عمومي اعمال خواهد شد",
"Replicate" => "تكرار",
"Slave" => "برده",
"Master" => "ارباب",
"Operations" => "اعمال",
"Operations Log" => "وقايع ثبت‌شده‌ي اعمال",
"Tiki Shoutbox" => "فريادگاه تيكي",
"Click to Navigate" => "براي هدايت اين‌جا را كليك كنيد",
"Focus:" => "تمركز:",
"big grin" => "شاد",
"cry" => "گريه",
"eek" => "زكي",
"evil" => "شيطون",
"lol" => "قهقهه",
"mr green" => "آقاي سبز",
"razz" => "شوخ",
"redface" => "صورت صورتي",
"rolleyes" => "با چشماي چرخون",
"smile" => "لبخند",
"surprised" => "متعجب",
"twisted" => "پيچونده شده",
"arrow" => "فلش",
"santa" => "سانتا",
"Current folder" => "پوشه‌ي جاري",
"This user is your friend" => "اين كاربر رفيق شماست",
"Your personal Wiki Page" => "صفحه‌ي شخصي ويكي شما",
"Your personal tracker information" => "اطلاعات tracker شخصي شما",
"Confirm new password" => "كلمه‌ي عبور جديد رو تاييد كنيد",
"Current password (required)" => "كلمه‌ي عبور كنوني(ضروري)",
"Edit Items" => "ويرايش اقلام",
"List Charts" => "فهرست نمودارها",
"Last Chart" => "آخرين نمودار",
"Previous Chart" => "نمودار قبلي",
"Chart created" => "نموادار ايجاد شد",
"Next Chart" => "نمودار بعدي",
"Permanency" => "قطعيت",
"chg" => "تغييرات",
"Avg" => "معدل",
"info/vote" => "مشاهده‌ي اطلاعات/دادن راي",
"Next chart will be generated on" => "نمودار بعدي در اين تاريخ توليد خواهد شد",
"View or vote items not listed in the chart" => "مشاهده يا انتخاب اقلامي كه در اين نمودار نيامده‌اند",
"Select something to vote on" => "موردي را براي راي دادن انتخاب كنيد",
"Item information" => "اطلاعات فقره",
"Dif" => "تعريف",
"Best Position" => "بهترين موقعيت",
"Vote this item" => "ارزش اين فقره",
"Highest" => "بيشترين ارزش",
"RSS settings" => "تنظيمات RSS",
"No chart indicated" => "هيچ نموداري مشخص نشده است.",
"No category indicated" => "هيچ طبقه‌اي مشخص نشده است.",
"Permission denied; you cannot assign permissions for this category" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد براي اين طبقه حقوق دسترسي تعريف كنيد",
"Last sites of directory \".\$rc[\"name\"].\" ." => "آخرين پايگاه‌هاي پوشه‌ي \".\$rc[\"name\"].\" .",
"No process indicated" => "هيچ فرايندي مشخص نشده است.",
"Activity name already exists" => "فعاليتي با اين نام قبلا ايجاد شده است",
"indicates if the process is active. Invalid processes cant be active" => "مشخص مي‌كند كه آيا فرايند فعال است يا خير. فرايندهاي نامعتبر نمي‌توانند فعال شوند",
"No instance indicated" => "هيچ نمونه‌اي مشخص نشده است.",
"No activity indicated" => "هشچ فعاليتي مشخص نشده است.",
"The process name already exists" => "فعاليتي با اين نام قبلا ايجاد شده است",
"Process already exists" => "اين فرايند هم‌اينك وجود دارد",
"You cant execute this activity" => "شما نمي‌توانيد اين فعاليت را اجرا كنيد",
"You couldn't abort a instance" => "شما نمي‌توانيد يك نمونه را متوقف كنيد",
"You couldn't exception a instance" => "نمي‌توانيد يك نمونه را مستثنا كنيد",
"No title indicated" => "هيچ عنواني مشخص نشده است.",
"No comment indicated" => "هيچ نظري مشخص نشده است.",
"No date indicated" => "هيچ تاريخي مشخص نشده است.",
"The game file must have .swf or .dcr extension" => "نام پرونده‌ي بازي بايد پسودي معادل .swf يا .dcr داشته باشد",
"The thumbnail name must be" => "نام تصويرك بايد ",
"Please supply both files" => "لطفا هردو پرونده را فراهم كنيد",
"No server indicated" => "هيچ سروري مشخص نشده است",
"Cannot connect to" => "عدم توانايي در برقراري ارتباط با",
"Missing information to read news (server,port,username,password,group) required" => "اطلاعات لازم براي خواند اخبار مفقود شده است. (سرور، درگاه، نام كاربري، كلمه‌ي عبور و گروه مورد نيازاند)",
"Cannot get messages" => "نمي‌توانم پيغام‌ها را بگيرم",
"A password and your IP address reminder email has been sent " => "پست الكتروينيكي يادآور كلمه‌ب عبور و آدرس IP شما ارسال شد ",
"changed '%s' from '%s' to '%s'" => "'%s' از '%s' به '%s' تغيير كرد",
"Tiki Calendar" => "تقويم تيكي",
"Admin Menu" => "مديريت منو",
"RSS Modules" => "ماژول‌هاي RSS",
"Chat" => "گپ‌زني(chat)",
"Import PHPWiki Dump" => "وارد كردن  PHPWiki Dump",
"Current events" => "رويدادهاي جاري",
"Last `\$module_rows` visitors" => "`\$module_rows` بازديد كننده‌ي آخر",
"Tiki Logo" => "علامت تيكي",
"User informations" => "اطلاعات كاربر",
"Group informations" => "اطلاعات گروه‌ها",
"Email This Post" => "اين الصاق را با پست الكترونيكي بفرست",
"RSS feeds" => "تغذيه‌ي RSS",
"Use titles in blog posts" => "از عنوان در الصاق‌هاي بلاگ استفاده كن",
"Send blog post" => "الصاق بلاگ را بفرست",
"A link to this post was sent to the following addresses:" => "يك پيوند به اين الصاق براي آدرس‌هاي ذيل ارسال شد:",
"Send post to this addresses" => "الصاق را به اين آدرس‌ها بفرست",
"List of email addresses separated by commas" => "فهرست آدرس‌هاي پست الكترونيكي، تفكيك شده با ويرگول",
"Compose Message" => "ايجاد پيغام",
"%s <b>%s</b> successfully deleted." => "%s <b>%s</b> با موفقيت حذف شد.",
"%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> به  %s <b>%s</b> اختصاص يافت",
"%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> از %s <b>%s</b> حذف شد.",
"group <b>%s</b> set as the default group of user <b>%s</b>." => "گروه <b>%s</b> با موفقيت به عنوان گروه پيش‌فرض كاربر <b>%s</b> قرار گرفت.",
"Post recommendation at" => "الصاق توصيه شده در",
"Prevent flooding" => "جلوگيري از طغيان",
"Minimum time between posts" => "حداقل زمان بين الصاق‌ها",
"Moderator user" => "كاربر ناظم",
"Moderator group" => "گروه ناظم",
"Send this forums posts to this email" => "الصاق‌هاي اين انجمن را به اين پست الكترونيكي بفرست",
"Prune unreplied messages after" => "پيغام‌هاي بدون جواب بايد بعد از چند روز هرس(حذف) شوند؟",
"Prune old messages after" => "پيغام‌ها بعد از چند روز قديمي هستند و بايد هرس(حذف) شوند؟",
"POP3 server" => "سرور POP3",
"Max attachment size (bytes)" => "بيشينه حجم ضميمه (بايت)",
"Default ordering for topics" => "ترتيب پيش‌فرض براي موضوعات",
"Topics per page" => "تعداد عنوان در هر صفحه",
"Default ordering for threads" => "ترتيب پيش‌‍فرض براي رگه‌ها",
"Includes" => "شامل",
"Assign Perms to this Group" => "حقوق دسترسي اختصاص يافته به اين گروه",
"Assign permissions to category" => "تخصيص حقوق دسترسي به طبقه ",
"Current permissions for this category" => "دسترسي‌هاي جاري براي اين طبقه",
"Remove from this Category Only" => "تنها از اين طبقه حذفش كن",
"Remove from this Category &amp; all its Children" => "از اين طبقه و طبقات فرزندش حذف كن",
"Assign permissions" => "تخصيص حقوق دسترسي به ",
"to group" => "را به گروه",
"this category &amp; all its children" => "اين طبقه و تمام طبقات فرزندانش",
"this category only" => "تنها اين طبقه",
"Assigning permissions for <b>all children</b> is recommended for best performance." => "تخصيص حقوق دسترسي براي  <b>تمام فرزندان</b> براي رسيدن به بهترين عملكرد پيشنهاد مي‌شود",
"ERROR: you must include a subject or a message at least" => "خطا: بايد حداقل يك موضوع يا متن وارد كنيد",
"Your registration code:" => "كد ثبت‌نام شما:",
"Registration code" => "كد ثبت‌نام",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "For you to vote, cookies must be allowed" => "For you to vote, cookies must be allowed",
// "This forum is flat and doesn't allow replies to other replies" => "This forum is flat and doesn't allow replies to other replies",
// "Copyright management" => "Copyright management",
// "Tiki was unable to retrieve login data from the database " => "Tiki was unable to retrieve login data from the database ",
// "The following error message was returned" => "The following error message was returned",
// "Things to check" => "Things to check",
// "Are your database login credentials correct" => "Are your database login credentials correct",
// "Did you complete the <a href='tiki-install.php' >Tiki Installer" => "Did you complete the <a href='tiki-install.php' >Tiki Installer",
// "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information" => "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information",
// "Uploaded" => "Uploaded",
// "Last editor" => "Last editor",
// "Explorer" => "Explorer",
// "Slideshow" => "Slideshow",
// "Default View" => "Default View",
// "Afghanistan" => "Afghanistan",
// "Aland Islands" => "Aland Islands",
// "Albania" => "Albania",
// "Andorra" => "Andorra",
// "Anguilla" => "Anguilla",
// "Aruba" => "Aruba",
// "Azerbaijan" => "Azerbaijan",
// "Belize" => "Belize",
// "Benin" => "Benin",
// "Bhutan" => "Bhutan",
// "Bosnia and Herzegovina" => "Bosnia and Herzegovina",
// "Botswana" => "Botswana",
// "Bouvet Island" => "Bouvet Island",
// "British Indian Ocean Territory" => "British Indian Ocean Territory",
// "British Virgin Islands" => "British Virgin Islands",
// "Bulgaria" => "Bulgaria",
// "Burkina Faso" => "Burkina Faso",
// "Burundi" => "Burundi",
// "Cambodia" => "Cambodia",
// "Cameroon" => "Cameroon",
// "Cape Verde" => "Cape Verde",
// "Catalan Countries" => "Catalan Countries",
// "Central African Republic" => "Central African Republic",
// "Chad" => "Chad",
// "Christmas Island" => "Christmas Island",
// "Cocos Islands" => "Cocos Islands",
// "Comoros" => "Comoros",
// "Congo" => "Congo",
// "Congo Democratic" => "Congo Democratic",
// "Djibouti" => "Djibouti",
// "Dominica" => "Dominica",
// "Equatorial Guinea" => "Equatorial Guinea",
// "Eritrea" => "Eritrea",
// "Ethiopia" => "Ethiopia",
// "Europe" => "Europe",
// "Falkland Islands" => "Falkland Islands",
// "Faroe Islands" => "Faroe Islands",
// "French Guiana" => "French Guiana",
// "French Southern Territories" => "French Southern Territories",
// "Gabon" => "Gabon",
// "Gambia" => "Gambia",
// "Georgia" => "Georgia",
// "Ghana" => "Ghana",
// "Gibraltar" => "Gibraltar",
// "Greenland" => "Greenland",
// "Grenada" => "Grenada",
// "Guadeloupe" => "Guadeloupe",
// "Guernsey" => "Guernsey",
// "Guinea" => "Guinea",
// "Guinea Bissau" => "Guinea Bissau",
// "Guyana" => "Guyana",
// "Heard Island and McDonald Islands" => "Heard Island and McDonald Islands",
// "Hong Kong" => "Hong Kong",
// "Isle of Man" => "Isle of Man",
// "Jersey" => "Jersey",
// "Kyrgyzstan" => "Kyrgyzstan",
// "Laos" => "Laos",
// "Lesotho" => "Lesotho",
// "Liberia" => "Liberia",
// "Libya" => "Libya",
// "Liechtenstein" => "Liechtenstein",
// "Macao" => "Macao",
// "Macedonia" => "Macedonia",
// "Madagascar" => "Madagascar",
// "Maldives" => "Maldives",
// "Mali" => "Mali",
// "Martinique" => "Martinique",
// "Mauritania" => "Mauritania",
// "Mayotte" => "Mayotte",
// "Moldova" => "Moldova",
// "Monaco" => "Monaco",
// "Mongolia" => "Mongolia",
// "Montenegro" => "Montenegro",
// "Montserrat" => "Montserrat",
// "Myanmar" => "Myanmar",
// "Namibia" => "Namibia",
// "Netherlands Antilles" => "Netherlands Antilles",
// "Niger" => "Niger",
// "Norfolk Island" => "Norfolk Island",
// "Northern Mariana Islands" => "Northern Mariana Islands",
// "North Korea" => "North Korea",
// "Oman" => "Oman",
// "Palau" => "Palau",
// "Palestine" => "Palestine",
// "Philippines" => "Philippines",
// "Pitcairn" => "Pitcairn",
// "Republic of Macedonia" => "Republic of Macedonia",
// "Reunion" => "Reunion",
// "Rwanda" => "Rwanda",
// "Saint Helena" => "Saint Helena",
// "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
// "Saint Lucia" => "Saint Lucia",
// "Saint Pierre and Miquelon" => "Saint Pierre and Miquelon",
// "San Marino" => "San Marino",
// "Sao Tome and Principe" => "Sao Tome and Principe",
// "Senegal" => "Senegal",
// "Serbia" => "Serbia",
// "Seychelles" => "Seychelles",
// "Sierra Leone" => "Sierra Leone",
// "South Georgia and South Sandwich Islands" => "South Georgia and South Sandwich Islands",
// "Sudan" => "Sudan",
// "Svalbard and Jan Mayen" => "Svalbard and Jan Mayen",
// "Swaziland" => "Swaziland",
// "Syria" => "Syria",
// "Tajikistan" => "Tajikistan",
// "Tanzania" => "Tanzania",
// "Timor-Leste" => "Timor-Leste",
// "Togo" => "Togo",
// "Tokelau" => "Tokelau",
// "Tunisia" => "Tunisia",
// "Turkmenistan" => "Turkmenistan",
// "Turks and Caicos Islands" => "Turks and Caicos Islands",
// "Uganda" => "Uganda",
// "United Nations Organization" => "United Nations Organization",
// "United States Minor Outlying Islands" => "United States Minor Outlying Islands",
// "US Virgin Islands" => "US Virgin Islands",
// "Uzbekistan" => "Uzbekistan",
// "Vatican" => "Vatican",
// "Viet Nam" => "Viet Nam",
// "Wallis and Futuna" => "Wallis and Futuna",
// "Western Sahara" => "Western Sahara",
// "World" => "World",
// "Yemen" => "Yemen",
// "MySQL Improved (mysqli). Requires MySQL 4.1+" => "MySQL Improved (mysqli). Requires MySQL 4.1+",
// "MySQL classic (mysql)" => "MySQL classic (mysql)",
// "PostgreSQL" => "PostgreSQL",
// "Email address not valid, test mail not sent" => "Email address not valid, test mail not sent",
// "Email address empty and \"copy\" checkbox not set, test mail not sent" => "Email address empty and \"copy\" checkbox not set, test mail not sent",
// "Test mail from Tiki installer " => "Test mail from Tiki installer ",
// "Tiki version" => "Tiki version",
// "PHP version" => "PHP version",
// "Server" => "Server",
// "Congratulations!\n\nYour server can send emails.\n\n" => "Congratulations!\n\nYour server can send emails.\n\n",
// "Slovene" => "Slovene",
// "Farsi" => "Farsi",
// "Finnish" => "Finnish",
// "Fijian" => "Fijian",
// "Galician" => "Galician",
// "Pijin Solomon" => "Pijin Solomon",
// "Template %s not registered" => "Template %s not registered",
// "Error line: %d" => "Error line: %d",
// "All Day" => "All Day",
// "file gallery" => "file gallery",
// "survey" => "survey",
// "(not registered)" => "(not registered)",
// "You have mistyped the anti-bot verification code; please try again" => "You have mistyped the anti-bot verification code; please try again",
// "Please wait %d seconds between posts" => "Please wait %d seconds between posts",
// "A contribution is mandatory" => "A contribution is mandatory",
// "Invalid Email" => "Invalid Email",
// "Your message has been queued for approval and will be posted after a moderator approves it" => "Your message has been queued for approval and will be posted after a moderator approves it",
// "This forum is locked" => "This forum is locked",
// "This thread is locked" => "This thread is locked",
// "Those comments are locked" => "Those comments are locked",
// "Newsletter subscription information at" => "Newsletter subscription information at",
// "Tiki Link - Insert internal link" => "Tiki Link - Insert internal link",
// "Select a Wiki page to link to" => "Select a Wiki page to link to",
// "Cannot open this file" => "Cannot open this file",
// "The global quota has been reached" => "The global quota has been reached",
// "The quota has been reached in" => "The quota has been reached in",
// "File gallery quota exceeded" => "File gallery quota exceeded",
// "Number of files transfered to the database" => "Number of files transfered to the database",
// "Number of files transfered to the file system" => "Number of files transfered to the file system",
// "Cannot read to this file" => "Cannot read to this file",
// "This is an approximation based on your server memory limit" => "This is an approximation based on your server memory limit",
// "This is the value of your server's PHP '%s' setting" => "This is the value of your server's PHP '%s' setting",
// "You are alerted by the server " => "You are alerted by the server ",
// "You can check the modifications at : " => "You can check the modifications at : ",
// "You are alerted of a change on " => "You are alerted of a change on ",
// "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
// "unlink failed" => "unlink failed",
// "The uploaded file exceeds the upload_max_filesize directive in php.ini" => "The uploaded file exceeds the upload_max_filesize directive in php.ini",
// "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form" => "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form",
// "The uploaded file was only partially uploaded. Please try again" => "The uploaded file was only partially uploaded. Please try again",
// "No file was uploaded" => "No file was uploaded",
// "Missing a temporary folder" => "Missing a temporary folder",
// "Failed to write file to disk" => "Failed to write file to disk",
// "File upload stopped by extension" => "File upload stopped by extension",
// "Invalid file mime type" => "Invalid file mime type",
// "XML file does not validate against the Mediawiki XML schema" => "XML file does not validate against the Mediawiki XML schema",
// "Contributions" => "Contributions",
// "Query point" => "Query point",
// "layer" => "layer",
// "Record" => "Record",
// "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it" => "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it",
// "menu" => "menu",
// "The content retrieved at %s is not a list of mods" => "The content retrieved at %s is not a list of mods",
// "Can't chdir to '%s'" => "Can't chdir to '%s'",
// "%s impossible to remove" => "%s impossible to remove",
// "Description not available" => "Description not available",
// "Module Title" => "Module Title",
// "Title to display at the top of the box" => "Title to display at the top of the box",
// "No box" => "No box",
// "Show only the content" => "Show only the content",
// "Decorations" => "Decorations",
// "Show module decorations" => "Show module decorations",
// "No title" => "No title",
// "Show module title" => "Show module title",
// "Perspective" => "Perspective",
// "Only display the module if in one of the listed perspectives. Semi-colon separated" => "Only display the module if in one of the listed perspectives. Semi-colon separated",
// "Module only applicable for the specified languages. Languages are defined as two character language codes. Multiple values can be separated by semi-colons" => "Module only applicable for the specified languages. Languages are defined as two character language codes. Multiple values can be separated by semi-colons",
// "Module only applicable for the specified sections. Multiple values can be separated by semi-colons" => "Module only applicable for the specified sections. Multiple values can be separated by semi-colons",
// "Page filter" => "Page filter",
// "Module only applicable on the specified page names. Multiple values can be separated by semi-colons" => "Module only applicable on the specified page names. Multiple values can be separated by semi-colons",
// "No Page" => "No Page",
// "Module not applicable on the specified page names. Multiple values can be separated by semi-colons" => "Module not applicable on the specified page names. Multiple values can be separated by semi-colons",
// "Module enabled or disabled depending on the theme. Specified themes can be either included or excluded. Theme names prefixed by \\\"!\\\" are in the exclusion list. Multiple values can be separated by semi-colons" => "Module enabled or disabled depending on the theme. Specified themes can be either included or excluded. Theme names prefixed by \\\"!\\\" are in the exclusion list. Multiple values can be separated by semi-colons",
// "Module only available based on the relationship of the user with the wiki page. Either only creators (y) or only non-creators (n) will see the module" => "Module only available based on the relationship of the user with the wiki page. Either only creators (y) or only non-creators (n) will see the module",
// "Contributor" => "Contributor",
// "Module only available based on the relationship of the user with the wiki page. Either only contributors (y) or only non-contributors (n) will see the module" => "Module only available based on the relationship of the user with the wiki page. Either only contributors (y) or only non-contributors (n) will see the module",
// "Flip" => "Flip",
// "Users can shade module" => "Users can shade module",
// "No numbers" => "No numbers",
// "If set to \"y\", the module will not number list items" => "If set to \"y\", the module will not number list items",
// "Number of rows, or items, to display" => "Number of rows, or items, to display",
// "Default: 10" => "Default: 10",
// "section edit" => "section edit",
// "This poll is closed" => "This poll is closed",
// "Title length" => "Title length",
// "Publication date" => "Publication date",
// "Expiration date" => "Expiration date",
// "Default number per page" => "Default number per page",
// "Default Ordering" => "Default Ordering",
// "Default article image width" => "Default article image width",
// "0 for original image size" => "0 for original image size",
// "Default article image height" => "Default article image height",
// "Multiple authentication backends are supported by Tikiwiki. The default value is to use the internal user database" => "Multiple authentication backends are supported by Tikiwiki. The default value is to use the internal user database",
// "Tiki" => "Tiki",
// "Tiki and OpenID" => "Tiki and OpenID",
// "Tiki and LDAP" => "Tiki and LDAP",
// "Shibboleth" => "Shibboleth",
// "Available languages" => "Available languages",
// "By default, all languages supported by tikiwiki are available on multilingual sites. This option allows to limit the languages to a subset" => "By default, all languages supported by tikiwiki are available on multilingual sites. This option allows to limit the languages to a subset",
// "Blogues" => "Blogues",
// "Categories used in templates (TPL)" => "Categories used in templates (TPL)",
// "Exclude these categories" => "Exclude these categories",
// "Users can change site language" => "Users can change site language",
// "Allow users to change the language of the menus and labels" => "Allow users to change the language of the menus and labels",
// "Spell checking" => "Spell checking",
// "Allow anonymous visitors to use the \"Contact Us\" feature" => "Allow anonymous visitors to use the \"Contact Us\" feature",
// "Default charset for sending mail" => "Default charset for sending mail",
// "utf-8" => "utf-8",
// "iso-8859-1" => "iso-8859-1",
// "Article RSS Description" => "Article RSS Description",
// "Description to be published as part of the RSS feed for articles" => "Description to be published as part of the RSS feed for articles",
// "Show Country Flag" => "Show Country Flag",
// "Show the country flag" => "Show the country flag",
// "Enable cool sites" => "Enable cool sites",
// "'),\n\t\t\t'type' => 'flag" => "'),\n\t\t\t'type' => 'flag",
// "Number of columns per page when listing directory categories" => "Number of columns per page when listing directory categories",
// "6" => "6",
// "'),\n\t\t\t'type' => 'text" => "'),\n\t\t\t'type' => 'text",
// "Method to Open Directory Links" => "Method to Open Directory Links",
// "PHP errors visible to admin only" => "PHP errors visible to admin only",
// "For development purposes, it\\'s better to display errors for all users. However, in production settings, they should only be displayed to administrators" => "For development purposes, it\\'s better to display errors for all users. However, in production settings, they should only be displayed to administrators",
// "PHP Error reporting level" => "PHP Error reporting level",
// "Level from which errors should be reported" => "Level from which errors should be reported",
// "Report all PHP errors except strict" => "Report all PHP errors except strict",
// "Report all PHP errors except notices" => "Report all PHP errors except notices",
// "Question and Answer prefix on Answers" => "Question and Answer prefix on Answers",
// "Q and A" => "Q and A",
// "Question ID" => "Question ID",
// "Faqs" => "Faqs",
// "Collaboratively authored documents with history of changes" => "Collaboratively authored documents with history of changes",
// "Online diaries or journals" => "Online diaries or journals",
// "Collections of graphic images for viewing or downloading (photo album)" => "Collections of graphic images for viewing or downloading (photo album)",
// "Machine Translation (by Google Translate)" => "Machine Translation (by Google Translate)",
// "Uses Google Translate to translate the content of wiki pages to other languages" => "Uses Google Translate to translate the content of wiki pages to other languages",
// "Experimental. This feature is still under development" => "Experimental. This feature is still under development",
// "Database & form generator" => "Database & form generator",
// "Online discussions on a variety of topics. Threaded or flat" => "Online discussions on a variety of topics. Threaded or flat",
// "Computer files, videos or software for downloading. With check-in & check-out (lock)" => "Computer files, videos or software for downloading. With check-in & check-out (lock)",
// "Articles can be used for date-specific news and announcements. You can configure articles to automatically publish and expire at specific times or to require that submissions be approved before becoming \"live.\"" => "Articles can be used for date-specific news and announcements. You can configure articles to automatically publish and expire at specific times or to require that submissions be approved before becoming \"live.\"",
// "Brief list of votable options; appears in module (left or right column)" => "Brief list of votable options; appears in module (left or right column)",
// "Content mailed to registered users" => "Content mailed to registered users",
// "Events calendar with public, private and group channels" => "Events calendar with public, private and group channels",
// "Insert, track, and manage advertising banners" => "Insert, track, and manage advertising banners",
// "Global category system. Items of different types (wiki pages, articles, tracker items, etc) can be added to one or many categories. Categories can have permissions" => "Global category system. Items of different types (wiki pages, articles, tracker items, etc) can be added to one or many categories. Categories can have permissions",
// "Score is a game to motivate participants to increase their contribution by comparing to other users" => "Score is a game to motivate participants to increase their contribution by comparing to other users",
// "Enables searching for content on the website" => "Enables searching for content on the website",
// "Freetags" => "Freetags",
// "Allows to set tags on pages and various objects within the website and generate tag cloud navigation patterns" => "Allows to set tags on pages and various objects within the website and generate tag cloud navigation patterns",
// "Action Log" => "Action Log",
// "Allows to keep track of what users are doing and produce reports on a per-user or per-category basis" => "Allows to keep track of what users are doing and produce reports on a per-user or per-category basis",
// "Contribution" => "Contribution",
// "Allows users to specify the type of contribution they are making while editing objects. The contributions are then displayed as color-coded in history and other reports" => "Allows users to specify the type of contribution they are making while editing objects. The contributions are then displayed as color-coded in history and other reports",
// "Enables internationalization features and multilingual support for then entire site" => "Enables internationalization features and multilingual support for then entire site",
// "Frequently asked questions and answers" => "Frequently asked questions and answers",
// "Questionnaire with multiple choice or open ended question" => "Questionnaire with multiple choice or open ended question",
// "User-submitted Web links" => "User-submitted Web links",
// "Quizzes " => "Quizzes ",
// "Timed questionnaire with recorded scores" => "Timed questionnaire with recorded scores",
// "Simple menu system which can optionally add an external web page in an iframe" => "Simple menu system which can optionally add an external web page in an iframe",
// "The Copyright Management System (or ©MS) is a way of licensing your content" => "The Copyright Management System (or ©MS) is a way of licensing your content",
// "Multimedia" => "Multimedia",
// "The applet is designed to read MP3 or FLV file" => "The applet is designed to read MP3 or FLV file",
// "Experimental. This feature is not actively maintained" => "Experimental. This feature is not actively maintained",
// "Quick comment (graffiti) box. Like a group chat, but not in real time" => "Quick comment (graffiti) box. Like a group chat, but not in real time",
// "Navigable, interactive maps with user-selectable layers" => "Navigable, interactive maps with user-selectable layers",
// "Requires mapserver" => "Requires mapserver",
// "Interactive use of Google Maps" => "Interactive use of Google Maps",
// "One-on-one chatting with customer" => "One-on-one chatting with customer",
// "Tell a Friend" => "Tell a Friend",
// "Add a link \"Email this page\" in all the pages" => "Add a link \"Email this page\" in all the pages",
// "HTML pages" => "HTML pages",
// "Static and dynamic HTML content" => "Static and dynamic HTML content",
// "HTML can be used in wiki pages. This is a separate feature" => "HTML can be used in wiki pages. This is a separate feature",
// "Basic form from visitor to admin" => "Basic form from visitor to admin",
// "Minichat" => "Minichat",
// "Real-time group text chatting" => "Real-time group text chatting",
// "Comments Moderation " => "Comments Moderation ",
// "An admin must validate a comment before it is visible" => "An admin must validate a comment before it is visible",
// "Comments Locking" => "Comments Locking",
// "Comments can be closed (no new comments)" => "Comments can be closed (no new comments)",
// "Allow posting of comments as Anonymous" => "Allow posting of comments as Anonymous",
// "Permit anonymous visitors to add a comment without needing to create an account" => "Permit anonymous visitors to add a comment without needing to create an account",
// "Display page description" => "Display page description",
// "Display the page description below the heading when viewing the page" => "Display the page description below the heading when viewing the page",
// "Display page title" => "Display page title",
// "Display the page name at the top of each page. If not enabled, the content must be structured to contain a header" => "Display the page name at the top of each page. If not enabled, the content must be structured to contain a header",
// "Display page ID" => "Display page ID",
// "Display the internal page ID when viewing the page" => "Display the internal page ID when viewing the page",
// "Individual wiki cache" => "Individual wiki cache",
// "Allow users to change the duration of the cache on a per-page basis" => "Allow users to change the duration of the cache on a per-page basis",
// "JS Calendar" => "JS Calendar",
// "JavaScript popup date selector" => "JavaScript popup date selector",
// "Output should be HTMLPurified" => "Output should be HTMLPurified",
// "This enable HTPMPurifier on outputs to filter remaining security problems like XSS" => "This enable HTPMPurifier on outputs to filter remaining security problems like XSS",
// "Full Screen" => "Full Screen",
// "Allow users to activate fullscreen mode" => "Allow users to activate fullscreen mode",
// "Css Menus" => "Css Menus",
// "Css Menus (suckerfish)" => "Css Menus (suckerfish)",
// "Shadowbox" => "Shadowbox",
// "Quick Permission Assignment" => "Quick Permission Assignment",
// "Quickperms allow to define classes of privileges and grant them to roles on objects" => "Quickperms allow to define classes of privileges and grant them to roles on objects",
// "HTML Purifier" => "HTML Purifier",
// "Ajax" => "Ajax",
// "Morcego 3D browser" => "Morcego 3D browser",
// "Mindmap" => "Mindmap",
// "Print Indexed" => "Print Indexed",
// "Search engine friendly url" => "Search engine friendly url",
// "SpreadSheet" => "SpreadSheet",
// "Ajax auto-save" => "Ajax auto-save",
// "Save draft" => "Save draft",
// "Requires AJAX (experimental)" => "Requires AJAX (experimental)",
// "Kaltura" => "Kaltura",
// "Users can identify other users as their friends" => "Users can identify other users as their friends",
// "Neglected feature" => "Neglected feature",
// "Action calendar" => "Action calendar",
// "Redirect to a similar wiki page if an exact match is not found" => "Redirect to a similar wiki page if an exact match is not found",
// "User Contacts" => "User Contacts",
// "Group Watches" => "Group Watches",
// "Daily Reports for User Watches" => "Daily Reports for User Watches",
// "User Levels" => "User Levels",
// "Group Alert" => "Group Alert",
// "TikiTests" => "TikiTests",
// "Use Minified Scripts" => "Use Minified Scripts",
// "These JavaScript files have been previously minified and are stable. They make pages quicker to load than their non-minified versions" => "These JavaScript files have been previously minified and are stable. They make pages quicker to load than their non-minified versions",
// "Check for updates automatically" => "Check for updates automatically",
// "TikiWiki will check for updates when you access the main Administration page" => "TikiWiki will check for updates when you access the main Administration page",
// "Use PEAR::Date library" => "Use PEAR::Date library",
// "Require confirmation if possible CSRF detected" => "Require confirmation if possible CSRF detected",
// "Lookup the user\\'s preferred language through browser preferences" => "Lookup the user\\'s preferred language through browser preferences",
// "Show pages in user\\'s preferred language" => "Show pages in user\\'s preferred language",
// "When accessing a page which has an equivalent in the user\\'s preferred language, favor the translated page" => "When accessing a page which has an equivalent in the user\\'s preferred language, favor the translated page",
// "Changing the page language also changes the site language" => "Changing the page language also changes the site language",
// "Translation assistant" => "Translation assistant",
// "Track translation operations between pages" => "Track translation operations between pages",
// "Urgent translation notifications" => "Urgent translation notifications",
// "Allow to flag changes as urgent, leading translations to be marked with a notice visible to all users" => "Allow to flag changes as urgent, leading translations to be marked with a notice visible to all users",
// "Incomplete translation notice" => "Incomplete translation notice",
// "When a page is translated to a new language, a notice will be automatically be inserted into the page to indicate that the translation is not yet complete" => "When a page is translated to a new language, a notice will be automatically be inserted into the page to indicate that the translation is not yet complete",
// "Multilingual structures" => "Multilingual structures",
// "Structures to lookup equivalent pages in other languages. May cause performance problems on larger structures" => "Structures to lookup equivalent pages in other languages. May cause performance problems on larger structures",
// "Display all languages in a single page" => "Display all languages in a single page",
// "List all languages as a language option in the page language drop list to see all languages at once" => "List all languages as a language option in the page language drop list to see all languages at once",
// "GZip output" => "GZip output",
// "Translation URLs" => "Translation URLs",
// "Show clickable URLs to translate the page to another language using Babel Fish website" => "Show clickable URLs to translate the page to another language using Babel Fish website",
// "Translation icons" => "Translation icons",
// "Show clickable icons to translate the page to another language using Babelfish website" => "Show clickable icons to translate the page to another language using Babelfish website",
// "Also known as emoticons" => "Also known as emoticons",
// "Bloc of content which can be reused and programmed (timed)" => "Bloc of content which can be reused and programmed (timed)",
// "Use File Galleries to store pictures" => "Use File Galleries to store pictures",
// "External link icon" => "External link icon",
// "Semantic links" => "Semantic links",
// "Going beyond Backlinks, allows to define some semantic relationships between wiki pages" => "Going beyond Backlinks, allows to define some semantic relationships between wiki pages",
// "Web Services" => "Web Services",
// "Can consume webservices in JSON or YAML" => "Can consume webservices in JSON or YAML",
// "Breadcrumbs" => "Breadcrumbs",
// "Anonymous editors must enter anti-bot code (CAPTCHA)" => "Anonymous editors must enter anti-bot code (CAPTCHA)",
// "Protect email against spam" => "Protect email against spam",
// "Anonymous voting" => "Anonymous voting",
// "Allow re-voting" => "Allow re-voting",
// "Search engine friendly url Postfilter" => "Search engine friendly url Postfilter",
// "Display article title in the sefurl" => "Display article title in the sefurl",
// "Display blog title in the sefurl" => "Display blog title in the sefurl",
// "Show module controls" => "Show module controls",
// "Perspectives" => "Perspectives",
// "Permits to override preferences" => "Permits to override preferences",
// "Permits find and replace of content in the edit box" => "Permits find and replace of content in the edit box",
// "Specify notification emails when creating articles" => "Specify notification emails when creating articles",
// "Category path" => "Category path",
// "Show category objects" => "Show category objects",
// "Use PHPLayers for category browser" => "Use PHPLayers for category browser",
// "Screencasts" => "Screencasts",
// "Allow to upload screencasts from wiki edit. Screencasts can be uploaded locally or on a WebDAV share" => "Allow to upload screencasts from wiki edit. Screencasts can be uploaded locally or on a WebDAV share",
// "Screencasts upload location" => "Screencasts upload location",
// "Local path or webdav path to the file upload location" => "Local path or webdav path to the file upload location",
// "Trailing slash required" => "Trailing slash required",
// "Screencasts HTTP prefix" => "Screencasts HTTP prefix",
// "Prefix to use for the files when generating a link to it" => "Prefix to use for the files when generating a link to it",
// "Screencast upload type" => "Screencast upload type",
// "Mode used to upload files. WebDav is used to upload to remote servers" => "Mode used to upload files. WebDav is used to upload to remote servers",
// "Webdav" => "Webdav",
// "Screencasts authentication user" => "Screencasts authentication user",
// "When using webdav to upload files, used as the username of the authentication credentials" => "When using webdav to upload files, used as the username of the authentication credentials",
// "Screencasts authentication password" => "Screencasts authentication password",
// "When using webdav to upload files, used as the password of the authentication credentials" => "When using webdav to upload files, used as the password of the authentication credentials",
// "Screencasts max file size" => "Screencasts max file size",
// "Maximum file size used for screencasts" => "Maximum file size used for screencasts",
// "Value provided in bytes" => "Value provided in bytes",
// "Page List" => "Page List",
// "The pagelist feature allows to maintain lists of pages and their associated score and priority" => "The pagelist feature allows to maintain lists of pages and their associated score and priority",
// "Database search" => "Database search",
// "Object filter" => "Object filter",
// "Search box" => "Search box",
// "Pertinence" => "Pertinence",
// "Object type" => "Object type",
// "Last modified date" => "Last modified date",
// "Blog-level" => "Blog-level",
// "Batch uploading" => "Batch uploading",
// "Topic archiving" => "Topic archiving",
// "Quick jumps" => "Quick jumps",
// "Replies are empty" => "Replies are empty",
// "First post of a thread can have an empty body" => "First post of a thread can have an empty body",
// "Forum name search" => "Forum name search",
// "Forum content search" => "Forum content search",
// "Topic content search" => "Topic content search",
// "Use Tiki (database-independent) search" => "Use Tiki (database-independent) search",
// "Use database (full-text) search" => "Use database (full-text) search",
// "Store password as plain text" => "Store password as plain text",
// "Admins can search for features in the admin panels" => "Admins can search for features in the admin panels",
// "Encryption method" => "Encryption method",
// "tikihash (old)" => "tikihash (old)",
// "Display 'MyTiki' in the application menu" => "Display 'MyTiki' in the application menu",
// "Show user's contribution on the user information page" => "Show user's contribution on the user information page",
// "Permission to all (not just any) of an object's categories is required for access" => "Permission to all (not just any) of an object's categories is required for access",
// "Require file author's name for anonymous uploads" => "Require file author's name for anonymous uploads",
// "Add a Powered by Tiki link on your site's footer" => "Add a Powered by Tiki link on your site's footer",
// "Podcast directory" => "Podcast directory",
// "The server must be able to read/write the directory" => "The server must be able to read/write the directory",
// "Required for podcasts" => "Required for podcasts",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols",
// "The server must be able to read the directory" => "The server must be able to read the directory",
// "The directory can be outside the web space" => "The directory can be outside the web space",
// "Prevent download if score becomes negative" => "Prevent download if score becomes negative",
// "Allow download limit per file" => "Allow download limit per file",
// "Yes, even in the same gallery" => "Yes, even in the same gallery",
// "Only in different galleries" => "Only in different galleries",
// "Must match" => "Must match",
// "Cannot match" => "Cannot match",
// "Quota for all the files and archives" => "Quota for all the files and archives",
// "(0 for illimitted)" => "(0 for illimitted)",
// "Quota can be defined for each file gallery" => "Quota can be defined for each file gallery",
// "Default quota for each new gallery" => "Default quota for each new gallery",
// "Show quota bar in the list page" => "Show quota bar in the list page",
// "Manage thread defaults per-forum" => "Manage thread defaults per-forum",
// "Display thread configuration bar" => "Display thread configuration bar",
// "Display thread configuration bar only when number of posts exceed" => "Display thread configuration bar only when number of posts exceed",
// "Keep settings for all forums during the user session" => "Keep settings for all forums during the user session",
// "Default style" => "Default style",
// "Default sort mode" => "Default sort mode",
// "Description length" => "Description length",
// "Do not prefix messages titles by 'Re: '" => "Do not prefix messages titles by 'Re: '",
// "Default ordering" => "Default ordering",
// "Creation Date (asc)" => "Creation Date (asc)",
// "Multilingual tags" => "Multilingual tags",
// "Permits translation management of tags" => "Permits translation management of tags",
// "Label visible in the browser\\'s title bar on all pages. Also appears in search engines" => "Label visible in the browser\\'s title bar on all pages. Also appears in search engines",
// "Validate new user registrations by email" => "Validate new user registrations by email",
// "Upon registration, the new user will receive an email containing a link to confirm validity" => "Upon registration, the new user will receive an email containing a link to confirm validity",
// "Landing page used for the wiki when no page is specified. The page will be created if it does not exist" => "Landing page used for the wiki when no page is specified. The page will be created if it does not exist",
// "Default language" => "Default language",
// "Site language used when no other language is specified by the user" => "Site language used when no other language is specified by the user",
// "Cache external pages" => "Cache external pages",
// "Cache external images" => "Cache external images",
// "The default help system may not be complete. You can help with the TikiWiki documentation" => "The default help system may not be complete. You can help with the TikiWiki documentation",
// "License page" => "License page",
// "Submit notice" => "Submit notice",
// "[-180 180]" => "[-180 180]",
// "[0 360]" => "[0 360]",
// "Maximum number of articles on articles home page" => "Maximum number of articles on articles home page",
// "Url to go when clicking on a username" => "Url to go when clicking on a username",
// "Default: " => "Default: ",
// "Remind/forgot password" => "Remind/forgot password",
// "If passwords <em>are not</em> plain text, reset instructions will be emailed to the user" => "If passwords <em>are not</em> plain text, reset instructions will be emailed to the user",
// "If passwords <em>are stored</em> as plain text, the password will be emailed to the user" => "If passwords <em>are stored</em> as plain text, the password will be emailed to the user",
// "Verify for available translations in the database" => "Verify for available translations in the database",
// "Language inclusion threshold" => "Language inclusion threshold",
// "When the number of languages is restricted on the site, and is below this number, all languages will be added to the preferred language list, even if unspecified by the user. However, priority will be given to the specified languages" => "When the number of languages is restricted on the site, and is below this number, all languages will be added to the preferred language list, even if unspecified by the user. However, priority will be given to the specified languages",
// "Maximum average server load threshold in the last minute" => "Maximum average server load threshold in the last minute",
// "Log mail in Tiki logs" => "Log mail in Tiki logs",
// "Add HTML comment at start and end of each Smarty template (TPL)" => "Add HTML comment at start and end of each Smarty template (TPL)",
// "Log SQL" => "Log SQL",
// "Log queries using more than (seconds)" => "Log queries using more than (seconds)",
// "This may impact performance" => "This may impact performance",
// "Mail end of line" => "Mail end of line",
// "CRLF (standard)" => "CRLF (standard)",
// "LF (some Unix MTA)" => "LF (some Unix MTA)",
// "Memcache" => "Memcache",
// "Enable connection to memcached servers to store temporary information" => "Enable connection to memcached servers to store temporary information",
// "Requires the PHP memcache extension" => "Requires the PHP memcache extension",
// "Memcache flags" => "Memcache flags",
// "Configuration switches for memcache connection" => "Configuration switches for memcache connection",
// "Memcache servers" => "Memcache servers",
// "Server list which may be accessed. For each server, the address, port and weight must be specified" => "Server list which may be accessed. For each server, the address, port and weight must be specified",
// "One per line. address:port (weight)" => "One per line. address:port (weight)",
// "Memcache key prefix" => "Memcache key prefix",
// "When the memcache cluster is used by multiple applications, using unique prefixes for each of them helps avoiding conflicts" => "When the memcache cluster is used by multiple applications, using unique prefixes for each of them helps avoiding conflicts",
// "Memcache expiration" => "Memcache expiration",
// "Duration for which the data will be kept" => "Duration for which the data will be kept",
// "Cache wiki data in memcache" => "Cache wiki data in memcache",
// "Cache wiki output in memcache" => "Cache wiki output in memcache",
// "Cache forum output in memcache" => "Cache forum output in memcache",
// "Allow users to define icons for menus entries" => "Allow users to define icons for menus entries",
// "Default path for the icons" => "Default path for the icons",
// "Keywords" => "Keywords",
// "Include freetags" => "Include freetags",
// "Use thread title instead" => "Use thread title instead",
// "Use image title instead" => "Use image title instead",
// "Use individual page description for Wiki pages instead" => "Use individual page description for Wiki pages instead",
// "Meta robots" => "Meta robots",
// "Revisit after" => "Revisit after",
// "Multi-domain" => "Multi-domain",
// "Allows to map domain names to perspectives and simulate multiple domains hosted on the same instance" => "Allows to map domain names to perspectives and simulate multiple domains hosted on the same instance",
// "Multi-domain Configuration" => "Multi-domain Configuration",
// "Comma-separated values mapping the domain name to the perspective ID" => "Comma-separated values mapping the domain name to the perspective ID",
// "One domain per line. Comma separated with perspective ID" => "One domain per line. Comma separated with perspective ID",
// "Wiki buttons" => "Wiki buttons",
// "Page description, icons, backlinks, .." => "Page description, icons, backlinks, ..",
// "Top " => "Top ",
// "Bottom" => "Bottom",
// "Neither" => "Neither",
// "Show categories" => "Show categories",
// "Show objects" => "Show objects",
// "Host" => "Host",
// "Proxy host" => "Proxy host",
// "Quantify change size" => "Quantify change size",
// "In addition to tracking the changes, track the change size and display the approximate up-to-date-ness of the page" => "In addition to tracking the changes, track the change size and display the approximate up-to-date-ness of the page",
// "Keep track of the unsuccessful attemps to translate strings" => "Keep track of the unsuccessful attemps to translate strings",
// "Restrict supported languages" => "Restrict supported languages",
// "Limit the languages made available on the site" => "Limit the languages made available on the site",
// "Refresh mode" => "Refresh mode",
// "Random" => "Random",
// "Parse the results" => "Parse the results",
// "Sender email" => "Sender email",
// "Email address that will be used as the sender for outgoing emails" => "Email address that will be used as the sender for outgoing emails",
// "Session storage location" => "Session storage location",
// "Select where the session information should be stored. Memcache sessions require memcache to be configured" => "Select where the session information should be stored. Memcache sessions require memcache to be configured",
// "Default (from php.ini)" => "Default (from php.ini)",
// "Session lifetime" => "Session lifetime",
// "Value provided in minutes" => "Value provided in minutes",
// "Silent session" => "Silent session",
// "Do not automatically start sessions" => "Do not automatically start sessions",
// "Session cookie name" => "Session cookie name",
// "Session cookie name used instead of the PHP default configuration" => "Session cookie name used instead of the PHP default configuration",
// "Display available translations" => "Display available translations",
// "Close site (except for those with permission)" => "Close site (except for those with permission)",
// "Message to display" => "Message to display",
// "Locations (breadcrumbs)" => "Locations (breadcrumbs)",
// "Choices" => "Choices",
// "Site title location" => "Site title location",
// "Location of the site title in the browser title bar relative to the current page\\'s descriptor" => "Location of the site title in the browser title bar relative to the current page\\'s descriptor",
// "Browser title display mode" => "Browser title display mode",
// "When breadcrumbs are used, method in which the browser title should be displayed" => "When breadcrumbs are used, method in which the browser title should be displayed",
// "Most specific first" => "Most specific first",
// "Least specific first (site)" => "Least specific first (site)",
// "Current only" => "Current only",
// "Include smarty notices in PHP error report" => "Include smarty notices in PHP error report",
// "In most cases, smarty notices can be safely ignored. However, they may be useful in the development process when strange issues occur" => "In most cases, smarty notices can be safely ignored. However, they may be useful in the development process when strange issues occur",
// "Smarty Security" => "Smarty Security",
// "Do not allow php code in smarty templates" => "Do not allow php code in smarty templates",
// "Check frequency" => "Check frequency",
// "Each day" => "Each day",
// "Each week" => "Each week",
// "Each month" => "Each month",
// "Minify javascript" => "Minify javascript",
// "Compress javascript files used in the page into a single file to be distributed statically. Changes to javascript files will require cache to be cleared" => "Compress javascript files used in the page into a single file to be distributed statically. Changes to javascript files will require cache to be cleared",
// "Use Jquery autocomplete user selector for better performance when number of users exceed" => "Use Jquery autocomplete user selector for better performance when number of users exceed",
// "Close site when server load is above the threshold  (except for those with permission)" => "Close site when server load is above the threshold  (except for those with permission)",
// "Show user\\'s real name instead of login (when possible)" => "Show user\\'s real name instead of login (when possible)",
// "Display UserTracker information on the user information page" => "Display UserTracker information on the user information page",
// "Users can configure modules" => "Users can configure modules",
// "Users can shade modules" => "Users can shade modules",
// "Always" => "Always",
// "Module decides" => "Module decides",
// "500Kb" => "500Kb",
// "1Mb" => "1Mb",
// "1.5Mb" => "1.5Mb",
// "2Mb" => "2Mb",
// "2.5Mb" => "2.5Mb",
// "3Mb" => "3Mb",
// "Include a flag by each e-mail to quickly flag/un-flag them" => "Include a flag by each e-mail to quickly flag/un-flag them",
// "Wiki link format" => "Wiki link format",
// "Character set used when detecting wiki links within pages" => "Character set used when detecting wiki links within pages",
// "Latin" => "Latin",
// "Display by default only pages in current language" => "Display by default only pages in current language",
// "In Wiki page lists, display by default only pages in current language" => "In Wiki page lists, display by default only pages in current language",
// "Display page version" => "Display page version",
// "Display the page version information when viewing the page" => "Display the page version information when viewing the page",
// "Page name display stripper" => "Page name display stripper",
// "Character to use as a delimiter in the page name. The portion of the name after this character will not be displayed" => "Character to use as a delimiter in the page name. The portion of the name after this character will not be displayed",
// "Wiki author list style" => "Wiki author list style",
// "Changes the list format used to display the authors of the page" => "Changes the list format used to display the authors of the page",
// "Creator & Author" => "Creator & Author",
// "Page last modified on" => "Page last modified on",
// "none (disabled)" => "none (disabled)",
// "Specify wiki author list style per page" => "Specify wiki author list style per page",
// "Allows to modify the style in which the author list is displayed on a per-page basis" => "Allows to modify the style in which the author list is displayed on a per-page basis",
// "Wiki action bar location" => "Wiki action bar location",
// "Buttons: Save, Preview, Cancel, .." => "Buttons: Save, Preview, Cancel, ..",
// "Both" => "Both",
// "Wiki navigation bar location" => "Wiki navigation bar location",
// "When using the ...page... page break wiki syntax" => "When using the ...page... page break wiki syntax",
// "Wiki top line location" => "Wiki top line location",
// "Enable page cache globally for wiki pages" => "Enable page cache globally for wiki pages",
// "Allow comments per page" => "Allow comments per page",
// "Enable control for comments on wiki pages individually" => "Enable control for comments on wiki pages individually",
// "Disable" => "Disable",
// "Enable (default On)" => "Enable (default On)",
// "Enable (default Off)" => "Enable (default Off)",
// "Enable edit plugin icons" => "Enable edit plugin icons",
// "Permits editing of a plugin, via a popup form, without needing to edit the whole page" => "Permits editing of a plugin, via a popup form, without needing to edit the whole page",
// "Enable plugin %0" => "Enable plugin %0",
// "Inline plugin %0 (hide plugin edit icon)" => "Inline plugin %0 (hide plugin edit icon)",
// "When inlined, the plugin edit icon will not appear" => "When inlined, the plugin edit icon will not appear",
// "Wysiwyg Editor is optional" => "Wysiwyg Editor is optional",
// "... and is displayed by default" => "... and is displayed by default",
// "Reopen with the same editor" => "Reopen with the same editor",
// "Content is parsed like wiki page" => "Content is parsed like wiki page",
// "Content is partially parsed" => "Content is partially parsed",
// "Toolbar skin" => "Toolbar skin",
// "Default" => "Default",
// "Office 2003" => "Office 2003",
// "Silver" => "Silver",
// "Nothing was changed, please check profile for errors" => "Nothing was changed, please check profile for errors",
// "An error occurred: " => "An error occurred: ",
// "Applying profile" => "Applying profile",
// "Added (or modified)" => "Added (or modified)",
// "Preference set" => "Preference set",
// "Group changed (or modified)" => "Group changed (or modified)",
// "User %0 was added to %1" => "User %0 was added to %1",
// "Created by profile installer" => "Created by profile installer",
// "Page updated by profile installer" => "Page updated by profile installer",
// "No name" => "No name",
// "Bad object" => "Bad object",
// "The passwords do not match" => "The passwords do not match",
// "uploaded the file" => "uploaded the file",
// "changes" => "changes",
// "No changes" => "No changes",
// "Yesterday" => "Yesterday",
// "more changes of the same type.." => "more changes of the same type..",
// "changed the picture gallery" => "changed the picture gallery",
// "uploaded the picture" => "uploaded the picture",
// "onto" => "onto",
// "removed the picture" => "removed the picture",
// "edited the wikipage" => "edited the wikipage",
// "this history" => "this history",
// "all history" => "all history",
// "edited the file gallery" => "edited the file gallery",
// "removed the file" => "removed the file",
// "added the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"to the category" => "added the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"to the category",
// "removed the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"from the category" => "removed the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"from the category",
// "created the subcategory" => "created the subcategory",
// "removed the subcategory" => "removed the subcategory",
// "edited the category" => "edited the category",
// "removed the article" => "removed the article",
// "created the article" => "created the article",
// "edited the article" => "edited the article",
// "replied to the blog" => "replied to the blog",
// "created the topic" => "created the topic",
// "at forum" => "at forum",
// "to the topic" => "to the topic",
// "Nothing has happened" => "Nothing has happened",
// "Feed provided by %s. Click to visit" => "Feed provided by %s. Click to visit",
// "Wiki Comment" => "Wiki Comment",
// "Calendar item" => "Calendar item",
// "Tracker item" => "Tracker item",
// "Simple" => "Simple",
// "Advanced" => "Advanced",
// "_HOMEPAGE_CONTENT_" => "_HOMEPAGE_CONTENT_",
// "You are not in group of friends to have the content of this block displayed for you" => "You are not in group of friends to have the content of this block displayed for you",
// "Smarty block.display.php: Missing error param" => "Smarty block.display.php: Missing error param",
// "<!-- jq smarty plugin inactive: feature_jquery off -->" => "<!-- jq smarty plugin inactive: feature_jquery off -->",
// "Fast Next" => "Fast Next",
// "Fast Prev" => "Fast Prev",
// "First {\$params['itemname']}" => "First {\$params['itemname']}",
// "Last {\$params['itemname']}" => "Last {\$params['itemname']}",
// "Next {\$params['itemname']}" => "Next {\$params['itemname']}",
// "Prev {\$params['itemname']}" => "Prev {\$params['itemname']}",
// "tip" => "tip",
// "warning" => "warning",
// "note" => "note",
// "errors" => "errors",
// "information" => "information",
// "Tab View" => "Tab View",
// "No Tabs" => "No Tabs",
// "If you want the saved version instead of this autosaved one" => "If you want the saved version instead of this autosaved one",
// "AutoSave" => "AutoSave",
// "Your edit session will expire in" => "Your edit session will expire in",
// "You must PREVIEW or SAVE your work now, to avoid losing your edits" => "You must PREVIEW or SAVE your work now, to avoid losing your edits",
// "Your edit session has expired" => "Your edit session has expired",
// "You are about to leave this page. Changes since your last save will be lost. Are you sure you want to exit this page" => "You are about to leave this page. Changes since your last save will be lost. Are you sure you want to exit this page",
// "Help page" => "Help page",
// "Admin Feature" => "Admin Feature",
// "Preference name not specified" => "Preference name not specified",
// "Preference %0 is not defined" => "Preference %0 is not defined",
// "Invert Sort" => "Invert Sort",
// "No rows found" => "No rows found",
// "{treetable}: Number of items in _checkboxColumnIndex doesn not match items in _checkbox" => "{treetable}: Number of items in _checkboxColumnIndex doesn not match items in _checkbox",
// "{treetable}: Number of items in _checkboxTitles doesn not match items in _checkbox" => "{treetable}: Number of items in _checkboxTitles doesn not match items in _checkbox",
// "Toggle sections" => "Toggle sections",
// "sec" => "sec",
// "km" => "km",
// "Permission denied: the specified wiki page cannot be used as Smarty template resource" => "Permission denied: the specified wiki page cannot be used as Smarty template resource",
// "First day of week: Sunday (its ID is 0) - translators you need to localize this string" => "First day of week: Sunday (its ID is 0) - translators you need to localize this string",
// "You have to make %d choice(s) for the question" => "You have to make %d choice(s) for the question",
// "You have to make at least %d choice(s) for the question" => "You have to make at least %d choice(s) for the question",
// "You have to make less than %d choice(s) for the question" => "You have to make less than %d choice(s) for the question",
// "You have to choose at least %d choice(s) for the question" => "You have to choose at least %d choice(s) for the question",
// "Foo" => "Foo",
// "Sample plugin" => "Sample plugin",
// "Face" => "Face",
// "Font family to use" => "Font family to use",
// "As defined by CSS" => "As defined by CSS",
// "Page '%0' cannot be found" => "Page '%0' cannot be found",
// "For the security of your password direct access to the feed is only available via https" => "For the security of your password direct access to the feed is only available via https",
// "Help link" => "Help link",
// "Edit Plugin" => "Edit Plugin",
// "Edit Section" => "Edit Section",
// "index" => "index",
// "smiling" => "smiling",
// "grinning" => "grinning",
// "crying" => "crying",
// "frightened" => "frightened",
// "evil stuff" => "evil stuff",
// "exclamation mark " => "exclamation mark ",
// "frowning" => "frowning",
// "light bulb" => "light bulb",
// "idea " => "idea ",
// "LOL" => "LOL",
// "laughing out loud " => "laughing out loud ",
// "mr. green laughing" => "mr. green laughing",
// "The file was uploaded with success" => "The file was uploaded with success",
// "The file you are trying upload was only partially uploaded" => "The file you are trying upload was only partially uploaded",
// "No file was uploaded. Was a file selected " => "No file was uploaded. Was a file selected ",
// "A temporary folder is missing" => "A temporary folder is missing",
// "Unknown error" => "Unknown error",
// "Flash player not available" => "Flash player not available",
// "__WARNING__: Plugin disabled \$plugin" => "__WARNING__: Plugin disabled \$plugin",
// "Bold" => "Bold",
// "pics/icons/text_bold.png" => "pics/icons/text_bold.png",
// "Italic" => "Italic",
// "pics/icons/text_italic.png" => "pics/icons/text_italic.png",
// "Strikethrough" => "Strikethrough",
// "pics/icons/text_strikethrough.png" => "pics/icons/text_strikethrough.png",
// "Non-parsed" => "Non-parsed",
// "pics/icons/noparse.png" => "pics/icons/noparse.png",
// "Align Center" => "Align Center",
// "pics/icons/text_align_center.png" => "pics/icons/text_align_center.png",
// "Horizontal Bar" => "Horizontal Bar",
// "pics/icons/page.png" => "pics/icons/page.png",
// "Page Break" => "Page Break",
// "lib/fckeditor_tiki/fckeditor-icons/Pagebreak.gif" => "lib/fckeditor_tiki/fckeditor-icons/Pagebreak.gif",
// "Block Quote" => "Block Quote",
// "pics/icons/box.png" => "pics/icons/box.png",
// "pics/icons/book.png" => "pics/icons/book.png",
// "Unordered List" => "Unordered List",
// "pics/icons/text_list_bullets.png" => "pics/icons/text_list_bullets.png",
// "Ordered List" => "Ordered List",
// "pics/icons/text_list_numbers.png" => "pics/icons/text_list_numbers.png",
// "Special Characters" => "Special Characters",
// "lib/fckeditor_tiki/fckeditor-icons/Specialchar.gif" => "lib/fckeditor_tiki/fckeditor-icons/Specialchar.gif",
// "img/smiles/icon_smile.gif" => "img/smiles/icon_smile.gif",
// "Foreground color" => "Foreground color",
// "pics/icons/palette.png" => "pics/icons/palette.png",
// "Background Color" => "Background Color",
// "pics/icons/palette_bg.png" => "pics/icons/palette_bg.png",
// "Wiki Link" => "Wiki Link",
// "pics/icons/page_link.png" => "pics/icons/page_link.png",
// "External Link" => "External Link",
// "pics/icons/world_link.png" => "pics/icons/world_link.png",
// "pics/icons/table.png" => "pics/icons/table.png",
// "Table Builder" => "Table Builder",
// "pics/icons/find.png" => "pics/icons/find.png",
// "Find Text" => "Find Text",
// "pics/icons/text_replace.png" => "pics/icons/text_replace.png",
// "Text Replace" => "Text Replace",
// "Full Screen Edit" => "Full Screen Edit",
// "pics/icons/arrow_in.png" => "pics/icons/arrow_in.png",
// "pics/icons/arrow_out.png" => "pics/icons/arrow_out.png",
// "Choose or upload images" => "Choose or upload images",
// "pics/icons/pictures.png" => "pics/icons/pictures.png",
// "Switch Editor (wiki or WYSIWYG)" => "Switch Editor (wiki or WYSIWYG)",
// "pics/icons/pencil_go.png" => "pics/icons/pencil_go.png",
// "Admin Toolbars" => "Admin Toolbars",
// "Upload was not successful. Duplicate file content " => "Upload was not successful. Duplicate file content ",
// "Field is not numeric" => "Field is not numeric",
// "Field is not a link to mp3 in the gallery" => "Field is not a link to mp3 in the gallery",
// "Field is not a link to FLV in the gallery" => "Field is not a link to FLV in the gallery",
// "Field is not a link to FLV or MP3 in the gallery" => "Field is not a link to FLV or MP3 in the gallery",
// "half column" => "half column",
// "prepend" => "prepend",
// "append" => "append",
// "max" => "max",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max,autocomplete</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[autocomplete]</strong> if y autocomplete while typing;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max,autocomplete</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[autocomplete]</strong> if y autocomplete while typing;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>toolbars,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[toolbars]</strong> enables toolbars if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>toolbars,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[toolbars]</strong> enables toolbars if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "drop down with other textfield" => "drop down with other textfield",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "radio buttons" => "radio buttons",
// "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>",
// "IP selector" => "IP selector",
// "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>",
// "page selector" => "page selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example:\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example:\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>",
// "static text" => "static text",
// "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "dynamic items list" => "dynamic items list",
// "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an url in a wiki syntax.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an url in a wiki syntax.\n\t\t\t\t</dl>",
// "multimedia" => "multimedia",
// "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>",
// "auto-increment" => "auto-increment",
// "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "user subscription" => "user subscription",
// "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>",
// "computed field" => "computed field",
// "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>",
// "user preference" => "user preference",
// "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u|m] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its size (n), the username of the uploader (u), or the mediaplayer plugin(m);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u|m] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its size (n), the username of the uploader (u), or the mediaplayer plugin(m);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "in group" => "in group",
// "<dl>\n\t\t\t\t<dt>Function: Allows to display if a item user is in a group and when he was assigned to the group (needs a user selector field)\n\t\t\t\t<dt>Usage: <strong>groupName,date</strong>\n\t\t\t\t<dt>Example: Members,date\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>GroupName</strong> Group to test. <strong>date</strong> displays the date the user was assigned in the group (if known), otherwise will display yes/no.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows to display if a item user is in a group and when he was assigned to the group (needs a user selector field)\n\t\t\t\t<dt>Usage: <strong>groupName,date</strong>\n\t\t\t\t<dt>Example: Members,date\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>GroupName</strong> Group to test. <strong>date</strong> displays the date the user was assigned in the group (if known), otherwise will display yes/no.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "The administrator has not yet validated your account. Please wait" => "The administrator has not yet validated your account. Please wait",
// "You must validate your account first. An email has been sent to you" => "You must validate your account first. An email has been sent to you",
// "The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "The registration mail can't be sent because there is no server email address set, and this feature is disabled",
// "The user email confirmation can't be sent. Contact the administrator" => "The user email confirmation can't be sent. Contact the administrator",
// "Personal Phone" => "Personal Phone",
// "Personal Mobile" => "Personal Mobile",
// "Personal Fax" => "Personal Fax",
// "Work Phone" => "Work Phone",
// "Work Mobile" => "Work Mobile",
// "Work Fax" => "Work Fax",
// "Organization" => "Organization",
// "Department" => "Department",
// "Division" => "Division",
// "Job Title" => "Job Title",
// "Street Address" => "Street Address",
// "City" => "City",
// "Zip Code" => "Zip Code",
// "Mailbox uninitialised??" => "Mailbox uninitialised??",
// "No mail body found" => "No mail body found",
// "User-Agent Info" => "User-Agent Info",
// "Displays various information about the client" => "Displays various information about the client",
// "Info required - IP|SVRSW|BROWSER" => "Info required - IP|SVRSW|BROWSER",
// "Anchor Link" => "Anchor Link",
// "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin" => "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin",
// "Anchor link label" => "Anchor link label",
// "The anchor name as defined in the ANAME plugin" => "The anchor name as defined in the ANAME plugin",
// "The name of the wiki page containing the anchor" => "The name of the wiki page containing the anchor",
// "Anchor Name" => "Anchor Name",
// "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin" => "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin",
// "The name of the anchor" => "The name of the anchor",
// "Image Annotation" => "Image Annotation",
// "Autogenerated content. Leave blank initially" => "Autogenerated content. Leave blank initially",
// "Absolute URL to the image or relative path from tikiwiki root" => "Absolute URL to the image or relative path from tikiwiki root",
// "Width" => "Width",
// "Image width" => "Image width",
// "Height" => "Height",
// "Image height" => "Image height",
// "Alignment" => "Alignment",
// "Image alignment. Possible values: left, right, center" => "Image alignment. Possible values: left, right, center",
// "Save changes to annotations" => "Save changes to annotations",
// "Image annotations changed" => "Image annotations changed",
// "Creates an annotation block for an image" => "Creates an annotation block for an image",
// "Displays an image and enables users to define zones to highlight information on the image" => "Displays an image and enables users to define zones to highlight information on the image",
// "Includes an article\\'s content within the page" => "Includes an article\\'s content within the page",
// "The article field to display. Default field is Heading" => "The article field to display. Default field is Heading",
// "Article ID" => "Article ID",
// "The article to display. If no value is provided, most recent article will be used" => "The article to display. If no value is provided, most recent article will be used",
// "Includes an article" => "Includes an article",
// "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
// "Id is optional. If not given, last article is used. Default field is heading" => "Id is optional. If not given, last article is used. Default field is heading",
// "Article List" => "Article List",
// "Inserts a list of articles in the page" => "Inserts a list of articles in the page",
// "Articles displayed" => "Articles displayed",
// "The number of articles to display in the list" => "The number of articles to display in the list",
// "Topics expression" => "Topics expression",
// "Topic ID expression" => "Topic ID expression",
// "Type expression" => "Type expression",
// "Category ID" => "Category ID",
// "The ID of the category to list from" => "The ID of the category to list from",
// "The article language to list" => "The article language to list",
// "Sort order" => "Sort order",
// "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")" => "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")",
// "Quiet" => "Quiet",
// "Whether to not report when there are no articles" => "Whether to not report when there are no articles",
// "Title only" => "Title only",
// "Whether to only show the title of the articles" => "Whether to only show the title of the articles",
// "Show body" => "Show body",
// "Whether to only show the body of the articles or just the heading" => "Whether to only show the body of the articles or just the heading",
// "Starting article" => "Starting article",
// "The article number that the list should start with" => "The article number that the list should start with",
// "Start date" => "Start date",
// "Earliest date to select articles from" => "Earliest date to select articles from",
// "End date" => "End date",
// "Latest date to select articles from" => "Latest date to select articles from",
// "Override Dates" => "Override Dates",
// "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings" => "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings",
// "Container class" => "Container class",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")",
// "Includes articles listing into a wiki page" => "Includes articles listing into a wiki page",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~",
// "Bullets" => "Bullets",
// "Inline" => "Inline",
// "Number" => "Number",
// "Show icon" => "Show icon",
// "Gives the name of the attached file to link to" => "Gives the name of the attached file to link to",
// "Same as name" => "Same as name",
// "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages",
// "Shows the description as the link text instead of the file name" => "Shows the description as the link text instead of the file name",
// "Makes the list of attachments a bulleted list" => "Makes the list of attachments a bulleted list",
// "Says that this file is an image, and should be displayed inline using the img tag" => "Says that this file is an image, and should be displayed inline using the img tag",
// "Makes the text between the {ATTACH} tags the link text instead of the file name or description" => "Makes the text between the {ATTACH} tags the link text instead of the file name or description",
// "Shows all attachments from the whole wiki" => "Shows all attachments from the whole wiki",
// "Gives the number, in the list of attachments, of the attachment to link to" => "Gives the number, in the list of attachments, of the attachment to link to",
// "Gives the actual id of the attachment to link in. You probably should never use this" => "Gives the actual id of the attachment to link in. You probably should never use this",
// "Puts the number of downloads in the alt comment" => "Puts the number of downloads in the alt comment",
// "Shows a file icon" => "Shows a file icon",
// "The wiki page the avatar will link to" => "The wiki page the avatar will link to",
// "Float" => "Float",
// "left|right" => "left|right",
// "Displays a link that allows to go back in the browser history" => "Displays a link that allows to go back in the browser history",
// "Insert back link on wiki page" => "Insert back link on wiki page",
// "List all pages linking to the specified page" => "List all pages linking to the specified page",
// "The page links will point to. Default value is the current page" => "The page links will point to. Default value is the current page",
// "Displayed information" => "Displayed information",
// "Pipe separated list of fields to display. ex: hits|user" => "Pipe separated list of fields to display. ex: hits|user",
// "Excluded pages" => "Excluded pages",
// "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox" => "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox",
// "Include Self" => "Include Self",
// "1|0" => "1|0",
// "No Header" => "No Header",
// "Banner" => "Banner",
// "Insert a banner" => "Insert a banner",
// "Target" => "Target",
// "missing parameter" => "missing parameter",
// "Blog List" => "Blog List",
// "Use BLOGLIST to include posts from a blog" => "Use BLOGLIST to include posts from a blog",
// "Blog ID" => "Blog ID",
// "Numeric value" => "Numeric value",
// "Maximum number of entries to list" => "Maximum number of entries to list",
// "Simple list" => "Simple list",
// "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)" => "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)",
// "Earliest date to select posts from" => "Earliest date to select posts from",
// "Latest date to select posts from" => "Latest date to select posts from",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")",
// "Use BLOGLIST to include posts from a blog. Syntax is" => "Use BLOGLIST to include posts from a blog. Syntax is",
// "where Id is the blog Id and Items is the max number of posts to display" => "where Id is the blog Id and Items is the max number of posts to display",
// "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
// "Box" => "Box",
// "Box title" => "Box title",
// "Displayed above the content" => "Displayed above the content",
// "Background color" => "Background color",
// "As defined by CSS, name or Hex code" => "As defined by CSS, name or Hex code",
// "Box width" => "Box width",
// "In pixels or percentage. Default value is 100%" => "In pixels or percentage. Default value is 100%",
// "Text Alignment" => "Text Alignment",
// "Float Position" => "Float Position",
// "for box with width less than 100%, make text wrap around the box" => "for box with width less than 100%, make text wrap around the box",
// "CSS Class" => "CSS Class",
// "Apply custom CSS class to the box" => "Apply custom CSS class to the box",
// "Includes a calendar and/or a list of calendar events" => "Includes a calendar and/or a list of calendar events",
// "Calendar filter" => "Calendar filter",
// "If set to a calendar identifier, restricts the events displayed to those in the specified calendar" => "If set to a calendar identifier, restricts the events displayed to those in the specified calendar",
// "View type" => "View type",
// "Determines how to show events" => "Determines how to show events",
// "Possible values" => "Possible values",
// "\"table\" shows events in a calendar" => "\"table\" shows events in a calendar",
// "Default value" => "Default value",
// "Calendar view type time span" => "Calendar view type time span",
// "If in calendar (or \"table\") view type, determines the time span displayed by the calendar" => "If in calendar (or \"table\") view type, determines the time span displayed by the calendar",
// "View the navigation bar" => "View the navigation bar",
// "Decide or not to show the navigation bar" => "Decide or not to show the navigation bar",
// "Includes a calendar" => "Includes a calendar",
// "~np~{CALENDAR(calendarId=>1)}{CALENDAR}" => "~np~{CALENDAR(calendarId=>1)}{CALENDAR}",
// "Id is optional. If not given, all calendars viewable by default are used" => "Id is optional. If not given, all calendars viewable by default are used",
// "Category IDs" => "Category IDs",
// "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page" => "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page",
// "Types" => "Types",
// "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img" => "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img",
// "Sort Order" => "Sort Order",
// "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle" => "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle",
// "Split" => "Split",
// "And" => "And",
// "With sub-categories" => "With sub-categories",
// "Show object name" => "Show object name",
// "Show type" => "Show type",
// "Incorrect param" => "Incorrect param",
// "Category Orphans" => "Category Orphans",
// "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker" => "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker",
// "Category Path" => "Category Path",
// "Separator" => "Separator",
// "String used to separate the categories in the path. Default character is >" => "String used to separate the categories in the path. Default character is >",
// "Display top category" => "Display top category",
// "yes|no, default to no" => "yes|no, default to no",
// "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool" => "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool",
// "Chart caption" => "Chart caption",
// "Sheet ID" => "Sheet ID",
// "Data sheet ID" => "Data sheet ID",
// "Chart Type" => "Chart Type",
// "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic" => "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic",
// "Chart Width" => "Chart Width",
// "Width in pixels" => "Width in pixels",
// "Chart Height" => "Chart Height",
// "Height in pixels" => "Height in pixels",
// "Value series" => "Value series",
// "Required for pie charts" => "Required for pie charts",
// "Independant series" => "Independant series",
// "Required for types other than pie chart" => "Required for types other than pie chart",
// "Dependant series" => "Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors" => "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors",
// "List of colors to use" => "List of colors to use",
// "Styles" => "Styles",
// "List of styles to use" => "List of styles to use",
// "Labels" => "Labels",
// "Labels for the series or values in the legend" => "Labels for the series or values in the legend",
// "Chart as PDF" => "Chart as PDF",
// "Chart as PostScript" => "Chart as PostScript",
// "Caption" => "Caption",
// "Code snippet label" => "Code snippet label",
// "Word Wrap" => "Word Wrap",
// "0|1, Enable word wrapping on the code to avoid breaking the layout" => "0|1, Enable word wrapping on the code to avoid breaking the layout",
// "Colors" => "Colors",
// "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, .." => "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, ..",
// "Line numbers" => "Line numbers",
// "0|1, may not be used with colors" => "0|1, may not be used with colors",
// "Wiki syntax" => "Wiki syntax",
// "0|1, parse wiki syntax within the code snippet" => "0|1, parse wiki syntax within the code snippet",
// "Right to left" => "Right to left",
// "0|1, switch the text display from left to right to right to left" => "0|1, switch the text display from left to right to right to left",
// "Content is HTML" => "Content is HTML",
// "0|1, display the content as is instead of escaping HTML special chars" => "0|1, display the content as is instead of escaping HTML special chars",
// "Includes content from the dynamic content system" => "Includes content from the dynamic content system",
// "Content ID" => "Content ID",
// "Also known as fortune cookies or taglines" => "Also known as fortune cookies or taglines",
// "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~" => "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~",
// "Countdown" => "Countdown",
// "Displays a countdown from now until the specified date" => "Displays a countdown from now until the specified date",
// "Text to append to the countdown" => "Text to append to the countdown",
// "Target date. Multiple formats accepted" => "Target date. Multiple formats accepted",
// "Locate Time" => "Locate Time",
// "on|off" => "on|off",
// "Items to show" => "Items to show",
// "Select: d=days, h=hours, m=minuts, s=seconds. Enter multiple values as: dhms. If blank, all items are shown" => "Select: d=days, h=hours, m=minuts, s=seconds. Enter multiple values as: dhms. If blank, all items are shown",
// "Show time since event" => "Show time since event",
// "If y, will display amount of time since the event (default). If n will simply display that the event is over" => "If y, will display amount of time since the event (default). If n will simply display that the event is over",
// "since " => "since ",
// "until " => "until ",
// " is over" => " is over",
// "Data Channel" => "Data Channel",
// "Displays a form to trigger data channels" => "Displays a form to trigger data channels",
// "List of fields to display. One field per line. Comma delimited: fieldname,label" => "List of fields to display. One field per line. Comma delimited: fieldname,label",
// "Channel Name" => "Channel Name",
// "Name of the channel as registered by the administrator" => "Name of the channel as registered by the administrator",
// "DBReport" => "DBReport",
// "Run a database report" => "Run a database report",
// "report definition" => "report definition",
// "Full DSN" => "Full DSN",
// "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database" => "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database",
// "Wiki DSN name" => "Wiki DSN name",
// "The name of a DSN connection defined by the Wiki administrator" => "The name of a DSN connection defined by the Wiki administrator",
// "0|1, parse wiki syntax within the report" => "0|1, parse wiki syntax within the report",
// "Debug" => "Debug",
// "0|1, display the parsed report definition" => "0|1, display the parsed report definition",
// "Missing db or dsn parameter" => "Missing db or dsn parameter",
// "You do not have permission to use this DSN" => "You do not have permission to use this DSN",
// "No DSN connection string found" => "No DSN connection string found",
// "Div" => "Div",
// "div|span|pre|b|i|tt|p|blockquote" => "div|span|pre|b|i|tt|p|blockquote",
// "Span" => "Span",
// "Teletype" => "Teletype",
// "Paragraph" => "Paragraph",
// "Block quote" => "Block quote",
// "left|right|center|justify" => "left|right|center|justify",
// "Justify" => "Justify",
// "Float position" => "Float position",
// "left|right, for box with width less than 100%, make text wrap around the box" => "left|right, for box with width less than 100%, make text wrap around the box",
// "Determine how other elements can wrap around the element" => "Determine how other elements can wrap around the element",
// "Apply custom CSS class to the div" => "Apply custom CSS class to the div",
// "HTML id" => "HTML id",
// "Sets the div\\'s id attribute, as defined by HTML" => "Sets the div\\'s id attribute, as defined by HTML",
// "Insert a division block, span, blockquote or other text formatting on wiki page" => "Insert a division block, span, blockquote or other text formatting on wiki page",
// "Definition List" => "Definition List",
// "One entry per line. Each line is in \"Term: Definition\" format" => "One entry per line. Each line is in \"Term: Definition\" format",
// "Equation" => "Equation",
// "Renders an equation written in LaTeX syntax as an image" => "Renders an equation written in LaTeX syntax as an image",
// "equation" => "equation",
// "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large" => "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large",
// "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size",
// "Includes the list of events from a calendar in the page" => "Includes the list of events from a calendar in the page",
// "Calendar ID" => "Calendar ID",
// "Numeric" => "Numeric",
// "Maximum days" => "Maximum days",
// "Maximum Rows" => "Maximum Rows",
// "Datetime" => "Datetime",
// "0|1" => "0|1",
// "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage",
// "Fade" => "Fade",
// "Displays a label. On click, the block of content will fade in and fade out" => "Displays a label. On click, the block of content will fade in and fade out",
// "Wiki syntax containing the text to display" => "Wiki syntax containing the text to display",
// "Label to display on first display" => "Label to display on first display",
// "Unspecified label" => "Unspecified label",
// "Fancy List" => "Fancy List",
// "One item per line starting with anything followed by \")\"" => "One item per line starting with anything followed by \")\"",
// "Use div" => "Use div",
// "Use div instead of ol" => "Use div instead of ol",
// "Class" => "Class",
// "CSS class for the fancylist" => "CSS class for the fancylist",
// "Creates a fancy-looking list" => "Creates a fancy-looking list",
// "num" => "num",
// "item text" => "item text",
// "one item per line" => "one item per line",
// "Fancy Table" => "Fancy Table",
// "Rows separated by >> in the header; for the table body, one row per line. Cells separated by | in both cases" => "Rows separated by >> in the header; for the table body, one row per line. Cells separated by | in both cases",
// "Heading row" => "Heading row",
// "Header rows of the table. Use >> to separate multiple rows" => "Header rows of the table. Use >> to separate multiple rows",
// "Heading CSS class" => "Heading CSS class",
// "CSS class to apply to the heading row" => "CSS class to apply to the heading row",
// "Header horizontal align" => "Header horizontal align",
// "Horizonatal alignments for header cells separated by |. Choices: left, right, center, justify" => "Horizonatal alignments for header cells separated by |. Choices: left, right, center, justify",
// "Header vertical align" => "Header vertical align",
// "Vertical alignments for header cells separated by |. Choices: top, middle, bottom, baseline" => "Vertical alignments for header cells separated by |. Choices: top, middle, bottom, baseline",
// "Column sort" => "Column sort",
// "Pre-sorted columns" => "Pre-sorted columns",
// "Bracketed numbers for column number and sort direction (0 = ascending, 1 = descending), for example: [0,0],[1,0]" => "Bracketed numbers for column number and sort direction (0 = ascending, 1 = descending), for example: [0,0],[1,0]",
// "Column widths" => "Column widths",
// "Column widths followed by px for pixels or % for percentages. Each column separated by |" => "Column widths followed by px for pixels or % for percentages. Each column separated by |",
// "Cell horizontal align" => "Cell horizontal align",
// "Table body column horizonatal alignments separated by |. Choices: left, right, center, justify" => "Table body column horizonatal alignments separated by |. Choices: left, right, center, justify",
// "Cell vertical align" => "Cell vertical align",
// "Table body column vertical alignments separated by |. Choices: top, middle, bottom, baseline" => "Table body column vertical alignments separated by |. Choices: top, middle, bottom, baseline",
// "The feature must be activated" => "The feature must be activated",
// "heads and cells separated by |" => "heads and cells separated by |",
// "Displays a link to an attachment to a wiki page and can display an image attachment. " => "Displays a link to an attachment to a wiki page and can display an image attachment. ",
// "Gallery ID" => "Gallery ID",
// "name_asc" => "name_asc",
// "Shows ID" => "Shows ID",
// "Shows Icon" => "Shows Icon",
// "Shows Name" => "Shows Name",
// "Shows Filename" => "Shows Filename",
// "Shows Size" => "Shows Size",
// "Shows Description" => "Shows Description",
// "Shows Creation Date" => "Shows Creation Date",
// "Shows Hits" => "Shows Hits",
// "Shows Locked by" => "Shows Locked by",
// "Shows Modification Date" => "Shows Modification Date",
// "Shows Author" => "Shows Author",
// "Shows Creator" => "Shows Creator",
// "Shows Parent Gallery Name" => "Shows Parent Gallery Name",
// "Shows Number of Files" => "Shows Number of Files",
// "Shows the slideshow of a gallery" => "Shows the slideshow of a gallery",
// "List files in a file gallery (with a category) or in a category or a file gallery od this category" => "List files in a file gallery (with a category) or in a category or a file gallery od this category",
// "Displays a list of files from the File Gallery" => "Displays a list of files from the File Gallery",
// "Flash video" => "Flash video",
// "Movie URL" => "Movie URL",
// "Complete URL to the movie to include. e.g. files/test.swf" => "Complete URL to the movie to include. e.g. files/test.swf",
// "Default width: 425" => "Default width: 425",
// "Default height: 350" => "Default height: 350",
// "Quality" => "Quality",
// "Flash video quality. Default value: high" => "Flash video quality. Default value: high",
// "Missing parameter movie to the plugin flash" => "Missing parameter movie to the plugin flash",
// "Footnote" => "Footnote",
// "Inserts a superscripted footnote number next to text and takes in footnote as parameter" => "Inserts a superscripted footnote number next to text and takes in footnote as parameter",
// "The footnote" => "The footnote",
// "Footnotearea" => "Footnotearea",
// "Inserts a section for collected footnotes in the wiki page" => "Inserts a section for collected footnotes in the wiki page",
// "Download box for a file on ftp server" => "Download box for a file on ftp server",
// "ftp" => "ftp",
// "file name" => "file name",
// "Ftp Server Name" => "Ftp Server Name",
// "Ftp User name" => "Ftp User name",
// "Ftp password" => "Ftp password",
// "Download button label" => "Download button label",
// "missing parameters" => "missing parameters",
// "Connection failed" => "Connection failed",
// "Gauge" => "Gauge",
// "Displays a graphical gauge" => "Displays a graphical gauge",
// "current value (REQUIRED)" => "current value (REQUIRED)",
// "Maximum Value" => "Maximum Value",
// "Maximum possible value. Default: 100" => "Maximum possible value. Default: 100",
// "Label displayed on the left side of the gauge" => "Label displayed on the left side of the gauge",
// "Color" => "Color",
// "Bar width in pixels" => "Bar width in pixels",
// "Label Width" => "Label Width",
// "Width in pixels allocated to the label" => "Width in pixels allocated to the label",
// "Display Percentage" => "Display Percentage",
// "true|false, if true then a percentage of the maximum is displayed" => "true|false, if true then a percentage of the maximum is displayed",
// "Display Value" => "Display Value",
// "true|false, if the numeric value is displayed" => "true|false, if the numeric value is displayed",
// "Bar height in pixels" => "Bar height in pixels",
// "Google Analytics" => "Google Analytics",
// "Add the tracking code for Google Analytics" => "Add the tracking code for Google Analytics",
// "Account number" => "Account number",
// "The account number for the site" => "The account number for the site",
// "Missing parameter" => "Missing parameter",
// "googledoc" => "googledoc",
// "Leave this empty" => "Leave this empty",
// "Type of Google document" => "Type of Google document",
// "key" => "key",
// "Google doc key - for example: pXsHENf1bGGY92X1iEeJJI" => "Google doc key - for example: pXsHENf1bGGY92X1iEeJJI",
// "Name of iframe" => "Name of iframe",
// "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large" => "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large",
// "Pixels or %" => "Pixels or %",
// "Margin Height" => "Margin Height",
// "Pixels" => "Pixels",
// "Margin Width" => "Margin Width",
// "Scrolling" => "Scrolling",
// "editLink" => "editLink",
// "Required parameter \"type\" missing" => "Required parameter \"type\" missing",
// "Required parameter \"key\" missing" => "Required parameter \"key\" missing",
// "Displays a Google document" => "Displays a Google document",
// "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition" => "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition",
// "Allowed User Friends" => "Allowed User Friends",
// "Pipe separated list of users whose friends are allowed to view the block. ex: admin|johndoe|foo" => "Pipe separated list of users whose friends are allowed to view the block. ex: admin|johndoe|foo",
// "Allowed Groups" => "Allowed Groups",
// "Pipe separated list of groups allowed to view the block. ex: Admins|Developers" => "Pipe separated list of groups allowed to view the block. ex: Admins|Developers",
// "Denied Groups" => "Denied Groups",
// "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers" => "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers",
// "Display wiki text if user is in one of listed groups or group of friends" => "Display wiki text if user is in one of listed groups or group of friends",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "GroupMailCore" => "GroupMailCore",
// "Displays GroupMail functions on a wiki page. Usually set up using a plugin alias created by the GroupMail profile" => "Displays GroupMail functions on a wiki page. Usually set up using a plugin alias created by the GroupMail profile",
// "From Email" => "From Email",
// "Email address to report" => "Email address to report",
// "Tracker Id" => "Tracker Id",
// "Id of GroupMail Logs tracker (set up in alias by profile)" => "Id of GroupMail Logs tracker (set up in alias by profile)",
// "From Field Id" => "From Field Id",
// "Id of GroupMail Logs tracker field (usually set up in alias by profile)" => "Id of GroupMail Logs tracker field (usually set up in alias by profile)",
// "operator Field Id" => "operator Field Id",
// "subject Field Id" => "subject Field Id",
// "message Field Id" => "message Field Id",
// "content Field Id" => "content Field Id",
// "account Field Id" => "account Field Id",
// "datetime Field Id" => "datetime Field Id",
// "Displays GroupMail functions on a wiki page" => "Displays GroupMail functions on a wiki page",
// "Group Stats" => "Group Stats",
// "Groups separated by " => "Groups separated by ",
// "Show Percentage" => "Show Percentage",
// "Show Bar" => "Show Bar",
// "Displays some stat about group belonging" => "Displays some stat about group belonging",
// "HTML" => "HTML",
// "Include literal HTML in a Wiki page" => "Include literal HTML in a Wiki page",
// "0|1, parse wiki syntax within the html code" => "0|1, parse wiki syntax within the html code",
// "Include literal HTML" => "Include literal HTML",
// "Iframe" => "Iframe",
// "Frame title" => "Frame title",
// "iframe" => "iframe",
// "Displays an iframe" => "Displays an iframe",
// " (experimental - possible successor to img in 5.0)" => " (experimental - possible successor to img in 5.0)",
// "File ID" => "File ID",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Image Source" => "Image Source",
// "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required" => "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required",
// "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded" => "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded",
// "Alias: lnk. Location the image should point to" => "Alias: lnk. Location the image should point to",
// "Link Relation" => "Link Relation",
// "\"rel\" attribute to add to the link" => "\"rel\" attribute to add to the link",
// "Link title" => "Link title",
// "Title text" => "Title text",
// "Image alt text" => "Image alt text",
// "Alternate text to display if impossible to load the image" => "Alternate text to display if impossible to load the image",
// "Alias:imalign. Image alignment in the page. (left, right)" => "Alias:imalign. Image alignment in the page. (left, right)",
// "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)" => "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)",
// "Image description to display on the page" => "Image description to display on the page",
// "Image Map" => "Image Map",
// "Name of the image map to use for the image" => "Name of the image map to use for the image",
// "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)" => "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)",
// "CSS Style" => "CSS Style",
// "CSS styling to apply to the plugin (usually used in configuration rather than on individual images)" => "CSS styling to apply to the plugin (usually used in configuration rather than on individual images)",
// "Border options" => "Border options",
// "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options" => "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options",
// "Description options" => "Description options",
// "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)" => "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)",
// "Default configuration" => "Default configuration",
// "Default configuration definitions. (Usually used in configuration rather than on individual images.)" => "Default configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Mandatory configuration" => "Mandatory configuration",
// "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)" => "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content" => "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content",
// "Display an image" => "Display an image",
// "Display images" => "Display images",
// "Image source" => "Image source",
// "Full URL to the image to display. \"id\", \"fileId\", \"attId\" or \"src\" required" => "Full URL to the image to display. \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Attachment ID" => "Attachment ID",
// "Numeric ID of an image attached to a wiki page (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image attached to a wiki page (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Makes the image a thumbnail that enlarges to full size when clicked or moused over (unless \"link\" is set to another target). \"browse\" and \"browsepopup\" only work with image gallery and \"download\" only works with file gallery" => "Makes the image a thumbnail that enlarges to full size when clicked or moused over (unless \"link\" is set to another target). \"browse\" and \"browsepopup\" only work with image gallery and \"download\" only works with file gallery",
// "Full size image appears when thumbnail is clicked" => "Full size image appears when thumbnail is clicked",
// "Mouseover" => "Mouseover",
// "Full size image will pop up while cursor is over the thumbnail (and disappear when not)" => "Full size image will pop up while cursor is over the thumbnail (and disappear when not)",
// "Mouseover (Sticky)" => "Mouseover (Sticky)",
// "Full size image will pop up once cursor passes over thumbnail and will remain up unless cursor passes over full size popup" => "Full size image will pop up once cursor passes over thumbnail and will remain up unless cursor passes over full size popup",
// "Popup" => "Popup",
// "Full size image will open in a separate winow or tab (depending on browser settings) when thumbnail is clicked" => "Full size image will open in a separate winow or tab (depending on browser settings) when thumbnail is clicked",
// "Image gallery browse window for the image will open when the thumbnail is clicked if the image is in a Tiki image gallery" => "Image gallery browse window for the image will open when the thumbnail is clicked if the image is in a Tiki image gallery",
// "Browse Popup" => "Browse Popup",
// "Same as \"browse\" except that the page opens in a new window or tab" => "Same as \"browse\" except that the page opens in a new window or tab",
// "Download dialog box will appear for file gallery images when thumbnail is clicked" => "Download dialog box will appear for file gallery images when thumbnail is clicked",
// "Enlarge button" => "Enlarge button",
// "Button for enlarging image" => "Button for enlarging image",
// "Enter a url to the address the image should link to. Not needed if thumb parameter is set; overrides thumb setting" => "Enter a url to the address the image should link to. Not needed if thumb parameter is set; overrides thumb setting",
// "Link relation" => "Link relation",
// "Enter \"box\" for colorbox effect (like shadowbox and lightbox) or appropriate syntax for link relation" => "Enter \"box\" for colorbox effect (like shadowbox and lightbox) or appropriate syntax for link relation",
// "Image map" => "Image map",
// "Maximum image size" => "Maximum image size",
// "Maximum height or width in pixels (largest dimension is scaled). Overrides height and width settings" => "Maximum height or width in pixels (largest dimension is scaled). Overrides height and width settings",
// "Align image" => "Align image",
// "Aligns the image itself. If the image is inside a box (because of other settings), use the align parameter to align the box" => "Aligns the image itself. If the image is inside a box (because of other settings), use the align parameter to align the box",
// "Image style" => "Image style",
// "Enter \"border\" to place a dark gray border around the image. Otherwise enter CSS styling syntax for other style effects" => "Enter \"border\" to place a dark gray border around the image. Otherwise enter CSS styling syntax for other style effects",
// "Align image block" => "Align image block",
// "Aligns the box containing the image" => "Aligns the box containing the image",
// "Image block style" => "Image block style",
// "Enter \"border\" to place a dark gray border frame around the image. Otherwise enter CSS styling syntax for other style effects" => "Enter \"border\" to place a dark gray border frame around the image. Otherwise enter CSS styling syntax for other style effects",
// "Description style" => "Description style",
// "Enter \"right\" or \"left\" to align text accordingly. Otherwise enter CSS styling syntax for other style effects" => "Enter \"right\" or \"left\" to align text accordingly. Otherwise enter CSS styling syntax for other style effects",
// "Wrapping control" => "Wrapping control",
// "Control how other items wrap around the image" => "Control how other items wrap around the image",
// "CSS class" => "CSS class",
// "CSS class to apply to the image" => "CSS class to apply to the image",
// "Image caption. \"desc\" or \"name\" for tiki images, \"idesc\" or \"ititle\" for iptc data, otherwise enter your own description" => "Image caption. \"desc\" or \"name\" for tiki images, \"idesc\" or \"ititle\" for iptc data, otherwise enter your own description",
// "Alternate text" => "Alternate text",
// "Alternate text that displays when image does not load" => "Alternate text that displays when image does not load",
// "Default config settings" => "Default config settings",
// "Default configuration settings (usually set by admin)" => "Default configuration settings (usually set by admin)",
// "Mandatory admin setting" => "Mandatory admin setting",
// "Mandatory configuration settings (usually set by admin)" => "Mandatory configuration settings (usually set by admin)",
// "File is not an image" => "File is not an image",
// "Server does not support image manipulation" => "Server does not support image manipulation",
// "''No image specified. Either the fileId, attId, id, or src parameter must be specified.''" => "''No image specified. Either the fileId, attId, id, or src parameter must be specified.''",
// "''Use one and only one of the following parameters: fileId, attId, id, or src.''" => "''Use one and only one of the following parameters: fileId, attId, id, or src.''",
// "Include a page\\'s content" => "Include a page\\'s content",
// "Page Name" => "Page Name",
// "Wiki page name to include" => "Wiki page name to include",
// "When only a portion of the page should be included, specify the marker from which inclusion should start" => "When only a portion of the page should be included, specify the marker from which inclusion should start",
// "When only a portion of the page should be included, specify the marker at which inclusion should end" => "When only a portion of the page should be included, specify the marker at which inclusion should end",
// "Invite" => "Invite",
// "Invite an email in groups" => "Invite an email in groups",
// "Confirmation message after posting form" => "Confirmation message after posting form",
// "Including group" => "Including group",
// "Default group" => "Default group",
// "Group from the item group selector / creator field" => "Group from the item group selector / creator field",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Jabber" => "Jabber",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Applet height in pixels" => "Applet height in pixels",
// "'),\n\t\t\t\t'description' => tra('Applet width in pixels" => "'),\n\t\t\t\t'description' => tra('Applet width in pixels",
// "'),\n\t\t\t\t'description' => tra('jabber.org" => "'),\n\t\t\t\t'description' => tra('jabber.org",
// "Default Color" => "Default Color",
// "255,255,255" => "255,255,255",
// "JQuery" => "JQuery",
// "Insert JQuery javascript code. Requires feature_jquery" => "Insert JQuery javascript code. Requires feature_jquery",
// " (experimental - may change in future versions)" => " (experimental - may change in future versions)",
// "JQuery Code" => "JQuery Code",
// "NotOnReady" => "NotOnReady",
// "NoJQuery" => "NoJQuery",
// "Optional markup for when feature_jquery is off" => "Optional markup for when feature_jquery is off",
// "Insert JQuery javascript code" => "Insert JQuery javascript code",
// "jquery code e.g. \$jq(\"img\\" => "jquery code e.g. \$jq(\"img\\",
// "Do not execute on document ready (execute inline)" => "Do not execute on document ready (execute inline)",
// "Javascript" => "Javascript",
// "Insert a javascript file or/and some javascript code" => "Insert a javascript file or/and some javascript code",
// "javascript code" => "javascript code",
// "Javascript filename" => "Javascript filename",
// "Kaltura video" => "Kaltura video",
// "Displays a KALTURA video on the wiki page" => "Displays a KALTURA video on the wiki page",
// "Kaltura Entry Id" => "Kaltura Entry Id",
// "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Not Language" => "Not Language",
// "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Page name to display information of. Default value is current page" => "Page name to display information of. Default value is current page",
// "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given",
// "Result Offset" => "Result Offset",
// "Result number at which the listing should start" => "Result number at which the listing should start",
// "Result Count" => "Result Count",
// "Number of results displayed in the list" => "Number of results displayed in the list",
// "Initial" => "Initial",
// "txt" => "txt",
// "Show Name Only" => "Show Name Only",
// "Structure Head" => "Structure Head",
// "Show Page Alias" => "Show Page Alias",
// "Two letter language code to filter pages listed" => "Two letter language code to filter pages listed",
// "Orphan Language" => "Orphan Language",
// "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed" => "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed",
// "Load Translations" => "Load Translations",
// "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter" => "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter",
// "Exact Match" => "Exact Match",
// "Related to Find" => "Related to Find",
// "Only Orphan Pages" => "Only Orphan Pages",
// "For List Pages" => "For List Pages",
// "List Progress" => "List Progress",
// "Indicates the internationalization progress of the page list" => "Indicates the internationalization progress of the page list",
// "List Name" => "List Name",
// "Name of the list as configured in the page list admin panel" => "Name of the list as configured in the page list admin panel",
// "Limit" => "Limit",
// "Maximum amount of results to display" => "Maximum amount of results to display",
// "Filter to apply to the page list" => "Filter to apply to the page list",
// "Score Limit" => "Score Limit",
// "Value used as the denominator for the score" => "Value used as the denominator for the score",
// "List Directory" => "List Directory",
// "Lists files in a directory" => "Lists files in a directory",
// "Full path to the server-local directory" => "Full path to the server-local directory",
// "URL Prefix" => "URL Prefix",
// ".ext" => ".ext",
// "Maximum amount of files to display" => "Maximum amount of files to display",
// "could not be opened because it doesn't exist or permission was denied" => "could not be opened because it doesn't exist or permission was denied",
// "Displays a map" => "Displays a map",
// "Map File" => "Map File",
// "Extents" => "Extents",
// "Mayan Calendars Info" => "Mayan Calendars Info",
// "Convert date from Gregorian to Mayan Calendars: Tzolkin, Haab, Long Count" => "Convert date from Gregorian to Mayan Calendars: Tzolkin, Haab, Long Count",
// "You must use the variable substitution.<br/>'.\n                             'LongCount: %baktun%, %katun%, %tun%, %winal%, %kin%;<br/>'.\n                             'Tzolkin: %tzolkin13%, %tzolkin20%, %tzolkin20name%;<br/>'.\n                             'Haab: %haabkin%, %haabwinal%, %haabwinalname%;<br/>'.\n                             'Misc: %longkin%, %julianday%.<br/><br/>'.\n                             'Example: template \"%baktun%.%katun%.%tun%.%winal%.%kin%, %tzolkin13% %tzolkin20name%, %haabkin% %haabwinalname%\" for 22.05.2009 will return 12.19.16.6.11, 8 CHUEN, 9 SIP.<br/>'.\n                             'Default template: %baktun%.%katun%.%tun%.%winal%.%kin% %tzolkin13% %tzolkin20name% %haabkin% %haabwinalname%" => "You must use the variable substitution.<br/>'.\n                             'LongCount: %baktun%, %katun%, %tun%, %winal%, %kin%;<br/>'.\n                             'Tzolkin: %tzolkin13%, %tzolkin20%, %tzolkin20name%;<br/>'.\n                             'Haab: %haabkin%, %haabwinal%, %haabwinalname%;<br/>'.\n                             'Misc: %longkin%, %julianday%.<br/><br/>'.\n                             'Example: template \"%baktun%.%katun%.%tun%.%winal%.%kin%, %tzolkin13% %tzolkin20name%, %haabkin% %haabwinalname%\" for 22.05.2009 will return 12.19.16.6.11, 8 CHUEN, 9 SIP.<br/>'.\n                             'Default template: %baktun%.%katun%.%tun%.%winal%.%kin% %tzolkin13% %tzolkin20name% %haabkin% %haabwinalname%",
// "Gregorian date" => "Gregorian date",
// "Gregorian date for convert. Format: DD.MM.YYYY. Default: Today date" => "Gregorian date for convert. Format: DD.MM.YYYY. Default: Today date",
// "Mayan Calendars" => "Mayan Calendars",
// " is not a valid date format. should be dd.mm.yyyy" => " is not a valid date format. should be dd.mm.yyyy",
// "Inline Flash mp3 and flv Player" => "Inline Flash mp3 and flv Player",
// "Mediaplayer" => "Mediaplayer",
// "MP3 URL" => "MP3 URL",
// "Complete URL to the mp3 to include" => "Complete URL to the mp3 to include",
// "FLV URL" => "FLV URL",
// "Complete URL to the flv to include" => "Complete URL to the flv to include",
// "One of" => "One of",
// "Member List" => "Member List",
// "Lists the members of selected groups and allows to add or remove members if permissions are granted" => "Lists the members of selected groups and allows to add or remove members if permissions are granted",
// "List of groups to handle through the interface. Colon separated" => "List of groups to handle through the interface. Colon separated",
// "Mini Quiz" => "Mini Quiz",
// "Displays a miniquiz" => "Displays a miniquiz",
// "Instructions::Feedback" => "Instructions::Feedback",
// "Tracker ID" => "Tracker ID",
// "Insert Module" => "Insert Module",
// "Module name as known in Tikiwiki" => "Module name as known in Tikiwiki",
// "Decoration" => "Decoration",
// "Max" => "Max",
// "np" => "np",
// "notitle" => "notitle",
// "Displays a module inline in a wiki page. More parameters can be added, not supported by UI" => "Displays a module inline in a wiki page. More parameters can be added, not supported by UI",
// "Monospace" => "Monospace",
// "Font name as known in browsers" => "Font name as known in browsers",
// "Create a mouseover feature on some text" => "Create a mouseover feature on some text",
// "Mouseover text if param label exists. Page text if text param exists" => "Mouseover text if param label exists. Page text if text param exists",
// "Text displayed on the page. The body is the mouseover content" => "Text displayed on the page. The body is the mouseover content",
// "Destination link when mouseover text is clicked. Use http:// for external links" => "Destination link when mouseover text is clicked. Use http:// for external links",
// "DEPRECATED" => "DEPRECATED",
// "Text displayed on the mouseover. The body contains the text of the page" => "Text displayed on the mouseover. The body contains the text of the page",
// "Mouseover box width. Default: 400px" => "Mouseover box width. Default: 400px",
// "Mouseover box height. Default: 200px" => "Mouseover box height. Default: 200px",
// "Offset X" => "Offset X",
// "Shifts the overlay to the right by the specified number of pixels relative to the cursor. Default: 5px" => "Shifts the overlay to the right by the specified number of pixels relative to the cursor. Default: 5px",
// "Offset Y" => "Offset Y",
// "Shifts the overlay lower by the specified number of pixels relative to the cursor. Default: 0px" => "Shifts the overlay lower by the specified number of pixels relative to the cursor. Default: 0px",
// "Parse Body" => "Parse Body",
// "y|n, parse the body of the plugin as wiki content. (Default to y)" => "y|n, parse the body of the plugin as wiki content. (Default to y)",
// "Background color of the popup" => "Background color of the popup",
// "'),\n\t\t\t\t'filter' => 'striptags" => "'),\n\t\t\t\t'filter' => 'striptags",
// "Text color in the popup" => "Text color in the popup",
// "Padding" => "Padding",
// "Effect" => "Effect",
// "Effect speed" => "Effect speed",
// "No label specified" => "No label specified",
// "MWTable" => "MWTable",
// "fancy" => "fancy",
// "true|false" => "true|false",
// "wiki_classes" => "wiki_classes",
// "Displays the data using (sort of) MediaWiki syntax" => "Displays the data using (sort of) MediaWiki syntax",
// "Displays a table using MediaWiki syntax" => "Displays a table using MediaWiki syntax",
// "MySpace" => "MySpace",
// "MySpace Page" => "MySpace Page",
// "Displays a MySpace Flash mp3 playlist in the wiki page" => "Displays a MySpace Flash mp3 playlist in the wiki page",
// "Object Hits" => "Object Hits",
// "Object ID" => "Object ID",
// "Object Type" => "Object Type",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "List pages part of a named list" => "List pages part of a named list",
// "Offset" => "Offset",
// "Pagination start element" => "Pagination start element",
// "list parameter missing or doesn\\'t exist" => "list parameter missing or doesn\\'t exist",
// "% of page hits" => "% of page hits",
// "Page Hits" => "Page Hits",
// "Search for images uploaded by users" => "Search for images uploaded by users",
// " (deprecated - scheduled to be removed or changed significantly)" => " (deprecated - scheduled to be removed or changed significantly)",
// "Filename or full path to file" => "Filename or full path to file",
// "Plugin Manager" => "Plugin Manager",
// "Information" => "Information",
// "Multiple values separated with | can be used" => "Multiple values separated with | can be used",
// "Poll ID" => "Poll ID",
// "Profile Installer" => "Profile Installer",
// "Adds controls required to install a profile" => "Adds controls required to install a profile",
// "Domain" => "Domain",
// "Profile repository domain. Default value is profiles.tikiwiki.org" => "Profile repository domain. Default value is profiles.tikiwiki.org",
// "Profile Name" => "Profile Name",
// "Name of the profile" => "Name of the profile",
// "Profile plugin only available to administrators" => "Profile plugin only available to administrators",
// "Profile %0/%1 not found" => "Profile %0/%1 not found",
// "Proposal" => "Proposal",
// "Provides a widget for users to vote on a proposal and view the current decision" => "Provides a widget for users to vote on a proposal and view the current decision",
// "The list of votes cast. One vote per line. Either 0, +1 or -1 followed by a username" => "The list of votes cast. One vote per line. Either 0, +1 or -1 followed by a username",
// "Accept proposal" => "Accept proposal",
// "Still undecided" => "Still undecided",
// "Reject proposal" => "Reject proposal",
// "Displays a proposal acceptance widget" => "Displays a proposal acceptance widget",
// "Short description of the proposal to vote on. Will be displayed above the result table" => "Short description of the proposal to vote on. Will be displayed above the result table",
// "Quote" => "Quote",
// "Quoted text" => "Quoted text",
// "Reply to" => "Reply to",
// "Name of the quoted person" => "Name of the quoted person",
// "wrote" => "wrote",
// "Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Quote text by surrounding the text with a box, like the [QUOTE] BBCode",
// "Random Dynamic Content" => "Random Dynamic Content",
// "Includes random content from the dynamic content system" => "Includes random content from the dynamic content system",
// "User List (showing Real Name)" => "User List (showing Real Name)",
// " (experimental, should be merged with UserList in Tiki5)" => " (experimental, should be merged with UserList in Tiki5)",
// "Login Filter" => "Login Filter",
// "String to use between elements of the list" => "String to use between elements of the list",
// "Maximum" => "Maximum",
// "Result limit" => "Result limit",
// "Layout" => "Layout",
// "Exclude" => "Exclude",
// "Displays a list of users showing their real name" => "Displays a list of users showing their real name",
// "Displays a list of registered users showing their Real Names" => "Displays a list of registered users showing their Real Names",
// "Redirect" => "Redirect",
// "Redirect the user to a wiki page or generic URL" => "Redirect the user to a wiki page or generic URL",
// "Wiki page name to redirect to" => "Wiki page name to redirect to",
// "Complete URL, internal or external" => "Complete URL, internal or external",
// "Redirects you to another wiki page" => "Redirects you to another wiki page",
// "Regular Expression" => "Regular Expression",
// "Takes regex expressions and parses the content between REGEX tags and replaces the text" => "Takes regex expressions and parses the content between REGEX tags and replaces the text",
// "Page name containing the regular expression" => "Page name containing the regular expression",
// "Displays a comment, tip, note or warning box" => "Displays a comment, tip, note or warning box",
// "remarks text" => "remarks text",
// "Remarks Box" => "Remarks Box",
// "Label displayed above the remark" => "Label displayed above the remark",
// "Highlight" => "Highlight",
// "Icon ID" => "Icon ID",
// "y|n Show close button (default y)" => "y|n Show close button (default y)",
// "Width (e.g. 100% or 250px - default \"\")" => "Width (e.g. 100% or 250px - default \"\")",
// "RSS Feed" => "RSS Feed",
// "Inserts an RSS feed output" => "Inserts an RSS feed output",
// "IDs" => "IDs",
// "List of feed IDs separated by colons. ex: feedId:feedId2" => "List of feed IDs separated by colons. ex: feedId:feedId2",
// "Number of results displayed" => "Number of results displayed",
// "You need to specify a RSS Id" => "You need to specify a RSS Id",
// "RSS Id incorrect" => "RSS Id incorrect",
// "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage",
// "Screencast" => "Screencast",
// "Display a screencast uploaded on the page" => "Display a screencast uploaded on the page",
// "Label to use as a replacement to the default text" => "Label to use as a replacement to the default text",
// "ID as provided automatically during the upload" => "ID as provided automatically during the upload",
// "Insert Screencast" => "Insert Screencast",
// "Screencast ID wasn't specified or doesn't exist" => "Screencast ID wasn't specified or doesn't exist",
// "Watch a video of these instructions" => "Watch a video of these instructions",
// "SourceForge" => "SourceForge",
// "aid?" => "aid?",
// "adit?" => "adit?",
// "groupid?" => "groupid?",
// "Insert a ShareThis button from www.sharethis.com" => "Insert a ShareThis button from www.sharethis.com",
// "sharethis" => "sharethis",
// "Display a social networking tool" => "Display a social networking tool",
// "Send services" => "Send services",
// "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services" => "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services",
// "First post services shown" => "First post services shown",
// "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget" => "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget",
// "Rotate image" => "Rotate image",
// "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping" => "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping",
// "Button text" => "Button text",
// "Custom link text for the button" => "Custom link text for the button",
// "Header title" => "Header title",
// "Optional header title text for the widget" => "Optional header title text for the widget",
// "Header background" => "Header background",
// "HTML color code (not color name) for the background color for the header if an optional header title is used" => "HTML color code (not color name) for the background color for the header if an optional header title is used",
// "Header text color" => "Header text color",
// "HTML color code (not color name) for the header text if an optional header title is used" => "HTML color code (not color name) for the header text if an optional header title is used",
// "Link text color for services" => "Link text color for services",
// "HTML color code (not color name) for the link text for all send and post services shown in the widget" => "HTML color code (not color name) for the link text for all send and post services shown in the widget",
// "A value of true will cause the widget to show in a pop-up window" => "A value of true will cause the widget to show in a pop-up window",
// "Embedded elements" => "Embedded elements",
// "A value of true will allow embedded elements (like flash) to be seen while iframe is loading" => "A value of true will allow embedded elements (like flash) to be seen while iframe is loading",
// "Sheet" => "Sheet",
// "Displays the content of a spreadsheet in the page" => "Displays the content of a spreadsheet in the page",
// "Internal ID of the TikiSheet" => "Internal ID of the TikiSheet",
// "New sheet in page: " => "New sheet in page: ",
// "Incomplete call to plugin: No target sheet" => "Incomplete call to plugin: No target sheet",
// "Create new sheet" => "Create new sheet",
// "Edit Sheet" => "Edit Sheet",
// "Show Pages" => "Show Pages",
// "Search criteria" => "Search criteria",
// "Maximum amount of results displayed" => "Maximum amount of results displayed",
// "name|desc" => "name|desc",
// "Skype" => "Skype",
// "Clickable Skype link" => "Clickable Skype link",
// "Name or number to call or chat with" => "Name or number to call or chat with",
// "Snarf" => "Snarf",
// "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified" => "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified",
// "Full URL to the page to include" => "Full URL to the page to include",
// "PCRE compliant regular expression" => "PCRE compliant regular expression",
// "Regular Expression Part" => "Regular Expression Part",
// "ex: \$1" => "ex: \$1",
// "Data to sort, one entry per line" => "Data to sort, one entry per line",
// "asc|desc|shuffle" => "asc|desc|shuffle",
// "Join Columns" => "Join Columns",
// "Generate the colspan attribute if columns are missing" => "Generate the colspan attribute if columns are missing",
// "Fixed Size" => "Fixed Size",
// "Generate the width attribute on the columns" => "Generate the width attribute on the columns",
// "Column Size" => "Column Size",
// "Editable" => "Editable",
// "Display edit icon for each section" => "Display edit icon for each section",
// "Custom class" => "Custom class",
// "add a class to customize the design" => "add a class to customize the design",
// "SQL" => "SQL",
// "DNS Name" => "DNS Name",
// "ADODB DNS" => "ADODB DNS",
// "Stat" => "Stat",
// "Displays some stats" => "Displays some stats",
// "separated by " => "separated by ",
// "Parent Id" => "Parent Id",
// "Added last hour" => "Added last hour",
// "Added last 24 hours" => "Added last 24 hours",
// "Added since the beginning of the day" => "Added since the beginning of the day",
// "Added(a) or viewed(v) since the beginning of the day" => "Added(a) or viewed(v) since the beginning of the day",
// "Added last 7 days" => "Added last 7 days",
// "Added(a) or viewed(v) last 7 days" => "Added(a) or viewed(v) last 7 days",
// "Added since the beginning of the week" => "Added since the beginning of the week",
// "Added(a) or viewed(v) since the beginning of the week" => "Added(a) or viewed(v) since the beginning of the week",
// "Added last month" => "Added last month",
// "Added(a) or viewed(v) last month" => "Added(a) or viewed(v) last month",
// "Added since the beginning of the month" => "Added since the beginning of the month",
// "Added(a) or viewed(v) since the beginning of the month" => "Added(a) or viewed(v) since the beginning of the month",
// "Added last year" => "Added last year",
// "Added(a) or viewed(v) last year" => "Added(a) or viewed(v) last year",
// "Added since the beginning of the year" => "Added since the beginning of the year",
// "Added(a) or viewed(v) since the beginning of the year" => "Added(a) or viewed(v) since the beginning of the year",
// "Subscript" => "Subscript",
// "Subscribe or unsubscribe to a group" => "Subscribe or unsubscribe to a group",
// "Subscribe Group" => "Subscribe Group",
// "Group Name" => "Group Name",
// "As known in Tikiwiki" => "As known in Tikiwiki",
// "Subscribe Text" => "Subscribe Text",
// "Subscribe text, containing %s as the placeholder for the group name" => "Subscribe text, containing %s as the placeholder for the group name",
// "Unsubscribe Text" => "Unsubscribe Text",
// "Unsubscribe text, containing %s as the placeholder for the group name" => "Unsubscribe text, containing %s as the placeholder for the group name",
// "Subscribe Action" => "Subscribe Action",
// "Subscribe button label, containing %s as the placeholder for the group name" => "Subscribe button label, containing %s as the placeholder for the group name",
// "Unsubscribe Action" => "Unsubscribe Action",
// "Unsubscribe button label, containing %s as the placeholder for the group name" => "Unsubscribe button label, containing %s as the placeholder for the group name",
// "Subscribe Groups" => "Subscribe Groups",
// "Show subscribe box" => "Show subscribe box",
// "Show default setting and buttons" => "Show default setting and buttons",
// "Show group description" => "Show group description",
// "Colon separated list of groups" => "Colon separated list of groups",
// "After changing default" => "After changing default",
// "Superscript" => "Superscript",
// "Displays text in superscript (exponent)" => "Displays text in superscript (exponent)",
// "Displays text in superscript" => "Displays text in superscript",
// "Wiki Page to redirect the user after his vote" => "Wiki Page to redirect the user after his vote",
// "Displays a survey" => "Displays a survey",
// "Tabs" => "Tabs",
// "Provides tabs built using the smarty tabset block" => "Provides tabs built using the smarty tabset block",
// "Tabs content separated by /////" => "Tabs content separated by /////",
// "Tabset name" => "Tabset name",
// "Unique tabset name (if you want it to remember its last state). Ex: user_profile_tabs" => "Unique tabset name (if you want it to remember its last state). Ex: user_profile_tabs",
// "Tab titles" => "Tab titles",
// "Pipe separated list of tab titles. Ex: tab 1|tab 2|tab 3" => "Pipe separated list of tab titles. Ex: tab 1|tab 2|tab 3",
// "Displays a set of tabs" => "Displays a set of tabs",
// "No tab title specified. At least one has to be set to make the tabs appear" => "No tab title specified. At least one has to be set to make the tabs appear",
// "Tag" => "Tag",
// "Displays the text between an html tag" => "Displays the text between an html tag",
// "Tag Name" => "Tag Name",
// "Any valid HTML tag, span by default" => "Any valid HTML tag, span by default",
// "Equivalent to the style attribute of an HTML tag" => "Equivalent to the style attribute of an HTML tag",
// "Displays text between HTML tags" => "Displays text between HTML tags",
// "File ID from the file gallery" => "File ID from the file gallery",
// "Image ID from the image gallery" => "Image ID from the image gallery",
// "URL to the image" => "URL to the image",
// "Maximum Size" => "Maximum Size",
// "Maximum width or height for the image" => "Maximum width or height for the image",
// "Floating" => "Floating",
// "Link target of the image" => "Link target of the image",
// "No image specified" => "No image specified",
// "Title Search" => "Title Search",
// "Search wiki page titles" => "Search wiki page titles",
// "Search Criteria" => "Search Criteria",
// "Portion of a page name" => "Portion of a page name",
// "hits|user" => "hits|user",
// "Pipe-separated list of page names to exclude from results" => "Pipe-separated list of page names to exclude from results",
// "Table of Contents (Structure)" => "Table of Contents (Structure)",
// "Displays the table of contents for the current structure\\'s subtree as part of the page content" => "Displays the table of contents for the current structure\\'s subtree as part of the page content",
// "Maximum Depth" => "Maximum Depth",
// "Maximum number of levels to display. On very large structures, this should be limited" => "Maximum number of levels to display. On very large structures, this should be limited",
// "By default, structure for the current page will be displayed. Alternate structure may be provided" => "By default, structure for the current page will be displayed. Alternate structure may be provided",
// "asc|desc" => "asc|desc",
// "Show Description" => "Show Description",
// "0|1, show the page description instead of the page name" => "0|1, show the page description instead of the page name",
// "Show Numbering" => "Show Numbering",
// "0|1, display the section numbers or not" => "0|1, display the section numbers or not",
// "plain|fancy" => "plain|fancy",
// "Top Friends" => "Top Friends",
// "List top-scoring users" => "List top-scoring users",
// "Maximum result count" => "Maximum result count",
// "Translate a string using Tikiwiki translation table" => "Translate a string using Tikiwiki translation table",
// "string" => "string",
// "Translate a string" => "Translate a string",
// "Colon-separated list of field IDs to be displayed. Example: 2:4:5" => "Colon-separated list of field IDs to be displayed. Example: 2:4:5",
// "Label on the submit button" => "Label on the submit button",
// "Show Title" => "Show Title",
// "Show Mandatory" => "Show Mandatory",
// "Embedded" => "Embedded",
// "URL used for the field links" => "URL used for the field links",
// "Url target" => "Url target",
// "Values" => "Values",
// "Colon-separated list of values" => "Colon-separated list of values",
// "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or " => "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or ",
// "Reset" => "Reset",
// "Label for the reset button, to return all fields to their default values" => "Label for the reset button, to return all fields to their default values",
// "user|page" => "user|page",
// "itemId" => "itemId",
// "itemId if you want to edit an item" => "itemId if you want to edit an item",
// "Template File" => "Template File",
// "Name of the template used to display the tracker items" => "Name of the template used to display the tracker items",
// "Name of the wiki page containing the template to display the tracker items" => "Name of the wiki page containing the template to display the tracker items",
// "New Status" => "New Status",
// "Default status applied to newly created items" => "Default status applied to newly created items",
// "Width of first column " => "Width of first column ",
// "Specify the width in pixels or percentage of the first column in the tracker form" => "Specify the width in pixels or percentage of the first column in the tracker form",
// "Incorrect fieldId" => "Incorrect fieldId",
// "Following fields are incorrect" => "Following fields are incorrect",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "You do not have permission to modify an item" => "You do not have permission to modify an item",
// "Filters" => "Filters",
// "Display List" => "Display List",
// "Line" => "Line",
// "Tracker Filter" => "Tracker Filter",
// "notice" => "notice",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "Filters the items of a tracker, fields are indicated with numeric ids" => "Filters the items of a tracker, fields are indicated with numeric ids",
// "Wiki text" => "Wiki text",
// "Tracker Item Field" => "Tracker Item Field",
// "Wiki text containing an {ELSE} marker" => "Wiki text containing an {ELSE} marker",
// "Item ID" => "Item ID",
// "Field ID" => "Field ID",
// "Colon separated list of field IDs" => "Colon separated list of field IDs",
// "o|p|c|op|oc|pc|opc" => "o|p|c|op|oc|pc|opc",
// "Test" => "Test",
// "Value to compare against" => "Value to compare against",
// "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)" => "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)",
// "Tracker List" => "Tracker List",
// "Notice" => "Notice",
// "Colon-separated list of fields to display on click. Example: 6:7" => "Colon-separated list of fields to display on click. Example: 6:7",
// "Sticky Popup" => "Sticky Popup",
// "Show Links" => "Show Links",
// "shownbitems" => "shownbitems",
// "Show Initials" => "Show Initials",
// "Show Status" => "Show Status",
// "Show Creation Date" => "Show Creation Date",
// "Show Last Modification" => "Show Last Modification",
// "Show Field Name" => "Show Field Name",
// "Show Item Rank" => "Show Item Rank",
// "Status Filter" => "Status Filter",
// "Which item status to list. o = open, p = pending, c = closed" => "Which item status to list. o = open, p = pending, c = closed",
// "Sort Mode" => "Sort Mode",
// "Maximum number of items" => "Maximum number of items",
// "Show pagination" => "Show pagination",
// "Filter Field" => "Filter Field",
// "Colon separated list of fields to allow filtering on" => "Colon separated list of fields to allow filtering on",
// "Filter Value" => "Filter Value",
// "Exact Value" => "Exact Value",
// "Checkbox" => "Checkbox",
// "goIfOne" => "goIfOne",
// "More" => "More",
// "More URL" => "More URL",
// "More Url" => "More Url",
// "Select automatically the item of the current user or the page" => "Select automatically the item of the current user or the page",
// "View User" => "View User",
// "Item ID separated with " => "Item ID separated with ",
// "List of items Ids" => "List of items Ids",
// "link url" => "link url",
// "Left Deliminator" => "Left Deliminator",
// "Right Deliminator" => "Right Deliminator",
// "If y, value will be truncated" => "If y, value will be truncated",
// "Export Button" => "Export Button",
// "Compute" => "Compute",
// "Sum or average all the values of a field  and displays it at the bottom of the table" => "Sum or average all the values of a field  and displays it at the bottom of the table",
// "fieldId" => "fieldId",
// "Show nothing if no items" => "Show nothing if no items",
// "incorrect filterfield" => "incorrect filterfield",
// "Displays a button to link to a page with a tracker plugin with prefilled tracker fields" => "Displays a button to link to a page with a tracker plugin with prefilled tracker fields",
// "Tracker Prefill" => "Tracker Prefill",
// "Tracker page name" => "Tracker page name",
// "Button label" => "Button label",
// "Field 1" => "Field 1",
// "Value 1" => "Value 1",
// "Content of the field" => "Content of the field",
// "Field 2" => "Field 2",
// "Value 2" => "Value 2",
// "Field 3" => "Field 3",
// "Value 3" => "Value 3",
// "Field 4" => "Field 4",
// "Value 4" => "Value 4",
// "Field 5" => "Field 5",
// "Value 5" => "Value 5",
// "Tracker Stats" => "Tracker Stats",
// "Show link to tiki-view_tracker" => "Show link to tiki-view_tracker",
// "Displays some stat of a tracker content, fields are indicated with numeric ids" => "Displays some stat of a tracker content, fields are indicated with numeric ids",
// "incorrect fieldId" => "incorrect fieldId",
// "Tracker Timeline" => "Tracker Timeline",
// "Timeline view of a tracker, can be used to display event schedules or gantt charts" => "Timeline view of a tracker, can be used to display event schedules or gantt charts",
// "Title Field" => "Title Field",
// "Tracker Field ID containing the item title" => "Tracker Field ID containing the item title",
// "Summary Field" => "Summary Field",
// "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused" => "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused",
// "Start Date" => "Start Date",
// "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field",
// "End Date" => "End Date",
// "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field",
// "Element Group" => "Element Group",
// "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row" => "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row",
// "Lower Bound" => "Lower Bound",
// "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Upper Bound" => "Upper Bound",
// "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Primary Scale Unit" => "Primary Scale Unit",
// "hour, day, week, month or year (default to hour)" => "hour, day, week, month or year (default to hour)",
// "Secondary Scale Unit" => "Secondary Scale Unit",
// "hour, day, week, month, year or empty (default to empty)" => "hour, day, week, month, year or empty (default to empty)",
// "Link Group Name" => "Link Group Name",
// "Convert the group name to a link. (y|n)" => "Convert the group name to a link. (y|n)",
// "Page Link Field" => "Page Link Field",
// "Tracker Field ID containing the page name for item details" => "Tracker Field ID containing the page name for item details",
// "Missing parameter: %0" => "Missing parameter: %0",
// "Start date after end date" => "Start date after end date",
// "Translated" => "Translated",
// "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)" => "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)",
// "Two letter language code of the language, ex: fr" => "Two letter language code of the language, ex: fr",
// "Country name, ex: France" => "Country name, ex: France",
// "User Count" => "User Count",
// "Group name" => "Group name",
// "Displays a list of registered users" => "Displays a list of registered users",
// "Display the user\\'s real name instead of login name" => "Display the user\\'s real name instead of login name",
// "Userpref" => "Userpref",
// "Display wiki text if user has a pref set to a value" => "Display wiki text if user has a pref set to a value",
// "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default" => "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default",
// "Navigation" => "Navigation",
// "Displays a navigation box that allows users to select a specific version to display" => "Displays a navigation box that allows users to select a specific version to display",
// "Display the current version name as the title. Note: Do not work when nav=>y" => "Display the current version name as the title. Note: Do not work when nav=>y",
// "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'" => "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'",
// "This is the default text" => "This is the default text",
// "(version 3)" => "(version 3)",
// "This is version 3 info" => "This is version 3 info",
// "(version 2)" => "(version 2)",
// "This is version 2 info" => "This is version 2 info",
// "(version 1)" => "(version 1)",
// "This is version 1 info" => "This is version 1 info",
// "Show Stats" => "Show Stats",
// "Show Stats After" => "Show Stats After",
// "Show Creator" => "Show Creator",
// "Wanted Pages" => "Wanted Pages",
// "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)" => "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)",
// "Ignore" => "Ignore",
// "Split By" => "Split By",
// "Skip Extension" => "Skip Extension",
// "Collect" => "Collect",
// "Level" => "Level",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored" => "A wildcard pattern of originating pages to be ignored",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated" => "The character, by which ignored patterns are separated",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list" => "Whether to include external wikis in the list",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column" => "Collect either originating or wanted pages in a cell and display them in the second column",
// "Switch-on debug output with details about the items" => "Switch-on debug output with details about the items",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex",
// "A custom filter for wanted pages to be listed (only used when level=>custom)" => "A custom filter for wanted pages to be listed (only used when level=>custom)",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "Lists ''wanted'' wiki pages" => "Lists ''wanted'' wiki pages",
// "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)" => "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)",
// "The character, by which ignored patterns are separated. possible values: characters" => "The character, by which ignored patterns are separated. possible values: characters",
// "Whether to include external wikis in the list. possible values" => "Whether to include external wikis in the list. possible values",
// "Collect either originating or wanted pages in a cell and display them in the second column. possible values" => "Collect either originating or wanted pages in a cell and display them in the second column. possible values",
// "Switch-on debug output with details about the items. possible values" => "Switch-on debug output with details about the items. possible values",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "ignored" => "ignored",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output" => "End of debug output",
// "Wanted Page" => "Wanted Page",
// "Referenced By Page" => "Referenced By Page",
// "Web Service" => "Web Service",
// "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface" => "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface",
// "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter" => "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter",
// "Complete service URL" => "Complete service URL",
// "Service Name" => "Service Name",
// "Registered service name" => "Registered service name",
// "Template Name" => "Template Name",
// "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided" => "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided",
// "Body as Parameter" => "Body as Parameter",
// "Name of the argument to send the body as for services with complex input. Named service required for this to be useful" => "Name of the argument to send the body as for services with complex input. Named service required for this to be useful",
// "Unknown Template" => "Unknown Template",
// "Unknown Service" => "Unknown Service",
// "Missing parameters" => "Missing parameters",
// "Youtube" => "Youtube",
// "Display youtube video in a wiki page" => "Display youtube video in a wiki page",
// "URL to the Youtube video" => "URL to the Youtube video",
// "width" => "width",
// "height" => "height",
// "quality" => "quality",
// "Missing parameter movie to the youtube plugin" => "Missing parameter movie to the youtube plugin",
// "Cannot create aliased page" => "Cannot create aliased page",
// "You attempted to create the following page" => "You attempted to create the following page",
// "That page is an alias for the following pages" => "That page is an alias for the following pages",
// "If you want to create the page, you must first edit each the pages above, and remove the alias link it may contain. This link should look something like this" => "If you want to create the page, you must first edit each the pages above, and remove the alias link it may contain. This link should look something like this",
// "Can't parse HTML data - no grammar file" => "Can't parse HTML data - no grammar file",
// "Removed version \$version" => "Removed version \$version",
// "rollback version " => "rollback version ",
// "Changed actual version to \$version" => "Changed actual version to \$version",
// "Plugin " => "Plugin ",
// "Semantic token already exists" => "Semantic token already exists",
// "Invalid semantic token name" => "Invalid semantic token name",
// "Semantic token not found" => "Semantic token not found",
// "Page locked" => "Page locked",
// "Page unlocked" => "Page unlocked",
// "Removed last version" => "Removed last version",
// "User %s does not have the permission" => "User %s does not have the permission",
// "The message has been sent to" => "The message has been sent to",
// "The message will be sent to" => "The message will be sent to",
// "User %s does not want to receive messages" => "User %s does not want to receive messages",
// "Sent box is full. Archive or delete some sent messages first if you want to send more messages" => "Sent box is full. Archive or delete some sent messages first if you want to send more messages",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "User %s can not receive messages, mailbox is full" => "User %s can not receive messages, mailbox is full",
// "User %s can not receive messages" => "User %s can not receive messages",
// "Invalid user: %s" => "Invalid user: %s",
// "Archive is full. Delete some messages from archive first" => "Archive is full. Delete some messages from archive first",
// "Displays a calendar of system events, such as wiki page modifications, forum posts and article publications. Days with events show links to the action calendar page" => "Displays a calendar of system events, such as wiki page modifications, forum posts and article publications. Days with events show links to the action calendar page",
// "Item types filter" => "Item types filter",
// "If set to a list of item types, restricts the items displayed to those of one of these types. Each set is a comma-separated list of item type codes" => "If set to a list of item types, restricts the items displayed to those of one of these types. Each set is a comma-separated list of item type codes",
// "Possible item type values" => "Possible item type values",
// "Google AdSense" => "Google AdSense",
// "Displays a text/image Google AdSense advertisement. This module should be updated to support new Google code" => "Displays a text/image Google AdSense advertisement. This module should be updated to support new Google code",
// "Advertisement channel, as optionally provided by Google" => "Advertisement channel, as optionally provided by Google",
// "As provided by Google. Format: \"pub-xxxxxxxxxxxxxxxx\"" => "As provided by Google. Format: \"pub-xxxxxxxxxxxxxxxx\"",
// "Global banner format as provided by Google. For example: \"display=468*60_as\"" => "Global banner format as provided by Google. For example: \"display=468*60_as\"",
// "Background color, as optionally provided by Google" => "Background color, as optionally provided by Google",
// "Border color, as optionally provided by Google" => "Border color, as optionally provided by Google",
// "Link color, as optionally provided by Google" => "Link color, as optionally provided by Google",
// "Text color, as optionally provided by Google" => "Text color, as optionally provided by Google",
// "URL color, as optionally provided by Google" => "URL color, as optionally provided by Google",
// "Article archives" => "Article archives",
// "Shows links to the published articles for each month" => "Shows links to the published articles for each month",
// "If set to \"y\", displays a button labelled \"More...\" that links to a paginated view of the selected articles" => "If set to \"y\", displays a button labelled \"More...\" that links to a paginated view of the selected articles",
// "Default: \"n\"" => "Default: \"n\"",
// "Category filter" => "Category filter",
// "If set to a category identifier, only consider the articles in the specified category" => "If set to a category identifier, only consider the articles in the specified category",
// "Example value: 13" => "Example value: 13",
// "Not set by default" => "Not set by default",
// "Topic filter (by names)" => "Topic filter (by names)",
// "If set to a list of article topic names separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered" => "If set to a list of article topic names separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered",
// "Example values" => "Example values",
// "Topic filter (by identifiers)" => "Topic filter (by identifiers)",
// "If set to a list of article topic identifiers separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered" => "If set to a list of article topic identifiers separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered",
// "Example values: 13, !13, 1+3, !1+5+7" => "Example values: 13, !13, 1+3, !1+5+7",
// "Types filter" => "Types filter",
// "If set to a list of article type names separated by plus signs, only consider the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not considered" => "If set to a list of article type names separated by plus signs, only consider the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not considered",
// "Example values: Event, !Event, Event+Review, !Event+Classified+Article" => "Example values: Event, !Event, Event+Review, !Event+Classified+Article",
// "Language filter" => "Language filter",
// "If set to a language code, only consider the articles in the specified language" => "If set to a language code, only consider the articles in the specified language",
// "Article Topics" => "Article Topics",
// "Lists all article topics with links to their articles" => "Lists all article topics with links to their articles",
// "Lists the specified number of published articles in the specified order" => "Lists the specified number of published articles in the specified order",
// "Show publication time" => "Show publication time",
// "If set to \"y\", article publication times are shown" => "If set to \"y\", article publication times are shown",
// "Show creation time" => "Show creation time",
// "If set to \"y\", article creation times are shown" => "If set to \"y\", article creation times are shown",
// "Show rating selector" => "Show rating selector",
// "If set to \"y\", offers the user to filter articles based on a minimum and a maximum rating" => "If set to \"y\", offers the user to filter articles based on a minimum and a maximum rating",
// "If set, displays an image for each article if one applies, with the given width (in pixels). The article\\'s own image is used, with a fallback to the article\\'s topic image" => "If set, displays an image for each article if one applies, with the given width (in pixels). The article\\'s own image is used, with a fallback to the article\\'s topic image",
// "If set to a category identifier, only lists the articles in the specified category" => "If set to a category identifier, only lists the articles in the specified category",
// "If set to a list of article topic names separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed" => "If set to a list of article topic names separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed",
// "If set to a list of article topic identifiers separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed" => "If set to a list of article topic identifiers separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed",
// "If set to a list of article type names separated by plus signs, only lists the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not listed" => "If set to a list of article type names separated by plus signs, only lists the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not listed",
// "If set to a language code, only lists the articles in the specified language" => "If set to a language code, only lists the articles in the specified language",
// "Specifies how the articles should be sorted" => "Specifies how the articles should be sorted",
// "Possible values include created and created_asc (equivalent), created_desc, author, rating, topicId, lang and title. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on article creation date" => "Possible values include created and created_asc (equivalent), created_desc, author, rating, topicId, lang and title. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on article creation date",
// "If set to an integer, offsets the articles list by the given number. For example, if the module was otherwise set to list the 10 articles most recently published, setting the offset to 10 would make the module list the 11th to 20th articles in descending order of publication time instead" => "If set to an integer, offsets the articles list by the given number. For example, if the module was otherwise set to list the 10 articles most recently published, setting the offset to 10 would make the module list the 11th to 20th articles in descending order of publication time instead",
// "If set to \"y\", displays a button labelled \"More\" that links to a paginated view of the selected articles" => "If set to \"y\", displays a button labelled \"More\" that links to a paginated view of the selected articles",
// "Absolute URL" => "Absolute URL",
// "If set to \"y\", some of the links use an absolute URL instead of a relative one. This can avoid broken links if the module is to be sent in a newsletter, for example" => "If set to \"y\", some of the links use an absolute URL instead of a relative one. This can avoid broken links if the module is to be sent in a newsletter, for example",
// "TikiWiki assistant" => "TikiWiki assistant",
// "Displays an assistant to guide new Tiki admins" => "Displays an assistant to guide new Tiki admins",
// "Last blog post comments" => "Last blog post comments",
// "Displays the specified number of the blog post comments most recently added" => "Displays the specified number of the blog post comments most recently added",
// "More in tooltips" => "More in tooltips",
// "If set to \"y\", the post on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip" => "If set to \"y\", the post on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip",
// "No date" => "No date",
// "If set to \"y\", the date at which comments were posted is not displayed in the module box" => "If set to \"y\", the date at which comments were posted is not displayed in the module box",
// "Last visited pages" => "Last visited pages",
// "Displays the last Wiki pages visited by the user" => "Displays the last Wiki pages visited by the user",
// "Maximum length" => "Maximum length",
// "Maximum number of characters in page names allowed before truncating" => "Maximum number of characters in page names allowed before truncating",
// "Includes a calendar or a list of calendar events" => "Includes a calendar or a list of calendar events",
// "Displayed month (relative)" => "Displayed month (relative)",
// "Distance in month to the month to display. A distance of -1 would display the previous month. Setting this option implies a calendar view type with a month time span" => "Distance in month to the month to display. A distance of -1 would display the previous month. Setting this option implies a calendar view type with a month time span",
// "Displays links to categories as a tree" => "Displays links to categories as a tree",
// "Object type filter" => "Object type filter",
// "Object type filter to apply when accessing a linked category. Example values" => "Object type filter to apply when accessing a linked category. Example values",
// "Deep" => "Deep",
// "Show subcategories objects when accessing a linked category. Possible values: on (default), off" => "Show subcategories objects when accessing a linked category. Possible values: on (default), off",
// "PHP Layers menu style" => "PHP Layers menu style",
// "Sets the menu style if PHP Layers is enabled. Possible values: tree (default), vert, horiz, plain, phptree" => "Sets the menu style if PHP Layers is enabled. Possible values: tree (default), vert, horiz, plain, phptree",
// "Limits displayed categories to a subtree of categories starting with the category with the given ID. Example value: 11. Default: 0 (don\\'t limit display)" => "Limits displayed categories to a subtree of categories starting with the category with the given ID. Example value: 11. Default: 0 (don\\'t limit display)",
// "Category Transitions" => "Category Transitions",
// "Displays controls to trigger category transitions and change the page\\'s state according to predefined rules" => "Displays controls to trigger category transitions and change the page\\'s state according to predefined rules",
// "Change Category" => "Change Category",
// "Enables to categorize an object" => "Enables to categorize an object",
// "Category identifier" => "Category identifier",
// "Changes the root of the displayed categories from default \"TOP\" to the category with the given identifier" => "Changes the root of the displayed categories from default \"TOP\" to the category with the given identifier",
// "Note that the root category is not displayed" => "Note that the root category is not displayed",
// "Defaults to 0 (root)" => "Defaults to 0 (root)",
// "No top" => "No top",
// "In non-detailed view, disallow uncategorizing. Example value: 1" => "In non-detailed view, disallow uncategorizing. Example value: 1",
// "Display path" => "Display path",
// "Instead of category names, diplay their path in the category tree starting from the category root defined" => "Instead of category names, diplay their path in the category tree starting from the category root defined",
// "Example value: 1" => "Example value: 1",
// "Multiple categories" => "Multiple categories",
// "If set to \"n\", only allows categorizing in one category (from those displayed)" => "If set to \"n\", only allows categorizing in one category (from those displayed)",
// "String to display on the button to submit new categories, when multiple categories is enabled. Default value: Categorize" => "String to display on the button to submit new categories, when multiple categories is enabled. Default value: Categorize",
// "Shy" => "Shy",
// "If set to \"y\", the module is not shown on pages which are not already categorized.' . \" \" . tra('Not set by default" => "If set to \"y\", the module is not shown on pages which are not already categorized.' . \" \" . tra('Not set by default",
// "Detailed" => "Detailed",
// "If set to \"y\", shows a list of categories in which the object is. If deletion is not disabled, it is done with the list" => "If set to \"y\", shows a list of categories in which the object is. If deletion is not disabled, it is done with the list",
// "If set to \"n\", the detailed list of categories will not offer to unassign a category" => "If set to \"n\", the detailed list of categories will not offer to unassign a category",
// "If set to \"y\", allow to assign new categories" => "If set to \"y\", allow to assign new categories",
// "Example values: y, n" => "Example values: y, n",
// "Default value: y" => "Default value: y",
// "Default value: n" => "Default value: n",
// "Image URL not in category" => "Image URL not in category",
// "Very particular parameter. If both this and \"Image URL in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is not in the category" => "Very particular parameter. If both this and \"Image URL in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is not in the category",
// "Example value" => "Example value",
// "Image URL in category" => "Image URL in category",
// "Very particular parameter. If both this and \"Image URL not in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is in the category" => "Very particular parameter. If both this and \"Image URL not in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is in the category",
// "Categorize %s" => "Categorize %s",
// "Categorize %s in %s" => "Categorize %s in %s",
// "Displays the number of pages received (via Communications)" => "Displays the number of pages received (via Communications)",
// "Last directory sites" => "Last directory sites",
// "Displays the specified number of the directory sites most recently added" => "Displays the specified number of the directory sites most recently added",
// "Directory category identifier" => "Directory category identifier",
// "If set to a directory category identifier, only displays the sites in the specified directory category" => "If set to a directory category identifier, only displays the sites in the specified directory category",
// "If set to \"y\", displays a button labelled \"More\" that links to the directory" => "If set to \"y\", displays a button labelled \"More\" that links to the directory",
// "Directory statistics" => "Directory statistics",
// "Displays statistics about the directory, including the number of sites validated and to validate, the number of categories, of searches and of visited links" => "Displays statistics about the directory, including the number of sites validated and to validate, the number of categories, of searches and of visited links",
// "Top directory sites" => "Top directory sites",
// "Displays the specified number of the directory sites from most visited to least visited" => "Displays the specified number of the directory sites from most visited to least visited",
// "Displays the site\\'s first featured links" => "Displays the site\\'s first featured links",
// "Displays links to file galleries" => "Displays links to file galleries",
// "Best rated topics" => "Best rated topics",
// "Displays the specified number of the forum topics with the best ratings" => "Displays the specified number of the forum topics with the best ratings",
// "Displays the latest forum posts" => "Displays the latest forum posts",
// "If set to \"y\", only displays topics" => "If set to \"y\", only displays topics",
// "Displays the specified number of the forums with the most comments" => "Displays the specified number of the forums with the most comments",
// "Displays the specified number of the forum topics with the most reads" => "Displays the specified number of the forum topics with the most reads",
// "Displays the specified number of the forums with the most visits" => "Displays the specified number of the forums with the most visits",
// "Freetags editor" => "Freetags editor",
// "Shows current freetags and enables to add and remove some if permissions allow" => "Shows current freetags and enables to add and remove some if permissions allow",
// "Freetags Wiki" => "Freetags Wiki",
// "Displays current freetags on wiki pages and enables to add tags if permissions allow" => "Displays current freetags on wiki pages and enables to add tags if permissions allow",
// "Similar freetags" => "Similar freetags",
// "Shows wiki pages with similar freetags" => "Shows wiki pages with similar freetags",
// "Similar pages" => "Similar pages",
// "Most popular tags" => "Most popular tags",
// "Shows the most popular freetags. More popularity is indicated by a larger font" => "Shows the most popular freetags. More popularity is indicated by a larger font",
// "Display type" => "Display type",
// "If set to \"cloud\", links are displayed as a cloud" => "If set to \"cloud\", links are displayed as a cloud",
// "Default: \"list\"" => "Default: \"list\"",
// "Maximum elements" => "Maximum elements",
// "If set to a number, limits the number of tags displayed" => "If set to a number, limits the number of tags displayed",
// "User preferred tags" => "User preferred tags",
// "Displays to registered users the freetags they prefer, based on the number of objects they added the tag to. More preference is indicated by a larger font" => "Displays to registered users the freetags they prefer, based on the number of objects they added the tag to. More preference is indicated by a larger font",
// "My preferred tags" => "My preferred tags",
// "Displays a simple form to search on Google. By default, search results are limited to those on the Tiki site" => "Displays a simple form to search on Google. By default, search results are limited to those on the Tiki site",
// "Groups emulation" => "Groups emulation",
// "Enables temporarily changing one\\'s group memberships to see how users in fewer groups experience the site" => "Enables temporarily changing one\\'s group memberships to see how users in fewer groups experience the site",
// "Emulate Groups" => "Emulate Groups",
// "Displays the specified number of last actions" => "Displays the specified number of last actions",
// "Show user" => "Show user",
// "If set to \"y\", user names are displayed in the module box" => "If set to \"y\", user names are displayed in the module box",
// "Show date" => "Show date",
// "If set to \"y\", action dates are displayed in the module box" => "If set to \"y\", action dates are displayed in the module box",
// "Maximum number of characters in action descriptions before truncating" => "Maximum number of characters in action descriptions before truncating",
// "Lists the specified number of blogs posts from newest to oldest" => "Lists the specified number of blogs posts from newest to oldest",
// "If set to \"y\", the date of posts is not displayed in the module box" => "If set to \"y\", the date of posts is not displayed in the module box",
// "Blog identifier" => "Blog identifier",
// "If set to a blog identifier, restricts the blog posts to those in the identified blog" => "If set to a blog identifier, restricts the blog posts to those in the identified blog",
// "Last category objects" => "Last category objects",
// "Lists the specified number of objects of the given type in the given category, starting from the most recently created" => "Lists the specified number of objects of the given type in the given category, starting from the most recently created",
// "Identifier of the category from which objects are listed. Objects merely in child categories will not be displayed" => "Identifier of the category from which objects are listed. Objects merely in child categories will not be displayed",
// "Maximum number of characters in object names allowed before truncating" => "Maximum number of characters in object names allowed before truncating",
// "Type of the objects to list. Example values" => "Type of the objects to list. Example values",
// "Displays the specified number of blogs from newest to oldest" => "Displays the specified number of blogs from newest to oldest",
// "Displays the specified number of FAQs from newest to oldest" => "Displays the specified number of FAQs from newest to oldest",
// "Displays the specified number of quizzes from newest to oldest" => "Displays the specified number of quizzes from newest to oldest",
// "Displays the specified number of file galleries, starting from the most recently modified" => "Displays the specified number of file galleries, starting from the most recently modified",
// "List the specified number of files, starting from the most recently added" => "List the specified number of files, starting from the most recently added",
// "Gallery identifiers" => "Gallery identifiers",
// "If set to a set of file gallery identifiers, restricts the files to those in the identified galleries. The value is a colon-separated sequence of integers" => "If set to a set of file gallery identifiers, restricts the files to those in the identified galleries. The value is a colon-separated sequence of integers",
// "Example value: 13, 2:13, 1:2:3:5:6" => "Example value: 13, 2:13, 1:2:3:5:6",
// "Last modified image galleries" => "Last modified image galleries",
// "Displays the specified number of image galleries, starting from the most recently modified" => "Displays the specified number of image galleries, starting from the most recently modified",
// "List the specified number of images, starting from the most recently added" => "List the specified number of images, starting from the most recently added",
// "Gallery identifier" => "Gallery identifier",
// "If set to an image gallery identifier, restricts the images to those in the identified gallery" => "If set to an image gallery identifier, restricts the images to those in the identified gallery",
// "Link content" => "Link content",
// "Display the links as image names or thumbnails" => "Display the links as image names or thumbnails",
// "Possible values: \"names\" or \"thumbnails\". Default value: \"names\"" => "Possible values: \"names\" or \"thumbnails\". Default value: \"names\"",
// "Displays the specified number of calendar events, starting from the most recently modified" => "Displays the specified number of calendar events, starting from the most recently modified",
// "Calendar identifier" => "Calendar identifier",
// "If set to a calendar identifier, restricts the events to those in the identified calendar" => "If set to a calendar identifier, restricts the events to those in the identified calendar",
// "Maximum number of characters in event names allowed before truncating" => "Maximum number of characters in event names allowed before truncating",
// "Lists the specified number of pages, starting from the most recently modified" => "Lists the specified number of pages, starting from the most recently modified",
// "Link target" => "Link target",
// "Target URL of the \"...more\" link at the bottom of the module" => "Target URL of the \"...more\" link at the bottom of the module",
// "Displays the specified number of blogs, starting from the most recently modified" => "Displays the specified number of blogs, starting from the most recently modified",
// "Lists the specified number of article submissions from newest to oldest" => "Lists the specified number of article submissions from newest to oldest",
// "Last tracker comments" => "Last tracker comments",
// "Lists the specified number of tracker comments (optionally restricting to those in a specific tracker or tracker item) starting from the most recently posted" => "Lists the specified number of tracker comments (optionally restricting to those in a specific tracker or tracker item) starting from the most recently posted",
// "Tracker identifier" => "Tracker identifier",
// "If set to a tracker identifier, only displays the comments on the given tracker" => "If set to a tracker identifier, only displays the comments on the given tracker",
// "Item identifier" => "Item identifier",
// "If set to an item identifier, only displays the comments on the given item" => "If set to an item identifier, only displays the comments on the given item",
// "Last tracker items" => "Last tracker items",
// "Displays the value of a field of the specified number of tracker items. If the specified tracker has no main field, either Field name or Field identifier is required" => "Displays the value of a field of the specified number of tracker items. If the specified tracker has no main field, either Field name or Field identifier is required",
// "Identifier of the tracker from which items are listed" => "Identifier of the tracker from which items are listed",
// "Field identifier" => "Field identifier",
// "Identifier of the field from which values are listed. If Field name is set, this parameter is ignored" => "Identifier of the field from which values are listed. If Field name is set, this parameter is ignored",
// "Field name" => "Field name",
// "Name of the field from which values are listed" => "Name of the field from which values are listed",
// "Example value: age" => "Example value: age",
// "Specifies how the items should be sorted" => "Specifies how the items should be sorted",
// "Possible values include created and created_asc (equivalent), created_desc, status, lastModif, createdBy and lastModifBy. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on item creation date. \"lastModif\" sorts on the last modification date of items. \"lastModif_desc\" sorts in descending order of last modification date" => "Possible values include created and created_asc (equivalent), created_desc, status, lastModif, createdBy and lastModifBy. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on item creation date. \"lastModif\" sorts on the last modification date of items. \"lastModif_desc\" sorts in descending order of last modification date",
// "Status filter" => "Status filter",
// "If set, limits the listed items to those with the given statuses. Values are combinations of \"o\" (open), \"p\" (pending) and \"c\" (closed). Possible values" => "If set, limits the listed items to those with the given statuses. Values are combinations of \"o\" (open), \"p\" (pending) and \"c\" (closed). Possible values",
// "Unable to determine which field to show. Tracker identifier may be invalid, or the tracker has no main field and neither Field identifier nor Field name were set" => "Unable to determine which field to show. Tracker identifier may be invalid, or the tracker has no main field and neither Field identifier nor Field name were set",
// "You do not have permission to view this tracker" => "You do not have permission to view this tracker",
// "Last Validated FAQs Questions" => "Last Validated FAQs Questions",
// "Displays the specified number of validated questions FAQs from newest to oldest" => "Displays the specified number of validated questions FAQs from newest to oldest",
// "Faq identifier" => "Faq identifier",
// "If set to a faq identifier, restricts the chosen questions to those in the identified faq" => "If set to a faq identifier, restricts the chosen questions to those in the identified faq",
// "Number of characters to display" => "Number of characters to display",
// "Displays information about the specified number of users in decreasing order of last login time" => "Displays information about the specified number of users in decreasing order of last login time",
// "Show avatars" => "Show avatars",
// "If set to \"y\", show user avatars" => "If set to \"y\", show user avatars",
// "Maximum number of characters in user names allowed before truncating" => "Maximum number of characters in user names allowed before truncating",
// "Tells users whether a live support operator is present and allows them to request support if possible. If the user is an operator, links to the operator console" => "Tells users whether a live support operator is present and allows them to request support if possible. If the user is an operator, links to the operator console",
// "Login box" => "Login box",
// "Input size" => "Input size",
// "Number of characters for username and password input fields" => "Number of characters for username and password input fields",
// "Logo" => "Logo",
// "Site logo, title and subtitle" => "Site logo, title and subtitle",
// "Menu page" => "Menu page",
// "Displays a Wiki page" => "Displays a Wiki page",
// "Page to display in the menu. Example value: HomePage" => "Page to display in the menu. Example value: HomePage",
// "Unread inter-user messages" => "Unread inter-user messages",
// "Displays to users their number of new inter-user messages and a link to their message box" => "Displays to users their number of new inter-user messages and a link to their message box",
// "Small live chat box" => "Small live chat box",
// "Channels" => "Channels",
// "List of chat channels. Channel names are separated by a comma (\",\")" => "List of chat channels. Channel names are separated by a comma (\",\")",
// "By default, a single channel named \"default\" exists" => "By default, a single channel named \"default\" exists",
// "Months links" => "Months links",
// "Links to the objects of a given type for the current month and those preceding it" => "Links to the objects of a given type for the current month and those preceding it",
// "Type of objects to link to" => "Type of objects to link to",
// "\"blogs\" for blog posts, \"cms\" for published articles" => "\"blogs\" for blog posts, \"cms\" for published articles",
// "Object identifier" => "Object identifier",
// "Identifier of an object with children to link to" => "Identifier of an object with children to link to",
// "This is required for the blog Object type" => "This is required for the blog Object type",
// "For example, an identifier of 3 and a blogs Object type will show links to the blog posts in the blog with identifier 3" => "For example, an identifier of 3 and a blogs Object type will show links to the blog posts in the blog with identifier 3",
// "List by month" => "List by month",
// "Displays the number of article submissions waiting examination and a link to the list" => "Displays the number of article submissions waiting examination and a link to the list",
// "Displays the specified number of old articles (which do not show on articles home page anymore)" => "Displays the specified number of old articles (which do not show on articles home page anymore)",
// "Enables to change current perspective" => "Enables to change current perspective",
// "Quick Edit" => "Quick Edit",
// "Enables to quickly create or edit Wiki pages" => "Enables to quickly create or edit Wiki pages",
// "Template identifier" => "Template identifier",
// "If set to a template identifier, the specified template is used for creating new Wiki pages" => "If set to a template identifier, the specified template is used for creating new Wiki pages",
// "If set, send the form to the given location (relative to Tiki\\'s root) for processing" => "If set, send the form to the given location (relative to Tiki\\'s root) for processing",
// "SUBMIT label" => "SUBMIT label",
// "The label on the button to submit the form" => "The label on the button to submit the form",
// "Size attribute (horizontal, in characters) of the text input field for page names" => "Size attribute (horizontal, in characters) of the text input field for page names",
// "Optional heading to display at the top of the module\\'s content" => "Optional heading to display at the top of the module\\'s content",
// "If set to a category identifier, pages created through the module are automatically categorized in the specified category" => "If set to a category identifier, pages created through the module are automatically categorized in the specified category",
// "Random image" => "Random image",
// "Displays a random image" => "Displays a random image",
// "If set to an image gallery identifier, restricts the chosen images to those in the identified gallery" => "If set to an image gallery identifier, restricts the chosen images to those in the identified gallery",
// "Show link" => "Show link",
// "If set to \"n\", the image thumbnail does not link to the image" => "If set to \"n\", the image thumbnail does not link to the image",
// "Default: \"y\"" => "Default: \"y\"",
// "Show name" => "Show name",
// "If set to \"y\", the name of the image is displayed" => "If set to \"y\", the name of the image is displayed",
// "If set to \"y\", the description of the image is displayed" => "If set to \"y\", the description of the image is displayed",
// "Displays the specified number of random wiki pages" => "Displays the specified number of random wiki pages",
// "New user registrationmore tiki-re" => "New user registrationmore tiki-re",
// "Feeds List" => "Feeds List",
// "List of feeds available on this site" => "List of feeds available on this site",
// "Search Box" => "Search Box",
// "Advanced search (for wiki, articles, blogs etc)" => "Advanced search (for wiki, articles, blogs etc)",
// "Search Box (new)" => "Search Box (new)",
// "Search Wiki Page" => "Search Wiki Page",
// "Search for a wiki page by name" => "Search for a wiki page by name",
// "Search Wiki Page (new)" => "Search Wiki Page (new)",
// "Lists the relationships known for the Wiki page displayed. For each relation type contained in the page, it lists all the pages it links to or gets linked from" => "Lists the relationships known for the Wiki page displayed. For each relation type contained in the page, it lists all the pages it links to or gets linked from",
// "The shoutbox is a quick messaging tool. Messages reload each time the page changes. Anyone with the right permission can see all messages. Another permission allows to send messages" => "The shoutbox is a quick messaging tool. Messages reload each time the page changes. Anyone with the right permission can see all messages. Another permission allows to send messages",
// "Tooltip" => "Tooltip",
// "If set to \"1\", displays message post dates and times as tooltips instead of showing directly in the module content" => "If set to \"1\", displays message post dates and times as tooltips instead of showing directly in the module content",
// "Label on the button to post a message" => "Label on the button to post a message",
// "Wait label" => "Wait label",
// "Label on the button to post a message when the message is being posted if AJAX is enabled" => "Label on the button to post a message when the message is being posted if AJAX is enabled",
// "Maximum messages shown" => "Maximum messages shown",
// "Number of messages to display" => "Number of messages to display",
// "Please wait.." => "Please wait..",
// "Since last visit (simple)" => "Since last visit (simple)",
// "Displays to logged in users the number of new or updated objects since their last login date and time" => "Displays to logged in users the number of new or updated objects since their last login date and time",
// "Since last visit" => "Since last visit",
// "Displays to logged in users new or updated objects since a point in time, by default their last login date and time" => "Displays to logged in users new or updated objects since a point in time, by default their last login date and time",
// "Show users" => "Show users",
// "If set to \"n\", do not show new users" => "If set to \"n\", do not show new users",
// "Show trackers" => "Show trackers",
// "If set to \"n\", do not show tracker changes" => "If set to \"n\", do not show tracker changes",
// "Calendar focus" => "Calendar focus",
// "Unless set to \"ignore\", the module changes the reference point in time from the user\\'s last login date and time to a day where users browse to using the calendar" => "Unless set to \"ignore\", the module changes the reference point in time from the user\\'s last login date and time to a day where users browse to using the calendar",
// "Since your last visit.." => "Since your last visit..",
// "new posts" => "new posts",
// "new tracker items" => "new tracker items",
// "updated tracker items" => "updated tracker items",
// "Switch Language" => "Switch Language",
// "Displays a language picker to change the language of the site" => "Displays a language picker to change the language of the site",
// "Display mode" => "Display mode",
// "Changes how the list of languages is displayed. Possible values are droplist, flags and words. Defaults to droplist" => "Changes how the list of languages is displayed. Possible values are droplist, flags and words. Defaults to droplist",
// "Prefix" => "Prefix",
// "Changes the default displayed prefix from \\\"Site Language:\\\"" => "Changes the default displayed prefix from \\\"Site Language:\\\"",
// "Switch theme" => "Switch theme",
// "Enables to quickly change the theme" => "Enables to quickly change the theme",
// "Terminology" => "Terminology",
// "Support for multilingual terminology" => "Support for multilingual terminology",
// "Tiki Tests" => "Tiki Tests",
// "Tiki test suite helper" => "Tiki test suite helper",
// "Displays the specified number of blogs with links to them, from the most active one to the least" => "Displays the specified number of blogs with links to them, from the most active one to the least",
// "Blog activity measurement can be more or less accurate" => "Blog activity measurement can be more or less accurate",
// "Lists the specified number of articles with links to them, from the most visited one to the least" => "Lists the specified number of articles with links to them, from the most visited one to the least",
// "Displays the specified number of file galleries with links to them, starting with the one with most hits" => "Displays the specified number of file galleries with links to them, starting with the one with most hits",
// "Displays the specified number of files with links to them, starting with the one with most hits" => "Displays the specified number of files with links to them, starting with the one with most hits",
// "Displays the specified number of users who posted to forums, starting with the one having most posts" => "Displays the specified number of users who posted to forums, starting with the one having most posts",
// "Top image galleries" => "Top image galleries",
// "Displays the specified number of image galleries with links to them, starting with the one with most hits" => "Displays the specified number of image galleries with links to them, starting with the one with most hits",
// "Displays the specified number of images with links to them, from the most visited one to the least" => "Displays the specified number of images with links to them, from the most visited one to the least",
// "Top Objects" => "Top Objects",
// "Displays the specified number of objects, starting with the one having the most hits" => "Displays the specified number of objects, starting with the one having the most hits",
// "Displays the specified number of wiki pages with links to them, starting with the one having the most hits" => "Displays the specified number of wiki pages with links to them, starting with the one having the most hits",
// "Displays the specified number of quizzes with links to them, starting with the one having the most hits" => "Displays the specified number of quizzes with links to them, starting with the one having the most hits",
// "Displays the specified number of blogs with links to them, from the most visited one to the least" => "Displays the specified number of blogs with links to them, from the most visited one to the least",
// "Displays the specified number of FAQs with links to them, from the most visited one to the least" => "Displays the specified number of FAQs with links to them, from the most visited one to the least",
// "Page translation" => "Page translation",
// "Links to versions of the wiki page being viewed in other languages, distinguishing between better, equivalent or worse translations. Optionally displays the up-to-dateness of the translation being viewed" => "Links to versions of the wiki page being viewed in other languages, distinguishing between better, equivalent or worse translations. Optionally displays the up-to-dateness of the translation being viewed",
// "Reference language" => "Reference language",
// "If set to a language code, restricts the localized pages shown to the reference page, unless that page is being displayed" => "If set to a language code, restricts the localized pages shown to the reference page, unless that page is being displayed",
// "Lists the specified number of calendar events, ordered by their start date" => "Lists the specified number of calendar events, ordered by their start date",
// "Calendars filter" => "Calendars filter",
// "If set to a list of calendar identifiers, restricts the events to those in the identified calendars. Identifiers are separated by vertical bars (\"|\"), commas (\",\") or colons (\":\")" => "If set to a list of calendar identifiers, restricts the events to those in the identified calendars. Identifiers are separated by vertical bars (\"|\"), commas (\",\") or colons (\":\")",
// "Maximum days in the future" => "Maximum days in the future",
// "Maximum distance to event start dates in days (looking forward)" => "Maximum distance to event start dates in days (looking forward)",
// "Maximum days in the past" => "Maximum days in the past",
// "Maximum distance to event end dates in days (looking backward)" => "Maximum distance to event end dates in days (looking backward)",
// "cellpadding" => "cellpadding",
// "cellspacing" => "cellspacing",
// "If set to \"y\", event descriptions are displayed" => "If set to \"y\", event descriptions are displayed",
// "Show end date and time" => "Show end date and time",
// "If set to \"y\", event end dates and times are displayed, when appropriate" => "If set to \"y\", event end dates and times are displayed, when appropriate",
// "Use custom calendar background colors" => "Use custom calendar background colors",
// "If set to \"y\", events are displayed with their calendar\\'s custom background color (if one is set)" => "If set to \"y\", events are displayed with their calendar\\'s custom background color (if one is set)",
// "Show information in tooltips" => "Show information in tooltips",
// "If set to \"n\", event tooltips will not display event information" => "If set to \"n\", event tooltips will not display event information",
// "Date format" => "Date format",
// "Format to use for most dates. See <a href=\"http://www.php.net/manual/en/function.strftime.php\">strftime() documentation</a>" => "Format to use for most dates. See <a href=\"http://www.php.net/manual/en/function.strftime.php\">strftime() documentation</a>",
// "site preference for short date format followed by site preference for short time format" => "site preference for short date format followed by site preference for short time format",
// "If set to an integer, event names are allowed that number of characters as a maximum before being truncated" => "If set to an integer, event names are allowed that number of characters as a maximum before being truncated",
// "Displays to registered users their blogs" => "Displays to registered users their blogs",
// "Lightweight interface to user bookmarks, enabling to view them concisely, do some manipulations and bookmark the page being viewed" => "Lightweight interface to user bookmarks, enabling to view them concisely, do some manipulations and bookmark the page being viewed",
// "User image galleries" => "User image galleries",
// "Displays to registered users their image galleries" => "Displays to registered users their image galleries",
// "Displays to registered users the specified number of wiki pages which they were the last to edit" => "Displays to registered users the specified number of wiki pages which they were the last to edit",
// "Lightweight interface to user tasks, enabling to view them concisely and do some manipulations" => "Lightweight interface to user tasks, enabling to view them concisely and do some manipulations",
// "Lists the public user tasks of a chosen group, with links to tasks" => "Lists the public user tasks of a chosen group, with links to tasks",
// "User-Group Tracker" => "User-Group Tracker",
// "User and Group tracker links" => "User and Group tracker links",
// "Displays the specified number of users and their score, starting from the one with the highest score" => "Displays the specified number of users and their score, starting from the one with the highest score",
// "Webmail Inbox" => "Webmail Inbox",
// "Displays Webmail Inbox" => "Displays Webmail Inbox",
// "Account Id" => "Account Id",
// "Webmail account identifier (if not set uses user\\'s current account)" => "Webmail account identifier (if not set uses user\\'s current account)",
// "GroupMail: Group (e.g. \"Help Team\")" => "GroupMail: Group (e.g. \"Help Team\")",
// "GroupMail: Tracker Id (to store GroupMail activity)" => "GroupMail: Tracker Id (to store GroupMail activity)",
// "GroupMail: From Field (Id of field in tracker to store email From header)" => "GroupMail: From Field (Id of field in tracker to store email From header)",
// "Subject Field Id" => "Subject Field Id",
// "GroupMail: Subject Field (Id of field in tracker to store email Subject header)" => "GroupMail: Subject Field (Id of field in tracker to store email Subject header)",
// "Message Field Id" => "Message Field Id",
// "GroupMail: Message Field (Id of field in tracker to store email message identifier)" => "GroupMail: Message Field (Id of field in tracker to store email message identifier)",
// "Content Field Id" => "Content Field Id",
// "GroupMail: Content Field (Id of field in tracker to store email message body content)" => "GroupMail: Content Field (Id of field in tracker to store email message body content)",
// "Account Field Id" => "Account Field Id",
// "GroupMail: Account Field (Id of field in tracker to store Webmail account name)" => "GroupMail: Account Field (Id of field in tracker to store Webmail account name)",
// "DateTime Field Id" => "DateTime Field Id",
// "GroupMail: Date Time Field (Id of field in tracker to store email sent timestamp)" => "GroupMail: Date Time Field (Id of field in tracker to store email sent timestamp)",
// "Operator Field Id" => "Operator Field Id",
// "GroupMail: Operator Field (Id of field in tracker to store operator name (username))" => "GroupMail: Operator Field (Id of field in tracker to store operator name (username))",
// "Maximum number of characters in subjects allowed before truncating" => "Maximum number of characters in subjects allowed before truncating",
// "Webmail error" => "Webmail error",
// "No accounts set up (or no current account set)" => "No accounts set up (or no current account set)",
// "Wiki Page" => "Wiki Page",
// "What is related" => "What is related",
// "Lists objects which share a category with the viewed object" => "Lists objects which share a category with the viewed object",
// "Displays information about users currently logged in" => "Displays information about users currently logged in",
// "Content to display" => "Content to display",
// "Display the number of users logged in, the list of users logged in, or both" => "Display the number of users logged in, the list of users logged in, or both",
// "Possible values: \"count\", \"list\" or \"both\". Default value: \"both\"" => "Possible values: \"count\", \"list\" or \"both\". Default value: \"both\"",
// "Cluster mode" => "Cluster mode",
// "If set to \"1\", separate users based on which host/server they logged on" => "If set to \"1\", separate users based on which host/server they logged on",
// "Last comments" => "Last comments",
// "Lists the specified number of comments starting from the most recently posted" => "Lists the specified number of comments starting from the most recently posted",
// "If set to \"y\", the name of the object on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip" => "If set to \"y\", the name of the object on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip",
// "Type of the objects from which comments will be listed. Possible values" => "Type of the objects from which comments will be listed. Possible values",
// "Last article comments" => "Last article comments",
// "YouTube" => "YouTube",
// "Displays YouTube videos and/or a link to a YouTube user\\'s page" => "Displays YouTube videos and/or a link to a YouTube user\\'s page",
// "Video identifiers" => "Video identifiers",
// "List of YouTube videos identifiers to display. Identifiers are separated by a comma (\",\")" => "List of YouTube videos identifiers to display. Identifiers are separated by a comma (\",\")",
// "YouTube user identifier" => "YouTube user identifier",
// "If set to a YouTube user identifier, display a link to the videos of this user" => "If set to a YouTube user identifier, display a link to the videos of this user",
// "Width of each video in pixels" => "Width of each video in pixels",
// "Height of each video in pixels" => "Height of each video in pixels",
// "Videos on YouTube" => "Videos on YouTube",
// "Invalid server key" => "Invalid server key",
// "Cookie not found" => "Cookie not found",
// "Can create/admin calendars" => "Can create/admin calendars",
// "Can add events in the calendar" => "Can add events in the calendar",
// "Can change events in the calendar" => "Can change events in the calendar",
// "Can browse the calendar" => "Can browse the calendar",
// "Can view events details" => "Can view events details",
// "Can view Tikiwiki tools calendar" => "Can view Tikiwiki tools calendar",
// "Administrator, can create channels remove channels etc" => "Administrator, can create channels remove channels etc",
// "Can use the chat system" => "Can use the chat system",
// "Can admin the cms" => "Can admin the cms",
// "Can approve submissions" => "Can approve submissions",
// "Can admin article topics" => "Can admin article topics",
// "Can admin article types" => "Can admin article types",
// "Can read article headings" => "Can read article headings",
// "Submited articles automatically approved" => "Submited articles automatically approved",
// "Can edit articles" => "Can edit articles",
// "Can edit submissions" => "Can edit submissions",
// "Can read articles" => "Can read articles",
// "Can remove articles" => "Can remove articles",
// "Can remove submissions" => "Can remove submissions",
// "Can submit articles" => "Can submit articles",
// "Can read a topic (Applies only to individual topic perms)" => "Can read a topic (Applies only to individual topic perms)",
// "Can admin contributions" => "Can admin contributions",
// "Can admin the directory" => "Can admin the directory",
// "Can admin directory categories" => "Can admin directory categories",
// "Can admin directory sites" => "Can admin directory sites",
// "Submited links are valid" => "Submited links are valid",
// "Can submit sites to the directory" => "Can submit sites to the directory",
// "Can validate submited links" => "Can validate submited links",
// "Can use the directory" => "Can use the directory",
// "Can admin faqs" => "Can admin faqs",
// "Can suggest faq questions" => "Can suggest faq questions",
// "Can view faqs" => "Can view faqs",
// "Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "Administrator, can manage users groups and permissions, Hotwords and all the weblog features",
// "Can admin users" => "Can admin users",
// "Can access site when closed" => "Can access site when closed",
// "Administrator, can admin banners" => "Administrator, can admin banners",
// "Can ban users or ips" => "Can ban users or ips",
// "Can admin the dynamic content system" => "Can admin the dynamic content system",
// "Can admin integrator repositories and rules" => "Can admin integrator repositories and rules",
// "Can admin mail-in accounts" => "Can admin mail-in accounts",
// "Can edit object permissions" => "Can edit object permissions",
// "Can admin external feeds" => "Can admin external feeds",
// "Can clean cache" => "Can clean cache",
// "Can create new css suffixed with -user" => "Can create new css suffixed with -user",
// "Can remove association between two pages in a translation set" => "Can remove association between two pages in a translation set",
// "Can admin cookies" => "Can admin cookies",
// "Can edit translations and create new languages" => "Can edit translations and create new languages",
// "Can edit menu" => "Can edit menu",
// "Can edit menu option" => "Can edit menu option",
// "Can edit site templates" => "Can edit site templates",
// "Can search" => "Can search",
// "Can report a link to the webmaster" => "Can report a link to the webmaster",
// "Can subscribe to groups" => "Can subscribe to groups",
// "Can send a link to a friend" => "Can send a link to a friend",
// "Can use HTML in pages" => "Can use HTML in pages",
// "Can view action log" => "Can view action log",
// "Can view action log for users of his own groups" => "Can view action log for users of his own groups",
// "Can view integrated repositories" => "Can view integrated repositories",
// "Can view referer stats" => "Can view referer stats",
// "Can view site stats" => "Can view site stats",
// "Can view site templates" => "Can view site templates",
// "Can admin blogs" => "Can admin blogs",
// "Can assign perms to blog" => "Can assign perms to blog",
// "Can post to a blog" => "Can post to a blog",
// "Can create a blog" => "Can create a blog",
// "Can read blogs" => "Can read blogs",
// "Can admin file galleries" => "Can admin file galleries",
// "Can assign perms to file gallery" => "Can assign perms to file gallery",
// "Can use Directory Batch Load" => "Can use Directory Batch Load",
// "Can upload zip files with files" => "Can upload zip files with files",
// "Can create file galleries" => "Can create file galleries",
// "Can download files" => "Can download files",
// "Can edit a gallery file" => "Can edit a gallery file",
// "Can list file galleries" => "Can list file galleries",
// "Can upload files" => "Can upload files",
// "Can view file galleries explorer" => "Can view file galleries explorer",
// "Can view file galleries path" => "Can view file galleries path",
// "Can view file galleries" => "Can view file galleries",
// "Can admin forums" => "Can admin forums",
// "Can attach to forum posts" => "Can attach to forum posts",
// "Auto approve forum posts" => "Auto approve forum posts",
// "Can edit own forum posts" => "Can edit own forum posts",
// "Can post in forums" => "Can post in forums",
// "Can start threads in forums" => "Can start threads in forums",
// "Can read forums" => "Can read forums",
// "Can report msgs to moderator" => "Can report msgs to moderator",
// "Can vote comments in forums" => "Can vote comments in forums",
// "Can admin freetags" => "Can admin freetags",
// "Can admin Image Galleries" => "Can admin Image Galleries",
// "Can assign perms to image gallery" => "Can assign perms to image gallery",
// "Can upload zip files with images" => "Can upload zip files with images",
// "Can create image galleries" => "Can create image galleries",
// "Can tag objects" => "Can tag objects",
// "Can list image galleries" => "Can list image galleries",
// "Can unassign tags from an object" => "Can unassign tags from an object",
// "Can upload images" => "Can upload images",
// "Can browse freetags" => "Can browse freetags",
// "Can view image galleries" => "Can view image galleries",
// "Can admin newsletters" => "Can admin newsletters",
// "Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Can subscribe many e-mails at once (requires tiki_p_subscribe email)",
// "Can send newsletters" => "Can send newsletters",
// "Can subscribe any email to newsletters" => "Can subscribe any email to newsletters",
// "Can subscribe to newsletters" => "Can subscribe to newsletters",
// "Can list newsletters" => "Can list newsletters",
// "Can admin polls" => "Can admin polls",
// "Can view poll results" => "Can view poll results",
// "Can vote polls" => "Can vote polls",
// "Can view poll voters" => "Can view poll voters",
// "Can admin toolbars" => "Can admin toolbars",
// "Can admin quizzes" => "Can admin quizzes",
// "Can take quizzes" => "Can take quizzes",
// "Can view quiz stats" => "Can view quiz stats",
// "Can view user quiz results" => "Can view user quiz results",
// "Can admin sheet" => "Can admin sheet",
// "Can create and edit sheets" => "Can create and edit sheets",
// "Can view sheet" => "Can view sheet",
// "Can view sheet history" => "Can view sheet history",
// "Can admin shoutbox (Edit/remove msgs)" => "Can admin shoutbox (Edit/remove msgs)",
// "Can post messages in shoutbox" => "Can post messages in shoutbox",
// "Can view shoutbox" => "Can view shoutbox",
// "Can admin surveys" => "Can admin surveys",
// "Can take surveys" => "Can take surveys",
// "Can view survey stats" => "Can view survey stats",
// "Can admin trackers" => "Can admin trackers",
// "Can attach files to tracker items" => "Can attach files to tracker items",
// "Can insert comments for tracker items" => "Can insert comments for tracker items",
// "Can view tracker items comments" => "Can view tracker items comments",
// "Can create new items for trackers" => "Can create new items for trackers",
// "Can list trackers" => "Can list trackers",
// "Can change tracker items" => "Can change tracker items",
// "Can change tracker pending items" => "Can change tracker pending items",
// "Can change tracker closed items" => "Can change tracker closed items",
// "Can view rating result for tracker items" => "Can view rating result for tracker items",
// "Can vote a rating for tracker items" => "Can vote a rating for tracker items",
// "Can view trackers" => "Can view trackers",
// "Can view trackers closed items" => "Can view trackers closed items",
// "Can view trackers pending items" => "Can view trackers pending items",
// "Can watch tracker" => "Can watch tracker",
// "Can export tracker items" => "Can export tracker items",
// "Can admin the wiki" => "Can admin the wiki",
// "Can assign perms to wiki pages" => "Can assign perms to wiki pages",
// "Can edit pages" => "Can edit pages",
// "Can edit copyright notices" => "Can edit copyright notices",
// "Can edit dynamic variables" => "Can edit dynamic variables",
// "Can create and edit structures" => "Can create and edit structures",
// "Can export wiki pages using the export feature" => "Can export wiki pages using the export feature",
// "Can lock pages" => "Can lock pages",
// "Can save as minor edit" => "Can save as minor edit",
// "Can remove" => "Can remove",
// "Can rename pages" => "Can rename pages",
// "Can rollback pages" => "Can rollback pages",
// "Can upload pictures to wiki pages" => "Can upload pictures to wiki pages",
// "Can use the page as a tracker template" => "Can use the page as a tracker template",
// "Can view page/pages" => "Can view page/pages",
// "Can watch structure" => "Can watch structure",
// "Can admin attachments to wiki pages" => "Can admin attachments to wiki pages",
// "Can add and change ratings on wiki pages" => "Can add and change ratings on wiki pages",
// "Can attach files to wiki pages" => "Can attach files to wiki pages",
// "Can view wiki attachments and download" => "Can view wiki attachments and download",
// "Can view wiki comments" => "Can view wiki comments",
// "Can view wiki history" => "Can view wiki history",
// "Can view rating of wiki pages" => "Can view rating of wiki pages",
// "Can view source of wiki pages" => "Can view source of wiki pages",
// "Can participate to rating of wiki pages" => "Can participate to rating of wiki pages",
// "Can view similar wiki pages" => "Can view similar wiki pages",
// "Can admin received articles" => "Can admin received articles",
// "Can admin received pages" => "Can admin received pages",
// "Can send articles to other sites" => "Can send articles to other sites",
// "Can send articles to this site" => "Can send articles to this site",
// "Can send pages to this site" => "Can send pages to this site",
// "Can send pages to other sites" => "Can send pages to other sites",
// "Can admin the TikiTests" => "Can admin the TikiTests",
// "Can edit TikiTests" => "Can edit TikiTests",
// "Can replay the TikiTests" => "Can replay the TikiTests",
// "Can cache user bookmarks" => "Can cache user bookmarks",
// "Can configure modules" => "Can configure modules",
// "Can create user bookmarks" => "Can create user bookmarks",
// "Can use the mini event calendar" => "Can use the mini event calendar",
// "Can use the notepad" => "Can use the notepad",
// "Can admin public tasks" => "Can admin public tasks",
// "Can use tasks" => "Can use tasks",
// "Can receive tasks from other users" => "Can receive tasks from other users",
// "Can send tasks to other users" => "Can send tasks to other users",
// "Can upload personal files" => "Can upload personal files",
// "Can create items in personal menu" => "Can create items in personal menu",
// "Can broadcast messages to all user" => "Can broadcast messages to all user",
// "Can broadcast messages to groups" => "Can broadcast messages to groups",
// "Can use the messaging system" => "Can use the messaging system",
// "Can admin comments" => "Can admin comments",
// "Can edit all comments" => "Can edit all comments",
// "Can post new comments" => "Can post new comments",
// "Can read comments" => "Can read comments",
// "Can delete comments" => "Can delete comments",
// "Can vote comments" => "Can vote comments",
// "Can admin content templates" => "Can admin content templates",
// "Can edit content templates" => "Can edit content templates",
// "Can use content templates" => "Can use content templates",
// "Can edit HTML pages" => "Can edit HTML pages",
// "Can view HTML pages" => "Can view HTML pages",
// "Can list registered users" => "Can list registered users",
// "Admin live support system" => "Admin live support system",
// "Can use live support system" => "Can use live support system",
// "Can create new mapfile" => "Can create new mapfile",
// "Can delete mapfiles" => "Can delete mapfiles",
// "Can edit mapfiles" => "Can edit mapfiles",
// "Can view mapfiles" => "Can view mapfiles",
// "Can view contents of mapfiles" => "Can view contents of mapfiles",
// "Can use webmail" => "Can use webmail",
// "Can use group webmail" => "Can use group webmail",
// "Can administrate group webmail accounts" => "Can administrate group webmail accounts",
// "Can use personal webmail accounts" => "Can use personal webmail accounts",
// "Can administrate personal webmail accounts" => "Can administrate personal webmail accounts",
// "Can view unapproved plugin details" => "Can view unapproved plugin details",
// "Can execute unapproved plugin" => "Can execute unapproved plugin",
// "Can approve plugin execution" => "Can approve plugin execution",
// "Trust all user inputs (no security checks)" => "Trust all user inputs (no security checks)",
// "View page backlinks" => "View page backlinks",
// "Can admin mail notifications" => "Can admin mail notifications",
// "Can invite user in groups" => "Can invite user in groups",
// "Can delete his own account" => "Can delete his own account",
// "Can use the Tiki Importer" => "Can use the Tiki Importer",
// "Can admin categories" => "Can admin categories",
// "Can see the category in a listing" => "Can see the category in a listing",
// "Can change the categories on the object" => "Can change the categories on the object",
// "Can add objects in the category" => "Can add objects in the category",
// "Can remove objects from the category" => "Can remove objects from the category",
// "Can create new categories" => "Can create new categories",
// "Can view the perspective" => "Can view the perspective",
// "Can view the group" => "Can view the group",
// "Can view the group members" => "Can view the group members",
// "Can add group members" => "Can add group members",
// "Can remove group members" => "Can remove group members",
// "Can join or leave the group" => "Can join or leave the group",
// "Can trigger the transition between two states" => "Can trigger the transition between two states",
// "Can admin kaltura feature" => "Can admin kaltura feature",
// "Can upload video on kaltura server" => "Can upload video on kaltura server",
// "Can edit information of kaltura entry" => "Can edit information of kaltura entry",
// "Can create kaltura remix video" => "Can create kaltura remix video",
// "Can delete kaltura entry" => "Can delete kaltura entry",
// "Can download kaltura entry" => "Can download kaltura entry",
// "Can list kaltura entries" => "Can list kaltura entries",
// "Can view kaltura entry" => "Can view kaltura entry",
// "Can upload screencasts to wiki pages" => "Can upload screencasts to wiki pages",
// "tiki release" => "tiki release",
// "feature version checks" => "feature version checks",
// "tiki needs upgrade" => "tiki needs upgrade",
// "tiki version last check" => "tiki version last check",
// "tiki version check frequency" => "tiki version check frequency",
// "lastUpdatePrefs" => "lastUpdatePrefs",
// "feature print indexed" => "feature print indexed",
// "groups are emulated" => "groups are emulated",
// "feature wiki" => "feature wiki",
// "default wiki diff style" => "default wiki diff style",
// "feature backlinks" => "feature backlinks",
// "feature dump" => "feature dump",
// "feature history" => "feature history",
// "feature lastChanges" => "feature lastChanges",
// "feature likePages" => "feature likePages",
// "feature listPages" => "feature listPages",
// "feature listorphanPages" => "feature listorphanPages",
// "feature listorphanStructure" => "feature listorphanStructure",
// "feature page title" => "feature page title",
// "feature sandbox" => "feature sandbox",
// "feature warn on edit" => "feature warn on edit",
// "feature wiki 1like redirection" => "feature wiki 1like redirection",
// "feature wiki allowhtml" => "feature wiki allowhtml",
// "feature wiki argvariable" => "feature wiki argvariable",
// "feature wiki attachments" => "feature wiki attachments",
// "feature wiki comments" => "feature wiki comments",
// "feature wiki description" => "feature wiki description",
// "feature wiki discuss" => "feature wiki discuss",
// "feature wiki export" => "feature wiki export",
// "feature wiki structure" => "feature wiki structure",
// "feature wiki import page" => "feature wiki import page",
// "feature wiki footnotes" => "feature wiki footnotes",
// "feature wiki icache" => "feature wiki icache",
// "feature wiki import html" => "feature wiki import html",
// "feature wiki mindmap" => "feature wiki mindmap",
// "feature wiki monosp" => "feature wiki monosp",
// "feature wiki multiprint" => "feature wiki multiprint",
// "feature wiki notepad" => "feature wiki notepad",
// "feature wiki make structure" => "feature wiki make structure",
// "feature wiki open as structure" => "feature wiki open as structure",
// "feature wiki pageid" => "feature wiki pageid",
// "feature wiki paragraph formatting" => "feature wiki paragraph formatting",
// "feature wiki paragraph formatting add br" => "feature wiki paragraph formatting add br",
// "feature wiki pictures" => "feature wiki pictures",
// "feature wiki plurals" => "feature wiki plurals",
// "feature wiki print" => "feature wiki print",
// "feature wiki protect email" => "feature wiki protect email",
// "feature wiki rankings" => "feature wiki rankings",
// "feature wiki ratings" => "feature wiki ratings",
// "feature wiki replace" => "feature wiki replace",
// "feature wiki show hide before" => "feature wiki show hide before",
// "feature wiki tables" => "feature wiki tables",
// "feature wiki templates" => "feature wiki templates",
// "feature wiki undo" => "feature wiki undo",
// "feature wiki userpage" => "feature wiki userpage",
// "feature wiki userpage prefix" => "feature wiki userpage prefix",
// "feature wiki usrlock" => "feature wiki usrlock",
// "feature wiki feedback polls" => "feature wiki feedback polls",
// "feature wiki save draft" => "feature wiki save draft",
// "feature wikiwords" => "feature wikiwords",
// "feature wikiwords usedash" => "feature wikiwords usedash",
// "feature wiki pagealias" => "feature wiki pagealias",
// "mailin autocheck" => "mailin autocheck",
// "mailin autocheckFreq" => "mailin autocheckFreq",
// "mailin autocheckLast" => "mailin autocheckLast",
// "page bar position" => "page bar position",
// "warn on edit time" => "warn on edit time",
// "wikiHomePage" => "wikiHomePage",
// "wikiLicensePage" => "wikiLicensePage",
// "wikiSubmitNotice" => "wikiSubmitNotice",
// "wiki authors style" => "wiki authors style",
// "wiki authors style by page" => "wiki authors style by page",
// "wiki dft list pages lang to current" => "wiki dft list pages lang to current",
// "wiki show version" => "wiki show version",
// "wiki bot bar" => "wiki bot bar",
// "wiki cache" => "wiki cache",
// "wiki comments default ordering" => "wiki comments default ordering",
// "wiki comments displayed default" => "wiki comments displayed default",
// "wiki comments per page" => "wiki comments per page",
// "wiki comments allow per page" => "wiki comments allow per page",
// "wiki creator admin" => "wiki creator admin",
// "wiki feature copyrights" => "wiki feature copyrights",
// "wiki forum id" => "wiki forum id",
// "wiki left column" => "wiki left column",
// "wiki list backlinks" => "wiki list backlinks",
// "wiki list comment" => "wiki list comment",
// "wiki list comment len" => "wiki list comment len",
// "wiki list description" => "wiki list description",
// "wiki list description len" => "wiki list description len",
// "wiki list creator" => "wiki list creator",
// "wiki list hits" => "wiki list hits",
// "wiki list lastmodif" => "wiki list lastmodif",
// "wiki list lastver" => "wiki list lastver",
// "wiki list links" => "wiki list links",
// "wiki list name" => "wiki list name",
// "wiki list name len" => "wiki list name len",
// "wiki list size" => "wiki list size",
// "wiki list status" => "wiki list status",
// "wiki list user" => "wiki list user",
// "wiki list versions" => "wiki list versions",
// "wiki list language" => "wiki list language",
// "wiki list categories" => "wiki list categories",
// "wiki list categories path" => "wiki list categories path",
// "wiki list id" => "wiki list id",
// "wiki list sortorder" => "wiki list sortorder",
// "wiki list sortdirection" => "wiki list sortdirection",
// "wiki pagealias tokens" => "wiki pagealias tokens",
// "wiki page regex" => "wiki page regex",
// "wiki page separator" => "wiki page separator",
// "wiki page navigation bar" => "wiki page navigation bar",
// "wiki actions bar" => "wiki actions bar",
// "wiki pagename strip" => "wiki pagename strip",
// "wiki right column" => "wiki right column",
// "wiki top bar" => "wiki top bar",
// "wiki topline position" => "wiki topline position",
// "wiki uses slides" => "wiki uses slides",
// "wiki watch author" => "wiki watch author",
// "wiki watch comments" => "wiki watch comments",
// "wiki watch editor" => "wiki watch editor",
// "wiki watch minor" => "wiki watch minor",
// "feature wiki history full" => "feature wiki history full",
// "feature wiki categorize structure" => "feature wiki categorize structure",
// "feature wiki watch structure" => "feature wiki watch structure",
// "feature wikiapproval" => "feature wikiapproval",
// "wikiapproval prefix" => "wikiapproval prefix",
// "wikiapproval hideprefix" => "wikiapproval hideprefix",
// "wikiapproval delete staging" => "wikiapproval delete staging",
// "wikiapproval master group" => "wikiapproval master group",
// "wikiapproval staging category" => "wikiapproval staging category",
// "wikiapproval approved category" => "wikiapproval approved category",
// "wikiapproval outofsync category" => "wikiapproval outofsync category",
// "wikiapproval block editapproved" => "wikiapproval block editapproved",
// "wikiapproval sync categories" => "wikiapproval sync categories",
// "wikiapproval update freetags" => "wikiapproval update freetags",
// "wikiapproval combine freetags" => "wikiapproval combine freetags",
// "wiki edit section" => "wiki edit section",
// "wiki edit section level" => "wiki edit section level",
// "wiki edit icons toggle" => "wiki edit icons toggle",
// "wiki edit plugin" => "wiki edit plugin",
// "wiki validate plugin" => "wiki validate plugin",
// "wiki edit minor" => "wiki edit minor",
// "feature pagelist" => "feature pagelist",
// "wikiplugin agentinfo" => "wikiplugin agentinfo",
// "wikiplugin alink" => "wikiplugin alink",
// "wikiplugin aname" => "wikiplugin aname",
// "wikiplugin annotation" => "wikiplugin annotation",
// "wikiplugin article" => "wikiplugin article",
// "wikiplugin articles" => "wikiplugin articles",
// "wikiplugin attach" => "wikiplugin attach",
// "wikiplugin avatar" => "wikiplugin avatar",
// "wikiplugin back" => "wikiplugin back",
// "wikiplugin backlinks" => "wikiplugin backlinks",
// "wikiplugin banner" => "wikiplugin banner",
// "wikiplugin bloglist" => "wikiplugin bloglist",
// "wikiplugin box" => "wikiplugin box",
// "wikiplugin calendar" => "wikiplugin calendar",
// "wikiplugin category" => "wikiplugin category",
// "wikiplugin catorphans" => "wikiplugin catorphans",
// "wikiplugin catpath" => "wikiplugin catpath",
// "wikiplugin center" => "wikiplugin center",
// "wikiplugin chart" => "wikiplugin chart",
// "wikiplugin code" => "wikiplugin code",
// "wikiplugin content" => "wikiplugin content",
// "wikiplugin cookie" => "wikiplugin cookie",
// "wikiplugin copyright" => "wikiplugin copyright",
// "wikiplugin countdown" => "wikiplugin countdown",
// "wikiplugin datachannel" => "wikiplugin datachannel",
// "wikiplugin dbreport" => "wikiplugin dbreport",
// "wikiplugin div" => "wikiplugin div",
// "wikiplugin dl" => "wikiplugin dl",
// "wikiplugin draw" => "wikiplugin draw",
// "wikiplugin equation" => "wikiplugin equation",
// "wikiplugin events" => "wikiplugin events",
// "wikiplugin fade" => "wikiplugin fade",
// "wikiplugin fancylist" => "wikiplugin fancylist",
// "wikiplugin fancytable" => "wikiplugin fancytable",
// "wikiplugin file" => "wikiplugin file",
// "wikiplugin files" => "wikiplugin files",
// "wikiplugin flash" => "wikiplugin flash",
// "wikiplugin footnote" => "wikiplugin footnote",
// "wikiplugin footnotearea" => "wikiplugin footnotearea",
// "wikiplugin ftp" => "wikiplugin ftp",
// "wikiplugin gauge" => "wikiplugin gauge",
// "wikiplugin googleanalytics" => "wikiplugin googleanalytics",
// "wikiplugin googledoc" => "wikiplugin googledoc",
// "wikiplugin group" => "wikiplugin group",
// "wikiplugin groupmailcore" => "wikiplugin groupmailcore",
// "wikiplugin groupstat" => "wikiplugin groupstat",
// "wikiplugin html" => "wikiplugin html",
// "wikiplugin iframe" => "wikiplugin iframe",
// "wikiplugin img" => "wikiplugin img",
// "wikiplugin image" => "wikiplugin image",
// "wikiplugin include" => "wikiplugin include",
// "wikiplugin invite" => "wikiplugin invite",
// "wikiplugin jabber" => "wikiplugin jabber",
// "wikiplugin js" => "wikiplugin js",
// "wikiplugin jq" => "wikiplugin jq",
// "wikiplugin lang" => "wikiplugin lang",
// "wikiplugin lastmod" => "wikiplugin lastmod",
// "wikiplugin listpages" => "wikiplugin listpages",
// "wikiplugin listprogress" => "wikiplugin listprogress",
// "wikiplugin lsdir" => "wikiplugin lsdir",
// "wikiplugin map" => "wikiplugin map",
// "wikiplugin mcalendar" => "wikiplugin mcalendar",
// "wikiplugin mediaplayer" => "wikiplugin mediaplayer",
// "wikiplugin memberlist" => "wikiplugin memberlist",
// "wikiplugin miniquiz" => "wikiplugin miniquiz",
// "wikiplugin module" => "wikiplugin module",
// "wikiplugin mono" => "wikiplugin mono",
// "wikiplugin mouseover" => "wikiplugin mouseover",
// "wikiplugin mwtable" => "wikiplugin mwtable",
// "wikiplugin myspace" => "wikiplugin myspace",
// "wikiplugin objecthits" => "wikiplugin objecthits",
// "wikiplugin pagelist" => "wikiplugin pagelist",
// "wikiplugin picture" => "wikiplugin picture",
// "wikiplugin pluginmanager" => "wikiplugin pluginmanager",
// "wikiplugin poll" => "wikiplugin poll",
// "wikiplugin profile" => "wikiplugin profile",
// "wikiplugin proposal" => "wikiplugin proposal",
// "wikiplugin quote" => "wikiplugin quote",
// "wikiplugin rcontent" => "wikiplugin rcontent",
// "wikiplugin realnamelist" => "wikiplugin realnamelist",
// "wikiplugin redirect" => "wikiplugin redirect",
// "wikiplugin regex" => "wikiplugin regex",
// "wikiplugin remarksbox" => "wikiplugin remarksbox",
// "wikiplugin rss" => "wikiplugin rss",
// "wikiplugin screencast" => "wikiplugin screencast",
// "wikiplugin sf" => "wikiplugin sf",
// "wikiplugin share" => "wikiplugin share",
// "wikiplugin sharethis" => "wikiplugin sharethis",
// "wikiplugin sheet" => "wikiplugin sheet",
// "wikiplugin showpages" => "wikiplugin showpages",
// "wikiplugin skype" => "wikiplugin skype",
// "wikiplugin snarf" => "wikiplugin snarf",
// "wikiplugin sort" => "wikiplugin sort",
// "wikiplugin split" => "wikiplugin split",
// "wikiplugin sql" => "wikiplugin sql",
// "wikiplugin stat" => "wikiplugin stat",
// "wikiplugin sub" => "wikiplugin sub",
// "wikiplugin subscribegroup" => "wikiplugin subscribegroup",
// "wikiplugin subscribegroups" => "wikiplugin subscribegroups",
// "wikiplugin sup" => "wikiplugin sup",
// "wikiplugin survey" => "wikiplugin survey",
// "wikiplugin tag" => "wikiplugin tag",
// "wikiplugin tabs" => "wikiplugin tabs",
// "wikiplugin thumb" => "wikiplugin thumb",
// "wikiplugin titlesearch" => "wikiplugin titlesearch",
// "wikiplugin toc" => "wikiplugin toc",
// "wikiplugin topfriends" => "wikiplugin topfriends",
// "wikiplugin trackerfilter" => "wikiplugin trackerfilter",
// "wikiplugin trackeritemfield" => "wikiplugin trackeritemfield",
// "wikiplugin trackerlist" => "wikiplugin trackerlist",
// "wikiplugin trackertimeline" => "wikiplugin trackertimeline",
// "wikiplugin tracker" => "wikiplugin tracker",
// "wikiplugin trackerprefill" => "wikiplugin trackerprefill",
// "wikiplugin trackerstat" => "wikiplugin trackerstat",
// "wikiplugin translated" => "wikiplugin translated",
// "wikiplugin tr" => "wikiplugin tr",
// "wikiplugin usercount" => "wikiplugin usercount",
// "wikiplugin userlist" => "wikiplugin userlist",
// "wikiplugin userpref" => "wikiplugin userpref",
// "wikiplugin versions" => "wikiplugin versions",
// "wikiplugin vote" => "wikiplugin vote",
// "wikiplugin wantedpages" => "wikiplugin wantedpages",
// "wikiplugin webservice" => "wikiplugin webservice",
// "wikiplugin youtube" => "wikiplugin youtube",
// "wikiplugininline agentinfo" => "wikiplugininline agentinfo",
// "wikiplugininline alink" => "wikiplugininline alink",
// "wikiplugininline aname" => "wikiplugininline aname",
// "wikiplugininline annotation" => "wikiplugininline annotation",
// "wikiplugininline article" => "wikiplugininline article",
// "wikiplugininline articles" => "wikiplugininline articles",
// "wikiplugininline attach" => "wikiplugininline attach",
// "wikiplugininline avatar" => "wikiplugininline avatar",
// "wikiplugininline back" => "wikiplugininline back",
// "wikiplugininline backlinks" => "wikiplugininline backlinks",
// "wikiplugininline banner" => "wikiplugininline banner",
// "wikiplugininline bloglist" => "wikiplugininline bloglist",
// "wikiplugininline box" => "wikiplugininline box",
// "wikiplugininline calendar" => "wikiplugininline calendar",
// "wikiplugininline category" => "wikiplugininline category",
// "wikiplugininline catorphans" => "wikiplugininline catorphans",
// "wikiplugininline catpath" => "wikiplugininline catpath",
// "wikiplugininline center" => "wikiplugininline center",
// "wikiplugininline chart" => "wikiplugininline chart",
// "wikiplugininline code" => "wikiplugininline code",
// "wikiplugininline content" => "wikiplugininline content",
// "wikiplugininline cookie" => "wikiplugininline cookie",
// "wikiplugininline copyright" => "wikiplugininline copyright",
// "wikiplugininline countdown" => "wikiplugininline countdown",
// "wikiplugininline datachannel" => "wikiplugininline datachannel",
// "wikiplugininline dbreport" => "wikiplugininline dbreport",
// "wikiplugininline div" => "wikiplugininline div",
// "wikiplugininline dl" => "wikiplugininline dl",
// "wikiplugininline draw" => "wikiplugininline draw",
// "wikiplugininline equation" => "wikiplugininline equation",
// "wikiplugininline events" => "wikiplugininline events",
// "wikiplugininline fade" => "wikiplugininline fade",
// "wikiplugininline fancylist" => "wikiplugininline fancylist",
// "wikiplugininline fancytable" => "wikiplugininline fancytable",
// "wikiplugininline file" => "wikiplugininline file",
// "wikiplugininline files" => "wikiplugininline files",
// "wikiplugininline flash" => "wikiplugininline flash",
// "wikiplugininline footnote" => "wikiplugininline footnote",
// "wikiplugininline footnotearea" => "wikiplugininline footnotearea",
// "wikiplugininline ftp" => "wikiplugininline ftp",
// "wikiplugininline gauge" => "wikiplugininline gauge",
// "wikiplugininline googleanalytics" => "wikiplugininline googleanalytics",
// "wikiplugininline googledoc" => "wikiplugininline googledoc",
// "wikiplugininline group" => "wikiplugininline group",
// "wikiplugininline groupmailcore" => "wikiplugininline groupmailcore",
// "wikiplugininline groupstat" => "wikiplugininline groupstat",
// "wikiplugininline html" => "wikiplugininline html",
// "wikiplugininline iframe" => "wikiplugininline iframe",
// "wikiplugininline img" => "wikiplugininline img",
// "wikiplugininline image" => "wikiplugininline image",
// "wikiplugininline include" => "wikiplugininline include",
// "wikiplugininline invite" => "wikiplugininline invite",
// "wikiplugininline jabber" => "wikiplugininline jabber",
// "wikiplugininline js" => "wikiplugininline js",
// "wikiplugininline jq" => "wikiplugininline jq",
// "wikiplugininline lang" => "wikiplugininline lang",
// "wikiplugininline lastmod" => "wikiplugininline lastmod",
// "wikiplugininline listpages" => "wikiplugininline listpages",
// "wikiplugininline listprogress" => "wikiplugininline listprogress",
// "wikiplugininline lsdir" => "wikiplugininline lsdir",
// "wikiplugininline map" => "wikiplugininline map",
// "wikiplugininline mcalendar" => "wikiplugininline mcalendar",
// "wikiplugininline mediaplayer" => "wikiplugininline mediaplayer",
// "wikiplugininline memberlist" => "wikiplugininline memberlist",
// "wikiplugininline miniquiz" => "wikiplugininline miniquiz",
// "wikiplugininline module" => "wikiplugininline module",
// "wikiplugininline mono" => "wikiplugininline mono",
// "wikiplugininline mouseover" => "wikiplugininline mouseover",
// "wikiplugininline mwtable" => "wikiplugininline mwtable",
// "wikiplugininline myspace" => "wikiplugininline myspace",
// "wikiplugininline objecthits" => "wikiplugininline objecthits",
// "wikiplugininline pagelist" => "wikiplugininline pagelist",
// "wikiplugininline picture" => "wikiplugininline picture",
// "wikiplugininline pluginmanager" => "wikiplugininline pluginmanager",
// "wikiplugininline poll" => "wikiplugininline poll",
// "wikiplugininline profile" => "wikiplugininline profile",
// "wikiplugininline proposal" => "wikiplugininline proposal",
// "wikiplugininline quote" => "wikiplugininline quote",
// "wikiplugininline rcontent" => "wikiplugininline rcontent",
// "wikiplugininline realnamelist" => "wikiplugininline realnamelist",
// "wikiplugininline redirect" => "wikiplugininline redirect",
// "wikiplugininline regex" => "wikiplugininline regex",
// "wikiplugininline remarksbox" => "wikiplugininline remarksbox",
// "wikiplugininline rss" => "wikiplugininline rss",
// "wikiplugininline screencast" => "wikiplugininline screencast",
// "wikiplugininline sf" => "wikiplugininline sf",
// "wikiplugininline share" => "wikiplugininline share",
// "wikiplugininline sharethis" => "wikiplugininline sharethis",
// "wikiplugininline sheet" => "wikiplugininline sheet",
// "wikiplugininline showpages" => "wikiplugininline showpages",
// "wikiplugininline skype" => "wikiplugininline skype",
// "wikiplugininline snarf" => "wikiplugininline snarf",
// "wikiplugininline sort" => "wikiplugininline sort",
// "wikiplugininline split" => "wikiplugininline split",
// "wikiplugininline sql" => "wikiplugininline sql",
// "wikiplugininline stat" => "wikiplugininline stat",
// "wikiplugininline sub" => "wikiplugininline sub",
// "wikiplugininline subscribegroup" => "wikiplugininline subscribegroup",
// "wikiplugininline subscribegroups" => "wikiplugininline subscribegroups",
// "wikiplugininline sup" => "wikiplugininline sup",
// "wikiplugininline survey" => "wikiplugininline survey",
// "wikiplugininline tag" => "wikiplugininline tag",
// "wikiplugininline tabs" => "wikiplugininline tabs",
// "wikiplugininline thumb" => "wikiplugininline thumb",
// "wikiplugininline titlesearch" => "wikiplugininline titlesearch",
// "wikiplugininline toc" => "wikiplugininline toc",
// "wikiplugininline topfriends" => "wikiplugininline topfriends",
// "wikiplugininline trackerfilter" => "wikiplugininline trackerfilter",
// "wikiplugininline trackeritemfield" => "wikiplugininline trackeritemfield",
// "wikiplugininline trackerlist" => "wikiplugininline trackerlist",
// "wikiplugininline trackertimeline" => "wikiplugininline trackertimeline",
// "wikiplugininline tracker" => "wikiplugininline tracker",
// "wikiplugininline trackerprefill" => "wikiplugininline trackerprefill",
// "wikiplugininline trackerstat" => "wikiplugininline trackerstat",
// "wikiplugininline translated" => "wikiplugininline translated",
// "wikiplugininline tr" => "wikiplugininline tr",
// "wikiplugininline usercount" => "wikiplugininline usercount",
// "wikiplugininline userlist" => "wikiplugininline userlist",
// "wikiplugininline userpref" => "wikiplugininline userpref",
// "wikiplugininline versions" => "wikiplugininline versions",
// "wikiplugininline vote" => "wikiplugininline vote",
// "wikiplugininline wantedpages" => "wikiplugininline wantedpages",
// "wikiplugininline webservice" => "wikiplugininline webservice",
// "wikiplugininline youtube" => "wikiplugininline youtube",
// "webservice consume defaultcache" => "webservice consume defaultcache",
// "feature webservices" => "feature webservices",
// "feature semantic" => "feature semantic",
// "feature wysiwyg" => "feature wysiwyg",
// "wysiwyg optional" => "wysiwyg optional",
// "wysiwyg default" => "wysiwyg default",
// "wysiwyg memo" => "wysiwyg memo",
// "wysiwyg wiki parsed" => "wysiwyg wiki parsed",
// "wysiwyg wiki semi parsed" => "wysiwyg wiki semi parsed",
// "wysiwyg toolbar skin" => "wysiwyg toolbar skin",
// "wiki feature 3d" => "wiki feature 3d",
// "wiki 3d width" => "wiki 3d width",
// "wiki 3d height" => "wiki 3d height",
// "wiki 3d navigation depth" => "wiki 3d navigation depth",
// "wiki 3d feed animation interval" => "wiki 3d feed animation interval",
// "wiki 3d existing page color" => "wiki 3d existing page color",
// "wiki 3d missing page color" => "wiki 3d missing page color",
// "feature blogs" => "feature blogs",
// "blog list order" => "blog list order",
// "home blog" => "home blog",
// "feature blog rankings" => "feature blog rankings",
// "feature blog comments" => "feature blog comments",
// "blog comments default ordering" => "blog comments default ordering",
// "blog comments per page" => "blog comments per page",
// "feature blogposts comments" => "feature blogposts comments",
// "blog list user" => "blog list user",
// "blog list title" => "blog list title",
// "blog list title len" => "blog list title len",
// "blog list description" => "blog list description",
// "blog list created" => "blog list created",
// "blog list lastmodif" => "blog list lastmodif",
// "blog list posts" => "blog list posts",
// "blog list visits" => "blog list visits",
// "blog list activity" => "blog list activity",
// "feature blog mandatory category" => "feature blog mandatory category",
// "feature blog heading" => "feature blog heading",
// "feature file galleries" => "feature file galleries",
// "home file gallery" => "home file gallery",
// "fgal root id" => "fgal root id",
// "fgal use db" => "fgal use db",
// "fgal batch dir" => "fgal batch dir",
// "fgal match regex" => "fgal match regex",
// "fgal nmatch regex" => "fgal nmatch regex",
// "fgal use dir" => "fgal use dir",
// "fgal podcast dir" => "fgal podcast dir",
// "feature file galleries comments" => "feature file galleries comments",
// "file galleries comments default ordering" => "file galleries comments default ordering",
// "file galleries comments per page" => "file galleries comments per page",
// "feature file galleries batch" => "feature file galleries batch",
// "feature file galleries rankings" => "feature file galleries rankings",
// "fgal enable auto indexing" => "fgal enable auto indexing",
// "fgal asynchronous indexing" => "fgal asynchronous indexing",
// "fgal allow duplicates" => "fgal allow duplicates",
// "fgal sort mode" => "fgal sort mode",
// "feature file galleries author" => "feature file galleries author",
// "fgal list id" => "fgal list id",
// "fgal list type" => "fgal list type",
// "fgal list name" => "fgal list name",
// "fgal list description" => "fgal list description",
// "fgal list size" => "fgal list size",
// "fgal list created" => "fgal list created",
// "fgal list lastModif" => "fgal list lastModif",
// "fgal list creator" => "fgal list creator",
// "fgal list author" => "fgal list author",
// "fgal list last user" => "fgal list last user",
// "fgal list comment" => "fgal list comment",
// "fgal list files" => "fgal list files",
// "fgal list hits" => "fgal list hits",
// "fgal list lockedby" => "fgal list lockedby",
// "fgal show path" => "fgal show path",
// "fgal show explorer" => "fgal show explorer",
// "fgal show slideshow" => "fgal show slideshow",
// "fgal default view" => "fgal default view",
// "fgal limit hits per file" => "fgal limit hits per file",
// "fgal prevent negative score" => "fgal prevent negative score",
// "fgal quota" => "fgal quota",
// "fgal quota per fgal" => "fgal quota per fgal",
// "fgal quota default" => "fgal quota default",
// "fgal quota show" => "fgal quota show",
// "feature galleries" => "feature galleries",
// "feature gal batch" => "feature gal batch",
// "feature gal slideshow" => "feature gal slideshow",
// "home gallery" => "home gallery",
// "gal use db" => "gal use db",
// "gal use lib" => "gal use lib",
// "gal match regex" => "gal match regex",
// "gal nmatch regex" => "gal nmatch regex",
// "gal use dir" => "gal use dir",
// "gal batch dir" => "gal batch dir",
// "feature gal rankings" => "feature gal rankings",
// "feature image galleries comments" => "feature image galleries comments",
// "image galleries comments default order" => "image galleries comments default order",
// "image galleries comments per page" => "image galleries comments per page",
// "gal list name" => "gal list name",
// "gal list parent" => "gal list parent",
// "gal list description" => "gal list description",
// "gal list created" => "gal list created",
// "gal list lastmodif" => "gal list lastmodif",
// "gal list user" => "gal list user",
// "gal list imgs" => "gal list imgs",
// "gal list visits" => "gal list visits",
// "feature image gallery mandatory category" => "feature image gallery mandatory category",
// "preset galleries info" => "preset galleries info",
// "gal image mouseover" => "gal image mouseover",
// "ProgressBarPlay" => "ProgressBarPlay",
// "ProgressBarLoad" => "ProgressBarLoad",
// "ProgressBarButton" => "ProgressBarButton",
// "ProgressBar" => "ProgressBar",
// "VolumeOn" => "VolumeOn",
// "VolumeOff" => "VolumeOff",
// "VolumeButton" => "VolumeButton",
// "Button" => "Button",
// "ButtonPressed" => "ButtonPressed",
// "ButtonOver" => "ButtonOver",
// "ButtonInfo" => "ButtonInfo",
// "ButtonInfoPressed" => "ButtonInfoPressed",
// "ButtonInfoOver" => "ButtonInfoOver",
// "ButtonInfoText" => "ButtonInfoText",
// "ID3" => "ID3",
// "PlayTime" => "PlayTime",
// "TotalTime" => "TotalTime",
// "PanelDisplay" => "PanelDisplay",
// "AlertMesg" => "AlertMesg",
// "PreloadDelay" => "PreloadDelay",
// "VideoHeight" => "VideoHeight",
// "VideoLength" => "VideoLength",
// "URLAppend" => "URLAppend",
// "LimitedMsg" => "LimitedMsg",
// "MaxPlay" => "MaxPlay",
// "MultimediaGalerie" => "MultimediaGalerie",
// "MultimediaDefaultLength" => "MultimediaDefaultLength",
// "MultimediaDefaultHeight" => "MultimediaDefaultHeight",
// "feature forums" => "feature forums",
// "home forum" => "home forum",
// "feature forum rankings" => "feature forum rankings",
// "feature forum parse" => "feature forum parse",
// "feature forum topics archiving" => "feature forum topics archiving",
// "feature forum replyempty" => "feature forum replyempty",
// "feature forum quickjump" => "feature forum quickjump",
// "feature forums allow thread titles" => "feature forums allow thread titles",
// "feature forum content search" => "feature forum content search",
// "feature forums name search" => "feature forums name search",
// "forums ordering" => "forums ordering",
// "forum list topics" => "forum list topics",
// "forum list posts" => "forum list posts",
// "forum list ppd" => "forum list ppd",
// "forum list lastpost" => "forum list lastpost",
// "forum list visits" => "forum list visits",
// "forum list desc" => "forum list desc",
// "forum list description len" => "forum list description len",
// "feature forum local search" => "feature forum local search",
// "feature forum local tiki search" => "feature forum local tiki search",
// "forum thread defaults by forum" => "forum thread defaults by forum",
// "forum thread user settings" => "forum thread user settings",
// "forum thread user settings threshold" => "forum thread user settings threshold",
// "forum thread user settings keep" => "forum thread user settings keep",
// "forum comments per page" => "forum comments per page",
// "forum comments no title prefix" => "forum comments no title prefix",
// "forum thread style" => "forum thread style",
// "forum thread sort mode" => "forum thread sort mode",
// "forum match regex" => "forum match regex",
// "feature articles" => "feature articles",
// "feature submissions" => "feature submissions",
// "feature cms rankings" => "feature cms rankings",
// "feature cms print" => "feature cms print",
// "feature cms emails" => "feature cms emails",
// "art list title" => "art list title",
// "art list title len" => "art list title len",
// "art list topic" => "art list topic",
// "art list date" => "art list date",
// "art list author" => "art list author",
// "art list rating" => "art list rating",
// "art list reads" => "art list reads",
// "art list size" => "art list size",
// "art list expire" => "art list expire",
// "art list img" => "art list img",
// "art list type" => "art list type",
// "art list visible" => "art list visible",
// "art view type" => "art view type",
// "art view title" => "art view title",
// "art view topic" => "art view topic",
// "art view date" => "art view date",
// "art view author" => "art view author",
// "art view reads" => "art view reads",
// "art view size" => "art view size",
// "art view img" => "art view img",
// "art list lang" => "art list lang",
// "feature article comments" => "feature article comments",
// "article comments default ordering" => "article comments default ordering",
// "article comments per page" => "article comments per page",
// "article image size x" => "article image size x",
// "article image size y" => "article image size y",
// "feature cms templates" => "feature cms templates",
// "cms bot bar" => "cms bot bar",
// "cms left column" => "cms left column",
// "cms right column" => "cms right column",
// "cms top bar" => "cms top bar",
// "cms spellcheck" => "cms spellcheck",
// "art home title" => "art home title",
// "feature trackers" => "feature trackers",
// "t use db" => "t use db",
// "t use dir" => "t use dir",
// "groupTracker" => "groupTracker",
// "userTracker" => "userTracker",
// "trk with mirror tables" => "trk with mirror tables",
// "trackerCreatorGroupName" => "trackerCreatorGroupName",
// "tracker jquery user selector threshold" => "tracker jquery user selector threshold",
// "feature userlevels" => "feature userlevels",
// "userlevels" => "userlevels",
// "userbreadCrumb" => "userbreadCrumb",
// "user assigned modules" => "user assigned modules",
// "user flip modules" => "user flip modules",
// "user show realnames" => "user show realnames",
// "feature mytiki" => "feature mytiki",
// "feature userPreferences" => "feature userPreferences",
// "feature user bookmarks" => "feature user bookmarks",
// "feature tasks" => "feature tasks",
// "w use db" => "w use db",
// "w use dir" => "w use dir",
// "w displayed default" => "w displayed default",
// "uf use db" => "uf use db",
// "uf use dir" => "uf use dir",
// "userfiles quota" => "userfiles quota",
// "feature usermenu" => "feature usermenu",
// "feature minical" => "feature minical",
// "feature notepad" => "feature notepad",
// "feature userfiles" => "feature userfiles",
// "feature community gender" => "feature community gender",
// "feature community mouseover" => "feature community mouseover",
// "feature community mouseover name" => "feature community mouseover name",
// "feature community mouseover gender" => "feature community mouseover gender",
// "feature community mouseover picture" => "feature community mouseover picture",
// "feature community mouseover friends" => "feature community mouseover friends",
// "feature community mouseover score" => "feature community mouseover score",
// "feature community mouseover country" => "feature community mouseover country",
// "feature community mouseover email" => "feature community mouseover email",
// "feature community mouseover lastlogin" => "feature community mouseover lastlogin",
// "feature community mouseover distance" => "feature community mouseover distance",
// "feature community list name" => "feature community list name",
// "feature community list score" => "feature community list score",
// "feature community list country" => "feature community list country",
// "feature community list distance" => "feature community list distance",
// "feature community friends permission" => "feature community friends permission",
// "feature community friends permission dep" => "feature community friends permission dep",
// "change language" => "change language",
// "change theme" => "change theme",
// "login is email" => "login is email",
// "validateUsers" => "validateUsers",
// "validateEmail" => "validateEmail",
// "forgotPass" => "forgotPass",
// "change password" => "change password",
// "available languages" => "available languages",
// "available styles" => "available styles",
// "lowercase username" => "lowercase username",
// "username pattern" => "username pattern",
// "max username length" => "max username length",
// "min username length" => "min username length",
// "users prefs allowMsgs" => "users prefs allowMsgs",
// "users prefs country" => "users prefs country",
// "users prefs diff versions" => "users prefs diff versions",
// "users prefs display timezone" => "users prefs display timezone",
// "users prefs email is public" => "users prefs email is public",
// "users prefs homePage" => "users prefs homePage",
// "users prefs lat" => "users prefs lat",
// "users prefs lon" => "users prefs lon",
// "users prefs mess archiveAfter" => "users prefs mess archiveAfter",
// "users prefs mess maxRecords" => "users prefs mess maxRecords",
// "users prefs mess sendReadStatus" => "users prefs mess sendReadStatus",
// "users prefs minPrio" => "users prefs minPrio",
// "users prefs mytiki blogs" => "users prefs mytiki blogs",
// "users prefs mytiki articles" => "users prefs mytiki articles",
// "users prefs mytiki gals" => "users prefs mytiki gals",
// "users prefs mytiki items" => "users prefs mytiki items",
// "users prefs mytiki msgs" => "users prefs mytiki msgs",
// "users prefs mytiki pages" => "users prefs mytiki pages",
// "users prefs mytiki tasks" => "users prefs mytiki tasks",
// "users prefs mytiki forum topics" => "users prefs mytiki forum topics",
// "users prefs mytiki forum replies" => "users prefs mytiki forum replies",
// "users prefs realName" => "users prefs realName",
// "users prefs gender" => "users prefs gender",
// "users prefs show mouseover user info" => "users prefs show mouseover user info",
// "users prefs tasks maxRecords" => "users prefs tasks maxRecords",
// "users prefs user dbl" => "users prefs user dbl",
// "users prefs user information" => "users prefs user information",
// "users prefs userbreadCrumb" => "users prefs userbreadCrumb",
// "users prefs mailCharset" => "users prefs mailCharset",
// "users prefs mailCurrentAccount" => "users prefs mailCurrentAccount",
// "validateRegistration" => "validateRegistration",
// "validator emails" => "validator emails",
// "url after validation" => "url after validation",
// "urlOnUsername" => "urlOnUsername",
// "feature messages" => "feature messages",
// "messu mailbox size" => "messu mailbox size",
// "messu archive size" => "messu archive size",
// "messu sent size" => "messu sent size",
// "allowmsg by default" => "allowmsg by default",
// "allowmsg is optional" => "allowmsg is optional",
// "feature freetags" => "feature freetags",
// "freetags browse show cloud" => "freetags browse show cloud",
// "freetags cloud colors" => "freetags cloud colors",
// "freetags preload random search" => "freetags preload random search",
// "freetags browse amount tags in cloud" => "freetags browse amount tags in cloud",
// "freetags browse amount tags suggestion" => "freetags browse amount tags suggestion",
// "freetags normalized valid chars" => "freetags normalized valid chars",
// "freetags lowercase only" => "freetags lowercase only",
// "freetags feature 3d" => "freetags feature 3d",
// "freetags 3d width" => "freetags 3d width",
// "freetags 3d height" => "freetags 3d height",
// "freetags 3d navigation depth" => "freetags 3d navigation depth",
// "freetags 3d feed animation interval" => "freetags 3d feed animation interval",
// "freetags 3d existing page color" => "freetags 3d existing page color",
// "freetags 3d missing page color" => "freetags 3d missing page color",
// "freetags 3d autoload" => "freetags 3d autoload",
// "freetags 3d camera distance" => "freetags 3d camera distance",
// "freetags 3d elastic constant" => "freetags 3d elastic constant",
// "freetags 3d eletrostatic constant" => "freetags 3d eletrostatic constant",
// "freetags 3d fov" => "freetags 3d fov",
// "freetags 3d friction constant" => "freetags 3d friction constant",
// "freetags 3d node charge" => "freetags 3d node charge",
// "freetags 3d node mass" => "freetags 3d node mass",
// "freetags 3d node size" => "freetags 3d node size",
// "freetags 3d spring size" => "freetags 3d spring size",
// "freetags 3d text size" => "freetags 3d text size",
// "freetags 3d adjust camera" => "freetags 3d adjust camera",
// "freetags multilingual" => "freetags multilingual",
// "morelikethis algorithm" => "morelikethis algorithm",
// "morelikethis basic mincommon" => "morelikethis basic mincommon",
// "freetags show middle" => "freetags show middle",
// "feature search stats" => "feature search stats",
// "feature search" => "feature search",
// "feature search fulltext" => "feature search fulltext",
// "feature search show forbidden obj" => "feature search show forbidden obj",
// "feature search show forbidden cat" => "feature search show forbidden cat",
// "feature search show object filter" => "feature search show object filter",
// "feature search show search box" => "feature search show search box",
// "feature search show visit count" => "feature search show visit count",
// "feature search show pertinence" => "feature search show pertinence",
// "feature search show object type" => "feature search show object type",
// "feature search show last modification" => "feature search show last modification",
// "search refresh index mode" => "search refresh index mode",
// "search parsed snippet" => "search parsed snippet",
// "feature search preferences" => "feature search preferences",
// "feature webmail" => "feature webmail",
// "webmail max attachment" => "webmail max attachment",
// "webmail view html" => "webmail view html",
// "feature contacts" => "feature contacts",
// "feature faqs" => "feature faqs",
// "feature faq comments" => "feature faq comments",
// "faq comments per page" => "faq comments per page",
// "faq comments default ordering" => "faq comments default ordering",
// "faq prefix" => "faq prefix",
// "feature quizzes" => "feature quizzes",
// "feature polls" => "feature polls",
// "feature poll comments" => "feature poll comments",
// "feature poll anonymous" => "feature poll anonymous",
// "poll comments default ordering" => "poll comments default ordering",
// "poll comments per page" => "poll comments per page",
// "poll list categories" => "poll list categories",
// "poll list objects" => "poll list objects",
// "feature poll revote" => "feature poll revote",
// "feature surveys" => "feature surveys",
// "feature featuredLinks" => "feature featuredLinks",
// "feature directory" => "feature directory",
// "directory columns" => "directory columns",
// "directory links per page" => "directory links per page",
// "directory open links" => "directory open links",
// "directory validate urls" => "directory validate urls",
// "directory cool sites" => "directory cool sites",
// "directory country flag" => "directory country flag",
// "feature calendar" => "feature calendar",
// "feature default calendars" => "feature default calendars",
// "calendar sticky popup" => "calendar sticky popup",
// "default calendars" => "default calendars",
// "calendar view mode" => "calendar view mode",
// "calendar view tab" => "calendar view tab",
// "calendar firstDayofWeek" => "calendar firstDayofWeek",
// "calendar timespan" => "calendar timespan",
// "feature jscalendar" => "feature jscalendar",
// "feature action calendar" => "feature action calendar",
// "calendar start year" => "calendar start year",
// "calendar end year" => "calendar end year",
// "calendar list begins focus" => "calendar list begins focus",
// "feature cal manual time" => "feature cal manual time",
// "server timezone" => "server timezone",
// "long date format" => "long date format",
// "long time format" => "long time format",
// "short date format" => "short date format",
// "short time format" => "short time format",
// "display field order" => "display field order",
// "rss forums" => "rss forums",
// "rss forum" => "rss forum",
// "rss directories" => "rss directories",
// "rss articles" => "rss articles",
// "rss blogs" => "rss blogs",
// "rss image galleries" => "rss image galleries",
// "rss file galleries" => "rss file galleries",
// "rss wiki" => "rss wiki",
// "rss image gallery" => "rss image gallery",
// "rss file gallery" => "rss file gallery",
// "rss blog" => "rss blog",
// "rss tracker" => "rss tracker",
// "rss trackers" => "rss trackers",
// "rss calendar" => "rss calendar",
// "rss mapfiles" => "rss mapfiles",
// "rss cache time" => "rss cache time",
// "title rss forums" => "title rss forums",
// "title rss forum" => "title rss forum",
// "title rss directories" => "title rss directories",
// "title rss articles" => "title rss articles",
// "title rss blogs" => "title rss blogs",
// "title rss image galleries" => "title rss image galleries",
// "title rss file galleries" => "title rss file galleries",
// "title rss wiki" => "title rss wiki",
// "title rss image gallery" => "title rss image gallery",
// "title rss file gallery" => "title rss file gallery",
// "title rss blog" => "title rss blog",
// "title rss tracker" => "title rss tracker",
// "title rss trackers" => "title rss trackers",
// "title rss calendar" => "title rss calendar",
// "title rss mapfiles" => "title rss mapfiles",
// "max rss forums" => "max rss forums",
// "max rss forum" => "max rss forum",
// "max rss directories" => "max rss directories",
// "max rss articles" => "max rss articles",
// "max rss blogs" => "max rss blogs",
// "max rss image galleries" => "max rss image galleries",
// "max rss file galleries" => "max rss file galleries",
// "max rss wiki" => "max rss wiki",
// "max rss image gallery" => "max rss image gallery",
// "max rss file gallery" => "max rss file gallery",
// "max rss blog" => "max rss blog",
// "max rss mapfiles" => "max rss mapfiles",
// "max rss tracker" => "max rss tracker",
// "max rss trackers" => "max rss trackers",
// "max rss calendar" => "max rss calendar",
// "summary rss blogs" => "summary rss blogs",
// "rssfeed default version" => "rssfeed default version",
// "rssfeed language" => "rssfeed language",
// "rssfeed editor" => "rssfeed editor",
// "rssfeed webmaster" => "rssfeed webmaster",
// "rssfeed creator" => "rssfeed creator",
// "rssfeed css" => "rssfeed css",
// "rssfeed publisher" => "rssfeed publisher",
// "rssfeed img" => "rssfeed img",
// "rss basic auth" => "rss basic auth",
// "feature maps" => "feature maps",
// "map path" => "map path",
// "default map" => "default map",
// "map help" => "map help",
// "map comments" => "map comments",
// "gdaltindex" => "gdaltindex",
// "ogr2ogr" => "ogr2ogr",
// "mapzone" => "mapzone",
// "feature gmap" => "feature gmap",
// "gmap defaultx" => "gmap defaultx",
// "gmap defaulty" => "gmap defaulty",
// "gmap defaultz" => "gmap defaultz",
// "gmap key" => "gmap key",
// "allowRegister" => "allowRegister",
// "eponymousGroups" => "eponymousGroups",
// "useRegisterPasscode" => "useRegisterPasscode",
// "registerPasscode" => "registerPasscode",
// "rememberme" => "rememberme",
// "remembertime" => "remembertime",
// "feature clear passwords" => "feature clear passwords",
// "feature crypt passwords" => "feature crypt passwords",
// "feature challenge" => "feature challenge",
// "min user length" => "min user length",
// "min pass length" => "min pass length",
// "pass chr num" => "pass chr num",
// "pass due" => "pass due",
// "email due" => "email due",
// "unsuccessful logins" => "unsuccessful logins",
// "rnd num reg" => "rnd num reg",
// "generate password" => "generate password",
// "auth method" => "auth method",
// "auth pear" => "auth pear",
// "auth ldap url" => "auth ldap url",
// "auth pear host" => "auth pear host",
// "auth pear port" => "auth pear port",
// "auth ldap scope" => "auth ldap scope",
// "auth ldap basedn" => "auth ldap basedn",
// "auth ldap userdn" => "auth ldap userdn",
// "auth ldap userattr" => "auth ldap userattr",
// "auth ldap useroc" => "auth ldap useroc",
// "auth ldap groupdn" => "auth ldap groupdn",
// "auth ldap groupattr" => "auth ldap groupattr",
// "auth ldap groupnameatr" => "auth ldap groupnameatr",
// "auth ldap groupdescatr" => "auth ldap groupdescatr",
// "auth ldap usergroupattr" => "auth ldap usergroupattr",
// "auth ldap groupgroupattr" => "auth ldap groupgroupattr",
// "auth ldap groupoc" => "auth ldap groupoc",
// "auth ldap memberattr" => "auth ldap memberattr",
// "auth ldap memberisdn" => "auth ldap memberisdn",
// "auth ldap adminuser" => "auth ldap adminuser",
// "auth ldap adminpass" => "auth ldap adminpass",
// "auth ldap version" => "auth ldap version",
// "auth ldap nameattr" => "auth ldap nameattr",
// "auth ldap countryattr" => "auth ldap countryattr",
// "auth ldap emailattr" => "auth ldap emailattr",
// "ldap create user tiki" => "ldap create user tiki",
// "ldap create user ldap" => "ldap create user ldap",
// "ldap skip admin" => "ldap skip admin",
// "auth ldap permit tiki users" => "auth ldap permit tiki users",
// "auth ldap debug" => "auth ldap debug",
// "auth ldap ssl" => "auth ldap ssl",
// "auth ldap starttls" => "auth ldap starttls",
// "auth ldap type" => "auth ldap type",
// "auth ldap syncuserattr" => "auth ldap syncuserattr",
// "auth ldap syncgroupattr" => "auth ldap syncgroupattr",
// "https login" => "https login",
// "feature show stay in ssl mode" => "feature show stay in ssl mode",
// "feature switch ssl mode" => "feature switch ssl mode",
// "https port" => "https port",
// "http port" => "http port",
// "login url" => "login url",
// "login scr" => "login scr",
// "register url" => "register url",
// "error url" => "error url",
// "highlight group" => "highlight group",
// "cookie path" => "cookie path",
// "cookie domain" => "cookie domain",
// "cookie name" => "cookie name",
// "user tracker infos" => "user tracker infos",
// "desactive login autocomplete" => "desactive login autocomplete",
// "permission denied login box" => "permission denied login box",
// "permission denied url" => "permission denied url",
// "feature intertiki" => "feature intertiki",
// "feature intertiki server" => "feature intertiki server",
// "feature intertiki slavemode" => "feature intertiki slavemode",
// "interlist" => "interlist",
// "feature intertiki mymaster" => "feature intertiki mymaster",
// "feature intertiki import preferences" => "feature intertiki import preferences",
// "feature intertiki import groups" => "feature intertiki import groups",
// "known hosts" => "known hosts",
// "tiki key" => "tiki key",
// "intertiki logfile" => "intertiki logfile",
// "intertiki errfile" => "intertiki errfile",
// "feature intertiki sharedcookie" => "feature intertiki sharedcookie",
// "search lru length" => "search lru length",
// "search lru purge rate" => "search lru purge rate",
// "search max syllwords" => "search max syllwords",
// "search min wordlength" => "search min wordlength",
// "search refresh rate" => "search refresh rate",
// "search syll age" => "search syll age",
// "feature categories" => "feature categories",
// "feature categoryobjects" => "feature categoryobjects",
// "feature categorypath" => "feature categorypath",
// "feature category reinforce" => "feature category reinforce",
// "feature category use phplayers" => "feature category use phplayers",
// "categorypath excluded" => "categorypath excluded",
// "categories used in tpl" => "categories used in tpl",
// "category jail" => "category jail",
// "expanded category jail" => "expanded category jail",
// "expanded category jail key" => "expanded category jail key",
// "feature html pages" => "feature html pages",
// "feature filegals manager" => "feature filegals manager",
// "feature contact" => "feature contact",
// "contact user" => "contact user",
// "contact anon" => "contact anon",
// "mail crlf" => "mail crlf",
// "feature detect language" => "feature detect language",
// "feature homePage if bl missing" => "feature homePage if bl missing",
// "record untranslated" => "record untranslated",
// "feature best language" => "feature best language",
// "feature translation" => "feature translation",
// "feature urgent translation" => "feature urgent translation",
// "feature translation incomplete notice" => "feature translation incomplete notice",
// "lang use db" => "lang use db",
// "language" => "language",
// "feature babelfish" => "feature babelfish",
// "feature babelfish logo" => "feature babelfish logo",
// "quantify changes" => "quantify changes",
// "feature sync language" => "feature sync language",
// "show available translations" => "show available translations",
// "language inclusion threshold" => "language inclusion threshold",
// "metatag keywords" => "metatag keywords",
// "metatag threadtitle" => "metatag threadtitle",
// "metatag imagetitle" => "metatag imagetitle",
// "metatag freetags" => "metatag freetags",
// "metatag description" => "metatag description",
// "metatag pagedesc" => "metatag pagedesc",
// "metatag author" => "metatag author",
// "metatag geoposition" => "metatag geoposition",
// "metatag georegion" => "metatag georegion",
// "metatag geoplacename" => "metatag geoplacename",
// "metatag robots" => "metatag robots",
// "metatag revisitafter" => "metatag revisitafter",
// "head extra js" => "head extra js",
// "keep versions" => "keep versions",
// "feature custom home" => "feature custom home",
// "site crumb seper" => "site crumb seper",
// "site nav seper" => "site nav seper",
// "feature sitemycode" => "feature sitemycode",
// "sitemycode" => "sitemycode",
// "sitemycode publish" => "sitemycode publish",
// "feature sitelogo" => "feature sitelogo",
// "sitelogo bgcolor" => "sitelogo bgcolor",
// "sitelogo bgstyle" => "sitelogo bgstyle",
// "sitelogo align" => "sitelogo align",
// "sitelogo title" => "sitelogo title",
// "sitelogo src" => "sitelogo src",
// "sitelogo alt" => "sitelogo alt",
// "feature siteloc" => "feature siteloc",
// "feature sitenav" => "feature sitenav",
// "sitenav" => "sitenav",
// "feature sitead" => "feature sitead",
// "sitead" => "sitead",
// "sitead publish" => "sitead publish",
// "feature breadcrumbs" => "feature breadcrumbs",
// "feature siteloclabel" => "feature siteloclabel",
// "feature sitesearch" => "feature sitesearch",
// "feature site login" => "feature site login",
// "feature sitemenu" => "feature sitemenu",
// "feature topbar version" => "feature topbar version",
// "feature topbar debug" => "feature topbar debug",
// "feature topbar id menu" => "feature topbar id menu",
// "feature topbar custom code" => "feature topbar custom code",
// "feature sitetitle" => "feature sitetitle",
// "feature sitedesc" => "feature sitedesc",
// "feature bot logo" => "feature bot logo",
// "feature endbody code" => "feature endbody code",
// "feature custom html head content" => "feature custom html head content",
// "users prefs theme" => "users prefs theme",
// "feature left column" => "feature left column",
// "feature right column" => "feature right column",
// "feature top bar" => "feature top bar",
// "feature bot bar" => "feature bot bar",
// "feature bot bar icons" => "feature bot bar icons",
// "feature bot bar debug" => "feature bot bar debug",
// "feature bot bar rss" => "feature bot bar rss",
// "feature bot bar power by tw" => "feature bot bar power by tw",
// "maxRecords" => "maxRecords",
// "maxArticles" => "maxArticles",
// "maxVersions" => "maxVersions",
// "feature view tpl" => "feature view tpl",
// "slide style" => "slide style",
// "site favicon" => "site favicon",
// "site favicon type" => "site favicon type",
// "style" => "style",
// "style option" => "style option",
// "site style" => "site style",
// "site style option" => "site style option",
// "use context menu icon" => "use context menu icon",
// "use context menu text" => "use context menu text",
// "feature site report" => "feature site report",
// "feature site send link" => "feature site send link",
// "feature layoutshadows" => "feature layoutshadows",
// "main shadow start" => "main shadow start",
// "main shadow end" => "main shadow end",
// "header shadow start" => "header shadow start",
// "header shadow end" => "header shadow end",
// "middle shadow start" => "middle shadow start",
// "middle shadow end" => "middle shadow end",
// "center shadow start" => "center shadow start",
// "center shadow end" => "center shadow end",
// "footer shadow start" => "footer shadow start",
// "footer shadow end" => "footer shadow end",
// "box shadow start" => "box shadow start",
// "box shadow end" => "box shadow end",
// "feature custom center column header" => "feature custom center column header",
// "feature mods provider" => "feature mods provider",
// "mods dir" => "mods dir",
// "mods server" => "mods server",
// "feature experimental" => "feature experimental",
// "feature actionlog" => "feature actionlog",
// "feature actionlog bytes" => "feature actionlog bytes",
// "browsertitle" => "browsertitle",
// "site title location" => "site title location",
// "site title breadcrumb" => "site title breadcrumb",
// "tmpDir" => "tmpDir",
// "feature tell a friend" => "feature tell a friend",
// "feature copyright" => "feature copyright",
// "feature multimedia" => "feature multimedia",
// "feature smileys" => "feature smileys",
// "popupLinks" => "popupLinks",
// "feature autolinks" => "feature autolinks",
// "default rows textarea wiki" => "default rows textarea wiki",
// "default rows textarea comment" => "default rows textarea comment",
// "default rows textarea forum" => "default rows textarea forum",
// "default rows textarea forumthread" => "default rows textarea forumthread",
// "section comments parse" => "section comments parse",
// "toolbar global" => "toolbar global",
// "toolbar global comments" => "toolbar global comments",
// "direct pagination" => "direct pagination",
// "nextprev pagination" => "nextprev pagination",
// "pagination firstlast" => "pagination firstlast",
// "pagination hide if one page" => "pagination hide if one page",
// "pagination icons" => "pagination icons",
// "pagination fastmove links" => "pagination fastmove links",
// "direct pagination max middle links" => "direct pagination max middle links",
// "direct pagination max ending links" => "direct pagination max ending links",
// "feature kaltura" => "feature kaltura",
// "wikiplugin kaltura" => "wikiplugin kaltura",
// "wikiplugininline kaltura" => "wikiplugininline kaltura",
// "default kaltura editor" => "default kaltura editor",
// "partnerId" => "partnerId",
// "secret" => "secret",
// "adminSecret" => "adminSecret",
// "kdpUIConf" => "kdpUIConf",
// "kdpWidget" => "kdpWidget",
// "kcwUIConf" => "kcwUIConf",
// "kseUIConf" => "kseUIConf",
// "kaeUIConf" => "kaeUIConf",
// "anonCanEdit" => "anonCanEdit",
// "cacheimages" => "cacheimages",
// "cachepages" => "cachepages",
// "count admin pvs" => "count admin pvs",
// "default mail charset" => "default mail charset",
// "error reporting adminonly" => "error reporting adminonly",
// "error reporting level" => "error reporting level",
// "smarty notice reporting" => "smarty notice reporting",
// "smarty security" => "smarty security",
// "feature htmlpurifier output" => "feature htmlpurifier output",
// "feature ajax" => "feature ajax",
// "feature ajax autosave" => "feature ajax autosave",
// "feature antibot" => "feature antibot",
// "feature banners" => "feature banners",
// "feature banning" => "feature banning",
// "feature comm" => "feature comm",
// "feature contribution" => "feature contribution",
// "feature contribution display in comment" => "feature contribution display in comment",
// "feature contribution mandatory" => "feature contribution mandatory",
// "feature contribution mandatory blog" => "feature contribution mandatory blog",
// "feature contribution mandatory comment" => "feature contribution mandatory comment",
// "feature contribution mandatory forum" => "feature contribution mandatory forum",
// "feature debug console" => "feature debug console",
// "feature debugger console" => "feature debugger console",
// "feature display my to others" => "feature display my to others",
// "feature dynamic content" => "feature dynamic content",
// "feature edit templates" => "feature edit templates",
// "feature editcss" => "feature editcss",
// "feature events" => "feature events",
// "feature friends" => "feature friends",
// "feature fullscreen" => "feature fullscreen",
// "feature help" => "feature help",
// "feature hotwords" => "feature hotwords",
// "feature hotwords nw" => "feature hotwords nw",
// "feature integrator" => "feature integrator",
// "feature live support" => "feature live support",
// "feature mailin" => "feature mailin",
// "feature menusfolderstyle" => "feature menusfolderstyle",
// "feature mobile" => "feature mobile",
// "feature modulecontrols" => "feature modulecontrols",
// "feature morcego" => "feature morcego",
// "feature multilingual" => "feature multilingual",
// "feature multilingual one page" => "feature multilingual one page",
// "feature multilingual structures" => "feature multilingual structures",
// "feature machine translation" => "feature machine translation",
// "feature newsletters" => "feature newsletters",
// "feature obzip" => "feature obzip",
// "feature perspective" => "feature perspective",
// "feature phplayers" => "feature phplayers",
// "feature cssmenus" => "feature cssmenus",
// "feature projects" => "feature projects",
// "feature ranking" => "feature ranking",
// "feature redirect on error" => "feature redirect on error",
// "feature referer highlight" => "feature referer highlight",
// "feature referer stats" => "feature referer stats",
// "feature score" => "feature score",
// "feature sheet" => "feature sheet",
// "feature shoutbox" => "feature shoutbox",
// "feature source" => "feature source",
// "feature stats" => "feature stats",
// "feature tabs" => "feature tabs",
// "feature theme control" => "feature theme control",
// "feature ticketlib" => "feature ticketlib",
// "feature ticketlib2" => "feature ticketlib2",
// "feature top banner" => "feature top banner",
// "feature usability" => "feature usability",
// "feature use quoteplugin" => "feature use quoteplugin",
// "feature user watches" => "feature user watches",
// "feature group watches" => "feature group watches",
// "feature user watches translations" => "feature user watches translations",
// "feature daily report watches" => "feature daily report watches",
// "feature quick object perms" => "feature quick object perms",
// "feature xmlrpc" => "feature xmlrpc",
// "helpurl" => "helpurl",
// "layout section" => "layout section",
// "limitedGoGroupHome" => "limitedGoGroupHome",
// "minical reminders" => "minical reminders",
// "modallgroups" => "modallgroups",
// "modseparateanon" => "modseparateanon",
// "php docroot" => "php docroot",
// "proxy host" => "proxy host",
// "proxy port" => "proxy port",
// "ip can be checked" => "ip can be checked",
// "sender email" => "sender email",
// "feature site report email" => "feature site report email",
// "session storage" => "session storage",
// "session lifetime" => "session lifetime",
// "session silent" => "session silent",
// "session cookie name" => "session cookie name",
// "shoutbox autolink" => "shoutbox autolink",
// "show comzone" => "show comzone",
// "tikiIndex" => "tikiIndex",
// "urlIndex" => "urlIndex",
// "useGroupHome" => "useGroupHome",
// "useGroupTheme" => "useGroupTheme",
// "useUrlIndex" => "useUrlIndex",
// "use proxy" => "use proxy",
// "user list order" => "user list order",
// "webserverauth" => "webserverauth",
// "feature purifier" => "feature purifier",
// "feature shadowbox" => "feature shadowbox",
// "log sql" => "log sql",
// "log sql perf min" => "log sql perf min",
// "log mail" => "log mail",
// "log tpl" => "log tpl",
// "case patched" => "case patched",
// "site closed" => "site closed",
// "site closed msg" => "site closed msg",
// "use load threshold" => "use load threshold",
// "load threshold" => "load threshold",
// "site busy msg" => "site busy msg",
// "bot logo code" => "bot logo code",
// "feature blogposts pings" => "feature blogposts pings",
// "feature create webhelp" => "feature create webhelp",
// "page n times in a structure" => "page n times in a structure",
// "feature forums search" => "feature forums search",
// "feature trackbackpings" => "feature trackbackpings",
// "feature wiki ext icon" => "feature wiki ext icon",
// "feature wiki mandatory category" => "feature wiki mandatory category",
// "feature intertiki imported groups" => "feature intertiki imported groups",
// "feature wiki history ip" => "feature wiki history ip",
// "pam create user tiki" => "pam create user tiki",
// "pam service" => "pam service",
// "pam skip admin" => "pam skip admin",
// "shib affiliation" => "shib affiliation",
// "shib create user tiki" => "shib create user tiki",
// "shib group" => "shib group",
// "shib skip admin" => "shib skip admin",
// "shib usegroup" => "shib usegroup",
// "wiki 3d camera distance" => "wiki 3d camera distance",
// "wiki 3d elastic constant" => "wiki 3d elastic constant",
// "wiki 3d eletrostatic constant" => "wiki 3d eletrostatic constant",
// "wiki 3d fov" => "wiki 3d fov",
// "wiki 3d friction constant" => "wiki 3d friction constant",
// "wiki 3d node charge" => "wiki 3d node charge",
// "wiki 3d node mass" => "wiki 3d node mass",
// "wiki 3d node size" => "wiki 3d node size",
// "wiki 3d spring size" => "wiki 3d spring size",
// "wiki 3d text size" => "wiki 3d text size",
// "articles feature copyrights" => "articles feature copyrights",
// "blogues feature copyrights" => "blogues feature copyrights",
// "faqs feature copyrights" => "faqs feature copyrights",
// "feature contributor wiki" => "feature contributor wiki",
// "https login required" => "https login required",
// "maxRowsGalleries" => "maxRowsGalleries",
// "replimaster" => "replimaster",
// "rowImagesGalleries" => "rowImagesGalleries",
// "scaleSizeGalleries" => "scaleSizeGalleries",
// "thumbSizeXGalleries" => "thumbSizeXGalleries",
// "thumbSizeYGalleries" => "thumbSizeYGalleries",
// "wiki 3d adjust camera" => "wiki 3d adjust camera",
// "wiki 3d autoload" => "wiki 3d autoload",
// "javascript enabled" => "javascript enabled",
// "feature comments post as anonymous" => "feature comments post as anonymous",
// "feature comments moderation" => "feature comments moderation",
// "feature comments locking" => "feature comments locking",
// "feature template zoom" => "feature template zoom",
// "menus items icons" => "menus items icons",
// "menus items icons path" => "menus items icons path",
// "feature iepngfix" => "feature iepngfix",
// "iepngfix selectors" => "iepngfix selectors",
// "iepngfix elements" => "iepngfix elements",
// "valid email regex" => "valid email regex",
// "feature jquery" => "feature jquery",
// "jquery effect" => "jquery effect",
// "jquery effect direction" => "jquery effect direction",
// "jquery effect speed" => "jquery effect speed",
// "jquery effect tabs" => "jquery effect tabs",
// "jquery effect tabs direction" => "jquery effect tabs direction",
// "jquery effect tabs speed" => "jquery effect tabs speed",
// "feature jquery ui" => "feature jquery ui",
// "feature jquery ui theme" => "feature jquery ui theme",
// "feature jquery tooltips" => "feature jquery tooltips",
// "feature jquery autocomplete" => "feature jquery autocomplete",
// "feature jquery superfish" => "feature jquery superfish",
// "feature jquery reflection" => "feature jquery reflection",
// "feature jquery sheet" => "feature jquery sheet",
// "feature jquery tablesorter" => "feature jquery tablesorter",
// "feature jquery cycle" => "feature jquery cycle",
// "feature sefurl" => "feature sefurl",
// "feature sefurl filter" => "feature sefurl filter",
// "feature sefurl paths" => "feature sefurl paths",
// "feature sefurl title article" => "feature sefurl title article",
// "feature sefurl title blog" => "feature sefurl title blog",
// "feature wiki screencasts" => "feature wiki screencasts",
// "feature wiki screencasts base" => "feature wiki screencasts base",
// "feature wiki screencasts httpbase" => "feature wiki screencasts httpbase",
// "feature wiki screencasts upload type" => "feature wiki screencasts upload type",
// "feature wiki screencasts user" => "feature wiki screencasts user",
// "feature wiki screencasts pass" => "feature wiki screencasts pass",
// "feature wiki screencasts max size" => "feature wiki screencasts max size",
// "feature tikitests" => "feature tikitests",
// "profile sources" => "profile sources",
// "profile channels" => "profile channels",
// "feature minichat" => "feature minichat",
// "memcache enabled" => "memcache enabled",
// "memcache flags" => "memcache flags",
// "memcache servers" => "memcache servers",
// "memcache expiration" => "memcache expiration",
// "memcache prefix" => "memcache prefix",
// "memcache wiki data" => "memcache wiki data",
// "memcache wiki output" => "memcache wiki output",
// "memcache forum output" => "memcache forum output",
// "feature pear date" => "feature pear date",
// "feature bidi" => "feature bidi",
// "feature lastup" => "feature lastup",
// "magic last load" => "magic last load",
// "feature groupalert" => "feature groupalert",
// "zend mail handler" => "zend mail handler",
// "zend mail smtp server" => "zend mail smtp server",
// "zend mail smtp auth" => "zend mail smtp auth",
// "zend mail smtp user" => "zend mail smtp user",
// "zend mail smtp pass" => "zend mail smtp pass",
// "zend mail smtp port" => "zend mail smtp port",
// "zend mail smtp security" => "zend mail smtp security",
// "feature group transition" => "feature group transition",
// "feature category transition" => "feature category transition",
// "terminology profile installed" => "terminology profile installed",
// "multidomain active" => "multidomain active",
// "multidomain config" => "multidomain config",
// "feature use minified scripts" => "feature use minified scripts",
// "tiki minify javascript" => "tiki minify javascript",
// "lib spellcheck" => "lib spellcheck",
// "wiki spellcheck" => "wiki spellcheck",
// "blog spellcheck" => "blog spellcheck",
// "allowMsgs" => "allowMsgs",
// "diff versions" => "diff versions",
// "display timezone" => "display timezone",
// "email is public" => "email is public",
// "homePage" => "homePage",
// "lat" => "lat",
// "lon" => "lon",
// "mess archiveAfter" => "mess archiveAfter",
// "mess maxRecords" => "mess maxRecords",
// "mess sendReadStatus" => "mess sendReadStatus",
// "minPrio" => "minPrio",
// "mytiki blogs" => "mytiki blogs",
// "mytiki articles" => "mytiki articles",
// "mytiki gals" => "mytiki gals",
// "mytiki items" => "mytiki items",
// "mytiki msgs" => "mytiki msgs",
// "mytiki pages" => "mytiki pages",
// "mytiki tasks" => "mytiki tasks",
// "mytiki forum topics" => "mytiki forum topics",
// "mytiki forum replies" => "mytiki forum replies",
// "realName" => "realName",
// "gender" => "gender",
// "show mouseover user info" => "show mouseover user info",
// "tasks maxRecords" => "tasks maxRecords",
// "user dbl" => "user dbl",
// "user information" => "user information",
// "mailCharset" => "mailCharset",
// "mailCurrentAccount" => "mailCurrentAccount",
// "Click Here to Insert in Wiki Syntax" => "Click Here to Insert in Wiki Syntax",
// "Select Categories" => "Select Categories",
// "Select/deselect all categories" => "Select/deselect all categories",
// "top of page" => "top of page",
// "Report this post" => "Report this post",
// "Group Monitor" => "Group Monitor",
// "Watched by categories" => "Watched by categories",
// "Errors" => "Errors",
// "Comments Locked" => "Comments Locked",
// "Comments are locked" => "Comments are locked",
// "Note" => "Note",
// "Post new message" => "Post new message",
// "required" => "required",
// "Maximum size" => "Maximum size",
// "Enter your name" => "Enter your name",
// "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address" => "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address",
// "Please note that the preview does not keep the attached file which you will have to choose before posting" => "Please note that the preview does not keep the attached file which you will have to choose before posting",
// "Post as Anonymous" => "Post as Anonymous",
// "Your comment will have to be approved by the moderator before it is displayed" => "Your comment will have to be approved by the moderator before it is displayed",
// "Type of contribution" => "Type of contribution",
// "Contributors" => "Contributors",
// "System error" => "System error",
// "Database is not currently up to date! Visit <a href=\"tiki-install.php\">Tiki Installer</a> to resolve this issue" => "Database is not currently up to date! Visit <a href=\"tiki-install.php\">Tiki Installer</a> to resolve this issue",
// "If you have shell (SSH) access, you can also use the following, on the command line, from the root of your Tiki installation" => "If you have shell (SSH) access, you can also use the following, on the command line, from the root of your Tiki installation",
// "The query was" => "The query was",
// "The built query was likely" => "The built query was likely",
// "Stacktrace" => "Stacktrace",
// "Duplicate File Gallery" => "Duplicate File Gallery",
// "File gallery" => "File gallery",
// "Duplicate categories" => "Duplicate categories",
// "Duplicate permissions" => "Duplicate permissions",
// "View inserted gallery" => "View inserted gallery",
// "Any file" => "Any file",
// "Podcast (audio)" => "Podcast (audio)",
// "Podcast (video)" => "Podcast (video)",
// "Gallery is visible to non-admin users" => "Gallery is visible to non-admin users",
// "Gallery is public" => "Gallery is public",
// "Any user with permission (not only the gallery owner) can upload files" => "Any user with permission (not only the gallery owner) can upload files",
// "Files can be locked at download" => "Files can be locked at download",
// "Maximum number of archives for each file" => "Maximum number of archives for each file",
// "Quota" => "Quota",
// "Used" => "Used",
// "Min" => "Min",
// "Group of users alerted when file gallery is modified" => "Group of users alerted when file gallery is modified",
// "Allows to select each user for small groups" => "Allows to select each user for small groups",
// "Display Properties" => "Display Properties",
// "Descending" => "Descending",
// "Ascending" => "Ascending",
// "Max rows per page" => "Max rows per page",
// "Select which items to display when listing galleries" => "Select which items to display when listing galleries",
// "Perhaps you are looking for" => "Perhaps you are looking for",
// "Go to Login Page" => "Go to Login Page",
// "(page will be orphaned)" => "(page will be orphaned)",
// "Go to" => "Go to",
// "Private Gallery" => "Private Gallery",
// "Archives" => "Archives",
// "Upload New Version" => "Upload New Version",
// "Download and lock" => "Download and lock",
// "The checkbox is disabled because this preference is disabled globally" => "The checkbox is disabled because this preference is disabled globally",
// "Please, enable the preference globally first" => "Please, enable the preference globally first",
// "You can ask your site Admin to enable the preference" => "You can ask your site Admin to enable the preference",
// "Show as a column" => "Show as a column",
// "Show in popup box" => "Show in popup box",
// "Show an icon in a column" => "Show an icon in a column",
// "Start the Slideshow" => "Start the Slideshow",
// "Pause the Slideshow" => "Pause the Slideshow",
// "Exact&nbsp;match" => "Exact&nbsp;match",
// "any type" => "any type",
// "all topic" => "all topic",
// "any language" => "any language",
// "not in" => "not in",
// "any category" => "any category",
// "Clear Filter" => "Clear Filter",
// "Show php error messages" => "Show php error messages",
// "Folksonomy Tags" => "Folksonomy Tags",
// "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together or enclose them with double quotes" => "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together or enclose them with double quotes",
// "Tags" => "Tags",
// "Translate tags" => "Translate tags",
// "Images Galleries" => "Images Galleries",
// "RSS Calendars" => "RSS Calendars",
// "Show Tree" => "Show Tree",
// "Hide Tree" => "Hide Tree",
// "Are you sure you want to delete the selected files" => "Are you sure you want to delete the selected files",
// "Download the zip" => "Download the zip",
// "Other Sorts" => "Other Sorts",
// "No Additionnal Sort" => "No Additionnal Sort",
// "No information" => "No information",
// "To validate your account and login to the site, please click on the following link" => "To validate your account and login to the site, please click on the following link",
// "The administrator approved your account" => "The administrator approved your account",
// "Confirm your email at %s" => "Confirm your email at %s",
// "A new topic was posted to forum" => "A new topic was posted to forum",
// "You are invited by" => "You are invited by",
// "You join this group" => "You join this group",
// "Join me on %s" => "Join me on %s",
// "Your account registration request for {\$mail_site} was validated by the site admin and your account is active now" => "Your account registration request for {\$mail_site} was validated by the site admin and your account is active now",
// "To login with your username and password, please follow this link" => "To login with your username and password, please follow this link",
// "User Account Activated" => "User Account Activated",
// "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first",
// "Assign to a group" => "Assign to a group",
// "Best regards" => "Best regards",
// "User Tracker" => "User Tracker",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "Someone" => "Someone",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Since this is your registered email address we inform that the password for this account is" => "Since this is your registered email address we inform that the password for this account is",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else" => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above" => "Important: The old password remains active if you don't click the link above",
// "Report for" => "Report for",
// "Last Report sent on" => "Last Report sent on",
// "Changes in detail" => "Changes in detail",
// "Look at this link" => "Look at this link",
// "A friend sends you a link from: " => "A friend sends you a link from: ",
// "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}",
// "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}" => "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}",
// "Download the file at" => "Download the file at",
// "Tracker was modified at" => "Tracker was modified at",
// "Please visit this link before login again" => "Please visit this link before login again",
// "Last attempt" => "Last attempt",
// "Confirm your account at %s" => "Confirm your account at %s",
// "An administrator of the site below has added you as a new user" => "An administrator of the site below has added you as a new user",
// "If you want to confirm your membership in this site, click on the following link to login for the first time" => "If you want to confirm your membership in this site, click on the following link to login for the first time",
// "Your authentication credentials are" => "Your authentication credentials are",
// "Welcome on the site" => "Welcome on the site",
// "Your personal access to" => "Your personal access to",
// "You'll receive email notification once your account is activated" => "You'll receive email notification once your account is activated",
// "Please do not attempt to login until you receive the email notification" => "Please do not attempt to login until you receive the email notification",
// "{\$mail_action} article post" => "{\$mail_action} article post",
// "{\$mail_title} by {\$mail_user} at" => "{\$mail_title} by {\$mail_user} at",
// "New article post" => "New article post",
// "Edited article post" => "Edited article post",
// "Deleted article post" => "Deleted article post",
// "{\$mail_action} article post at" => "{\$mail_action} article post at",
// "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}" => "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}",
// "View item calendar at" => "View item calendar at",
// "Modified calendar item" => "Modified calendar item",
// "New calendar item" => "New calendar item",
// "A new category was created in" => "A new category was created in",
// "A category was removed in" => "A category was removed in",
// "Removed by" => "Removed by",
// "removed" => "removed",
// "A category was updated" => "A category was updated",
// "Updated by" => "Updated by",
// "Old" => "Old",
// "updated" => "updated",
// "File Gallery %s changed" => "File Gallery %s changed",
// "A file was removed from the file gallery" => "A file was removed from the file gallery",
// "File Name" => "File Name",
// "A new file was posted to file gallery" => "A new file was posted to file gallery",
// "Posted by" => "Posted by",
// "New forum topic in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum topic in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "Image Gallery {\$galleryName} changed" => "Image Gallery {\$galleryName} changed",
// "A new file was posted to image gallery" => "A new file was posted to image gallery",
// "An object was added to category" => "An object was added to category",
// "Added by" => "Added by",
// "An object was removed from category" => "An object was removed from category",
// "A page has been added to your watched sub-structure" => "A page has been added to your watched sub-structure",
// "A page has been removed from your watched sub-structure" => "A page has been removed from your watched sub-structure",
// "A page has been promoted out your watched sub-structure" => "A page has been promoted out your watched sub-structure",
// "A page has been demoted to your watched structure" => "A page has been demoted to your watched structure",
// "Structure modified" => "Structure modified",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "A file was attached to {\$mail_page}" => "A file was attached to {\$mail_page}",
// "The page {\$mail_page} was deleted but used to be here" => "The page {\$mail_page} was deleted but used to be here",
// "The changes in this version follow below, followed after by the current full page text" => "The changes in this version follow below, followed after by the current full page text",
// "The old page content follows below" => "The old page content follows below",
// "Wiki page %s created by {\$mail_user}" => "Wiki page %s created by {\$mail_user}",
// "Wiki page %s deleted by {\$mail_user}" => "Wiki page %s deleted by {\$mail_user}",
// "A file was attached to %s" => "A file was attached to %s",
// "Wiki page %s changed by {\$mail_user}" => "Wiki page %s changed by {\$mail_user}",
// "Wiki page %s was commented on by" => "Wiki page %s was commented on by",
// "an anonymous user" => "an anonymous user",
// "Wiki page renamed" => "Wiki page renamed",
// "Old name" => "Old name",
// "Thank you for your registration. You may log in now" => "Thank you for your registration. You may log in now",
// "Query Results" => "Query Results",
// "Querying" => "Querying",
// "Scroll Up" => "Scroll Up",
// "Scroll Down" => "Scroll Down",
// "Zoom out" => "Zoom out",
// "Zoom in" => "Zoom in",
// "This layer has been set by the maps administrator to not be downloadable" => "This layer has been set by the maps administrator to not be downloadable",
// "from the mapfile" => "from the mapfile",
// "Archive is full" => "Archive is full",
// "Confirmation" => "Confirmation",
// "Please Confirm" => "Please Confirm",
// "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences" => "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences",
// "ERROR" => "ERROR",
// "No messages to download" => "No messages to download",
// "Mailbox is full! Delete or archive some messages if you want to receive more messages" => "Mailbox is full! Delete or archive some messages if you want to receive more messages",
// "is reply to" => "is reply to",
// "Auto-archive age for read messages" => "Auto-archive age for read messages",
// "Return to archive" => "Return to archive",
// "Return to outbox" => "Return to outbox",
// "Replied" => "Replied",
// "Not replied" => "Not replied",
// "Toggle module contents" => "Toggle module contents",
// "toggle" => "toggle",
// "Toggle Vertically" => "Toggle Vertically",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number " => "You forgot your Google ad_client number ",
// "More.." => "More..",
// "To configure your Tiki" => "To configure your Tiki",
// "Admin Home" => "Admin Home",
// "from the menu" => "from the menu",
// "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "To remove this module" => "To remove this module",
// "and remove the assistant module" => "and remove the assistant module",
// "You can also add other modules" => "You can also add other modules",
// "To customize the menu" => "To customize the menu",
// "and edit menu ID 42" => "and edit menu ID 42",
// "Or, create your own menu and add it to a module" => "Or, create your own menu and add it to a module",
// "To begin configuring Tiki, please" => "To begin configuring Tiki, please",
// "as admin" => "as admin",
// "The Tikiwiki Community" => "The Tikiwiki Community",
// "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>" => "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>",
// "Tikiwiki Documentation" => "Tikiwiki Documentation",
// "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>",
// "on blogpost" => "on blogpost",
// "Add event" => "Add event",
// "Missing %0 of the following categories" => "Missing %0 of the following categories",
// "%0 extra of the following categories" => "%0 extra of the following categories",
// "Unknown comparison" => "Unknown comparison",
// "Impossible condition, %0 of" => "Impossible condition, %0 of",
// "Apply" => "Apply",
// "Assign into category" => "Assign into category",
// "Unassign category" => "Unassign category",
// "Tags This Page Has" => "Tags This Page Has",
// "Add tags" => "Add tags",
// "List everything tagged" => "List everything tagged",
// "All Groups" => "All Groups",
// "Your Groups" => "Your Groups",
// "Emulated Groups" => "Emulated Groups",
// "Switch to Groups" => "Switch to Groups",
// "Simulate" => "Simulate",
// "No records to display" => "No records to display",
// "insert original" => "insert original",
// "insert thumbnail" => "insert thumbnail",
// "more" => "more",
// "No avatar" => "No avatar",
// "You" => "You",
// "Logged in as" => "Logged in as",
// "Switch User" => "Switch User",
// "Enter user name and click 'Switch'.<br />Useful for testing permissions" => "Enter user name and click 'Switch'.<br />Useful for testing permissions",
// "Switch user" => "Switch user",
// "Login through Shibboleth" => "Login through Shibboleth",
// "Login as" => "Login as",
// "CapsLock is on" => "CapsLock is on",
// "local account" => "local account",
// "OpenID Login" => "OpenID Login",
// "What is OpenID" => "What is OpenID",
// "Wiki feed" => "Wiki feed",
// "Feed" => "Feed",
// "Blogs feed" => "Blogs feed",
// "Articles feed" => "Articles feed",
// "Image Galleries feed" => "Image Galleries feed",
// "File Galleries feed" => "File Galleries feed",
// "Forums feed" => "Forums feed",
// "Maps feed" => "Maps feed",
// "Calendars" => "Calendars",
// "A leading plus sign indicates that this word must be present in every object returned" => "A leading plus sign indicates that this word must be present in every object returned",
// "A leading minus sign indicates that this word must not be present in any row returned" => "A leading minus sign indicates that this word must not be present in any row returned",
// "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher" => "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher",
// "These two operators are used to change a word's contribution to the relevance value that is assigned to a row" => "These two operators are used to change a word's contribution to the relevance value that is assigned to a row",
// "Parentheses are used to group words into subexpressions" => "Parentheses are used to group words into subexpressions",
// "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator" => "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator",
// "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended" => "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended",
// "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed" => "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed",
// "Advanced search" => "Advanced search",
// "Advanced Search Help" => "Advanced Search Help",
// "Page Relations" => "Page Relations",
// "Are you sure you want to delete this shout" => "Are you sure you want to delete this shout",
// "Shout date" => "Shout date",
// "Delete this shout" => "Delete this shout",
// "Edit this shout" => "Edit this shout",
// "New Tracker Items" => "New Tracker Items",
// "New Calendar Events" => "New Calendar Events",
// "Nothing has changed" => "Nothing has changed",
// "`\$module_params.prefix`" => "`\$module_params.prefix`",
// "Site Language" => "Site Language",
// "Site default" => "Site default",
// "Find term" => "Find term",
// "If not found, you will be given a chance to create it" => "If not found, you will be given a chance to create it",
// "TikiTests Menu" => "TikiTests Menu",
// "List Tests" => "List Tests",
// "Create Test" => "Create Test",
// "There are no translations of this page" => "There are no translations of this page",
// "Up-to-date-ness" => "Up-to-date-ness",
// "Better translations" => "Better translations",
// "update from it" => "update from it",
// "None match your" => "None match your",
// "Set your preferred languages" => "Set your preferred languages",
// "preferred languages" => "preferred languages",
// "Equivalent translations" => "Equivalent translations",
// "Translations that need improvement" => "Translations that need improvement",
// "update it" => "update it",
// "Group information" => "Group information",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "Webmail inbox" => "Webmail inbox",
// "Refresh (non-ajax)" => "Refresh (non-ajax)",
// "TAKE" => "TAKE",
// "View contact" => "View contact",
// "on host" => "on host",
// "User does not accept messages" => "User does not accept messages",
// "More Videos" => "More Videos",
// "Changes that need to be reproduced are highlighted below" => "Changes that need to be reproduced are highlighted below",
// "[-]" => "[-]",
// "Use Ctrl+Click to select multiple options" => "Use Ctrl+Click to select multiple options",
// "Requires" => "Requires",
// "You need to set" => "You need to set",
// "Insert/Edit an internal wiki link" => "Insert/Edit an internal wiki link",
// "Wiki Link insert" => "Wiki Link insert",
// "Please make a selection of text in order to create a link" => "Please make a selection of text in order to create a link",
// "Insert an image" => "Insert an image",
// "Tiki Image - Insert an image" => "Tiki Image - Insert an image",
// "Switch to normal (wiki) editor" => "Switch to normal (wiki) editor",
// "By" => "By",
// "Read more" => "Read more",
// "Do not group by item" => "Do not group by item",
// "Group by item" => "Group by item",
// "Calendar View" => "Calendar View",
// "Tiki Action Calendar" => "Tiki Action Calendar",
// "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones" => "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones",
// "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users" => "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users",
// "Global site configuration, date formats, admin password etc" => "Global site configuration, date formats, admin password etc",
// "Switches for major features" => "Switches for major features",
// "User resistration, remember me cookie settings and authentication methods" => "User resistration, remember me cookie settings and authentication methods",
// "User specific features and settings" => "User specific features and settings",
// "Profiles" => "Profiles",
// "Repository configuration, browse and apply profiles" => "Repository configuration, browse and apply profiles",
// "Look & Feel" => "Look & Feel",
// "Theme selection, layout settings and UI effect controls" => "Theme selection, layout settings and UI effect controls",
// "Internationalization and localization - mulitlingual features" => "Internationalization and localization - mulitlingual features",
// "Editing and Plugins" => "Editing and Plugins",
// "Text editing settings applicable to many areas. Plugin activation and plugin alias management" => "Text editing settings applicable to many areas. Plugin activation and plugin alias management",
// "Module appearance settings" => "Module appearance settings",
// "Information to include in the header of each page" => "Information to include in the header of each page",
// "Performance" => "Performance",
// "Server performance settings" => "Server performance settings",
// "Site security settings" => "Site security settings",
// "Feeds" => "Feeds",
// "Web feeds" => "Web feeds",
// "Connect" => "Connect",
// "Wiki page settings and features" => "Wiki page settings and features",
// "Defaults and configuration for file galleries" => "Defaults and configuration for file galleries",
// "Settings for blogs" => "Settings for blogs",
// "Defaults and configuration for image galleries (will be phased out in favour of file galleries)" => "Defaults and configuration for image galleries (will be phased out in favour of file galleries)",
// "Settings and features for articles" => "Settings and features for articles",
// "Settings and features for forums" => "Settings and features for forums",
// "Settings and features for trackers" => "Settings and features for trackers",
// "Settings and features for polls" => "Settings and features for polls",
// "Settings and features for calendars" => "Settings and features for calendars",
// "Settings and features for categories" => "Settings and features for categories",
// "Values of actions for users rank score" => "Values of actions for users rank score",
// "Settings and features for freetags" => "Settings and features for freetags",
// "Search configuration" => "Search configuration",
// "Settings and features for FAQs" => "Settings and features for FAQs",
// "Settings and features for directory of links" => "Settings and features for directory of links",
// "Settings and features for maps" => "Settings and features for maps",
// "Defaults and API key for Google Maps" => "Defaults and API key for Google Maps",
// "?" => "?",
// "Site-wide copyright information" => "Site-wide copyright information",
// "Message settings" => "Message settings",
// "User files settings" => "User files settings",
// "Webmail settings" => "Webmail settings",
// "Options for WYSIWYG editor" => "Options for WYSIWYG editor",
// "Set up links between Tiki servers" => "Set up links between Tiki servers",
// "Manage semantic wiki links" => "Manage semantic wiki links",
// "Webservices" => "Webservices",
// "Register and manage web services" => "Register and manage web services",
// "Sef URL" => "Sef URL",
// "Search Engine Friendly URLs" => "Search Engine Friendly URLs",
// "Kaltura video configuration" => "Kaltura video configuration",
// "To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or" => "To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or",
// "Create a blog" => "Create a blog",
// "Requires a separate download" => "Requires a separate download",
// "Force and limit categorization to within subtree of" => "Force and limit categorization to within subtree of",
// "Blogs Listings" => "Blogs Listings",
// "Select which items to display when listing blogs" => "Select which items to display when listing blogs",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "General settings" => "General settings",
// "Default calendars to display" => "Default calendars to display",
// "All calendars" => "All calendars",
// "A subset of available calendars" => "A subset of available calendars",
// "Create calendar" => "Create calendar",
// "Default view mode" => "Default view mode",
// "Week" => "Week",
// "Month" => "Month",
// "Quarter" => "Quarter",
// "Semester" => "Semester",
// "View list begins" => "View list begins",
// "Focus Date" => "Focus Date",
// "Period beginning" => "Period beginning",
// "First day of the week" => "First day of the week",
// "Depends user language" => "Depends user language",
// "Split hours in periods of" => "Split hours in periods of",
// "1 minute" => "1 minute",
// "10 minutes" => "10 minutes",
// "15 minutes" => "15 minutes",
// "30 minutes" => "30 minutes",
// "Manual selection of time/date" => "Manual selection of time/date",
// "JS calendar" => "JS calendar",
// "Year selection is valid when the JS Calendar <strong>is not</strong> enabled" => "Year selection is valid when the JS Calendar <strong>is not</strong> enabled",
// "First year in the dropdown" => "First year in the dropdown",
// "Enter a year or use +/- N to specify a year relative to the current\n\tyear" => "Enter a year or use +/- N to specify a year relative to the current\n\tyear",
// "Last year in the dropdown" => "Last year in the dropdown",
// "Sticky popup" => "Sticky popup",
// "Item view tab" => "Item view tab",
// "Browse categories" => "Browse categories",
// "Administer categories" => "Administer categories",
// "Separate category IDs with a comma (,)" => "Separate category IDs with a comma (,)",
// "Will improve performance, but may show forbidden results" => "Will improve performance, but may show forbidden results",
// "Look under \"Articles\" on the application menu for links to" => "Look under \"Articles\" on the application menu for links to",
// "Admin topics" => "Admin topics",
// "Admin types" => "Admin types",
// "Title of articles home page" => "Title of articles home page",
// "Article properties" => "Article properties",
// "Give only one value (width or height) to keep the image proportions" => "Give only one value (width or height) to keep the image proportions",
// "Batch upload (CSV file)" => "Batch upload (CSV file)",
// "File format: title,authorName,heading,body,lang,user" => "File format: title,authorName,heading,body,lang,user",
// "Articles Listing" => "Articles Listing",
// "Select which items to display when listing articles" => "Select which items to display when listing articles",
// "User features" => "User features",
// "Highlight group" => "Highlight group",
// "Use the format: trackerId, fieldId1, fieldId2, .." => "Use the format: trackerId, fieldId1, fieldId2, ..",
// "Users can choose to show their gender" => "Users can choose to show their gender",
// "Requires User Preferences feature" => "Requires User Preferences feature",
// "Show user's information on mouseover" => "Show user's information on mouseover",
// "Requires user's information to be public" => "Requires user's information to be public",
// "Real name" => "Real name",
// "Feature is disabled" => "Feature is disabled",
// "Enable now" => "Enable now",
// "Default user preferences" => "Default user preferences",
// "Users Default Preferences" => "Users Default Preferences",
// "Character set for mail" => "Character set for mail",
// "default" => "default",
// "Detect user timezone if browser allows, otherwise site default" => "Detect user timezone if browser allows, otherwise site default",
// "User messages" => "User messages",
// "Notify sender when reading mail" => "Notify sender when reading mail",
// "My forum topics" => "My forum topics",
// "My forum replies" => "My forum replies",
// "Select which items to display when listing users" => "Select which items to display when listing users",
// "Score ascending" => "Score ascending",
// "Score descending" => "Score descending",
// "Name ascending" => "Name ascending",
// "Name descending" => "Name descending",
// "Login ascending" => "Login ascending",
// "Login descending" => "Login descending",
// "TikiWiki CMS/Groupware is Free and Open Source Software (FOSS). It is a community-driven project which exists and improves thanks to the participation of people just like YOU" => "TikiWiki CMS/Groupware is Free and Open Source Software (FOSS). It is a community-driven project which exists and improves thanks to the participation of people just like YOU",
// "Join the community" => "Join the community",
// "Promote your site" => "Promote your site",
// "To submit your site to TikiWiki.org" => "To submit your site to TikiWiki.org",
// "Submit site" => "Submit site",
// "Help Tiki spread" => "Help Tiki spread",
// "Help improve Tiki" => "Help improve Tiki",
// "To submit a feature request or to report a bug" => "To submit a feature request or to report a bug",
// "Click here to go to our development site" => "Click here to go to our development site",
// "Copyright allows to determine a copyright for all the objects of tikiwiki" => "Copyright allows to determine a copyright for all the objects of tikiwiki",
// "Enable copyright management for" => "Enable copyright management for",
// "To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or" => "To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or",
// "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site",
// "Global features" => "Global features",
// "Main feature" => "Main feature",
// "Additional" => "Additional",
// "Programmer" => "Programmer",
// "These features are relatively new, or recently underwent major renovations. You should expect growing pains and possibly a lack of up to date documentation, as you would of a version 1.0 application" => "These features are relatively new, or recently underwent major renovations. You should expect growing pains and possibly a lack of up to date documentation, as you would of a version 1.0 application",
// "Experimental" => "Experimental",
// "Will be phased out" => "Will be phased out",
// "These features generally work but will probably be phased out in the future, because they are superseded by other features or because of evolution in Web technology" => "These features generally work but will probably be phased out in the future, because they are superseded by other features or because of evolution in Web technology",
// "Seem ok but.." => "Seem ok but..",
// "These features are not reported to be broken, but they are not actively developed and/or widely used" => "These features are not reported to be broken, but they are not actively developed and/or widely used",
// "Need polish" => "Need polish",
// "These features are generally known to have issues, and/or need admin help and/or user patience to work" => "These features are generally known to have issues, and/or need admin help and/or user patience to work",
// "Feedbacks" => "Feedbacks",
// "To create or remove file galleries, select" => "To create or remove file galleries, select",
// "from the application menu" => "from the application menu",
// "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory" => "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory",
// "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>",
// "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/",
// "Create a Gallery" => "Create a Gallery",
// "Move files from database to directory" => "Move files from database to directory",
// "Move files from directory to database" => "Move files from directory to database",
// "Store in database" => "Store in database",
// "Store in directory" => "Store in directory",
// "Score is disabled" => "Score is disabled",
// "Upload Regex" => "Upload Regex",
// "Gallery Listings" => "Gallery Listings",
// "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries" => "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries",
// "Select which items to display when listing galleries: " => "Select which items to display when listing galleries: ",
// "Search Indexing" => "Search Indexing",
// "Automatically index files on upload or change" => "Automatically index files on upload or change",
// "Handlers" => "Handlers",
// "Add custom handlers to make your files &quot;searchable&quot; content" => "Add custom handlers to make your files &quot;searchable&quot; content",
// "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command" => "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command",
// "To delete a handler, leave the <strong>System Command</strong> field blank" => "To delete a handler, leave the <strong>System Command</strong> field blank",
// "System Command" => "System Command",
// "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or",
// "Create a forum" => "Create a forum",
// "If disabled, replies will quote the original post" => "If disabled, replies will quote the original post",
// "Will be a thread title" => "Will be a thread title",
// "Threads" => "Threads",
// "Allows users to override the defaults" => "Allows users to override the defaults",
// "When listing forums" => "When listing forums",
// "Forums Listing" => "Forums Listing",
// "Select which items to display when listing forums" => "Select which items to display when listing forums",
// "Show tag cloud" => "Show tag cloud",
// "Maximum number of tags in cloud" => "Maximum number of tags in cloud",
// "Show freetags in middle column" => "Show freetags in middle column",
// "Preload freetag random tag" => "Preload freetag random tag",
// "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>" => "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>",
// "Random tag cloud colors" => "Random tag cloud colors",
// "Separate colors with a comma (,)" => "Separate colors with a comma (,)",
// "Number of Tags to show in Tag Suggestions" => "Number of Tags to show in Tag Suggestions",
// "Valid characters pattern" => "Valid characters pattern",
// "Alphanumeric ASCII characters only" => "Alphanumeric ASCII characters only",
// "No accents or special characters" => "No accents or special characters",
// "Accept all charactrs" => "Accept all charactrs",
// "Lowercase tags only" => "Lowercase tags only",
// "&quot;More Like This&quot; algorithm" => "&quot;More Like This&quot; algorithm",
// "basic" => "basic",
// "weighted" => "weighted",
// "Minimum amount of tags in common" => "Minimum amount of tags in common",
// "Tag Management" => "Tag Management",
// "Cleanup unused tags" => "Cleanup unused tags",
// "3D Tag Browser" => "3D Tag Browser",
// "Morcego 3D browser disabled" => "Morcego 3D browser disabled",
// "Enable freetags 3D browser" => "Enable freetags 3D browser",
// "Graph appearance" => "Graph appearance",
// "Node color" => "Node color",
// "Camera settinsg" => "Camera settinsg",
// "Physics engine" => "Physics engine",
// "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or",
// "You can upload images of a size of " => "You can upload images of a size of ",
// "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value",
// "No Gallery exists" => "No Gallery exists",
// "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below" => "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols",
// "Display image informations in a mouseover box" => "Display image informations in a mouseover box",
// "yes, and don't display those informations under the image" => "yes, and don't display those informations under the image",
// "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)",
// "Pixels Default" => "Pixels Default",
// "Default scale size" => "Default scale size",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Release Check" => "Release Check",
// "Reset or upgrade your database" => "Reset or upgrade your database",
// "Check for updates now" => "Check for updates now",
// "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look & Feel</strong></a> section for additional site related customization preferences" => "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look & Feel</strong></a> section for additional site related customization preferences",
// "Mail" => "Mail",
// "Mail Sender" => "Mail Sender",
// "Sendmail" => "Sendmail",
// "SMTP" => "SMTP",
// "SMTP Server" => "SMTP Server",
// "Authentication" => "Authentication",
// "These values will be stored in plain text in the database" => "These values will be stored in plain text in the database",
// "Logging and Reporting" => "Logging and Reporting",
// "Visible to admin only" => "Visible to admin only",
// "Include Smarty notices" => "Include Smarty notices",
// "Spam protection" => "Spam protection",
// "MultiDomain" => "MultiDomain",
// "Session" => "Session",
// "Advanced configuration warning" => "Advanced configuration warning",
// "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects" => "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects",
// "Changing this feature will immediately log you out when you save this preference" => "Changing this feature will immediately log you out when you save this preference",
// "Miscellaneous" => "Miscellaneous",
// "Use TikiWiki feature as homepage" => "Use TikiWiki feature as homepage",
// "Use different URL as home page" => "Use different URL as home page",
// "Redirects" => "Redirects",
// "If a requested page doesn't exist, redirect to a similarly named page" => "If a requested page doesn't exist, redirect to a similarly named page",
// "On permission denied, display login module (for Anonymous)" => "On permission denied, display login module (for Anonymous)",
// "Send to URL" => "Send to URL",
// "Site Access" => "Site Access",
// "Default timezone" => "Default timezone",
// "Use site default to show times" => "Use site default to show times",
// "Detect user timezone (if browser allows). Otherwise use site default" => "Detect user timezone (if browser allows). Otherwise use site default",
// "Sample" => "Sample",
// "Fields display order" => "Fields display order",
// "Change the <strong>Admin</strong> password" => "Change the <strong>Admin</strong> password",
// "Minimum {\$prefs.min_pass_length} characters long" => "Minimum {\$prefs.min_pass_length} characters long",
// "To use Google Maps, you must generate a Google Maps API Key for your web site. See <a href=\"http://www.google.com/apis/maps/signup.html\">http://www.google.com/apis/maps/signup.html</a> for details" => "To use Google Maps, you must generate a Google Maps API Key for your web site. See <a href=\"http://www.google.com/apis/maps/signup.html\">http://www.google.com/apis/maps/signup.html</a> for details",
// "Google Maps API Key" => "Google Maps API Key",
// "Defaults" => "Defaults",
// "Edit or export/import Languages" => "Edit or export/import Languages",
// "Babelfish links" => "Babelfish links",
// "Customized String Translation" => "Customized String Translation",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "Intertiki shared cookie for sliding auth under same domain" => "Intertiki shared cookie for sliding auth under same domain",
// "InterTiki Server" => "InterTiki Server",
// "Known hosts" => "Known hosts",
// "Kaltura Registration" => "Kaltura Registration",
// "If you don't have a Kaltura Partner Id, " => "If you don't have a Kaltura Partner Id, ",
// "to register" => "to register",
// "Kaltura Partner Settings" => "Kaltura Partner Settings",
// "Partner Id" => "Partner Id",
// "User Secret" => "User Secret",
// "Admin Secret" => "Admin Secret",
// "Kaltura Dynamic Player" => "Kaltura Dynamic Player",
// "KDP UI Configuration Id" => "KDP UI Configuration Id",
// "KDP Widget Id" => "KDP Widget Id",
// "Kaltura Contribution Wizard" => "Kaltura Contribution Wizard",
// "KCW UI Configuration Id" => "KCW UI Configuration Id",
// "Kaltura Remix Editors" => "Kaltura Remix Editors",
// "Kaltura Simple Editor UI Configuration Id" => "Kaltura Simple Editor UI Configuration Id",
// "Kaltura Advance Editor UI Configuration Id" => "Kaltura Advance Editor UI Configuration Id",
// "Enable/disable Tiki features in " => "Enable/disable Tiki features in ",
// ", but configure them elsewhere" => ", but configure them elsewhere",
// "Wysiwyg" => "Wysiwyg",
// "Validate by email" => "Validate by email",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>",
// "Validate user's email server" => "Validate user's email server",
// "Require validation by Admin" => "Require validation by Admin",
// "Validator emails (separated by comma) if different than the sender email" => "Validator emails (separated by comma) if different than the sender email",
// "Require passcode to register" => "Require passcode to register",
// "Passcode" => "Passcode",
// "Users must enter this code to register" => "Users must enter this code to register",
// "Use CAPTCHA to prevent automatic/robot registrations" => "Use CAPTCHA to prevent automatic/robot registrations",
// "Requires PHP GD library" => "Requires PHP GD library",
// "Include &quot;Generate Password&quot; option on registration form" => "Include &quot;Generate Password&quot; option on registration form",
// "Users can select a group to join at registration" => "Users can select a group to join at registration",
// "By default, new users automatically join the Registered group" => "By default, new users automatically join the Registered group",
// "Url a user is redirected after account validation" => "Url a user is redirected after account validation",
// "Account validated successfully" => "Account validated successfully",
// "Use tracker to collect more user information" => "Use tracker to collect more user information",
// "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display" => "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display",
// "Use tracker to collect more group information" => "Use tracker to collect more group information",
// "Re-validate user by email after" => "Re-validate user by email after",
// "Use <strong>-1</strong> for never" => "Use <strong>-1</strong> for never",
// "unsuccessful login attempts" => "unsuccessful login attempts",
// "Create a new group for each user" => "Create a new group for each user",
// "The group will be named identical to the user's username" => "The group will be named identical to the user's username",
// "Disable browser's autocomplete feature for username and password fields" => "Disable browser's autocomplete feature for username and password fields",
// "Confirm that the Admin account has a valid email address or you will not be permitted to login" => "Confirm that the Admin account has a valid email address or you will not be permitted to login",
// "Use HTTPS login" => "Use HTTPS login",
// "Encourage secure (https) login" => "Encourage secure (https) login",
// "Consider we are always in HTTPS, but do not check" => "Consider we are always in HTTPS, but do not check",
// "Users can choose to stay in SSL mode after an HTTPS login" => "Users can choose to stay in SSL mode after an HTTPS login",
// "Users can switch between secured or standard mode at login" => "Users can switch between secured or standard mode at login",
// "User's choice" => "User's choice",
// "Cookie name" => "Cookie name",
// "Use email as username" => "Use email as username",
// "Minimum length" => "Minimum length",
// "Force lowercase" => "Force lowercase",
// "Username pattern" => "Username pattern",
// "Store passwords in plain text is activated. You should never set this unless you know what you are doing" => "Store passwords in plain text is activated. You should never set this unless you know what you are doing",
// "Users can change their password" => "Users can change their password",
// "Require characters and numerals" => "Require characters and numerals",
// "Password expires after" => "Password expires after",
// "You must change the Authentication Method to LDAP for these changes to take effect" => "You must change the Authentication Method to LDAP for these changes to take effect",
// "Create user if not in Tiki" => "Create user if not in Tiki",
// "Create user if not in LDAP" => "Create user if not in LDAP",
// "Use Tiki authentication for Admin login" => "Use Tiki authentication for Admin login",
// "Use Tiki authentication for users created in tiki" => "Use Tiki authentication for users created in tiki",
// "LDAP Bind settings" => "LDAP Bind settings",
// "Will override the Host and Port settings" => "Will override the Host and Port settings",
// "Write LDAP debug Information in Tiki Logs" => "Write LDAP debug Information in Tiki Logs",
// "Use SSL (ldaps)" => "Use SSL (ldaps)",
// "Use TLS" => "Use TLS",
// "LDAP Bind Type" => "LDAP Bind Type",
// "Default: userattr=username,UserDN,BaseDN" => "Default: userattr=username,UserDN,BaseDN",
// "userattr=username,BaseDN" => "userattr=username,BaseDN",
// "Active Directory (username@domain)" => "Active Directory (username@domain)",
// "Plain Username" => "Plain Username",
// "Search scope" => "Search scope",
// "Subtree" => "Subtree",
// "One level" => "One level",
// "Base object" => "Base object",
// "LDAP version" => "LDAP version",
// "Base DN" => "Base DN",
// "LDAP User" => "LDAP User",
// "User DN" => "User DN",
// "User attribute" => "User attribute",
// "User OC" => "User OC",
// "Realname attribute" => "Realname attribute",
// "Country attribute" => "Country attribute",
// "E-mail attribute" => "E-mail attribute",
// "Synchronize user attributes to tiki everytime the user logs in" => "Synchronize user attributes to tiki everytime the user logs in",
// "LDAP Group" => "LDAP Group",
// "Synchronize group attributes to tiki everytime the user logs in" => "Synchronize group attributes to tiki everytime the user logs in",
// "Note: this enables the usage of LDAP groups" => "Note: this enables the usage of LDAP groups",
// "Group DN" => "Group DN",
// "Group attribute" => "Group attribute",
// "Group description attribute" => "Group description attribute",
// "Group OC" => "Group OC",
// "LDAP Group Member - if group membership can be found in group attributes" => "LDAP Group Member - if group membership can be found in group attributes",
// "Member attribute" => "Member attribute",
// "Member is DN" => "Member is DN",
// "LDAP User Group - if group membership can be found in user attributes" => "LDAP User Group - if group membership can be found in user attributes",
// "Group attribute in group entry" => "Group attribute in group entry",
// "LDAP Admin" => "LDAP Admin",
// "Admin user" => "Admin user",
// "Admin password" => "Admin password",
// "You must change the Authentication Method to PAM for these changes to take effect" => "You must change the Authentication Method to PAM for these changes to take effect",
// "Shibboleth Authentication " => "Shibboleth Authentication ",
// "You must change the Authentication Method to Shibboleth for these changes to take effect" => "You must change the Authentication Method to Shibboleth for these changes to take effect",
// "Valid affiliations" => "Valid affiliations",
// "Separate multiple affiliations with commas" => "Separate multiple affiliations with commas",
// "Create with default group" => "Create with default group",
// "CAS" => "CAS",
// "You must change the Authentication Method to CAS for these changes to take effect" => "You must change the Authentication Method to CAS for these changes to take effect",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/" => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/",
// "CAS Server" => "CAS Server",
// "Hostname" => "Hostname",
// "You must enable PHP CAS first" => "You must enable PHP CAS first",
// "Themes" => "Themes",
// "Theme options" => "Theme options",
// "The \"users can change theme\" feature will override the theme displayed" => "The \"users can change theme\" feature will override the theme displayed",
// "Theme not saved yet - click \"Apply\"" => "Theme not saved yet - click \"Apply\"",
// "Theme Screenshot" => "Theme Screenshot",
// "Each group can have its theme" => "Each group can have its theme",
// "Slideshow theme" => "Slideshow theme",
// "View Templates" => "View Templates",
// "Custom HTML &lt;head&gt; Content" => "Custom HTML &lt;head&gt; Content",
// "Custom Site Header" => "Custom Site Header",
// "The Custom Site Header will display for the Admin only. Select <strong>Publish</strong> to display the content for </em>all<em> users" => "The Custom Site Header will display for the Admin only. Select <strong>Publish</strong> to display the content for </em>all<em> users",
// "Site Logo and Title" => "Site Logo and Title",
// "Logo source (image path)" => "Logo source (image path)",
// "Logo background color" => "Logo background color",
// "Examples" => "Examples",
// "Logo background style" => "Logo background style",
// "Logo alignment" => "Logo alignment",
// "Logo title (on mouse over)" => "Logo title (on mouse over)",
// "Site title" => "Site title",
// "Search Bar" => "Search Bar",
// "Login Bar" => "Login Bar",
// "Top Bar" => "Top Bar",
// "Requires CSS Menus or PHPLayers" => "Requires CSS Menus or PHPLayers",
// "Menu ID" => "Menu ID",
// "Display current Tiki version" => "Display current Tiki version",
// "Custom Center Column Header" => "Custom Center Column Header",
// "only if module" => "only if module",
// "Users can Flip Columns" => "Users can Flip Columns",
// "Prefix breadcrumbs with &quot;Location : &quot" => "Prefix breadcrumbs with &quot;Location : &quot",
// "Top of page" => "Top of page",
// "Top of center column" => "Top of center column",
// "Entire location" => "Entire location",
// "Custom Site Footer" => "Custom Site Footer",
// "Custom End of &lt;body&gt; Code" => "Custom End of &lt;body&gt; Code",
// "Bottom bar (RSS)" => "Bottom bar (RSS)",
// "Site Report Bar" => "Site Report Bar",
// "Webmaster Report" => "Webmaster Report",
// "Webmaster Email" => "Webmaster Email",
// "Leave <strong>blank</strong> to use the default sender email" => "Leave <strong>blank</strong> to use the default sender email",
// "Email this page" => "Email this page",
// "Shadow layer" => "Shadow layer",
// "Additional layers for shadows, rounded corners or other decorative styling" => "Additional layers for shadows, rounded corners or other decorative styling",
// "Main shadow start" => "Main shadow start",
// "Main shadow end" => "Main shadow end",
// "Header shadow start" => "Header shadow start",
// "Header shadow end" => "Header shadow end",
// "Middle shadow start" => "Middle shadow start",
// "Middle shadow end" => "Middle shadow end",
// "Center shadow start" => "Center shadow start",
// "Center shadow end" => "Center shadow end",
// "Footer shadow start" => "Footer shadow start",
// "Footer shadow end" => "Footer shadow end",
// "Module (box) shadow start" => "Module (box) shadow start",
// "Module (box) shadow end" => "Module (box) shadow end",
// "Pagination links" => "Pagination links",
// "Use relative (next / previous) pagination links" => "Use relative (next / previous) pagination links",
// "Max. number of links around the current item" => "Max. number of links around the current item",
// "Max. number of links after the first or before the last item" => "Max. number of links after the first or before the last item",
// "Display 'First' and 'Last' links" => "Display 'First' and 'Last' links",
// "Display fast move links (by 10 percent of the total number of pages) " => "Display fast move links (by 10 percent of the total number of pages) ",
// "Hide pagination when there is only one page" => "Hide pagination when there is only one page",
// "Use Icons" => "Use Icons",
// "UI Effects" => "UI Effects",
// "JQuery plugins and add-ons" => "JQuery plugins and add-ons",
// "Requires jquery feature" => "Requires jquery feature",
// "Tooltips" => "Tooltips",
// "JQuery Tooltips: Customisable help tips" => "JQuery Tooltips: Customisable help tips",
// "Autocomplete" => "Autocomplete",
// "JQuery Autocomplete" => "JQuery Autocomplete",
// "Superfish" => "Superfish",
// "JQuery Superfish (effects on CSS menus)" => "JQuery Superfish (effects on CSS menus)",
// "Reflection" => "Reflection",
// "JQuery Reflection (reflection effect on images)" => "JQuery Reflection (reflection effect on images)",
// "JQuery UI" => "JQuery UI",
// "JQuery UI: More JQuery functionality" => "JQuery UI: More JQuery functionality",
// "JQuery UI Theme" => "JQuery UI Theme",
// "JQuery UI Theme: Themes for look and feel of JQuery UI widgets" => "JQuery UI Theme: Themes for look and feel of JQuery UI widgets",
// "For future use" => "For future use",
// "Cycle" => "Cycle",
// "slideshow" => "slideshow",
// "JQuery Cycle (slideshow)" => "JQuery Cycle (slideshow)",
// "JQuery Sheet" => "JQuery Sheet",
// "JQuery Spreadsheet" => "JQuery Spreadsheet",
// "JQuery Sortable Tables" => "JQuery Sortable Tables",
// "Standard UI effects" => "Standard UI effects",
// "Effect for modules" => "Effect for modules",
// "Slide" => "Slide",
// "Blind (UI)" => "Blind (UI)",
// "Clip (UI)" => "Clip (UI)",
// "Drop (UI)" => "Drop (UI)",
// "Explode (UI)" => "Explode (UI)",
// "Fold (UI)" => "Fold (UI)",
// "Puff (UI)" => "Puff (UI)",
// "Slide (UI)" => "Slide (UI)",
// "Main JQuery effect" => "Main JQuery effect",
// "Speed" => "Speed",
// "Fast" => "Fast",
// "Slow" => "Slow",
// "Vertical" => "Vertical",
// "Horizontal" => "Horizontal",
// "Tab UI effects" => "Tab UI effects",
// "Effect for tabs" => "Effect for tabs",
// "JQuery effect for tabs" => "JQuery effect for tabs",
// "Correct PNG images alpha transparency in IE6 (experimental)" => "Correct PNG images alpha transparency in IE6 (experimental)",
// "CSS selectors to be fixed" => "CSS selectors to be fixed",
// "Separate multiple elements with a comma (&nbsp;,&nbsp;)" => "Separate multiple elements with a comma (&nbsp;,&nbsp;)",
// "HTMLDomElements to be fixed" => "HTMLDomElements to be fixed",
// "Favicon" => "Favicon",
// "image/png" => "image/png",
// "image/bmp" => "image/bmp",
// "image/x-icon" => "image/x-icon",
// "Context Menus" => "Context Menus",
// "Currently used in File Galleries only" => "Currently used in File Galleries only",
// "Use context menus for actions (icons)" => "Use context menus for actions (icons)",
// "Use context menus for actions (text)" => "Use context menus for actions (text)",
// "Separators" => "Separators",
// "Meta tags" => "Meta tags",
// "Geo URL" => "Geo URL",
// "&quot;Modules&quot; are the boxes of content in the right &amp; left columns" => "&quot;Modules&quot; are the boxes of content in the right &amp; left columns",
// "Admin &gt; Modules" => "Admin &gt; Modules",
// "from the menu to create and edit modules" => "from the menu to create and edit modules",
// "Hint: If you lose your login module, use tiki-login_scr.php to be able to login" => "Hint: If you lose your login module, use tiki-login_scr.php to be able to login",
// "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item" => "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item",
// "Save Preferences" => "Save Preferences",
// "ProgressBarPlay Color" => "ProgressBarPlay Color",
// "ProgressBarLoad Color" => "ProgressBarLoad Color",
// "ProgressBarButton Color" => "ProgressBarButton Color",
// "ProgressBar Color" => "ProgressBar Color",
// "Volume On Color" => "Volume On Color",
// "Volume Off Color" => "Volume Off Color",
// "Volume Button Color" => "Volume Button Color",
// "Button Color" => "Button Color",
// "Button Pressed Color" => "Button Pressed Color",
// "Button Over Color" => "Button Over Color",
// "Button Info Color" => "Button Info Color",
// "Button Info Pressed Color" => "Button Info Pressed Color",
// "Button Info Over Color" => "Button Info Over Color",
// "Button Info Text Color" => "Button Info Text Color",
// "ID3 Tag Color" => "ID3 Tag Color",
// "Play Time Color" => "Play Time Color",
// "Total Time Color" => "Total Time Color",
// "Panel Display Color" => "Panel Display Color",
// "Alert Message Color" => "Alert Message Color",
// "Flash Length" => "Flash Length",
// "Flash Heigth" => "Flash Heigth",
// "Video Length" => "Video Length",
// "Video Heigth" => "Video Heigth",
// "Preload Delay" => "Preload Delay",
// "Max Play time" => "Max Play time",
// "URL Append" => "URL Append",
// "Message after limited time" => "Message after limited time",
// "ID of System File Galleries to upload multimedia files" => "ID of System File Galleries to upload multimedia files",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Performance'>Performance page</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Performance'>Performance page</a> on Tiki's developer site",
// "Output compression is active" => "Output compression is active",
// "Compression is handled by" => "Compression is handled by",
// "Many search options impact performance. Please see <a href=\"tiki-admin.php?page=search\">Search admin panel</a>" => "Many search options impact performance. Please see <a href=\"tiki-admin.php?page=search\">Search admin panel</a>",
// "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or",
// "Loading profile" => "Loading profile",
// "Are you sure you want to apply the profile" => "Are you sure you want to apply the profile",
// "Sending" => "Sending",
// "TikiWiki Profiles" => "TikiWiki Profiles",
// "The following list of changes has been applied" => "The following list of changes has been applied",
// "Apply Profiles" => "Apply Profiles",
// "A Friendly Warning" => "A Friendly Warning",
// "Some of your Profiles Repositories are not connecting. This may prevent you from applying certain profiles" => "Some of your Profiles Repositories are not connecting. This may prevent you from applying certain profiles",
// "Option 1: Quick Filter" => "Option 1: Quick Filter",
// "Option 2: Manual Filter" => "Option 2: Manual Filter",
// "Filter the list of profiles" => "Filter the list of profiles",
// "Profile" => "Profile",
// "Repository" => "Repository",
// "applied" => "applied",
// "Profile repository" => "Profile repository",
// "Javascript must be turned <b>ON</b> in order to apply Profiles. Please enable your javascript and try again" => "Javascript must be turned <b>ON</b> in order to apply Profiles. Please enable your javascript and try again",
// "Repositories" => "Repositories",
// "Repository URLs" => "Repository URLs",
// "Enter multiple repository URLs, one per line" => "Enter multiple repository URLs, one per line",
// "Data Channels" => "Data Channels",
// "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. " => "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. ",
// "More information" => "More information",
// "Profile tester" => "Profile tester",
// "This will run the profile and make potentially unrecoverable changes in your database" => "This will run the profile and make potentially unrecoverable changes in your database",
// "Test Profile Name" => "Test Profile Name",
// "Use this page to configure the feeds generated by Tiki. To syndicate feeds from other sites, use the <strong>Admin</strong> &gt; <strong>External Feeds</strong> menu option, or" => "Use this page to configure the feeds generated by Tiki. To syndicate feeds from other sites, use the <strong>Admin</strong> &gt; <strong>External Feeds</strong> menu option, or",
// "External feeds" => "External feeds",
// "Feed for articles" => "Feed for articles",
// "Maximum number of items to display" => "Maximum number of items to display",
// "Show Author" => "Show Author",
// "Homepage URL" => "Homepage URL",
// "Feed for blogs" => "Feed for blogs",
// "Individual blogs" => "Individual blogs",
// "Feed for image galleries" => "Feed for image galleries",
// "Individual image galleries" => "Individual image galleries",
// "Feed for file galleries" => "Feed for file galleries",
// "Individual file galleries" => "Individual file galleries",
// "Feed for wiki" => "Feed for wiki",
// "Individual forums" => "Individual forums",
// "Individual trackers items" => "Individual trackers items",
// "Calendar events" => "Calendar events",
// "Feed for directory" => "Feed for directory",
// "Map files" => "Map files",
// "Feed for maps" => "Feed for maps",
// "Image Path" => "Image Path",
// "Caching time" => "Caching time",
// "Use <strong>0</strong> for no caching" => "Use <strong>0</strong> for no caching",
// "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public" => "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public",
// "You can see users rank by score in the module users_rank, for that go to" => "You can see users rank by score in the module users_rank, for that go to",
// "can be seen on page" => "can be seen on page",
// "in Admin menu" => "in Admin menu",
// "Search type" => "Search type",
// "This search uses the MySQL Full-Text feature" => "This search uses the MySQL Full-Text feature",
// "The indexation is always updated" => "The indexation is always updated",
// "Tiki search" => "Tiki search",
// "Specify the Tiki search settings" => "Specify the Tiki search settings",
// "Use <strong>0</strong> for no refresh" => "Use <strong>0</strong> for no refresh",
// "The Tiki search indexes must be refreshed if you turn the Tiki search on" => "The Tiki search indexes must be refreshed if you turn the Tiki search on",
// "Refresh all search index now" => "Refresh all search index now",
// "Refresh trackers search index now" => "Refresh trackers search index now",
// "Refresh tracker search index now" => "Refresh tracker search index now",
// "Refresh files search index now" => "Refresh files search index now",
// "May impact performance" => "May impact performance",
// "Enabling these options will improve performance, but may show forbidden results" => "Enabling these options will improve performance, but may show forbidden results",
// "Search Results" => "Search Results",
// "Select the items to display on the search results page" => "Select the items to display on the search results page",
// "Select the information to display for each result" => "Select the information to display for each result",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Security'>Security page</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Security'>Security page</a> on Tiki's developer site",
// "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings" => "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings",
// "CSRF Security" => "CSRF Security",
// "Use these options to protect against cross-site request forgeries (CSRF)" => "Use these options to protect against cross-site request forgeries (CSRF)",
// "SEFURL will not work unless Tiki specific directives are deployed to the .htaccess file. You will need to execute htaccess.sh or manually configure the .htaccess file" => "SEFURL will not work unless Tiki specific directives are deployed to the .htaccess file. You will need to execute htaccess.sh or manually configure the .htaccess file",
// "List of Url Parameters that should go in the path" => "List of Url Parameters that should go in the path",
// "Known Types" => "Known Types",
// "Token" => "Token",
// "Invert" => "Invert",
// "Show Usage" => "Show Usage",
// "Delete &amp; Unreference" => "Delete &amp; Unreference",
// "Invert Relation" => "Invert Relation",
// "Self" => "Self",
// "New Types" => "New Types",
// "Fix" => "Fix",
// "No occurences found" => "No occurences found",
// "Text area (that apply throughout many features)" => "Text area (that apply throughout many features)",
// "Wiki paragraph formatting" => "Wiki paragraph formatting",
// "...but still create line breaks within paragraphs" => "...but still create line breaks within paragraphs",
// "Parse wiki syntax in comments in all sections apart from Forums" => "Parse wiki syntax in comments in all sections apart from Forums",
// "&lt;return&gt; for rows" => "&lt;return&gt; for rows",
// "Open Hotwords in new window" => "Open Hotwords in new window",
// "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting",
// "Plugin disabled" => "Plugin disabled",
// "Default size" => "Default size",
// "Comments " => "Comments ",
// "Forum reply" => "Forum reply",
// "External links and images" => "External links and images",
// "External links will be identified with" => "External links will be identified with",
// "Plugins" => "Plugins",
// "About plugins" => "About plugins",
// "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below" => "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below",
// "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>" => "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>",
// "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below" => "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below",
// "Edit plugin icons" => "Edit plugin icons",
// "Enable" => "Enable",
// "Disable edit plugin icon (make plugin inline)" => "Disable edit plugin icon (make plugin inline)",
// "Plugin Aliases" => "Plugin Aliases",
// "About plugin aliases" => "About plugin aliases",
// "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}" => "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}",
// "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}" => "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}",
// "Available Alias" => "Available Alias",
// "Enable Plugins" => "Enable Plugins",
// "General Information" => "General Information",
// "Plugin Name" => "Plugin Name",
// "Base Plugin" => "Base Plugin",
// "Body Label" => "Body Label",
// "Dependencies" => "Dependencies",
// "Validation" => "Validation",
// "Inline (No Plugin Edit UI)" => "Inline (No Plugin Edit UI)",
// "Simple Plugin Arguments" => "Simple Plugin Arguments",
// "Argument" => "Argument",
// "New Argument" => "New Argument",
// "Plugin Parameter Documentation" => "Plugin Parameter Documentation",
// "Safe" => "Safe",
// "Plugin Body" => "Plugin Body",
// "Ignore User Input" => "Ignore User Input",
// "Default Content" => "Default Content",
// "Encoding" => "Encoding",
// "Argument Source (if different)" => "Argument Source (if different)",
// "Default Value" => "Default Value",
// "Composed Plugin Arguments" => "Composed Plugin Arguments",
// "Pattern" => "Pattern",
// "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or",
// "Tracker attachment preferences" => "Tracker attachment preferences",
// "Tracker attachments" => "Tracker attachments",
// "Switch storage" => "Switch storage",
// "No records" => "No records",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely",
// "Do not use this feature as it is very buggy and unmaintained. It will be pulled out of the code base later on" => "Do not use this feature as it is very buggy and unmaintained. It will be pulled out of the code base later on",
// "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used" => "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used",
// "Lookup" => "Lookup",
// "Test Input" => "Test Input",
// "Response Information" => "Response Information",
// "OIntegrate Version" => "OIntegrate Version",
// "Not supported" => "Not supported",
// "Schema Version" => "Schema Version",
// "Schema Documentation" => "Schema Documentation",
// "Available" => "Available",
// "Not specified, default used" => "Not specified, default used",
// "Content Type" => "Content Type",
// "Not specified" => "Not specified",
// "Returned Data" => "Returned Data",
// "Proposed Templates" => "Proposed Templates",
// "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters" => "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters",
// "Register Service" => "Register Service",
// "Registered Templates" => "Registered Templates",
// "Engine" => "Engine",
// "Output" => "Output",
// "Register Template" => "Register Template",
// "Use the 'Quick Edit' module to easily create or edit wiki pages" => "Use the 'Quick Edit' module to easily create or edit wiki pages",
// "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules" => "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules",
// "Page display" => "Page display",
// "Page ID" => "Page ID",
// "Page version" => "Page version",
// "Allow override per page" => "Allow override per page",
// "Edit section" => "Edit section",
// "Edit section level" => "Edit section level",
// "Toggle display of section and plugin edit icons" => "Toggle display of section and plugin edit icons",
// "Allow minor edits" => "Allow minor edits",
// "Minor edits do not flag new content for translation and do not send watch notifications" => "Minor edits do not flag new content for translation and do not send watch notifications",
// "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled" => "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled",
// "Log bytes changes (+/-) in action logs" => "Log bytes changes (+/-) in action logs",
// "Display by default" => "Display by default",
// "Manage attachments" => "Manage attachments",
// "Tag for current wiki" => "Tag for current wiki",
// "Restore wiki to tag" => "Restore wiki to tag",
// "Restore" => "Restore",
// "Remove a tag" => "Remove a tag",
// "Use File Galleries to store pictures " => "Use File Galleries to store pictures ",
// "WikiWords" => "WikiWords",
// "Maximum number of versions" => "Maximum number of versions",
// "Never delete versions younger than" => "Never delete versions younger than",
// "Display IP address" => "Display IP address",
// "Default diff style" => "Default diff style",
// "HTML diff" => "HTML diff",
// "Side-by-side diff by characters" => "Side-by-side diff by characters",
// "Inline diff" => "Inline diff",
// "Inline diff by characters" => "Inline diff by characters",
// "Full side-by-side diff by characters" => "Full side-by-side diff by characters",
// "Full inline diff" => "Full inline diff",
// "Full inline diff by characters" => "Full inline diff by characters",
// "History all instead of only page data, description, and change comment" => "History all instead of only page data, description, and change comment",
// "Forums are disabled" => "Forums are disabled",
// "Forum for discussion" => "Forum for discussion",
// "View source" => "View source",
// "Polls are disabled" => "Polls are disabled",
// "like pages" => "like pages",
// "Make structure from page" => "Make structure from page",
// "Categorize structure pages together" => "Categorize structure pages together",
// "Create webhelp from structure" => "Create webhelp from structure",
// "A page can occur multiple times in a structure" => "A page can occur multiple times in a structure",
// "Import pages" => "Import pages",
// "Slideshows" => "Slideshows",
// "User's page" => "User's page",
// "Users can lock pages" => "Users can lock pages",
// "Wiki watch" => "Wiki watch",
// "Watch minor edits" => "Watch minor edits",
// "Staging &amp; Approval" => "Staging &amp; Approval",
// "Use wiki page staging and approval" => "Use wiki page staging and approval",
// "Force bounce of editing of approved pages to staging" => "Force bounce of editing of approved pages to staging",
// "Delete staging pages at approval" => "Delete staging pages at approval",
// "If not in the group, edit is always redirected to the staging page edit" => "If not in the group, edit is always redirected to the staging page edit",
// "Unique page name prefix to indicate staging copy" => "Unique page name prefix to indicate staging copy",
// "Hide page name prefix" => "Hide page name prefix",
// "Staging" => "Staging",
// "Approved" => "Approved",
// "(mandatory for feature to work)" => "(mandatory for feature to work)",
// "Out-of-sync" => "Out-of-sync",
// "Categorize approved pages with categories of staging copy on approval" => "Categorize approved pages with categories of staging copy on approval",
// "Freetags are disabled" => "Freetags are disabled",
// "Replace freetags with that of staging pages, on approval" => "Replace freetags with that of staging pages, on approval",
// "Add new freetags of approved copy (into tags field) when editing staging pages" => "Add new freetags of approved copy (into tags field) when editing staging pages",
// "Page Listings" => "Page Listings",
// "Pages not in structure" => "Pages not in structure",
// "Configuration" => "Configuration",
// "Select which items to display when listing pages" => "Select which items to display when listing pages",
// "Name length" => "Name length",
// "Edit comments" => "Edit comments",
// "Edit Comments length" => "Edit Comments length",
// "Categories path" => "Categories path",
// "Camera settings" => "Camera settings",
// "Upload Type" => "Upload Type",
// "Data location" => "Data location",
// "HTTP Prefix" => "HTTP Prefix",
// "WebDav username" => "WebDav username",
// "WebDav password" => "WebDav password",
// "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>",
// "Wysiwyg Editor Features" => "Wysiwyg Editor Features",
// "Development Notice" => "Development Notice",
// "Unless a significant amount of preferences are documented and use dynamic preferences before the 4.0 release, this search feature will become disabled by default" => "Unless a significant amount of preferences are documented and use dynamic preferences before the 4.0 release, this search feature will become disabled by default",
// "Database Version Problem" => "Database Version Problem",
// "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors" => "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors",
// "A new version of Tikiwiki, <b>{\$prefs.tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>" => "A new version of Tikiwiki, <b>{\$prefs.tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>",
// "disabled" => "disabled",
// "enabled" => "enabled",
// "preference" => "preference",
// "preference name" => "preference name",
// "TikiCache/System" => "TikiCache/System",
// "Mods" => "Mods",
// "Edit Languages" => "Edit Languages",
// "External Pages Cache" => "External Pages Cache",
// "Content Templates" => "Content Templates",
// "External Wikis" => "External Wikis",
// "Report" => "Report",
// "Please select some actions to view" => "Please select some actions to view",
// "kb" => "kb",
// "Graph Contributions" => "Graph Contributions",
// "Group Bar Plot" => "Group Bar Plot",
// "Accumulated Bar Plot" => "Accumulated Bar Plot",
// "Legend background color" => "Legend background color",
// "Save graphs to image gallery" => "Save graphs to image gallery",
// "See Statistics" => "See Statistics",
// "contribution" => "contribution",
// "contributor" => "contributor",
// "Edit Action" => "Edit Action",
// "Save Action" => "Save Action",
// "Volumes are equally distributed on each contributors/author" => "Volumes are equally distributed on each contributors/author",
// "connection time" => "connection time",
// "connection seconds" => "connection seconds",
// "mns" => "mns",
// "Volumn per category" => "Volumn per category",
// "Volumn per category and per user" => "Volumn per category and per user",
// "Number of actions per user" => "Number of actions per user",
// "Total number of users" => "Total number of users",
// "Number of actions per object" => "Number of actions per object",
// "Total number of objects" => "Total number of objects",
// "Number of actions per category" => "Number of actions per category",
// "Number of actions per category and per user" => "Number of actions per category and per user",
// "Volumn per the users'group and per contribution" => "Volumn per the users'group and per contribution",
// "Volumn per group and per contribution" => "Volumn per group and per contribution",
// "Volumn per user and per contribution" => "Volumn per user and per contribution",
// "Volumn per users'contribution and time" => "Volumn per users'contribution and time",
// "Volumn per contribution and time" => "Volumn per contribution and time",
// "recorded" => "recorded",
// "Wiki page actions except viewed will always be recorded but can be not reported" => "Wiki page actions except viewed will always be recorded but can be not reported",
// "Create Calendar" => "Create Calendar",
// "View Calendars" => "View Calendars",
// "View Calendar" => "View Calendar",
// "Add Event" => "Add Event",
// "Create / Edit Calendar" => "Create / Edit Calendar",
// "Create/Edit Calendars" => "Create/Edit Calendars",
// "Custom URL" => "Custom URL",
// "Start of day" => "Start of day",
// "End of day" => "End of day",
// "Standard Colors" => "Standard Colors",
// "Green" => "Green",
// "Blue" => "Blue",
// "Purple" => "Purple",
// "Red" => "Red",
// "Orange" => "Orange",
// "Yellow" => "Yellow",
// "Let me select my own colors" => "Let me select my own colors",
// "Custom foreground color" => "Custom foreground color",
// "Ex" => "Ex",
// "Custom background color" => "Custom background color",
// "Default event status" => "Default event status",
// "Show in calendar view" => "Show in calendar view",
// "Group of users alerted when calendar event is modified" => "Group of users alerted when calendar event is modified",
// "Delete events older than" => "Delete events older than",
// "Browse the category system" => "Browse the category system",
// "Current Category ID" => "Current Category ID",
// "Edit permissions for this category" => "Edit permissions for this category",
// "Remove from this Category" => "Remove from this Category",
// "Use the Administration page of each enabled feature to allow the use of content templates" => "Use the Administration page of each enabled feature to allow the use of content templates",
// "Use in" => "Use in",
// "No features are configured to use templates" => "No features are configured to use templates",
// "Visible in no sections" => "Visible in no sections",
// "Remove section" => "Remove section",
// "Admin Contributions" => "Admin Contributions",
// "Edit the contribution" => "Edit the contribution",
// "Contributions are mandatory in wiki pages" => "Contributions are mandatory in wiki pages",
// "Contributions are mandatory in forums" => "Contributions are mandatory in forums",
// "Contributions are mandatory in comments" => "Contributions are mandatory in comments",
// "Contributions are mandatory in blogs" => "Contributions are mandatory in blogs",
// "Contributions are displayed in the comment/post" => "Contributions are displayed in the comment/post",
// "Create a new contribution" => "Create a new contribution",
// "List of contributions" => "List of contributions",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}" => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}",
// "Use Admin DSN to define the database to be used by the SQL plugin" => "Use Admin DSN to define the database to be used by the SQL plugin",
// "Admin External Wikis" => "Admin External Wikis",
// "Duplicate forum" => "Duplicate forum",
// "View this forum" => "View this forum",
// "Import forums" => "Import forums",
// ".." => "..",
// "Create/Edit Forums" => "Create/Edit Forums",
// "Only allow replies to the first message (flat forum)" => "Only allow replies to the first message (flat forum)",
// "Set topics preferences" => "Set topics preferences",
// "Show topics preferences" => "Show topics preferences",
// "hide topics preferences" => "hide topics preferences",
// "Set thread preferences" => "Set thread preferences",
// "Show threads preferences" => "Show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Default style for threads" => "Default style for threads",
// "Duplicate Forum" => "Duplicate Forum",
// "Duplicate perms" => "Duplicate perms",
// "Duplicate" => "Duplicate",
// "Admin HTML Page Dynamic Zones" => "Admin HTML Page Dynamic Zones",
// "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones",
// "Refresh rate (if dynamic)" => "Refresh rate (if dynamic)",
// "Admin dynamic zones" => "Admin dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature" => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>" => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>",
// "For wiki page, use ((PageName))" => "For wiki page, use ((PageName))",
// "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Use Ctrl+Click to select multiple groups" => "Use Ctrl+Click to select multiple groups",
// "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each" => "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each",
// "If the url is ((PageName)), you do not need to put the groups, the option will be displayed only if the page can be displayed" => "If the url is ((PageName)), you do not need to put the groups, the option will be displayed only if the page can be displayed",
// "section level 0" => "section level 0",
// "section level 1" => "section level 1",
// "section level 2" => "section level 2",
// "section level 3" => "section level 3",
// "sorted section level 0" => "sorted section level 0",
// "switch with previous option" => "switch with previous option",
// "switch with next option" => "switch with next option",
// "Export CSV data" => "Export CSV data",
// "Import CSV data" => "Import CSV data",
// "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'" => "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'",
// "Create/Edit Menu" => "Create/Edit Menu",
// "Icons" => "Icons",
// "Folder Icon" => "Folder Icon",
// "Path and filename of closed folder icon" => "Path and filename of closed folder icon",
// "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder" => "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder",
// "In the same directory, include an icon for the opened folder" => "In the same directory, include an icon for the opened folder",
// "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>" => "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>",
// "Configure icons for menu entries" => "Configure icons for menu entries",
// "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=look\">Look and Feel</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu" => "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=look\">Look and Feel</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu",
// "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes" => "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes",
// "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "To use a menu in a tiki format" => "To use a menu in a tiki format",
// "To use menu in a css/suckerfish format" => "To use menu in a css/suckerfish format",
// "To customize the menu's CSS id (#)" => "To customize the menu's CSS id (#)",
// "The following required parameters are missing" => "The following required parameters are missing",
// "Assign/Edit modules" => "Assign/Edit modules",
// "Move Up" => "Move Up",
// "Move Down" => "Move Down",
// "assign_name\">Module Name" => "assign_name\">Module Name",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y" => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y",
// "The" => "The",
// "Display Modules to All Groups" => "Display Modules to All Groups",
// "setting will override your selection of specific groups" => "setting will override your selection of specific groups",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// "to make sure users will notice any newly assigned modules" => "to make sure users will notice any newly assigned modules",
// "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site" => "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site",
// "Use Wiki Structure" => "Use Wiki Structure",
// "Edit Newsletter" => "Edit Newsletter",
// "You can add several email addresses by separating them with commas" => "You can add several email addresses by separating them with commas",
// "The user email will be refreshed at each newsletter sending" => "The user email will be refreshed at each newsletter sending",
// "Batch e-mail subscribe" => "Batch e-mail subscribe",
// "txt file, one e-mail per line" => "txt file, one e-mail per line",
// "Export Subscriber Emails" => "Export Subscriber Emails",
// "Add subscribers of another newsletter" => "Add subscribers of another newsletter",
// "Create Newsletter" => "Create Newsletter",
// "Drafts" => "Drafts",
// "Allow customized text message to be sent with the html version" => "Allow customized text message to be sent with the html version",
// "Mail notifications" => "Mail notifications",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications",
// "Alert" => "Alert",
// "Preload Admin Account" => "Preload Admin Account",
// "User / Group" => "User / Group",
// "Multiple" => "Multiple",
// "Trackers Outbound Emails" => "Trackers Outbound Emails",
// "Forums Outbound Emails" => "Forums Outbound Emails",
// "Admin page lists" => "Admin page lists",
// "Current lists" => "Current lists",
// "Edit this list" => "Edit this list",
// "Remove this list" => "Remove this list",
// "Edit list" => "Edit list",
// "Add list" => "Add list",
// "Seed with pages from a category" => "Seed with pages from a category",
// "Add page" => "Add page",
// "Page priority" => "Page priority",
// "Page score" => "Page score",
// "Edit {\$list.name|escape}" => "Edit {\$list.name|escape}",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Create poll" => "Create poll",
// "Edit poll" => "Edit poll",
// "Toggle Quick Options" => "Toggle Quick Options",
// "Add Option" => "Add Option",
// "Leave box empty for deleting an option" => "Leave box empty for deleting an option",
// "Votes older than these days are no more considered" => "Votes older than these days are no more considered",
// "0 for no limit" => "0 for no limit",
// "Add poll to pages" => "Add poll to pages",
// "This menu shows only Polls with 'status': \"template\"" => "This menu shows only Polls with 'status': \"template\"",
// "Use Ctrl+Click to select multiple pages" => "Use Ctrl+Click to select multiple pages",
// "Lock the pages" => "Lock the pages",
// "Admin External Feeds" => "Admin External Feeds",
// "Tips" => "Tips",
// "This page is to configure settings of external feeds read/imported by Tiki. To generate/export feeds, look for \"Feeds\" on the admin panel, or" => "This page is to configure settings of external feeds read/imported by Tiki. To generate/export feeds, look for \"Feeds\" on the admin panel, or",
// "To use feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the feed" => "To use feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the feed",
// "Edit this feed" => "Edit this feed",
// "Create new external feed" => "Create new external feed",
// "Show Date" => "Show Date",
// "View feed" => "View feed",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>" => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>",
// "PHP functions" => "PHP functions",
// "Function" => "Function",
// "To disallow a function, add a disable_functions=exec,passthru for instance in your php.ini" => "To disallow a function, add a disable_functions=exec,passthru for instance in your php.ini",
// "TikiWiki settings" => "TikiWiki settings",
// "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors" => "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors",
// "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)" => "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)",
// "Security checks" => "Security checks",
// "Check file permissions" => "Check file permissions",
// "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments" => "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments",
// "See end of table for detailed explanations" => "See end of table for detailed explanations",
// "owner" => "owner",
// "special" => "special",
// "other" => "other",
// "uid" => "uid",
// "gid" => "gid",
// "suid" => "suid",
// "sgid" => "sgid",
// "r" => "r",
// "w" => "w",
// "Set User ID (suid) files" => "Set User ID (suid) files",
// "World writable files or directories" => "World writable files or directories",
// "Files or directories the Webserver can write to" => "Files or directories the Webserver can write to",
// "Strange Inodes (not file, not link, not directory)" => "Strange Inodes (not file, not link, not directory)",
// "Executable files" => "Executable files",
// "What to do with these check results" => "What to do with these check results",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"" => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content" => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information" => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes" => "Inodes that are not files or directories are not part of tiki. Review these Inodes",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod" => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod",
// "XML Zip Import" => "XML Zip Import",
// "The structure" => "The structure",
// "has just been created" => "has just been created",
// "You will remove structure" => "You will remove structure",
// "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict" => "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict",
// "The following pages have automatically been categorized with the same categories as the structure" => "The following pages have automatically been categorized with the same categories as the structure",
// "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent" => "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent",
// "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent" => "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent",
// "Edit structure" => "Edit structure",
// "View structure" => "View structure",
// "PDF" => "PDF",
// "XML Zip" => "XML Zip",
// "Add a New Question" => "Add a New Question",
// "This survey stats" => "This survey stats",
// "Edit Survey Question" => "Edit Survey Question",
// "Add a New Question to this survey" => "Add a New Question to this survey",
// "Multiple choices of thumbnails from a file gallery" => "Multiple choices of thumbnails from a file gallery",
// "Wiki textarea" => "Wiki textarea",
// "Answer is mandatory" => "Answer is mandatory",
// "Number of required answers (for multiple choices)" => "Number of required answers (for multiple choices)",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "For a rate, you can give the maximum value" => "For a rate, you can give the maximum value",
// "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4" => "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4",
// "Create/Edit Surveys" => "Create/Edit Surveys",
// "Closed" => "Closed",
// "Tiki Cache/System Admin" => "Tiki Cache/System Admin",
// "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)" => "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)",
// "Exterminator of cached content" => "Exterminator of cached content",
// "Directory to exterminate" => "Directory to exterminate",
// "Clear all Tiki caches" => "Clear all Tiki caches",
// "All user prefs sessions" => "All user prefs sessions",
// "Directories to save" => "Directories to save",
// "Full Path to the Zip File" => "Full Path to the Zip File",
// "Generate a zip of those directories" => "Generate a zip of those directories",
// "A zip has been written to {\$zipPath}" => "A zip has been written to {\$zipPath}",
// "Directory is not writeable" => "Directory is not writeable",
// "Advanced feature" => "Advanced feature",
// "View mode" => "View mode",
// "Wiki and WYSIWYG" => "Wiki and WYSIWYG",
// "Wiki only" => "Wiki only",
// "WYSIWYG only" => "WYSIWYG only",
// "Load" => "Load",
// "Reset to Global" => "Reset to Global",
// "Reset to defaults" => "Reset to defaults",
// "Auto Reloading" => "Auto Reloading",
// "Row" => "Row",
// "Formatting Tools" => "Formatting Tools",
// "Plugin Tools" => "Plugin Tools",
// "Edit tool" => "Edit tool",
// "Wysiwyg Token" => "Wysiwyg Token",
// "Plugin name" => "Plugin name",
// "Custom Tools" => "Custom Tools",
// "Add a new custom tool" => "Add a new custom tool",
// "To configure the toolbars on the various text editing areas select the section, and optionally check the comments checkbox, you want to edit and drag the icons from the left hand box to the toolbars on the right.<br />\nDrag icons back from the toolbar rows onto the full list to remove them.<br />\nIcons with <strong>bold</strong> labels are for wiki text areas, those that are <em>italic</em> are for WYSIWYG mode, and those that are <strong><em>bold and italic</em></strong> are for both.<br />\nTo save the current set use the dropdown (and optionally check the comments checkbox) at the bottom of the page to set where you want these toolbars to appear, and click Save" => "To configure the toolbars on the various text editing areas select the section, and optionally check the comments checkbox, you want to edit and drag the icons from the left hand box to the toolbars on the right.<br />\nDrag icons back from the toolbar rows onto the full list to remove them.<br />\nIcons with <strong>bold</strong> labels are for wiki text areas, those that are <em>italic</em> are for WYSIWYG mode, and those that are <strong><em>bold and italic</em></strong> are for both.<br />\nTo save the current set use the dropdown (and optionally check the comments checkbox) at the bottom of the page to set where you want these toolbars to appear, and click Save",
// "Inactive - Click to Activate" => "Inactive - Click to Activate",
// "Active - Click to Deactivate" => "Active - Click to Deactivate",
// "Field is public? (viewed in trackerlist plugin)" => "Field is public? (viewed in trackerlist plugin)",
// "New tracker field" => "New tracker field",
// "Select list items that will be displayed" => "Select list items that will be displayed",
// "Multilingual content" => "Multilingual content",
// "visible to admin only" => "visible to admin only",
// "visible by creator &amp; admin only" => "visible by creator &amp; admin only",
// "The option creator needs a field of type user selector and option 1" => "The option creator needs a field of type user selector and option 1",
// "Visible by" => "Visible by",
// "Editable by" => "Editable by",
// "Description text is wiki-parsed" => "Description text is wiki-parsed",
// "Error message" => "Error message",
// "Export fieldId also" => "Export fieldId also",
// "Check the box to re-import in this tracker and change the fields" => "Check the box to re-import in this tracker and change the fields",
// "Uncheck the box to import in another database" => "Uncheck the box to import in another database",
// "Edit This Tracker's Fields" => "Edit This Tracker's Fields",
// "with" => "with",
// "Create Tracker" => "Create Tracker",
// "Create/Edit Tracker" => "Create/Edit Tracker",
// "Auto create corresponding categories" => "Auto create corresponding categories",
// "Create a group for each item" => "Create a group for each item",
// "Groups will include" => "Groups will include",
// "Creator is assigned to the group" => "Creator is assigned to the group",
// "and it becomes his default group" => "and it becomes his default group",
// "and it becomes the new item group creator" => "and it becomes the new item group creator",
// "But copy the default group in this fiedlId before updating the group" => "But copy the default group in this fiedlId before updating the group",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique for a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique for a tracker and they must be valid in SQL",
// "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender",
// "User can take ownership of item created by anonymous" => "User can take ownership of item created by anonymous",
// "Only one item per user or IP" => "Only one item per user or IP",
// "The tracker needs a user or IP field with the option 1" => "The tracker needs a user or IP field with the option 1",
// "Member of the creator group can modify items" => "Member of the creator group can modify items",
// "Format if not the default short one" => "Format if not the default short one",
// "Show creation date when viewing tracker item" => "Show creation date when viewing tracker item",
// "Identify creation user in tracker item" => "Identify creation user in tracker item",
// "Show lastModif date when viewing tracker item" => "Show lastModif date when viewing tracker item",
// "Identify lastModif user in tracker item" => "Identify lastModif user in tracker item",
// "LastModif" => "LastModif",
// "ItemId" => "ItemId",
// "and display last comment user/date" => "and display last comment user/date",
// "Items can be created only during a certain time" => "Items can be created only during a certain time",
// "Do not show empty fields in item view" => "Do not show empty fields in item view",
// "Show these fields (ID comma separated) in a popup on item link when listing tracker items" => "Show these fields (ID comma separated) in a popup on item link when listing tracker items",
// "Group of users alerted when tracker is modified" => "Group of users alerted when tracker is modified",
// "Date Format" => "Date Format",
// "timestamp" => "timestamp",
// "Charset encoding" => "Charset encoding",
// "UTF-8" => "UTF-8",
// "ISO-8859-1" => "ISO-8859-1",
// "Duplicate Tracker" => "Duplicate Tracker",
// "Manage permissions" => "Manage permissions",
// "Inherits Permissions from" => "Inherits Permissions from",
// "User Choice" => "User Choice",
// "Inherit permissions directly from following groups" => "Inherit permissions directly from following groups",
// "Selected groups only. Use Ctrl+Click to select more than one" => "Selected groups only. Use Ctrl+Click to select more than one",
// "Also inheriting permissions from the following groups (indirect inheritance through the groups selected above)" => "Also inheriting permissions from the following groups (indirect inheritance through the groups selected above)",
// "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)" => "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)",
// "Default category assigned to uncategorized objects edited by a user with this default group" => "Default category assigned to uncategorized objects edited by a user with this default group",
// "Group Theme" => "Group Theme",
// "Use site default" => "Use site default",
// "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)",
// "User can assign to the group himself" => "User can assign to the group himself",
// "Users are automatically unassigned from the group after" => "Users are automatically unassigned from the group after",
// "0 or empty for never" => "0 or empty for never",
// "Assign group <em>management</em> permissions" => "Assign group <em>management</em> permissions",
// "Create Item" => "Create Item",
// "Choose a field .." => "Choose a field ..",
// "Remove from Group" => "Remove from Group",
// "Add to group" => "Add to group",
// "Download CSV export" => "Download CSV export",
// "Assign users to group" => "Assign users to group",
// "Each user in the file must already exist" => "Each user in the file must already exist",
// "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>" => "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>",
// "CSV File" => "CSV File",
// "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login" => "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login",
// "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login" => "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login",
// "Feedback" => "Feedback",
// "Updated users" => "Updated users",
// "More Criteria" => "More Criteria",
// "Group (direct)" => "Group (direct)",
// "ago" => "ago",
// "Need to validate email" => "Need to validate email",
// "Assign to group" => "Assign to group",
// "Edit Included Group" => "Edit Included Group",
// "Edit Group" => "Edit Group",
// "Validate user" => "Validate user",
// "Confirm user email" => "Confirm user email",
// "Invalid email" => "Invalid email",
// "Send a wiki page by Email" => "Send a wiki page by Email",
// "Tip: Hold down CTRL to select multiple" => "Tip: Hold down CTRL to select multiple",
// "Template wiki page" => "Template wiki page",
// "Assign user to Groups" => "Assign user to Groups",
// "Use the email as username" => "Use the email as username",
// "Lowercase only" => "Lowercase only",
// "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)" => "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)",
// "Warning: it will mess with slave intertiki sites that use this one as master" => "Warning: it will mess with slave intertiki sites that use this one as master",
// "No password is required" => "No password is required",
// "Tikiwiki is configured to delegate the password managment to LDAP" => "Tikiwiki is configured to delegate the password managment to LDAP",
// "Repeat Password" => "Repeat Password",
// "User must change password at first login" => "User must change password at first login",
// "Send an email to the user in order to allow him to validate his account" => "Send an email to the user in order to allow him to validate his account",
// "Last Login" => "Last Login",
// "You do not have permission to edit this user" => "You do not have permission to edit this user",
// "CSV file layout" => "CSV file layout",
// "login,password,email<br />user1,pass1,email1<br />user2,pass2,email2" => "login,password,email<br />user1,pass1,email1<br />user2,pass2,email2",
// "Overwrite but keep the previous login if the login exists in another case" => "Overwrite but keep the previous login if the login exists in another case",
// "Don't overwrite" => "Don't overwrite",
// "Overwrite groups" => "Overwrite groups",
// "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>" => "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>",
// "Loading.." => "Loading..",
// "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences" => "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences",
// "Approve page changes in staging" => "Approve page changes in staging",
// "Page has been approved" => "Page has been approved",
// "New attachments" => "New attachments",
// "Old attachments" => "Old attachments",
// "Changes from the following versions under staging have been merged into the approved version" => "Changes from the following versions under staging have been merged into the approved version",
// "Show Help" => "Show Help",
// "Article type" => "Article type",
// "Actions on this article type" => "Actions on this article type",
// "This page will be replaced with the Object Permissions page although currently it does not support the \"advanced\" mode of this page.<br />Please try it out and feedback with any improvements or problems" => "This page will be replaced with the Object Permissions page although currently it does not support the \"advanced\" mode of this page.<br />Please try it out and feedback with any improvements or problems",
// "Click this button to try it now" => "Click this button to try it now",
// "Global object permissions" => "Global object permissions",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Level configuration" => "Level configuration",
// "Assign User {\$assign_user|escape} to Groups" => "Assign User {\$assign_user|escape} to Groups",
// "Assign User to Group" => "Assign User to Group",
// "Directory batch upload" => "Directory batch upload",
// "available images" => "available images",
// "Remove File Extension from Image Name" => "Remove File Extension from Image Name",
// "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field",
// "Convert the last sub directory to a sub gallery" => "Convert the last sub directory to a sub gallery",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created",
// "Use the last sub directory name as description" => "Use the last sub directory name as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created",
// "Select a Gallery" => "Select a Gallery",
// "Browse File Gallery" => "Browse File Gallery",
// "Please do not use this feature to upload data into the database" => "Please do not use this feature to upload data into the database",
// "Available Files" => "Available Files",
// "Select a File Gallery" => "Select a File Gallery",
// "Process files" => "Process files",
// "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. ",
// "Report to Webmaster" => "Report to Webmaster",
// "The TikiWiki Community" => "The TikiWiki Community",
// "TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
// "database queries used in " => "database queries used in ",
// "Last update from SVN" => "Last update from SVN",
// "Watch Only This Category" => "Watch Only This Category",
// "Watch This Category and Their Descendants" => "Watch This Category and Their Descendants",
// "Stop Watching Only This Category" => "Stop Watching Only This Category",
// "Stop Watching This Category and Their Descendants" => "Stop Watching This Category and Their Descendants",
// "Admin the Category System" => "Admin the Category System",
// "in the current category - and its subcategories: " => "in the current category - and its subcategories: ",
// "Upper level" => "Upper level",
// "Browse related tags" => "Browse related tags",
// "Network of Tags related to" => "Network of Tags related to",
// "With all selected tags" => "With all selected tags",
// "With one selected tag" => "With one selected tag",
// "With last selected tag" => "With last selected tag",
// "More Popular Tags" => "More Popular Tags",
// "Alphabetically" => "Alphabetically",
// "By Size" => "By Size",
// "Cloud" => "Cloud",
// "\$feature_label" => "\$feature_label",
// "results found" => "results found",
// "Directory Batch" => "Directory Batch",
// "All Images" => "All Images",
// "Monitor this Gallery" => "Monitor this Gallery",
// "Stop Monitoring this Gallery" => "Stop Monitoring this Gallery",
// "subgallery" => "subgallery",
// "You can view this gallery's configured image (first, random, etc.) in your browser using" => "You can view this gallery's configured image (first, random, etc.) in your browser using",
// "You can include the gallery's image in an HTML page using one of these lines" => "You can include the gallery's image in an HTML page using one of these lines",
// "Slideshow Forward" => "Slideshow Forward",
// "Cyclic" => "Cyclic",
// "Include the image in a tiki page using the following syntax" => "Include the image in a tiki page using the following syntax",
// "To include the image in an HTML page" => "To include the image in an HTML page",
// "To link to this page from another tiki page" => "To link to this page from another tiki page",
// "Browsing Video" => "Browsing Video",
// "Edit Video" => "Edit Video",
// "First Video" => "First Video",
// "Prev Video" => "Prev Video",
// "Next Video" => "Next Video",
// "Last Video" => "Last Video",
// "Video Title" => "Video Title",
// "Move video" => "Move video",
// "You can view this video in your browser using" => "You can view this video in your browser using",
// "You can include the video in a tiki page using one of these lines" => "You can include the video in a tiki page using one of these lines",
// "Admin Calendar" => "Admin Calendar",
// "Export Calendars" => "Export Calendars",
// "Click to export calendars" => "Click to export calendars",
// "Visible Calendars" => "Visible Calendars",
// "Click to select visible calendars" => "Click to select visible calendars",
// "Export calendars" => "Export calendars",
// "advanced parameters" => "advanced parameters",
// "Edit event" => "Edit event",
// "Delete event" => "Delete event",
// "View event" => "View event",
// "All-Day" => "All-Day",
// "Website" => "Website",
// "View this Week" => "View this Week",
// "View this Day" => "View this Day",
// "o" => "o",
// "Calendar Item" => "Calendar Item",
// "Edit Calendar" => "Edit Calendar",
// "New event" => "New event",
// "Recurrence" => "Recurrence",
// "This event depends on a recurrence rule" => "This event depends on a recurrence rule",
// "This event is not recurrent" => "This event is not recurrent",
// "On a weekly basis" => "On a weekly basis",
// "Each" => "Each",
// "of the week" => "of the week",
// "On a monthly basis" => "On a monthly basis",
// "of the month" => "of the month",
// "On a yearly basis" => "On a yearly basis",
// "There's no such date as" => "There's no such date as",
// "Starting on" => "Starting on",
// "ending by" => "ending by",
// "ending after" => "ending after",
// "events" => "events",
// "Start period" => "Start period",
// "End after" => "End after",
// "occurrences" => "occurrences",
// "End before" => "End before",
// "Event is repeated" => "Event is repeated",
// "every" => "every",
// "of every month" => "of every month",
// "on each" => "on each",
// "Date and time of end" => "Date and time of end",
// "Events cannot end before they start" => "Events cannot end before they start",
// "No description" => "No description",
// "or new" => "or new",
// "Choose users to alert" => "Choose users to alert",
// "chair" => "chair",
// "default role" => "default role",
// "required participant" => "required participant",
// "optional participant" => "optional participant",
// "non participant" => "non participant",
// "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in" => "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in",
// "role:login_or_email,login_or_email" => "role:login_or_email,login_or_email",
// "If no role is provided, default role will be \"Chair participant\"" => "If no role is provided, default role will be \"Chair participant\"",
// "Update this event only" => "Update this event only",
// "Update every unchanged events of this recurrence rule" => "Update every unchanged events of this recurrence rule",
// "Update every events of this recurrence rule" => "Update every events of this recurrence rule",
// "Delete Recurrent events" => "Delete Recurrent events",
// "Calendar import" => "Calendar import",
// "Calendar has been updated" => "Calendar has been updated",
// "D" => "D",
// "W" => "W",
// "M" => "M",
// "%d/%m" => "%d/%m",
// "Advanced parameters for iCal export" => "Advanced parameters for iCal export",
// "Calendars to be exported" => "Calendars to be exported",
// "Your account has been validated" => "Your account has been validated",
// "You have to choose a password to use this account" => "You have to choose a password to use this account",
// "Change your password" => "Change your password",
// "Send another message" => "Send another message",
// "Group View" => "Group View",
// "Publish this contact to groups" => "Publish this contact to groups",
// "<a href=\"tiki-directory_admin_categories.php\">Add a directory category now</a>" => "<a href=\"tiki-directory_admin_categories.php\">Add a directory category now</a>",
// "The following site was added, but may require validation by the admin before appearing on the lists" => "The following site was added, but may require validation by the admin before appearing on the lists",
// "Edit a site" => "Edit a site",
// "Add a site" => "Add a site",
// "Directory Categories" => "Directory Categories",
// "Use Ctrl+Click to select multiple directory categories" => "Use Ctrl+Click to select multiple directory categories",
// "Parent directory category" => "Parent directory category",
// "Most visited directory sub-categories" => "Most visited directory sub-categories",
// "Directory Category description" => "Directory Category description",
// "Random directory sub-categories" => "Random directory sub-categories",
// "Allow sites in this directory category" => "Allow sites in this directory category",
// "Show number of sites in this directory category" => "Show number of sites in this directory category",
// "Directory Subcategories" => "Directory Subcategories",
// "Admin related directory categories" => "Admin related directory categories",
// "Add a related directory category" => "Add a related directory category",
// "Directory Category" => "Directory Category",
// "Related directory categories" => "Related directory categories",
// "Perform action with selected" => "Perform action with selected",
// "Add a Directory Category" => "Add a Directory Category",
// "in current directory category" => "in current directory category",
// "Total directory categories" => "Total directory categories",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "Emails to be notified (separated with commas)" => "Emails to be notified (separated with commas)",
// "-1 for unlimited" => "-1 for unlimited",
// "Max impressions for a user" => "Max impressions for a user",
// "Max clicks" => "Max clicks",
// "Or, create a new zone" => "Or, create a new zone",
// "Use Flash" => "Use Flash",
// "Movie Size" => "Movie Size",
// "FlashPlugin min version" => "FlashPlugin min version",
// "ex" => "ex",
// "A category is mandatory" => "A category is mandatory",
// "The file will be saved in" => "The file will be saved in",
// "Wiki Syntax" => "Wiki Syntax",
// "For more information, please see" => "For more information, please see",
// "Wiki Page Editor" => "Wiki Page Editor",
// "More help on editing wiki pages" => "More help on editing wiki pages",
// "The syntax system used for creating pages in TikiWiki" => "The syntax system used for creating pages in TikiWiki",
// "Also available here" => "Also available here",
// "Plugins help" => "Plugins help",
// "Bold text" => "Bold text",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Underlined text" => "Underlined text",
// "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background" => "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background",
// "Deleted text" => "Deleted text",
// "2 dashes" => "2 dashes",
// "Headings" => "Headings",
// "Show/Hide" => "Show/Hide",
// "show/hide heading section. + (shown) or - (hidden) by default" => "show/hide heading section. + (shown) or - (hidden) by default",
// "Autonumbered Headings" => "Autonumbered Headings",
// "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Horizontal rule" => "Horizontal rule",
// "Text box" => "Text box",
// "Centered text" => "Centered text",
// "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)" => "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)",
// "page|#anchor" => "page|#anchor",
// "page|#anchor|desc" => "page|#anchor|desc",
// "for wiki heading/anchor references" => "for wiki heading/anchor references",
// "Indentation" => "Indentation",
// "Creates an indentation for each plus (useful in list to continue at the same level)" => "Creates an indentation for each plus (useful in list to continue at the same level)",
// "row" => "row",
// "col" => "col",
// "Monospace font" => "Monospace font",
// "Code sample" => "Code sample",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "to separate pages" => "to separate pages",
// "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text" => "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text",
// "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar" => "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar",
// "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew" => "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew",
// "Special characters" => "Special characters",
// "hard space" => "hard space",
// "numeric between ~ for html numeric characters entity" => "numeric between ~ for html numeric characters entity",
// "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines" => "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines",
// "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line" => "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line",
// "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt" => "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt",
// "More help here" => "More help here",
// "Wiki plugins extend the function of wiki syntax with more specialized commands" => "Wiki plugins extend the function of wiki syntax with more specialized commands",
// "Upload from disk to change the image" => "Upload from disk to change the image",
// "Save and Go Next" => "Save and Go Next",
// "Im-Export Languages" => "Im-Export Languages",
// "Toggle interactive translation off" => "Toggle interactive translation off",
// "Toggle interactive translation on" => "Toggle interactive translation on",
// "Edit quiz results" => "Edit quiz results",
// "and its subpages from the structure" => "and its subpages from the structure",
// "The page already exists. The page that has been added to the structure is the existing one" => "The page already exists. The page that has been added to the structure is the existing one",
// "The following pages added have automatically been categorized with the same categories as the structure" => "The following pages added have automatically been categorized with the same categories as the structure",
// "Monitor the Sub-Structure" => "Monitor the Sub-Structure",
// "Stop Monitoring the Sub-Structure" => "Stop Monitoring the Sub-Structure",
// "Move in this structure" => "Move in this structure",
// "Move to another structure" => "Move to another structure",
// "at the beginning" => "at the beginning",
// "at the end" => "at the end",
// "Categorize all pages in structure together" => "Categorize all pages in structure together",
// "Remove existing categories from ALL pages before recategorizing" => "Remove existing categories from ALL pages before recategorizing",
// "<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=small line below Title",
// "Submit Article" => "Submit Article",
// "Auto-Approve Article" => "Auto-Approve Article",
// "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering" => "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering",
// "This would cause you problems (e.g. menus can stop collapsing/expanding)" => "This would cause you problems (e.g. menus can stop collapsing/expanding)",
// "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)" => "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)",
// "Maybe You just want to modify the top of your Tiki site" => "Maybe You just want to modify the top of your Tiki site",
// "Please consider using the Look & Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface" => "Please consider using the Look & Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface",
// "Delete the copy in the theme" => "Delete the copy in the theme",
// "Add Notification Email" => "Add Notification Email",
// "Admin notifications" => "Admin notifications",
// "View Page" => "View Page",
// "View Article" => "View Article",
// "Language of newly translated page" => "Language of newly translated page",
// "Unspecified" => "Unspecified",
// "Name of newly translated page" => "Name of newly translated page",
// "Create translation" => "Create translation",
// "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"" => "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"",
// "\"The page already exists. It was selected in the list below.\"" => "\"The page already exists. It was selected in the list below.\"",
// "Or" => "Or",
// "Add existing page as a translation of this page" => "Add existing page as a translation of this page",
// "Manage existing translations of this page" => "Manage existing translations of this page",
// "Change language for this page" => "Change language for this page",
// "Select from available options.." => "Select from available options..",
// "Change Language" => "Change Language",
// "No language is assigned to this page" => "No language is assigned to this page",
// "Please select a language before performing translation" => "Please select a language before performing translation",
// "Set Current Page's Language" => "Set Current Page's Language",
// "Edit Video Information" => "Edit Video Information",
// "Browse Videos" => "Browse Videos",
// "The following video was successfully edited" => "The following video was successfully edited",
// "You can include the video in an HTML page using one of these lines" => "You can include the video in an HTML page using one of these lines",
// "View object" => "View object",
// "Preview your changes" => "Preview your changes",
// "Save the page" => "Save the page",
// "Cancel the edit, you will lose your changes" => "Cancel the edit, you will lose your changes",
// "This edit session will expire in" => "This edit session will expire in",
// "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer" => "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer",
// "Update '{\$page|escape}'" => "Update '{\$page|escape}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval" => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval",
// "This is a new staging page that has not been approved before" => "This is a new staging page that has not been approved before",
// "The current staging copy may contain changes that have yet to be approved" => "The current staging copy may contain changes that have yet to be approved",
// "View changes since last approval" => "View changes since last approval",
// "You are editing the approved copy of this page" => "You are editing the approved copy of this page",
// "There are currently changes in the staging copy that have yet to be approved" => "There are currently changes in the staging copy that have yet to be approved",
// "Are you sure you do not want to edit" => "Are you sure you do not want to edit",
// "the staging copy" => "the staging copy",
// "instead" => "instead",
// "Draft written on" => "Draft written on",
// "Warning: new versions of this page have been made after this draft" => "Warning: new versions of this page have been made after this draft",
// "Edit wiki page" => "Edit wiki page",
// "Change the style used to display differences to be translated" => "Change the style used to display differences to be translated",
// "Change diff styles" => "Change diff styles",
// "Edit page" => "Edit page",
// "Edit Comment" => "Edit Comment",
// "Edit comment: Enter some text to describe the changes you are currently making" => "Edit comment: Enter some text to describe the changes you are currently making",
// "Monitor this page" => "Monitor this page",
// "Add another image" => "Add another image",
// "Categories will be inherited from the structure top page" => "Categories will be inherited from the structure top page",
// "Tools" => "Tools",
// "Lock this page" => "Lock this page",
// "Allow comments on this page" => "Allow comments on this page",
// "Regex search " => "Regex search ",
// "Replace with" => "Replace with",
// "Case Insensitivity" => "Case Insensitivity",
// "Upload Screencast" => "Upload Screencast",
// "Incorrect file extension was used for your flash screencast, expecting .swf or .flv" => "Incorrect file extension was used for your flash screencast, expecting .swf or .flv",
// "An unexpected error occurred while uploading your flash screencast" => "An unexpected error occurred while uploading your flash screencast",
// "Incorrect file extension was used for your Ogg screencast, expecting .ogg" => "Incorrect file extension was used for your Ogg screencast, expecting .ogg",
// "A flash screencast is mandatory" => "A flash screencast is mandatory",
// "An unexpected error occurred while uploading your Ogg screencast" => "An unexpected error occurred while uploading your Ogg screencast",
// "Preview not possible" => "Preview not possible",
// "Flash video (required)" => "Flash video (required)",
// "Ogg video (optional)" => "Ogg video (optional)",
// "Add another screencast" => "Add another screencast",
// "Authors' style" => "Authors' style",
// "Description (used for metatags)" => "Description (used for metatags)",
// "or use" => "or use",
// "Translation request" => "Translation request",
// "Send urgent translation request" => "Send urgent translation request",
// "List Sheets" => "List Sheets",
// "Graph" => "Graph",
// "Export to file" => "Export to file",
// "Format" => "Format",
// "Autodetect" => "Autodetect",
// "Export Tracker Items" => "Export Tracker Items",
// "Delimitors" => "Delimitors",
// "Carriage Return inside Field Value" => "Carriage Return inside Field Value",
// "Parse as Wiki Text" => "Parse as Wiki Text",
// "Fields visible in items list" => "Fields visible in items list",
// "Fields searchable or visible in items list" => "Fields searchable or visible in items list",
// "Fields visible in an item view" => "Fields visible in an item view",
// "All fields" => "All fields",
// "These fields" => "These fields",
// "Use Ctrl+Click to select multiple fields" => "Use Ctrl+Click to select multiple fields",
// "Edit FAQ question" => "Edit FAQ question",
// "Add FAQ question" => "Add FAQ question",
// "File Archive" => "File Archive",
// "Be careful to set the right permissions on the files you link to" => "Be careful to set the right permissions on the files you link to",
// "Create New File Gallery" => "Create New File Gallery",
// "Size (width x height)" => "Size (width x height)",
// "Forum Importer" => "Forum Importer",
// "Import from a Local SQL File" => "Import from a Local SQL File",
// "Forum Type" => "Forum Type",
// "DB Prefix" => "DB Prefix",
// "Local SQL Filename on Server (path will be stripped)" => "Local SQL Filename on Server (path will be stripped)",
// "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up",
// "Verification" => "Verification",
// "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>" => "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>",
// "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred" => "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred",
// "Select a Forum You Wish to Move (ONE at a time!)" => "Select a Forum You Wish to Move (ONE at a time!)",
// "Which Forum Do You Wish to Import this Into" => "Which Forum Do You Wish to Import this Into",
// "Message queue for forum" => "Message queue for forum",
// "Back to forum" => "Back to forum",
// "Search by name" => "Search by name",
// "Search in content" => "Search in content",
// "Reported messages for forum" => "Reported messages for forum",
// "Perfom action with checked" => "Perfom action with checked",
// "Un-report" => "Un-report",
// "Tag translation" => "Tag translation",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag" => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag",
// "Until then, they cannot be translated" => "Until then, they cannot be translated",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Set language" => "Set language",
// "Universal" => "Universal",
// "Show the following languages" => "Show the following languages",
// "Cancel friendship request" => "Cancel friendship request",
// "Global default" => "Global default",
// "Google Map Locator" => "Google Map Locator",
// "enter address" => "enter address",
// "Find address" => "Find address",
// "Save clicked point" => "Save clicked point",
// "Reset view to default" => "Reset view to default",
// "Save current view as default" => "Save current view as default",
// "Center map to saved point" => "Center map to saved point",
// "Reset view to site default" => "Reset view to site default",
// "Users Map" => "Users Map",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Landscape" => "Landscape",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal Scale" => "Horizontal Scale",
// "Vertical Scale" => "Vertical Scale",
// "Series" => "Series",
// "Wiki plug-in" => "Wiki plug-in",
// "Ical import / Export" => "Ical import / Export",
// "Select The calendar to export" => "Select The calendar to export",
// "Calendar Import" => "Calendar Import",
// "ICal File" => "ICal File",
// "Modify String in Source Language" => "Modify String in Source Language",
// "Original String" => "Original String",
// "New String" => "New String",
// "If you are NOT running a new Tiki installation, make a backup of your database before using this importer" => "If you are NOT running a new Tiki installation, make a backup of your database before using this importer",
// "Your PHP is running with safe mode enabled. This might cause problems to the import process as safe mode limits the possibly to change in run time some PHP settings (like max_execution_time). It is recommended to run this script without safe mode" => "Your PHP is running with safe mode enabled. This might cause problems to the import process as safe mode limits the possibly to change in run time some PHP settings (like max_execution_time). It is recommended to run this script without safe mode",
// "Depending on the size of the file from the source software, the import process may take a while to complete. This might be a problem according to your PHP and web server settings. This script tries to change the relevant settings but there are some settings that the script cannot change. So, if you are having problems with the script, please try to increase the value of the following PHP settings: max_input_time, max_execution_time (this setting is limited by the web server setting, if you are running Apache also change its Timeout setting), post_max_size, upload_max_filesize, memory_limit. It is recommended that you run this script on a server where you can change the values of those settings (if needed)" => "Depending on the size of the file from the source software, the import process may take a while to complete. This might be a problem according to your PHP and web server settings. This script tries to change the relevant settings but there are some settings that the script cannot change. So, if you are having problems with the script, please try to increase the value of the following PHP settings: max_input_time, max_execution_time (this setting is limited by the web server setting, if you are running Apache also change its Timeout setting), post_max_size, upload_max_filesize, memory_limit. It is recommended that you run this script on a server where you can change the values of those settings (if needed)",
// "Select the software to import from" => "Select the software to import from",
// "WARNING: make sure to have a backup before running the script. If you do not have a backup this is the last chance to cancel the importer by clicking on the cancel button" => "WARNING: make sure to have a backup before running the script. If you do not have a backup this is the last chance to cancel the importer by clicking on the cancel button",
// "Congratulations! You have successful imported your data to Tikiwiki" => "Congratulations! You have successful imported your data to Tikiwiki",
// "pages imported from a total of" => "pages imported from a total of",
// "You can see the list of wiki pages in your site" => "You can see the list of wiki pages in your site",
// "here" => "here",
// "Importer log" => "Importer log",
// "Tiki installer" => "Tiki installer",
// "Welcome" => "Welcome",
// "Welcome to the Tiki installation and upgrade script" => "Welcome to the Tiki installation and upgrade script",
// "Use this script to install a new Tiki database or upgrade your existing database to release" => "Use this script to install a new Tiki database or upgrade your existing database to release",
// "For the latest information about this release, please read the" => "For the latest information about this release, please read the",
// "Release Notes" => "Release Notes",
// "For complete documentation, please visit" => "For complete documentation, please visit",
// "For more information about Tiki, please visit" => "For more information about Tiki, please visit",
// "Select your language" => "Select your language",
// "Read the License" => "Read the License",
// "Tiki is software distributed under the LGPL license" => "Tiki is software distributed under the LGPL license",
// " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>" => " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>",
// "Review the System Requirements" => "Review the System Requirements",
// "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/Requirements\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements" => "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/Requirements\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements",
// "This installer will perform some basic checks automatically" => "This installer will perform some basic checks automatically",
// "Memory" => "Memory",
// "Success" => "Success",
// "Tiki has not detected your PHP memory_limit" => "Tiki has not detected your PHP memory_limit",
// "This probably means you have no set limit (all is well)" => "This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at" => "Tiki has detected your PHP memory limit at",
// "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution" => "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution",
// "Allocating too little memory will cause Tiki to display blank pages" => "Allocating too little memory will cause Tiki to display blank pages",
// "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver" => "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages" => "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages",
// "To test your system configuration, Tiki will attempt to send a test message to you" => "To test your system configuration, Tiki will attempt to send a test message to you",
// "Test email" => "Test email",
// "Email address to send test to" => "Email address to send test to",
// "Copy test mail to " => "Copy test mail to ",
// "Send Test Message" => "Send Test Message",
// "Tiki was able to send a test message to" => "Tiki was able to send a test message to",
// "Tiki was not able to send a test message" => "Tiki was not able to send a test message",
// "Review your mail log for details" => "Review your mail log for details",
// "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)" => "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)",
// "If your host requires SMTP authentication, additional configuration may be necessary" => "If your host requires SMTP authentication, additional configuration may be necessary",
// "Image Processing" => "Image Processing",
// "Tiki detected" => "Tiki detected",
// "Tiki was not able to detect the GD library" => "Tiki was not able to detect the GD library",
// "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support" => "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support",
// "Set the Database Connection" => "Set the Database Connection",
// "Tiki requires an active database connection" => "Tiki requires an active database connection",
// "You must create the database and user <em>before</em> completing this page" => "You must create the database and user <em>before</em> completing this page",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "This is normal for a new installation" => "This is normal for a new installation",
// "Tiki found an existing database connection in your local.php file" => "Tiki found an existing database connection in your local.php file",
// "Use Existing Connection" => "Use Existing Connection",
// "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>" => "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>",
// "Database information" => "Database information",
// "Enter your database connection information" => "Enter your database connection information",
// "Database type" => "Database type",
// "Select the type of database to use with Tiki" => "Select the type of database to use with Tiki",
// "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension" => "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension",
// "Host name" => "Host name",
// "Enter the host name or IP for your database" => "Enter the host name or IP for your database",
// "Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Use <strong>localhost</strong> if the database is running on the same machine as Tiki",
// "Database name" => "Database name",
// "Enter the name of the database that Tiki will use" => "Enter the name of the database that Tiki will use",
// "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names" => "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names",
// "Database user" => "Database user",
// "Enter a database user with administrator permission for the Database" => "Enter a database user with administrator permission for the Database",
// "User name" => "User name",
// "Install &amp; Upgrade" => "Install &amp; Upgrade",
// "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page" => "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page",
// "This install will populate (or upgrade) the database" => "This install will populate (or upgrade) the database",
// "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>" => "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>",
// "A new install will populate the database" => "A new install will populate the database",
// "Reinstall the database" => "Reinstall the database",
// "This will destroy your current database" => "This will destroy your current database",
// "Reinstall" => "Reinstall",
// "Upgrade" => "Upgrade",
// "Warning: Category Permissions Will Not Be Upgraded" => "Warning: Category Permissions Will Not Be Upgraded",
// "Category permissions have been revamped in version 4. If you have been using category permissions, note that they may not work properly after upgrading to version 4, and it will be necessary to reconfigure them" => "Category permissions have been revamped in version 4. If you have been using category permissions, note that they may not work properly after upgrading to version 4, and it will be necessary to reconfigure them",
// "Automatically upgrade your existing database to v" => "Automatically upgrade your existing database to v",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please login with your admin password to continue" => "Please login with your admin password to continue",
// "Review the Upgrade" => "Review the Upgrade",
// "Review the Installation" => "Review the Installation",
// "Upgrade complete" => "Upgrade complete",
// "Installation complete" => "Installation complete",
// "Your database has been configured and Tiki is ready to run" => "Your database has been configured and Tiki is ready to run",
// "If this is your first install, your admin password is <strong>admin</strong>" => "If this is your first install, your admin password is <strong>admin</strong>",
// "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application" => "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application",
// "Upgrade operations executed successfully" => "Upgrade operations executed successfully",
// "Installation operations executed successfully" => "Installation operations executed successfully",
// "SQL queries" => "SQL queries",
// "Database was left unchanged" => "Database was left unchanged",
// "Operations failed" => "Operations failed",
// "Display details" => "Display details",
// "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages" => "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages",
// ".htaccess File" => ".htaccess File",
// "We recommend enabling the <strong>.htaccess</strong> file for your Tiki" => "We recommend enabling the <strong>.htaccess</strong> file for your Tiki",
// "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security" => "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security",
// "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>" => "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>",
// "Complete these fields to configure common, general settings for your site" => "Complete these fields to configure common, general settings for your site",
// "The information you enter here can be changed later" => "The information you enter here can be changed later",
// "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings" => "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings",
// "This will appear in the browser title bar" => "This will appear in the browser title bar",
// "Email sent by your site will use this address" => "Email sent by your site will use this address",
// "Secure Login" => "Secure Login",
// "HTTPS login" => "HTTPS login",
// "Administrator" => "Administrator",
// "Admin email" => "Admin email",
// "This is the email address for your administrator account" => "This is the email address for your administrator account",
// "Enter Your Tiki" => "Enter Your Tiki",
// "The installation is complete" => "The installation is complete",
// "Tiki is an open source project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/Develop+Tiki' target='_blank'>develop Tiki</a>" => "Tiki is an open source project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/Develop+Tiki' target='_blank'>develop Tiki</a>",
// "Installation" => "Installation",
// "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation",
// "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu" => "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu",
// "Enter Tiki and Lock Installer" => "Enter Tiki and Lock Installer",
// "Recommended" => "Recommended",
// "Enter Tiki Without Locking Installer" => "Enter Tiki Without Locking Installer",
// "MultiTiki Setup" => "MultiTiki Setup",
// "Default Installation" => "Default Installation",
// "DB OK" => "DB OK",
// "No DB" => "No DB",
// "Adding a new host" => "Adding a new host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "Are you upgrading an existing Tiki site" => "Are you upgrading an existing Tiki site",
// "Go directly to the <strong>Install/Upgrade</strong> step" => "Go directly to the <strong>Install/Upgrade</strong> step",
// "Install/Upgrade" => "Install/Upgrade",
// "Restart the installer" => "Restart the installer",
// "Database Connection" => "Database Connection",
// "Reset the Database Connection" => "Reset the Database Connection",
// "Install Profile" => "Install Profile",
// "Configure the General Settings" => "Configure the General Settings",
// "Tiki Icon" => "Tiki Icon",
// "TikiWiki Project Web Site" => "TikiWiki Project Web Site",
// "Support Forums" => "Support Forums",
// "TikiWiki CMS/Groupware Project" => "TikiWiki CMS/Groupware Project",
// "Powered by TikiWiki" => "Powered by TikiWiki",
// "Interactive translator" => "Interactive translator",
// "has been updated" => "has been updated",
// "Close this window" => "Close this window",
// "Go Back" => "Go Back",
// "Clicking 'Close this window' will reload the main window from where it was opened" => "Clicking 'Close this window' will reload the main window from where it was opened",
// "Upload to Kaltura" => "Upload to Kaltura",
// "List Entries" => "List Entries",
// "Upload Successful" => "Upload Successful",
// "You have successfully added {\$count} new entry/entries" => "You have successfully added {\$count} new entry/entries",
// "Change Details" => "Change Details",
// "Remix" => "Remix",
// "Advanced Editor" => "Advanced Editor",
// "Simple Editor" => "Simple Editor",
// "Views" => "Views",
// "Plays" => "Plays",
// "Last 2 days" => "Last 2 days",
// "Last 3 days" => "Last 3 days",
// "Last 5 days" => "Last 5 days",
// "Last week" => "Last week",
// "Last 2 weeks" => "Last 2 weeks",
// "Last month" => "Last month",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone" => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone",
// "Max Clicks" => "Max Clicks",
// "The cache is used by" => "The cache is used by",
// "Approval" => "Approval",
// "Rejected" => "Rejected",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block" => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block" => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block",
// "Edit content block" => "Edit content block",
// "Create content block" => "Create content block",
// "Current Value" => "Current Value",
// "SlideShow" => "SlideShow",
// "Keep gallery window open" => "Keep gallery window open",
// "Your comment" => "Your comment",
// "Modifications" => "Modifications",
// "Property <b>{\$fgp_name}</b> Changed" => "Property <b>{\$fgp_name}</b> Changed",
// "Media Entries" => "Media Entries",
// "Mix Entries" => "Mix Entries",
// "Kaltura Remix Entries" => "Kaltura Remix Entries",
// "Kaltura Media Entries" => "Kaltura Media Entries",
// "Loads" => "Loads",
// "Browse Entries" => "Browse Entries",
// "Additional Info" => "Additional Info",
// "Media Type" => "Media Type",
// "No entries" => "No entries",
// "No media entries found. " => "No media entries found. ",
// "Click here " => "Click here ",
// "to upload" => "to upload",
// "No mix entries found. " => "No mix entries found. ",
// "to create a new mix" => "to create a new mix",
// "Playlist Type" => "Playlist Type",
// "No playlists found. " => "No playlists found. ",
// "to create a playlist" => "to create a playlist",
// "Object Permissions List" => "Object Permissions List",
// "Manage Permissions" => "Manage Permissions",
// "If an object is not in the special section, then only the default perms are on" => "If an object is not in the special section, then only the default perms are on",
// "Special" => "Special",
// "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on" => "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on",
// "Page aliases found" => "Page aliases found",
// "Last modification" => "Last modification",
// "Page creator" => "Page creator",
// "Status of the page" => "Status of the page",
// "Links to other items in page" => "Links to other items in page",
// "Links to this page in other pages" => "Links to this page in other pages",
// "Backl" => "Backl",
// "Page size" => "Page size",
// " {if \$find ne ''}and {/if}starting with" => " {if \$find ne ''}and {/if}starting with",
// "However, some page aliases fitting the query were found (see Aliases section above)" => "However, some page aliases fitting the query were found (see Aliases section above)",
// "Perform action with checked" => "Perform action with checked",
// "Xml Zip" => "Xml Zip",
// "Back to admin" => "Back to admin",
// "For security purposes we must periodically validate your email address to allow continued access to this site" => "For security purposes we must periodically validate your email address to allow continued access to this site",
// "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site" => "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site",
// "Thank you" => "Thank you",
// "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/" => "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/",
// "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>" => "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>",
// "Tiki \"mods\" are undergoing refurbishment" => "Tiki \"mods\" are undergoing refurbishment",
// "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification" => "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification",
// "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more" => "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more",
// "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)" => "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)",
// "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")" => "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")",
// "for version" => "for version",
// "all versions" => "all versions",
// "or later" => "or later",
// "No mods found" => "No mods found",
// "licence" => "licence",
// "Records" => "Records",
// "My Articles" => "My Articles",
// "User Articles" => "User Articles",
// "My User Items" => "My User Items",
// "User Items" => "User Items",
// "User forum topics" => "User forum topics",
// "Forum topics" => "Forum topics",
// "Date of post" => "Date of post",
// "User forum replies" => "User forum replies",
// "Forum replies" => "Forum replies",
// "To display the objects you created or contributed to" => "To display the objects you created or contributed to",
// "MyInfo" => "MyInfo",
// "Contacts Preferences" => "Contacts Preferences",
// "Sent Edition" => "Sent Edition",
// "HTML version" => "HTML version",
// "Text version" => "Text version",
// "Delete errors" => "Delete errors",
// "Not sent" => "Not sent",
// "Removal of your email address failed" => "Removal of your email address failed",
// "Subscription failed" => "Subscription failed",
// "Object Watches" => "Object Watches",
// "Watching Groups" => "Watching Groups",
// "Edit Permissions" => "Edit Permissions",
// "Currently editing Global permissions" => "Currently editing Global permissions",
// "This object's direct permissions override any global permissions or category permissions affecting this object" => "This object's direct permissions override any global permissions or category permissions affecting this object",
// "This category's direct permissions override any global permissions affecting objects in it" => "This category's direct permissions override any global permissions affecting objects in it",
// "To edit global permissions" => "To edit global permissions",
// "No permissions yet applied to this object but category permissions affect this object and are displayed below" => "No permissions yet applied to this object but category permissions affect this object and are displayed below",
// "To edit category permissions" => "To edit category permissions",
// "No direct permissions yet applied to this object. Global permissions apply" => "No direct permissions yet applied to this object. Global permissions apply",
// "Currently inherited permissions displayed" => "Currently inherited permissions displayed",
// "Assign global permissions" => "Assign global permissions",
// "Reset to Global Perms" => "Reset to Global Perms",
// "Reset Perms" => "Reset Perms",
// "This will remove all the settings here and permissions will be reset to inherit any category permissions that are set, or the global sitewide permissions" => "This will remove all the settings here and permissions will be reset to inherit any category permissions that are set, or the global sitewide permissions",
// "This will remove all the settings here and permissions will be reset to inherit the global sitewide permissions" => "This will remove all the settings here and permissions will be reset to inherit the global sitewide permissions",
// "Permissions Clipboard" => "Permissions Clipboard",
// "Copy the permissions set here" => "Copy the permissions set here",
// "Paste" => "Paste",
// "Paste copied permissions from " => "Paste copied permissions from ",
// "Assign or remove permissions on <em>all</em> child categories" => "Assign or remove permissions on <em>all</em> child categories",
// "Are you sure you want to effect all child categories?\\nThere is no undo" => "Are you sure you want to effect all child categories?\\nThere is no undo",
// "Assign or remove permissions on all pages of the sub-structure" => "Assign or remove permissions on all pages of the sub-structure",
// "Are you sure you want to effect all pages in this sub-structure?\\nThere is no undo" => "Are you sure you want to effect all pages in this sub-structure?\\nThere is no undo",
// "Select groups" => "Select groups",
// "Some of your groups have been automatically hidden.<br /> Select the groups below to assign permissions for" => "Some of your groups have been automatically hidden.<br /> Select the groups below to assign permissions for",
// "Select all" => "Select all",
// "Select features" => "Select features",
// "Some of your features have been automatically hidden.<br /> Select the features below to assign permissions for" => "Some of your features have been automatically hidden.<br /> Select the features below to assign permissions for",
// "Show permissions for disabled features" => "Show permissions for disabled features",
// "Feature name" => "Feature name",
// "Quick Permissions" => "Quick Permissions",
// "These permissions override any global permissions or category permissions affecting this object" => "These permissions override any global permissions or category permissions affecting this object",
// "To edit global permissions <a class=\"rbox-link\" href=\"tiki-objectpermissions.php?objectType=global\">click here</a>" => "To edit global permissions <a class=\"rbox-link\" href=\"tiki-objectpermissions.php?objectType=global\">click here</a>",
// "Assign Quick-Permissions to this object" => "Assign Quick-Permissions to this object",
// "A couple of userdefined permissions are currently assigned (See tab Assign Permissions)" => "A couple of userdefined permissions are currently assigned (See tab Assign Permissions)",
// "Your OpenID identity is valid" => "Your OpenID identity is valid",
// "However, no account is associated to the OpenID identifier" => "However, no account is associated to the OpenID identifier",
// "Create a new Tikiwiki account from OpenID" => "Create a new Tikiwiki account from OpenID",
// "Associate OpenID with an existing Tikiwiki account" => "Associate OpenID with an existing Tikiwiki account",
// "Your identity gives you access to multiple user accounts" => "Your identity gives you access to multiple user accounts",
// "Select account" => "Select account",
// "Make Structure" => "Make Structure",
// "{\$atts|@count} files attached" => "{\$atts|@count} files attached",
// "Preview of version" => "Preview of version",
// "(current)" => "(current)",
// "Rollback to this version" => "Rollback to this version",
// "Source of version" => "Source of version",
// "Updated from" => "Updated from",
// "Used to update" => "Used to update",
// "Update Translation" => "Update Translation",
// "Hide translation history" => "Hide translation history",
// "Show translation history" => "Show translation history",
// "File (only .gif, .jpg and .png images approximately 45px × 45px)" => "File (only .gif, .jpg and .png images approximately 45px × 45px)",
// "Plugin execution was denied" => "Plugin execution was denied",
// "Plugin execution pending approval" => "Plugin execution pending approval",
// "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected" => "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected",
// "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible" => "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible",
// "You are allowed to" => "You are allowed to",
// "View arguments" => "View arguments",
// "Execute the plugin in preview mode (may be dangerous)" => "Execute the plugin in preview mode (may be dangerous)",
// "Approve the plugin for public execution" => "Approve the plugin for public execution",
// "This plugin does not contain any arguments" => "This plugin does not contain any arguments",
// "This plugin's body is empty" => "This plugin's body is empty",
// "Any" => "Any",
// "Items found" => "Items found",
// "Rank" => "Rank",
// "Sum" => "Sum",
// "Plugin Approval" => "Plugin Approval",
// "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups" => "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups",
// "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins" => "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins",
// "This page lists the plugins that require validation, the first time they are encountered" => "This page lists the plugins that require validation, the first time they are encountered",
// "Each plugin contains a unique <em>signature</em> that is preserved" => "Each plugin contains a unique <em>signature</em> that is preserved",
// "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list" => "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list",
// "The plugin will automatically be added if it is encountered" => "The plugin will automatically be added if it is encountered",
// "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin" => "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin",
// "For security, you should review each plugin to ensure it is safe to approve" => "For security, you should review each plugin to ensure it is safe to approve",
// "Plugin" => "Plugin",
// "Added By" => "Added By",
// "Signature" => "Signature",
// "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "Approve all pending plugins" => "Approve all pending plugins",
// "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins" => "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins",
// "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe" => "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe",
// "No plugins pending approval" => "No plugins pending approval",
// "Poll Results" => "Poll Results",
// "Top Voted Polls" => "Top Voted Polls",
// "Edit Poll" => "Edit Poll",
// "Find the poll" => "Find the poll",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Vote range displayed" => "Vote range displayed",
// "All votes with no span consideration" => "All votes with no span consideration",
// "All votes with span consideration" => "All votes with span consideration",
// "All votes" => "All votes",
// "List Votes" => "List Votes",
// "Permission denied. You do not have permission to read complete articles" => "Permission denied. You do not have permission to read complete articles",
// "Selected Structures" => "Selected Structures",
// "Add Structure" => "Add Structure",
// "No structures" => "No structures",
// "Add Pages" => "Add Pages",
// "No pages" => "No pages",
// "Add Pages from Structures" => "Add Pages from Structures",
// "Add Structure Pages" => "Add Structure Pages",
// "Selected Pages" => "Selected Pages",
// "No pages selected" => "No pages selected",
// "P/F" => "P/F",
// "star" => "star",
// "half star" => "half star",
// "Send a link" => "Send a link",
// "Received Pages" => "Received Pages",
// "Edit Received Page" => "Edit Received Page",
// "The highlight pages already exist" => "The highlight pages already exist",
// "Please, change the name if you want the page to be uploaded" => "Please, change the name if you want the page to be uploaded",
// "Received Structures" => "Received Structures",
// "Prefix the checked" => "Prefix the checked",
// "Postfix the checked" => "Postfix the checked",
// "Use your email as login" => "Use your email as login",
// "Minimum {\$prefs.min_username_length} characters long" => "Minimum {\$prefs.min_username_length} characters long",
// "Passcode to register" => "Passcode to register",
// "Not your password" => "Not your password",
// "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\t\t\t\t\t\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}" => "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\t\t\t\t\t\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}",
// "Generate a\tpassword" => "Generate a\tpassword",
// "Select your group" => "Select your group",
// "Make sure to whitelist this domain to prevent registration emails being canned by your spam filter" => "Make sure to whitelist this domain to prevent registration emails being canned by your spam filter",
// "Enter your username or email" => "Enter your username or email",
// "Enter your email" => "Enter your email",
// "Request Password Reset" => "Request Password Reset",
// "Back to page" => "Back to page",
// "to version" => "to version",
// "Date Search" => "Date Search",
// "All dates" => "All dates",
// "Calendar Items" => "Calendar Items",
// "octets" => "octets",
// "Data HTML" => "Data HTML",
// "Data Txt" => "Data Txt",
// "Attached Files" => "Attached Files",
// "To add a file, click here" => "To add a file, click here",
// "Reply To Email" => "Reply To Email",
// "if not" => "if not",
// "Save as Draft" => "Save as Draft",
// "Save your changes" => "Save your changes",
// "Save any changes and send to all subscribers" => "Save any changes and send to all subscribers",
// "Send a structure" => "Send a structure",
// "Ex: http://tikiwiki.org or localhost" => "Ex: http://tikiwiki.org or localhost",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "This is the staging copy of" => "This is the staging copy of",
// "the approved version of this page" => "the approved version of this page",
// "Viewing of changes since last approval is possible only after first approval" => "Viewing of changes since last approval is possible only after first approval",
// "Approve changes" => "Approve changes",
// "Latest changes will be synchronized after approval" => "Latest changes will be synchronized after approval",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time" => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time",
// "Content may be out of date" => "Content may be out of date",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages",
// "TOC" => "TOC",
// "This text was automatically translated by Google Translate from the following page: " => "This text was automatically translated by Google Translate from the following page: ",
// "page: %0/%1" => "page: %0/%1",
// "Last edited by" => "Last edited by",
// "based on work by" => "based on work by",
// "Contributors to this page" => "Contributors to this page",
// "Page last modified on %0 by %1" => "Page last modified on %0 by %1",
// "Created by %0" => "Created by %0",
// "Last Modification: %0 by %1" => "Last Modification: %0 by %1",
// "You will not see the latest queries" => "You will not see the latest queries",
// "Clean" => "Clean",
// "Params" => "Params",
// "Total replies" => "Total replies",
// "Average number of replies per topic" => "Average number of replies per topic",
// "FAQ Stats" => "FAQ Stats",
// "Most viewed objects in period" => "Most viewed objects in period",
// "Clean logs older than" => "Clean logs older than",
// "months" => "months",
// "Send a link to a friend" => "Send a link to a friend",
// "The link was sent to the following addresses" => "The link was sent to the following addresses",
// "Friend's email" => "Friend's email",
// "Separate multiple email addresses with a comma" => "Separate multiple email addresses with a comma",
// "Your name" => "Your name",
// "Your email" => "Your email",
// "I found an interesting page that I thought you would like" => "I found an interesting page that I thought you would like",
// "TikiTests Edit" => "TikiTests Edit",
// "Summary mode" => "Summary mode",
// "Show Page Differences" => "Show Page Differences",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Show POST Data" => "Show POST Data",
// "Use Current Session/Logout" => "Use Current Session/Logout",
// "Recorded Links" => "Recorded Links",
// "Request" => "Request",
// "Element to compare (Xpath expression)" => "Element to compare (Xpath expression)",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "Delete this link" => "Delete this link",
// "TikiTests List" => "TikiTests List",
// "Config" => "Config",
// "Replay" => "Replay",
// "Tidy extension not present" => "Tidy extension not present",
// "PECL HTTP extension present" => "PECL HTTP extension present",
// "cURL extension present" => "cURL extension present",
// "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible" => "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible",
// "List TikiTests" => "List TikiTests",
// "Create a TikiTest" => "Create a TikiTest",
// "Replay the TikiTest" => "Replay the TikiTest",
// "Edit the TikiTest" => "Edit the TikiTest",
// "TikiTests Record Configuration" => "TikiTests Record Configuration",
// "Start Recording Test" => "Start Recording Test",
// "TikiTests Replay Configuration" => "TikiTests Replay Configuration",
// "Failure" => "Failure",
// "Reference" => "Reference",
// "The pages are different" => "The pages are different",
// "The pages are identical" => "The pages are identical",
// "Recording to pause press the pause button" => "Recording to pause press the pause button",
// "Pause the recording" => "Pause the recording",
// "Paused to resume press the play button" => "Paused to resume press the play button",
// "Resume the recording" => "Resume the recording",
// "Stop the recording" => "Stop the recording",
// "Theme Control Center: Categories" => "Theme Control Center: Categories",
// "Theme Control Center: Sections" => "Theme Control Center: Sections",
// "Edit File" => "Edit File",
// "Advanced mode" => "Advanced mode",
// "Retry" => "Retry",
// "The following files have been successfully uploaded" => "The following files have been successfully uploaded",
// "You can link to the file from a Wiki page using" => "You can link to the file from a Wiki page using",
// "You can display an image in a Wiki page using" => "You can display an image in a Wiki page using",
// "Or using as a thumbnail with ShadowBox" => "Or using as a thumbnail with ShadowBox",
// "You can link to the file from an HTML page using" => "You can link to the file from an HTML page using",
// "You locked the file" => "You locked the file",
// "The file is locked by {\$fileInfo.lockedby}" => "The file is locked by {\$fileInfo.lockedby}",
// "File title" => "File title",
// "required field for podcasts" => "required field for podcasts",
// "File description" => "File description",
// "Unzip zip files" => "Unzip zip files",
// "Author, if different from the Creator" => "Author, if different from the Creator",
// "Maximum number of downloads" => "Maximum number of downloads",
// "Add File" => "Add File",
// "Maximum file size is around" => "Maximum file size is around",
// "Uploading file.." => "Uploading file..",
// "No File to Upload.." => "No File to Upload..",
// " Syntax tips" => " Syntax tips",
// "Link to file from a Wiki page" => "Link to file from a Wiki page",
// "For image files" => "For image files",
// "To display in a Wiki page" => "To display in a Wiki page",
// "Display thumbnail that enlarges" => "Display thumbnail that enlarges",
// "No gallery available" => "No gallery available",
// "The column is disabled" => "The column is disabled",
// "a folder" => "a folder",
// "a bookmark" => "a bookmark",
// "User Contacts Preferences" => "User Contacts Preferences",
// "Default view" => "Default view",
// "Manage Fields" => "Manage Fields",
// "Basic Data" => "Basic Data",
// "User Icon" => "User Icon",
// "(non public)" => "(non public)",
// "This user is your friend " => "This user is your friend ",
// "The user requested friendship with you" => "The user requested friendship with you",
// "Accept friendship from this user" => "Accept friendship from this user",
// "Refuse friendship from this user" => "Refuse friendship from this user",
// "Currently waiting for user approval" => "Currently waiting for user approval",
// "Cancel friendship request towards this user" => "Cancel friendship request towards this user",
// "Additional Information" => "Additional Information",
// "User Contribution" => "User Contribution",
// "has contributed to the following content" => "has contributed to the following content",
// "has not contributed to any content yet" => "has not contributed to any content yet",
// "Forum comments" => "Forum comments",
// "Send Me A Message" => "Send Me A Message",
// "Send me a message " => "Send me a message ",
// "The following message will be sent to user" => "The following message will be sent to user",
// "Message Body" => "Message Body",
// "Toggle" => "Toggle",
// "Toggle options" => "Toggle options",
// "Male" => "Male",
// "Female" => "Female",
// "Your preferred language" => "Your preferred language",
// "Can you read more languages" => "Can you read more languages",
// "Other languages you can read (select on the left to add to the list on the right)" => "Other languages you can read (select on the left to add to the list on the right)",
// "Select language.." => "Select language..",
// "Display info tooltip on mouseover for every user who allows his/her information to be public" => "Display info tooltip on mouseover for every user who allows his/her information to be public",
// "My user items" => "My user items",
// "My level" => "My level",
// "Account Deletion" => "Account Deletion",
// "Are you really sure you want to delete your account " => "Are you really sure you want to delete your account ",
// "Check this box if you really want to delete your account" => "Check this box if you really want to delete your account",
// "Delete my account" => "Delete my account",
// "Accepted User and Creator" => "Accepted User and Creator",
// "Not Accepted User" => "Not Accepted User",
// "Marked as deleted" => "Marked as deleted",
// "User Watches and preferences" => "User Watches and preferences",
// "You need to set your email to receive email notifications" => "You need to set your email to receive email notifications",
// "Report Preferences" => "Report Preferences",
// "You are not allowed to remove this notification " => "You are not allowed to remove this notification ",
// "Use reports to summarise notifications about objects you are watching" => "Use reports to summarise notifications about objects you are watching",
// "Use reports" => "Use reports",
// "Interval in witch you want to get the reports" => "Interval in witch you want to get the reports",
// "Short report" => "Short report",
// "Detailed report" => "Detailed report",
// "HTML-Email" => "HTML-Email",
// "Send me an email also if nothing happened" => "Send me an email also if nothing happened",
// "Reports are disabled, only standard reporting is available" => "Reports are disabled, only standard reporting is available",
// "Sites you are watching" => "Sites you are watching",
// "Use \"watches\" to monitor wiki pages or other objects" => "Use \"watches\" to monitor wiki pages or other objects",
// "Watch new items by clicking the {icon _id=eye} button on specific pages" => "Watch new items by clicking the {icon _id=eye} button on specific pages",
// "Select event type" => "Select event type",
// "All watched events" => "All watched events",
// "A user edited an article" => "A user edited an article",
// "A user deleted an article" => "A user deleted an article",
// "A user submits a blog post" => "A user submits a blog post",
// "A user posts a forum thread" => "A user posts a forum thread",
// "A user posts a forum topic" => "A user posts a forum topic",
// "A user edited a wiki page" => "A user edited a wiki page",
// "A user created a wiki page in a language" => "A user created a wiki page in a language",
// "A user edits an article" => "A user edits an article",
// "A user deletes an article" => "A user deletes an article",
// "Used space" => "Used space",
// "up to" => "up to",
// "no limit for admin" => "no limit for admin",
// "No articles yet" => "No articles yet",
// "Add an article" => "Add an article",
// "There are no questions in this FAQ" => "There are no questions in this FAQ",
// "Manage Message Queue" => "Manage Message Queue",
// "Manage Reported Messages" => "Manage Reported Messages",
// "Monitor Topics of this Forum" => "Monitor Topics of this Forum",
// "Stop Monitoring Topics of this Forum" => "Stop Monitoring Topics of this Forum",
// "Monitor Topics and Threads of this Forum" => "Monitor Topics and Threads of this Forum",
// "Stop Monitoring Topics and Threads of this Forum" => "Stop Monitoring Topics and Threads of this Forum",
// "Group Monitor Topics of this Forum" => "Group Monitor Topics of this Forum",
// "Group Monitor Topics and Threads of this Forum" => "Group Monitor Topics and Threads of this Forum",
// "Editing" => "Editing",
// "Post New" => "Post New",
// "Watch for replies" => "Watch for replies",
// "Send me an e-mail when someone replies to my topic" => "Send me an e-mail when someone replies to my topic",
// "Don't send me any e-mails" => "Don't send me any e-mails",
// "Editing posts" => "Editing posts",
// "Forum Lock" => "Forum Lock",
// "Unarchive" => "Unarchive",
// "posts in this forum" => "posts in this forum",
// "Filter Posts" => "Filter Posts",
// "Posts Filtering" => "Posts Filtering",
// "Last post date" => "Last post date",
// "Show archived posts" => "Show archived posts",
// "Containing posts by" => "Containing posts by",
// "Me" => "Me",
// "Posts with no replies" => "Posts with no replies",
// "Archived" => "Archived",
// "Topic List" => "Topic List",
// "The post has been reported and will be reviewed by a moderator" => "The post has been reported and will be reviewed by a moderator",
// "Print this page only" => "Print this page only",
// "Print all pages" => "Print all pages",
// "Stop Monitor" => "Stop Monitor",
// "Tracker Items" => "Tracker Items",
// "Pending" => "Pending",
// "Tracker Item" => "Tracker Item",
// "Edit/Delete" => "Edit/Delete",
// "Add a new" => "Add a new",
// "Edit this" => "Edit this",
// " mail account" => " mail account",
// "Incoming servers (used in this order)" => "Incoming servers (used in this order)",
// "IMAP server" => "IMAP server",
// "Mbox filepath" => "Mbox filepath",
// "Maildir mail directory" => "Maildir mail directory",
// "Use SSL" => "Use SSL",
// "Outgoing server" => "Outgoing server",
// "Account details" => "Account details",
// "Group (shared mail inbox) or private" => "Group (shared mail inbox) or private",
// "This will be a group mail account" => "This will be a group mail account",
// "This will be a personal mail account" => "This will be a personal mail account",
// "Auto-refresh page time" => "Auto-refresh page time",
// "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission" => "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission",
// "Personal e-mail accounts" => "Personal e-mail accounts",
// "This is the active account" => "This is the active account",
// "IMAP" => "IMAP",
// "Mbox" => "Mbox",
// "Maildir" => "Maildir",
// "POP3" => "POP3",
// "Group e-mail accounts" => "Group e-mail accounts",
// "Show Unread" => "Show Unread",
// "Show Flagged" => "Show Flagged",
// "Auto refresh set for every \$autoRefresh seconds" => "Auto refresh set for every \$autoRefresh seconds",
// "Refresh now" => "Refresh now",
// "Group messages" => "Group messages",
// "unFlagged" => "unFlagged",
// "Part" => "Part",
// "page id" => "page id",
// "View edit icons" => "View edit icons",
// "Group Monitor on Structure" => "Group Monitor on Structure",
// "Jump to Content" => "Jump to Content",
// "Fullscreen" => "Fullscreen",
// "Cancel Fullscreen" => "Cancel Fullscreen",
// "Show/Hide Left Column" => "Show/Hide Left Column",
// "Show/Hide Right Column" => "Show/Hide Right Column",
// "Latitude" => "Latitude",
// "Longitude" => "Longitude",
// "Remove Image" => "Remove Image",
// "Word Limit Exceeded" => "Word Limit Exceeded",
// "Character Limit Exceeded" => "Character Limit Exceeded",
// "Character Count" => "Character Count",
// "Word Count" => "Word Count",
// "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator" => "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator",
// "Number of votes" => "Number of votes",
// "Your rating" => "Your rating",
// "You did not vote yet" => "You did not vote yet",
// "My rating" => "My rating",
// "Click to vote for this value" => "Click to vote for this value",
// "Clik to delete your vote" => "Clik to delete your vote",
// "You have ever subscribed" => "You have ever subscribed",
// "You have not yet subscribed" => "You have not yet subscribed",
// "friends" => "friends",
// "Unsubscribe" => "Unsubscribe",
// "Google Maps is not enabled" => "Google Maps is not enabled",
// "The main text of this page is available in the following languages" => "The main text of this page is available in the following languages",
// "Use this thread to discuss the page" => "Use this thread to discuss the page",
// "Missing or incorrect trackerId parameter for the plugin" => "Missing or incorrect trackerId parameter for the plugin",
// "list" => "list",
// "Email address the person you want to invite" => "Email address the person you want to invite",
// "Set in these groups" => "Set in these groups",
// "Leave" => "Leave",
// "Undecided" => "Undecided",
// "Last Day" => "Last Day",
// "Last Week" => "Last Week",
// "Last Month" => "Last Month",
// "Last Year" => "Last Year",
// "Your default group" => "Your default group",
// "Change default group" => "Change default group",
// "Subscribe to a group" => "Subscribe to a group",
// "Toggle display" => "Toggle display",
// "Creator &amp; Last Editor" => "Creator &amp; Last Editor",
// "Save the page as a partial translation" => "Save the page as a partial translation",
// "Partial Translation" => "Partial Translation",
// "Save the page as a completed translation" => "Save the page as a completed translation",
// "Complete Translation" => "Complete Translation",
// "Save the page, but do not send notifications and do not count it as new content to be translated" => "Save the page, but do not send notifications and do not count it as new content to be translated",
// "Save the page as a draft" => "Save the page as a draft",
// "Save Draft" => "Save Draft",
// "Permission denied you cannot view the Tiki calendar" => "Permission denied you cannot view the Tiki calendar",
// "%0 enabled" => "%0 enabled",
// "%0 disabled" => "%0 disabled",
// "%0 set" => "%0 set",
// "%0 unset" => "%0 unset",
// "Help on Configuration Sections" => "Help on Configuration Sections",
// "Current version is up to date : <b>%0</b>" => "Current version is up to date : <b>%0</b>",
// "A new major release branch is available" => "A new major release branch is available",
// "A new %0 major release branch is available" => "A new %0 major release branch is available",
// "Wiki Attachments" => "Wiki Attachments",
// "Feeds settings" => "Feeds settings",
// "Freetags settings" => "Freetags settings",
// "Customize look and feel of your Tiki" => "Customize look and feel of your Tiki",
// "Text area" => "Text area",
// "Configure Site Ads and Banners" => "Configure Site Ads and Banners",
// "Kaltura settings" => "Kaltura settings",
// "Help on \$admintitle Config" => "Help on \$admintitle Config",
// "Must specify actionId" => "Must specify actionId",
// "Users Contributions: Addition" => "Users Contributions: Addition",
// "%s Contributions: Addition" => "%s Contributions: Addition",
// "Users Contributions: Suppression" => "Users Contributions: Suppression",
// "%s Contributions: Suppression" => "%s Contributions: Suppression",
// "Total Contributions Addition per Day" => "Total Contributions Addition per Day",
// "Total Contributions Addition per Week" => "Total Contributions Addition per Week",
// "Total Contributions Suppression per Day" => "Total Contributions Suppression per Day",
// "Total Contributions Suppression per Week" => "Total Contributions Suppression per Week",
// "Total Contributions: Addition" => "Total Contributions: Addition",
// "Total Contributions: Suppression" => "Total Contributions: Suppression",
// "Groups Contributions: Addition" => "Groups Contributions: Addition",
// "Groups Contributions: Suppression" => "Groups Contributions: Suppression",
// "white" => "white",
// "gray" => "gray",
// "silver" => "silver",
// "ivory" => "ivory",
// "whitesmoke" => "whitesmoke",
// "beige" => "beige",
// "darkgrey" => "darkgrey",
// "Object doesn't exists" => "Object doesn't exists",
// "Click here to delete the category" => "Click here to delete the category",
// "You can not create a category with a name already existing at this level" => "You can not create a category with a name already existing at this level",
// "The file does not have the required header" => "The file does not have the required header",
// "Category can`t be parent of itself" => "Category can`t be parent of itself",
// "No display" => "No display",
// "You must specify a directory" => "You must specify a directory",
// "moved %d images, %d errors occured" => "moved %d images, %d errors occured",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Test Image" => "Test Image",
// "You cannot have a blank password" => "You cannot have a blank password",
// "Path to mapfiles is invalid" => "Path to mapfiles is invalid",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "Error opening uploaded file" => "Error opening uploaded file",
// "A comment in a wiki page is posted or edited" => "A comment in a wiki page is posted or edited",
// "You need to provide a username or an email" => "You need to provide a username or an email",
// "The list name must be specified" => "The list name must be specified",
// "Sorry, your list could not be added. Please check that it doesn\\'t already exist" => "Sorry, your list could not be added. Please check that it doesn\\'t already exist",
// "Sorry, your list could not be updated. Please check that it already exists" => "Sorry, your list could not be updated. Please check that it already exists",
// "off" => "off",
// "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html" => "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html",
// "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement" => "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement",
// "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory" => "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory",
// "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts" => "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts",
// "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)" => "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)",
// "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users" => "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users",
// "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users" => "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users",
// "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands" => "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous" => "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous",
// "This is a modified File. Cannot check version. Check if it is dangerous" => "This is a modified File. Cannot check version. Check if it is dangerous",
// "This file is from another Tikiwiki version: " => "This file is from another Tikiwiki version: ",
// "Are you sure you want to delete this custom tool" => "Are you sure you want to delete this custom tool",
// "JavaScript is required for this page" => "JavaScript is required for this page",
// "Are you sure you want to remove this topic" => "Are you sure you want to remove this topic",
// "Are you sure you want to remove this topic AND all the articles related" => "Are you sure you want to remove this topic AND all the articles related",
// "Tracker does not allow attachments" => "Tracker does not allow attachments",
// "Remove group: " => "Remove group: ",
// "Remove permission: %s on %s" => "Remove permission: %s on %s",
// "Group name can not be empty" => "Group name can not be empty",
// "The description is mandatory as it is used as mail subject" => "The description is mandatory as it is used as mail subject",
// "Invalid or unknown email" => "Invalid or unknown email",
// "User login or email is required" => "User login or email is required",
// "User does not exist on master" => "User does not exist on master",
// "Email validation requested but email address not set" => "Email validation requested but email address not set",
// "Password not set" => "Password not set",
// "User login contains invalid characters" => "User login contains invalid characters",
// "Deleted account %s" => "Deleted account %s",
// "%s %s assigned to %s %s" => "%s %s assigned to %s %s",
// "group %s set as the default group of user %s" => "group %s set as the default group of user %s",
// "Login contains invalid characters" => "Login contains invalid characters",
// "approved by " => "approved by ",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Permission denied you cannot approve staging pages" => "Permission denied you cannot approve staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "Unassign perm %s from group %s" => "Unassign perm %s from group %s",
// "Image Galleries Admin Panel" => "Image Galleries Admin Panel",
// "Could not read image %s" => "Could not read image %s",
// "Image %s upload failed" => "Image %s upload failed",
// "Image %s uploaded successfully" => "Image %s uploaded successfully",
// "Image %s removed from Batch directory" => "Image %s removed from Batch directory",
// "Impossible to remove image %s from Batch directory" => "Impossible to remove image %s from Batch directory",
// "Permission denied you cannot use the batch directory loading" => "Permission denied you cannot use the batch directory loading",
// "Incorrect directory chosen for batch upload of images" => "Incorrect directory chosen for batch upload of images",
// "Please setup that dir on " => "Please setup that dir on ",
// "Please contact the website administrator" => "Please contact the website administrator",
// "File Galleries Admin Panel" => "File Galleries Admin Panel",
// "Could not read file %s" => "Could not read file %s",
// "Could not write to file %s" => "Could not write to file %s",
// "File %s upload failed" => "File %s upload failed",
// "Upload was successful" => "Upload was successful",
// "File %s removed from Batch directory" => "File %s removed from Batch directory",
// "Impossible to remove file %s from Batch directory" => "Impossible to remove file %s from Batch directory",
// "Incorrect directory chosen for batch upload of files" => "Incorrect directory chosen for batch upload of files",
// "Last modifications to the blog" => "Last modifications to the blog",
// "Nothing tagged yet" => "Nothing tagged yet",
// "You must clear your browser cache" => "You must clear your browser cache",
// "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>" => "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>",
// "Calendar event : " => "Calendar event : ",
// "Permission denied you can not view this page" => "Permission denied you can not view this page",
// "Mo" => "Mo",
// "Tu" => "Tu",
// "We" => "We",
// "Th" => "Th",
// "Fr" => "Fr",
// "Sa" => "Sa",
// "Su" => "Su",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "Invalid username or activation code. Maybe this code has already been used" => "Invalid username or activation code. Maybe this code has already been used",
// "Invalid old password or unknown user" => "Invalid old password or unknown user",
// "Invalid request. Expecting channels array" => "Invalid request. Expecting channels array",
// "Missing channel name" => "Missing channel name",
// "Authentication required" => "Authentication required",
// "One of the requested channels cannot be requested. It does not exist or permission is denied" => "One of the requested channels cannot be requested. It does not exist or permission is denied",
// "One of the install profiles could not be obtained" => "One of the install profiles could not be obtained",
// "This feature is disabled'.\$prefs['validateUsers']));\n\t\$smarty->display('error.tpl" => "This feature is disabled'.\$prefs['validateUsers']));\n\t\$smarty->display('error.tpl",
// "Problem. Try to log in again to receive new confirmation instructions" => "Problem. Try to log in again to receive new confirmation instructions",
// "ERROR: you must include a subject or a message. You must also make sure to have a valid e-mail in the FROM field" => "ERROR: you must include a subject or a message. You must also make sure to have a valid e-mail in the FROM field",
// "Last sites of directory \" . \$rc[\"name\"] . \" " => "Last sites of directory \" . \$rc[\"name\"] . \" ",
// "You cannot download this file right now. Your score is low or file limit was reached" => "You cannot download this file right now. Your score is low or file limit was reached",
// "Error : The file %s doesn't exist" => "Error : The file %s doesn't exist",
// "Page is a staging copy. Translation must begin from the approved copy" => "Page is a staging copy. Translation must begin from the approved copy",
// "Translation of this page is incomplete" => "Translation of this page is incomplete",
// "Not enable for this type of object" => "Not enable for this type of object",
// "Override lock and carry on with edit" => "Override lock and carry on with edit",
// "Page is currently being edited" => "Page is currently being edited",
// "This page is being edited by " => "This page is being edited by ",
// "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. ",
// "The file you selected is too large to upload" => "The file you selected is too large to upload",
// "Incorrect file extension was used for your 0gg screencast, expecting .ogg" => "Incorrect file extension was used for your 0gg screencast, expecting .ogg",
// "Page already exists. Go back and choose a different name" => "Page already exists. Go back and choose a different name",
// "The translation set already contains a page in this language" => "The translation set already contains a page in this language",
// "Remove archive: " => "Remove archive: ",
// "Remove file gallery: " => "Remove file gallery: ",
// "Form error - no import method selected for some reason" => "Form error - no import method selected for some reason",
// "Form error - no server-side filename entered for selected import method" => "Form error - no server-side filename entered for selected import method",
// "Last replied forum topics" => "Last replied forum topics",
// "Not supported yet" => "Not supported yet",
// "Canceled friendship request with %s" => "Canceled friendship request with %s",
// "I have refused your friendship request" => "I have refused your friendship request",
// "I have canceled my friendship request" => "I have canceled my friendship request",
// "Back to preferences" => "Back to preferences",
// "Back to item" => "Back to item",
// "No valid renderer found. GD or PDFLib required" => "No valid renderer found. GD or PDFLib required",
// "No sheet specified" => "No sheet specified",
// "You must select a renderer" => "You must select a renderer",
// "Invalid Series for current graphic" => "Invalid Series for current graphic",
// "Only the administrator can upload language files" => "Only the administrator can upload language files",
// "Operations executed successfully" => "Operations executed successfully",
// "Invalid software name" => "Invalid software name",
// "Page saved (version %d)" => "Page saved (version %d)",
// "You have requested that this page be machine translated" => "You have requested that this page be machine translated",
// "However, the Machine Translation feature is not enabled. Please enable this feature, or ask a site admin to do it" => "However, the Machine Translation feature is not enabled. Please enable this feature, or ask a site admin to do it",
// "Error writing in the databse: \$query" => "Error writing in the databse: \$query",
// "Permission denied: You cannot upload videos" => "Permission denied: You cannot upload videos",
// "You need to set your Kaltura account details: " => "You need to set your Kaltura account details: ",
// "Could not establish Kaltura session. Try again" => "Could not establish Kaltura session. Try again",
// "Permission denied: You cannot remix videos" => "Permission denied: You cannot remix videos",
// "Permission denied: You cannot change video version" => "Permission denied: You cannot change video version",
// "Permission denied: You cannot delete kaltura video" => "Permission denied: You cannot delete kaltura video",
// "Permission denied: You cannot download kaltura video" => "Permission denied: You cannot download kaltura video",
// "Permission denied: You cannot edit video information" => "Permission denied: You cannot edit video information",
// "Permission denied: You cannot view video" => "Permission denied: You cannot view video",
// "Delete comments" => "Delete comments",
// "Approved Status" => "Approved Status",
// "Queued" => "Queued",
// "The file is already locked by %s" => "The file is already locked by %s",
// "Remove file: " => "Remove file: ",
// "Quota too big" => "Quota too big",
// "Quota too small" => "Quota too small",
// "Warning: Empty file" => "Warning: Empty file",
// "Please re-upload your file" => "Please re-upload your file",
// "Permission denied you can edit this file" => "Permission denied you can edit this file",
// "Cannot read the file" => "Cannot read the file",
// "Upload was not successful. Duplicate file content" => "Upload was not successful. Duplicate file content",
// "File update was successful" => "File update was successful",
// "This gallery does not exist" => "This gallery does not exist",
// "Permission denied: You cannot view this page" => "Permission denied: You cannot view this page",
// "Invalid action" => "Invalid action",
// "Unable to contact remote server" => "Unable to contact remote server",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Unable to create login" => "Unable to create login",
// "More than %d unsuccessful login attempts have been made" => "More than %d unsuccessful login attempts have been made",
// "An email has been sent to you with the instructions to follow" => "An email has been sent to you with the instructions to follow",
// "Resend" => "Resend",
// "You should have received an email. Check your mailbox and your spam box.Otherwise click on the button to resend the email" => "You should have received an email. Check your mailbox and your spam box.Otherwise click on the button to resend the email",
// "Your default nickname is already in use. A new one has to be selected" => "Your default nickname is already in use. A new one has to be selected",
// "The selected account is not associated with your identity" => "The selected account is not associated with your identity",
// "unknown action" => "unknown action",
// "Authentication method is not OpenID" => "Authentication method is not OpenID",
// "Invalid password" => "Invalid password",
// "Account disabled" => "Account disabled",
// "You must use the right case for your user name" => "You must use the right case for your user name",
// "Feature Ajax Disabled. Please ask your site administrator to enable" => "Feature Ajax Disabled. Please ask your site administrator to enable",
// "You must first setup MapServer" => "You must first setup MapServer",
// "invalid mapfile name" => "invalid mapfile name",
// "An error as occured with the mapfile" => "An error as occured with the mapfile",
// "Please create a directory named ' . \$prefs['map_path'] . ' to hold your map files" => "Please create a directory named ' . \$prefs['map_path'] . ' to hold your map files",
// "map edit" => "map edit",
// "No page provided" => "No page provided",
// "Page \"%0\" does not exist" => "Page \"%0\" does not exist",
// "Are you sure you want to delete this note" => "Are you sure you want to delete this note",
// "Note not found" => "Note not found",
// "Permission denied you cannot assign permissions for this object" => "Permission denied you cannot assign permissions for this object",
// "Permission denied you cannot view the source of this page" => "Permission denied you cannot view the source of this page",
// "Missing object list type argument" => "Missing object list type argument",
// "Index" => "Index",
// "Index (' . \$code . " => "Index (' . \$code . ",
// "You are already logged in" => "You are already logged in",
// "You must choose a group" => "You must choose a group",
// "This is not a valid mail adress" => "This is not a valid mail adress",
// "Username cannot contain uppercase letters" => "Username cannot contain uppercase letters",
// "Username must be at least" => "Username must be at least",
// "Username cannot contain more than" => "Username cannot contain more than",
// "characters" => "characters",
// "Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "Please enter a valid %s.  No spaces, more than %d characters and contain %s",
// "Missing User Name" => "Missing User Name",
// "User Already Exists" => "User Already Exists",
// "Valid User Name" => "Valid User Name",
// "Missing Email" => "Missing Email",
// "Valid Email" => "Valid Email",
// "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password" => "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password",
// "The mail can't be sent. Contact the administrator" => "The mail can't be sent. Contact the administrator",
// "A password reminder email has been sent " => "A password reminder email has been sent ",
// "An email with a link to reset your password has been sent " => "An email with a link to reset your password has been sent ",
// "to the email" => "to the email",
// "You cannot rename staging pages. Please rename the approved page instead" => "You cannot rename staging pages. Please rename the approved page instead",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
// "Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS Feed Error Message: \$errmsg",
// "A problem occured during file uploading" => "A problem occured during file uploading",
// "File which was causing trouble was at rank" => "File which was causing trouble was at rank",
// "The error was" => "The error was",
// "invalid email" => "invalid email",
// "Notice: this variable may not be empty" => "Notice: this variable may not be empty",
// "Notice: invalid variable value" => "Notice: invalid variable value",
// "Permission denied you cannot remove this sheet" => "Permission denied you cannot remove this sheet",
// "You do not have permission to edit messages \$owner" => "You do not have permission to edit messages \$owner",
// "Clean the sql logs" => "Clean the sql logs",
// "Report to the webmaster" => "Report to the webmaster",
// "No trackerId specified" => "No trackerId specified",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "You must lock the file before editing it" => "You must lock the file before editing it",
// "Batch file processed" => "Batch file processed",
// "Incorrect file extension" => "Incorrect file extension",
// "Your screencast has been uploaded successfully" => "Your screencast has been uploaded successfully",
// "Your screencasts have been uploaded successfully" => "Your screencasts have been uploaded successfully",
// "Password has been changed" => "Password has been changed",
// "Invalid password. Your current password is required to change administrative information" => "Invalid password. Your current password is required to change administrative information",
// "A new page is created in a language" => "A new page is created in a language",
// "Language watch" => "Language watch",
// "Permission denied: you cannot view this blog post while it is marked private" => "Permission denied: you cannot view this blog post while it is marked private",
// "You must suggest a question; please try again" => "You must suggest a question; please try again",
// "Incorrect thread" => "Incorrect thread",
// "There are a problem connecting to that account" => "There are a problem connecting to that account",
// "There are a problem deleting that mail" => "There are a problem deleting that mail",
// "Mail ID" => "Mail ID",
// "There are a problem deleting mails" => "There are a problem deleting mails",
// "Are you sure you want to delete this account" => "Are you sure you want to delete this account",
// "Taking" => "Taking",
// "Putting back" => "Putting back",
// "Checking" => "Checking",
// "Plugin modified by editor" => "Plugin modified by editor",
// "Tidy Extension not present" => "Tidy Extension not present",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "The TikiTests Replay File has an error" => "The TikiTests Replay File has an error",
// "You are about to delete a TikiTest file, do you want to continue " => "You are about to delete a TikiTest file, do you want to continue ",
// "Error deleting the file" => "Error deleting the file",
// "TikiTest List" => "TikiTest List",
// "TikiTest Record" => "TikiTest Record",
// "You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "You need one of the extension pecl HTTP or Curl to replay the TikiTest",
// "The TikiTest Replay File is Empty" => "The TikiTest Replay File is Empty",
// "TikiTest Replay" => "TikiTest Replay",
// "The page is empty" => "The page is empty",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"El Salvador" => "El Salvador",
"Federated States of Micronesia" => "Federated States of Micronesia",
"tracker" => "tracker",
"faq" => "faq",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"Tracker" => "Tracker",
"(AT)" => "(AT)",
"(DOT)" => "(DOT)",
"%" => "%",
"Pop-up" => "Pop-up",
"Your account request has been stored and will be activated by the admin as soon as possible." => "Your account request has been stored and will be activated by the admin as soon as possible.",
"LDAP" => "LDAP",
"PAM" => "PAM",
"Regex" => "Regex",
"Test file from repository to generate preview for (empty = configured start page)" => "Test file from repository to generate preview for (empty = configured start page)",
"RSS" => "RSS",
"popup" => "popup",
"+" => "+",
"%m/%d" => "%m/%d",
"Try to convert HTML to wiki" => "Try to convert HTML to wiki",
"tikiwiki.org" => "tikiwiki.org",
"%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
"%H:%M %Z" => "%H:%M %Z",
"tiki-mobile.php" => "tiki-mobile.php",
"unicode" => "unicode",
"Public for group" => "Public for group",
"very low" => "very low",
"low" => "low",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "اين خصلت غيرفعال است",
"Permission denied. You cannot view pages" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد صفحات را ببينيد",
"Re:" => "در پاسخ به:",
"This script cannot be called directly" => "اين دستخط(script) نمي‌تواند مستقيما فراخواني شود",
"The copyright management feature is not enabled." => "خصيصه‌ي مديريت حق انحصاري چاپ(copyright) فعال نيست.",
"No page indicated" => "هيچ صفحه‌اي انتخاب نشده است.",
"You must supply all the information, including title and year." => "بايد تمام اطلاعات را فراهم كنيد، اين اطلاعات شامل سال و عنوان نيز هستند.",
"You do not have permission to use this feature" => "متاسفانه نمي‌توانيد از اين خصيصه استفاده كنيد.",
"This feature is for admins only" => "اين خصيصه تنها براي سرپرستان است",
"ID" => "شناسه",
"Type" => "گونه:",
"Name" => "نام",
"Description" => "شرح",
"Size" => "حجم",
"Created" => "ايجاد شده در:",
"Last Modified" => "آخرين تغيير",
"Creator" => "ايجاد كننده",
"Author" => "مؤلف",
"Comment" => "نظر",
"Files" => "پرونده‌ها",
"Hits" => "ضربت‌ها(Hits)",
"Locked by" => "قفل شده به‌وسيله‌ي",
"Path" => "مسير",
"Algeria" => "الجزاير",
"American Samoa" => "ساموآي آمريكايي",
"Angola" => "آنگولا",
"Antigua" => "آنتيگا",
"Argentina" => "آرژانتين",
"Armenia" => "ارمنستان",
"Australia" => "استراليا",
"Austria" => "اتريش",
"Bahamas" => "باهاماس",
"Bahrain" => "بحرين",
"Bangladesh" => "بنگلادش",
"Barbados" => "باربادوس",
"Belarus" => "بلاروس",
"Belgium" => "بلژيك",
"Bermuda" => "برمودا",
"Bolivia" => "بوليوي",
"Brazil" => "برزيل",
"Brunei" => "برونئي",
"Canada" => "كانادا",
"Cayman Islands" => "جزاير كايمن",
"Chile" => "شيلي",
"China" => "چين",
"Colombia" => "كلمبيا",
"Cook Islands" => "جزاير كوك",
"Costa Rica" => "كاستاريكا",
"Croatia" => "كرواسي",
"Cuba" => "كوبا",
"Cyprus" => "قبرس",
"Czech Republic" => "جمهوري چك",
"Denmark" => "دانمارك",
"Dominican Republic" => "جمهوري دمنيكن",
"Ecuador" => "اكوادور",
"Egypt" => "مصر",
"Estonia" => "استووني",
"Fiji" => "جزاير فيجي",
"Finland" => "فنلاند",
"France" => "فرانسه",
"French Polynesia" => "پلینزی فرانسه",
"Germany" => "آلمان",
"Greece" => "يونان",
"Guam" => "گوآم",
"Guatemala" => "گوانتانامو",
"Haiti" => "هائیتی",
"Honduras" => "هندوراس",
"Hungary" => "مجارستان",
"Iceland" => "ايسلند",
"India" => "هند",
"Indonesia" => "اندونزي",
"Iran" => " ايران (جمهوري اسلامي)",
"Iraq" => "عراق",
"Ireland" => "ايرلند",
"Israel" => "فلستين اشغالي",
"Italy" => "ايتاليا",
"Ivory Coast" => "ساحل عاج",
"Jamaica" => "جامائيكا",
"Japan" => "ژاپن",
"Jordan" => "اردن",
"Kazakstan" => "قزاقستان",
"Kenya" => "كنيا",
"Kiribati" => "كريباتي",
"Kuwait" => "كويت",
"Latvia" => "لتوني",
"Lebanon" => "لبنان",
"Lithuania" => "ليتواني",
"Luxemburg" => "لوكرامبورگ",
"Malawi" => "مالاوی",
"Malaysia" => "مالزي",
"Malta" => "مالت",
"Marshall Islands" => "جزاير مارشال",
"Mauritius" => "موريس",
"Mexico" => "مكزيك",
"Morocco" => "مراكش",
"Mozambique" => "موزامبيك",
"Nauru" => "ناورو",
"Nepal" => "نپال",
"Netherlands" => "هلند",
"New Caledonia" => "اسكاتلند جديد",
"New Zealand" => "زلاند نو",
"Nicaragua" => "نيكاراگوئه",
"Nigeria" => "نيجريه",
"Niue" => "نیووی",
"None" => "هيچ‌كدام",
"Norway" => "نروژ",
"Other" => "ساير",
"Pakistan" => "پاكستان",
"Panama" => "پاناما",
"Papua New Guinea" => "پاپوآ گینه نو",
"Paraguay" => "پاراگوئه",
"Peru" => "پرو",
"Poland" => "لهستان",
"Portugal" => "پرتقال",
"Puerto Rico" => "پورتوریکو",
"Quatar" => "قطر",
"Romania" => "روماني",
"Russia" => "روسيه",
"Samoa" => "ساموآ",
"Saudi Arabia" => "عربستان صعنودي",
"Singapore" => "سنگاپور",
"Slovakia" => "اسلواكي",
"Slovenia" => "اسلوني",
"Solomon Islands" => "جزاير سليمان",
"Somalia" => "سومالي",
"South Africa" => "آفريقاي جنوبي",
"South Korea" => "كره‌ي جنوبي",
"Spain" => "اسپانيا",
"Sri Lanka" => "سريلانكا",
"St Vincent Grenadines" => "سنت وينسنت و گرانادينز",
"Surinam" => "سورينام",
"Sweden" => "سوئد",
"Switzerland" => "سوئيس",
"Taiwan" => "تايوان",
"Thailand" => "تايلند",
"Tonga" => "تانگو",
"Trinidad Tobago" => "تريناداد و توباگو",
"Turkey" => "تركيه",
"Tuvalu" => "تووالو",
"Ukraine" => "اوكراين",
"United Arab Emirates" => "امارات متحده عربي",
"United Kingdom" => "انگلستان",
"United States" => "ايالات متحده آمريكا",
"Uruguay" => "اروگوئه",
"Vanuatu" => "فانواتو",
"Venezuela" => "ونزوئلا",
"Wales" => "ولز",
"Yugoslavia" => "يوگوسلاوي",
"Zambia" => "زامبيا",
"Zimbabwe" => "زيمباوه",
"Arabic" => "عربي",
"Catalan" => "كاتالان",
"Simplified Chinese" => "چيني ساده‌شده",
"Chinese" => "چيني",
"Czech" => "چك",
"Danish" => "دانماركي",
"German" => "آلماني",
"English" => "انگليسي",
"English British" => "انگليسي(انگلستاني)",
"Spanish" => "اسپانايي",
"Greek" => "يواناني",
"French" => "فرانسوي",
"Hebrew" => "عبري",
"Croatian" => "كرواسيايي",
"Italian" => "ايتاليايي",
"Japanese" => "ژاپني",
"Korean" => "كره‌اي",
"Hungarian" => "مجارستاني",
"Dutch" => "هلندي",
"Norwegian" => "نروژي",
"Polish" => "لهستاني",
"Português" => "پرتقالي",
"Brazilian Portuguese" => "پرتقالي برزيلي",
"Russian" => "روسي",
"Slovak" => "اسواكي‌اي",
"Serbian" => "صربي",
"Serbian Latin" => "صربي لاتين",
"Swedish" => "سوئدي",
"Tuvaluan" => "تاوالان",
"Traditional Chinese" => "چيني سنتي",
"Ukrainian" => "اوكرايني",
"Permission denied" => "دسترسي غيرممكن",
"The file is not a CSV file or has not a correct syntax" => "اين پرونده، يك پرونده‌ي CSV نيست يا اشكالي در نحو آن وجود دارد",
"locked" => "قفل شده",
"locked by" => "قفل شده به‌وسيله‌ي",
"Administration:" => "مديريت:",
"in" => "ميان",
"continued" => "ادامه دارد",
"New Image Uploaded by" => "تصوير جديد، بارگذاري شده به‌وسيله‌ي:",
"New Subscriptions" => "اشتراك جديد",
"New Item in Tracker" => "يك فقره‌ي جديد در tracker",
"by" => "به‌وسيله‌ي",
"Wiki" => "ويكي",
"Image Gallery" => "سرسراي تصاوير",
"Articles" => "مقالات",
"Blogs" => "بلاگ‌ها",
"Forums" => "انجمن‌ها",
"Directory" => "پوشه",
"File Gallery" => "سرسراي پرونده",
"FAQs" => "سئوالات متداول",
"Quizzes" => "آزمون‌ها",
"Trackers" => "Trackerها",
"Survey" => "نظرسنجي",
"Newsletter" => "خبرنامه",
"article" => "مقاله",
"blog" => "بلاگ",
"directory" => "پوشه",
"forum" => " انجمن",
"image gallery" => "سرسراي تصوير",
"newsletter" => "خبرنامه",
"poll" => "راي‌گيري",
"quiz" => "آزمون",
"wiki page" => "صفحه‌ي ويكي",
"image" => "تصوير",
"calendar" => "تقويم",
"Invalid filename (using filters for filenames)" => "نام تصوير معتبر نيست (به دليل استفاده از فيلترها براي نام پرونده‌ها",
"Cannot upload this file - maximum upload size exceeded" => "حجم اين پرونده از حد مجاز بيشتري است. نمي‌توانم آن را بارگذاري كنم.",
"Anonymous" => "بي‌نام",
"Wrong password. Cannot post comment" => "كلمه‌ي عبور اشتباه است. نمي‌توانم نظر را الصاق كنم",
"You have to enter a title and text" => "شما بايد يك متن و عنوان وارد كنيد",
"WikiDiff::apply: line count mismatch: %s != %s" => "تغييرات ويكي::apply:تعداد خطوط همخواني ندارد:%s != %s",
"WikiDiff::_check: failed" => "تغييرات ويكي::_check:ناموق بود",
"WikiDiff::_check: edit sequence is non-optimal" => "تغييرات ويكي::_check: ترتيب ويرايش بهينه نيست.",
"WikiDiff Okay: LCS = %s" => "تغييرات ويكي صحيح است:LCS= %s",
"Line:" => "خط:",
"Lines:" => "خطوط:",
"Find" => "دنبال اين بگرد",
"find" => "بياب",
"prev" => "قبلي",
"Page" => "صفحه‌ي",
"next" => "بعدي",
"Link" => "پيوند",
"Page name" => "نام صفحه",
"File Galleries" => "سرسراهاي پرونده‌ها",
"Wiki Home" => "مبدا ويكي",
"Home" => "مبدا",
"Blog" => "بلاگ",
"previous page" => "صفحه‌ي قبل",
"next page" => "صفحه‌ي بعد",
"posted on" => "الصاق شده در",
"Continue" => "ادامه",
"By:" => "به‌وسيله‌ي:",
"Read" => "خوانده‌شده‌ها",
"List articles" => "فهرست مقالات",
"Last post" => "آخرين الصاق",
"Invalid imagename (using filters for filenames)" => "نام تصوير معتبر نيست (به دليل استفاده از فيلترها براي نام پرونده‌ها)",
"Errors detected" => "خطايي بوجود آمد",
"Upload was not successful" => "بارگذاري موفق نبود(Upload was not successful)",
"No image yet, sorry." => "متاسفم، هنوز هيچ تصويري وجود ندارد.",
"No valid ogr2ogr executable" => "ogr2ogr غيرقابل اجرا",
"Could not create \$tdo.mif in data directory" => "نمي‌توانم \$tdo.mif را در پوشه‌ي داده‌ها ايجاد كنم",
"Could not create \$tdo.mid in data directory" => "نمي‌توانم \$tdo.mid را در پوشه‌ي داده‌ها ايجاد كنم",
"unknown" => "ناشناخته",
"User Map Generated in:" => "نقشه‌ي كاربر توليد شده در:",
"Image Map Generated in:" => "تصوير كاربر ساخته شده در:",
"NONE" => "هيچكدام",
"File %s not found" => "پرونده‌ي %s يافت نشد",
"File %s is not a valid archive" => "پرونده‌ي %s يك بايگاني معتبر نيست",
"Impossible to open %s : %s" => "باز كردن %s غيرممكن است: %s",
"Language" => "زبان",
"Section" => "بخش",
"Theme" => "قيافه(Theme)",
"Rows" => "رديف",
"Users accept internal messages by default" => "به‌صورت پيش‌فرض، كاربران پيغام‌هاي داخلي را دريافت كنند",
"Users can opt-out internal messages" => "كاربران بتوانند پيغام‌هاي داخلي را دست‌چين كنند",
"Title" => "عنوان",
"Topic" => "موضوع",
"Visible" => "قابل رؤيت",
"Rating" => "رتبه‌بندي",
"Reads" => "تعداد دفعات مشاهده",
"Images" => "تصاوير",
"Newest first" => "ابتدا جديدترها",
"Oldest first" => "ابتدا قديمي‌ترها",
"Points" => "امتياز",
"Authentication method" => "نحوه‌ي تصديق هويت",
"Tiki and PAM" => "تيكي و PAM",
"CAS (Central Authentication Service)" => "خدمات تصديق هويت متمركز(CAS)",
"Web Server" => "سرور وب(Web Server)",
"Creation date (desc)" => "بر اساس تاريخ ايجاد (نزولي)",
"Last modification date (desc)" => "بر اساس آخرين تغيير (نزولي)",
"Blog title (asc)" => "عنوان بلاگ (صعودي)",
"Number of posts (desc)" => "تعداد الصاق‌ها (نزولي)",
"Visits (desc)" => "روئيت‌ها (نزولي)",
"Activity (desc)" => "فعاليت (نزولي)",
"Disabled" => "غيرفعال",
"Plain text" => "متن ساده",
"Link to user information" => "متصل به اطلاعات كاربر",
"User avatar" => "شكلك كاربر",
"Contact user" => "كاربر مورد تماس",
"Count admin pageviews" => "مشاهده‌ي صفحات سرپرست را بشمار",
"default mapfile" => "پرونده‌ي نقشه پيش‌فرض",
"Validate URLs" => "URLها را تاييد اعتبار كن",
"Links per page" => "پيوندها در هر صفحه",
"Method to open directory links" => "روش باز كردن پيوندهاي پوشه‌ها",
"replace current window" => "در همين صفحه‌ي كنوني",
"new window" => "پنجره‌ي جديد",
"inline frame" => "قاب دروني (inline frame)",
"No error reporting" => "بدون گزارش خطا",
"Report all PHP errors" => "تمام خطاهاي PHP رو گزارش بده",
"Default number of comments per page" => "پيش‌فرض تعداد نظرات در هر صفحه",
"Comments default ordering" => "ترتيب پيش‌فرض نظرات",
"Polls" => "راي‌گيري‌ها",
"Newsletters" => "خبرنامه‌ها",
"Calendar" => "تقويم",
"Banners" => "درفش‌ها",
"Category" => "طبقه",
"Score" => "امتيازدهي",
"Search" => "جستجو",
"Multilingual" => "چند زبانه‌اي",
"FAQ" => "سئوالات متداول",
"Surveys" => "نظرسنجي‌ها",
"Featured links" => "پيوندهاي خاص",
"Copyright" => "حق انحصاري چاپ",
"Shoutbox" => "فريادگاه",
"Maps" => "نقشه‌ها",
"Google Maps" => "نقشه‌هاي گوگل",
"Live support system" => "سامانه‌ي پشتيباني زنده",
"Contact Us" => "تماس با ما",
"PHPLayers" => "PHP Layers Menu System",
"Mobile" => "سيار",
"Webmail" => "پست تحت وب",
"Intertiki" => "بين تيكي(Inter tiki)",
"Mail-in" => "كنترل با پست الكترونيكي",
"Wysiwyg editor" => "ويرايش‌گر Wysiwyg",
"Friendship Network" => "شبكه‌ي رفاقت",
"Banning system" => "سامانه‌ي تحريم",
"Stats" => "آمار",
"Referer Stats" => "آمار مراجعات",
"Redirect On Error" => "هنگام بروز خطا، كاربر را Redirect كن",
"Communications (send/receive objects)" => "ارتباطات (ارسال/دريافت اشيائ)",
"Custom Home" => "مبدا قابل متناسب‌سازي",
"Mini Calendar" => "تقويم جيبي",
"User Preferences Screen" => "صفحه‌ي تنظيمات براي هر كاربر",
"User Notepad" => "صفحه‌ي يادداشت‌برداري براي هر كاربر",
"User Bookmarks" => "صفحه‌ياب براي هر كاربر",
"User Watches" => "ديده‌بان‌هاي كاربر",
"User Watches Translations" => "ديده‌بان‌هاي كاربران را ترجمه كن",
"User Menu" => "منو براي هر كاربر",
"User Tasks" => "سامانه‌ي وظايف براي هر كاربر",
"User Messages" => "سامانه‌ي پيغام براي هر كاربر",
"User Files" => "پرونده براي هر كاربر",
"Integrator" => "كامل كننده",
"XMLRPC API" => "رابط برنامه نويسي XMLRPC",
"Debugger Console" => "ميزكار اشكال‌زدايي",
"Protect against CSRF with a ticket" => "به كمك يك بليط، در برابر CSRF حفاظت كن",
"Detect browser language" => "زبان مرورگر را تشخيص بده",
"Help System" => "سامانه‌ي كمك رساني",
"Smileys" => "صورتك‌ها",
"Dynamic Content System" => "سامانه‌ي محتواي پويا",
"Display menus as folders" => "منوها را مانند پوشه‌ها نمايش بده",
"Activate" => "فعال شود",
"Comments" => "نظرات",
"Search and replace" => "جستجو و جايگزيني",
"Submissions" => "ارائه‌ها",
"Rankings" => "رتبه‌بندي‌ها",
"Content templates" => "الگوهاي محتوا",
"Print" => "چاپ",
"Ignore category viewing restrictions" => "محدوديت‌هاي مشاهده‌ي طبقات را ناديده بگير",
"Local" => "محلي(Local)",
"List pages" => "فهرست صفحات",
"Last changes" => "آخرين تغييرات",
"Orphan pages" => "صفحات يتيم",
"Referer Search Highlighting" => "علامت‌زدن اطلاعات جستجو شده",
"Search stats" => "آمار جستجو‌ها",
"Ignore individual object permissions" => "حقوق دسترسي انفرادي اشياء را ناديده بگير",
"Visits" => "بازديدها",
"Accept wiki syntax" => "نحو ويكي(wiki syntax) قابل قبول است",
"Allow same file to be uploaded more than once" => "بارگذاري يك پرونده‌ي پيش از يك بار مجاز است",
"Never" => "هيچ‌وقت!",
"Mb" => "مگابايت",
"Uploaded filenames must match regex" => "نام پرونده‌هاي بارگذاري شده بايد با اين اصطلاح همخواني داشته باشد",
"Plain" => "ساده",
"Threaded" => "مانند نخ كشيده",
"Headers Only" => "فقط سرفصل",
"Title (desc)" => "عنوان (نزولي)",
"Title (asc)" => "عنوان (صعودي)",
"Topics" => "عناوين",
"Posts" => "الصاق‌ها",
"Posts per day" => "الصاق‌ها در روز",
"Creation Date (desc)" => "تاريخ ايجاد (نزولي)",
"Topics (desc)" => "عناوين (نزولي)",
"Threads (desc)" => "رگه(thread)ها (نزولي)",
"Last post (desc)" => "آخرين الصاق (نزولي)",
"Name (desc)" => "نام (نزولي)",
"Name (asc)" => "نام (صعودي)",
"Browser title" => "عنوان مرورگر",
"Home page" => "صحفه‌ي مبدا",
"Use group homepages" => "استفاده از صفحات مبدا براي گروه‌ها",
"Go to group homepage only if login from default homepage" => "تنها در صورتي كه از صفحه‌ي پيش‌فرض وارد شدند، به صفحه‌ي مبدا گروه برو",
"Temporary directory" => "پوشه‌ي موقت",
"Help URL" => "URL كمك",
"Open external links in new window" => "پيوند(link)هاي خارجي را در پنجره‌ي جديد باز كن",
"Full path to gdaltindex" => "آدرس كامل به gdaltindex",
"Full path to ogr2ogr" => "آدرس كامل به ogr2ogr",
"Map Zone" => "قلمرو نقشه",
"Display modules to all groups always" => "همواره ماژول‌ها را تمام گروه‌ها نشان بده",
"Hide anonymous-only modules from registered users" => "ماژول‌هاي كاربران بي‌نام را از كاربران ثبت‌نام كرده مخفي كن",
"Content" => "محتوا",
"Use database for translation" => "از بانك اطلاعاتي براي ترجمه استفاده كن",
"full path to mapfiles" => "آدرس كامل پرونده‌هاي نقشه",
"Wiki Page for Help" => "صفحه‌ي ويكي براي كمك",
"Wiki Page for Comments" => "صفحه‌ي ويكي براي نظرات",
"Maximum mailbox size (messages, 0=unlimited)" => "بيشينه فضاي صندوق پستي)تعداد پيغام، 0 به معني بدون محدوديت)",
"Maximum mail archive size (messages, 0=unlimited)" => "بيشينه فضاي صندوق بايگاني)تعداد پيغام، 0 به معني بدون محدوديت)",
"Maximum sent box size (messages, 0=unlimited)" => "بيشينه فضاي صندوق پيگيري(sent box))تعداد پيغام، 0 به معني بدون محدوديت)",
"geo.position" => "موقعيت جغرافيايي",
"geo.region" => "منطقه‌ي جغرافيايي",
"geo.placename" => "نام جغرافيايي محلي",
"Port" => "درگاه(port):",
"Proxy port" => "درگاه(port) پروكسي",
"Record untranslated strings" => "ركورد ترجمه نشده است",
"Normal" => "عادي",
"Refresh rate" => "نرخ بازيابي(Refresh)",
"Minimum length of search word" => "حداقل طول كلمه‌ي جستو شده",
"Max. number of words containing a syllable" => "بيشينه تعداد كلماتي كه يك هجا را مي‌سازند",
"Max. age in hours of syllable search cache" => "بيشينه عمر cache جستجوي هجا به ساعت",
"LRU list purging rate" => "نرخ پاك‌سازي فهرست LRU",
"LRU list length" => "طول فهرست LRU",
"Database" => "بانك اطلاعاتي",
"After" => "بعداز",
"Before" => "قبل از",
"Publish" => "منتشر شود",
"Use proxy" => "از پروكسي(proxy) استفاده كن",
"Allow viewing HTML mails?" => "اجازه‌ي مشاهده‌ي پست‌هاي الكترونيكي HTML رو بده",
"Maximum size for each attachment" => "بيشينه حجم هر ضميمه",
"Unlimited" => "نامحدود",
"Complete" => "كامل",
"Business style" => "سبك تجاري",
"Collaborative style" => "سبك همكاري",
"Top" => "فوقاني",
"Cache wiki pages (global)" => "صفحات ويكي را cache كن(عمومي)",
"no cache" => "بدون cache",
"minute" => "دقيقه",
"minutes" => "دقيقه",
"hour" => "ساعت",
"hours" => "ساعت",
"Enable wiki 3D browser" => "مرورگر 3بعدي ويكي فعال باشد",
"Load page on navigation" => "هنگام مرور صفحه را بار كن",
"Browser height" => "ارتفاع مرورگر",
"Navigation depth" => "‘عمق مرور",
"Node size" => "حجم گره",
"Text size" => "حجم متن",
"Spring (connection) size" => "حجم ارتباط",
"Existing page node color" => "رنگ گره‌ي صفحه‌ي موجود",
"Missing page node color" => " رنگ گره‌ي صفحه‌ي مفقود",
"Camera distance adjusted relative to nearest node" => "فاصله‌ي دوربين باتوجه به نزديك‌ترين گره",
"Camera distance" => "فاصله‌ي دوربين",
"Field of view" => "ميدان ديد",
"Feed animation interval (milisecs)" => "فرجه‌ي تغذيه‌ي انگيزش (ميلي ثانيه)",
"Friction constant" => "ثابت اصطحكاك",
"Elastic constant" => "ثابت ارتجاعي",
"Eletrostatic constant" => "ثابت الكترواستاتيك",
"Node mass" => "جرم گره",
"Node charge" => "هزينه‌ي گره",
"Wiki top pages" => "بهترين صفحات ويكي",
"Most relevant pages" => "مرتبط‌ترين صفحات",
"Relevance" => "رابطه",
"Wiki last pages" => "آخرين صفحات ويكي",
"Modified" => "تغيير كرده در:",
"Forums last posts" => "آخرين الصاقات انجمن‌ها",
"Topic date" => "تاريخ عنوان",
"Forums most read topics" => "پرخواننده‌ترين انجمن‌ها",
"Forums best topics" => "بهترين عناوين انجمن‌ها",
"Forums most visited forums" => "پربيننده‌ترين انجمن‌ها",
"Forums with most posts" => "پر الصاق ترين پربيننده‌ترين",
"Wiki top galleries" => "سرسراهاي برتر ويكي",
"Wiki top file galleries" => "سرسرهاي برتر پرونده‌هاي",
"Wiki top images" => "تصاوير برتر ويكي",
"Wiki top files" => "پرونده‌هاي برتر ويكي",
"Downloads" => "دريافت‌ها",
"Wiki last images" => "آخرين تصاوير ويكي",
"Upload date" => "تاريخ بارگذاري",
"Wiki last files" => "خرين پرونده‌هاي ويكي",
"Wiki top articles" => "برترين مقالات ويكي",
"Most visited blogs" => "پربيننده‌ترين بلاگ‌ها",
"Most active blogs" => "فعال‌ترين بلاگ‌ها",
"Activity" => "فعاليت",
"Blogs last posts" => "آخرين الصاق بلاگ",
"Post date" => "تاريخ الصاق",
"Wiki top authors" => "برترين مؤلفان ويكي",
"Pages" => "صفحات",
"Top article authors" => "برترين مؤلفان مقالات",
"User already exists" => "اين كاربر قبلا ايجاد شده بود",
"Wrong registration code" => "كد ثبت‌نام اشتباه است",
"Invalid username" => "نام كاربري معتبر نيست",
"Username is too long" => "نام كاربري پيش از حد بلند است",
"Username cannot contain whitespace" => "نام كاربر نمي‌تواند جاي خالي داشته باشد",
"Wrong passcode. You need to know the passcode to register at this site" => "كدعبور اشتباه است. براي ثبت‌نام در اين پايگاه، بايد كدعبور را بدانيد",
"Invalid email address. You must enter a valid email address" => "آدرسي پست الكترونيكي معتبر نيست. بايد يك آدرس معتبر وارد كنيد",
"The registration mail can't be sent. Contact the administrator" => "پست الكترونيكي ثبت‌نام را نمي‌توانم ارسال كنيم. با سرپرست تماس بگيريد",
"change" => "تغيير بده",
"Today" => "امروز",
"and" => "و-با-",
"from" => "از",
"replied" => "پاسخ داده‌شده",
"Login" => "ورود",
"See other users' profiles" => "مشاهده‌ي نمايه‌ي(profile) ساير كاربران",
"Have your profile seen" => " مشاهده‌ي نمايه‌ي(profile) خود توسط ديگر كاربران",
"Make friends" => "رفيق شدن",
"Receive message" => "دريافت پيغام",
"Send message" => "ارسال پپغام",
"Read an article" => "خواندن يك مقاله",
"Publish an article" => "انتشار يك مقاله",
"Have your article read" => "خوانده شدن مقاله",
"Create new file gallery" => "ايجاد يك سرسراي پرونده‌ي جديد",
"Upload new file to gallery" => "بارگذاري پرونده‌ي جديد به سرسرا",
"Download other user's file" => "دريافت پرونده‌هاي ساير كاربران",
"Have your file downloaded" => "دريافت شدن پرونده‌هاي بارگذاري شده",
"Create a new image gallery" => "ايجاد يك سرسراي جديد",
"Upload new image to gallery" => "بارگذاري تصوير جديد در سرسرا",
"See other users' galleries" => "مشاهده‌ي سرسراي تصاوير ديگر كاربران",
"See other users' images" => "مشاهده‌ي تصاوير ساير كاربران",
"Have your gallery seen by other users" => "مشاهده‌ي سرسراي خود به‌وسيله‌ي ديگر كاربران",
"Have your image seen" => "ديده‌شدن تصوير خود",
"Create new blog" => "يك بلاگ جديد ايجاد كن",
"Post in a blog" => "الصاق در يك بلاگ",
"Read other users' blogs" => "خواندن بلاگ‌هاي ساير كاربران",
"Have your blog read" => "خوانده‌شدن بلاگ توسط ساير كاربران",
"Create a new wiki page" => "ساخت يك ويكي جديد",
"Edit an existing page" => "ويرايش يك صفحه‌ي موجود",
"Attach file" => "ضميمه كردن پرونده",
"Gallery" => "سرسرا",
"Image" => "تصوير",
"Forum" => "انجمن",
"Article" => "مقاله",
"Blog post" => "الصاق بلاگ",
"Unknown" => "ناشناخته",
"Trackeritem" => "فقره‌ي tracker",
"Directory category" => "طبقه‌ي پوشه",
"Prev" => "قلي",
"Next" => "بعدي",
"comment" => "ايراد نظر",
"Click Here" => "اين‌جا را كليك كنيد",
"Edit Template" => "ويرايش الگو",
"Hide" => "مخفي كن",
"help" => "كمك",
"All" => "همه",
"The text is" => "متن عبارت است از",
"character(s) too long - please edit it." => "تعداد حروف بيش از حد است. لطفا اصلاح كنيد.",
"Date Selector" => "انتخاب‌گر تاريخ",
"phplayers are not available on this site" => "لايه‌هاي PHP در اين پايگاه فعال نيستند.",
"Select All" => "انتخاب همه",
"days" => "روز",
"day" => "روز",
"mins" => "دقيقه",
"min" => "دقيقه",
"secs" => "ثانيه",
"done" => "انجام شد",
"Text cut here" => "متن اين‌جا قطع مي‌شود",
"Task" => "وظيفه",
"for" => "براي",
"Priority" => "اولويت",
"Start date:" => "تاريخ شروع:",
"End date:" => "تاريخ پايان:",
"Friend" => "رفيق",
"Last seen on" => "آخرين بار روئيت شده در",
"(idle for %s seconds)" => "(بيكار براي %s ثانيه)",
"User information - Click for more info" => "اطلاعات كاربر – براي اطلاعات بيشتر اين‌جا را كليك كنيد",
"More info about \$other_user" => "اطلاعات بيشتر درخصوص \$other_user",
"(idle for \$idletime seconds)" => "(بيكار بري \$idletime ثانيه)",
"Yes" => "بله",
"No" => "خير",
"Use this tree to copy the structure" => "از اين درختواره براي كپي ساختار استفاده كن",
"created from structure" => "ايجاد شده از ساختار",
"Table of contents" => "فهرست",
"text" => "متن",
"unknown error" => "خطاي نامشخص",
"You are not logged in" => "شما به سامانه وارد نشده‌ايد",
"Page cannot be found" => "چنين صفحه‌اي پيدا نشد",
"Permission denied. You cannot view this section" => "متاسفانه شما حقوق دسترسي لازم براي مشاهده‌ي اين بخش را نداريد",
"Help" => "كمك",
"You are banned from" => "دسترسي شما به اين بخش ممنوع شده است:",
"wiki" => "ويكي",
"img-g" => "تصوير-g",
"file-g" => "پرونده-g",
"faqs" => "سئوالات متداول",
"quizzes" => "آزمون‌ها",
"arts" => "هنرها",
"blogs" => "بلاگ‌ها",
"forums" => "انجمن‌ها",
"Click to edit dynamic variable" => "براي ويرايش متغيير پويا اين‌جا را كليك كنيد",
"Update variables" => "به‌روز رساني متغييرها",
"Show" => "نمايش بده",
"sad" => "غمگين",
"confused" => "گيج",
"cool" => "آرام",
"mad" => "قاطي",
"%d points" => " امتياز%d",
"Removed" => "حذف شد",
"__WARNING__: No such module \$plugin!" => "__اخطار__: چنين ماژولي وجود ندارد \$plugin!",
"at" => "راس ساعت",
"new" => "جديد",
"Create page:" => "ساخت صفحه:",
"Unknown language" => "زبان ناشناخته",
"Click here to confirm your action" => "براي تاييد اين دكمه را بفشاريد",
"Sea Surfing (CSRF) detected. Operation blocked." => "Sea Surfing (CSRF)  كشف شدو عمليات مسدود شد.",
"Heading" => "سرنامه(عنوان)",
"Reduce area height" => "ارتفاع محدوده را كاهش بده",
"Enlarge area height" => "ارتفاع محدوده را اضافه كن",
"Wiki Help" => "كمك از ويكي",
"Item Modification" => "تغيير فقره",
"Item" => "قلم",
"Item creation" => "ايجاد فقره",
"Subject" => "موضوع",
"Tracker was modified at " => "Tracker در اين‌جا تغيير كرد  ",
"View the tracker item at:" => "فقره‌ي tracker را در اين‌جا مشاهده كنيد:",
"text field" => "رشته‌ي متني",
"size" => "اندازه",
"textarea" => "متن",
"checkbox" => "جعبه انتخاب(checkbox)",
"numeric field" => "ستون عددي",
"drop down" => "كركره‌اي",
"user selector" => "انتخاب كاربران",
"group selector" => "انتخاب گروه كاربري",
"country selector" => "انتخاب كشور",
"date and time" => "زمان و تاريخ",
"jscalendar" => "تقويم JS",
"action" => "عمل",
"header" => "سرصفحه",
"category" => "طبقه",
"item link" => "پيوند به فقره",
"items list" => "فهرست اقلام",
"email" => "پست الكترونيكي",
"url" => "آدرس اينترنتي",
"system" => "سامانه",
"attachment" => "ضميمه",
"open" => "باز",
"pending" => "معلق",
"closed" => "بسته",
"Message" => "پيغام",
"No extra information for that attached file. " => "هيچ اطلاعات اضافي در خصوص پرونده‌ي ضميمه‌شده وجود ندارد ",
"child categories" => "طبقات فرزند",
"objects in category" => "اشياء در طبقه",
"Password should be at least" => "كلمهِ‌ي عبور بايد حداقل",
"characters long" => "حرف داشته باشد",
"Password must contain both letters and numbers" => "كلمه‌ي عبور بايد هم شامل حروف و و هم عدد باشد.",
"Company" => "سازمان",
"State" => "وضعيت",
"Country" => "كشور",
"No subject" => "بدون موضوع",
"Info" => "اطلاعات",
"Displays browser client info" => "نمايش اطلاعات مرورگر ارباب رجوع",
"Creates a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which specifies the location and name of the anchor" => "يك پيوند به يك لنگر(anchor) در صفحه‌اي از ويكي قرار مي‌دهد. در اتحاد با pluginاي كه نام و مكان لنگر را مشخص مي‌كند(ANAME) استفاده شود.",
"linktext" => "متن پيوند",
"Creates an anchor in a wiki page. Use in conjunction with the ALINK plugin, which specifies a link to the anchor" => "يك پيوند به يك لنگر(anchor) در صفحه‌اي از ويكي قرار مي‌دهد. در اتحاد با pluginاي كه پيوندبه لنگر را مي‌سازد(ALINK) استفاده شود.",
"Location" => "محل",
"Field" => "ستون",
"Attachment" => "ضميمه",
"File" => "پرونده",
"Show description" => "شرح را نمايش بده؟",
"No such attachment on this page" => "چنين پميمه‌اي در اين صفحه وجود ندارد",
"Displays an attachment or a list of them" => "يك ضميمه يا فهرستي از آن‌ها نمايش مي‌دهد",
"Avatar" => "شكلك",
"Displays the user Avatar" => "شكلك كاربر رو نمايش بده",
"username" => "نام كاربري",
"Back" => "بازگشت",
"Backlinks" => "پيوندهاي معكوس",
"List all pages that link to specific pages" => "تمام صفحاتي كه به يك صفحه‌ي خاص اشاره مي‌كنند را فهرست مي‌كند",
"No pages links to" => "هيچ صفحه‌اي به اين مورد پيوند ندارد",
"One page links to" => "يك صفحه به اين مورد پيوند دارد",
"pages link to" => "صفحاتي كه به اين مورد پيوند دارند",
"Zone" => "قلمرو",
"Items" => "اقلام",
"Insert theme-styled box on wiki page" => "جعبه‌ي سبك قيافه در صفحه‌ي ويكي قرار بگيرد",
"Insert list of items with the current/given category in the wiki page" => "در صفحات ويكي، فهرست اقلام طبقه‌ي جاري/انتخابي را درج كن",
"Categories are disabled" => "طبقات غيرفعال‌اند",
"Display Tiki objects that have not been categorized" => "اشياء تيكي كه طبقه‌بندي نشده‌اند را نمايش بده",
"Objects" => "شيء",
"Insert the full category path for each category that this wiki page belongs to" => "آدرس كامل طبقه را براي هر طبقه كه اين صفحه‌ي ويكي به آن تعلق دارد درج كن",
"Center" => "مركز",
"Centers the plugin content in the wiki page" => "محتويات plugin را در مركز صفحه‌ي ويكي قرار بده",
"Chart" => "نام نمودار",
"title" => "عنوان",
"Code" => "دستورالعمل",
"Displays a snippet of code" => "يه تيكه از كد را نمايش بده",
"code" => "دستورالعمل",
"note: colors and ln are exclusive" => "نكته: رنگ‌ها و ln اختصاصي هستند",
"Dynamic Content" => "محتوي پويا",
"Cookie" => "كوكي",
"Insert copyright notices" => "اطلاعيه‌ي حقوق انحصاري چاپ(copyright) را درج كن",
"Example" => "مثال",
"seconds" => "ثانيه",
"Pre" => "قبلي",
"Right" => "راست",
"Left" => "چپ",
"Clear" => "پاك كن",
"Creates a definition list" => "يك فهرست تعريف تهيه كن",
"term" => "دوره",
"definition" => "معني",
"one definition per line" => "يك معني در هر خط",
"Events" => "رويدادها",
"Desc" => "توضيحات",
"Upcoming events" => "رويدادهاي قريب‌الوقوع",
"Label" => "برچسب",
"Displays the data using the Tikiwiki odd/even table style" => "اطلاعات را با استفاده از سبك جدول زوج/فرد تيكي-ويكي نمايش بده",
"cells" => "سلول(ها)",
"sort" => "مرتب كن",
"Displays a Flash (.swf) file in the wiki page" => "نمايش يك پرونده‌ي SWF در صفحه‌ي ويكي",
"failed" => "ناموفق بود",
"description" => "شرح",
"Value" => "مقدار",
"Displays a graphical GAUGE" => "يك پيمانه‌ي ترسيمي(Graphical GAUGE) نمايش بده",
"type" => "نوع",
"Group" => "نام گروه",
"groups" => "گروه‌هاي كاربري",
"HTML code" => "كد HTML",
"URL" => "آدرسي اينترنتي",
"name" => "نام",
"Image ID" => "شناسه‌ي تصوير",
"Image size" => "اندازه‌ي تصوير",
"Thumbnail" => "تصويرك",
"Browse" => "مرور",
"Download" => "دريافت",
"Include" => "شامل",
"Start" => "شروع",
"Stop" => "توقف",
"Include a page" => "شامل يك صفحه است",
"Email address" => "آدرس پست الكترونيكي",
"Displays the text only if the language matchs" => "فقط درصورتي كه زبان همخواني داشت متن را نمايش مي‌دهد",
"Last Modification" => "آخرين تغييرات",
"List Pages" => "فهرست صفحات",
"Sort" => "مرتب بر اساس",
"or" => "يا",
"Filter" => "فيلتر",
"complete" => "كامل",
"articles" => "مقالات",
"Map" => "نگاشت",
"Feature disabled" => "خصيصه غيرفعال شد",
"Template" => "الگو",
"Style" => "سبك",
"Groups" => "گروه‌هاي كاربري",
"Module Name" => "نام ماژول",
"Please choose a module" => "لطفا يك ماژول انتخاب كنيد",
"to be used as argument" => "براي استفاده به‌عنوان آرگومان",
"Displays a module inline in a wiki page" => "يك ماژول را در ميان صفحه نمايش مي‌دهد",
"Sorry, no such module" => "متاسفانه چنين ماژولي وجود ندارد",
"Font" => "قلم",
"Displays the data using a monospace font" => "داده‌ها را با استفاده از يك قلم monospace نمايش مي‌دهد",
"Text" => "متن",
"Sticky" => "چسب‌‌ناك",
"data" => "داده‌ها",
"Object" => "شئي",
"Days" => "روز",
"Status" => "وضعيت",
"Picture" => "تصوير",
"picture not found" => "تصوير پيدا نشد",
"Displays a list of plugins available in this wiki." => "يك فهرست از pluginهاي اين ويكي را نمايش مي‌دهد.",
"No version indicated" => "هيچ نسخه‌اي مشخص نشده است",
"No arguments indicated" => "هيچ آرگوماني مشخص نشده است",
"Poll" => "راي‌گيري",
"Displays the output of a poll, fields are indicated with numeric ids." => "خروجي يك راي‌گيري را نمايش مي‌دهد، ستون‌ها را اعداد مشخص مي‌شوند",
"missing poll ID for plugin POLL" => "شناسه‌ي راي‌گيري براي plugin راي‌گيري مفقود شده است",
"Preferences" => "تنظيمات",
"User Information" => "اطلاعات كاربر",
"one data per line" => "يك داده در هر خط",
"Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "عبارت regex را مي‌گيرد و محتواي بين تگ‌هاي آن را تجزيه كرده با متن جايگزين مي‌كند",
"Icon" => "تمثال",
"Close" => "ببند",
"Date" => "تاريخ",
"Automatically creates a link to the appropriate SourceForge object" => "به‌صورت خودكار يك پيوند به شيء مناسب در SourceForge ايجاد كن",
"Sheet Heading" => "سرصفحه‌ي ورق",
"TikiSheet" => "ورق‌‌هاي تيكي",
"List wiki pages" => "فهرست صفحات ويكي",
"Display" => "نمايش",
"Last modified by" => "آخرين بار به‌وسيله‌ي ايشان تغيير كرده است",
"Action" => "عمل",
"The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "pluin مربوط به SNARF، خود را جايگزين متن HTML مربوط به آن URL مي‌كند. Regex به‌صورت دلخواه",
"This data is put in a CODE caption." => "Plugin مربوط به SNARF خود را جايگزين بدنه‌ي HTML يك URL مي‌كند. جايگزيني Regex نيز با استفاده از regex يا regexres در محتوا ممكن خواهد بود كه مورد دوم به عنوان آرگوماني براي preg_replace استفاده خواهد شد.",
"Missing url parameter for SNARF plugin." => "پارامتر URL براي SNARF مفقود شده است",
"Sorts the plugin content in the wiki page" => "مربت كردن محتواي يك plugin در صحفه‌ي ويكي",
"Order" => "ترتيب",
"Split a page into rows and columns" => "انشعاب يك صفحه به سطرها و ستون‌ها",
"First" => "اولين",
"Edit" => "ويرايش",
"row1col1" => "سطر 1، ستون 1",
"row1col2" => "سطر 1، ستون 2",
"row2col1" => "سطر 2، ستون 1",
"row2col2" => "سطر 2، ستون 2",
"Run a sql query" => "اجراي يك جستار SQL",
"sql query" => "جستار SQL",
"Missing db param" => "پارامتر بانك اطلاعاتي مفقود است",
"Displays text in subscript." => "متن را در پانويس نمايش مي‌دهد",
"Subscribe" => "عضويت",
"Url" => "آدرس اينترنتي",
"Id" => "شناسه",
"Displays the thumbnail for an image" => "تصويرك يك تصوير را نمايش مي‌دهد",
"Original" => "بكر",
"Search the titles of all pages in this wiki" => "عناوين تمام صفحه‌هاي اين ويكي را جستجو كن",
"No pages found for title search" => "هيچ صفحه‌اي براي اين جستجو در عناوين يافت نشد",
"One page found for title search" => "يك صفحه در جستجوي عناوين يافت شد",
"pages found for title search" => "صفحه در جستجوي عناوين يافت شد",
"Structure ID" => "شناسه‌ي ساختار",
"Public" => "عمومي؟",
"Translate" => "ترجمه كن",
"Fields" => "ستون‌ها",
"Email" => "پست الكترونيكي",
"to" => "تا",
"template" => "الگو",
"Preview" => "پيش‌نمايش",
"preview" => "پيش‌نمايش",
"View" => "مشاهده",
"Error" => "خطا",
"Displays an input form for tracker submit" => "يك فرم ورودي براي ارائه‌ي tracker نمايش مي‌دهد",
"Fields marked with a * are mandatory." => "پركردن مواردي كه با * علامت زده شده‌اند اجباري است.",
"Displays the output of a tracker content, fields are indicated with numeric ids." => "خروجي محتواي يك tracker را نمايش مي‌دهد، ستون‌ها با اعداد مشخص شده‌اند",
"Mode" => "حالت",
"Delete" => "حذف",
"Error in tracker ID" => "خطا در شناسه‌ي tracker",
"No field indicated" => "هيچ ستوني مشخص نشده است",
"Links to a translated content" => "به يك محتواي ترجمه شده پيوند مي‌زند",
"Flag" => "پرچم",
"Displays the number of registered users" => "تعداد كاربران ثبت‌نام كرده را نمايش مي‌دهد",
"User List" => "فهرست كاربران",
"Real Name" => "نام واقعي",
"users" => "كاربران",
"Versions" => "نسخه",
"Split the text in parts visible only under some conditions" => "تنها در شرايط خاص، متن منشعب در بخش‌ها قابل روئيت است",
"Vote" => "اخذ راي",
"Table" => "جدول",
"External Wiki" => "ويكي‌هاي خارجي",
"valid" => "اعتبار",
"ERROR: Either the subject or body must be non-empty" => "خطا: هيچ‌كدام از متن و موضوع نبايد خالي باشند",
"ERROR: No valid users to send the message" => "خطا: هيچ كاربر معتبري براي ارسال پيغام يافت نشد",
"Invalid user" => "كاربر نامعتبر است",
"Message will be sent to: " => "پيغام براي اين كاربران ارسال خواهد شد:",
"No more messages" => "پيغام‌هاي بيشتر مقدور نيست",
"Categories" => "طبقات",
"Categorize" => "طبقات",
"Unassign" => "حذف",
"Assign" => "اختصاص بده",
"Received objects" => "اشياء دريافت شده",
"File galleries" => "سرسراهاي پرونده‌ها",
"Last forum posts" => "آخرين الصاق‌هاي انجمن",
"Topics only" => "فقط عنوان",
"Most commented forums" => "انجمن‌هايي با بيشترين نظرات",
"Most read topics" => "پربيننده‌ترين الصاق‌ها",
"Most visited forums" => "پربيننده‌ترين انجمن‌ها",
"Google Search" => "جستجوي گوگل",
"Last actions" => "آخرين اعمال",
"Last blog posts" => "آخرين الصاق‌هاي بلاگ",
"no object here yet" => "هنوز هيج شئيي اين‌جاي نيست",
"Last Created blogs" => "آخرين بلاگ ساخته شده‌",
"Last Created FAQs" => "آخرين FAQهاي ايجاد شده",
"Last Created Quizzes" => "آخرين آزمون‌هاي ايجاد شده",
"Last modified file galleries" => "آخرين سرسراهاي پرونده‌ي تغيير يافته",
"Last Files" => "آخرين پرونده‌ها",
"Last Images" => "آخرين تصاوير",
"Last modified events" => "آخرين رويدادهاي تغيير كرده",
"Last Modified blogs" => "آخرين بلاگ‌هاي تغيير كرده‌",
"Last submissions" => "آخرين ارائه‌ها",
"Last Items" => "آخرين اقلام",
"Last Modified Items" => "اقلام تغيير كرده",
"Last Visitors" => "آخرين بازديد كنندگان",
"Live support" => "پشتيباني زنده",
"Messages" => "پيغام",
"Waiting Submissions" => "درخواست‌هاي در صف انتظار",
"Old articles" => "مقالات قديمي",
"Create/Edit" => "ايجاد/حذف",
"Quick Edit a Wiki Page" => "ويرايش سريع يك صفحه‌ي ويكي",
"Random Pages" => "صفحات تصادفي",
"New user registration" => "ثبت‌نام كاربر جديد",
"Post" => "الصاق",
"Since your last visit" => "از آخرين بازديد شما...",
"Changes since" => "تغييرات از",
"new comments" => "نظرات جديد",
"wiki pages changed" => "صفحه‌ي ويكي تغيير كرده‌اند",
"new articles" => "مقاله‌ي جديد",
"new FAQs" => "FAQ جديد",
"new blogs" => "بلاگ‌هاي جديد",
"new blog posts" => "الصاق‌هاي جديد بلاگ",
"new image galleries" => "سراسراهاي تصوير جديد",
"new images" => "تصاوير جديد",
"new file galleries" => "سراسراهاي پرونده‌ي جديد",
"new files" => "پرونده‌هاي جديد",
"new polls" => "راي‌گيري‌هاي جديد",
"new users" => "كاربران جديد",
"Most Active blogs" => "فعال‌ترين بلاگ‌ها",
"Top articles" => "برترين مقالات",
"Top File Galleries" => "برترين سرسراهاي پرونده",
"Top files" => "پرونده‌هاي برتر",
"Top Forum Posters" => "آگهي‌هاي برتر انجمن‌ها",
"Top Images" => "تصاوير برتر",
"Top Pages" => "برترين صفحات",
"Top Quizzes" => "برترين آزمون‌ها",
"Top Visited FAQs" => "پربيننده‌ترين FAQها",
"User Blogs" => "بلاگ‌هاي كاربر",
"My blogs" => "بلاگ‌هاي من",
"User bookmarks" => "صفحه‌ياب(bookmark)هاي كاربران",
"My galleries" => "سرسراهاي من",
"User Pages" => "صفخات كاربران",
"My Pages" => "صفحات من",
"User tasks" => "وظايف كاربر",
"The task title must have at least 3 characters" => "موضوع وظيفه، بايد حدااقل 3 حرف باشد",
"Public tasks" => "وظايف عمومي",
"Top users" => "برترين كاربران",
"Online users" => "كاربران روي خط",
"Last wiki comments" => "آخرين نظرات ويكي",
"Invalid username or password" => "نام كاربري يا كلمه‌ي عبور معتبر نيست",
"country" => "كشور",
"theme" => "قيافه",
"Anti-Bot verification code" => "كد بازبيني ضد ماشيني(Anti-bot)",
"Random Image" => "تصوير تصادفي",
"Enter the code you see above" => "كدي كه در بالا مي‌بينيد را وارد كنيد",
"List of attached files" => "فهرست پرونده‌هاي ضميمه شده",
"id" => "شناسه",
"desc" => "توضيحات",
"uploaded" => "بارگذاري شده",
"Remove" => "حذف",
"Upload file" => "بارگذاري پرونده",
"Attach" => "ضميمه",
"Attach a file to this item" => "يك پرونده به اين فقره ضميمه كن",
"Version" => "نسخه",
"Attachments" => "ضمايم",
"more info" => "اطلاعات بيشتر",
"No attachments for this item" => "اين فقره هيچ ضميمه‌اي ندارد",
"debug" => "اشكال‌زدايي",
"Fatal error" => "خطاي مهلك",
"Created by" => "ايجاد شده توسط",
"on" => "در",
"Activity=" => "فعاليت=",
"Actions" => "اقدامات",
"Properties" => "خصوصيات",
"No records found" => "هيچ ركوردي يافت نشد.",
"Admin Categories" => "مديريت طبقه‌بندي‌ها",
"No categories defined" => "هيچ طبقه‌اي تعريف نشده است",
"Browse Category" => "مرور طبقه",
"stars" => "شروع",
"User Level" => "سطح كاربر",
"private message" => "پيغام شخصي",
"Send eMail to User" => "ارسال پست الكترونيكي به كاربر",
"user online" => "كاربر روي خط است",
"user offline" => "كاربر خارج خط است",
"Reply" => "پاسخ",
"Approve" => "تصويب",
"Reject" => "مردود",
"Save to notepad" => "ذخيره در دفترچه‌ي يادداشت",
"Monitor this Topic" => "اين عنوان را ديده‌باني كن",
"Stop Monitoring this Topic" => "ديده‌باني اين عنوان با متوقف كن",
"Moderator actions" => "اعمال ناظم",
"reported:" => "گزارش داده شده:",
"queued:" => "درصف قرار گرفته:",
"Move to topic:" => "به اين موضوع منتقلش كن:",
"Move" => "تغيير مكان",
"Delete Selected" => "انتخاب شده‌ها را حذف كن",
"Unlock" => "بازكردن قفل",
"Lock" => "قفلش كن",
"Threshold" => "آستانه",
"Set" => "تنظيم",
"Replies" => "پاسخ‌ها",
"below your current threshold" => "پايين‌تر از حد آستانه‌ي شما",
"New Reply" => "پاسخ جديد",
"Editing reply" => "ويرايش پاسخ",
"Reply to the selected post" => "پاسخ به الصاق‌هاي انتخاب شده",
"Editing comment" => "ويرايش نظر",
"Comment on the selected post" => "ايراد نظر درمورد الصاق انتخاب شده",
"Post new comment" => "ايراد نظر جديد",
"Toolbars" => "تگ‌هاي سريع",
"optional" => "اختياري",
"Reply to parent post" => "پاسخ به نظر مادر",
"Post new reply" => "الصاق يك پاسخ جديد",
"Cancel" => "لغو",
"Posting replies" => "الصاق پاسخ",
"Posting comments" => "نظرهاي الصاقات",
"Add Comment" => "افزودن نظريه",
"1 comment" => "1 نظر",
"Go back" => "به جاي قبلي بازگرد",
"Return to home page" => "به صفحه‌ي مبدا بازگرد",
"Copyrights" => "حقوق انصحاري چاپ",
"Year" => "سال",
"Authors" => "مولفين",
"Add" => "اضافه كن",
"Tiki Debugger Console" => "ميز رفع اشكال تيكي",
"Current URL" => "URL كنوني",
"Command" => "دستور",
"exec" => "اجرا",
"Type <code>help</code> to get list of available commands" => "براي دريافت فهرستي از دستورات موجود، را وارد كنيد<code>help</code>",
"Syntax" => "نحو",
"Page generation debugging log" => "ثبت رويداد اشكال‌زدايي توليد صفحه",
"Features state" => "آمار خصايص",
"Total" => "مجموع",
"features matched" => "خصايص هم‌خواني دارند",
"Watchlist" => "فهرست ديده‌بان‌ها",
"duplicate" => "تكراري است",
"There are individual permissions set for this file gallery" => "حقوق دسترسي فردي براي اين سرسراي پرونده تنظيم شده است",
"Save" => "ذخيره كن",
"System" => "سامانه",
"Use" => "استفاده كنيد",
"unlimited" => "نامحدود",
"none" => "هيچكدام",
"Parent gallery" => "سرسراي مادر",
"Owner of the gallery" => "مالك سرسرا",
"Default sort order" => "مرتب‌سازي پيش‌فرض",
"Max description display size" => "بيشينه اندازه‌ي نمايش شرح",
"Please login" => "لطفا وارد شويد",
"There are no wiki pages similar to '{\$page}'" => "هيج صفحه‌ي ويكي مشابه '{\$page}' وجود ندارد",
"Create this page" => "اين صفحه را ايجاد كن",
"Close Window" => "پنچره را ببند",
"Active Perms" => "حقوق دسترسي فعال",
"Perms" => "حقوق دسترسي‌ها",
"Replace" => "جايگزين كن",
"List" => "فهرست",
"Name-filename" => "نام-نام پرونده",
"Filename only" => "تنها نام پرونده",
"Number of displayed rows" => "تعداد رديف‌هايي كه بايد نمايش داده شود",
"in:" => "در:",
"Go" => "بگرد",
"RSS Wiki" => "RSS براي ويكي",
"RSS Blogs" => "RSS براي بلاگ‌ها",
"RSS Articles" => "RSS براي مقالات",
"RSS Image Galleries" => "RSS براي سرسراهاي تصاوير",
"RSS File Galleries" => "RSS براي سرسراهاي تصاوير",
"RSS Forums" => "RSS برا انجمن‌ها",
"RSS Maps" => "RSS براي نقشه‌ها",
"RSS Directories" => "RSS براي پوشه‌ها",
"Perform action with checked:" => "با انتخاب شده‌ها:",
"Move Selected Files" => "پرونده‌هاي انتخاب شده را منتقل كن",
"Assign Permissions" => "تخصيص حقوق دسترسي به ",
"Move to" => "انتقال به",
"Filename" => "نام پرونده",
"Hi {\$mail_user} has sent you this link:" => "سلام، {\$mail_user} براي شما اين پيوند را ارسال كرده است",
"Blog post:" => "الصاق بلاگ:",
"at:" => "در:",
"Somebody or you tried to subscribe this email address at our site:" => "شما يا شخص ديگري، سعي در مشترك كردن اين پست الكترونيكي در اين پايگاه داشته‌اند:",
"To the newsletter:" => "به خبرنامه‌ي:",
"Description:" => "شرح:",
"In order to confirm your subscription you must access the following URL:" => "براي تاييد اشتراك خود، بايد اين پيوند را دنبال كنيد:",
"User:" => "نام كاربري:",
"A new message was posted to forum" => "يك پيغام جديد به انجمن الصاق شده است",
"New topic:" => "عنوان جديد:",
"Topic:" => "عنوان:",
"You sent a request with the subject:" => "شما يك درخواست با اين موضوع فرستاده‌ايد:",
"Use the subject to indicate the operation to apply:" => "از موضوع براي مشخص كردن عملي كه بايد اجرا شود استفاده كنيد:",
"GET:WikiName to get a wiki page" => "GET:'نام ويكي'، براي گرفتن نام صفحه‌ي ويكي",
"PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:'نام ويكي'، براي به‌روز رساني/ايجاد يك صفحه‌ي ويكي (از بدنه(body) براي اطلاعات صفحه استفاده كنيد)",
"APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:'نام ويكي'، براي افزودن داده به يك صفحه‌ي ويكي (از بدنه(body) براي اطلاعات صفحه استفاده كنيد)",
"PREPEND:WikiName to append the data at the top" => "PREPEND:'نام ويكي'، براي افزودن داده با بالاي صفحه",
"Tiki mail-in instructions" => "دستورالعمل 'كنترل با پست الكترونيكي' تيكي",
"Tiki mail-in auto-reply." => "پاسخ خودكار 'كنترل با پست الكترونيكي' تيكي.",
"Page not found:" => "صفحه پيدا نشد:",
"Hi," => "سلام،",
"A new message was posted to you at {\$mail_machine}" => "يك پست الكترونيكي در {\$mail_machine} براي شما ارسال شده است",
"From" => "از طرف",
"New message arrived from %s" => " يك پيغام جديد ازطرف %s دريافت شد",
"Hi" => "سلام",
"Enjoy the site!" => "از اين پايگاه لذت ببريد!",
"has requested an account on" => "درخواست يك حساب در اين‌جا كرده است",
"To validate that account, please follow the link:" => "براي معتبر ساخت آن حساب، لطفا اين پيوند را دنبال كنيد:",
"User Registration Request" => "درخواست عضويت كاربر در تيكي",
"You're invited to join my network of friends!" => "شما براي پيوستن به شبكه‌ي رفقاي من دعوت شده‌ايد!",
"The user" => "كاربر",
"registered at your site" => "در پايگاه شما ثبت‌نام كرد",
"Bye bye!" => "خداحافظ!",
"This email address has been removed to the list of subscriptors of:" => "اين پست الكترونيكي به از فهرست مشتركين اين بخش حذف شد:",
"Newsletter:" => "خبرنامه:",
"Bye bye from %s at %s" => "از %s در %s خداحافظ",
"You can unsubscribe from this newsletter following this link" => "با دنبال كردن اين پيوند، شما مي‌توانيد عضويت خود را از اين خبرنامه لغو كنيد",
"Welcome to our newsletter!" => "به خبرنامه‌ي ما خوش‌آمديد!",
"This email address has been added to the list of subscriptors of:" => "اين آدرس پست الكترونيكي اضافه شد به فهرست اشتراك‌هاي:",
"You can always cancel your subscription using:" => "شما همواره مي‌توانيد اشتراك خود را بدين‌طريق لغو نماييد:",
"Welcome to %s at %s" => "به %s در %s خوش‌آمديد",
"Email notification" => "آگاه‌ساز پست الكترونيكي تيكي",
"Your account information for %s" => "اطلاعات حساب تيكي شما براي %s",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "يك مقاله‌ي جديد به‌وسيله‌ي {\$mail_user} به {\$mail_site} در {\$mail_date|tiki_short_datetime} ارسال شد",
"You can edit the submission following this link:" => "با دنبال كردن اين پيوند مي‌تواند مورد ارسال شده را ويرايش كنيد:",
"Title:" => "عنوان:",
"Heading:" => "سرصفحه:",
"Body:" => "متن:",
"New article submitted at %s" => "مقاله‌ي جديد در %s ثبت شد",
"You or someone registered this email address at" => "شما يا شخص ديگري اين آدرس پست الكترونيكي را در اين‌جا ثبت كرده است:",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "درصورتي كه مي‌خواهيد در اين پايگاه ثبت‌نام كنيد، بايد از اين پيوند براي اولين ورود استفاده نماييد:",
"Your registration confirmation" => "اطلاعات ثبت‌نام تيكي شما",
"You will receive an email with information to login for the first time into this site" => "شما يك پست الترونيكي با اطلاعات كافي براي اولين ورود به اين پايگاه دريافت خواهيد كرد",
"View the article at:" => "مقاله را در اين‌جا مشاهده كنيد:",
"If you don't want to receive these notifications follow this link:" => "درصورتي كه نمي‌خواهيد اين اطلاعيه‌ها را دريافت كنيد، اين پيوند را دنبال نماييد:",
"View the blog at:" => "بلاگ را در اين‌جا مشاهده كنيد:",
"New blog post at %s" => "الصاق جديد بلاگ در %s",
"changed" => "تغيير كرد",
"created" => "ايجاد شده",
"New" => "جديد",
"File Description" => "شرح پرونده",
"The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "نقشه‌ي {\$mail_page} به‌وسيله‌ي {\$mail_user} در {\$mail_date|tiki_short_datetime} تغيير كرد",
"You can view the updated map following this link:" => "با دنبال كردن اين پيوند، مي‌توانيد نقشه‌ي به‌روز رساني شده را مشاهده كنيد:",
"You can edit the map following this link:" => "با دنبال كردن اين پيوند، مي‌توانيد نقشه را ويرايش كنيد:",
"The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "صفحه‌ي {\$mail_page} به‌وسيله‌ي  {\$mail_user} در {\$mail_date|tiki_short_datetime} ايجاد شد",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "صفحه‌ي {\$mail_page} به‌وسيله‌ي {\$mail_user} در {\$mail_date|tiki_short_datetime} تغيير كرد.",
"Comment:" => "ايراد نظر:",
"You can view the page by following this link:" => "مي‌توانيد با دنبال كردن اين پيوند، صفحه را مشاهده كنيد:",
"You can view a diff back to the previous version by following this link:" => "مي‌توانيد اختلاف با نسخه‌ي قبل را با دنبال كردن اين پيوند مشاهده كنيد:",
"-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-خطوط: {\$oldd}به +خطوط: {\$newd} تغيير كرد",
"The new page content follows below." => "محتواي جديد صفحه در ادامه است.",
"The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "نظر {\$mail_date|tiki_short_datetime} به صفحه‌ي {\$mail_page} توسط {\$mail_user} ايراد شد",
"New name" => "نام جديد",
"click on the map to zoom or pan, do not drag" => "براي بزرگنمايي يا حركت در نقشه، فقط كليك كنيد، نكشيد",
"Scale" => "مقياس",
"Query" => "جستار",
"Pan" => "حركت طولي-عرضي",
"Redraw" => "دوباره بكش",
"select zoom/pan/query and image size" => "اندازه‌ي تصوير و بزرگنمايي/حركت/جستار را انتخاب كنيد",
"View the Map Only" => "تنها نقشه را نمايش بده",
"Reset Map" => "نقشه را بازنشاني كن",
"Click on the map or click redraw" => "روي نقشه يا دكمه‌ي 'دوباره بكش' كليك كنيد",
"Last modification date" => "تاريخ آخرين تغييرات",
"Overview" => "نمايش",
"Legend" => "علائم اختصاري",
"Layer Manager" => "مدير لايه‌ها",
"Layer" => "لايه",
"On" => "در",
"Download Layer" => "دريافت لايه",
"you have requested to download the layer:" => "شما درخواست دريافت اين لايه را داده‌ايد:",
"Here are the files to download, do not forget to rename them:" => "پرونده‌ها براي دريافت آماده‌اند، فراموش نكنيد كه نام آن‌ها را تغيير دهيد.",
"Mapfiles" => "پرونده‌هاي نقشه",
"Mapfile" => "پرونده‌ي نقشه",
"Available mapfiles" => "پرونده‌هاي نقشه‌ي موجود",
"hits last 7 days" => "ضربت در هفت روز گذشته",
"monitor this map" => "اين نقشه را ديده‌باني كن",
"Stop Monitoring this Map" => "ديده‌باني اين نقشه را متوقف كن",
"Create a new mapfile" => "ساخت يك پرونده‌ي نقشه‌ي جديد",
"Create" => "بساز",
"Mapfile listing" => "فهرست پرونده‌هاي نقشه‌ها",
"Reload" => "باركردن مجدد",
"History" => "تاريخچه",
"You can view this map in your browser using" => "با استفاده از اين مي‌توانيد اين نقشه را در مرورگر خود مشاهده كنيد",
"Zoom out x2" => "بزرگنمايي 2برابر",
"Zoom in x2" => "بزرگنمايي 2برابر",
"Mapfile History" => "تاريخچه‌ي پرونده‌ي نقشه",
"of" => "از",
"Compare" => "مقايسه كن",
"Comparing version {\$old.version} with version {\$new.version}" => "مقايسه‌ي نسخه‌ي {\$old.version} با نسخه‌ي {\$new.version}",
"Version:" => "نسخه:",
"Current" => "جاري",
"Versions are identical" => "نسخ مشابه‌اند.",
"Legend:" => "علائم:",
"v=view" => "v=مشاهده‌ي اطلاعات",
"c=compare" => "c=مقايسه",
"d=diff" => "d=تفاوت‌ها",
"Full side-by-side diff" => "اختلافات پهلو به پهلوي كامل",
"Unified diff" => "اختلافات يك‌جهته",
"Side-by-side view" => "مشاهده‌ي پهلو به پهلو",
"User" => "كاربر",
"Ip" => "آدرس اينترنتي(IP)",
"Diff" => "تغييرات",
"Older Version" => "نسخ قبلي",
"Directories" => "پوشه‌ها",
"back to" => "برگشت به",
"Upload From Disk:" => "بارگذاري از دستگاه:",
"Upload Files" => "بارگذاري پرونده",
"Bytes maximum" => "بيشينه",
"Create Directory:" => "ايجاد پوشه:",
"index file (.shp):" => "پرونده‌ي ايندكس(.shp):",
"files to index (regexp):" => "پرونده‌ها براي ايندكس‌گذاري(regexp):",
"Message Archive" => "بايگاني پيغام‌ها",
"messages" => "پيغام‌ها",
"Unread" => "نخوانده",
"Flagged" => "علامت زده‌شده",
"Unflagged" => "بدون علامت",
"Containing" => "شامل",
"Sender" => "فرستنده",
"No messages to display" => "هيچ پيغامي براي نمايش وجود ندارد.",
"Broadcast message" => "پيغام را براي همه ارسال كن",
"OK" => "قبول",
"All users" => "تمام كاربران",
"Lowest" => "كم‌ترين ارزش",
"Low" => "كم",
"High" => "زياد",
"Very High" => "خيلي زياد",
"Send" => "بفرست",
"Compose message" => "ايجاد پيغام",
"Invalid" => "نامعتبر",
"Find replied message" => "پاسخ ارسالي را بياب",
"Archive" => "بايگاني",
"Mark as read" => "به عنوان خوانده‌شده",
"Mark as unread" => "به عنوان خوانده‌نشده",
"Mark as flagged" => "به عنوان علامت‌دار",
"Mark as unflagged" => "به عنوان بدون علامت",
"Mark" => "علامت بزن",
"Mailbox" => "صندوق پستي",
"Compose" => "ايجاد پيغام",
"Broadcast" => "ارسال همگاني",
"Sent" => "ارسال شده‌ها",
"Read message" => "خواندن پيغام",
"Return to mailbox" => "بازگشت به صندوق پستي",
"replyall" => "پاسخ به همه",
"Unflag" => "بدون علامت",
"Flag this message" => "اين پيغام را علامت بزن",
"From:" => "از:",
"Sent Messages" => "پيغام‌هاي ارسال شده",
"move to archive" => "انتقال به بايگاني",
"receiver" => "گيرنده",
"'name' parameter for tikimodule missed" => "پارامتر 'نام'(name) براي ماژول‌هاي تيكي مفقود شده است.",
"Move module up" => "ماژول را بالا ببر",
"Up" => "بالا",
"Move module down" => "ماژول را پايين ببر",
"Down" => "پايين",
"Move module to opposite side" => "ماژول را به طرف مقابل ببر",
"opp side" => "طرف مقابل",
"Unassign this module" => "اين ماژول را از انتصاي در بياور",
"Are you sure you want to unassign this module?" => "آيا از خروج انتصاب را تاييد مي‌كنيد؟",
"Thank you for installing Tikiwiki" => "از اينكه تيكي‌ويكي را نصب كرده‌ايد متشكريم",
"Select" => "انتخاب",
"Admin" => "سرپرستي",
"Admin Modules" => "مديريت ماژول‌ها",
"Modules" => "ماژول‌ها",
"Admin Menus" => "مديريت منو",
"Menus" => "فهرست‌هاي انتخاب",
"login" => "ورود",
"Pages:" => "صفحات:",
"Categories:" => "طبقات:",
"Register" => "ثبت‌نام",
"Open operator console" => "ميركار پشتيبان را باز كن",
"Logout" => "خروج",
"Switch" => "گزينه",
"Login through CAS" => "ورود به سامانه اطلاعات طريق CAS",
"Login as admin" => "ورورد با عنوان 'سرپرست'",
"eMail" => "پست الكترونيكي",
"Password" => "كلمه‌ي عبور",
"Remember me" => "مرا به خاطر داشته باش",
"week" => "هفته",
"month" => "ماه",
"year" => "سال",
"Click here to register" => "براي ثبت‌نام اين‌جا را كليك كنيد‍",
"Click here if you've forgotten your password" => "اگر كلمه‌ي عبور خود را فراموش كرده‌ايد اين‌جا را كليك كنيد",
"I forgot my password" => "من كلمه‌ي عبورم را فراموش كرده‌ام",
"Click here to login using the default security protocol" => "براي ورود با استفاده از پروتكل امنيتي پيش‌فرض، اين‌جا را كليك كنيد",
"Standard" => "معمولي",
"Click here to login using a secure protocol" => "براي ورود به‌كمك يك پروتوكل امن، اين‌جا را كليك كنيد",
"Secure" => "امن",
"Stay in ssl Mode" => "در باب ssl بمان",
"You have" => "شما",
"new messages" => "پيغام‌هاي جديد داريد",
"new message" => "پيغام جديد داريد",
"You have 0 new messages" => "شما هيچ پيغام جديدي نداريد",
"We have" => "داريم",
"submissions waiting to be examined" => "درخواست‌هايي كه منتظر بررسي هستند",
"Image Galleries" => "سرسراهاي تصاوير",
"Entire Site" => "تمام پايگاه",
"Wiki Pages" => "صفحات ويكي",
"Image Gals" => "سالن‌هاي تصاوير",
"Blog Posts" => "الصاقات بلاگ",
"Search Wiki PageName" => "جستجو در نام صفحات ويكي",
"Read More" => "اطلاعات بيشتر",
"Since your last visit on" => "از آخرين بازديد شما در",
"New Images" => "تصاوير جديد",
"Wiki Pages Changed" => "صفحه‌ي ويكي تغيير كرده‌اند",
"New Files" => "پرونده‌هاي جديد",
"New Comments" => "نظرات جديد",
"New Users" => "كاربران جديد",
"click to edit" => "ويرايش",
"Top galleries" => "سرسراهاي برتر",
"view" => "مشاهده اطلاعات",
"click to view" => "نمايش",
"Bookmarks" => "صفحه‌ياب‌ها",
"Cache" => "نهان‌ها(Cache)",
"Done" => "انجام شد",
"Del" => "حذف",
"select" => "انتخاب",
"Refresh" => "بازيابي كن",
"online users" => "كاربران روي خط",
"online user" => "كاربر روي‌خط",
"Send a message to" => "ارسال پيغام براي",
"Send a message" => "ارسال پيغام",
"vote" => "راي دادن",
"Warning" => "اخطار",
"Users" => "كاربران",
"Send Newsletter" => "خبرنامه را بفرست",
"RSS feed" => "تغذيه‌ي RSS",
"Edit blog" => "ويرايش بلاگ",
"Monitor this Blog" => "اين بلاگ را ديده‌باني كن",
"Stop Monitoring this Blog" => "ديده‌باني اين بلاگ را متوقف كن",
"Find:" => "جستجو:",
"pages" => "صفحه",
"To edit the copyright notices" => "براي ويرايش اخطاريه‌ي حق انحصاري چاپ",
"The content on this page is licensed under the terms of the" => "محتواي اين صفحه تحت اين شرايط قرار دارد",
"Permalink" => "دنباله‌ي ثابت",
"comments" => "نظرات",
"First page" => "اولين صفحه",
"Previous page" => "صفحه‌ي قبلي",
"page" => "صفحه",
"Next page" => "صفحه‌ي بعدي",
"Last page" => "آخرين صفحه",
"referenced by" => "مرجوع شده از",
"references" => "ارجاعات",
"View Comments" => "مشاهده‌ي نظرها",
"Trackback pings" => "pingهاي trackback",
"URI" => "آدرس URI",
"Blog name" => "نام بلاگ",
"List View" => "نمايش فهرستي",
"Tools Calendars" => "تقويم‌ها ابزارها",
"Check / Uncheck All" => "انتخاب همه/هيچكدام",
"Tip" => "نكته",
"Cancel Edit" => "تغييرات را لغو كن",
"Change preferences" => "تغيير تنظيمات",
"Site Ads and Banners" => "نشان‌ها و تبليغات پايگاه",
"General" => "عمومي",
"Features" => "خصيصه‌ها",
"Community" => "اجتماع",
"i18n" => "بين‌الملل سازي(i18n)",
"Module" => "ماژول",
"Meta Tags" => "فرا برچسب‌ها(meta tags)",
"Security" => "امنيت",
"User files" => "پرونده‌هاي كاربر",
"InterTiki" => "بين تيكي(Inter tiki)",
"General Settings" => "تنظيمات عمومي",
"Home Blog (main blog)" => "بلاگ مبدا(بلاگ اصلي)",
"Change settings" => "تغيير تنظيمات",
"Day" => "روز",
"Saturday" => "شنبه",
"Sunday" => "يك شنبه",
"Monday" => "دو شنبه",
"5 minutes" => "5 دقيقه",
"Permissions" => "دسترسي‌ها",
"Import CSV file" => "وارد كردن پرونده‌ي CSV",
"Import" => "ورود اطلاعات",
"Admin Groups" => "مديريت گروه‌هاي كاربري",
"Admin Users" => "مديريت كاربران",
"Gender" => "جنس",
"avatar" => "شكلك",
"Number of friends" => "تعداد دوستان",
"E-mail" => "آدرس پست الكترونيكي",
"Last login" => "آخرين ورود",
"Distance" => "فاصله",
"Number of visited pages to remember" => "تعداد صفحات ديده شده‌اي كه  بايد در ياد بماند",
"Displayed time zone" => "نمايش زمان",
"User information" => "اطلاعات كاربر",
"Private" => "شخصي",
"public" => "عمومي",
"Use double-click to edit pages" => "از double-click براي ويرايش صفحات استفاده كن",
"Show user's info on mouseover" => "هنگام اشاره‌ي موش‌واره، اطلاعات كاربر را نمايش بده",
"Tasks per page" => "وظيفه در هرصفحه",
"Messages per page" => "پيغام در هر صفحه",
"Allow messages from other users" => "دريافت پيغام از ساير كاربران مجاز است",
"Send me an email for messages with priority equal or greater than" => "هنگامي كه پيامي با درجه‌ي اولويت برابر يا بزرگتر از اين دريافت مي‌كنم، آن را با يك پست الكترونيكي برايم بفرست",
"Auto-archive read messages after x days" => "پس از چند پيغام‌هاي خوانده شده را به‌صورت خودكار بايگاني كنم؟",
"never" => "هرگز",
"My Tiki" => "تيكي من",
"My pages" => "صفحات من",
"My messages" => "پيغام‌هاي من‌",
"My tasks" => "وظايف من",
"My items" => "اقلام من",
"Settings" => "تنظيمات",
"Watches" => "ديده‌بان‌ها",
"Home Gallery (main gallery)" => "سرسراي مبدا (سرسراي اصلي)",
"MIME Type" => "نوع MIME",
"Reindex all files for search" => "تمام پرونده‌ها را براي جستجو مجددا index گزاري كن",
"Home Forum (main forum)" => "انجمن مبدا (انجمن اصلي)",
"Searches" => "جستجوها",
"Browser width" => "عرض مرورگر",
"Home Gallery" => "سرسراي مبدا",
"Galleries features" => "خصيصه‌هاي سرسراها",
"Uses Slideshow" => "از نمايش صفحه به صفحه استفاده كن(slideshow)",
"Use database to store images" => "تصاوير را در بانك اطلاعاتي نگهدار",
"Use a directory to store images" => "از يك پوشه(directory) براي نگهداري تصاوير استفاده كن",
"Directory path" => "آدرس پوشه",
"Library to use for processing images" => "كتابخانه‌ي مورد استفاده براي پردازش تصاوير",
"Uploaded image names must match regex" => "نام تصاوير بارگذاري شده بايد با اين اصطلاح همخواني داشته باشد",
"Uploaded image names cannot match regex" => "نام تصاوير بارگذاري شده نبايد با اين اصطلاح همخواني داشته باشد",
"Directory Batch Loading" => "باركردن دسته‌اي پوشه‌ها",
"Enable directory batch loading" => "باركردن دسته‌اي پوشه‌ها فعال باشد",
"Batch loading directory" => "پوشه‌ي باركردن دسته‌اي",
"Max Rows per page" => "بيشينه سطرها در هر صفحه",
"Images per row" => "تصاوير در هر سطر",
"Thumbnails size X" => "اندازه‌ي عرض تصويرك(thumbnail)",
"Thumbnails size Y" => "اندازه‌ي عرض تصويرك(thumbnail)",
"pixels" => "نقطه(پيكسل)",
"Set features" => "تنظيمات اعمال شوند",
"Exterminator" => "منهدم كننده",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "تصاويري از سرسراي سامانه كه در صفحات ويكي، مقالات و الصاق‌هاي بلاگ‌ها استفاده نمي‌شوند را حذف كن",
"Mover" => "انتقال",
"Move images from filesystem storage to database storage" => "تصاوير را به بانك اطلاعاتي منتقل كن",
"All galleries" => "تمام سرسراها",
"System Gallery" => "سرسراي سامانه",
"Gallery listing configuration" => "پيكربندي فهرست تصاوير",
"Parent" => "منشا",
"Last modified" => "آخرين تغيير",
"Change configuration" => "تغيير پيكربندي",
"Image galleries comments settings" => "تنظيمات مربوط به توضحيات سرسراهاي تصوير",
"General Preferences" => "تنظيمات  عمومي",
"Site Identity" => "عينيت پايگاه",
"Username" => "نام كاربري",
"Contact" => "تماس",
"Home Page" => "صفحه‌ي مبدا",
"Custom home" => "متناسب‌سازي مبدا",
"Date and Time Formats" => "شكل زمان و تاريخ",
"Date and Time Format Help" => "كمك در زمينه‌ي شكل زمان و تاريخ",
"Change admin password" => "تغيير كلمه‌ي عبور سرپرست",
"Change password" => "كلمه‌ي عبور را تغيير بده",
"Default x for map center" => "طول پيش‌فرض براي مركز نقشه",
"Default y from map center" => "عرض پيش‌فرض براي مركز نقشه",
"Default zoom level" => "مقدار پيش‌فرض بزرگ‌نمايي(zoom)",
"whole earth" => "تمام جهان",
"country size" => "اندازه‌ي كشور",
"city size" => "اندازه‌ي شهر",
"max zoom" => "بيشينه بزرگنمايي",
"Internationalization" => "بين‌الملل‌سازي",
"Syntax error" => "خطا در نحو",
"Intertiki client" => "ارباب‌رجوع(client) بين‌تيكي",
"Tiki Unique key" => "كليد يكتاي تيكي",
"InterTiki Slave mode" => "حالت برده در بين‌تيكي",
"Warning: overrides manually registered local users" => "اخطار: اين گزينه جايگزين كاربران ثبت‌نام كرده‌ي محلي(local) كه به‌صورت دستي وارد شده‌اند خواهد شد.",
"as master" => "به عنوان كارفرما",
"host" => "ميزبان",
"port" => "درگاه",
"Add new server" => "اضافه كردن يك سرور جديد",
"Intertiki server" => "خدمتگزار(server) بين‌تيكي",
"Intertiki Server enabled" => "سرور بين‌تيكي فعال است",
"Access Log file" => "پرونده‌ي ثبت وقايع دسترسي",
"Errors Log file" => "پرونده‌ي ثبت خطاها",
"Key" => "كليد",
"IP" => " آدرس اينترنتي(IP)",
"click here" => "اين‌جا را كليك كنيد",
"Tiki and HTTP Auth" => "تيي و تصديق هويت HTTP",
"Registration" => "ثبت‌نام",
"Users can register" => "كاربران مي‌توانند ثبت‌نام كنند",
"Use challenge/response authentication" => "از تصديق هويت رقابت/پاسخي استفاده كن",
"Allow secure (https) login" => "ورود امن (https) مجاز است",
"Require secure (https) login" => " ورود امن (https) ضروري است ",
"Duration:" => "در طول:",
"URL:" => "آدرس اينترنتي(URL):",
"Currently unused" => "هم‌اكنون استفاده نمي‌شود",
"Version 1.0" => "نسخه‌ي 1.0",
"Version 2.0" => "نسخه‌ي 2.0",
"Users can change theme" => "كاربران ثبت‌نام كرده، مي‌توانند قيافه(theme)ي خود را تغيير دهند",
"Restrict available themes" => "قيافه(theme)هاي موجود را محدود كن",
"Available styles:" => "شيوه‌هاي موجود:",
"Edit CSS" => "ويرايش CSSها",
"Theme Control" => "تنظيم قيافه(Theme)",
"Tiki Template Viewing" => "مشاهده‌ي الگوهاي تيكي",
"Edit Templates" => "ويرايش الگوها",
"General Layout options" => "تنظيمات نماي عمومي",
"logged as" => "وارد شده با عنوان",
"Alt. description (e.g. for text browsers)" => " شرح جايگزين (مثلا براي مرورگرهاي مبتني بر متن)",
"Subtitle" => "زيرنويس",
"Site menu bar" => "نوار منو پايگاه",
"Custom code" => "كد متناسب‌سازي",
"Left column" => "ستون سمت چپ",
"always" => "همواره",
"user decides" => "بنا به تصميم كاربر",
"Right column" => "ستون سمت راست",
"Site location bar" => "نوار مكان پايگاه",
"Larger font for" => "قلم درشت‌تر براي",
"Use page description:" => "از توضيحات صفحه استفاده كن",
"Bottom bar" => "نوار پايين",
"Bottom bar icons" => "تمثال‌هاي نوار پايين",
"Bottom bar debug" => "رفع اشكال نوار پايين",
"Maximum number of records in listings" => "بيشينه تعداد ركوردها در فهرست‌برداري‌ها",
"Use direct pagination links" => "دنباله‌هاي صفحه‌گذاري‌هاي مستقيم استفاده كن",
"Direction" => "جهت",
"Use Tabs" => "استفاده از برگه‌ها(tabs)",
"Layout per section" => "هر بخش، نماي مخصوص به خود را داشته باشد",
"Admin layout per section" => "مديريت نماهاي هر بخش",
"Favicon icon file name:" => "نام پروندهي تمثال(Icon) پايگاه(favicon filename):‌",
"Favicon icon MIME type:" => "نوع MIME تمثال پايگاه:",
"Generate User Map" => "نقشه‌ي كاربر را توليد كن",
"Robots" => "ماشين‌هاي خودكار",
"Waiting" => "انتظار",
"Last update" => "آخرين به‌روز رساني",
"Image galleries" => "سرسراهاي تصاوير",
"Feed for forums" => "تغذيه براي انجمن‌ها",
"Specification" => "مشخصات",
"Admin modules" => "مديريت ماژول‌ها",
"Expiration" => "انقضا",
"Refresh wiki search index now" => "راهنماي جستجوي ويكي را بازيابي كن",
"Automonospaced text" => "متون autospaceشده‌ي خودكار",
"Tables syntax" => "نحو جداول",
"|| for rows" => "|| براي سطرها",
"AutoLinks" => " پيوندهاي خودكار (AutoLinks)",
"Hotwords" => "واژگان آتشين",
"rows" => "رديف",
"Required" => "(اجباري)",
"Parameters" => "پارامترها",
"Use database to store files" => "از بانك اطلاعاتي براي نگهداري پرونده‌ها استفاده كن",
"Use a directory to store files" => "از يك پوشه براي نگهداري پرونده‌ها استفاده كن",
"dls" => "تعداد دريافت",
"Storage" => "انباره",
"Change all to db" => "همه را به بانك اطلاعاتي ببر",
"Change all to file" => "همه را به‌صورت پرونده در پوشه‌ها بگذار",
"Trackers with mirror tables" => "Trackerها با جداول آيينه‌اي",
"Use trackers with mirror tables" => "از Trackerها با جداول آيينه‌اي استفاده كن",
"Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "مقادير در جداول اختصاصي براي هر tracker نگهداري مي‌شوند. بنابراين شما مي‌توانيد به راحتي آن‌ها را خارج از تيكي‌ويكي دستكاري كنيد",
"Validate choice" => "انتخاب‌ها را تاييد اعتبار كن",
"Quota (Mb)" => "سهميه‌ي حجمي (به مگابايت)",
"Use database to store userfiles" => "براي نگهداري پرونده‌هاي كاربران از بانك اطلاعاتي استفاده كن",
"Use a directory to store userfiles" => "براي نگهداري پرونده‌هاي كاربران از يك پوشه استفاده كن",
"Create New" => "ساخت جديد",
"List authors" => "مؤلفان را فهرست كن...",
"Not Installed" => "نصب نشده است",
"Warn on edit conflict" => "هنگام بهوجود آمدن تضاد در ويرايش‌ها، هشدار بده",
"Undo" => "برگشت عمل",
"Footnotes" => "تبصره‌ها",
"Permission" => "حقوق دسترسي",
"Allow HTML" => "HTML مجاز است ",
"Sandbox" => "دست‌گرمي",
"Dumps" => " تخليه(dump)",
"Generate dump" => "نسخه‌ي تخليه(dump) را بساز",
"Download last dump" => "دريافت آخرين تثمال كامل تهيه‌ي شده",
"Pictures" => "عكس",
"Remove unused pictures" => "حذف عكس‌هاي استفاده نشده",
"Export" => "صدور اطلاعات",
"Export Wiki Pages" => "صادرات صفحات ويكي",
"Accept dashes and underscores in WikiWords" => "خط تيره و زيرخط در ويكي -كلمه‌ها مجاز است",
"Link plural WikiWords to their singular forms" => "ويكي-كلمات جمع را به مفرد آن‌ها متصل كن",
"Only with last version" => "تنها با آخرين نگارش",
"Side-by-side diff" => "اختلافات پهلو به پهلو",
"Discuss pages on forums" => "در خصوص صفحات در انجمن‌ها بحث شود",
"Similar" => "مشابهات",
"Structures" => "ساختارها",
"Open page as structure" => "صفحه را به عنوان ساختار باز كن",
"Import HTML" => "واردات HTML",
"Page creators are admin of their pages" => "سازنده‌هاي صفحات، همان مالكان آن‌ها هستند",
"MultiPrint" => "چاپ چندگانه",
"Create watch for author on page creation" => "براي ويراستار هنگام ساخت صفحات، ديده‌بان بساز",
"Enable watch events when I am the editor" => "هنگامي كه من ويراستار هستم، ديده‌بان رويدادها فعال باشد",
"Enable watches on comments" => "ديده‌بان در 'نظرات' فعال باشد",
"Links" => "پيوندها",
"Wiki 3D Browser Configuration" => "پيكربندي مرورگر 3بعدي ويكي",
"Wiki attachments" => "ضمايم ويكي",
"Change" => "تعيير بده",
"Crosslinks to other features and settings" => "دسترسي مستقيم به ساير خصيصه‌ها و تنظيمات",
"Other sections" => "ساير بخش‌ها",
"Spreadsheet" => "صفحه‌گسترده",
"Shoutbox Words" => "كلمات فريادگاه",
"Live Support" => "پشتيباني زنده",
"Contact us" => "تماس با ما",
"Administration features" => "خصيصه‌هاي مديريتي",
"SysLogs" => "ثبت وقايع",
"phpinfo" => "اطلاعات php",
"Banning" => "تحريم كردن",
"Transversal features" => "خصيصه‌هاي نوسنجي",
"which apply to more than one section" => "آن‌هايي كه به بيش از يك‌بخش اعمال مي‌شوند",
"Mail Notifications" => "آگاه‌ساز‌هاي پستي",
"Navigation features" => "خصيصه‌هاي ناوبري",
"Look & feel" => "ببين و حس كن",
"themes" => "قيافه‌ها",
"Text area features" => "خصيصه‌هاي فضاي متني",
"features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "خصيصه‌هايي كه مي‌توانيد در تمام فضاهاي متني مانند صفحات ويكي، بلاگ‌ها، مقالات، انجمن‌ها و غيره، استفاده كنيد",
"Cookies" => "كوكي‌ها",
"DSN" => "DSNها",
"Stats &amp; banners" => "آمارها و درفش‌ها",
"Search Stats" => "آمار جستجو",
"bytes" => "بايت",
"Statistics" => "آمار",
"Weeks" => "هفته",
"Setting" => "تنظيمات",
"viewed" => "مشاهده شده",
"Add or edit a rule" => "ايجاد يا تغيير قوانين",
"Rule title" => "عنوان قانون",
"Username regex matching" => "تطبيق نام كاربري",
"IP regex matching" => "تطبيق آدرس اينترنتي(IP)",
"Banned from sections" => "محروم از اين منابع",
"Rule activated by dates" => "قانون باتوجه به تاريخ فعال مي‌شود",
"Rule active from" => "قاتون از اين تارخ فعال است",
"Rule active until" => "قانون تا اين تاريخ فعال است",
"Custom message to the user" => "پيغام متناسب‌شده براي كاربر",
"Rules" => "قوانين",
"x" => "حذف",
"User/IP" => "كاربر/آدرس اينترنتي(IP)",
"Sections" => "بخش‌ها",
"Admin Calendars" => "مديريت تقويم‌ها",
"List of Calendars" => "فهرست تقويم‌ها",
"Loc" => "مكان",
"Participants" => "شركت‌كنندگان",
"Cat" => "طبقه",
"Lang" => "زبان",
"Prio" => "اولويت",
"Subscription" => "اشتراك",
"Perso" => "شخصي",
"Custom Locations" => "مكان‌هاي متناسب",
"Custom Participants" => "شركت‌كننده‌هاي متناسب",
"Custom Categories" => "طبقه‌بندي‌هاي متناسب",
"Custom Languages" => "زبان‌هاي متناسب",
"Custom Subscription List" => "فهرست اشتراك متناسب",
"Custom Priorities" => "اولويت‌هاي متناسب",
"Personal Calendar" => "تقويم شخصي",
"h" => "ساعت",
"Current category" => "طبقه‌ي جاري",
"Child categories" => "طبقات فرزند",
"Edit this category:" => "اين طبقه را ويرايش كن:",
"Add new category" => "افزودن طبقه‌ي جديد",
"Batch upload (CSV file):" => " بارگذاري دسته‌اي(Batch upload)",
"Objects in category" => "اشياء در طبقه‌ي",
"No records found." => "هيچ ركوردي يافت نشد.",
"Add objects to category" => "افزودن شيء به طبقه",
"Admin templates" => "الگوهاي سرپرستي",
"Edit this template:" => "اين الگو را ويرايش كن:",
"Create new template" => "ساخت الگوي جديد",
"Use wysiwyg editor" => "از ويراستار WYSIWYG استفاده كن",
"Use normal editor" => "از ويراستار معمولي استفاده كن",
"CMS" => "سامانه‌ي مديريت محتوي",
"HTML Pages" => "صفحات HTML",
"Templates" => "الگوها",
"Admin cookies" => "مديريت كوكي‌ها(cookies)",
"Create/edit cookies" => "ايجاد/تغيير كوكي",
"Upload Cookies from textfile" => "كوكي‌ها را از يك فايل بارگذاري كن",
"Upload from disk:" => " بارگذاري از دستگاه:",
"Upload" => "بارگذاري",
"Remove all cookies" => "تمام كوكي‌ها را حذف كن",
"cookie" => "كوكي",
"Admin dsn" => "مديريت DSNها",
"Create/edit dsn" => "ايجاد/ويرايش dsn",
"Admin external wikis" => "سرپرستي ويكي‌هاي خارجي",
"View template" => "مشاهده‌ي الگو",
"tiki admin external wikis template" => "الگوي مديريت ويكي‌هاي خارجي تيكي",
"Edit template" => "ويرايش الگو",
"Create/Edit External Wiki" => "ايجاد/تغيير ويكي‌هاي خارجي‌",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (از \$page براي جايگزيني نام صفحه در URL استفاده كنيد، مانند: http://www.example.com/tiki-index.php?page=\$page)",
"ExtWiki" => "ويكي خارجي",
"Admin Forums" => "مديريت انجمن",
"Create new forum" => "ايجاد انجمن جديد",
"List forums" => "فهرست انجمن‌ها",
"Coms" => "نظرات",
"Age" => "سن",
"PPD" => "ppd",
"Edit this Forum:" => "اين انجمن را ويرايش كن:",
"Create New Forum" => "ساخت يك انجمن جديد",
"There are individual permissions set for this forum" => "حقوق دسترسي فردي براي اين انجمن تنظيم شده است",
"Name:" => "نام:",
"Create new" => "يكي ايجاد كن",
"Password protected" => "حفاظت شده با كلمه‌ي عبور؟",
"Forum password" => "كلمه‌ي عبور انجمن:",
"Topic list configuration" => "پيكربندي فهرست عناوين",
"Posts can be rated" => "الصاق‌ها مي‌توانند ارزيابي شوند‌",
"Display last post titles" => "چند تعداد از آخرين الصاق‌ها نمايش داده شوند؟",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "پيغام‌هاي الصاق شده به اين انجمن را چنان به اين آدرس ارسال كن، كه پاسخ آن‌ها بتواند به‌عنوان الصاق در انجمن قرار گيرد:",
"Send mails even when the post is generated by inbound mail" => "حتي هنگامي كه خود الصاق به وسيله‌ي پست الكترونيكي ايجاد شده است، پست الكترونيكي را ارسال كن!؟",
"Append a reply link to outbound mails" => "يك پيوند 'پاسخ' به پست‌هاي الكترونيكي خروجي اضافه كن؟",
"Originating e-mail address for mails from this forum" => "پست‌هاي الكترونيكي ارسالي از اين انجمن، از طرف اين آدرس ارسال مي‌شوند:",
"Add messages from this email to the forum" => "پيغام‌هاي اين آدرس را در اين انجمن الصاق كن",
"Use topic smileys" => "صورتك‌هاي عناوين را نمايش بده؟",
"Show topic summary" => "خلاصه‌ي عناوين را نمايش بده؟",
"User information display" => "اطلاعات كاربر را نمايش بده؟",
"Online" => "روي خط",
"Approval type" => "نوع تصويب(approval)",
"Store attachments in:" => "ضمايم را در اين‌جا نگهداري:",
"Admin Hotwords" => "مديريت واژگان آتشين",
"Add Hotword" => "اضافه كردن واژگان آتشين",
"Word" => "واژه",
"Admin HTML pages" => "مديريت صفحات HTML",
"Edit this page" => "اين صفحه را ويرايش كن",
"View page" => "مشاهده‌ي صفحه",
"Edit zone" => "اين قلمرو را ويرايش كن",
"Dynamic zones" => "قلمرو پويا",
"zone" => "قلمرو",
"content" => "محتوي",
"Mass update" => "بارگذاري كيلويي!",
"Create new HTML page" => "يك صفحه‌ي HTML جديد ايجاد كن",
"Edit this HTML page:" => "ويرايش اين صفحه‌ي HTML:",
"Apply template" => "الگوي اعمالي",
"Dynamic" => "پويا",
"Static" => "ثابت",
"Last Modif" => "تاريخ آخرين تغيير",
"Edit Repository:" => "ويرايش مخرن:",
"Create New Repository" => "ساخت مخزن جديد",
"List Repositories" => "فهرست مخازن",
"New Repository" => "مخزن جديد",
"View Repository" => "مشاهده‌ي مخزن",
"Human readable repository name" => "نام قابل خواندن مخزن",
"Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "مسير مخزن (سامانه‌ي پرونده‌ي محلي: نسبي/مطلق ريشه‌هاي وب، از راه‌دور: بايد با 'http://' آغاز شوند)",
"File name of start page" => "نام پرونده‌ي صفحه‌ي آغازين",
"Start page" => "صفحه‌ي آغازين",
"CSS file to load when browse this repository" => "پرونده‌ي CSSاي كه بايد هنگام مرور اين مخزن بار شود",
"CSS file" => "پرونده‌ي CSS",
"Is repository visible to users" => "آيا مخزن براي كاربران عادي قابل مشاهده است؟",
"Can files from repository be cached" => "آيا پرونده‌هاي مخزن مي‌توانند cache شوند؟",
"Cacheable" => "قابل cache شدن",
"Are files from repository can be cached" => "آيا پرونده‌هاي اين مخزن قابل cache هستند؟",
"Clear all cached pages of this repository" => "تمام صفحاتي از اين مخزن كه cache شده‌اند را خالي كن",
"Clear cache" => "حافظه نهان(cache) را تخليه كن",
"Seconds count 'till cached page will be expired" => "شمارش ثانيه‌ها 'تا صفحه‌ي cache شده منقضي شود'",
"Cache expiration" => "انقضاي cache",
"Human readable text description of repository" => "متن قابل خواندن مخزن",
"Available Repositories" => "مخازن موجود",
"CSS File" => "پرونده‌هاي CSS",
"Edit rules" => "ويرايش قوانين",
"Edit Rules for Repository:" => "ويرايش قوانين مخازن:",
"Configure Repositories" => "پيكربندي مخازن",
"Configure this Repository" => "پيكربيندي اين مخزن",
"View this Repository" => "مشاهده‌ي اين مخزن",
"New Rule" => "قانون جديد",
"Copy Rules" => "كپي قوانين",
"view/hide copy rules dialog" => "مشاهده/مخفي‌كردن رونوشت محاروه‌ي(dialog) كپي قوانين",
"Source repository" => "مخزن منبع",
"Copy" => "كپي",
"According this order rules will be applied ('0' or empty = auto)" => "قوانين با توجه به اين ترتيب اعمال مي‌شوند (0 يا هيچي =خودكار)",
"Rule order" => "ترتيب قوانين",
"Text to search for" => "متن براي جستجو",
"Text to replace" => "متن براي جايگزيني",
"Is this regular expression or simple search/replacer" => "آيا اين يك مبين منظم(regular expression) است يا جستجوي/جايگزيني ساده؟",
"Is case sensitive (for simple replacer)" => "حساس به حروف؟ (براي جايگزيني ساده)",
"Case sensitive" => "حساس به حروف",
"subset of chars: imsxeADSXUu, which is regex modifiers" => "زيرمجموعه‌اي از حروف: imsxeADSXUu، كه تعديل كننده‌ي regex است",
"Regex modifiers" => "تعديل كننده‌هاي regex",
"Human readable text description of rule" => "توضيح قابل خواندن قانون",
"Check to enable this rule" => "براي فعال كردن اين قانون اين گزينه را انتخاب كنيد",
"Enabled" => "فعال شد",
"Preview options" => "اختيارات پيش‌نمايش",
"Apply all rules or just this to generate preview" => "تمام قوانين يا فقط اين را براي توليد پيش‌نمايش اعمال كن",
"Apply all rules" => "اعمال تمام قوانين",
"View source code after rules applied" => "كداصل(sourcecode) پس از اعمال قوانين نمايش بده",
"Code preview" => "پيش‌نمايش كد",
"Generate HTML preview" => "پيش‌نمايش HTML را توليد كن",
"HTML preview" => "پيش‌نمايش HTML",
"Preview Results" => "پيش‌نمايش نتايج",
"Rules List" => "فهرست قوانين",
"Case" => "اگر",
"Configure/Options" => "پيكربندي/تنظيمات",
"Admin layout" => "مديريت طرح‌بندي",
"Theme control" => "تنظيم قيافه(Theme)",
"layout options" => "اختيارات طرح‌بندي",
"Top bar" => "نوار بالا",
"Generate positions by hits" => "موقعيت‌ها اطلاعات طريق ضربات مشخص شود",
"List of featured links" => "فهرست پيوندهاي خاص",
"Position" => "موقعيت",
"Add Featured Link" => "افزودن پيوند خاص",
"Edit this Featured Link:" => "اين پيوند خاص را ويرايش كن:",
"Create new Featured Link" => "ايجاد پيوند خاص جديد",
"disables the link" => "پيوند را غيرفعال كن",
"Link type" => "نوع پيوند",
"replace current page" => "جايگزين صفحه‌ي كنوني شود",
"framed" => "قاب‌دار",
"open new window" => "پنجره‌ي جديد باز شود",
"Mail-in accounts" => "حساب‌هاي 'كنترل با پست الكترونيكي'",
"Account" => "حساب",
"Add new Mail-in account" => "افزودن حساب جديد 'كنترل با پست الكترونيكي'",
"Edit Mail-in account" => "ويرايش حساب 'كنترل با پست الكترونيكي'",
"Account name" => "نام حساب:",
"POP server" => "سرور POP(دريافت):",
"SMTP server" => "سرور SMTP(ارسال):",
"SMTP requires authentication" => "آيا سرور SMTP نياز به تصديق هويت (authentication) دارد؟",
"article-put" => "قراردادن مقاله",
"wiki-get" => "گرفتن ويكي",
"wiki-put" => "قراردادن ويكي",
"wiki-append" => "افزودن ويكي",
"Article Topic" => "عنوان مقاله",
"Admin Topics" => "مديريت عناوين",
"Article Type" => "نوع مقاله",
"Admin Types" => "مديريت انواع",
"Active" => "فعال",
"Allow anonymous acces" => "دسترسي بي‌نمام مجاز است؟",
"Allow attachments" => "ضمايم مجازند؟",
"Discard to the end from" => "از اين به بعد را دور بنداز:",
"Check Mail-in accounts" => "بررسي حساب‌هاي 'كنترل با پست الكترونيكي'",
"Check automatically" => "به‌صورت خودكار بررسي كن",
"Frequency" => "تناوب",
"mn" => "دقيقه",
"List menus" => "فهرست منوها",
"Edit this menu" => "اين منو را ويرايش كن",
"Edit menu options" => "ويرايش اختيارات منو",
"Show Quick Urls" => "URLهاي سريع را نمايش بده",
"Some useful URLs" => "چند URL سودمند",
"Hide Quick Urls" => "URLهاي سريع را مخفي كن",
"option" => "اختيارات",
"separator" => "جداكننده",
"Choose" => "انتخاب كنيد",
"Home Blog" => "بلاگ مبدا",
"Home Image Gal" => "سرسراي تصوير مبدا",
"Home Image Gallery" => "سرسراي تصوير مبدا",
"Home File Gal" => "سرسراي پرونده‌ي مبدا",
"Home File Gallery" => "سرسراي پرونده‌ي مبدا",
"User preferences" => "تنظيمات كاربر",
"User prefs" => "تنظيمات كاربر",
"List galleries" => "فهرست سرسراها",
"List image galleries" => "فهرست سرسراهاي تصوير",
"Upload image" => "بارگذاري تصوير",
"Gallery Rankings" => "امتيازدهي‌هاي سرسراها",
"Browse a gallery" => "مرور سرسرا",
"Articles home" => "مبدا مقالات",
"All articles" => "تمام مقالات",
"Submit" => "ارائه",
"List Blogs" => "فهرست بلاگ‌ها",
"Create blog" => "ايجاد بلاگ‌",
"View a forum" => "مشاهده‌ي انجمن",
"View a thread" => "مشاهده‌ي رگه",
"View a FAQ" => "مشاهده‌ي FAQ",
"Take a quiz" => "برگزاري آزمون",
"Quiz stats" => "‌وضعيت آزمون‌ها",
"Stats for a Quiz" => "آمار آزمون",
"Preview menu" => "مشاهده‌ي منو",
"Menu options" => "اختيارات منو",
"Options" => "اختيارات",
"Active Permissions" => "حقوق دسترسي فعال",
"Edit this Menu:" => "اين منو را ويرايش كن:",
"Create new Menu" => "ايجاد يك منوي جديد",
"dynamic collapsed" => "جمع‌كردن پويا",
"dynamic extended" => "بست دادن پويا",
"fixed" => "ثابت شده",
"Clear Cache" => "پاك‌سازي حافظه نهان(cache)",
"Assigned Modules" => "ماژول‌‌هاي تخصيصي داده شده",
"Left Modules" => "ماژول‌هاي سمت چپ",
"Move to Right Column" => "انتقال به ستون چپ",
"Right Modules" => "ماژول‌هاي سمت راست",
"Move to Left Column" => "انتقال به ستون راست",
"Assign new module" => "تخصيص ماژول جديد",
"Edit this assigned module:" => "اين ماژول تخصيص داده شده را ويرايش كن:",
"Cache Time" => "زمان نگهداري در نهانگاه(Cache)",
"Visibility" => "قابلت روئيت",
"Displayed now for all eligible users even with personal assigned modules" => "براي كاربران واجد شرايط كه حتي ماژولي به آن‌ها اختصاص يافته است نيز نمايش داده شود",
"Displayed for the eligible users with no personal assigned modules" => "براي كاربران واجد شرايط كه هيچ ماژول اختصاصي‌اي براي آن‌ها وجود ندارد، نمايش داده شود",
"Displayed now, can't be unassigned" => "نمايش داده مي‌شود، نمي‌تواند حذف شود",
"Not displayed until a user chooses it" => "نمايش داده نمي‌شود مگر آن‌كه كاربر انتخابش كند",
"User Modules" => "ماژول‌هاي كاربران",
"Create new user module" => "يك ماژول جديد كاربري ايجاد كن",
"Edit this user module:" => "اين ماژول كاربري را ويرايش كن:",
"Must be wiki parsed" => "بايد توسط ويكي تجزيه شده باشد",
"Objects that can be included" => "اشيائي كه مي‌توانند داخل ماژول قرار بگيرند",
"Random active poll" => "راي‌گيري فعال تصادفي",
"Random current poll" => "راي‌گيري جاري تصادفي",
"Use Poll" => "از اين راي‌گيري استفاده كن",
"Use Gallery" => "از اين سرسراها استفاده كن",
"Use Dynamic Content" => "از محتوي پويا استفاده كن",
"Use RSS Module" => "از اين ماژول RSS استفاده كن",
"Use Menu" => "از اين فهرست استفاده كن",
"Use phplayermenu" => "از اين فهرست لايه‌اي PHP استفاده كن ",
"Use Banner Zone" => "از قلمرو درفش استفاده كن",
"Structures:" => "ساختارها:",
"Data" => "داده‌ها",
"Admin newsletter subscriptions" => "مديريت اشتراك خبرنامه‌ها",
"List Newsletters" => "فهرست خبرنامه‌ها",
"Admin Newsletters" => "مديريت خبرنامه‌ها",
"Send Newsletters" => "ارسال خبرنامه‌ها",
"Add a subscription newsletters" => "افزودن يك اشتراك خبرنامه",
"Email:" => "پست الكترونيكي:",
"Add email:" => "افزودن پست الكترونيكي:",
"Add user:" => "افزودن كاربر:",
"Group subscription also subscribes included groups" => "عضويت در گروه‌ها باعث عضويت در گروه‌هاي شامل نيز مي‌شود",
"Don't send confirmation mail" => "پست الكترونيكي 'تصديق' را ارسال نكن",
"Subscribe group" => "گروه عضو شود",
"Included group, group users and emails will be refreshed at each newsletter sending" => "در هر ارسال خبرنامه، گروه‌ها، كاربران گره‌ها و پست‌هاي الكترونيكي را تازه كن",
"Subscriptions" => "اعضا",
"Valid" => "معتبر",
"Subscribed" => "عضو شد",
"Admin newsletters" => "مديريت خبرنامه‌ها",
"Editions" => "نسخه‌ها",
"Last Sent" => "آخرين ارسال",
"Create/Edit Newsletters" => "ايجاد/تغيير خبرنامه‌ها",
"There are individual permissions set for this newsletter" => "حقوق دسترسي فردي براي اين خبرنامه تنظيم شده است",
"Users can subscribe/unsubscribe to this list" => "اربران مي‌توانند عضو اين فهرست شوند و عضويت خود را لغو كنند",
"Users can subscribe any email address" => "كاربران مي‌توانند هر آدرس پست الكترونيكي را عضو كنند",
"Add unsubscribe instructions to each newsletter" => "دستورالعمل لغو عضويت را در تمام خبرنامه‌ها قرار بده",
"Validate email addresses" => "آدرس‌هاي پست الكترونيكي را تاييد اعتبار كن",
"Add notification" => "افزودن آگاه‌ساز",
"Event" => "رويداد",
"edit" => "ويرايش",
"remove" => "حذفش كن",
"Update" => "به‌روز رساني كن",
"List polls" => "فهرست راي‌گيري‌ها",
"Edit this poll" => "ويرايش اين راي‌گيري",
"Preview poll" => "پيش‌نمايش راي‌گيري",
"Poll options" => "اختيارات راي‌گيري‌ها",
"Votes" => "تعداد راي‌ها",
"Admin Polls" => "مديريت راي‌گيري‌ها",
"Set last poll as current" => "آخرين راي‌گيري را راي‌گيري جاري قرار بده",
"Close all polls but last" => "بجر آخرين راي‌گيري، ما بقي را ببند",
"Activate all polls" => "تمام راي‌گيري‌ها را فعال كن",
"active" => "فعال",
"current" => "جاري",
"object" => "شيء",
"PublishDate" => "تاريخ انتشار",
"Results" => "نتايج",
"Wiki pages" => "صفحات ويكي",
"Content for the feed" => "محتواي تغذيه",
"Security Admin" => "مديريت امنيت",
"PHP settings" => "تنظيمات PHP",
"PHP variable" => "متغيير PHP",
"Risk Factor" => "ضريب خطر",
"Explanation" => "توضيحات",
"Tiki variable" => "متغيير تيكي‌ويكي",
"Check all tiki files" => "تمام پرونده‌هاي تيكي را كنترل كن",
"Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "دقت كنيد كه اين كار ممكن است زمان بسيار زيادي بگيرد. لذا بهتر است قبل از اجراي آن، تنظيم مربوط به max_execution_time در پرونده‌ي php.ini را كنترل كنيد.",
"File checks" => "بررسي‌هاي پرونده",
"user" => "كاربر",
"group" => "گروه",
"sticky" => "چسب‌‌ناك",
"Admin Shoutbox Words" => "مديريت كلمات فريادگاه",
"Add Banned Word" => "افزودن كلمات ممنوعه",
"Are you sure you want to delete this word?" => "آيا درمورد حذف اين كلمه مطمئن هستيد؟",
"Destroy the structure leaving the wiki pages" => "هنگام خروجي از صفحات ويكي، ساختار آن‌ها را نابود كن",
"Destroy the structure and remove the pages" => "ساختار را نابود كن و صفحات را حذف نما",
"Export Pages" => "صدور صفحه",
"Dump Tree" => "dumpكردن درختواره",
"Create WebHelp" => "ساخت كمك تحت وب",
"View WebHelp" => "مشاهده‌ي كمك وبي",
"Create new structure" => "ايجاد ساختار جديد",
"Alias" => "نام مستعار",
"Tree" => "درختواره",
"Use single spaces to indent structure levels" => "براي مشخص كردن سطوح ساختار از يك 'فاصله' استفاده كنيد",
"Create New Structure" => "ايجاد ساختار جديد",
"List surveys" => "فهرست نظرسنجي‌ها",
"Survey Stats" => "آمار نظرسنجي‌",
"Edit this Survey" => "ويرايش اين نظرسنجي‌",
"Admin Surveys" => "مديريت نظرسنجي‌ها",
"Question" => "سئوال",
"One choice" => "تك انتخابي",
"Multiple choices" => "چند انتخابي",
"Short text" => "متن كوتاه",
"Rate (1..5)" => "امتياز (از 1 تا 5)",
"Rate (1..10)" => "امتياز (از 1 تا 10)",
"Rate" => "نرخ",
"Options (if apply)" => "اختيارات (اگر قابل استفاده باشند)",
"Questions" => "سئوالات",
"Admin surveys" => "مديريت نظرسنجي‌ها",
"List Surveys" => "فهرست نظرسنجي‌ها",
"Edit this Survey:" => "ويرايش اين نظرسنجي:‌",
"Create New Survey" => "ايجاد نظرسنجي جديد‌",
"There are individual permissions set for this survey" => "حقوق دسترسي فردي براي اين نظرسنجي تعيين شده است‌",
"Open" => "باز",
"Empty" => "تخليه شود",
"Fix UTF-8 Errors in Tables" => "رفع اشكالات UTF-8 در جداول",
"Warning: Make a backup of your Database before using this function!" => "اخطار: قبل از استفاده از اين تابع، يك نسخه‌ي پشتيبان از بانك اطلاعاتي خود تهيه كنيد!",
"Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "اخطار: اگر سعي در تبديل جداول بزرگ داشته داريد، بيشينه زمان اجرا را در پرونده‌ي php.ini خود بالا ببريد!",
"This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "اي تابع، رشته‌هاي كدشده با استاندارد ISO-8859-1 را در جداول شما به UTF-8 تبديل مي‌كند.",
"This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "اگر شما محتوايي را با تيكي &lt; 1.8.4 تهيه كرده باشيد و charsetپيش‌فرض در apache هروي ISO-8859-1 باشد، اين كار احتمالا ضروري است.",
"UTF-8 Errors fixed" => "خطاهاي رفع شده‌ي UTF-8",
"Investigate" => "استفسار(Investigate)",
"Fix it" => "ترميمش كن",
"Create a new topic" => "ايجاد يك عنوان جديد",
"Topic Name" => "نام عنوان",
"Upload Image" => " بارگذاري تصوير",
"List of topics" => "فهرست عناوين",
"Articles (subs)" => "زير مقالات",
"topic image" => "تصوير موضوع",
"Deactivate" => "غيرفعال شود",
"Remove with articles" => "حذف با مقالات",
"List Trackers" => "فهرست trackerها",
"Admin Trackers" => "مديريت trackerها",
"Edit This Tracker" => "ويرايش اين tracker",
"View This Tracker's Items" => "نمايش اقلام اين tracker",
"Tracker fields" => "ستون‌هاي tracker",
"Mandatory" => "اجباري؟",
"Is column visible when listing tracker items?" => "آيا اين ستون هنگام نمايش فهرست اقلام tracker نمايش داده شود؟",
"Tbl vis" => "قابل مشاهده؟",
"Column links to edit/view item?" => "از طريق اين ستون بتوان فقره را ويرايش كرد؟",
"isMain" => "اصلي؟",
"Searchable" => "قابل جستجو",
"Hidden" => "مخفي؟",
"Edit tracker field" => "ويرايش ستون‌هاي tracker",
"Field is mandatory?" => "پركردن اين ستون اجباري است؟",
"Column is searchable?" => "ستون قابل جستجو باشد؟",
"Field is hidden?" => "ستون مخفي است؟",
"not hidden" => "مخفي نيست",
"editable by admin only" => "تنها به‌وسيله‌ي سرپرست قابل تغيير است",
"Import/Export Trackers Fields" => "وارد/صادر كردن ستون‌هاي tracker",
"Found" => "پيدا شد",
"trackers" => "Trackerها",
"Edit Tracker" => "ويرايش tracker",
"There are individual permissions set for this tracker" => "حقوق دسترسي فردي براي اين tracker تعريف شده است",
"No individual permissions. Global permissions apply." => "بدون حقوق دسترسي فردي. حقوق دسترسي عمومي اعمال مي‌شوند.",
"Show status" => "وضعيت را نمايش بده؟",
"Default status displayed in list mode" => "وضعيت پيش‌فرض براي نمايش در حالت فهرست",
"Show status to tracker admin only" => "وضعيت را تنها به سرپرست‌ها نمايش بده",
"Send copies of all activity in this tracker to this e-mail address" => "ارسال رونوشت تمام فعاليت‌ها در اين tracker به اين آدرس:",
"Use simplified e-mail format" => "از شكل ساده شده‌ي پست الكترونيكي استفاده كن",
"New items are created with status" => "اقلام جديد با اين وضعيت ايجاد شوند:",
"Authoritative status for modified items" => "وضعيت‌ها مجاز براي اقلام ويرايش شده:",
"No change" => "بدون تغيير",
"Item creator can modify his items?" => "آيا ايجاد كننده‌ي يك فقره، مي‌تواند آن را تغيير دهد؟",
"The tracker needs a user field with the option 1" => "(tracker به يك رشته‌ي كاربري option برابر 1 نياز دارد)",
"The tracker needs a group field with the option 1" => "(tracker به يك رشته‌ي گروه كاربري option برابر 1 نياز دارد)",
"Show creation date when listing tracker items?" => "نمايش تاريخ ايجاد در فهرست اقلام trakcerها؟",
"Show lastModif date when listing tracker items?" => "نمايش آخرين تاريخ تغيير در فهرست اقلام trakcerها؟",
"What field is used for default sort?" => "اقلام به‌صورت پيش‌فرض به كدام ترتيب باشند؟",
"What is default sort order in list?" => "ترتيب پيش‌فرض در داخل فهرست چيست؟",
"ascending" => "صعودي",
"descending" => "نزولي",
"Tracker items allow ratings?" => "امكان امتيازدهي به اقلام trackerها؟",
"with values" => "با مقادير",
"and display rating results in listing?" => "و امتيازات را در فهرست نمايش بده؟",
"Tracker items allow comments?" => "امكان نظردهي درخصوص اقلام؟",
"and display comments in listing?" => "و نظرات را در فهرست نمايش بده؟",
"Tracker items allow attachments?" => "امكان ضميمه كردن به اقلام؟",
"and display attachments in listing?" => "و نمايش ضميمه‌ها در فهرست",
"Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "اختيارات در نمايش ضمايم (از اعداد براي ترتيب‌دهي استفاده كنيد، 0(صفر)ها نمايش داده نمي‌شوند و اعداد منفي در popupها نمايش داده مي‌شوند.",
"Filesize" => "حجم پرونده",
"Filetype" => "نوع پرونده",
"LongDesc" => "توضيحات",
"Import/Export" => "واردات/صادرات",
"Import/export trackers" => "وارد/صادر كردن trackerها",
"Admin groups" => "سرپرستي گروه‌هاي كاربران",
"Admin users" => "سرپرستي كاربران",
"Add new group" => "اضافه كردن گروه جديد",
"List of existing groups" => "فهرست گروه‌هاي موجود",
"Edit group" => "ويرايش گروه",
"Add a New Group" => "افزودن يك گروه جديد",
"Use wiki page name or full URL" => "از نام صفحات ويكي و يا URL كامل استفاده كنيد",
"Group Information Tracker" => "tracker اطلاعات گروه‌ها",
"choose a group tracker ..." => "يك tracker گروه انتخاب كنيد",
"choose a field ..." => "يك ستون انتخاب كنيد ...",
"Users Information Tracker" => "tracker اطلاعات كاربران",
"choose a users tracker ..." => "يك tracker كاربر انتخاب كنيد...",
"Group tracker item : {\$groupitemid}" => "فقره tracker فقره : {\$groupitemid}",
"Edit Item" => "ويرايش فقره",
"Group tracker item not found" => "فقره tracker گروه يافت نشد",
"Members" => "اعضا",
"users in group" => "كاربران در گروه",
"Add a New User" => "اضافه كردن يك كاربر جديد",
"Reason" => "مشكل:",
"Registered" => "اعضا",
"to groups" => "به گروه(هاي)",
"Remove Users and their Userpages" => "كاربران و صفحات آن‌ها را حذف كن",
"Manage Group Assignments" => "عضويت گروه‌هايشان رو مديريت كن",
"Set Default Groups" => "غضو گروه‌هاي كاربري پيش‌فرض كن",
"Assign selected to" => "انتخاب شده‌ها را منتصب كنيد به",
"Remove selected from" => "انتخاب شده‌ها را حذف كنيد از",
"the following groups:" => "گروه‌هاي ذيل:",
"bcc" => "رونوشت مخفي",
"Edit user" => "ويرايش كاربر",
"Generate a password" => "يك كلمه‌ي عبور توليد كن ",
"User tracker item : {\$usersitemid}" => "فقره tracker كاربر: {\$usersitemid}",
"Overwrite" => "روي اطلاعات قبلي بنويس",
"Source" => "منبع",
"Admin Article Types" => "مديريت انواع مقالات",
"List of types" => "فهرست انواع",
"Shows up in the drop down list of article types" => "در فهرست كركره‌اي انواع مقالات نمايش داده مي‌شود.",
"Allow ratings by the author" => "اجازه‌ي امتيازدهي به‌وسيله‌ي مولف.",
"Show before publish date" => "نمايش قبل از انتشار",
"non-admins can view before the publish date" => "كاربران عادي مي‌توانند قبل از تاريخ انتشار مشاهده كنند.",
"Show after expire date" => "نمايش بعد از انقضا",
"non-admins can view after the expire date" => "كاربران عادي مي‌توانند بعد از انقضا مشاهده كنند.",
"Heading only" => "فقط سرصفحه",
"No article body, heading only" => "بدون متن، تنها سرصفحه",
"Allow comments for this type" => "نظردهي براي اين نوع مجاز است",
"Comment Can Rate Article" => "نظرات در امتياز دخيل‌اند",
"Allow comments to include a rating value" => "نظرات در تعيين امتياز مقاله تاثير دارند.",
"Show image" => "نمايش تصوير",
"Show topic or own image" => "عنوان يا تصوير خود را نمايش بده.",
"Show avatar" => "نمايش شكلك",
"Show author's avatar" => "شكلك مؤلف را نمايش بده",
"Show author" => "نمايش مؤلف",
"Show author name" => "نام مؤلف را نمايش بده",
"Show publish date" => "تاريخ تاليف را نمايش بده",
"Show expire date" => "تاريخ انقضا را نمايش بده",
"Show reads" => "نمايش خوانده‌شدن",
"Show the number of times the article was read" => "تعداد دفعاتي كه اين مقاله خوانده شده را نمايش بده",
"Show size" => "حجم را نمايش بده",
"Show the size of the article" => "حجم مقاله را نمايش بده",
"Show topline" => "نمايش خط مقدم",
"Show a small title over the title" => "يك عنوان كوچك بالاي عنوان اصلي نمايش بده",
"Show subtitle" => "نمايش زيرنويس",
"Show the subtitle" => "،نمايش زيرنويس!",
"Show source" => "نمايش منبع",
"Show link to source after article body" => "پس از متن مقاله، پيوند به منبع را نمايش بده",
"Show Image Caption" => "عنوان تصوير را نمايش بده",
"Show a legend under the image" => "علائم و اختصارات را زير تصوير نمايش بده",
"Show Language" => "نمايش زبان",
"Show the language" => "زبان را نمايش بده",
"Creator can edit" => "امكان ويرايش خالق",
"The person who submits an article of this type can edit it" => "شخصي كه مقاله‌اي از اين دسته را ارائه كرده است، بتواند آن‌را ويرايش كند",
"Show lang" => "نمايش زبان",
"Review" => "مرور",
"Classified" => "طبقه‌بندي شده",
"Create a new type" => "ساخت نوع جديد",
"Group Information" => "اطلاعات گروه",
"level" => "مرحله",
"Create level" => "ايجاد مرلحه",
"all permissions in level" => "تام حقوق دسترسي در مرحله",
"backlinks to" => "پيوندهاي معكوس به",
"No backlinks to this page" => "هيچ پيوند معكوسي براي اين صفحه وجود ندارد",
"Browse Gallery" => "مرور سرسرا",
"Upload From Disk" => " بارگذاري از دستگاه",
"Process" => "فرايند",
"Edit Post" => "ويرايش الصاق",
"View Blog" => "مشاهده‌ي بلاگ",
"Use ...page... to separate pages in a multi-page post" => "براي جدا كردن صفحات در يك الصاق چندصفحه‌اي، از ...page... استفاده كنيد",
"Body" => "مات",
"Upload image for this post" => "بارگذاري تصوير براي اين الصاق",
"Trash" => "خاكروبه",
"Mark entry as private:" => "اين الصاق، خصوصي است",
"Spellcheck" => "بررسي املايي",
"Save and Exit" => "ذخيره كن و خارج شو",
"Powered by" => "فراهم شده به‌وسيله‌ي",
"Made with" => "ساخته شده با",
"powered by" => "فراهم شده به‌وسيله‌ي",
"Wiki RSS" => "RSS ويكي",
"Blogs RSS" => "RSS بلاگ‌ها",
"Articles RSS" => "RSS مقالات ",
"Image Galleries RSS" => "RSS سرسراهاي تصاوير",
"File Galleries RSS" => "RSS سرسراهاي پرونده",
"Forums RSS" => "RSS انجمن‌ها",
"Maps RSS" => "RSS نقشه‌ها",
"Execution time" => "زمان اجرا",
"Memory usage" => "ميزان استفاده از حافظه",
"Server load" => "بار سرور",
"Admin Category" => "مديريت طبقه",
"Browse in" => "مرور در",
"Trackers Items" => "اقلامtrackerها",
"Sheets" => "ورق‌ها",
"Hide subcategories objects" => "اشياء زيرطبقات را مخفي كن",
"Show subcategories objects" => "اشياء زيرطبقات را هم نشان بده",
"List Galleries" => "فهرست سرسراها",
"Edit Gallery" => "ويرايش سرسرا",
"Rebuild Thumbnails" => "تصويرك‌ها را مجددا بساز",
"List Gallery" => "نمايش اقلام",
"Sort Images by" => "تصاوير مرتب بر اساس",
"Subgallery" => "زير سرسرا",
"Hit" => "ضربه(hit)",
"Original Size" => "اندازه‌ي سازمان",
"rotate right" => "چرخش به راست",
"rotate" => "چرخش",
"Details" => "جزئيات",
"You can include the image in a tiki page using one of these lines" => "به كمك يكي از اين خطوط مي‌توانيد تصوير دلخواه خود را در يك صفحه‌ي تيكي بگنجانيد",
"Return to Gallery" => "بازگشت به سرسرا",
"Edit Image" => "ويرايش تصوير",
"First Image" => "اولين تصوير",
"Prev Image" => "تصوير قبلي",
"Smaller" => "كوچكتر",
"Bigger" => "بزرگتر",
"Popup window" => "پنجره‌ي Popup",
"Next Image" => "تصوير بعدي",
"Last Image" => "آخرين تصاوير",
"Click to zoom" => "براي بزرگنمايي اين‌جا را كليك كنيد",
"Image Name" => "نام تصوير",
"Image Scale" => "مقياس تصوير",
"Latitude (WGS84/decimal degrees)" => "عرض جغرافيايي (درجه‌ي دهدهي بر اساس WGS84)",
"Longitude (WGS84/decimal degrees)" => "طول جغرافيايي (درجه‌ي دهدهي بر اساس WGS84‌)",
"Move image" => "انتقال تصوير",
"Stop Monitoring this Page" => "ديده‌باني اين صفحه را متوقف كن",
"Monitor this Page" => "اين صفحه را ديده‌باني كن",
"Group Calendars" => "تقويم‌هاي گروهي",
"Tentative" => "آزمايشي",
"Confirmed" => "تاييد شد",
"Cancelled" => "لغو شد",
"Change Focus" => "تغيير تمركز",
"Edit Calendar Item" => "ويرايش فقره جديد در تقويم",
"New Calendar Item" => "ايجاد فقره‌ي جديد در تقويم",
"Tuesday" => "سه شنبه",
"Wednesday" => "چهار شنبه",
"Thursday" => "پنج شنبه",
"Friday" => "جمعه",
"January" => "ژانويه",
"February" => "فوريه",
"March" => "مارس",
"April" => "آوريل",
"May" => "مي",
"June" => "جون",
"July" => "جولاي",
"August" => "اگوست",
"September" => "سپتامبر",
"October" => "اكتبر",
"November" => "نوامبر",
"December" => "دسامبر",
"times" => "بار",
"End" => "پايان",
"Duration" => "مدت زمان",
"Organized by" => "سازماندهي شده به‌وسيله‌ي",
"Roles" => "قوانين",
"import" => "وارد كن",
"Change password enforced" => "تغيير كلمه‌ي عبور اجباري است",
"Send a message to us" => "يك پيغام براي ما بفرستيد",
"Contact us by email" => "تماس با ما از طريق پست الكترونيكي",
"Click here to send us an email" => "براي ارسال يك پست الكترونيكي به ما، اين‌جا را كليك كنيد",
"Contacts" => "تماس‌ها",
"Create/edit contacts" => "ايجاد/ويرايش تماس",
"First Name" => "نام كوچك",
"Last Name" => "نام خانوادگي",
"Nickname" => "نام مستعار",
"You can browse the generated WebHelp here" => "شما مي‌توانيد 'كمك تحت‌وب' توليد شده را اينجا مرور كنيد",
"Structure" => "ساختار",
"Top page" => "صفحه‌ي بالا",
"Add a new site" => "افزودن يك پايگاه جديد",
"You cannot add sites until Directory Categories are setup." => "قبل از تنظيم طبقات پوشه‌ها، نمي‌توانيد پايگاهي اضافه كنيد.",
"Please contact the Site Administrator" => "لظفا با سرپرست پايگاه تماس بگيريد.",
"Site added" => "پايگاه اضافه شد",
"Directory Administration" => "مديريت پوشه‌ها",
"There are" => "تعداد",
"invalid sites" => "پايگاه بي‌اعتبار",
"valid sites" => "پايگاه معتبر",
"Users have visited" => "كاربران ديده‌اند:",
"sites from the directory" => "عدد از اين پوشه.",
"Users have searched" => "كاربران جستجو كرده‌اند:",
"times from the directory" => "بار از اين پوشه.",
"Related" => "مرتبط",
"Sites" => "پايگاه‌ها",
"Validate" => "تاييد",
"Admin directory categories" => "مديريت طبقات پوشه‌ها",
"Add a directory category" => "افزودن يك طبقه‌ي پوشه‌اي",
"Edit this directory category" => "اين پوشه‌ي طبقات را ويرايش كن",
"Children type" => "انواع فرزند",
"Maximum number of children to show" => "بيشينه تعداد فرزنداني كه نمايش داده مي‌شود",
"Editor group" => "گروه ويراستار",
"cType" => "نوع طبقه",
"allow" => "مجاز",
"count" => "تعداد",
"editor" => "ويراستار",
"relate" => "ارتباط",
"Mutual" => "دوجانبه",
"Admin sites" => "مديريت پايگاه‌ها",
"Is valid" => "آيا معتبر است؟",
"New Sites" => "پايگاه‌هاي جديد",
"Cool Sites" => "پايگاه‌هاي بامزه(cool)",
"Add a Site" => "اضافه كردن يك پاگاه",
"any" => "هركدام از",
"in entire directory" => "در بين تمام پوشه‌ها‌",
"Sort by" => "مرتب بر اساس",
"name (desc)" => "نام (نزولي)",
"name (asc)" => "نام (صعودي)",
"hits (desc)" => "ضربت-hit- (نزولي)",
"hits (asc)" => "ضربت-hit- (صعودي)",
"creation date (desc)" => "تاريخ ايجاد (نزولي)",
"creation date (asc)" => "تاريخ ايجاد (صعودي)",
"last updated (desc)" => "آخرين تغيير (نزولي)",
"last updated (asc)" => "آخرين تغيير (صعودي)",
"Added" => "اضافه شد",
"Last updated" => "تاريخ آخرين تغيير",
"Total links" => "مجموع پيوندها",
"Links to validate" => "پيوندهايي كه بايد بررسي شوند",
"Searches performed" => "جستجو انجام شده",
"Total links visited" => "مجموعه صفحاتي كه ديده شده",
"Directory ranking" => "امتيازدهي به پوشه‌ها",
"Search results" => "نتيجه‌ي جستجو",
"Validate sites" => "پايگاه را تاييد اعتبار كنيد",
"Edit article" => "ويرايش مقاله",
"List Articles" => "فهرست مقالات",
"View Articles" => "مشاهده‌ي مقالات",
"Topline" => "خط بالايي",
"Author Name" => "نام مولف",
"Own Image" => "تصوير مخصوص",
"Article image" => "تصوير مقالات",
"Use own image" => "از تصوير مخصوص استفاده كن؟",
"Float text around image" => "متن را حول تصوير شناور كن",
"Own image size x" => "طول تصوير اختصاصي",
"Own image size y" => "عرض تصوير اختصاصي",
"Image caption" => "عنوان تصوير",
"Publish Date" => "تاريخ انتشار",
"Expiration Date" => "تاريخ انقضا",
"Edit or create banners" => "ويرايش يا ساخت درفش‌ها",
"List banners" => "فهرست درفش‌ها",
"URL to link the banner" => "URL براي پيوند درفش",
"Client" => "نرم‌افزار بخش كاربر",
"Max impressions" => "بيشينه تعداد نمايش",
"Show the banner only between these dates" => "درفش را تنها در اين بازه‌ي تاريخي نمايش بده",
"From date" => "از تاريخ",
"To date" => "تا تاريخ",
"Use dates" => "هر هيچ حالت بعد از تاريخ فعال نباشد",
"Show the banner only in this hours" => "درفش را تنها در اين ساعات نمايش بده",
"Show the banner only on" => "درفش را تنها در اين روزها نمايش بده",
"Mon" => "دوشنبه",
"Tue" => "سه‌شنبه",
"Wed" => "چهارشنبه",
"Thu" => "پنج‌شنبه",
"Fri" => "جمعه",
"Sat" => "شنبه",
"Sun" => "يك شنبه",
"Select ONE method for the banner" => "تك شيوه براي درفش انتخاب كنيد",
"Use HTML" => "از HTML استفاده كن",
"Use image" => "از تصوير استفاده كن:",
"Image:" => "تصوير:",
"Current Image" => "تصوير كنوني",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "از تصوير توليد شده توسط URL استفاده كن.(تصوير براي هر مشاهده به‌وسيله‌ي URL درخواست خواهد شد)",
"Use text" => "از متن استفاده كن",
"Save the Banner" => "درفش را ذخيره كن",
"Remove Zones (you lose entered info for the banner)" => "قلمروها را حذف كن(اطلاعات مربوط به درفش‌ها را از دست خواهيد داد)",
"Create Blog" => "ايجاد بلاگ",
"Current heading" => "سرصفحه‌ي كنوني",
"There are individual permissions set for this blog" => "حقوق دسترسي فردي براي اين بلاگ تنظيم شده است",
"Number of posts to show" => "تعداد الصاق‌هايي كه بايد نشان داده شود",
"Allow other user to post in this blog" => "به ديگر كاربران اجازه‌ي الصاق در اين بلاگ را بده",
"Allow search" => "اجازه‌ي جستجو را بده",
"Allow comments" => "اجازه‌ي نظردادن(commenting) را بده",
"Show user avatar" => "شكلك كاربر را نمايش بده",
"Blog heading" => "سرصفحه‌ي بلاگ",
"Edit Style Sheet" => "ويرايش سبك نگارش",
"Style Sheet" => "سبك نگارش",
"choose a stylesheet" => "يك سبك نگارش انتخاب كنيد",
"Try" => "تلاش",
"Colored text" => "متن رنگي",
"Box content" => "محتواي جعبه",
"Dynamic variables" => "متغييرهاي پويا",
"Inserts an editable variable" => "يك متغيير قابل ويرايش درج مي‌كند",
"External links" => "پيوندهاي خارجي",
"For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "براي يك ويكي خارجي، از 'نام ويكي خارجي': نام صفحه يا ((نام ويكي خارجي': نام صفحه)) استفاده كنيد",
"Square Brackets" => "كروشه‌هاي مربع",
"Use [[foo] to show [foo]." => "از [[foo] براي نمايش[foo] استفاده كنيد.",
"Wiki References" => "مرجع‌هاي ويكي",
"JoinCapitalizedWords or use" => "كلمات با حروف بزرگ را ادغام كن و يا از اين استفاده كن",
"page|description" => "صفحه|توضحيات",
"for wiki references" => "براي مراجع ويكي",
"SomeName" => "نامي",
"prevents referencing" => "ممانعت از ارجاع‌دهي",
"Lists" => "فهرست‌ها",
"for bullet lists" => "براي فهرست گلوله‌اي",
"for numbered lists" => "براي فهرست شماره‌اي",
"for definiton lists" => "براي فهرست معنا",
"Tables" => "جداول",
"Title bar" => "ميله‌ي عنوان",
"Multi-page pages" => "صفحات چندصفحه‌اي",
"Non parsed sections" => "بخش تجزيه نشده",
"Prevents wiki parsing of the enclosed data." => "از تجزيه‌ي داده‌ي پيوست توسط ويكي ممانعت مي‌كند.",
"Preformated sections" => "شكل‌دهي اوليه‌ي بخش‌ها",
"Block Preformatting" => "شكل‌دهي اوليه را مسدود كن",
"Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "متن پيش‌تاخته را با هر تعداد فاصله‌ي خالي را يك بلوك تك فاصله‌اي تبديل كن كه هنوز ساير دستورالعمل‌هاي شكل‌بندي ويكي را رعايت مي‌كند. از همان تعداد فاصله كه شما وارد كرده‌اي استفاده خواهد شد. توجه كنيد كه اين حالت از تك فاصله‌ها و خط شكن‌ها جلوگيري نمي‌كند؛ براي اين‌كار از ~pp~...~/pp~ استفاده كنيد.",
"No description available" => "توضيحي موجود نيست",
"Browse Images" => "مرور تصوير",
"Edit successful!" => "ويرايش موفقيت‌آميز بود!",
"The following image was successfully edited" => "تصوير مقابل با موفقيت ويرايش شد",
"Image Description" => "شرح تصوير",
"You can view this image in your browser using" => "به اين طريق مي‌توانيد تصوير را در مرورگر خود ببينيد",
"You can include the image in an HTML page using one of these lines" => "به كمك يكي از اين خطوط مي‌توانيد تصوير دلخواه خود را در يك صفحه‌ي HTML بگنجانيد",
"Edit or ex/import Languages" => "ويرايش يا وارد/صادر كردن زبان",
"Edit and create Languages" => "ويرايش و ايجاد زبان‌ها",
"Edit and create languages" => "ويرايش و ايجاد زبان‌ها",
"Create Language" => "ساخت زبان",
"Shortname" => "نام كوتاه",
"like" => "مانند",
"Longname" => "نام بلند",
"Select the language to edit" => "زبان را براي ويرايش انتخاب كنيد",
"Add a translation" => "يك ترجمه اضافه كن",
"Edit translations" => "ويرايش ترجمه",
"Translate recorded" => "ترجمه ظبط شد",
"Translation" => "ترجمه",
"reset table" => "جدول را بازبنشان",
"Create New Block" => "يك بلوك جديد ايجاد كن",
"Return to block listing" => "به فهرست بلوك‌ها بازگرد",
"Block description: " => "توضيحات بلوك: ",
"You are editing block:" => "شما در حال ويرايش اين بلاك هستيد:",
"Publishing date" => "تاريخ انتشار",
"Publishing Date" => "تاريخ انتشار",
"Edit question options" => "ويرايش اختيارات سئوالات",
"List Quizzes" => "فهرست آزمون‌ها",
"Quiz Stats" => "آمار آزمون‌ها",
"This Quiz Stats" => "آمار اين آزمون",
"Edit this Quiz" => "اين آزمون را ويرايش كن",
"Admin Quizzes" => "مديريت آزمون‌ها",
"Create/edit options for question" => "ايجاد/ويرايش اختيارات براي سئوال‌ها",
"Option" => "اختيار(Option)",
"points" => "امتياز",
"Quiz" => "آزمون",
"canRepeat" => "قابل تكرار",
"timeLimit" => "زمان آزمون",
"Create/edit quizzes" => "ايجاد/تغيير آزمون‌ها ",
"There are individual permissions set for this quiz" => "براي اين آزمون، حقوق دسترسي فردي تنظيم شده است.",
"Quiz can be repeated" => "امكان شركت مجدد در آزمون وجود دارد",
"Store quiz results" => "نتايج آزمون‌ها را نگهداري كن",
"Immediate feedback" => "نتيجه را بلافاصله به كاربر اعلام كن",
"Show correct answers" => "جواب‌هاي صحيح را نمايش بده",
"Shuffle questions" => "سئوالات را درهم‌ريخته انتخاب كن",
"Shuffle answers" => "جواب‌ها را درهم ريخته نشان بده",
"Quiz is time limited" => "زمان آزمون محدود است",
"Maximum time" => "بيشينه زمان",
"Passing Percentage" => "نمره‌ي قبولي",
"Edit quiz questions" => "ويرايش سئوالات آزمون",
"Create/edit questions for quiz" => "ايجاد/ويرايش سئوال‌ها براي آزمون",
"Question Type" => "نوع سئوال",
"Import questions from text" => "سئوالات را از متن دريافت كن",
"Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "دستورالعمل: سئوالات چندگزينه‌اي خود را در زير تايپ كنيد. در خط اول سئوال و در خطوط بعدي در هر خط پاسخ‌ها را وارد كنيد. سئوال‌هاي بعدي را با يك خط خالي از هم جدا كنيد. پاسخ‌هاي صحيح را با \"*\" مشخص كنيد (ستاره‌ي خالي، بدون گيومه).",
"Input" => "ورودي",
"maxScore" => "امتياز بيشينه",
"From Points" => "از امتياز",
"To Points" => "تا امتياز",
"Answer" => "پاسخ",
"Modify Structure" => "اصلاح ساختار",
"You will remove" => "شما حذف خواهيد كرد:",
"and its subpages from the structure, now you have two options:" => "و زيرصفحات آن را از ساختار، حالا شما تو انتخاب داريد:",
"Remove only from structure" => "تنها از ساختار حذفش كن",
"Remove from structure and remove page too" => "از ساختار حذفش كن و خود صفحه را نيز حذف كن",
"Structure Layout" => "طرح‌بندي ساختار",
"Promote" => "ارتقا",
"Demote" => "تنزل",
"Previous" => "قبلي",
"Current Node" => "گره‌ي كنوني",
"Page alias" => "نام مستعار صفحه",
"Add pages to current node" => "افزودن صفحه به گره‌ي كنوني",
"After page" => "پس از صفحه",
"Create Page" => "ساخت صفحه",
"Use pre-existing page" => "از صفحات موجود استفاده كن",
"Submit article" => "ارائه‌ي مقاله",
"List Submissions" => "فهرست ارائه‌ها",
"<b>*</b>=optional" => "<b>*</b>=اختياري",
"<b>Topline</b>=small line above Title" => "<b>خط اوليه</b>=خط كوچك بالاي تيتر",
"<b>Source</b>=URL to article source" => "<b>منبع</b>=URLاي به منبع مقاله",
"Edit templates" => "ويرايش الگوها",
"Template listing" => "فهرست الگوها",
"Available templates" => "الگوهاي موجود",
"Save Only in the Theme:" => "ذخيره فقط براي قيافه‌ي ",
"Edit a topic" => "ويرايش يك موضوع",
"You must specify the object language" => "بايد زبان شيء را مشخص كنيد",
"The object doesn't exist" => "شيء وجود ندارد",
"The object doesn't have a language" => "شيء زباني ندارد",
"The object has already a translation for this language" => "اين شيء قبلا براي اين زبان ترجمه شده است",
"The object is already in the set of translations" => "اين شيء از قبل در مجموعه‌ي ترجمه‌ها وجود داشته است",
"detach" => "جداسازي",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "'دست‌گرمي' صفحه‌اي است كه شما مي‌توانيد مهارت ويرايش خود را تمرين كنيد. از خصيصه‌ي 'پيش‌نمايش' براي روئيت شماي صفحه استفاده كنيد، هيچ نسخه‌اي براي اين صفحه نگهداري نمي‌شود.",
"Upload picture" => "بارگذاري تصوير",
"Admin Content Templates" => "مديريت الگوهاي محتوي",
"Import page" => "وارد كردن صفحه",
"export all versions" => "تمام نسخ را صادر كن",
"Year:" => "سال:",
"Authors:" => "مولفين:",
"Manage structures" => "مديريت ساختارها",
"License" => "پروانه",
"Important" => "مهم",
"My Footnotes" => "تبصره‌هاي من",
"Use rating" => "از امتيازدهي استفاده كن",
"There is no available poll template." => "هيچ الگوي راي‌گيري‌اي وجود ندارد.",
"You should ask an admin to create them." => "براي ايجاد آن‌ها بايد از مديريت درخواست كنيد.",
"an existing poll" => "يك راي‌گيري موجود",
"votes" => "راي",
"status" => "آمار",
"lastModif" => "آخرين تغييرات",
"Admin FAQ" => "مديريت FAQ",
"List FAQs" => "فهرست سئوالات متداول",
"View FAQ" => "مشاهده‌ي FAQ",
"Edit this FAQ" => "ويرايش اين FAQ",
"New Question" => "سئوال جديد",
"Use a question from another FAQ" => "استفاده از يك سئوال در FAQ ديگر",
"FAQ questions" => "سئوالات FAQ",
"Suggested questions" => "سئوالات پيشنهاد شده",
"No suggested questions" => "بدون سئوال پيشنهادي",
"Upload File" => "بارگذاري پرونده",
"View tpl" => "مشاهده‌ي الگو",
"File Galleries tpl" => "الگوي سرسراهاي پرونده",
"You can access the file gallery using the following URL" => "شما مي‌توانيد به كمك اين آدرس به سرسراهاي پرونده‌ها دسترسي پيدا كنيد",
"Admin forums" => "مديريت انجمن‌ها",
"Edit queued message" => "ويرايش پيغام‌هاي در صف",
"make this a thread of" => "اين را به يك گره تبديل كن از",
"None, this is a thread message" => "هيچ‌كدام، اين يك پيغام رگه‌اي است",
"summary" => "خلاصه",
"normal" => "معمولي",
"announce" => "اعلام",
"hot" => "برانگيخته",
"no feeling" => "بدون احساس",
"frown" => "اخمو",
"exclaim" => "متعجب",
"idea" => "متفكر",
"neutral" => "معمولي",
"question" => "پرسش‌گر",
"happy" => "شاد",
"wink" => "چشمك",
"Save and Approve" => "ذخيره و تاييد",
"convert to topic" => "تبديل به عنوان",
"List of messages" => "فهرست پيغام‌ها",
"New Topic" => "عنوان جديد",
"no summary" => "بدون خلاصه",
"No messages queued yet" => "هنوز هيچ پيغامي در صف قرار نگرفته است",
"Last Post" => "آخرين الصاق",
"Configure Forum" => "پيكربندي انجمن‌ها",
"Reported by" => "گزارش شده به‌وسيله‌ي",
"Pending requests" => "درخواست‌هاي رفاقت معلق",
"Request Time" => "زمان درخواست",
"Accept" => "قبول شده",
"Refuse" => "رد مي‌كنم",
"Waiting requests" => "درخواست‌هاي در انتظار",
"Your friends" => "دوستان شما",
"break friendship" => "قطع ارتباط(رفاقت)",
"Galleries" => "سرسراها",
"Create New Gallery" => "ايجاد سرسراي جديد",
"Create a gallery" => "ايجاد يك سرسراي جديد",
"Edit this gallery:" => "اين سرسرا را ويرايش كن",
"There are individual permissions set for this gallery" => "براي اين سرسرا، حقوق دسترسي فردي تعريف شده است",
"Gallery is visible to non-admin users?" => "سرسرا براي كاربران عادي(غير سرپرست) نيز قابل ديدن است؟",
"Geographic" => "جغرافيايي",
"Fields to show during browsing the gallery" => "هنگام مرور سرسرا، اين موارد را نشان بده",
"Creation Date" => "تاريخ ايجاد",
"XY-Size" => "اندازه‌ي طول و عرض(XY) ",
"Gallery Image" => "تصوير سرسرا",
"Available scales" => "مقياس‌هاي موجود",
"Bounding box" => "جعبه‌ي كران‌گزاري",
"default scale" => "ابعاد پيش‌فرض",
"No scales available" => "هيچ مقياسي موجود نيست",
"Original image is default scale" => "تصوير اصلي، مقياس پيش‌فرض است",
"Add scaled images with bounding box of square size" => "تصاوير مدرج را با كادري مربع به اين اندازه اضافه كن",
"Other users can upload images to this gallery" => "ساير كاربران مي‌توانند به اين سرسرا تصوير اضافه كنند",
"You can access the gallery using the following URL" => "شما مي‌توانيد با استفاده از اين URL به اين سرسرا دسترسي پيدا كنيد",
"Available Galleries" => "سرسراهاي(Galleries) موجود",
"Choose a filter" => "يك فيلتر انتخاب كنيد",
"Imgs" => "تصاوير",
"Make Map" => "ساخت نقشه",
"To" => "به",
"Im- Export languages" => "وارد/صادر كردن زبان‌ها",
"Select the language to Import" => "زبان را براي وارد كردن انتخاب كنيد",
"Select the language to Export" => "زبان را براي صادر كردن انتخاب كنيد",
"Import From File" => "پرونده را از اين وارد كن",
"Grab Wiki Tables" => "جداول ويكي را بگير",
"Import pages from a Structured Text Dump" => "صفحات را از يك متن Dumpشده‌ي ساختار يافته وارد كن",
"Name of the dump file (it has to be in dump/)" => "نام پرونده‌ي dump (بايد به اين شكل باشد: dump/)",
"Overwrite existing pages if the name is the same" => "در صورتي كه صفحه‌اي با اين نام وجود دارد، روي آن بنويس",
"Previously remove existing page versions" => "نسخ قبلي اين صفحه",
"excerpt" => "گلچين كردن",
"Result" => "نتيجه",
"body" => "بدنه",
"Errors:" => "خطاها:",
"Locked" => "قفل شده",
"Install" => "نصب",
"Failed" => "رد",
"Configure General Settings" => "تنظيمات عمومي",
"Documentation" => "مستندات",
"Clear cached version and refresh cache" => "نسخه‌ي Cacheشده را خالي كن و Cache را تازه كن ",
"configure rules" => "پيكربندي قوانين",
"Edit Repository" => "مخزن را ويرايش كن",
"Last Changes" => "آخرين تغييرات",
"Search by Date" => "جستجو بر اساس تاريخ",
"LastChanges" => "آخرين تغييرات",
"v" => "نما",
"Rollback" => "عقب‌گرد",
"Pages like" => "صفحات مشابه",
"No pages found" => "صفحه‌اي پيدا نشد.",
"Edit New Article" => "ويرايش مقاله‌ي جديد",
"View Submissions" => "مشاهده‌ي ارائه‌ها",
"ExpireDate" => "تاريخ انقضا",
"AuthorName" => "نام مولف",
"Img" => "تصوير",
"Create banner" => "ساخت درفش",
"Method" => "اسلوب",
"Use Dates?" => "از تاريخ استفاده شود؟",
"Max Impressions" => "بيشينه تعداد نمايش",
"Impressions" => "تعداد نمايش",
"Clicks" => "كليك",
"Create New Blog" => "يك بلاگ جديد ايجاد كن",
"Dynamic content system" => "سامانه‌ي محتوي پويا",
"Available content blocks" => "بلوك‌هاي محتوي موجود",
"Current ver" => "نسخه‌ي جاري",
"Next ver" => "نسخه‌ي بعدي",
"Future vers" => "نسخ آينده",
"Program" => "برنامه",
"Available FAQs" => "FAQهاي موجود",
"Edit/Create" => "ويرايش/ساخت",
"Edit this FAQ:" => "ويرايش اين FAQ",
"Create new FAQ" => "ساخت FAQ جديد",
"Create New FAQ:" => "ساخت FAQ جديد:",
"Users can suggest questions" => "كاربران مي‌توانند سئوال پيشنهاد دهند؟",
"Create a File Gallery" => "ايجاد يك سرسراي پرونده",
"Gallery Images" => "تصاوير سرسرا",
"Edit Blog" => "ويرايش بلاگ",
"Blog Title" => "عنوان بلاگ",
"Edit New Submission" => "ويرايش ارائه‌ي جديد",
"Survey stats" => "آمار نظرسنجي‌ها",
"Take Survey" => "به اجرا گذاشتن",
"users registered" => "كاربر ثبت‌نام كرده است",
"Distance (km)" => "فاصله (به كيلومتر)",
"List Movies" => "فهرست فيلم‌ها",
"Choose a movie" => "يك فيلم انتخاب كن",
"Last mod" => "آخرين تغيير",
"Last author" => "آخرين مؤلف",
"Last version" => "آخرين نسخه",
"unlocked" => "قفل نشده",
"Open client window" => "پنجره‌ي كاربر را بازكن",
"Generate HTML" => "HTML توليد كن",
"Transcripts" => "رونوشت‌ها",
"Online operators" => "پشتيبانان روي خط",
"Operator" => "پشتيبان",
"transcripts" => "روشت‌ها",
"offline" => "خارج خط",
"Offline operators" => "پشتيبانان خارج از خط",
"Add an operator to the system" => "افزودن يك پشتيبان به سامانه",
"Operators must be tiki users" => "پشتيبان بايد كاربر تيكي باشد.",
"Set as Operator" => "به عنوان پشتيبان قرارش بده",
"Chat started" => "گفتگو آغاز شد",
"Operator:" => "پشتيبان",
"Live support:User window" => "پشتيباني زنده: پنجره‌ي كاربر",
"Request live support" => "درخواست پشتيباني زنده",
"Request support" => "درخواست پشتيباني",
"Open a support ticket instead" => "به‌جاي اين يك بليط پشتيباني بازكن",
"Your request is being processed" => "درخواست شما درحال جريان است",
"cancel request and exit" => "درخواست را لغو كن و خارج شو",
"cancel request and leave a message" => "درخواست را لغو كن و يك پيغام بگذار",
"Live support:Console" => "پشتيباني زنده: ميزكار",
"be online" => "وارد مدار شو",
"be offline" => "از مدار خارج شو",
"Support requests" => "درخواست پشتيباني",
"Requested" => "درخواست شده",
"Join" => "بپيوند",
"Support chat transcripts" => "رونوشت گفتگوي پشتيباني",
"operator" => "پشتيبان",
"started" => "تاريخ شروع",
"reason" => "دليل",
"msgs" => "پيغام‌ها",
"Transcript" => "رونوشت",
"Mail-in feature" => "خصيصه‌ي 'كنترل با پست الكترونيكي'",
"Prefs" => "تنظيمات",
"Daily" => "روزانه",
"Weekly" => "هفتگي",
"Remove old events" => "رويدادهاي قديمي را حذف كن",
"duration" => "مدت زمان",
"Mini Calendar: Preferences" => "تقويم جيبي: تنظيمات",
"Calendar Interval in daily view" => "بازه تقويم در نماي روزانه",
"Start hour for days" => "ساعت شروع براي روزها",
"End hour for days" => "ساعت پايان براي روزها",
"Reminders" => "يادآورها",
"no reminders" => "بدون يادآوري",
"Or enter path or URL" => "يا مسير يا URL را وارد كنيد",
"Add Topic" => "افزودن موضوع",
"Tikiwiki Mods" => "حالات تيكي‌ويكي",
"Mods Configuration" => "پيكربندي حالت",
"Update remote index" => "به‌روز رساني راهنماي از راه دور(remote index)",
"Rebuild local list" => "ساخت مجدد فهرست محلي(local)",
"Republish all" => "همه را مجددا منتشر كن",
"Publish all" => "همه را منتشر كن",
"Unpublish all" => "پس‌گرفتن تمام انتشارها",
"Attention" => "توجه",
"all types" => "تمام موارد",
"Display only this type" => "فقط اين نوع را نمايش بده",
"Unpublish" => "پس گرفتن انتشار",
"Republish" => "انتشار مجدد",
"Tikiwiki Mods Configuration" => "پيكربندي حالات تيكي‌ويكي",
"Mods Install/uninstall" => "حذف/نصب حالات",
"Enable Mods providing" => "فراهم كردن حالات، فعال باشد",
"Mods local directory" => "پوشه‌ي محلي حالات",
"Mods remote server" => "سرور راه‌دور حالات",
"Package Config" => "پيكربندي بسته‌بندي",
"y" => "بله",
"User Galleries" => "سرسراهاي كاربر",
"Unread Messages" => "پيغام‌هاي خوانده نشده",
"Tasks" => "وظايف",
"MyTiki" => "تيكي من",
"Notepad" => "دفترچه يادداشت",
"MyFiles" => "پرونده‌هاي من",
"My Watches" => "ديده‌بان‌هاي من",
"Sent editions" => "نسخ ارسال شده",
"The newsletter was sent to {\$sent} email addresses" => "خبرنامه براي پست‌هاي الكترونيكي {\$sent} ارسال شد.",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "از عضويت شما متشكريم. به‌زودي يك پيغام الكترونيكي دريافت خواهيد كرد تا از طريق آن عضويت خود را تاييد كنيد. قبل از تاييد هيچ خبرنامه‌اي براي شما ارسال نخواهد شد.",
"Your email address was removed from the list of subscriptors." => "آدرس پست الكترونيكي شما از فهرست اعضا حذف شد",
"Subscription confirmed!" => "عضصويت تاييد شد",
"Subscribe to Newsletter" => "عضويت در خبرنامه",
"Subscribe to this Newsletter" => "عضويت",
"Available Newsletters" => "خبرنامه‌هاي موجود",
"Notes" => "يادداشت‌ها",
"Write a note" => "يك يادداشت بنويس",
"quota" => "سهميه",
"No notes yet" => "هنوز هيچ پيغامي وجود ندارد.",
"Merge selected notes into" => "يادداشت‌هاي انتخابي را ادغام كن و بريز داخل",
"Reading note:" => "خواندن يادداشت:",
"List notes" => "آخرين يادداشت‌ها",
"Write note" => "نوشتن يادداشت",
"Wiki Create" => "ساخت ويكي",
"Wiki Overwrite" => "نوشتن ويكي(جايگزيني روي قبلي‌ها)",
"Assign permissions to " => "تخصيص حقوق دسترسي به ",
"Assign permissions to this object" => " تخصيص حقوق دسترسي به اين شيئ",
"Published" => "تاريخ انتشار",
"Passcode to register (not your user password)" => "كدعبور براي ثبت‌نام(اين كلمه‌ي عبور شما نيست)",
"Orphan Pages" => "صفحات يتيم",
"Browser not supported" => "مرورگر وب شما پشتيباني نمي‌شود(نمي‌توانيد با اين مرورگر از گپ‌زني‌ها استفاده كنيد)",
"Rename" => "تغيير نام",
"Slides" => "اسلايدها",
"Discuss" => "بحث",
"Attach File" => "ضميمه‌كردن پرونده",
"1 File Attached" => "1 پرونده ضميمه شد",
"s=source" => "s=منبع",
"b=rollback" => "b=برگشت تغييرات",
"Pick your avatar" => "شكلك خود را انتخاب كنيد",
"User Preferences" => "تنظيمات كاربر",
"Your current avatar" => "شكلك كنوني شما",
"no avatar" => "بدون شكلك",
"reset" => "بازنشاني",
"Pick avatar from the library" => "شكلك خود را از بين كتابخانه انتخاب كنيد",
"Pick user Avatar" => "انتخاب شكلك كاربر",
"Hide all" => "همه را پنهان كن",
"icons" => "تمثال‌ها",
"Show all" => "نمايش همه",
"Avatar Image" => "تصوير شكلك",
"random" => "تصادفي",
"Upload your own avatar" => "شكلك خود را بارگذاري كنيد",
"View Details" => "مشاهده‌ي جرئيات",
"Insert" => "درج",
"atts" => "خصوصيات",
"List Attachments" => "آخرين ضمايم",
"Average" => "معدل",
"View Results" => "مشاهده‌ي نتايج",
"Vote poll" => "راي دادن",
"Other Polls" => "ساير راي‌گيري‌ها",
"Note: Remember that this is only a preview, and has not yet been saved!" => "نكته: به‌خاطر داشته‌باشيد كه اين تنها يك پيش‌نمايش است و وظيفه دخيره نشده است",
"on:" => "در:",
"Topic image" => "تصوير سرفصل",
"Viewing blog post" => "مشاهده‌ي الصاقات بلاگ",
"Return to blog" => "بازگشت به بلاگ",
"The original document is available at" => "مستند اصلي در اين‌جا قابل دسترسي است",
"Print multiple pages" => "چاپ چندين صفحه",
"Add Page" => "افزودن صفحه",
"Edit quiz" => "ويرايش آزمون",
"Current Version" => "نسنه‌ي جاري",
"General Options" => "اختيارات عمومي",
"Publication Date" => "تاريخ انتشار",
"at " => "در ",
"Use " => "بهره‌گيري ",
"randomly selected questions." => "سئوالات انتخاب شده به‌صورت تصادفي",
"Test-time Options" => "اختيارات زماني",
"Limit questions displayed per page to " => "سئوالاتي كه در هر صفحه نمايش داده مي‌شوند را محدود كن به",
"&nbsp question(s)." => "سئوال(هاي) &nbsp",
"Impose a time limit of " => "تحميل محدوديت زماني  ",
"Allow students to store partial results and return to quiz." => "به دانش‌آموزيين اجازه بده نتايج را نيمه‌كاره نگه‌داريند و با آزمون برگردند.",
"Allow students to retake this quiz " => "به دانش‌آموزيين اجازه‌ي شركت مجدد در اين آزمون را بده ",
"Grading and Feedback" => "درجه‌بندي و بازخورد",
"Grading method " => "اسلوب درجه‌بندي ",
"Show students their score " => "به دانش‌آموزيين امتيازاتشان را نشان بده ",
"Show students the correct answers " => "به دانش‌آموزيين پاسخ‌هاي صحيح را نشان بده ",
"Publish statistics " => "انتشار آمار ",
"Extra Options" => "اختيارات اضافي ",
"Solicit additional questions from students" => "درخواست سئوالات اضافي از طرف دانش‌آموزيين",
"Link quiz to forum named: " => "آزمون را به اين انجمن پيوند بده: ",
"Prologue:" => "افتتاحيه",
"Epilogue:" => "اختتاميه:",
"Quiz result stats" => "آمار نتايج آزمون",
"Time" => "زمان",
"User answers" => "پاسخ‌هاي كاربران",
"Stats for quizzes" => "وضعيت آزمون‌ها",
"taken" => "گرفته شده؟",
"Av score" => "متوسط امتياز",
"Av time" => "زمان متوسط",
"Clear Stats" => "آمار را پاك كن",
"time taken" => "زمان گرفته شده",
"Passed" => "قبول",
"Stats for this quiz Questions " => "آمار براي اين سئوالات آزمون ",
"Top 10" => "10 تاي برتر",
"Top 20" => "20 تاي برتر ",
"Top 50" => "50 تاي برتر ",
"Top 100" => "100 تاي برتر ",
"Received articles" => "مقالات دريافت شده",
"Edit received article" => "ويرايش مقالات دريافت شده",
"Use Image" => "از تصوير استفاده كن",
"Image x size" => "اندازه‌ي طول تصوير",
"Image y size" => "اندازه‌ي عرض تصوير",
"Image name" => "نام تصوير",
"Accept Article" => "تاييد مقاله",
"Site" => "پايگاه",
"Referer stats" => "آمار مراجعات",
"Last" => "آخرين",
"Your email could not be validated; make sure you email is correct and click register below." => "آدرس پست الكترونيكي شما نمي‌تواند تاييد اعتبار شود؛ اطلاعات صحت آدرس خود اطمينان حاصل كنيد و روي 'ثبت‌نام' در پايين كليك كنيد",
"Register as a new user" => "ثبت‌نام به عنوان كاربر جديد",
"Repeat password" => "تكرار ‌كلمه‌ي عبور",
"A valid email is mandatory to register" => "براي ثبت‌نام، يك پست الكترونيكي معتبر ضروري است",
"Tiki site registered" => "پايگاه تيكي ثبت شد",
"The following site was added and validation by admin may be needed before appearing on the lists" => "اين پايگاه اضافه شده است و تاييد اعتبار به‌وسيله‌ي سرپرست قبل از نمايش در فهرست لازم است",
"You don't have permission to use this feature." => "متاسفانه شما حقوق دسترسي كافي براي استفاده از اين خصيصه را نداريد",
"Please register." => "لطفا ثبت‌نام كنيد.",
"Register this site at tikiwiki.org" => "اين پايگاه رو در tikiwiki.org ثبت كن",
"Read this first!" => "ابتدا اين را بخوانيد!",
"On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "در اين صفحه مي‌توانيد پايگاه خود را به tikiwiki.org بشناسانيد. پايگاه شما در فهرست پايگاه‌هاي شناخته شده‌ي تيكي در tikiwiki.org ثبت خواهد شد.",
"Registering is voluntary." => "ثبت‌نام اختياري است",
"Registering does not give you any benefits except one more link to your site." => "ثبت‌نام سود خاصي عايد شما نمي‌كند، جز اين‌كه يك پيود اضافه به پايگاه شما ايجاد مي‌شود.",
"You don't get any emails, we don't sell the data about your site." => "شما هيچ پست الكترونيكي دريافت نخواهيد كرد، ما اطلاعات پايگاه شما را نخواهيم فروخت!",
"Registering is just for us to get an overview of Tiki's usage." => "ثبت‌نام فقط براي ماست، براي اين‌كه يك چشم‌اندازي از استفاده‌هاي تيكي داشته باشيم",
"If your site is private or inside your intranet, you should not register!" => "اگز پايگاه شما خصوصي است، يا داخل اينترانت قرار گرفته است، نبايد ثبتش كنيد!",
"Information about your site" => " اطلاعاتي درخصوص پايگاه شما",
"Send me my Password" => "براي من كلمه‌ي عبورم را ارسال كن",
"Remove page" => "صفحه را حذف كن",
"Last Version" => "آخرين نسخه",
"You are about to remove the page" => "شما درحال حذف صفحه هستيد",
"permanently" => "كاملا",
"Remove all versions of this page" => "تمام نسخ اين صفحه را حذف كن",
"Rollback page" => "صفحه را به حالت قبل برگردان",
"Searched" => "جستجو شد",
"Search in" => "جستجو در",
"Simple search" => "جستجوي ساده",
"No pages matched the search criteria" => "هيچ صفحه‌اي كه شرايط جستجو را داشته باشد، يافت نشد",
"This newsletter will be sent to {\$subscribers} email addresses." => "اين خبرنامه براي پست‌هاي الكترونيكي {\$subscribers} ارسال خواهد شد.",
"Prepare a newsletter to be sent" => "آماده‌سازي يك خبرنامه براي ارسال",
"Apply content template" => "اين الگوي محتوا را به خبرنامه اعمال كن",
"Send objects" => "ارسال اشياء",
"Transmission results" => "نتايج مخابره‌ها",
"Send Wiki Pages" => "صفحات ويكي را بفرست",
"Send Articles" => "مقالات را بفرست",
"Add Article" => "مقاله را اضافه كن",
"Send objects to this site" => "اشياء را به اين پايگاه بفرست",
"Create a sheet" => "ساخت يك ورق",
"Edit this sheet:" => "ويرايش اين ورق:",
"Create New Sheet" => "ساخت ورق جديد",
"There are individual permissions set for this sheet" => "براي اين ورق حقوق دسترسي فردي تعريف شده است",
"Class Name" => "نام كلاس",
"Header Rows" => "ستون‌هاي سرصفحه",
"Footer Rows" => "ستون‌هاي پاصفحه",
"Create new Sheet" => "ساخت ورق جديد",
"You can access the sheet using the following URL" => "با استفاده از YRL روبرو مي‌توانيد به اين ورق دسترسي پيدا كنيد",
"Available Sheets" => "اوراق موجود",
"Change shoutbox general settings" => "تغيير تنظيمات عمومي فريادگاه",
"auto-link urls" => "URLهاي پيوند خودكار(Autolink)",
"Post or edit a message" => "الصاق يا ويرايش پيغام",
"Location : " => "محل:",
"Parent page" => "صفحه‌ي مادر",
"Child" => "فرزند",
"Most viewed objects" => "پربيننده‌ترين اشياء",
"Most viewed objects in the last 7 days" => "پربيننده‌ترين اشياء در هفته‌ي گذشته",
"Site Stats" => "آمار پايگاه",
"Started" => "تاريخ برپايي",
"Days online" => "برپا (روز)",
"Total pageviews" => "تعداد كل بازديدها",
"Average pageviews per day" => "متوسط بازديد در روز",
"pvs" => "قبلي",
"Best day" => "بهترين روز",
"Worst day" => "بدترين روز",
"Wiki Stats" => "آمار ويكي",
"Size of Wiki Pages" => "حجم صفحات ويكي",
"Average page length" => "متوسط طول صفحه",
"Average versions per page" => "متوسط نسخه در هر صفحه",
"Visits to wiki pages" => "بازديد از صفحات ويكي",
"Average links per page" => "متوسط پيوندها در هر صفحه",
"Image galleries Stats" => "آمار سرسراهاي تصاوير",
"Average images per gallery" => "متوسط تعداد تصوير در هر سرسرا",
"Total size of images" => "مجموع حجم تصاوير",
"Average image size" => "متوسط حجم تصاوير",
"Visits to image galleries" => "بازديد از سرسراهاي تصاوير",
"File galleries Stats" => "آمار سرسراهاي پرونده‌ها",
"Average files per gallery" => "متوسط تعداد پرونده در هر سرسرا",
"Total size of files" => "مجموع حجم پرونده‌ها",
"Average file size" => "متوسط حجم پرونده‌ها",
"Visits to file galleries" => "بازديد از سرسراهاي پرونده‌ها",
"CMS Stats" => "آمار سامانه‌ي مديريت محتوي",
"Total reads" => "مجموع قرائت‌ها",
"Average reads per article" => "متوسط قرائت هر مقاله",
"Total articles size" => "مجموع حجم مقالات",
"Average article size" => "متوسط حجم مقالات",
"Forum Stats" => "آمار انجمن‌ها",
"Total topics" => "مجموع موضوعات",
"Average topics per forums" => "متوسط تعداد موضوع در هر انجمن",
"Visits to forums" => "تعداد بازديد ار انجمن‌ها",
"Blog Stats" => "آمار بلاگ‌ها",
"Weblogs" => "وبلاگ‌ها‌",
"Total posts" => "مجموع الصاق‌ها",
"Average posts per weblog" => "متوسط الصاق در هر بلاگ‌",
"Total size of blog posts" => "حجم مجموع الصاق‌هاي بلاگ",
"Average posts size" => "متوسط حجم الصاق‌ها‌",
"Visits to weblogs" => "بازديد از وبلاگ‌ها",
"Poll Stats" => "آمار راي گيري‌ها",
"Total votes" => "مجموع راي‌ها",
"Average votes per poll" => "متوسط تعداد راي در هر راي‌گيري",
"Total questions" => "مجموع سئوالات",
"Average questions per FAQ" => "متوسط تعداد سئوال در هر بخش",
"User Stats" => "آمار كاربران",
"Average bookmarks per user" => "متوسط تعداد صفحه‌ياب براي هر كاربر",
"Average questions per quiz" => "متوسط تعداد سئوال در هر آزمون",
"Quizzes taken" => "مجموع آزمون‌ها",
"Average quiz score" => "متوسط امتياز آزمون‌ها",
"Average time per quiz" => "متوسط زمان هر آزمون",
"Usage chart" => "نمودار استفاده",
"Usage chart image" => "تصوير نمودار استفاده",
"Daily Usage" => "استفاده روزانه",
"Stats for surveys" => "آمار نظرسنجي‌ها",
"Last taken" => "آخرين اجرا",
"Tiki Logs" => "ثبت وقايع تيكي",
"Time Left" => "زمان باقي مانده",
"Send Answers" => "پاسخ‌ها را ارسال كن",
"Thank you for your submission" => "از ارائه‌ي شما متشكريم",
"Your email was sent" => "پست الكترونيكي شما ارسال شد",
"Theme is selected as follows" => "قيافه‌ها بدين ترتيب انتخاب مي‌شوند",
"If a theme is assigned to the individual object that theme is used." => "اگر قيافه‌اي به يك شيء منفرد تخصيص داده شده باشد، آن قيفه انتخاب مي‌شود.",
"If not then if a theme is assigned to the object's category that theme is used" => "وگرنه درصورتي كه يك قيافه به طبقه‌اي از اشياء تخصيص داده شده باشد، آن قيفه انتخاب مي‌شود.",
"If not then a theme for the section is used" => "وگرنه، درصورتي كه قيافه‌اي به يك بخش تخصيص داده شده باشد، آن قيفه انتخاب مي‌شود. ",
"If none of the above was selected the user theme is used" => "درصورتي كه هيچ‌كدام از موارد فوق نباشد، قيافه‌ي منتخب كاربر انتخاب مي‌شود.",
"Finally if the user didn't select a theme the default theme is used" => "و در پايان، اگر كاربر نيز قيافه‌اي انتخاب نكرده باشد، قيافه‌ي پيش‌فرض انتخاب مي‌شود.",
"Control by Objects" => "كنترل با اشياء",
"Control by Sections" => "كنترل با بخش‌ها",
"Assign themes to categories" => "تخصيص قيافه به طبقات",
"Assigned categories" => "طبقات تحصيص‌يافته",
"Theme Control Center: Objects" => "مركز كنترل قيافه‌ها: اشياء",
"Control by Categories" => "كنترل با طبقات",
"Assign themes to objects" => "تخصيص قيافه به اشياءظ",
"Assigned objects" => "اشياء تخصيص يافته",
"Assign themes to sections" => "تخصيص قيافه‌ها به بخش‌ها",
"Assigned sections" => "بخش‌هاي تحصيص داده شده",
"The following file was successfully uploaded" => "پرونده‌ي مذكور با موفقيت بارگذاري شد",
"You can download this file using" => "بدين‌وسيله مي‌توانيد اين پرونده را بارگذاري كنيد",
"Batch Upload Results" => "نتيجه‌ي بارگذاري دسته‌اي",
"Upload successful!" => "بارگذاري موفقيت آميز بود!",
"The following image was successfully uploaded" => "تصوير مذكر با موفقيت بارگذاري شد",
"Image ID thumb" => "تصويرك شناسه‌ي تصوير",
"You can include the image in an Wiki page using" => "بدين وسيله مي‌توانيد تصويري را دريك صفحه‌ي ويكي بگنجانيد",
"or use filename" => "يا از نام اصلي پرونده استفاده كن",
"Now enter the image URL" => "يك URL تصوير وارد كنيد",
"or upload a local image from your disk" => "يا از دستگاه خود يك تصوير بارگذاري كنيد",
"Batch Upload" => " بارگذاري دسته‌اي(Batch upload)",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "تصويرك (اختياري، جايگزين ساخت خودكار تصويرك مي‌شود)",
"You have to create a gallery first!" => "شما بايد ابتدا يك سرسرا ايجاد كنيد",
"User assigned modules" => "ماژول‌هاي تخصيص يافته‌ي كاربر",
"Restore defaults" => "برگرداندن پيش‌فرض‌ها",
"#" => "رديف",
"act" => "گونه",
"Assign module" => "تخصيص ماژول",
"Column" => "ستنون",
"top" => "گره بالايي",
"Folders" => "پوشه‌ها",
"Folder in" => "پوشه در",
"Remove Folder" => "پوشه را حذف كنت",
"Refresh Cache" => "بازيابي cache",
"Admin folders and bookmarks" => "مديريت پوشه‌ها و صفحه‌ياب‌ها",
"Send me a message" => "يك پيغام براي من بفرست",
"Assign Group" => "قرار دادن كاربر در گروه",
"Change user preferences" => "تغيير تنظيمات كاربر",
"Homepage" => "صفحه‌ي مبدا",
"Users HomePage" => "صفحه‌ي مبدا كاربران",
"Personal Wiki Page" => "صفحه‌ي شخصي ويكي‌",
"Create page" => "صفحه‌ي را بساز",
"Request friendship from this user" => "درخواست رفاقت با اين كاربر",
"Personal Information" => "اطلاعات شخصي",
"Use Google Map locator" => "از نقشه‌ياب گوگل استفاده كن",
"View extra information" => "مشاهده‌ي اطلاعات اضافي",
"Is email public? (uses scrambling to prevent spam)" => "آيا پست الكترونيكي عمومي است؟(باعث دريافت Spam مي‌شود‌",
"Unavailable - please set your e-mail below" => "در دسترس نيست – لطفا آدرس پست الكترونيك خود را در زير ثبت كنيد",
"Does your mail reader need a special charset" => "آيا نرم‌افزار دريافت كننده‌ي پست‌هاي الكترونيكي شما به كاراكتر خاصي نيازمند است؟",
"Notify sender when reading his mail" => "هنگامي كه پست الكترونيكي مولف خوانده مي‌شود، به وي خبر بده",
"Account Information" => "اطلاعات حساب",
"Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "'كلمه‌ي عبور' و 'تاييد كلمه‌ي عبور' را خالي بگذاريد تا كلمه‌ي عبور كنوني باقي بماند",
"Change administrative info" => "تغيير اطلاعات سرپرستي",
"New task" => "وظيفه‌ي جديد",
"Task list" => "فهرست وظايف",
"Admin mode off" => "حالت عادي",
"Admin mode on" => "حالت سرپرستي",
"Task help" => "كمك در وظايف",
"Empty Trash" => "تخليه‌ي خاكرويه",
"Received task" => "وظايف دريافت شده",
"You received this task, please read and execute it" => "شما اين وظيفه را دريافت كرده‌ايد، لطفا آن را مطالعه كرده و اجرا فرماييد",
"Send task" => "ارسال وظيفه",
"You send this task to a other user" => "شما اين وظيفه را به يك كاربر ديگر ارسال مي‌كند",
"Shared task" => "وظايف مشترك",
"This task is public to a special group" => "اين وظيفه براي يك گروه خاص عمومي است",
"Accepted by Task User and Creator" => "پذيرفته شده از طرف كاربر وظيفه و ايجاد كننده",
"Task is accepted by user and creator" => "اين وظيفه از طرف كاربر موظف و ايجاد كننده پذيرفته شده است",
"Not Accepted by One User" => "از طرف يك كاربر پذيرفته شده است",
"Task is rejected by one user" => "وظيفه از طرف يك كاربر رد شده است",
"Waiting for Me" => "منتظر من هستند",
"Task is not accepted by you, read the task and accept or reject it" => "اين وظيفه از طرف شما پذيرفته نشده است، لطفا آن را مطالعه كرده، سپس رد يا قبولش كنيد",
"Waiting for Other User" => "منتظر ساير كاربران",
"Task is not accepted/rejected by other user" => "وظيفه از طرف كاربر قبول يا رد نشده است",
"Admin Mode" => "حالت سرپرستي",
"Edit task" => "ويرايش وظيفه",
"NOT accept" => "قبول نشد",
"Remove from Trash" => "از خاكروبه هم حذفش كن",
"Move into Trash" => "انتقال به خاكروبه",
"Task saved" => "وظيفه ذخيره شد",
"Edit Task" => "ويرايش وظيفه",
"View Task" => "مشاهده‌ي وظيفه",
"Open a new task" => "گشايش يك وظيفه‌ي جديد",
"taskId" => "شناسه‌ي وظيفه",
"Task user" => "كاربر موظف",
"Only the creator can delete this task" => "تنها ايجاد كننده مي‌تواند اين وظيفه را حذف كند",
"Use start date and time" => "از تاريخ و ساعت شروع استفاده كن",
"Use end date and time" => "از تاريخ و ساعت پايان استفاده كن",
"Open / In Process" => "بازكردن / در فرايند",
"Waiting / Not Started" => "درحال انتظار/هنوز آغاز نشده است",
"Percentage completed" => "درصد پيشرفت",
"Shared for Group" => "مشترك براي گروه",
"Accepted by User" => "پذيرفته شده از طرف كاربر",
"No / Rejected" => "خير / رد شده",
"Accepted by Creator" => "پذيرفته شده از طرف ايجاد كننده",
"This message will be send to users if you are makeing changes of assigned tasks" => "درصورتي كه تغييراتي در وظايف اختصاص داده‌شده دهيد، اين پيغام براي كاربران ارسال خواهد شده",
"Send message with changes" => "پيغام را با تغييرات ارسال كن",
"Modified by" => "تغيير كرده به‌وسيله‌ي",
"Inform task user by email" => "كاربر موظف را با پست الكترونيكي آگاه كن",
"You can only view this task" => "شما تنها اين وظيفه را مي‌توانيد ببينيد",
"Completed" => "تكميل شده",
"No tasks entered" => "هيچ وظيفه‌اي وارد نشده است.",
"Select One" => "يكي را انتخاب كنيد",
"Undo Trash" => "بازگشت از خاكروبه",
"Show:" => "نمايش بده:",
"Received" => "دريافت شده‌ها",
"Submitted" => "ارائه شده",
"Shared" => "مشترك",
"All Shared Tasks" => "تمام وظايف مشترك",
"completed (100%)" => "تماما (100%) تكميل شد",
"Monthly" => "ماهانه",
"Add Watch" => "افزودن ديده‌بان",
"A user submits an article" => "يك كاربر، يك مقاله ارائه مي‌دهد",
"May need to refresh twice to see changes" => "ممكن است براي ديدن تغييرات، احتياج به دو بار بازيابي باشد",
"Add top level bookmarks to menu" => "صفحه‌ياب‌هاي برتر را به منو اضافه كن",
"Add or edit an item" => "افزودن يا ويرايش يك قلم",
"New Window" => "پنجره‌ي جديد",
"replace window" => "جايگزيني پنجره",
"Pos" => "رديف",
"User_versions_for" => "نسخ كاربر براي",
"This page is being edited by" => "اين صفحه در حال ويرايش شدن است، توسط:",
"Proceed at your own peril" => "با مسئوليت خودتان ادامه دهيد",
"Insert Row" => "درج سطر",
"Insert Column" => "درج ستون",
"Remove Row" => "حذف سطر",
"Remove Column" => "حذف ستون",
"Merge Cells" => "ادغام ستون",
"Restore Cells" => "بازيابي سلول‌ها",
"Copy Calculation" => "محاسبات را كپي كن",
"Format Cell" => "شكل‌دهي سلول",
"expires:" => "منقضي در:",
"Banner stats" => "آمار درفش‌ها",
"Create new banner" => "ساخت درفش جديد",
"Banner Information" => "اطلاعات درفش",
"Click ratio" => "نرخ كليك كردن",
"Hours" => "ساعت",
"Weekdays" => "روزهاي هفته",
"mon" => "دو شنبه",
"tue" => "سه شنبه",
"wed" => "چهار شنبه",
"thu" => "پنج شنبه",
"fri" => "جمعه",
"sat" => "شنبه",
"sun" => "يك شنبه",
"Banner raw data" => "داده‌ي خام درفش",
"Cached" => "cachشده",
"This is a cached version of the page." => "اين يك نسخه‌ي cache شده از اين صفحه است.",
"Click here to view the Google cache of the page instead." => "اين‌جا را كليك كنيد تا cach گوگل را با جاي آن ببينيد.",
"Answers" => "پاسخ‌ها",
"Add Suggestion" => "افزودن پيشنهاد",
"Forum List" => "فهرست انجمن",
"Edit Forum" => "ويرايش انجمن",
"Summary" => "خلاصه",
"for links" => "براي پيوندها، از",
"HTML tags are not allowed inside posts" => "كدهاي HTML داخل الصاق‌ها مجاز نيستند",
"Moderator Actions" => "اعمال ناظم",
"Move Selected Topics" => "عناوين منتخب را انتقال بده",
"Unlock Selected Topics" => "قفل عنواين منتخب را باز كن",
"Lock Selected Topics" => "عناوين منتخب را قفل كن",
"Delete Selected Topics" => "عناوين منتخب را حذف كن",
"Merge" => "ادغام",
"Merge Selected Topics" => "عناوين منتخب را اذغام كن",
"Reported Messages:" => "پيغام‌هاي گزارش شده:",
"Queued Messages:" => "پيغام‌هاي در صف",
"Merge into topic" => "ادغام در عنوان",
"Emot" => "احساسات",
"pts" => "امتياز",
"Announce" => "اعلام",
"Hot" => "برانگيخته",
"No topics yet" => "هنوز هيچ عنواني وجود ندارد.",
"Jump to forum" => "به اين انجمن بپر",
"All posts" => "تمام الصاق‌ها",
"Last hour" => "ساعت گذشته",
"Last 24 hours" => "24 ساعت گذشته",
"Last 48 hours" => "48 ساعت گذشته",
"prev topic" => "عنوان قبلي",
"next topic" => "عنوان بعدي",
"Show posts" => "الصاق‌ها را نمايش بده",
"Monitor" => "ديده‌باني",
"Insert New Item" => "درج فقره‌ي جديد",
"Edit Fields" => "ويرايش ستون‌ها",
"View inserted item" => "مشاهده‌ي اقلام درج شده",
"Insert new item" => "درج فقره‌ي جديد",
"View Item" => "مشاهده‌ي فقره",
"Filter Tracker Items" => "اقلام tracker را فيلتر كن",
"Add a Comment" => "ايراد نظر",
"Items list" => "فهرست اقلام",
"Special Operations" => "اعمال خاص",
"close" => "ببند",
"Show All" => "نمايش همه",
"Clip" => "كليپ",
"Back To Mailbox" => "بازگشت به صندوق پستي",
"Full Headers" => "سرصفحه‌هاي كامل",
"Normal Headers" => "سرصفحه‌هاي معمولي",
"Reply To All" => "پايه به همه",
"Forward" => "ارجاع",
"Cc" => "رونشت",
"Select from address book" => "از كتابچه‌ي آدرس انتخاب كن",
"CC" => "رونشت",
"BCC" => "رونوشت تاريك",
"Use HTML mail" => "از پست الكترونيكي HTML استفاده كن",
"The following addresses are not in your address book" => "اين آدرس‌ها در كتابچه‌ي آدرس نيستند",
"Add Contacts" => "افزودن گيرنده",
"Attachment 1" => "ضميمه‌ي 1",
"Attachment 2" => "ضميمه‌ي 2",
"Attachment 3" => "ضميمه‌ي 3",
"Address book" => "كتابچه‌ي آدرس",
"3d browser" => "مرورگر 3بعدي",
"as Creator &amp; Last Editor" => "به‌عنوان ايجادكننده و آخرين ويراستار",
"no (disabled)" => "هيچكدام (غيرفعال)",
"Save Minor Edit" => "كوچك",
"Administration" => "سرپرستي",
"Enable/disable Tiki features here, but configure them elsewhere" => "خصيصه‌هاي ويكي را در اين محل فعال/غيرفعال كنيد، اما آن‌ها را جاهاي ديگر پيكربندي نماييد.",
"General preferences and settings" => "تنظيمات  عمومي",
"User registration, login and authentication" => "ثبت‌نام كاربران، ورود و تصديق هويت",
"Wiki settings" => "تنظيمات ويكي",
"Article/CMS settings" => "تنظيمات مقالات/سامانه‌ي مديريت محتوا",
"Poll comments settings" => "تنظيمات 'نظرات' راي‌گيري‌ها",
"Configuration options for all blogs on your site" => "تنظيمات پيكربندي براي تمام بلاگ‌ها در پايگاه شما",
"Forums settings" => "تنظيمات انجمن‌ها",
"FAQ comments settings" => "تنظيمات مربوط به 'نظرات' FAQها",
"Trackers settings" => "تنظيمات Trackerها",
"Directory settings" => "تنظيمات پوشه",
"Maps configuration" => "پيكربندي نقشه‌ها",
"Meta Tags settings" => "تنظيمات فرابرچسب‌ها",
"Search settings" => "تنظيمات جستجو",
"Score settings" => "تنظيمات امتيازدهي‌ها",
"Community settings" => "تنظيمات اجتماعات",
"Calendar settings" => "تنظيمات تقويم",
"Intertiki settings" => "تنظيمات بين تيكي",
"Upload failed" => "بارگذاري شكست خورد",
"All posted" => "همه را الصاق كن (نيازي به تصويب نيست)",
"Queue anonymous posts" => "الصاق‌هاي بي‌نام را در صف قرار بده",
"Queue all posts" => "تمام الصاق‌ها را در صف قرار بده",
"No attachments" => "بدون ضميمه",
"Everybody can attach" => "همه مي‌توانند پرونده ضميمه كنند",
"Only users with attach permission" => "تنها كاربراني كه دسترسي ضميمه كردن دارند مي‌توانند ضميمه كنند",
"Moderators and admin can attach" => "مديران و ناظم‌ها نمي‌توانند ضميمه كنند",
"Date (desc)" => "تاريخ (نزولي)",
"Date (asc)" => "تاريخ (نزولي)",
"Score (desc)" => "امتياز (نزولي)",
"Replies (desc)" => "پاسخ‌ها (نزولي)",
"Reads (desc)" => "خوانده شدن (نزولي)",
"You have to provide a hotword and a URL" => "شما بايد يك URL و يك واژه‌ي آتشين فراهم كنيد",
"Owner" => "مالك",
"Detected, Version:" => "يافت شد، نسخه:",
"Not detected." => "كشف نشد",
"Your admin password has been changed" => "كلمه‌ي عبور سرپرست تغيير كرد",
"All Fields except gdaltindex must be filled" => "تمام ستون‌ها مگر gdaltindex بايد پر شوند",
"No valid gdaltindex executable" => "gdaltindex نامعتبر و غيرقابل اجرا",
"Tag already exists" => "برچسب قبلا ايجاد شده است",
"Tag not found" => "برچسب پيدا نشد",
"Repository name can't be an empty" => "نام مخرن نمي‌تواند خالي باشد",
"Requested action is not supported on repository" => "عمل درخواستي قابل انجام بر روي مخزن نيست",
"No repository" => "هيچ مخزني نيست",
"Search is mandatory field" => "جستجوي يك ستون اجباري است",
"File not found " => "پرونده پيدا نشد ",
"Requested action in not supported on repository" => "عمل درخواستي روي مخزن پشتيباني نمي‌شود",
"Non-existent link" => "پيوند وجود ندارد",
"Mail-in account %s incorrect" => "حساب 'كنترل با پست الكترونيكي' %s ناصحيح است",
"Mail-in account %s saved" => "حساب 'كنترل با پست الكترونيكي' %s ذخيره شد",
"Frequency should be a positive integer!" => "تناوب بايد يك عدد مثبت باشد!",
"Mail-in accounts set to be checked every %s minutes" => "حساب 'كنترل با پست الكترونيكي' براي بررسي در هر %s دقيقه تنظيم شد",
"Automatic Mail-in accounts checking disabled" => "بررسي خودكار حساب 'كنترل با پست الكترونيكي' غيرفعال شد",
"No menu indicated" => "هيچ منواي مشخص نشده است",
"No newsletter indicated" => "هيچ خبرنمامه‌اي مشخص نشده است",
"A user registers" => "ثبت‌نام يك كاربر",
"Any wiki page is changed" => "يكي از صفحات ويكي تغيير كردند",
"Any wiki page is changed, even minor changes" => "هر صفحه‌ي ويكي كه تغيير مي‌كند، حتي اگر تغييرات اندك باشند",
"PHP error" => "خطاهاي PHP",
"No poll indicated" => "هيچ راي‌گيري‌اي مشخص نشده است",
"unsafe" => "ناامن",
"register_globals should be off by default. See the php manual for details." => "register_globals بايد  به‌صورت پيش‌فرض خاموش باشد. براي اطلاعات بيشتر سند راهنماي PHP را مطالعه كنيد",
"safe" => "امن",
"risky" => "خطرناك",
"session.use_trans_sid should be off by default. See the php manual for details." => "session.use_trans_sid بايد به‌صورت پيش‌فرض خاموش باشد. براي اطلاعات بيشتر سند راهنماي PHP را مطالعه كنيد",
"upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir احتمالا در پوشه‌ي تيكي‌ويكي شماست. اين خطر وجود دارد كه فردي پرونده‌اي را در اين پوشه بارگذاري كرده و از طريق وي به آن دسترسي پيدا كند",
"cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "نمي‌توانم بررسي كنم كه آيا upload_tmp_dir از طريق وب قابل دسترس است يا خير. براي اطمينان بايد تنظيمات سرور وب خود را بررسي كنيد.",
"setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "تنظيم xbithack امن نيست! بسته به نحوه‌ي اداره كردن وب‌سرور شما و تنظيمات تيكي، ممكن است مهاجمين بتوانند پرونده‌اي به سرسراي پرونده‌ها بارگزاري كرده و آن را اجرا كنند",
"allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off." => "allow_url_fopen ممكن است به‌صورت بالقوه براي بارگذاري اطلاعات يا دستخط(script) از راه دور مورد استفاده قرار گيرد. اگر از بلاگ‌ها استفاده نمي‌كنيد، مي‌توانيد اين خصيصه را خاموش كنيد.",
"The Path to store files in the filegallery should be outside the tiki root directory" => "آدرس ذخيره‌ي پرونده‌ها در سرسراي پرونده بايد خارج از پوشه‌ي مادر تيكي باشد",
"The Path to store files in the imagegallery should be outside the tiki root directory" => "آدرس ذخيره‌ي پرونده‌ها در سرسراي تصوير بايد خارج از پوشه‌ي مادر تيكي باشد",
"The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code." => "خصيصه‌ي 'ويرايش الگوها' روشن است. به كساني كه اطمينان نداريد، امكان استفاده از اين خصيصه را ندهيد، زيرا به راحتي براي تزريق دستور به PHP مورد استفاده قرار مي‌گيرد.",
"File is not readable. Unable to check." => "پرونده قابل خواندن نيست. نمي‌توانم بررسي كنيم.",
"You have to provide a word" => "شما بايد كلمه‌اي وارد كنيد",
"Permission denied. You cannot view this page." => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد اين صفحه را ببينيد.",
"Permission denied you cannot edit this page" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد اين صفحه را ويرايش كنيد",
"You must specify a page name, it will be created if it doesn't exist." => "بايد نام صفحه را وارد كنيد، اگر وجود نداشته باشد، ساخته خواهد شد",
"page not added (Exists)" => "صفحه اضافه نشد(وجود داشت)",
"No survey indicated" => "هيچ نظرسنجي‌اي مشخص نشده است",
"You don't have permission to use this feature" => "متاسفانه شما حقوق دسترسي كافي براي استفاده از اين خصيه را نداريد",
"No Errors detected" => "هيچ خطايي يافت نشد",
"No tracker indicated" => "هيچ trackerاي مشخص نشده است",
"Group already exists" => "اين گروه قبلا ايجاد شده است.",
"User doesn't exist" => "كاربر وجود ندارد",
"No records were found. Check the file please!" => "هيچ ركوردي يافت نشد. لطفا پرونده را كنترل كنيد!",
"User login is required" => "احتياج به نام ورود براي كاربر است",
"Password is required" => "احتياج به كلمه‌ي عبور است",
"Email is required" => "اجتياج به پست الكترونيكي است",
"User is duplicated" => "كاربر تكراري است",
"Created account %s <%s>" => "حساب %s <%s> ايجاد شد",
"Assigned %s in group %s" => "%s به گروه %s منتصب شد",
"User %s already exists" => "كابر %s از قبل وجود داشت",
"New %s created with %s %s." => "%s جديد با %s %s ايجاد شد",
"Impossible to create new %s with %s %s." => "ساخت %s جديد با %s %s غير ممكن است.",
"%s %s successfully deleted." => "%s %s يا موفقيت ايجاد شد",
"%s %s removed from %s %s." => "%s %s با موفقيت از %s %s حذف شد",
"%s changed from %s to %s" => "%s از %s به %s تغيير يافت",
"Impossible to change %s from %s to %s" => "تغيير %s از %s به %s غيرممكن است",
"%s modified successfully." => "%s با موفقيت تغيير يافت.",
"password" => "كلمه‌ي عبور‌",
"%s modification failed." => "تغيير %s موفقيت‌آميز نبود",
"rss feed disabled" => "تغذيه‌ي RSS غيرفعال شد",
"Tiki RSS feed for articles" => "تغذيه‌ي RSSهاي تيكي براي مقالات",
"Last articles." => "آخرين مقالات",
"Unknown group" => "گروه نامشخص",
"Group doesn't exist" => "گروه وجود ندارد",
"You have to indicate a group" => "بايد يك گروه مشخص كنيد",
"This group is invalid" => "اين گروه معتبر نيست",
"Permission denied you cannot view backlinks for this page" => "متاسفانه شما حقوق دسترسي كافي براي مشاهده‌ي backlinkهاي اين صفحه را نداريد",
"The page cannot be found" => "صفحه يافت نشد",
"Invalid directory name" => "نام پوشه معتبر نيست",
"It isn't possible to post in any blog. You may need to create a blog first." => "شما به هيچ بلاگي نمي‌توانيد الصاق كنيد، شايد ابتدا بايستي بلاگ‌اي ايجاد نماييد.",
"Permission denied you cannot post" => "متاسفانه شما حقوق دسترسي لازم براي الصاق را نداريد",
"Permission denied you cannot edit this post" => "متاسفانه شما حقوق دسترسي لازم براي تغيير اين الصاق را نداريد.",
"Top visited blogs" => "پربيننده‌ترين بلاگ‌ها",
"Last posts" => "آخرين الصاق‌ها",
"Top active blogs" => "فعال‌ترين بلاگ‌ها",
"Tiki RSS feed for blog: " => "تغذيه‌ي RSS تيكي براي بلاگ: ",
"No blogId specified" => "هيچ بلاگي مشخص نشده است.",
"Tiki RSS feed for weblogs" => "تغذيه‌ي RSS تيكي براي وبلاگ‌ها",
"Last posts to weblogs." => "آخرين الصاق‌ها به وبلاگ‌ها",
"TOP" => "فوقاني",
"Permission denied you cannot access this gallery" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد به اين سرسرا دسترسي داشته باشيد.",
"No gallery indicated" => "هيچ سرسرايي مشخص نشده است.",
"Permission denied you can not view this section" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد اين بخش را ببينيد.",
"Permission denied you cannot remove images from this gallery" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد تصاوير را از اين سرسرا حذف كنيد.",
"Permission denied you cannot rebuild thumbnails in this gallery" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد تصويرك‌هاي اين سرسرا را از نو بسازيد.",
"Permission denied you cannot rotate images in this gallery" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد تصاوير اين سرسرا را بچرخانيد.",
"No image indicated" => "هيچ تصويري مشخص نشده است.",
"Permission denied you cannot move images from this gallery" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد تصاوير اين سرسرا را منتقل كنيد.",
"Permission denied you cannot view the calendar" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد اين تقويم را مشاهده كنيد.",
"event without name" => "رويداد بدون نام",
"Access Denied" => "دسترسي ممنوع است",
"You can not use the same password again" => "نمي‌توانيد از همان كلمه‌ي عبور مجددا استفاده كنيد",
"Top authors" => "برترين مؤلفين",
"Message sent to" => "پيغام ارسال شد به",
"You need to change chmod 'whelp' manually to 777" => "بابد دسترسي 'whelp' را به‌صورت دستب به 777 تغيير دهيد.",
"This feature has been disabled" => "اين خصيصه غيرفعال شده است",
"Tiki RSS feed for directory sites" => "تغذيه‌ي RSS براي پايگاه‌هاي پوشه",
"Last sites." => "آخرين پايگاه‌ها",
"Must enter a name to add a site. " => "براي افزودن پايگاه بايد يك نام وارد كنيد. ",
"Must enter a url to add a site. " => "براي وارد كردن يك پايگاه بايد يك URL وارد كنيد. ",
"URL already added to the directory. Duplicate site? " => "URL قبلا به پوشه اصافه شده بود، تكراري اضافه كنم؟",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "URL قابل دسترس نسيت. URL اشتباه است يا پايگاه روي‌خط نيست و نمي‌تواند به پوشه اصافه شود. ",
"Must select a category. " => "بايد يك طبقه انتخاب كنيد. ",
"Must enter a name to add a site" => "براي افزودن يك پايگاه بايد يك نام وارد كنيد",
"Must enter a url to add a site" => "براي افزودن يك پايگاه بايد يك URL وارد كنيد",
"URL already added to the directory. Duplicate site?" => "URL قبلا به پوشه اصافه شده بود، تكراري اضافه كنم؟",
"URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "URL قابل دسترس نسيت. URL اشتباه است يا پايگاه روي‌خط نيست و نمي‌تواند به پوشه اصافه شود. ",
"Must select a category" => "بايد يك طبقه انتخاب كنيد. ",
"No site indicated" => "هيچ پايگاهي مشخص نشده است.",
"No parent specified" => "هيچ والدي مشخص نشده است.",
"Article not found" => "مقاله پيدا نشد.",
"Permission denied you cannot edit this article" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد اين مقاله را ويرايش كنيد",
"The language can't be changed as its set of translations has already this language" => "زبان نمي‌تواند تغيير كند، چراكه مجموعه‌ي ترجمه‌ها اين زبان را دارد",
"You do not have permissions to edit banners" => "شما حق دسترسي براي ويرايش درفش‌ها(banners) را نداريد",
"Banner not found" => "درفش(banner) پيدا نشد",
"You do not have permission to edit this banner" => "شما حق دسترسي براي ويرايش اين درفش(banner) را نداريد",
"Permission denied you cannot create or edit blogs" => "دسترسي غير ممكن است، شما نمي‌توانيد بلاگ بسازيد يا تغيير دهيد",
"Permission denied you cannot edit this blog" => "دسترسي غيرممكن است، شما نمي‌توانيد اين بلاگ را تغيير دهيد",
"You do not have permission to write the style sheet" => "متاسفانه شما حقوق دسترسي كافي براي نوشتن سبك نگارش(Style sheet) نداريد",
"Invalid request to edit an image" => "درخواست نامعتبر براي ويرايش يك تصوير",
"Permission denied you cannot edit images" => "دسترسي غيرممكن است، شما نمي‌توانيد تصاوير را تغيير دهيد",
"Permission denied you can edit images but not in this gallery" => "دسترسي ممنوع است: شما مي‌توانيد تصاوير را ويرايش كنيد، اما نه در اين سرسرا",
"Failed to edit the image" => "ويرايش تصوير ناموفق بود",
"Permission denied to use this feature" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد از اين خصيصه استفاده كنيد",
"Shortname must be 2 Characters" => "نام اختصار بايد 2 حرف باشد",
"You must provide a longname" => "بايد نام مشروح را وارد كنيد",
"Language created" => "زبان ايجاد شد",
"No content id indicated" => "هيچ شناسه‌ي محتوايي مشخص نشده است.",
"No question indicated" => "هيچ سئوالي مشخص نشده است.",
"No quiz indicated" => "هيچ آزموني مشخص نشده است.",
"No structure indicated" => "هيچ ساختاري مشخص نشده است.",
"Invalid structure_id or page_ref_id" => "شناسه‌ي ساختار يا شناسه‌ي ارجاع به صفحه معتبر نيست",
"Permission denied you cannot send submissions" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد ارائه كنيد",
"Permission denied you cannot edit submissions" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد ارائه‌ها را ويرايش كنيد",
"You have to create a topic first" => "بايد ابتدا يك موضوع ايجاد كنيد",
"You do not have permission to do that" => "متاسفانه براي اين‌كار حقوق دسترسي كافي نداريد",
"You do not have permission to read the template" => "متاسفانه شما حقوق دسترسي كافي براي خواندن الگو نداريد",
"No topic id specified" => "هيچ شناسه‌ي موضوعي مشخص نشده است.",
"Invalid topic id specified" => "شناسه‌ي موضوع مشخص شده معتبر نيست",
"No object indicated" => "هيچ شيئي مشخص نشده است.",
"No type indicated" => "هيچ نوعي مشخص نشده است.",
"page imported" => "صفحه وارد شد",
"created from import" => "ساخته شده از طريق واردات",
"Can't import remote HTML page" => "نمي‌توانم صفحه‌ي راه‌دور HTML را وارد كنم",
"The SandBox is disabled" => "دست‌گرمي غيرفعال است",
"Cannot edit page because it is locked" => "نمي‌توان اين صفحه را ويرايش كرد. صفحه قفل است",
"No questions group indicated" => "هيج گروه سئوالي مشخص نشده است.",
"Permission denied you cannot edit this file" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد اين پرونده را ويرايش كنيد",
"Permission denied you cannot remove files from this gallery" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد پرونده‌اي از اين سرسرا حذف كنيد",
"Top visited file galleries" => "پربيننده‌ترين سرسراهاي پرونده",
"Most downloaded files" => "پرونده‌هايي كه از همه بيشتري دريافت شده‌اند",
"Last files" => "آخرين پرونده‌ها",
"Tiki RSS feed for file galleries" => "تغذيه‌ي RSS تيكي براي سرسراهاي پرونده",
"Last files uploaded to the file galleries." => "آخرين پرونده‌هاي بارگذاري شده در سرسراهاي پرونده",
"No galleryId specified" => "هيچ شناسه‌ي سرسرايي مشخص نشده است.",
"Tiki RSS feed for the file gallery: " => "تغذيه‌ي RSS تيكي براي سرسراي پرونده‌ي: ",
"No forum indicated" => "هيچ انجمني مشخص نشده است.",
"Last forum topics" => "آخرين موضوعات انجمن",
"Top topics" => "برترين عناوين",
"Forum posts" => "الصاق‌هاي انجمن",
"No forumId specified" => "هيچ شناسه‌ي انجمني مشخص نشده است",
"Tiki RSS feed for forum: " => "تغذيه‌ي RSS براي انجمن: ",
"Tiki RSS feed for forums" => "تغذيه‌ي RSS براي انجمن‌ها",
"Last topics in forums." => "آخرين موضوعات در انجمن‌ها",
"Accepted friendship request from %s" => "درخواست رفاقت از طرف %s مورد قبول واقع شد",
"Refused friendship request from %s" => "درخواست رفاقت %s رد شد!",
"Broke friendship with %s" => "رابطه(رفاقت) را %s قطع شد",
"I have broken our friendship!" => "من رابطه‌مان(رابطه‌ي رفاقت) را قطع كردم!",
"You must be logged in to use this feature" => "براي استفاده از اين خصيصه بايد وارد سامانه شويد",
"Friendship request sent to %s" => "درخواست رفاقت به %s ارسال شد.",
"You're already friend of %s" => "شما هم‌اينك هم رفيق %s هستيد",
"I have accepted your friendship request!" => "من درخواست رفاقت شما را پذيرفته‌ام!",
"first uploaded image" => "اولين تصوير بارگذاري شده",
"last uploaded image" => "آخرين تصوير بارگذاري شده",
"first image" => "اولين تصوير",
"last image" => "آخرين تصاوير",
"random image" => "يك تصوير تصادفي",
"Permission denied you cannot create galleries and so you cant edit them" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد سرسرا ايجاد كنيد، درنتيجه نمي‌توانيد آن‌ها را ويرايش كنيد",
"Permission denied you cannot edit this gallery" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد اين سرسرا را ويرايش كنيد",
"Permission denied you cannot remove this gallery" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد اين سرسرا را حذف كنيد",
"Permission denied you cannot make the map of this gallery" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد نقشه‌ي اين سرسرا را تهيه كنيد",
"Top images" => "تصاوير برتر",
"Last images" => "آخرين تصاوير",
"Tiki RSS feed for image galleries" => "تغذيه‌ي RSS تيكي براي سرسراهاي تصاوير",
"Last images uploaded to the image galleries." => "آخرين تصاوير بارگذاري شده به سرسراهاي تصاوير",
"Tiki RSS feed for the image gallery: " => "تغذيه‌ي RSS تيكي براي سرسراي تصوير: ",
"overwriting old page" => "صفحات قديمي را بازنويسي كن",
"updated from structured text import" => "به‌روز رساني شده توسط واردات متن ساختار يافته",
"page created" => "صفحه ساخته شد",
"created from structured text import" => "به‌روز رساني شده توسط واردات ساختار يافته",
"No name indicated for wiki page" => "هيچ نامي براي صفحه‌ي ويكي مشخص نشده است.",
"No repository given" => "هيچ مخزني داده نشده است.",
"Permission denied. You cannot view pages like this page" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد صفحاتي مانند اين صفحه را مشاهده كنيد",
"Permission denied you cannot remove articles" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد مقالات را حذف كنيد",
"Permission denied you cannot remove banners" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد درفش‌ها را حذف كنيد",
"Permission denied you cannot remove this blog" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد اين بلاگ را حذف كنيد",
"Non-existent gallery" => "چنين سرسرايي وجود ندارد",
"Permission denied you can upload files but not to this file gallery" => "دسترسي ممنوع است: شما مي‌توانيد پرونده بارگذاري كنيد، اما نه به اين سرسرا",
"Could not upload the file" => "نمي‌توانم پرونده را بارگذاري كنم",
"Could not find the file requested" => "نمي‌توانم پرونده‌ي درخواستي را پيدا كنم",
"Permission denied you can't upload files so you can't edit them" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد پرونده‌اي بارگذاري كنيد، لذا نمي‌تواندي پرونده‌ها را ويرايش كنيد",
"You cannot admin blogs" => "شما نمي‌توانيم بلاگ‌ها را مديريت كنيد",
"Permission denied you cannot remove submissions" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد ارائه‌ها را حذف كنيد",
"Permission denied you cannot approve submissions" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد ارائه‌ها را تاييد كنيد",
"You have to enable cookies to be able to login to this site" => "براي ورود به اين پايگاه، بايد كوكي‌ها را در مرورگر خود براي اين پايگاه فعال كنيد",
"Tiki mail-in auto-reply" => "پاسخ خودكار 'كنترل با پست الكترونيكي'",
"Sorry, you can't use this feature." => "متاسفم، شما نمي‌توانيد از اين خصيصه استفاده كنيد",
"You do not have permissions to view the maps" => "متاسفانه شما حقوق دسترسي كافي براي مشاهده‌ي نقشه‌ها را نداريد",
"Maps feature is not correctly setup : Maps path is missing." => "خصيصه‌ي نقشه به درستي برپا نشده است: مسير نقشه‌ها مفقود است.",
"mapfile name incorrect" => "نام پرونده‌ي نقشه ناصحيح است.",
"This mapfile already exists" => "پرونده‌ي نقشه قبل تكراري است.",
"You do not have permission to write to the mapfile" => "متاسفانه شما حقوق دسترسي كافي براي نوشتن در اين پرونده‌ي نقشه را ندارد",
"You do not have permission to delete the mapfile" => "متاسفانه شما حقوق دسترسي لازم براي حذف اين پرونده‌ي نقشه را نداريد",
"I could not make a copy" => "نمي‌توانم يك رونوشت(كپي) تهيه كنم",
"You do not have permission to read the mapfile" => "متاسفانه شما حقوق دسترسي كافي براي خواندن اين پرونده‌ي نقشه را نداريد",
"You dont have permission to do that" => "متاسفانه شما حقوق دسترسي كافي بري انجام اين كار را نداريد",
"Tiki RSS feed for maps" => "تغذيه‌ي RSSهاي تيكي براي نقشه‌ها",
"List of maps available." => "فهرست نقشه‌هاي موجود.",
"You do not have permissions to view the layers" => "متاسفانه شما حقوق دسترسي كافي براي مشاهده‌ي لايه‌ها را نداريد",
"You do not have permissions to delete a file" => "متاسفانه شما حقوق دسترسي كافي براي حذف يك پرونده را نداريد",
"File not found" => "پرونده پيدا نشد",
"You do not have permissions to create a directory" => "متاسفانه شما حقوق دسترسي كافي براي ساخت يك پوشه را نداريد",
"The Directory is not empty" => "پوشه خالي نيست",
"You do not have permissions to delete a directory" => "متاسفانه شما حقوق دسترسي كافي براي حذف يك پوشه را نداريد",
"You do not have permissions to create an index file" => "متاسفانه شما حقوق دسترسي كافي براي ساخت يك پرونده‌ي Index را نداريد",
"Invalid file name" => "نام پرونده معتبر نيست",
"Invalid files to index" => "پرونده‌ي غيرمعتبر براي ايندكس‌گذاري",
"I do not know where is gdaltindex. Set correctly the Map feature" => "من نمي‌دانم gdaltindex كجاست. لطفا خصيصه‌ي نقشه را صحيح تنظيم كنيد",
"I could not create the index file" => "نمي‌توانم پرونده‌ي Index را ايجاد كنم",
"Must be logged to use this feature" => "براي استفاده از اين خصيصه، بايد وارد سامانه شويد",
"Welcome at Hawiki" => "به 'هاويكي' خوش‌آمديد",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "استفاده از اين پايگاه تيكي‌ويكي براي دسترسي از طريق بسياري از ابزارهاي سيار مانند تلفن‌هاي WAP، PDAها، ابزارهاي i-mode و غيره آماده شده است.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "شما مي‌توانيد با هدايت مرورگر ابزار خود به آدرس مقابل، اين پايگاه را در ابزار سيار خود مرور كنيد:",
"About" => "درباره",
"You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "شما نياز به اجراي setup.sh :<br /> داريد.  كاربران متعارف apache عبارتند از: www-data, apache يا nobody",
"Your PHP installation does not have zlib enabled." => "نصب PHP شما، zlibاش فعال نيست.",
"You must log in to use this feature" => "براي استفاده از اين خصيصيه شما بايد وارد سامانه شويد",
"You do not have permission to view other users data" => "متاسفانه شما حقوق دسترسي كافي براي مشاهده‌ي اطلاعات ساير كاربران را نداريد",
"You must be logged in to subscribe to newsletters" => "براي عضويت در خبرنامه‌ها بايد وارد سامانه شويد",
"No note indicated" => "هيچ يادداشتي مشخص نشده است",
"merged note:" => "ادغام يادداشت: ",
"File is too big" => "پرونده خيلي بزرگ است",
"No item indicated" => ".هيچ موردي انتخاب نشده است",
"created from notepad" => "ايجاد شده از notepad",
"Page already exists" => "صفحه قبلا ايجاد شده بود",
"Not enough information to display this page" => "اطلاعات كافي براي نمايش در اين صفحه وجود ندارد",
"Permission denied you cannot browse this page history" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد تاريخچه‌ي اين صفحه را مرور كنيد",
"No article indicated" => "هيچ مقاله‌اي مشخص نشده است",
"Article is not published yet" => "مقاله هنوز منتشر نشده است",
"No post indicated" => "هيچ الصاقي مشخص نشده است",
"Blog not found" => "بلاگ يافت نشد",
"No pages indicated" => "هيچ صفحه‌اي مشخص نشده است.",
"Pageviews" => "مشاهدات صفحه",
"You don't have permission to edit quizzes." => "متاسفانه شما حقوق دسترسي كافي براي ويرايش اين آزمون را نداريد.",
"No result indicated" => "هيچ نتيجه‌اي مشخص نشده است.",
"The passwords don't match" => "كلمه‌ي عبور همخواني ندارد",
"Invalid or unknown username" => "نام كاربري نامعتبر يا ناشناخته است",
"Unable to send mail. User has not configured email" => "امكان ارسال پست الكترونيكي وجود ندارد. كاربر پست الكترونيكي خود را پيكربندي نكرده است",
"to the registered email address for" => "به آدرسي‌هاي پست الكترونيكي ثبت شده براي",
"last version" => "آخرين نسخه",
"Permission denied you cannot remove versions from this page" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد نسخ اين صفحه را حذف كنيد",
"Permission denied you cannot rename this page" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد نام اين صفحه را تغيير دهيد",
"Cannot rename page because the new name begins with reserved prefix" => "از آن‌جايي كه اين نام صفحه با پيشوند اندوخته شده(reserved) آغاز مي‌‍شود، نمي‌توان نام آن را تغيير داد",
"Cannot rename page maybe new page already exists" => "نمي‌توانم صفحه را تغيير نام بدهم، احتمالا صفحه‌اي با اين نام وجود دارد.",
"Non-existent version" => "نسخه وجود ندارد",
"Permission denied you cannot rollback this page" => "دسترسي ممنوع است: متاسفانه شما حق برگرداندن اين صفحه با حالت قبل را نداريد",
"Error Message" => "پيغام‌ها خطا",
"No newsletters available." => "هيچ خبرنامه‌اي موجود نيست.",
"successfully sent" => "با موفقيت ارسال شد",
"not sent" => "ارسال نشد",
"Error: " => "خطا: ",
"Page must be defined inside a structure to use this feature" => "صفحه بايد درون يك ساختار تعريف شده باشد تا بتوان از اين خصيصه استفاده كرد",
"You cannot take this quiz twice" => "نمي‌توانيد در اين آزمون دوبار شركت كنيد",
"Quiz time limit exceeded quiz cannot be computed" => "زمان آزمون به سر آمده است. آزمون به حساب نخواهد آمد",
"You cannot take this survey twice" => "شما نمي‌توانيد دوبار در اين نظرخواهي شركت كنيد",
"Please create a category first" => "لطفا ابتدا يك طبقه ايجاد كنيد",
"empty" => "تخليه شود",
"No permission to upload zipped file packages" => "حقوق دسترسي براي بارگذاري بسته‌هاي تصاوير فشرده شده(zipped) وجود ندارد",
"Error processing zipped image package" => "خطا در پردازش بسته‌ي تصاوير فشرده شده",
"No permission to upload zipped image packages" => "حقوق دسترسي براي بارگذاري بسته‌هاي تصاوير فشرده شده(zipped) وجود ندارد",
"The uploaded file ist not recognized as a image" => "The uploaded file is not recognized as an image",
"Permission denied you cannot upload images" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد تصويري بارگذاري كنيد.",
"Permission denied you can upload images but not to this gallery" => "دسترسي ممنوع است: شما مي‌توانيد تصوير بارگذاري كنيد، اما نه در اين سرسرا",
"Cannot get image from URL" => "نمي‌توانم از اين URL تصوير را بگيرم",
"That is not an image (or you have php < 4.0.5)" => "اين يك تصوير نيست (يا نسخه‌ي PHP شما قديمي‌تر از 4.0.5 است)",
"Usage" => "استفاده",
"No url indicated" => "No URL indicated",
"Unknown user" => "كاربر نامشخص",
"You are not logged in and no user indicated" => "شما وارد سامانه نشده اين و هيچ كاربري مشخص نشده است.",
"The user has chosen to make his information private" => "كاربر اين اطلاعات را جزو اطلاعات شخصي خود قرار داده است",
"Email is set to %s" => "پست الكترونيكي تنظيم شده است به %s",
"The passwords did not match" => "كلمه‌ي عبور هم‌خواني ندارد",
"no" => "خير",
"was moved into trash" => "به خاكروبه منتقل شد",
"trashed by" => "منتقل شده به خاكروبه به‌وسيله‌ي",
"open / in process" => "بازكردن / در فرايند",
"Rights by creator" => "حقوق به‌وسيله‌ي ايجاد كننده",
"END" => "پايان",
"Percentage" => "درصد",
"Task accepted by creator" => "وظيفه به‌وسيله‌ي ايجاد كننده پذيرفته شد",
"Task accepted by task user" => "وظيفه از طرف كاربر موظف پذيرفته شد",
"Task NOT accepted by creator" => "وظيفه به‌وسيله‌ي ايجاد كننده پذيرفته نشد",
"Task NOT accepted by task user" => "وظيفه از طرف كاربر موظف پذيرفته نشد",
"Sorry this task does not exist or you have no rights to view this task" => "متاسفانه چنين وظيفه‌اي وجود ندارد، يا شما حقوق دسترسي كافي براي ديدن آن را نداريد",
"Task entries:" => "اقلام وظايف:",
"Changes:" => "تغييرات:",
"Info message" => "پيغام اطلاعات",
"NEW Task" => "وظيفه‌ي جديد",
"Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "متاسفم، شما اجازه‌ي ارسال وظيفه به ساير كاربران را نداريد، يا كاربر انتخابي اجازه‌ي دريافت وظيفه را ندارد!",
"Changes on Task" => "تغييرات در وظايف",
"You received a new task" => "شما يك وظيفه‌ي جديد دريافت كرده‌ايد",
"The priority is" => "اولوست",
"high" => "بالا",
"very high" => "خيلي بالا",
"You've to start your work at least on" => "شما بايد حداقل تا اين موقع كار خود را آغاز كنيد",
"You've to finish your work on" => "شما بايد كارتان را تا اين موقع تمام كنيد",
"Login and click the link below" => "وارد سامانه شده و روي پيوند زير كليك كنيد",
"Please read the task and work on it!" => "لطفا وظيفه را بخوانيد و رويش كار كنيد!",
"Sorry, there was an error while trying to write data into the database" => "متاسفم، هنگام نوشتن در پايگاه داده با اشكال مواجه شدم.",
"Cannot upload this file not enough quota" => "نمي‌توانم اين پرونده را بارگذاري كنم. محدوديت حجم شما پر خواهد شد",
"No user indicated" => "هيچ كاربري مشخص نشده است.",
"Non-existent user" => "كاربر وجود ندارد",
"No banner indicated" => "هيچ درفشي مشخص نشده است.",
"No blog indicated" => "هيچ بلاگي مشخص نشده است.",
"Permission denied you cannot remove the post" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد اين الصاق را حذف كنيد",
"No cache information available" => "اطلاعات cache در دسترس نيست",
"No faq indicated" => "هيچ FAQاي مشخص نشده است.",
"You are not permitted to remove someone else\\'s post!" => "شما حق حذف الصاقات شخص ديگر را نداريد!",
"No thread indicated" => "هيچ رگه‌اي مشخص نشده است",
"A SheetId is required." => "يك شناسه‌ي ورق لازم است.",
"That tracker don't use extras." => "That tracker doesn't use extras.",
"Aborted" => "منقطع شده",
"Top pages" => "برترين صفحات",
"Last pages" => "آخرين صفحات",
"Tiki RSS feed for the wiki pages" => "تغذيه‌ي RSS تيكي براي صفحات ويكي",
"Last modifications to the Wiki." => "آخرين تغييرات ويكي",
"###end###"=>"###end###");
