##
# $Id: enum_wayback.rb 10394 2010-09-20 08:06:27Z jduck $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##


require 'msf/core'
require 'net/http'

class Metasploit3 < Msf::Auxiliary
	include Msf::Auxiliary::Report
	def initialize(info = {})
		super(update_info(info,
			'Name' => 'Pull Archive.org stored URLs for a domain',
			'Description' => %q{
					This module pulls and parses the URLs stored by Archive.org for the purpose of
				replaying during a web assessment. Finding unlinked and old pages.
			},
			'Author' => [ 'Rob Fuller <mubix [at] hak5.org>' ],
			'License' => MSF_LICENSE,
			'Version' => '$Revision: 10394 $'
		))
		register_options(
			[
				OptString.new('DOMAIN', [ true, "Domain to request URLS for"]),
				OptString.new('OUTFILE', [ false, "Where to output the list for use"])
			], self.class)

		register_advanced_options(
			[
				OptString.new('PROXY', [ false, "Proxy server to route connection. <host>:<port>",nil]),
				OptString.new('PROXY_USER', [ false, "Proxy Server User",nil]),
				OptString.new('PROXY_PASS', [ false, "Proxy Server Password",nil])
			], self.class)

	end

	def pull_urls(targetdom)
		response = ""
		pages = []
		header = { 'User-Agent' => "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US) AppleWebKit/525.13 (KHTML, like Gecko) Chrome/4.0.221.6 Safari/525.13"}
		clnt = Net::HTTP::Proxy(@proxysrv,@proxyport,@proxyuser,@proxypass).new("web.archive.org")
		resp, data = clnt.get2("/web/*sr_1nr_1300/http://"+targetdom+"/*",header)
		response << data
		response.each_line do |line|
			pages << line.gsub!(/(.+>)(.+)(<\/a><br>)\n/, '\2')
		end

		pages.delete_if{|x| x==nil}
		pages.uniq!
		pages.sort!

		for i in (0..(pages.count-1))
			fix = "http://" + pages[i].to_s
			pages[i] = fix
		end
		return pages
	end

	def write_output(data)
		print_status("Writing URLs list to #{datastore['OUTFILE']}...")
		file_name = datastore['OUTFILE']
		if FileTest::exist?(file_name)
			print_status("OUTFILE already existed, appending..")
		else
			print_status("OUTFILE did not exist, creating..")
		end

		File.open(file_name, 'ab') do |fd|
			fd.write(data)
		end


	end

	def run
		if datastore['PROXY']
			@proxysrv,@proxyport = datastore['PROXY'].split(":")
			@proxyuser = datastore['PROXY_USER']
			@proxypass = datastore['PROXY_PASS']
		else
			@proxysrv,@proxyport = nil, nil
		end

		target = datastore['DOMAIN']

		urls = []
		print_status("Pulling urls from Archive.org")
		urls = pull_urls(target)

		print_status("Located #{urls.count} addresses for #{target}")

		if datastore['OUTFILE']
			write_output(urls.join("\n") + "\n")
		else
			urls.each do |i|
				puts(i)
			end
		end
	end
end
