# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean)

#FIXME: add dependency on storm/twisted-wrapper

setup(name='elisa-plugin-database',
    version='0.19', 
    description="Database management",
    long_description="""Scan your local media and index it in the database.""",
    license='GPLv3', 
    author='Moovida Developers',
    author_email='elisa@lists.fluendo.com',
    keywords='',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    entry_points="""
    [elisa.plugins.search.searchers]
    DBSearcher = elisa.plugins.database.searcher:DBSearcher

    [elisa.core.components.resource_provider]
    MediaScanner = elisa.plugins.database.media_scanner:MediaScanner

    [elisa.core.components.service_provider]
    DatabaseDBusServiceProvider = elisa.plugins.database.dbus_service:DatabaseDBusServiceProvider
    """,
    package_data={'': ['*.png', '*.conf', 'pieces/*.png'],
                  'elisa.plugins.database.i18n': ['*.po', '*/LC_MESSAGES/*.mo', '*.pot'],
                 },
    controller_mappings=[
                         # FIXME: we should create a controller path convention
                         # and adapt the paths here
                         ('/poblesec/database/music/artists',
                          'elisa.plugins.database.music_controller:ArtistsDbListSwitcherController'),
                         ('/poblesec/database/music/albums',
                          'elisa.plugins.database.music_controller:AlbumsDbListSwitcherController'),
                         ('/poblesec/database/music/albums_of_artist',
                          'elisa.plugins.database.music_controller:AlbumsOfArtistDbListSwitcherController'),
                         ('/poblesec/database/music/tracks',
                          'elisa.plugins.database.music_controller:TracksDbListSwitcherController'),
                         ('/poblesec/database/music/genres',
                          'elisa.plugins.database.music_controller:GenresDbListSwitcherController'),
                         ('/poblesec/database/music/genre',
                          'elisa.plugins.database.music_controller:GenreDbListSwitcherController'),
                         ('/poblesec/database/music/decades',
                          'elisa.plugins.database.music_controller:DecadesDbListSwitcherController'),
                         ('/poblesec/database/music/time',
                          'elisa.plugins.database.music_controller:TimeDbListSwitcherController'),
                         ('/poblesec/database/music/tracks_played',
                          'elisa.plugins.database.playlists_controller:PlayedTracksListSwitcherController'),

                         ('/poblesec/database/movie/video_added',
                          'elisa.plugins.database.playlists_controller:AddedMovieListSwitcherController'),
                         ('/poblesec/database/movie/video_played',
                          'elisa.plugins.database.playlists_controller:PlayedMovieListSwitcherController'),
                         ('/poblesec/database/movie/video_unplayed',
                          'elisa.plugins.database.playlists_controller:UnPlayedMovieListSwitcherController'),

                         ('/poblesec/database/tvepisode/video_added',
                          'elisa.plugins.database.playlists_controller:AddedTVEpisodeListSwitcherController'),
                         ('/poblesec/database/tvepisode/video_played',
                          'elisa.plugins.database.playlists_controller:PlayedTVEpisodeListSwitcherController'),
                         ('/poblesec/database/tvepisode/video_unplayed',
                          'elisa.plugins.database.playlists_controller:UnPlayedTVEpisodeListSwitcherController'),

                         ('/poblesec/database/artist/more',
                          'elisa.plugins.database.music_controller:ArtistMoreOptionsController'),

                         ('/poblesec/database/album/list',
                          'elisa.plugins.database.music_controller:AlbumTracksListController'),
                         ('/poblesec/database/album/more',
                          'elisa.plugins.database.music_controller:AlbumMoreOptionsController'),

                         ('/poblesec/database/music/tracks_added',
                          'elisa.plugins.database.playlists_controller:AddedTracksListSwitcherController'),
                         ('/poblesec/database/photo/list',
                          'elisa.plugins.database.photo_controller:PhotoListSwitcherController'),
                         ('/poblesec/database/photo/photo_actions',
                          'elisa.plugins.database.photo_controller:PhotoVerticalWithPreview'),
                         ('/poblesec/database/photo/albums',
                          'elisa.plugins.database.photo_controller:AlbumsListSwitcherController'),
                         ('/poblesec/database/photo/by_month',
                          'elisa.plugins.database.photo_controller:PhotoMonthListSwitcherController'),
                         ('/poblesec/database/photo/by_date',
                          'elisa.plugins.database.photo_controller:PhotoTimesListSwitcherController'),
                         ('/poblesec/database/photo/photos_added',
                          'elisa.plugins.database.playlists_controller:AddedPhotosListSwitcherController'),
                         ('/poblesec/database/photo/photos_played',
                          'elisa.plugins.database.playlists_controller:PlayedPhotosListSwitcherController'),
                         ('/poblesec/database/video/unclassified',
                          'elisa.plugins.database.video_controller:AllVideosListSwitcherController'),

                         ('/poblesec/database/video/recategorize/choose_category',
                          'elisa.plugins.database.video_categorizer:ChooseCategoryController'),
                         ('/poblesec/database/recategorize/movie',
                          'elisa.plugins.database.video_categorizer:ChooseMovieFromSearchResultsController'),
                         ('/poblesec/database/recategorize/noresults/movie',
                          'elisa.plugins.database.video_categorizer:NoMovieResultsController'),
                         ('/poblesec/database/recategorize/search/movie',
                          'elisa.plugins.database.video_categorizer:SearchMovieController'),
                         ('/poblesec/database/recategorize/manual/movie',
                          'elisa.plugins.database.video_categorizer:ManualMovieController'),
                         ('/poblesec/database/recategorize/confirm/movie',
                          'elisa.plugins.database.video_categorizer:ConfirmToMovieController'),
                         ('/poblesec/database/recategorize/confirm/movie/manual',
                          'elisa.plugins.database.video_categorizer:ConfirmToManualMovieController'),
                         ('/poblesec/database/recategorize/success/movie',
                          'elisa.plugins.database.video_categorizer:RecategorizationToMovieCompleteController'),
                         ('/poblesec/database/recategorize/tvepisode',
                          'elisa.plugins.database.video_categorizer:ChooseTVEpisodeFromSearchResultsController'),
                         ('/poblesec/database/recategorize/noresults/tvepisode',
                          'elisa.plugins.database.video_categorizer:NoTVEpisodeResultsController'),
                         ('/poblesec/database/recategorize/search/tvepisode',
                          'elisa.plugins.database.video_categorizer:SearchTVEpisodeController'),
                         ('/poblesec/database/recategorize/manual/tvepisode',
                          'elisa.plugins.database.video_categorizer:ManualTVEpisodeController'),
                         ('/poblesec/database/recategorize/confirm/tvepisode',
                          'elisa.plugins.database.video_categorizer:ConfirmToTVEpisodeController'),
                         ('/poblesec/database/recategorize/confirm/tvepisode/manual',
                          'elisa.plugins.database.video_categorizer:ConfirmToManualTVEpisodeController'),
                         ('/poblesec/database/recategorize/success/tvepisode',
                          'elisa.plugins.database.video_categorizer:RecategorizationToTVEpisodeCompleteController'),

                         ('/poblesec/database/movie/list',
                          'elisa.plugins.database.video_controller:AllMoviesListSwitcherController'),
                         ('/poblesec/database/tvshows/list',
                          'elisa.plugins.database.tvshows_controllers:AllTVSeasonsListSwitcherController'),
                         ('/poblesec/database/tvseason/list',
                          'elisa.plugins.database.tvshows_controllers:TVSeasonEpisodeListController'),
                         ('/poblesec/database/tvseason/more',
                          'elisa.plugins.database.tvshows_controllers:TVSeasonMoreOptionsController'),
                         ('/poblesec/database/movie/synopsis',
                          'elisa.plugins.database.video_controller:MovieSynopsisController'),
                         ('/poblesec/database/tvepisode/synopsis',
                          'elisa.plugins.database.tvshows_controllers:TVEpisodeSynopsisController'),
                         ('/poblesec/database/.*playlists',
                          'elisa.plugins.database.playlists_controller:PlaylistsPreviewListController'),
                         ('/poblesec/database/.*library',
                          'elisa.plugins.poblesec.section:SectionMenuController'),

                         ('/poblesec/search/results/DBSearcher/artists',
                          'elisa.plugins.database.music_controller:ArtistsDbListSwitcherController'),
                         ('/poblesec/search/results/DBSearcher/albums',
                          'elisa.plugins.database.music_controller:AlbumsDbListSwitcherController'),
                         ('/poblesec/search/results/DBSearcher/tracks',
                          'elisa.plugins.database.music_controller:TracksDbListSwitcherController'),],

    decorator_mappings=[
                        # FIXME: the filesystem decorator should not be here
                        # but in the poblesec plugin ; this works around an
                        # ordering issue in the menus.
                        #('/poblesec/database/music_library',
                        #'elisa.plugins.poblesec.music:filesystem_decorator'),
                        #('/poblesec/database/video_library',
                        #'elisa.plugins.poblesec.video:filesystem_decorator'),
                        # music library entries
                        #('/poblesec/database/music_library',
                        # 'elisa.plugins.database.music_controller:music_lib_decades_decorator'),

                        #('/poblesec/database/video_library',
                        # 'elisa.plugins.database.tvshows_controllers:tvshows_lib_decorator'),

                        # music playlists
                        ('/poblesec/database/music/playlists',
                         'elisa.plugins.database.playlists_controller:recently_added_tracks_decorator'),
                        ('/poblesec/database/music/playlists',
                         'elisa.plugins.database.playlists_controller:most_played_tracks_decorator'),
                        ('/poblesec/database/music/playlists',
                         'elisa.plugins.database.playlists_controller:last_played_tracks_decorator'),
                         # movies playlists
                        ('/poblesec/database/movie/playlists',
                         'elisa.plugins.database.playlists_controller:recently_added_movie_decorator'),
                        ('/poblesec/database/movie/playlists',
                         'elisa.plugins.database.playlists_controller:most_played_movie_decorator'),
                        ('/poblesec/database/movie/playlists',
                         'elisa.plugins.database.playlists_controller:last_played_movie_decorator'),
                        ('/poblesec/database/movie/playlists',
                         'elisa.plugins.database.playlists_controller:unplayed_movie_decorator'),
                         # tv playlists
                        ('/poblesec/database/tv/playlists',
                         'elisa.plugins.database.playlists_controller:recently_added_tv_decorator'),
                        ('/poblesec/database/tv/playlists',
                         'elisa.plugins.database.playlists_controller:most_played_tv_decorator'),
                        ('/poblesec/database/tv/playlists',
                         'elisa.plugins.database.playlists_controller:last_played_tv_decorator'),
                        ('/poblesec/database/tv/playlists',
                         'elisa.plugins.database.playlists_controller:unplayed_tv_decorator'),
                        ],
    cmdclass=cmdclass,
)
