# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from elisa.core.utils.i18n import install_translation

from elisa.plugins.poblesec.link import Link
from elisa.plugins.poblesec.sections_menu import main_menu_decorate

from twisted.internet import defer

_ = install_translation('poblesec')

def internet_decorator(controller):
    controller_path = "/poblesec/internet_menu"
    label = _("Internet Media")
    icon = "elisa.plugins.poblesec.internet_section"
    dfr = main_menu_decorate(controller, controller_path, label, icon)
    return dfr

def internet_video_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/video/internet"
    link.label = _("Video")
    controller.model.append(link)
    return defer.succeed(None)

def internet_music_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/music/internet"
    link.label = _("Music")
    controller.model.append(link)
    return defer.succeed(None)

def internet_images_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/pictures/internet"
    link.label = _("Images")
    controller.model.append(link)
    return defer.succeed(None)

def internet_radio_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/radio/internet"
    link.label = _("Radio")
    controller.model.append(link)
    return defer.succeed(None)
