# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.core.components.input_provider import PushInputProvider
from elisa.core.input_event import *

from twisted.internet import stdio, protocol

import string


class RawInput(PushInputProvider, protocol.Protocol):
    """
    This class implements raw input support
    """

    def _display_help(self):
        # FIXME: this is a hack: non View classes are not allowed to output
        # things
        print "*** Actions ***"
        print "z : Go Up"
        print "s : Go Down"
        print "q : Go Left"
        print "d : Go Right"
        print "o : Play"
        print "p : Pause"
        print "0..9 : Select Item"
        print "w : Exit"
        print "? : Help"

    def create_input_event(self, data):
        self.debug("input data=%r", data)

        # considering only the first character
        data = data[0]

        event = InputEvent(EventSource.KEYBOARD,
                           EventType.KEY_DOWN,
                           EventAction.NONE)
        event.origin = self.origin

        if data == '\n':
            event.value = EventValue.KEY_RETURN
            return event
        elif data in string.ascii_letters + string.digits:
            event.value = eval("EventValue.KEY_%s" % data)

        if data == 'z':
            event.action = EventAction.GO_UP
        elif data == 'q':
            event.action = EventAction.GO_LEFT
        elif data == 's':
            event.action = EventAction.GO_DOWN
        elif data == 'd':
            event.action = EventAction.GO_RIGHT
        elif data == 'o':
            event.action = EventAction.PLAY
        elif data == 'p':
            event.action = EventAction.PAUSE
        elif data == 'w':
            event.action = EventAction.EXIT
        elif data == '?':
            self._display_help()

        return event


    def dataReceived(self, data):
        e = self.create_input_event(data)
        if (e and self.input_manager):
            self.input_manager.process_event(e, self.path)

    def bind(self):
        stdio.StandardIO(self)

    def unbind(self):
        pass

if __name__ == "__main__":

    try:
        from twisted.internet import glib2reactor
        glib2reactor.install()
    except AssertionError:
        # already installed...
        pass

    from twisted.internet import reactor

    class FakeManager:

        up_ok = False
        down_ok = False

        def process_event(self, event, input_provider_path):
            print event

    r = RawInput()
    m = FakeManager()
    r.input_manager = m
    r.bind()
    reactor.run()
    r.unbind()
