# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from elisa.core.utils import defer
from elisa.core.utils.i18n import install_translation
from elisa.core.action import ContextualAction
from elisa.core.resource_manager import ResourceProviderNotFound

from elisa.plugins.poblesec.link import Link

from elisa.plugins.poblesec.plugins_settings import GenericSettingsController
from elisa.plugins.poblesec.login import LoginController

from elisa.plugins.flickr.utils import get_flickr_provider

_ = install_translation('flickr')
_p = install_translation('poblesec')


def flickr_settings_decorator(controller):
    controller.append_plugin('flickr', _('Flickr'), '/poblesec/flickr/settings')
    return defer.succeed(None)

class AuthenticationAction(ContextualAction):

    def __init__(self, controller):
        super(AuthenticationAction, self).__init__(controller)
        provider = get_flickr_provider()
        if provider.is_logged_in():
            self.name = _("Log out")
        else:
            self.name = _("Log in")

    def execute(self, item):
        provider = get_flickr_provider()
        if provider.is_logged_in():
            self.name = _("Log in")
            provider.logout()
            dfr = defer.succeed(None)
        else:
            def controller_appended(result):
                self.name = _("Log out")
                return result

            browser = self.controller.frontend.retrieve_controllers('/poblesec/browser')[0]
            path = "/poblesec/flickr/login"
            title = _("Log in")
            dfr = browser.history.append_controller(path, title)
            dfr.addCallback(controller_appended)
        return dfr

class SettingsController(GenericSettingsController):

    def populate_model(self):
        action = AuthenticationAction(self)
        action.connect('name-changed', self._action_name_changed_cb)
        model = [action,]
        return defer.succeed(model)

    def _action_name_changed_cb(self, *args):
        self.refresh()

class FlickrLoginController(LoginController):

    """
    Specific login controller for Flickr.
    """

    def login(self, username, password):
        # Overridden from mother class.
        try:
            provider = get_flickr_provider()
        except ResourceProviderNotFound, error:
            return defer.fail(error)
        else:
            return provider.login(username, password)

    def success(self, result):
        # Overridden from mother class.
        browser = self.frontend.retrieve_controllers('/poblesec/browser')[0]
        paths = [('/poblesec/internet_menu', _p('INTERNET MEDIA'), {}),
                 ('/poblesec/pictures/internet', _p('Images'), {}),
                 ('/poblesec/flickr/home', _('Flickr'), {}),
                 ('/poblesec/flickr/account', _('My Flickr Account'), {})]
        return browser.navigate(paths)
