/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.journal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activeio.journal.InvalidRecordLocationException;
import org.apache.activeio.journal.Journal;
import org.apache.activeio.journal.JournalEventListener;
import org.apache.activeio.journal.RecordLocation;
import org.apache.activeio.packet.ByteArrayPacket;
import org.apache.activeio.packet.Packet;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.JournalQueueAck;
import org.apache.activemq.command.JournalTopicAck;
import org.apache.activemq.command.JournalTrace;
import org.apache.activemq.command.JournalTransaction;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.filter.NonCachedMessageEvaluationContext;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.journal.JournalMessageStore;
import org.apache.activemq.store.journal.JournalTopicMessageStore;
import org.apache.activemq.store.journal.JournalTransactionStore;
import org.apache.activemq.thread.Scheduler;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.usage.Usage;
import org.apache.activemq.usage.UsageListener;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ThreadPoolUtils;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalPersistenceAdapter
implements PersistenceAdapter,
JournalEventListener,
UsageListener,
BrokerServiceAware {
    private BrokerService brokerService;
    protected Scheduler scheduler;
    private static final Logger LOG = LoggerFactory.getLogger(JournalPersistenceAdapter.class);
    private Journal journal;
    private PersistenceAdapter longTermPersistence;
    private final WireFormat wireFormat = new OpenWireFormat();
    private final ConcurrentHashMap<ActiveMQQueue, JournalMessageStore> queues = new ConcurrentHashMap();
    private final ConcurrentHashMap<ActiveMQTopic, JournalTopicMessageStore> topics = new ConcurrentHashMap();
    private SystemUsage usageManager;
    private final long checkpointInterval = 300000L;
    private long lastCheckpointRequest = System.currentTimeMillis();
    private long lastCleanup = System.currentTimeMillis();
    private int maxCheckpointWorkers = 10;
    private int maxCheckpointMessageAddSize = 0x100000;
    private final JournalTransactionStore transactionStore = new JournalTransactionStore(this);
    private ThreadPoolExecutor checkpointExecutor;
    private TaskRunner checkpointTask;
    private CountDownLatch nextCheckpointCountDownLatch = new CountDownLatch(1);
    private boolean fullCheckPoint;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final Runnable periodicCheckpointTask = this.createPeriodicCheckpointTask();
    private TaskRunnerFactory taskRunnerFactory;
    private File directory;

    public JournalPersistenceAdapter() {
    }

    public JournalPersistenceAdapter(Journal journal, PersistenceAdapter longTermPersistence, TaskRunnerFactory taskRunnerFactory) throws IOException {
        this.setJournal(journal);
        this.setTaskRunnerFactory(taskRunnerFactory);
        this.setPersistenceAdapter(longTermPersistence);
    }

    public void setTaskRunnerFactory(TaskRunnerFactory taskRunnerFactory) {
        this.taskRunnerFactory = taskRunnerFactory;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
        journal.setJournalEventListener((JournalEventListener)this);
    }

    public void setPersistenceAdapter(PersistenceAdapter longTermPersistence) {
        this.longTermPersistence = longTermPersistence;
    }

    final Runnable createPeriodicCheckpointTask() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long lastTime = 0L;
                1 var3_2 = this;
                synchronized (var3_2) {
                    lastTime = JournalPersistenceAdapter.this.lastCheckpointRequest;
                }
                if (System.currentTimeMillis() > lastTime + 300000L) {
                    JournalPersistenceAdapter.this.checkpoint(false, true);
                }
            }
        };
    }

    public void setUsageManager(SystemUsage usageManager) {
        this.usageManager = usageManager;
        this.longTermPersistence.setUsageManager(usageManager);
    }

    public Set<ActiveMQDestination> getDestinations() {
        HashSet<ActiveMQDestination> destinations = new HashSet<ActiveMQDestination>(this.longTermPersistence.getDestinations());
        destinations.addAll(this.queues.keySet());
        destinations.addAll(this.topics.keySet());
        return destinations;
    }

    private MessageStore createMessageStore(ActiveMQDestination destination) throws IOException {
        if (destination.isQueue()) {
            return this.createQueueMessageStore((ActiveMQQueue)destination);
        }
        return this.createTopicMessageStore((ActiveMQTopic)destination);
    }

    public MessageStore createQueueMessageStore(ActiveMQQueue destination) throws IOException {
        JournalMessageStore store = this.queues.get(destination);
        if (store == null) {
            MessageStore checkpointStore = this.longTermPersistence.createQueueMessageStore(destination);
            store = new JournalMessageStore(this, checkpointStore, (ActiveMQDestination)destination);
            this.queues.put(destination, store);
        }
        return store;
    }

    public TopicMessageStore createTopicMessageStore(ActiveMQTopic destinationName) throws IOException {
        JournalTopicMessageStore store = this.topics.get(destinationName);
        if (store == null) {
            TopicMessageStore checkpointStore = this.longTermPersistence.createTopicMessageStore(destinationName);
            store = new JournalTopicMessageStore(this, checkpointStore, destinationName);
            this.topics.put(destinationName, store);
        }
        return store;
    }

    public void removeQueueMessageStore(ActiveMQQueue destination) {
        this.queues.remove(destination);
    }

    public void removeTopicMessageStore(ActiveMQTopic destination) {
        this.topics.remove(destination);
    }

    public TransactionStore createTransactionStore() throws IOException {
        return this.transactionStore;
    }

    public long getLastMessageBrokerSequenceId() throws IOException {
        return this.longTermPersistence.getLastMessageBrokerSequenceId();
    }

    public void beginTransaction(ConnectionContext context) throws IOException {
        this.longTermPersistence.beginTransaction(context);
    }

    public void commitTransaction(ConnectionContext context) throws IOException {
        this.longTermPersistence.commitTransaction(context);
    }

    public void rollbackTransaction(ConnectionContext context) throws IOException {
        this.longTermPersistence.rollbackTransaction(context);
    }

    public synchronized void start() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.checkpointTask = this.taskRunnerFactory.createTaskRunner(new Task(){

            public boolean iterate() {
                return JournalPersistenceAdapter.this.doCheckpoint();
            }
        }, "ActiveMQ Journal Checkpoint Worker");
        this.checkpointExecutor = new ThreadPoolExecutor(this.maxCheckpointWorkers, this.maxCheckpointWorkers, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runable) {
                Thread t = new Thread(runable, "Journal checkpoint worker");
                t.setPriority(7);
                return t;
            }
        });
        this.usageManager.getMemoryUsage().addUsageListener((UsageListener)this);
        if (this.longTermPersistence instanceof JDBCPersistenceAdapter) {
            ((JDBCPersistenceAdapter)this.longTermPersistence).setCleanupPeriod(0);
        }
        this.longTermPersistence.start();
        this.createTransactionStore();
        this.recover();
        this.scheduler = new Scheduler("Journal Scheduler");
        this.scheduler.start();
        this.scheduler.executePeriodically(this.periodicCheckpointTask, 30000L);
    }

    public void stop() throws Exception {
        this.usageManager.getMemoryUsage().removeUsageListener((UsageListener)this);
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        this.scheduler.cancel(this.periodicCheckpointTask);
        this.scheduler.stop();
        this.checkpoint(true, true);
        this.checkpointTask.shutdown();
        ThreadPoolUtils.shutdown((ExecutorService)this.checkpointExecutor);
        this.checkpointExecutor = null;
        this.queues.clear();
        this.topics.clear();
        IOException firstException = null;
        try {
            this.journal.close();
        }
        catch (Exception e) {
            firstException = IOExceptionSupport.create((String)("Failed to close journals: " + e), (Exception)e);
        }
        this.longTermPersistence.stop();
        if (firstException != null) {
            throw firstException;
        }
    }

    public PersistenceAdapter getLongTermPersistence() {
        return this.longTermPersistence;
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void overflowNotification(RecordLocation safeLocation) {
        this.checkpoint(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint(boolean sync, boolean fullCheckpoint) {
        try {
            if (this.journal == null) {
                throw new IllegalStateException("Journal is closed.");
            }
            long now = System.currentTimeMillis();
            CountDownLatch latch = null;
            JournalPersistenceAdapter journalPersistenceAdapter = this;
            synchronized (journalPersistenceAdapter) {
                latch = this.nextCheckpointCountDownLatch;
                this.lastCheckpointRequest = now;
                if (fullCheckpoint) {
                    this.fullCheckPoint = true;
                }
            }
            this.checkpointTask.wakeup();
            if (sync) {
                LOG.debug("Waking for checkpoint to complete.");
                latch.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("Request to start checkpoint failed: " + e, (Throwable)e);
        }
    }

    public void checkpoint(boolean sync) {
        this.checkpoint(sync, sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doCheckpoint() {
        boolean fullCheckpoint;
        CountDownLatch latch = null;
        JournalPersistenceAdapter journalPersistenceAdapter = this;
        synchronized (journalPersistenceAdapter) {
            latch = this.nextCheckpointCountDownLatch;
            this.nextCheckpointCountDownLatch = new CountDownLatch(1);
            fullCheckpoint = this.fullCheckPoint;
            this.fullCheckPoint = false;
        }
        try {
            JournalMessageStore ms;
            Iterator<JournalMessageStore> iterator;
            LOG.debug("Checkpoint started.");
            RecordLocation newMark = null;
            ArrayList<FutureTask<RecordLocation>> futureTasks = new ArrayList<FutureTask<RecordLocation>>(this.queues.size() + this.topics.size());
            if (fullCheckpoint) {
                iterator = this.queues.values().iterator();
                while (iterator.hasNext()) {
                    try {
                        ms = iterator.next();
                        FutureTask<RecordLocation> futureTask = new FutureTask<RecordLocation>(new Callable<RecordLocation>(){

                            @Override
                            public RecordLocation call() throws Exception {
                                return ms.checkpoint();
                            }
                        });
                        futureTasks.add(futureTask);
                        this.checkpointExecutor.execute(futureTask);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to checkpoint a message store: " + e, (Throwable)e);
                    }
                }
            }
            iterator = this.topics.values().iterator();
            while (iterator.hasNext()) {
                try {
                    ms = (JournalTopicMessageStore)iterator.next();
                    FutureTask<RecordLocation> futureTask = new FutureTask<RecordLocation>(new Callable<RecordLocation>((JournalTopicMessageStore)ms){
                        final /* synthetic */ JournalTopicMessageStore val$ms;
                        {
                            this.val$ms = journalTopicMessageStore;
                        }

                        @Override
                        public RecordLocation call() throws Exception {
                            return this.val$ms.checkpoint();
                        }
                    });
                    futureTasks.add(futureTask);
                    this.checkpointExecutor.execute(futureTask);
                }
                catch (Exception e) {
                    LOG.error("Failed to checkpoint a message store: " + e, (Throwable)e);
                }
            }
            try {
                for (FutureTask futureTask : futureTasks) {
                    RecordLocation mark = (RecordLocation)futureTask.get();
                    if (!fullCheckpoint || mark == null || newMark != null && newMark.compareTo((Object)mark) >= 0) continue;
                    newMark = mark;
                }
            }
            catch (Throwable e) {
                LOG.error("Failed to checkpoint a message store: " + e, e);
            }
            if (fullCheckpoint) {
                long now;
                try {
                    if (newMark != null) {
                        LOG.debug("Marking journal at: " + newMark);
                        this.journal.setMark(newMark, true);
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to mark the Journal: " + e, (Throwable)e);
                }
                if (this.longTermPersistence instanceof JDBCPersistenceAdapter && (now = System.currentTimeMillis()) > this.lastCleanup + 300000L) {
                    this.lastCleanup = now;
                    ((JDBCPersistenceAdapter)this.longTermPersistence).cleanup();
                }
            }
            LOG.debug("Checkpoint done.");
        }
        finally {
            latch.countDown();
        }
        journalPersistenceAdapter = this;
        synchronized (journalPersistenceAdapter) {
            return this.fullCheckPoint;
        }
    }

    public DataStructure readCommand(RecordLocation location) throws IOException {
        try {
            Packet packet = this.journal.read(location);
            return (DataStructure)this.wireFormat.unmarshal(this.toByteSequence(packet));
        }
        catch (InvalidRecordLocationException e) {
            throw this.createReadException(location, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw this.createReadException(location, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void recover() throws IllegalStateException, InvalidRecordLocationException, IOException, IOException {
        RecordLocation pos = null;
        int transactionCounter = 0;
        LOG.info("Journal Recovery Started from: " + this.journal);
        ConnectionContext context = new ConnectionContext((MessageEvaluationContext)new NonCachedMessageEvaluationContext());
        block13: while (true) {
            JournalMessageStore store;
            if ((pos = this.journal.getNextRecordLocation(pos)) == null) {
                RecordLocation location = this.writeTraceMessage("RECOVERED", true);
                this.journal.setMark(location, true);
                LOG.info("Journal Recovered: " + transactionCounter + " message(s) in transactions recovered.");
                return;
            }
            Packet data = this.journal.read(pos);
            DataStructure c = (DataStructure)this.wireFormat.unmarshal(this.toByteSequence(data));
            if (c instanceof Message) {
                Message message = (Message)c;
                store = (JournalMessageStore)this.createMessageStore(message.getDestination());
                if (message.isInTransaction()) {
                    this.transactionStore.addMessage(store, message, pos);
                    continue;
                }
                store.replayAddMessage(context, message);
                ++transactionCounter;
                continue;
            }
            switch (c.getDataStructureType()) {
                case 52: {
                    JournalQueueAck command = (JournalQueueAck)c;
                    store = (JournalMessageStore)this.createMessageStore(command.getDestination());
                    if (command.getMessageAck().isInTransaction()) {
                        this.transactionStore.removeMessage(store, command.getMessageAck(), pos);
                        continue block13;
                    }
                    store.replayRemoveMessage(context, command.getMessageAck());
                    ++transactionCounter;
                    continue block13;
                }
                case 50: {
                    JournalQueueAck command = (JournalTopicAck)c;
                    store = (JournalTopicMessageStore)this.createMessageStore(command.getDestination());
                    if (command.getTransactionId() != null) {
                        this.transactionStore.acknowledge((JournalTopicMessageStore)store, (JournalTopicAck)command, pos);
                        continue block13;
                    }
                    ((JournalTopicMessageStore)store).replayAcknowledge(context, command.getClientId(), command.getSubscritionName(), command.getMessageId());
                    ++transactionCounter;
                    continue block13;
                }
                case 54: {
                    JournalQueueAck command = (JournalTransaction)c;
                    try {
                        switch (command.getType()) {
                            case 1: {
                                this.transactionStore.replayPrepare(command.getTransactionId());
                                break;
                            }
                            case 2: 
                            case 4: {
                                JournalTransactionStore.Tx tx = this.transactionStore.replayCommit(command.getTransactionId(), command.getWasPrepared());
                                if (tx == null) break;
                                tx.getOperations();
                                for (JournalTransactionStore.TxOperation op : tx.getOperations()) {
                                    if (op.operationType == 0) {
                                        op.store.replayAddMessage(context, (Message)op.data);
                                    }
                                    if (op.operationType == 1) {
                                        op.store.replayRemoveMessage(context, (MessageAck)op.data);
                                    }
                                    if (op.operationType != 3) continue;
                                    JournalTopicAck ack = (JournalTopicAck)op.data;
                                    ((JournalTopicMessageStore)op.store).replayAcknowledge(context, ack.getClientId(), ack.getSubscritionName(), ack.getMessageId());
                                }
                                ++transactionCounter;
                                break;
                            }
                            case 3: 
                            case 5: {
                                this.transactionStore.replayRollback(command.getTransactionId());
                                break;
                            }
                            default: {
                                throw new IOException("Invalid journal command type: " + command.getType());
                            }
                        }
                    }
                    catch (IOException e) {
                        LOG.error("Recovery Failure: Could not replay: " + c + ", reason: " + e, (Throwable)e);
                    }
                    continue block13;
                }
                case 53: {
                    JournalTrace trace = (JournalTrace)c;
                    LOG.debug("TRACE Entry: " + trace.getMessage());
                    continue block13;
                }
            }
            LOG.error("Unknown type of record in transaction log which will be discarded: " + c);
        }
    }

    private IOException createReadException(RecordLocation location, Exception e) {
        return IOExceptionSupport.create((String)("Failed to read to journal for: " + location + ". Reason: " + e), (Exception)e);
    }

    protected IOException createWriteException(DataStructure packet, Exception e) {
        return IOExceptionSupport.create((String)("Failed to write to journal for: " + packet + ". Reason: " + e), (Exception)e);
    }

    protected IOException createWriteException(String command, Exception e) {
        return IOExceptionSupport.create((String)("Failed to write to journal for command: " + command + ". Reason: " + e), (Exception)e);
    }

    protected IOException createRecoveryFailedException(Exception e) {
        return IOExceptionSupport.create((String)("Failed to recover from journal. Reason: " + e), (Exception)e);
    }

    public RecordLocation writeCommand(DataStructure command, boolean sync) throws IOException {
        if (this.started.get()) {
            try {
                return this.journal.write(this.toPacket(this.wireFormat.marshal((Object)command)), sync);
            }
            catch (IOException ioe) {
                LOG.error("Cannot write to the journal", (Throwable)ioe);
                this.brokerService.handleIOException(ioe);
                throw ioe;
            }
        }
        throw new IOException("closed");
    }

    private RecordLocation writeTraceMessage(String message, boolean sync) throws IOException {
        JournalTrace trace = new JournalTrace();
        trace.setMessage(message);
        return this.writeCommand((DataStructure)trace, sync);
    }

    public void onUsageChanged(Usage usage, int oldPercentUsage, int newPercentUsage) {
        newPercentUsage = newPercentUsage / 10 * 10;
        oldPercentUsage = oldPercentUsage / 10 * 10;
        if (newPercentUsage >= 70 && oldPercentUsage < newPercentUsage) {
            boolean sync = newPercentUsage >= 90;
            this.checkpoint(sync, true);
        }
    }

    public JournalTransactionStore getTransactionStore() {
        return this.transactionStore;
    }

    public void deleteAllMessages() throws IOException {
        try {
            JournalTrace trace = new JournalTrace();
            trace.setMessage("DELETED");
            RecordLocation location = this.journal.write(this.toPacket(this.wireFormat.marshal((Object)trace)), false);
            this.journal.setMark(location, true);
            LOG.info("Journal deleted: ");
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create((Throwable)e);
        }
        this.longTermPersistence.deleteAllMessages();
    }

    public SystemUsage getUsageManager() {
        return this.usageManager;
    }

    public int getMaxCheckpointMessageAddSize() {
        return this.maxCheckpointMessageAddSize;
    }

    public void setMaxCheckpointMessageAddSize(int maxCheckpointMessageAddSize) {
        this.maxCheckpointMessageAddSize = maxCheckpointMessageAddSize;
    }

    public int getMaxCheckpointWorkers() {
        return this.maxCheckpointWorkers;
    }

    public void setMaxCheckpointWorkers(int maxCheckpointWorkers) {
        this.maxCheckpointWorkers = maxCheckpointWorkers;
    }

    public boolean isUseExternalMessageReferences() {
        return false;
    }

    public void setUseExternalMessageReferences(boolean enable) {
        if (enable) {
            throw new IllegalArgumentException("The journal does not support message references.");
        }
    }

    public Packet toPacket(ByteSequence sequence) {
        return new ByteArrayPacket(new org.apache.activeio.packet.ByteSequence(sequence.data, sequence.offset, sequence.length));
    }

    public ByteSequence toByteSequence(Packet packet) {
        org.apache.activeio.packet.ByteSequence sequence = packet.asByteSequence();
        return new ByteSequence(sequence.getData(), sequence.getOffset(), sequence.getLength());
    }

    public void setBrokerName(String brokerName) {
        this.longTermPersistence.setBrokerName(brokerName);
    }

    public String toString() {
        return "JournalPersistenceAdapator(" + this.longTermPersistence + ")";
    }

    public void setDirectory(File dir) {
        this.directory = dir;
    }

    public File getDirectory() {
        return this.directory;
    }

    public long size() {
        return 0L;
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
        PersistenceAdapter pa = this.getLongTermPersistence();
        if (pa instanceof BrokerServiceAware) {
            ((BrokerServiceAware)pa).setBrokerService(brokerService);
        }
    }

    public long getLastProducerSequenceId(ProducerId id) {
        return -1L;
    }
}

