/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.io.IOException;
import java.util.Arrays;
import javax.jms.JMSException;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.Message;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.util.JMSExceptionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkBridgeFilter
implements DataStructure,
BooleanExpression {
    public static final byte DATA_STRUCTURE_TYPE = 91;
    static final Logger LOG = LoggerFactory.getLogger(NetworkBridgeFilter.class);
    protected BrokerId networkBrokerId;
    protected int networkTTL;
    transient ConsumerInfo consumerInfo;

    public NetworkBridgeFilter() {
    }

    public NetworkBridgeFilter(ConsumerInfo consumerInfo, BrokerId networkBrokerId, int networkTTL) {
        this.networkBrokerId = networkBrokerId;
        this.networkTTL = networkTTL;
        this.consumerInfo = consumerInfo;
    }

    @Override
    public byte getDataStructureType() {
        return 91;
    }

    @Override
    public boolean isMarshallAware() {
        return false;
    }

    @Override
    public boolean matches(MessageEvaluationContext mec) throws JMSException {
        try {
            Message message = mec.getMessage();
            return message != null && this.matchesForwardingFilter(message, mec);
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    @Override
    public Object evaluate(MessageEvaluationContext message) throws JMSException {
        return this.matches(message) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected boolean matchesForwardingFilter(Message message, MessageEvaluationContext mec) {
        int hops;
        if (NetworkBridgeFilter.contains(message.getBrokerPath(), this.networkBrokerId)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Message all ready routed once through target broker (" + this.networkBrokerId + "), path: " + Arrays.toString(message.getBrokerPath()) + " - ignoring: " + message);
            }
            return false;
        }
        int n = hops = message.getBrokerPath() == null ? 0 : message.getBrokerPath().length;
        if (hops >= this.networkTTL) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Message restricted to " + this.networkTTL + " network hops ignoring: " + message);
            }
            return false;
        }
        if (message.isAdvisory()) {
            if (this.consumerInfo != null && this.consumerInfo.isNetworkSubscription()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("not propagating advisory to network sub: " + this.consumerInfo.getConsumerId() + ", message: " + message);
                }
                return false;
            }
            if (message.getDataStructure() != null && message.getDataStructure().getDataStructureType() == 5) {
                ConsumerInfo info2 = (ConsumerInfo)message.getDataStructure();
                int n2 = hops = info2.getBrokerPath() == null ? 0 : info2.getBrokerPath().length;
                if (hops >= this.networkTTL) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("ConsumerInfo advisory restricted to " + this.networkTTL + " network hops ignoring: " + message);
                    }
                    return false;
                }
                if (NetworkBridgeFilter.contains(info2.getBrokerPath(), this.networkBrokerId)) {
                    LOG.trace("ConsumerInfo advisory all ready routed once through target broker (" + this.networkBrokerId + "), path: " + Arrays.toString(info2.getBrokerPath()) + " - ignoring: " + message);
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean contains(BrokerId[] brokerPath, BrokerId brokerId) {
        if (brokerPath != null && brokerId != null) {
            for (int i = 0; i < brokerPath.length; ++i) {
                if (!brokerId.equals(brokerPath[i])) continue;
                return true;
            }
        }
        return false;
    }

    public int getNetworkTTL() {
        return this.networkTTL;
    }

    public void setNetworkTTL(int networkTTL) {
        this.networkTTL = networkTTL;
    }

    public BrokerId getNetworkBrokerId() {
        return this.networkBrokerId;
    }

    public void setNetworkBrokerId(BrokerId remoteBrokerPath) {
        this.networkBrokerId = remoteBrokerPath;
    }
}

