/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.FallbackConverter;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.spi.TypeConverterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public final class GenericFileConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GenericFileConverter.class);

    private GenericFileConverter() {
    }

    @FallbackConverter
    public static Object convertTo(Class<?> type, Exchange exchange, Object value, TypeConverterRegistry registry) throws IOException, NoTypeConversionAvailableException {
        if (GenericFile.class.isAssignableFrom(value.getClass())) {
            GenericFile file = (GenericFile)value;
            Class<?> from = file.getBody().getClass();
            if (from.isAssignableFrom(type)) {
                return file.getBody();
            }
            TypeConverter tc = registry.lookup(type, from);
            if (tc != null) {
                InputStream is;
                BufferedReader reader;
                Object body = file.getBody();
                if (Reader.class.isAssignableFrom(type) && (reader = GenericFileConverter.genericFileToReader(file, exchange)) != null) {
                    return reader;
                }
                if (InputStream.class.isAssignableFrom(type) && (is = GenericFileConverter.genericFileToInputStream(file, exchange)) != null) {
                    return is;
                }
                if (body instanceof File && file.getCharset() != null) {
                    reader = GenericFileConverter.genericFileToReader(file, exchange);
                    TypeConverter readerTc = registry.lookup(type, Reader.class);
                    if (readerTc != null) {
                        return readerTc.convertTo(type, exchange, reader);
                    }
                }
                return tc.convertTo(type, exchange, body);
            }
        }
        return null;
    }

    @Converter
    public static InputStream genericFileToInputStream(GenericFile<?> file, Exchange exchange) throws IOException, NoTypeConversionAvailableException {
        File f;
        if (file.getFile() instanceof File && (f = (File)file.getFile()).exists()) {
            String charset = file.getCharset();
            if (charset != null) {
                LOG.debug("Read file {} with charset {}", (Object)f, (Object)file.getCharset());
            } else {
                LOG.debug("Read file {} (no charset)", (Object)f);
            }
            return IOConverter.toInputStream(f, charset);
        }
        if (exchange != null) {
            file.getBinding().loadContent(exchange, file);
            return exchange.getContext().getTypeConverter().convertTo(InputStream.class, exchange, file.getBody());
        }
        return null;
    }

    @Converter
    public static String genericFileToString(GenericFile<?> file, Exchange exchange) throws IOException, NoTypeConversionAvailableException {
        BufferedReader reader = GenericFileConverter.genericFileToReader(file, exchange);
        if (reader != null) {
            return IOConverter.toString(reader);
        }
        if (exchange != null) {
            file.getBinding().loadContent(exchange, file);
            return exchange.getContext().getTypeConverter().convertTo(String.class, exchange, file.getBody());
        }
        return null;
    }

    @Converter
    public static Serializable genericFileToSerializable(GenericFile<?> file, Exchange exchange) throws IOException, NoTypeConversionAvailableException {
        InputStream is;
        if (exchange != null && (is = GenericFileConverter.genericFileToInputStream(file, exchange)) != null) {
            return exchange.getContext().getTypeConverter().convertTo(Serializable.class, exchange, is);
        }
        return null;
    }

    private static BufferedReader genericFileToReader(GenericFile<?> file, Exchange exchange) throws IOException, NoTypeConversionAvailableException {
        if (file.getFile() instanceof File) {
            File f = (File)file.getFile();
            if (!f.exists()) {
                return null;
            }
            String charset = file.getCharset();
            if (charset != null) {
                LOG.debug("Read file {} with charset {}", (Object)f, (Object)file.getCharset());
                return IOConverter.toReader(f, charset);
            }
            LOG.debug("Read file {} (no charset)", (Object)f);
            return IOConverter.toReader(f, exchange);
        }
        return null;
    }
}

