/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.ast;

import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.language.simple.ast.LiteralExpression;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;
import org.apache.camel.util.StringHelper;

public class SimpleFunctionExpression
extends LiteralExpression {
    public SimpleFunctionExpression(SimpleToken token) {
        super(token);
    }

    @Override
    public Expression createExpression(String expression) {
        String function = this.text.toString();
        return this.createSimpleExpression(function, true);
    }

    public Expression createExpression(String expression, boolean strict) {
        String function = this.text.toString();
        return this.createSimpleExpression(function, strict);
    }

    private Expression createSimpleExpression(String function, boolean strict) {
        String[] parts;
        Expression answer = this.createSimpleExpressionDirectly(function);
        if (answer != null) {
            return answer;
        }
        String remainder = this.ifStartsWithReturnRemainder("bodyAs", function);
        if (remainder != null) {
            String type = ObjectHelper.between(remainder, "(", ")");
            if (type == null) {
                throw new SimpleParserException("Valid syntax: ${bodyAs(type)} was: " + function, this.token.getIndex());
            }
            type = StringHelper.removeQuotes(type);
            return ExpressionBuilder.bodyExpression(type);
        }
        remainder = this.ifStartsWithReturnRemainder("mandatoryBodyAs", function);
        if (remainder != null) {
            String type = ObjectHelper.between(remainder, "(", ")");
            if (type == null) {
                throw new SimpleParserException("Valid syntax: ${mandatoryBodyAs(type)} was: " + function, this.token.getIndex());
            }
            type = StringHelper.removeQuotes(type);
            return ExpressionBuilder.mandatoryBodyExpression(type);
        }
        remainder = this.ifStartsWithReturnRemainder("body", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("in.body", function);
        }
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${body.OGNL} was: " + function, this.token.getIndex());
            }
            return ExpressionBuilder.bodyOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("exception", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${exception.OGNL} was: " + function, this.token.getIndex());
            }
            return ExpressionBuilder.exchangeExceptionOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("headerAs", function);
        if (remainder != null) {
            String keyAndType = ObjectHelper.between(remainder, "(", ")");
            if (keyAndType == null) {
                throw new SimpleParserException("Valid syntax: ${headerAs(key, type)} was: " + function, this.token.getIndex());
            }
            String key = ObjectHelper.before(keyAndType, ",");
            String type = ObjectHelper.after(keyAndType, ",");
            if (ObjectHelper.isEmpty(key) || ObjectHelper.isEmpty(type)) {
                throw new SimpleParserException("Valid syntax: ${headerAs(key, type)} was: " + function, this.token.getIndex());
            }
            key = StringHelper.removeQuotes(key);
            type = StringHelper.removeQuotes(type);
            return ExpressionBuilder.headerExpression(key, type);
        }
        if ("in.headers".equals(function) || "headers".equals(function)) {
            return ExpressionBuilder.headersExpression();
        }
        remainder = this.ifStartsWithReturnRemainder("in.headers", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("in.header", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("headers", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("header", function);
        }
        if (remainder != null) {
            boolean invalid;
            if (remainder.startsWith(".") || remainder.startsWith("?")) {
                remainder = remainder.substring(1);
            }
            if (remainder.startsWith("[") && remainder.endsWith("]")) {
                remainder = remainder.substring(1, remainder.length() - 1);
            }
            if (invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder)) {
                throw new SimpleParserException("Valid syntax: ${header.name[key]} was: " + function, this.token.getIndex());
            }
            if (OgnlHelper.isValidOgnlExpression(remainder)) {
                return ExpressionBuilder.headersOgnlExpression(remainder);
            }
            return ExpressionBuilder.headerExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("out.header.", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("out.headers.", function);
        }
        if (remainder != null) {
            return ExpressionBuilder.outHeaderExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("property", function);
        if (remainder != null) {
            boolean invalid;
            if (remainder.startsWith(".") || remainder.startsWith("?")) {
                remainder = remainder.substring(1);
            }
            if (remainder.startsWith("[") && remainder.endsWith("]")) {
                remainder = remainder.substring(1, remainder.length() - 1);
            }
            if (invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder)) {
                throw new SimpleParserException("Valid syntax: ${property.OGNL} was: " + function, this.token.getIndex());
            }
            if (OgnlHelper.isValidOgnlExpression(remainder)) {
                return ExpressionBuilder.propertyOgnlExpression(remainder);
            }
            return ExpressionBuilder.propertyExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("sys.", function);
        if (remainder != null) {
            return ExpressionBuilder.systemPropertyExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("sysenv.", function);
        if (remainder != null) {
            return ExpressionBuilder.systemEnvironmentExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("file:", function);
        if (remainder != null) {
            Expression fileExpression = this.createSimpleFileExpression(remainder);
            if (function != null) {
                return fileExpression;
            }
        }
        if ((remainder = this.ifStartsWithReturnRemainder("date:", function)) != null) {
            parts = remainder.split(":");
            if (parts.length < 2) {
                throw new SimpleParserException("Valid syntax: ${date:command:pattern} was: " + function, this.token.getIndex());
            }
            String command = ObjectHelper.before(remainder, ":");
            String pattern = ObjectHelper.after(remainder, ":");
            return ExpressionBuilder.dateExpression(command, pattern);
        }
        remainder = this.ifStartsWithReturnRemainder("bean:", function);
        if (remainder != null) {
            return ExpressionBuilder.beanExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("properties:", function);
        if (remainder != null) {
            parts = remainder.split(":");
            if (parts.length > 2) {
                throw new SimpleParserException("Valid syntax: ${properties:[locations]:key} was: " + function, this.token.getIndex());
            }
            String locations = null;
            String key = remainder;
            if (parts.length == 2) {
                locations = ObjectHelper.before(remainder, ":");
                key = ObjectHelper.after(remainder, ":");
            }
            return ExpressionBuilder.propertiesComponentExpression(key, locations);
        }
        remainder = this.ifStartsWithReturnRemainder("ref:", function);
        if (remainder != null) {
            return ExpressionBuilder.refExpression(remainder);
        }
        if (strict) {
            throw new SimpleParserException("Unknown function: " + function, this.token.getIndex());
        }
        return null;
    }

    private Expression createSimpleExpressionDirectly(String expression) {
        if (ObjectHelper.isEqualToAny(expression, "body", "in.body")) {
            return ExpressionBuilder.bodyExpression();
        }
        if (ObjectHelper.equal(expression, "out.body")) {
            return ExpressionBuilder.outBodyExpression();
        }
        if (ObjectHelper.equal(expression, "id")) {
            return ExpressionBuilder.messageIdExpression();
        }
        if (ObjectHelper.equal(expression, "exchangeId")) {
            return ExpressionBuilder.exchangeIdExpression();
        }
        if (ObjectHelper.equal(expression, "exception")) {
            return ExpressionBuilder.exchangeExceptionExpression();
        }
        if (ObjectHelper.equal(expression, "exception.message")) {
            return ExpressionBuilder.exchangeExceptionMessageExpression();
        }
        if (ObjectHelper.equal(expression, "exception.stacktrace")) {
            return ExpressionBuilder.exchangeExceptionStackTraceExpression();
        }
        if (ObjectHelper.equal(expression, "threadName")) {
            return ExpressionBuilder.threadNameExpression();
        }
        if (ObjectHelper.equal(expression, "camelId")) {
            return ExpressionBuilder.camelContextNameExpression();
        }
        return null;
    }

    private Expression createSimpleFileExpression(String remainder) {
        if (ObjectHelper.equal(remainder, "name")) {
            return ExpressionBuilder.fileNameExpression();
        }
        if (ObjectHelper.equal(remainder, "name.noext")) {
            return ExpressionBuilder.fileNameNoExtensionExpression();
        }
        if (ObjectHelper.equal(remainder, "name.ext")) {
            return ExpressionBuilder.fileExtensionExpression();
        }
        if (ObjectHelper.equal(remainder, "onlyname")) {
            return ExpressionBuilder.fileOnlyNameExpression();
        }
        if (ObjectHelper.equal(remainder, "onlyname.noext")) {
            return ExpressionBuilder.fileOnlyNameNoExtensionExpression();
        }
        if (ObjectHelper.equal(remainder, "ext")) {
            return ExpressionBuilder.fileExtensionExpression();
        }
        if (ObjectHelper.equal(remainder, "parent")) {
            return ExpressionBuilder.fileParentExpression();
        }
        if (ObjectHelper.equal(remainder, "path")) {
            return ExpressionBuilder.filePathExpression();
        }
        if (ObjectHelper.equal(remainder, "absolute")) {
            return ExpressionBuilder.fileAbsoluteExpression();
        }
        if (ObjectHelper.equal(remainder, "absolute.path")) {
            return ExpressionBuilder.fileAbsolutePathExpression();
        }
        if (ObjectHelper.equal(remainder, "length") || ObjectHelper.equal(remainder, "size")) {
            return ExpressionBuilder.fileSizeExpression();
        }
        if (ObjectHelper.equal(remainder, "modified")) {
            return ExpressionBuilder.fileLastModifiedExpression();
        }
        throw new SimpleParserException("Unknown file language syntax: " + remainder, this.token.getIndex());
    }

    private String ifStartsWithReturnRemainder(String prefix, String text) {
        String remainder;
        if (text.startsWith(prefix) && (remainder = text.substring(prefix.length())).length() > 0) {
            return remainder;
        }
        return null;
    }
}

