/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.Collections;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.jms.DefaultQueueBrowseStrategy;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.MessageHelper;
import org.springframework.jms.core.JmsOperations;

@ManagedResource(description="Managed JMS Queue Endpoint")
public class JmsQueueEndpoint
extends JmsEndpoint
implements BrowsableEndpoint {
    private int maximumBrowseSize = -1;
    private final QueueBrowseStrategy queueBrowseStrategy;

    public JmsQueueEndpoint(Queue destination) throws JMSException {
        this("jms:queue:" + destination.getQueueName(), null);
        this.setDestination((Destination)destination);
    }

    public JmsQueueEndpoint(String uri, JmsComponent component, String destination, JmsConfiguration configuration) {
        this(uri, component, destination, configuration, null);
    }

    public JmsQueueEndpoint(String uri, JmsComponent component, String destination, JmsConfiguration configuration, QueueBrowseStrategy queueBrowseStrategy) {
        super(uri, component, destination, false, configuration);
        this.queueBrowseStrategy = queueBrowseStrategy == null ? this.createQueueBrowseStrategy() : queueBrowseStrategy;
    }

    public JmsQueueEndpoint(String endpointUri, String destination, QueueBrowseStrategy queueBrowseStrategy) {
        super(endpointUri, destination, false);
        this.queueBrowseStrategy = queueBrowseStrategy == null ? this.createQueueBrowseStrategy() : queueBrowseStrategy;
    }

    public JmsQueueEndpoint(String endpointUri, String destination) {
        super(endpointUri, destination, false);
        this.queueBrowseStrategy = this.createQueueBrowseStrategy();
    }

    @ManagedAttribute
    public int getMaximumBrowseSize() {
        return this.maximumBrowseSize;
    }

    @ManagedAttribute
    public void setMaximumBrowseSize(int maximumBrowseSize) {
        this.maximumBrowseSize = maximumBrowseSize;
    }

    public List<Exchange> getExchanges() {
        if (this.queueBrowseStrategy == null) {
            return Collections.emptyList();
        }
        String queue = this.getDestinationName();
        JmsOperations template = this.getConfiguration().createInOnlyTemplate(this, false, queue);
        return this.queueBrowseStrategy.browse(template, queue, this);
    }

    @ManagedOperation(description="Current number of Exchanges in Queue")
    public long queueSize() {
        return this.getExchanges().size();
    }

    @ManagedOperation(description="Get Exchange from queue by index")
    public String browseExchange(Integer index) {
        List<Exchange> exchanges = this.getExchanges();
        if (index >= exchanges.size()) {
            return null;
        }
        Exchange exchange = exchanges.get(index);
        if (exchange == null) {
            return null;
        }
        return exchange.toString();
    }

    @ManagedOperation(description="Get message body from queue by index")
    public String browseMessageBody(Integer index) {
        List<Exchange> exchanges = this.getExchanges();
        if (index >= exchanges.size()) {
            return null;
        }
        Exchange exchange = exchanges.get(index);
        if (exchange == null) {
            return null;
        }
        String body = exchange.hasOut() ? (String)exchange.getOut().getBody(String.class) : (String)exchange.getIn().getBody(String.class);
        return body;
    }

    @ManagedOperation(description="Get message as XML from queue by index")
    public String browseMessageAsXml(Integer index, Boolean includeBody) {
        List<Exchange> exchanges = this.getExchanges();
        if (index >= exchanges.size()) {
            return null;
        }
        Exchange exchange = exchanges.get(index);
        if (exchange == null) {
            return null;
        }
        Message msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        String xml = MessageHelper.dumpAsXml((Message)msg, (boolean)includeBody);
        return xml;
    }

    @ManagedOperation(description="Gets all the messages as XML from the queue")
    public String browseAllMessagesAsXml(Boolean includeBody) {
        return this.browseRangeMessagesAsXml(0, Integer.MAX_VALUE, includeBody);
    }

    @ManagedOperation(description="Gets the range of messages as XML from the queue")
    public String browseRangeMessagesAsXml(Integer fromIndex, Integer toIndex, Boolean includeBody) {
        return EndpointHelper.browseRangeMessagesAsXml((BrowsableEndpoint)this, (Integer)fromIndex, (Integer)toIndex, (Boolean)includeBody);
    }

    protected QueueBrowseStrategy createQueueBrowseStrategy() {
        return new DefaultQueueBrowseStrategy();
    }
}

