/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.transport.SocketConnectorFactory;
import org.apache.activemq.transport.WebTransportServerSupport;
import org.apache.activemq.transport.ws.StompServlet;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class WSTransportServer
extends WebTransportServerSupport {
    public WSTransportServer(URI location) {
        super(location);
        this.bindAddress = location;
        this.socketConnectorFactory = new SocketConnectorFactory();
    }

    protected void doStart() throws Exception {
        this.server = new Server();
        if (this.connector == null) {
            this.connector = this.socketConnectorFactory.createConnector();
        }
        URI bind = this.getBindLocation();
        this.bind();
        ServletContextHandler contextHandler = new ServletContextHandler((HandlerContainer)this.server, "/", 0);
        ServletHolder holder = new ServletHolder();
        Map webSocketOptions = IntrospectionSupport.extractProperties((Map)this.transportOptions, (String)"websocket.");
        for (Map.Entry webSocketEntry : webSocketOptions.entrySet()) {
            Object value = webSocketEntry.getValue();
            if (value == null) continue;
            holder.setInitParameter((String)webSocketEntry.getKey(), value.toString());
        }
        holder.setServlet((Servlet)new StompServlet());
        contextHandler.addServlet(holder, "/");
        contextHandler.setAttribute("acceptListener", (Object)this.getAcceptListener());
        this.server.start();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        Server temp = this.server;
        this.server = null;
        if (temp != null) {
            temp.stop();
        }
    }

    public InetSocketAddress getSocketAddress() {
        return null;
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
    }

    protected void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void setTransportOption(Map<String, Object> transportOptions) {
        Map socketOptions = IntrospectionSupport.extractProperties(transportOptions, (String)"transport.");
        this.socketConnectorFactory.setTransportOptions(socketOptions);
        super.setTransportOption(transportOptions);
    }

    public boolean isSslServer() {
        return false;
    }
}

