/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.impl.XSDComponentImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XSDAnnotationImpl
extends XSDComponentImpl
implements XSDAnnotation {
    protected EList applicationInformation = null;
    protected EList userInformation = null;
    protected EList attributes = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static XSDAnnotation createAnnotation(Node node) {
        if (XSDConstants.nodeType(node) == 1) {
            XSDAnnotation xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
            xsdAnnotation.setElement((Element)node);
            return xsdAnnotation;
        }
        return null;
    }

    protected XSDAnnotationImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_ANNOTATION;
    }

    public EList getApplicationInformation() {
        if (this.applicationInformation == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.w3c.dom.Element");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.applicationInformation = new EDataTypeUniqueEList((Class)clazz, (InternalEObject)this, 5);
        }
        return this.applicationInformation;
    }

    public EList getUserInformation() {
        if (this.userInformation == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.w3c.dom.Element");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.userInformation = new EDataTypeUniqueEList((Class)clazz, (InternalEObject)this, 6);
        }
        return this.userInformation;
    }

    public EList getAttributes() {
        if (this.attributes == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.w3c.dom.Attr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.attributes = new EDataTypeUniqueEList((Class)clazz, (InternalEObject)this, 7);
        }
        return this.attributes;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getApplicationInformation();
            }
            case 6: {
                return this.getUserInformation();
            }
            case 7: {
                return this.getAttributes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.getApplicationInformation().clear();
                this.getApplicationInformation().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getUserInformation().clear();
                this.getUserInformation().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getAttributes().clear();
                this.getAttributes().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.getApplicationInformation().clear();
                return;
            }
            case 6: {
                this.getUserInformation().clear();
                return;
            }
            case 7: {
                this.getAttributes().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return this.applicationInformation != null && !this.applicationInformation.isEmpty();
            }
            case 6: {
                return this.userInformation != null && !this.userInformation.isEmpty();
            }
            case 7: {
                return this.attributes != null && !this.attributes.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (applicationInformation: ");
        result.append(this.applicationInformation);
        result.append(", userInformation: ");
        result.append(this.userInformation);
        result.append(", attributes: ");
        result.append(this.attributes);
        result.append(')');
        return result.toString();
    }

    public Element createElement() {
        Element newElement = this.createElement(1);
        this.setElement(newElement);
        return newElement;
    }

    public void validate() {
        super.validate();
        Element theElement = this.getElement();
        if (theElement != null) {
            this.checkElementComplexContent("annotation", "http://www.w3.org/TR/xmlschema-1/", "element-annotation", theElement);
        }
    }

    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        Element theElement = this.getElement();
        if (changedElement == theElement || changedElement.getParentNode() == theElement) {
            XSDConcreteComponent container = this.getContainer();
            ArrayList<Attr> newAttributes = new ArrayList<Attr>();
            Node theNode = theElement;
            while (theNode != null) {
                NamedNodeMap attributes = theNode.getAttributes();
                int i = 0;
                int size = attributes.getLength();
                while (i < size) {
                    Attr attr = (Attr)attributes.item(i);
                    String attrName = attr.getNodeName();
                    int index = attrName.lastIndexOf(":");
                    if (index != -1) {
                        newAttributes.add(attr);
                    }
                    ++i;
                }
                if (container == null || container.getElement() == theNode) break;
                theNode = theNode.getParentNode();
            }
            EList theAttributes = this.getAttributes();
            ArrayList remainingAttributes = new ArrayList(theAttributes);
            remainingAttributes.removeAll(newAttributes);
            if (!remainingAttributes.isEmpty()) {
                theAttributes.removeAll(remainingAttributes);
            }
            XSDAnnotationImpl.setListContentAndOrder(theAttributes, newAttributes);
        }
    }

    protected void reconcileContents(Element changedElement) {
        Element theElement = this.getElement();
        if (changedElement == theElement || changedElement.getParentNode() == theElement) {
            ArrayList<Node> newApplicationInformation = new ArrayList<Node>();
            ArrayList<Node> newUserInformation = new ArrayList<Node>();
            Node child = theElement.getFirstChild();
            while (child != null) {
                switch (XSDConstants.nodeType(child)) {
                    case 4: {
                        newApplicationInformation.add(child);
                        break;
                    }
                    case 10: {
                        newUserInformation.add(child);
                    }
                }
                child = child.getNextSibling();
            }
            EList theApplicationInformation = this.getApplicationInformation();
            ArrayList remainingApplicationInformation = new ArrayList(theApplicationInformation);
            remainingApplicationInformation.removeAll(newApplicationInformation);
            if (!remainingApplicationInformation.isEmpty()) {
                theApplicationInformation.removeAll(remainingApplicationInformation);
            }
            XSDAnnotationImpl.setListContentAndOrder(theApplicationInformation, newApplicationInformation);
            EList theUserInformation = this.getUserInformation();
            ArrayList remainingUserInformation = new ArrayList(theUserInformation);
            remainingUserInformation.removeAll(newUserInformation);
            if (!remainingUserInformation.isEmpty()) {
                remainingUserInformation.removeAll(newUserInformation);
            }
            theUserInformation.removeAll(remainingUserInformation);
            XSDAnnotationImpl.setListContentAndOrder(theUserInformation, newUserInformation);
        }
    }

    public Element createApplicationInformation(String sourceURI) {
        if (this.getElement() == null) {
            this.updateElement();
        }
        Element result = this.createElement(4);
        if (sourceURI != null && result != null) {
            result.setAttributeNS(null, "source", sourceURI);
        }
        return result;
    }

    public Element createUserInformation(String sourceURI) {
        if (this.getElement() == null) {
            this.updateElement();
        }
        Element result = this.createElement(10);
        if (sourceURI != null && result != null) {
            result.setAttributeNS(null, "source", sourceURI);
        }
        return result;
    }

    public EList getApplicationInformation(String sourceURI) {
        BasicEList result = new BasicEList();
        Iterator applicationInformation = this.getApplicationInformation().iterator();
        while (applicationInformation.hasNext()) {
            Element appinfo = (Element)applicationInformation.next();
            if (!(sourceURI == null ? !appinfo.hasAttributeNS(null, "source") : appinfo.getAttributeNS(null, "source").equals(sourceURI))) continue;
            result.add((Object)appinfo);
        }
        return result;
    }

    public EList getUserInformation(String sourceURI) {
        BasicEList result = new BasicEList();
        Iterator userInformation = this.getUserInformation().iterator();
        while (userInformation.hasNext()) {
            Element documentation = (Element)userInformation.next();
            if (!(sourceURI == null ? !documentation.hasAttributeNS(null, "source") : documentation.getAttributeNS(null, "source").equals(sourceURI))) continue;
            result.add((Object)documentation);
        }
        return result;
    }

    public Set getApplicationInformationSources() {
        HashSet<String> result = new HashSet<String>();
        Iterator applicationInformation = this.getApplicationInformation().iterator();
        while (applicationInformation.hasNext()) {
            Element appinfo = (Element)applicationInformation.next();
            result.add(appinfo.hasAttributeNS(null, "source") ? appinfo.getAttributeNS(null, "source") : null);
        }
        return result;
    }

    public Set getUserInformationSources() {
        HashSet<String> result = new HashSet<String>();
        Iterator userInformation = this.getUserInformation().iterator();
        while (userInformation.hasNext()) {
            Element documentation = (Element)userInformation.next();
            result.add(documentation.hasAttributeNS(null, "source") ? documentation.getAttributeNS(null, "source") : null);
        }
        return result;
    }

    protected void getComponentsWithInformation(Collection result, int nodeType, String sourceURI) {
        Iterator elements = (nodeType == 4 ? this.getApplicationInformation() : this.getUserInformation()).iterator();
        while (elements.hasNext()) {
            Element childElement = (Element)elements.next();
            if (!(sourceURI == null ? !childElement.hasAttributeNS(null, "source") : childElement.getAttributeNS(null, "source").equals(sourceURI))) continue;
            result.add(this.getContainer());
            break;
        }
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDAnnotationImpl clonedAnnotation = (XSDAnnotationImpl)this.getXSDFactory().createXSDAnnotation();
        clonedAnnotation.isReconciling = true;
        if (shareDOM) {
            Element element = this.getElement();
            if (element != null) {
                clonedAnnotation.setElement(element);
            }
            clonedAnnotation.getApplicationInformation().addAll((Collection)this.getApplicationInformation());
            clonedAnnotation.getUserInformation().addAll((Collection)this.getUserInformation());
            clonedAnnotation.getAttributes().addAll((Collection)this.getAttributes());
        }
        clonedAnnotation.isReconciling = shareDOM;
        return clonedAnnotation;
    }
}

