/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.views;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class ExplainErrorsView
extends ViewPart {
    private StyledText explanationText;
    private Color red;
    private Color yellow;
    private Color black;
    private HashMap levels = new HashMap();

    public ExplainErrorsView() {
        this.levels.put("(W)", "A warning (optional)");
        this.levels.put("(W once)", "A warning (optional)");
        this.levels.put("(D)", "A deprecation (optional)");
        this.levels.put("(S)", "A severe warning (default)");
        this.levels.put("(F)", "A fatal error (trappable)");
        this.levels.put("(P)", "An internal error you should never see (trappable)");
        this.levels.put("(X)", "A very fatal error (nontrappable)");
        this.levels.put("(A)", "An alien error message (not generated by Perl)");
    }

    public void createPartControl(Composite parent) {
        this.explanationText = new StyledText(parent, 770);
        this.explanationText.setEditable(false);
        this.red = new Color((Device)parent.getDisplay(), 216, 60, 26);
        this.yellow = new Color((Device)parent.getDisplay(), 211, 140, 29);
        this.black = new Color((Device)parent.getDisplay(), 0, 0, 0);
    }

    public String getText() {
        return this.explanationText.getText();
    }

    public void setFocus() {
        this.explanationText.setFocus();
    }

    public void explain(ArrayList markers) {
        this.explanationText.setText("");
        int i = 0;
        while (i < markers.size()) {
            IMarker marker = (IMarker)markers.get(i);
            try {
                int pos = this.explanationText.getCharCount();
                this.explanationText.append(String.valueOf((String)marker.getAttribute("message")) + "\n");
                int severity = (Integer)marker.getAttribute("severity");
                StyleRange styleRange = new StyleRange();
                styleRange.start = pos;
                styleRange.length = ((String)marker.getAttribute("message")).length();
                styleRange.fontStyle = 1;
                styleRange.foreground = severity == 1 ? this.yellow : this.red;
                this.explanationText.setStyleRange(styleRange);
                String expStr = (String)marker.getAttribute("org.epic.marker.printfPerlErrorMessage");
                String levelStr = null;
                if (expStr.length() > 0) {
                    levelStr = (String)this.levels.get(expStr.substring(0, expStr.indexOf(")") + 1));
                }
                if (levelStr != null) {
                    pos = this.explanationText.getCharCount();
                    this.explanationText.append(String.valueOf(levelStr) + "\n");
                    styleRange = new StyleRange();
                    styleRange.start = pos;
                    styleRange.length = levelStr.length();
                    styleRange.fontStyle = 2;
                    styleRange.foreground = this.black;
                    this.explanationText.setStyleRange(styleRange);
                }
                this.explanationText.append(levelStr != null ? expStr.substring(expStr.indexOf(")") + 2) : expStr);
                this.explanationText.append("\n");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }
}

