/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug;

import java.io.BufferedReader;
import java.io.PrintWriter;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.epic.debug.PerlTarget;
import org.epic.debug.db.PerlDB;
import org.epic.debug.util.IPathMapper;
import org.epic.debug.util.RemotePort;

public class DebugTarget
extends PerlTarget {
    private final IProcess process;
    private final RemotePort debugPort;
    private final PerlDB perlDB;
    private final IPathMapper pathMapper;

    public DebugTarget(ILaunch launch, IProcess process, RemotePort debugPort, IPathMapper pathMapper) throws CoreException {
        super(launch);
        this.process = process;
        this.debugPort = debugPort;
        this.perlDB = new PerlDB(this);
        this.pathMapper = pathMapper;
        if (!this.perlDB.isTerminated()) {
            this.initDebugger();
        }
    }

    public PerlDB getDebugger() {
        return this.perlDB;
    }

    public String getName() throws DebugException {
        return this.getProcess().getLabel();
    }

    public IProcess getProcess() {
        return this.process;
    }

    public RemotePort getRemotePort() {
        return this.debugPort;
    }

    public boolean isLocal() {
        return true;
    }

    public int getDebugPort() {
        return this.debugPort.getServerPort();
    }

    public BufferedReader getDebugReadStream() {
        return this.debugPort.getReadStream();
    }

    public PrintWriter getDebugWriteStream() {
        return this.debugPort.getWriteStream();
    }

    public IPathMapper getPathMapper() {
        return this.pathMapper;
    }

    public void debugSessionTerminated() {
        this.shutdown();
    }

    public void perlDBstarted(PerlDB perlDB) {
    }

    public IThread[] getThreads() throws DebugException {
        return this.perlDB.getThreads();
    }

    public boolean hasThreads() throws DebugException {
        return this.perlDB.getThreads() != null;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return false;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.perlDB.isTerminated((IDebugElement)this);
    }

    public void terminate() throws DebugException {
        this.shutdown();
    }

    public boolean canResume() {
        return this.perlDB.canResume((IDebugElement)this);
    }

    public boolean canSuspend() {
        return this.perlDB.canSuspend((IDebugElement)this);
    }

    public boolean isSuspended() {
        return this.perlDB.isSuspended((IDebugElement)this);
    }

    public void resume() throws DebugException {
        this.perlDB.resume((IDebugElement)this);
    }

    public void suspend() throws DebugException {
        this.perlDB.suspend((IDebugElement)this);
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
        this.unsupportedOperation();
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        this.unsupportedOperation();
        return null;
    }

    protected void initDebugger() throws DebugException {
        this.getDebugger().init(null, -1, -1);
    }

    protected void shutdown() {
        this.debugPort.shutdown();
        super.shutdown();
    }
}

