/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.ui.PerlDebugImages;
import org.epic.debug.ui.ProjectAndFileBlock;
import org.epic.debug.ui.ProjectBlock;

public class LaunchConfigurationMainTab
extends AbstractLaunchConfigurationTab {
    private ProjectBlock projectBlock;

    public LaunchConfigurationMainTab(boolean includeFileBlock) {
        this.projectBlock = includeFileBlock ? new ProjectAndFileBlock() : new ProjectBlock();
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.projectBlock.createControl(comp);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.projectBlock.initializeFrom(config);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        this.projectBlock.performApply(config);
    }

    public String getErrorMessage() {
        String m = super.getErrorMessage();
        return m == null ? this.projectBlock.getErrorMessage() : m;
    }

    public String getMessage() {
        String m = super.getMessage();
        return m == null ? this.projectBlock.getMessage() : m;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.projectBlock.setLaunchConfigurationDialog(dialog);
    }

    public void dispose() {
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return this.projectBlock.isValid(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        this.projectBlock.setDefaults(config);
    }

    public String getName() {
        return "Main";
    }

    public Image getImage() {
        return PerlDebugPlugin.getDefaultDesciptorImageRegistry().get(PerlDebugImages.DESC_OBJS_LaunchTabMain);
    }
}

