/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.varparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.varparser.PerlDebugVar;

public class PerlDebugValue
extends DebugElement
implements IValue {
    private static final IVariable[] NO_VARS = new IVariable[0];
    public static final int CONTENT_HAS_CHANGED = 1;
    public static final int VALUE_HAS_CHANGED = 2;
    public static final int VALUE_UNCHANGED = 0;
    private final List vars;
    private final String value;
    private final String type;

    public PerlDebugValue(IDebugTarget parent, String type, String value) {
        this(parent, type, value, NO_VARS);
    }

    public PerlDebugValue(IDebugTarget parent, String type, String value, IVariable[] vars) {
        super(parent);
        this.type = type;
        this.value = value;
        this.vars = new ArrayList<IVariable>(Arrays.asList(vars));
    }

    public void addVar(PerlDebugVar var) {
        this.vars.add(var);
    }

    public int calculateChangeFlags(PerlDebugValue previous) {
        int ret = 0;
        try {
            int countNew;
            int countOld;
            if (this.value == null && previous.getValueString() != null || !this.value.equals(previous.getValueString())) {
                ret = 2;
            }
            if (this.type == null && previous.type != null || this.type != null && !this.type.equals(previous.type)) {
                ret = 2;
            }
            if ((countOld = previous.vars.size()) != (countNew = this.vars.size())) {
                ret |= 1;
            }
            int newPos = 0;
            while (newPos < countNew) {
                boolean found = false;
                PerlDebugVar varNew = (PerlDebugVar)((Object)this.vars.get(newPos));
                int oldPos = 0;
                while (oldPos < countOld && !found) {
                    PerlDebugVar varOld = (PerlDebugVar)((Object)previous.vars.get(oldPos));
                    if (varOld.getName().equals(varNew.getName())) {
                        found = true;
                        if (varNew.calculateChangeFlags(varOld)) {
                            ret |= 1;
                        }
                    }
                    ++oldPos;
                }
                if (!found) {
                    varNew.setChangeFlags(2, true);
                    ret |= 1;
                }
                ++newPos;
            }
            return ret;
        }
        catch (DebugException e) {
            PerlDebugPlugin.log(e);
            return 0;
        }
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public String getReferenceTypeName() throws DebugException {
        return this.type;
    }

    public String getValueString() throws DebugException {
        return this.value;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.vars.toArray(new IVariable[this.vars.size()]);
    }

    public boolean hasVariables() throws DebugException {
        return !this.vars.isEmpty();
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public String toString() {
        return "T" + (this.type != null ? this.type : "<null>") + "{" + this.value + "} with " + this.vars.size() + " vars";
    }

    void setChangeFlags(int value, boolean recurse) {
        Iterator i = this.vars.iterator();
        while (i.hasNext()) {
            ((PerlDebugVar)((Object)i.next())).setChangeFlags(value, recurse);
        }
    }
}

