/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.CallGraphEdge;
import edu.umd.cs.findbugs.CallGraphNode;
import edu.umd.cs.findbugs.CallSite;
import edu.umd.cs.findbugs.graph.AbstractEdge;
import edu.umd.cs.findbugs.graph.AbstractGraph;
import edu.umd.cs.findbugs.graph.AbstractVertex;
import java.util.IdentityHashMap;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallGraph
extends AbstractGraph<CallGraphEdge, CallGraphNode> {
    private IdentityHashMap<Method, CallGraphNode> methodToNodeMap = new IdentityHashMap();

    public CallGraphEdge createEdge(CallGraphNode source, CallGraphNode target, CallSite callSite) {
        CallGraphEdge edge = (CallGraphEdge)this.createEdge(source, target);
        edge.setCallSite(callSite);
        return edge;
    }

    public CallGraphNode addNode(Method method) {
        CallGraphNode node = new CallGraphNode();
        this.addVertex(node);
        node.setMethod(method);
        this.methodToNodeMap.put(method, node);
        return node;
    }

    public CallGraphNode getNodeForMethod(Method method) {
        return this.methodToNodeMap.get(method);
    }

    @Override
    protected CallGraphEdge allocateEdge(CallGraphNode source, CallGraphNode target) {
        return new CallGraphEdge(source, target);
    }

    @Override
    protected /* synthetic */ AbstractEdge allocateEdge(AbstractVertex x0, AbstractVertex x1) {
        return this.allocateEdge((CallGraphNode)x0, (CallGraphNode)x1);
    }
}

