/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.config;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class CommandLine {
    private List<String> optionList = new LinkedList<String>();
    private Set<String> requiresArgumentSet = new HashSet<String>();
    private Map<String, String> optionDescriptionMap = new HashMap<String, String>();
    private Map<String, String> optionExtraPartSynopsisMap = new HashMap<String, String>();
    private Map<String, String> argumentDescriptionMap = new HashMap<String, String>();
    int maxWidth = 0;
    private static final String SPACES = "                    ";

    public void addSwitch(String option, String description) {
        this.optionList.add(option);
        this.optionDescriptionMap.put(option, description);
        if (option.length() > this.maxWidth) {
            this.maxWidth = option.length();
        }
    }

    public void addSwitchWithOptionalExtraPart(String option, String optionExtraPartSynopsis, String description) {
        this.optionList.add(option);
        this.optionExtraPartSynopsisMap.put(option, optionExtraPartSynopsis);
        this.optionDescriptionMap.put(option, description);
        int length = option.length() + optionExtraPartSynopsis.length() + 3;
        if (length > this.maxWidth) {
            this.maxWidth = length;
        }
    }

    public void addOption(String option, String argumentDesc, String description) {
        this.optionList.add(option);
        this.optionDescriptionMap.put(option, description);
        this.requiresArgumentSet.add(option);
        this.argumentDescriptionMap.put(option, argumentDesc);
        int width = option.length() + 3 + argumentDesc.length();
        if (width > this.maxWidth) {
            this.maxWidth = width;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] expandOptionFiles(String[] argv, boolean ignoreComments, boolean ignoreBlankLines) throws IOException {
        ArrayList<String> resultList = new ArrayList<String>();
        String[] arr$ = argv;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String arg = arr$[i$];
            if (!arg.startsWith("@")) {
                resultList.add(arg);
                continue;
            }
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(arg.substring(1)), Charset.forName("UTF-8")));
                while ((line = reader.readLine()) != null) {
                    line = line.trim();
                    if (ignoreComments && line.startsWith("#") || ignoreBlankLines && line.equals("")) continue;
                    resultList.add(line);
                }
                continue;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    @SuppressWarnings(value={"DM_EXIT"})
    public int parse(String[] argv, int minArgs, int maxArgs, String usage) {
        try {
            int count = this.parse(argv);
            int remaining = argv.length - count;
            if (remaining < minArgs || remaining > maxArgs) {
                System.out.println(usage);
                System.out.println("Expected " + minArgs + "..." + maxArgs + " file arguments, found " + remaining);
                System.out.println("Options:");
                this.printUsage(System.out);
                System.exit(1);
            }
            return count;
        }
        catch (HelpRequestedException e) {
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(usage);
        System.out.println("Options:");
        this.printUsage(System.out);
        System.exit(1);
        return -1;
    }

    public int parse(String[] argv) throws IOException, HelpRequestedException {
        int arg = 0;
        while (arg < argv.length) {
            String option = argv[arg];
            if (option.equals("-help")) {
                throw new HelpRequestedException();
            }
            if (!option.startsWith("-")) break;
            String optionExtraPart = "";
            int colon = option.indexOf(58);
            if (colon >= 0) {
                optionExtraPart = option.substring(colon + 1);
                option = option.substring(0, colon);
            }
            if (this.optionDescriptionMap.get(option) == null) {
                throw new IllegalArgumentException("Unknown option: " + option);
            }
            if (this.requiresArgumentSet.contains(option)) {
                if (++arg >= argv.length) {
                    throw new IllegalArgumentException("Option " + option + " requires an argument");
                }
                String argument = argv[arg];
                this.handleOptionWithArgument(option, argument);
                ++arg;
                continue;
            }
            this.handleOption(option, optionExtraPart);
            ++arg;
        }
        return arg;
    }

    protected abstract void handleOption(String var1, String var2) throws IOException;

    protected abstract void handleOptionWithArgument(String var1, String var2) throws IOException;

    public void printUsage(OutputStream os) {
        PrintStream out = new PrintStream(os);
        Iterator<String> i$ = this.optionList.iterator();
        while (i$.hasNext()) {
            String option = i$.next();
            out.print("  ");
            StringBuffer buf = new StringBuffer();
            buf.append(option);
            if (this.optionExtraPartSynopsisMap.get(option) != null) {
                String optionExtraPartSynopsis = this.optionExtraPartSynopsisMap.get(option);
                buf.append("[:");
                buf.append(optionExtraPartSynopsis);
                buf.append("]");
            }
            if (this.requiresArgumentSet.contains(option)) {
                buf.append(" <");
                buf.append(this.argumentDescriptionMap.get(option));
                buf.append(">");
            }
            CommandLine.printField(out, buf.toString(), this.maxWidth + 1);
            out.println(this.optionDescriptionMap.get(option));
        }
        out.flush();
    }

    private static void printField(PrintStream out, String s, int width) {
        int n;
        if (s.length() > width) {
            throw new IllegalArgumentException();
        }
        out.print(s);
        for (int nSpaces = width - s.length(); nSpaces > 0; nSpaces -= n) {
            n = Math.min(SPACES.length(), nSpaces);
            out.print(SPACES.substring(0, n));
        }
    }

    public static class HelpRequestedException
    extends Exception {
    }
}

