/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.NameMatch;
import edu.umd.cs.findbugs.filter.SignatureUtil;

public class FieldMatcher
implements Matcher {
    private NameMatch name;
    private String signature;

    public FieldMatcher(String name) {
        this.name = new NameMatch(name);
    }

    public FieldMatcher(String name, String type) {
        this.name = new NameMatch(name);
        this.signature = SignatureUtil.createFieldSignature(type);
    }

    public boolean match(BugInstance bugInstance) {
        FieldAnnotation fieldAnnotation = bugInstance.getPrimaryField();
        if (fieldAnnotation == null) {
            return false;
        }
        if (!this.name.match(fieldAnnotation.getFieldName())) {
            return false;
        }
        return this.signature == null || this.signature.equals(fieldAnnotation.getFieldSignature());
    }
}

