/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.builder;

import java.util.Date;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.core.builder.AbstractRdtCompiler;
import org.rubypeople.rdt.internal.core.builder.CleanRdtCompiler;
import org.rubypeople.rdt.internal.core.builder.IncrementalRdtCompiler;
import org.rubypeople.rdt.internal.core.symbols.SymbolIndex;

public class RubyBuilder
extends IncrementalProjectBuilder {
    public static boolean DEBUG;
    private IProject currentProject;

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        this.currentProject = this.getProject();
        if (this.currentProject == null || !this.currentProject.isAccessible()) {
            return null;
        }
        if (DEBUG) {
            RubyCore.trace("Started " + this.buildType(n) + " build of " + this.buildDescription());
        }
        AbstractRdtCompiler abstractRdtCompiler = this.createCompiler(n);
        abstractRdtCompiler.compile(iProgressMonitor);
        if (DEBUG) {
            RubyCore.trace("Finished build of " + this.buildDescription());
        }
        return null;
    }

    private AbstractRdtCompiler createCompiler(int n) {
        SymbolIndex symbolIndex = RubyCore.getPlugin().getSymbolIndex();
        if (this.isPartialBuild(n)) {
            return new IncrementalRdtCompiler(this.currentProject, this.getDelta(this.currentProject), symbolIndex);
        }
        return new CleanRdtCompiler(this.currentProject, symbolIndex);
    }

    private String buildType(int n) {
        return this.isPartialBuild(n) ? "Incremental" : "Full";
    }

    private String buildDescription() {
        return String.valueOf(this.currentProject.getName()) + " @ " + new Date(System.currentTimeMillis());
    }

    private boolean isPartialBuild(int n) {
        return n == 10 || n == 9;
    }

    public static void setVerbose(boolean bl) {
        DEBUG = bl;
    }
}

