/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.debug.internal.ui.ImageDescriptorRegistry;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesMessages;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyElementImageProvider;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.rubypeople.rdt.ui.RubyElementImageDescriptor;

public class MembersOrderPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREF_ID = "org.rubypeople.rdt.ui.preferences.MembersOrderPreferencePage";
    private static final String ALL_SORTMEMBER_ENTRIES = "T,SF,SM,F,C,M";
    private static final String ALL_VISIBILITY_ENTRIES = "B,V,R";
    private static final String PREF_OUTLINE_SORT_OPTION = "outlinesortoption";
    private static final String PREF_VISIBILITY_SORT_OPTION = "org.eclipse.jdt.ui.visibility.order";
    private static final String PREF_USE_VISIBILITY_SORT_OPTION = "org.rubypeople.rdt.ui.enable.visibility.order";
    public static final String CONSTRUCTORS = "C";
    public static final String FIELDS = "F";
    public static final String METHODS = "M";
    public static final String STATIC_METHODS = "SM";
    public static final String STATIC_FIELDS = "SF";
    public static final String TYPES = "T";
    public static final String PUBLIC = "B";
    public static final String PRIVATE = "V";
    public static final String PROTECTED = "R";
    private boolean fUseVisibilitySort;
    private ListDialogField fSortOrderList;
    private ListDialogField fVisibilityOrderList;
    private SelectionButtonDialogField fUseVisibilitySortField;

    private static boolean isValidEntries(List list, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!list.contains(string2)) {
                return false;
            }
            ++n;
        }
        return n == list.size();
    }

    public MembersOrderPreferencePage() {
        this.setPreferenceStore(RubyPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.MembersOrderPreferencePage_label_description);
        String string = this.getPreferenceStore().getString(PREF_OUTLINE_SORT_OPTION);
        String string2 = PreferencesMessages.MembersOrderPreferencePage_category_button_up;
        String string3 = PreferencesMessages.MembersOrderPreferencePage_category_button_down;
        this.fSortOrderList = new ListDialogField(null, new String[]{string2, string3}, (ILabelProvider)new MemberSortLabelProvider());
        this.fSortOrderList.setDownButtonIndex(1);
        this.fSortOrderList.setUpButtonIndex(0);
        List list = MembersOrderPreferencePage.parseList(string);
        if (!MembersOrderPreferencePage.isValidEntries(list, ALL_SORTMEMBER_ENTRIES)) {
            string = this.getPreferenceStore().getDefaultString(PREF_OUTLINE_SORT_OPTION);
            list = MembersOrderPreferencePage.parseList(string);
        }
        this.fSortOrderList.setElements(list);
        this.fUseVisibilitySort = this.getPreferenceStore().getBoolean(PREF_USE_VISIBILITY_SORT_OPTION);
        String string4 = this.getPreferenceStore().getString(PREF_VISIBILITY_SORT_OPTION);
        string2 = PreferencesMessages.MembersOrderPreferencePage_visibility_button_up;
        string3 = PreferencesMessages.MembersOrderPreferencePage_visibility_button_down;
        this.fVisibilityOrderList = new ListDialogField(null, new String[]{string2, string3}, (ILabelProvider)new VisibilitySortLabelProvider());
        this.fVisibilityOrderList.setDownButtonIndex(1);
        this.fVisibilityOrderList.setUpButtonIndex(0);
        list = MembersOrderPreferencePage.parseList(string4);
        if (!MembersOrderPreferencePage.isValidEntries(list, ALL_VISIBILITY_ENTRIES)) {
            string4 = this.getPreferenceStore().getDefaultString(PREF_VISIBILITY_SORT_OPTION);
            list = MembersOrderPreferencePage.parseList(string4);
        }
        this.fVisibilityOrderList.setElements(list);
    }

    private static List parseList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
            ++n;
        }
        return arrayList;
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.rubypeople.rdt.ui.sort_order_preference_page_context");
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 768;
        composite2.setLayoutData((Object)gridData);
        this.createListDialogField(composite2, this.fSortOrderList);
        this.fUseVisibilitySortField = new SelectionButtonDialogField(32);
        this.fUseVisibilitySortField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                MembersOrderPreferencePage.this.fVisibilityOrderList.setEnabled(MembersOrderPreferencePage.this.fUseVisibilitySortField.isSelected());
            }
        });
        this.fUseVisibilitySortField.setLabelText(PreferencesMessages.MembersOrderPreferencePage_usevisibilitysort_label);
        this.fUseVisibilitySortField.doFillIntoGrid(composite2, 2);
        this.fUseVisibilitySortField.setSelection(this.fUseVisibilitySort);
        this.createListDialogField(composite2, this.fVisibilityOrderList);
        this.fVisibilityOrderList.setEnabled(this.fUseVisibilitySortField.isSelected());
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void createListDialogField(Composite composite, ListDialogField listDialogField) {
        Control control = listDialogField.getListControl(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = this.convertWidthInCharsToPixels(50);
        control.setLayoutData((Object)gridData);
        Composite composite2 = listDialogField.getButtonBox(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        composite2.setLayoutData((Object)gridData);
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected void performDefaults() {
        IPreferenceStore iPreferenceStore = RubyPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getDefaultString(PREF_OUTLINE_SORT_OPTION);
        if (string != null) {
            this.fSortOrderList.setElements(MembersOrderPreferencePage.parseList(string));
        } else {
            this.fSortOrderList.setElements(MembersOrderPreferencePage.parseList(ALL_SORTMEMBER_ENTRIES));
        }
        string = iPreferenceStore.getDefaultString(PREF_VISIBILITY_SORT_OPTION);
        if (string != null) {
            this.fVisibilityOrderList.setElements(MembersOrderPreferencePage.parseList(string));
        } else {
            this.fVisibilityOrderList.setElements(MembersOrderPreferencePage.parseList(ALL_VISIBILITY_ENTRIES));
        }
        this.fUseVisibilitySortField.setSelection(iPreferenceStore.getDefaultBoolean(PREF_USE_VISIBILITY_SORT_OPTION));
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.updateList(iPreferenceStore, this.fSortOrderList, PREF_OUTLINE_SORT_OPTION);
        this.updateList(iPreferenceStore, this.fVisibilityOrderList, PREF_VISIBILITY_SORT_OPTION);
        iPreferenceStore.setValue(PREF_USE_VISIBILITY_SORT_OPTION, this.fUseVisibilitySortField.isSelected());
        RubyPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void updateList(IPreferenceStore iPreferenceStore, ListDialogField listDialogField, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        List list = listDialogField.getElements();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            stringBuffer.append(string2);
            stringBuffer.append(',');
        }
        iPreferenceStore.setValue(string, stringBuffer.toString());
    }

    private class MemberSortLabelProvider
    extends LabelProvider {
        public Image getImage(Object object) {
            ImageDescriptorRegistry imageDescriptorRegistry = RubyPlugin.getImageDescriptorRegistry();
            Object object2 = null;
            if (object instanceof String) {
                int n = 0;
                String string = (String)object;
                if (string.equals(MembersOrderPreferencePage.FIELDS)) {
                    object2 = RubyElementImageProvider.getFieldImageDescriptor();
                } else if (string.equals(MembersOrderPreferencePage.CONSTRUCTORS)) {
                    object2 = RubyElementImageProvider.getMethodImageDescriptor(n);
                    object2 = new RubyElementImageDescriptor((ImageDescriptor)object2, 512, RubyElementImageProvider.SMALL_SIZE);
                } else if (string.equals(MembersOrderPreferencePage.METHODS)) {
                    object2 = RubyElementImageProvider.getMethodImageDescriptor(n);
                } else if (string.equals(MembersOrderPreferencePage.STATIC_FIELDS)) {
                    object2 = RubyElementImageProvider.getFieldImageDescriptor();
                    object2 = new RubyElementImageDescriptor((ImageDescriptor)object2, 8, RubyElementImageProvider.SMALL_SIZE);
                } else if (string.equals(MembersOrderPreferencePage.STATIC_METHODS)) {
                    object2 = RubyElementImageProvider.getMethodImageDescriptor(n);
                    object2 = new RubyElementImageDescriptor((ImageDescriptor)object2, 8, RubyElementImageProvider.SMALL_SIZE);
                } else {
                    object2 = string.equals(MembersOrderPreferencePage.TYPES) ? RubyElementImageProvider.getTypeImageDescriptor(false, false, false) : RubyElementImageProvider.getMethodImageDescriptor(0);
                }
                return imageDescriptorRegistry.get(object2);
            }
            return null;
        }

        public String getText(Object object) {
            if (object instanceof String) {
                String string = (String)object;
                if (string.equals(MembersOrderPreferencePage.FIELDS)) {
                    return PreferencesMessages.MembersOrderPreferencePage_fields_label;
                }
                if (string.equals(MembersOrderPreferencePage.METHODS)) {
                    return PreferencesMessages.MembersOrderPreferencePage_methods_label;
                }
                if (string.equals(MembersOrderPreferencePage.STATIC_FIELDS)) {
                    return PreferencesMessages.MembersOrderPreferencePage_staticfields_label;
                }
                if (string.equals(MembersOrderPreferencePage.STATIC_METHODS)) {
                    return PreferencesMessages.MembersOrderPreferencePage_staticmethods_label;
                }
                if (string.equals(MembersOrderPreferencePage.CONSTRUCTORS)) {
                    return PreferencesMessages.MembersOrderPreferencePage_constructors_label;
                }
                if (string.equals(MembersOrderPreferencePage.TYPES)) {
                    return PreferencesMessages.MembersOrderPreferencePage_types_label;
                }
            }
            return "";
        }
    }

    private class VisibilitySortLabelProvider
    extends LabelProvider {
        public Image getImage(Object object) {
            ImageDescriptorRegistry imageDescriptorRegistry = RubyPlugin.getImageDescriptorRegistry();
            ImageDescriptor imageDescriptor = null;
            if (object instanceof String) {
                String string = (String)object;
                if (string.equals(MembersOrderPreferencePage.PUBLIC)) {
                    imageDescriptor = RubyElementImageProvider.getMethodImageDescriptor(0);
                } else if (string.equals(MembersOrderPreferencePage.PRIVATE)) {
                    imageDescriptor = RubyElementImageProvider.getMethodImageDescriptor(2);
                } else if (string.equals(MembersOrderPreferencePage.PROTECTED)) {
                    imageDescriptor = RubyElementImageProvider.getMethodImageDescriptor(1);
                }
                return imageDescriptorRegistry.get(imageDescriptor);
            }
            return null;
        }

        public String getText(Object object) {
            if (object instanceof String) {
                String string = (String)object;
                if (string.equals(MembersOrderPreferencePage.PUBLIC)) {
                    return PreferencesMessages.MembersOrderPreferencePage_public_label;
                }
                if (string.equals(MembersOrderPreferencePage.PRIVATE)) {
                    return PreferencesMessages.MembersOrderPreferencePage_private_label;
                }
                if (string.equals(MembersOrderPreferencePage.PROTECTED)) {
                    return PreferencesMessages.MembersOrderPreferencePage_protected_label;
                }
            }
            return "";
        }
    }
}

