/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.connection.internal.ui.filter;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.rdb.core.internal.ui.explorer.filter.IFilterNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManager;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentService;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

public class FilterUtil {
    private static final ContainmentService containment = RDBCorePlugin.getDefault().getContainmentService();
    private static final ConnectionManager manager = RDBCorePlugin.getDefault().getConnectionManager();

    private static Database getDatabase(SQLObject sqlObject) {
        while (sqlObject != null && !(sqlObject instanceof Database) && !((sqlObject = (SQLObject)containment.getContainer((EObject)sqlObject)) instanceof Database)) {
        }
        return sqlObject instanceof Database ? (Database)sqlObject : null;
    }

    private static SQLObject getFilterParent(Object parent) {
        while (parent != null && !(parent instanceof SQLObject) && !((parent = ((IVirtualNode)parent).getParent()) instanceof SQLObject)) {
        }
        return parent instanceof SQLObject ? (SQLObject)parent : null;
    }

    public static boolean hasFilter(IFilterNode filterNode) {
        Database database = FilterUtil.getDatabase(FilterUtil.getFilterParent(filterNode));
        ConnectionInfo connectionInfo = database != null ? manager.getConnectionInfo((SQLObject)database) : null;
        return connectionInfo != null && connectionInfo.getFilter(filterNode.getFilterName()) != null;
    }
}

