/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.actions;

import java.util.Iterator;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.xsd.ui.internal.adt.actions.BaseSelectionAction;
import org.eclipse.wst.xsd.ui.internal.adt.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IComplexType;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IField;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IModel;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IStructure;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;

public class DeleteAction
extends BaseSelectionAction {
    public static final String ID = "org.eclipse.wst.xsd.ui.internal.editor.DeleteAction";

    public DeleteAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages._UI_ACTION_DELETE);
        this.setId(ID);
        this.setImageDescriptor(XSDEditorPlugin.getImageDescriptor("icons/delete_obj.gif"));
    }

    public void run() {
        Iterator i = ((IStructuredSelection)this.getSelection()).iterator();
        while (i.hasNext()) {
            Object selection = i.next();
            Command command = null;
            boolean doReselect = false;
            IModel model = null;
            if (selection instanceof IComplexType) {
                command = ((IComplexType)selection).getDeleteCommand();
                model = ((IComplexType)selection).getModel();
                doReselect = true;
            } else if (selection instanceof IField) {
                model = ((IField)selection).getModel();
                if (((IField)selection).isGlobal()) {
                    doReselect = true;
                }
                command = ((IField)selection).getDeleteCommand();
            } else if (selection instanceof IStructure) {
                IStructure structure = (IStructure)selection;
                model = structure.getModel();
                command = structure.getDeleteCommand();
            }
            if (command == null) continue;
            command.execute();
            if (model == null || !doReselect) continue;
            this.provider.setSelection((ISelection)new StructuredSelection((Object)model));
        }
    }
}

