/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.IMonitoredServerPort;
import org.eclipse.wst.server.core.internal.ServerMonitorManager;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;

public class MonitorServerPortAction
extends Action {
    protected Shell shell;
    protected IServer server;
    protected ServerPort port;
    protected IMonitoredServerPort monitoredPort;
    protected boolean checked;

    public MonitorServerPortAction(Shell shell, IServer server, ServerPort port) {
        super(NLS.bind((String)Messages.actionMonitorPort, (Object[])new String[]{String.valueOf(port.getPort()), port.getName()}));
        this.shell = shell;
        this.server = server;
        this.port = port;
        IMonitoredServerPort[] msps = ServerMonitorManager.getInstance().getMonitoredPorts(server);
        if (msps != null) {
            int size = msps.length;
            int i = 0;
            while (i < size) {
                if (port.equals((Object)msps[i].getServerPort()) && (msps[i].getContentTypes() == null || msps[i].getContentTypes().length == 0 || port.getContentTypes() != null && msps[i].getContentTypes().length == port.getContentTypes().length)) {
                    this.monitoredPort = msps[i];
                }
                ++i;
            }
        }
        this.checked = this.monitoredPort != null;
        this.setChecked(this.checked);
    }

    public void run() {
        ServerMonitorManager smm = ServerMonitorManager.getInstance();
        if (this.checked) {
            smm.removeMonitor(this.monitoredPort);
        } else {
            if (this.monitoredPort == null) {
                this.monitoredPort = smm.createMonitor(this.server, this.port, -1, null);
            }
            try {
                smm.startMonitor(this.monitoredPort);
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Could not monitor", e);
            }
        }
    }
}

