/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.classpath;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorations;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorationsManager;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathContainer;

public class J2EEComponentClasspathInitializer
extends ClasspathContainerInitializer {
    private static final ClasspathDecorationsManager decorations = J2EEComponentClasspathContainer.getDecorationsManager();

    public void initialize(IPath containerPath, IJavaProject javaProject) throws CoreException {
        J2EEComponentClasspathContainer.install(containerPath, javaProject);
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject javaProject, IClasspathContainer sg) throws CoreException {
        String key = containerPath.toString();
        IClasspathEntry[] entries = sg.getClasspathEntries();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            IPath srcpath = entry.getSourceAttachmentPath();
            IPath srcrootpath = entry.getSourceAttachmentRootPath();
            IClasspathAttribute[] attrs = entry.getExtraAttributes();
            if (srcpath != null || attrs.length > 0) {
                String eid = entry.getPath().toString();
                ClasspathDecorations dec = new ClasspathDecorations();
                dec.setSourceAttachmentPath(srcpath);
                dec.setSourceAttachmentRootPath(srcrootpath);
                dec.setExtraAttributes(attrs);
                decorations.setDecorations(key, eid, dec);
            }
            ++i;
        }
        decorations.save();
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)javaProject);
        J2EEComponentClasspathInitializer.refresh(container);
    }

    private static void refresh(IClasspathContainer container) {
        if (container instanceof J2EEComponentClasspathContainer) {
            ((J2EEComponentClasspathContainer)container).refresh(true);
        } else {
            try {
                Field field = container.getClass().getDeclaredField("fOriginal");
                field.setAccessible(true);
                J2EEComponentClasspathInitializer.refresh((IClasspathContainer)field.get(container));
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

