/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpointGroups;

import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.BreakpointGroupMessages;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.BreakpointSelectionAction;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.debug.internal.ui.views.breakpoints.WorkingSetCategory;
import org.eclipse.jface.viewers.IStructuredSelection;

public class RemoveFromWorkingSetAction
extends BreakpointSelectionAction {
    public RemoveFromWorkingSetAction(BreakpointsView view) {
        super(BreakpointGroupMessages.RemoveFromWorkingSetAction_0, view);
    }

    public void run() {
        for (Object object : this.getStructuredSelection()) {
            if (!(object instanceof IBreakpoint)) continue;
            IBreakpoint breakpoint = (IBreakpoint)object;
            BreakpointContainer[] containers = this.getBreakpointsView().getMovedFromContainers(breakpoint);
            if (containers == null) continue;
            int i = 0;
            while (i < containers.length) {
                BreakpointContainer container = containers[i];
                container.getOrganizer().removeBreakpoint(breakpoint, container.getCategory());
                ++i;
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection.isEmpty() || !this.getBreakpointsView().isShowingGroups()) {
            return false;
        }
        for (Object object : selection) {
            if (object instanceof IBreakpoint) {
                IBreakpoint breakpoint = (IBreakpoint)object;
                BreakpointContainer[] containers = this.getBreakpointsView().getMovedFromContainers(breakpoint);
                if (containers == null || containers.length == 0) {
                    return false;
                }
                int i = 0;
                while (i < containers.length) {
                    BreakpointContainer container = containers[i];
                    if (container.getCategory() instanceof WorkingSetCategory) {
                        WorkingSetCategory category = (WorkingSetCategory)container.getCategory();
                        if (!"org.eclipse.debug.ui.breakpointWorkingSet".equals(category.getWorkingSet().getId())) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    ++i;
                }
                continue;
            }
            return false;
        }
        return true;
    }
}

