/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.ExternalHyperlink;
import org.eclipse.ant.internal.ui.launchConfigurations.AntStreamMonitor;
import org.eclipse.ant.internal.ui.launchConfigurations.AntStreamsProxy;
import org.eclipse.ant.internal.ui.launchConfigurations.TaskLinkManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.console.IHyperlink;

public class RemoteAntBuildListener
implements ILaunchesListener {
    private ServerSocket fServerSocket;
    private Socket fSocket;
    private BufferedReader fBufferedReader;
    private IProcess fProcess;
    private String fProcessId;
    private File fBuildFileParent = null;
    private List fMessageQueue;
    protected ILaunch fLaunch;
    private Map fFileNameToIFile = new HashMap();
    private String fLastFileName = null;
    private String fLastTaskName = null;
    private boolean fBuildFailed = false;

    public RemoteAntBuildListener(ILaunch launch) {
        this.fLaunch = launch;
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public synchronized void startListening(int eventPort) {
        ServerConnection connection = new ServerConnection(eventPort);
        connection.start();
    }

    protected synchronized void shutDown() {
        this.fLaunch = null;
        this.fFileNameToIFile = null;
        if (DebugPlugin.getDefault() != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        }
        try {
            if (this.fBufferedReader != null) {
                this.fBufferedReader.close();
                this.fBufferedReader = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.fSocket != null) {
                this.fSocket.close();
                this.fSocket = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.fServerSocket != null) {
                this.fServerSocket.close();
                this.fServerSocket = null;
            }
        }
        catch (IOException iOException) {}
    }

    protected void receiveMessage(String message) {
        if (message.startsWith("6")) {
            this.receiveTaskMessage(message);
        } else if (message.startsWith("7")) {
            this.receiveTargetMessage(message);
        } else if (message.startsWith("processID")) {
            this.fProcessId = message = message.substring("processID".length());
        } else {
            int index = message.indexOf(44);
            if (index > 0) {
                int priority = Integer.parseInt(message.substring(0, index));
                message = message.substring(index + 1);
                this.writeMessage(String.valueOf(message) + System.getProperty("line.separator"), priority);
                if (message.startsWith("BUILD FAILED")) {
                    this.fBuildFailed = true;
                } else if (this.fBuildFailed) {
                    if (message.startsWith("Total time:")) {
                        this.fBuildFailed = false;
                    } else {
                        AntUtil.linkBuildFailedMessage(message, this.getProcess());
                    }
                }
            }
        }
    }

    private void receiveTargetMessage(String message) {
        message = message.substring("7".length());
        StringTokenizer tokenizer = new StringTokenizer(message, ",");
        message = tokenizer.nextToken();
        if (tokenizer.hasMoreTokens()) {
            int locationLength = Integer.parseInt(tokenizer.nextToken());
            String location = tokenizer.nextToken();
            while (location.length() < locationLength) {
                location = String.valueOf(location) + ",";
                location = String.valueOf(location) + tokenizer.nextToken();
            }
            int lineNumber = Integer.parseInt(tokenizer.nextToken());
            this.generateLink(message, location, lineNumber, 0, message.length() - 1);
        }
        this.writeMessage(String.valueOf(message) + System.getProperty("line.separator"), 2);
    }

    private void receiveTaskMessage(String message) {
        message = message.substring("6".length());
        int index = message.indexOf(44);
        int priority = Integer.parseInt(message.substring(0, index));
        int index2 = message.indexOf(44, index + 1);
        String taskName = message.substring(index + 1, index2);
        if (taskName.length() == 0) {
            taskName = this.fLastTaskName;
        }
        int index3 = message.indexOf(44, index2 + 1);
        int lineLength = Integer.parseInt(message.substring(index2 + 1, index3));
        int index4 = index3 + 1 + lineLength;
        String line = message.substring(index3 + 1, index4);
        StringBuffer labelBuff = new StringBuffer();
        labelBuff.append('[');
        labelBuff.append(taskName);
        labelBuff.append("] ");
        labelBuff.append(line);
        line = labelBuff.toString();
        this.fLastTaskName = taskName;
        int locationIndex = message.indexOf(44, index4 + 1);
        int finalIndex = locationIndex + 1;
        String fileName = message.substring(index4 + 1, locationIndex);
        int locationLength = 0;
        if (fileName.length() == 0) {
            fileName = this.fLastFileName;
        } else {
            finalIndex = message.indexOf(44, locationIndex) + 1;
            locationLength = Integer.parseInt(fileName);
            fileName = message.substring(finalIndex, finalIndex + locationLength);
            ++locationLength;
        }
        this.fLastFileName = fileName;
        int lineNumber = Integer.parseInt(message.substring(finalIndex + locationLength));
        int size = 15 - (taskName.length() + 3);
        int offset = Math.max(size - 2, 1);
        int length = 15 - size - 3;
        if (fileName != null) {
            this.generateLink(line, fileName, lineNumber, offset, length);
        }
        StringBuffer fullMessage = new StringBuffer();
        this.adornMessage(taskName, line, fullMessage);
        this.writeMessage(fullMessage.append(System.getProperty("line.separator")).toString(), priority);
    }

    private void generateLink(String line, String fileName, int lineNumber, int offset, int length) {
        IHyperlink taskLink = null;
        if (lineNumber == -1) {
            taskLink = AntUtil.getLocationLink(fileName, this.fBuildFileParent);
        } else {
            IFile file = (IFile)this.fFileNameToIFile.get(fileName);
            if (file == null) {
                file = AntUtil.getFileForLocation(fileName, this.fBuildFileParent);
                if (file != null) {
                    this.fFileNameToIFile.put(fileName, file);
                    taskLink = new FileLink(file, null, -1, -1, lineNumber);
                } else {
                    File javaIOFile = FileUtils.newFileUtils().resolveFile(this.fBuildFileParent, fileName);
                    if (javaIOFile.exists()) {
                        taskLink = new ExternalHyperlink(javaIOFile, lineNumber);
                    }
                }
            } else {
                taskLink = new FileLink(file, null, -1, -1, lineNumber);
            }
        }
        if (taskLink != null) {
            TaskLinkManager.addTaskHyperlink(this.getProcess(), taskLink, (IRegion)new Region(offset, length), line);
        }
    }

    protected IProcess getProcess() {
        if (this.fProcess == null && this.fProcessId != null) {
            IProcess[] all = DebugPlugin.getDefault().getLaunchManager().getProcesses();
            int i = 0;
            while (i < all.length) {
                IProcess process = all[i];
                if (this.fProcessId.equals(process.getAttribute("org.eclipse.ant.core.ANT_PROCESS_ID"))) {
                    this.fProcess = process;
                    break;
                }
                ++i;
            }
        }
        return this.fProcess;
    }

    private AntStreamMonitor getMonitor(int priority) {
        IProcess process = this.getProcess();
        if (process == null) {
            return null;
        }
        AntStreamsProxy proxy = (AntStreamsProxy)process.getStreamsProxy();
        if (proxy == null) {
            return null;
        }
        AntStreamMonitor monitor = null;
        switch (priority) {
            case 2: {
                monitor = (AntStreamMonitor)proxy.getOutputStreamMonitor();
                break;
            }
            case 0: {
                monitor = (AntStreamMonitor)proxy.getErrorStreamMonitor();
                break;
            }
            case 4: {
                monitor = (AntStreamMonitor)proxy.getDebugStreamMonitor();
                break;
            }
            case 1: {
                monitor = (AntStreamMonitor)proxy.getWarningStreamMonitor();
                break;
            }
            case 3: {
                monitor = (AntStreamMonitor)proxy.getVerboseStreamMonitor();
            }
        }
        return monitor;
    }

    private void adornMessage(String taskName, String line, StringBuffer fullMessage) {
        if (taskName == null) {
            taskName = "null";
        }
        int size = 15 - (taskName.length() + 6);
        int i = 0;
        while (i < size) {
            fullMessage.append(' ');
            ++i;
        }
        fullMessage.append(line);
    }

    protected void writeMessage(String message, int priority) {
        AntStreamMonitor monitor = this.getMonitor(priority);
        if (monitor == null) {
            if (this.fMessageQueue == null) {
                this.fMessageQueue = new ArrayList();
            }
            this.fMessageQueue.add(message);
            return;
        }
        if (this.fMessageQueue != null) {
            for (String oldMessage : this.fMessageQueue) {
                monitor.append(oldMessage);
            }
            this.fMessageQueue = null;
        }
        monitor.append(message);
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (launch.equals(this.fLaunch)) {
                this.shutDown();
                return;
            }
            ++i;
        }
    }

    public abstract class ListenerSafeRunnable
    implements ISafeRunnable {
        public void handleException(Throwable exception) {
            AntUIPlugin.log(exception);
        }
    }

    private class ServerConnection
    extends Thread {
        private int fServerPort;

        public ServerConnection(int port) {
            super("Ant Build Server Connection");
            this.setDaemon(true);
            this.fServerPort = port;
        }

        public void run() {
            IOException exception = null;
            try {
                String message;
                RemoteAntBuildListener.this.fServerSocket = new ServerSocket(this.fServerPort);
                IPreferenceStore prefs = AntUIPlugin.getDefault().getPreferenceStore();
                int socketTimeout = prefs.getInt("timeout");
                RemoteAntBuildListener.this.fServerSocket.setSoTimeout(socketTimeout);
                RemoteAntBuildListener.this.fSocket = RemoteAntBuildListener.this.fServerSocket.accept();
                RemoteAntBuildListener.this.fBufferedReader = new BufferedReader(new InputStreamReader(RemoteAntBuildListener.this.fSocket.getInputStream()));
                while (RemoteAntBuildListener.this.fBufferedReader != null && (message = RemoteAntBuildListener.this.fBufferedReader.readLine()) != null) {
                    RemoteAntBuildListener.this.receiveMessage(message);
                }
            }
            catch (SocketException socketException) {
            }
            catch (SocketTimeoutException e) {
                exception = e;
            }
            catch (IOException e) {
                exception = e;
            }
            if (exception != null) {
                AntUIPlugin.log(exception);
            }
            RemoteAntBuildListener.this.shutDown();
        }
    }
}

