/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.Project;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModelMessages;
import org.eclipse.ant.internal.ui.model.AntModelProject;
import org.eclipse.ant.internal.ui.model.AntPropertyNode;
import org.eclipse.ant.internal.ui.model.IAntModel;
import org.eclipse.ant.internal.ui.model.LocationProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;

public class AntProjectNode
extends AntElementNode {
    protected AntModelProject fProject;
    protected IAntModel fModel;
    protected String fLabel;

    public AntProjectNode(AntModelProject project, IAntModel antModel) {
        super("project");
        this.fProject = project;
        this.fModel = antModel;
    }

    public String getLabel() {
        if (this.fLabel == null) {
            this.fLabel = this.fProject != null ? this.fProject.getName() : AntModelMessages.AntProjectNode_0;
            if (this.fLabel == null || this.fLabel.length() == 0) {
                this.fLabel = "project";
            }
        }
        return this.fLabel;
    }

    protected ImageDescriptor getBaseImageDescriptor() {
        return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antProject");
    }

    public Project getProject() {
        return this.fProject;
    }

    protected IAntModel getAntModel() {
        return this.fModel;
    }

    public void reset() {
        super.reset();
        this.fProject.reset();
        this.setProblemSeverity(-1);
        this.setProblemMessage(null);
        this.fOffset = -1;
        this.fLength = -1;
    }

    public String getDescription() {
        return this.fProject.getDescription();
    }

    public String getBuildFileName() {
        IFile file;
        LocationProvider locationProvider = this.getAntModel().getLocationProvider();
        if (locationProvider != null && (file = locationProvider.getFile()) != null) {
            return file.getFullPath().toOSString();
        }
        return null;
    }

    public String getDefaultTargetName() {
        return this.fProject.getDefaultTarget();
    }

    public void setCurrentConfiguringProperty(AntPropertyNode node) {
        AntModelProject project = (AntModelProject)this.getProject();
        project.setCurrentConfiguringProperty(node);
    }

    public AntProjectNode getProjectNode() {
        return this;
    }

    public boolean containsOccurrence(String identifier) {
        return identifier.equals(this.getDefaultTargetName());
    }

    public List computeIdentifierOffsets(String identifier) {
        String textToSearch = this.getAntModel().getText(this.getOffset(), this.getLength());
        if (textToSearch == null || textToSearch.length() == 0 || identifier.length() == 0) {
            return null;
        }
        ArrayList<Integer> results = new ArrayList<Integer>(1);
        identifier = new StringBuffer("\"").append(identifier).append('\"').toString();
        int defaultTargetNameOffset = textToSearch.indexOf("default");
        defaultTargetNameOffset = textToSearch.indexOf(identifier, defaultTargetNameOffset);
        results.add(new Integer(this.getOffset() + defaultTargetNameOffset + 1));
        return results;
    }

    public boolean isRegionPotentialReference(IRegion region) {
        if (!super.isRegionPotentialReference(region)) {
            return false;
        }
        String textToSearch = this.getAntModel().getText(this.getOffset(), this.getLength());
        if (textToSearch == null) {
            return false;
        }
        return this.checkReferenceRegion(region, textToSearch, "default");
    }
}

