#!/bin/sh
echo 'name: cmdargs
version: 0.9.5
id: cmdargs-0.9.5-9048103c87e21bd73f9e06503555af31

license: BSD3
copyright: Neil Mitchell 2009-2012
maintainer: Neil Mitchell <ndmitchell@gmail.com>
stability: Beta
homepage: http://community.haskell.org/~ndm/cmdargs/
package-url:
synopsis: Command line argument processing
description: This library provides an easy way to define command line parsers. Most users
             will want to use the "System.Console.CmdArgs.Implicit" module, whose
             documentation contains an example.
             .
             * "System.Console.CmdArgs.Explicit" provides a way to write command line
             parsers for both single mode programs (most programs) and multiple
             mode programs (e.g. darcs or cabal). Parsers are defined by constructing
             a data structure.
             .
             * "System.Console.CmdArgs.Implicit" provides a way to concisely define
             command line parsers, up to three times shorter than getopt. These parsers
             are translated into the Explicit data type.
             .
             * "System.Console.CmdArgs.GetOpt" provides a wrapper allowing compatiblity
             with existing getopt parsers, mapping to the Explicit data type.
             .
             For a general reference on what command line flags are commonly used,
             see <http://www.faqs.org/docs/artu/ch10s05.html>.
category: Console
author: Neil Mitchell <ndmitchell@gmail.com>
pkgpath: devel/hs-cmdargs
exposed: True
exposed-modules: System.Console.CmdArgs.Quote
                 System.Console.CmdArgs System.Console.CmdArgs.Annotate
                 System.Console.CmdArgs.Default System.Console.CmdArgs.Explicit
                 System.Console.CmdArgs.GetOpt System.Console.CmdArgs.Implicit
                 System.Console.CmdArgs.Text System.Console.CmdArgs.Helper
                 System.Console.CmdArgs.Verbosity
hidden-modules: Data.Generics.Any Data.Generics.Any.Prelude
                System.Console.CmdArgs.Explicit.Complete
                System.Console.CmdArgs.Explicit.ExpandArgsAt
                System.Console.CmdArgs.Explicit.Help
                System.Console.CmdArgs.Explicit.Process
                System.Console.CmdArgs.Explicit.SplitJoin
                System.Console.CmdArgs.Explicit.Type
                System.Console.CmdArgs.Implicit.Ann
                System.Console.CmdArgs.Implicit.Global
                System.Console.CmdArgs.Implicit.Local
                System.Console.CmdArgs.Implicit.Reader
                System.Console.CmdArgs.Implicit.Reform
                System.Console.CmdArgs.Implicit.Type
                System.Console.CmdArgs.Implicit.UI
trusted: False
import-dirs: /usr/local/lib/ghc/cmdargs-0.9.5
library-dirs: /usr/local/lib/ghc/cmdargs-0.9.5
hs-libraries: HScmdargs-0.9.5
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         filepath-1.3.0.1-edbc3d8247914b04f448e9261e7fe895
         process-1.1.0.2-a830d25f0e9fb9c610aa641b7f5b20f9
         template-haskell-2.8.0.0-ac0663b70333f59eeec24f3cf48cfb28
         transformers-0.3.0.0-948c0bbaafc952a144be4248ffa27cb1
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-cmdargs-0.9.5/html/cmdargs.haddock
haddock-html: /usr/local/share/doc/hs-cmdargs-0.9.5/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
