#!/bin/sh
echo 'name: semigroupoids
version: 3.0.3
id: semigroupoids-3.0.3-3f51386efb52c19d1b27985adc9dde05

license: BSD3
copyright: Copyright (C) 2011 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
stability: provisional
homepage: http://github.com/ekmett/semigroupoids
package-url:
synopsis: Haskell 98 semigroupoids: Category sans id
description: Provides a wide array of semigroupoids and operations for working with semigroupds.
             .
             A Semigroupoid is a Category without the requirement of identity arrows for every object in the category.
             .
             When working with comonads you often have the @\<*\>@ portion of an @Applicative@, but
             not the @pure@. This was captured in Uustalu and Vene'\''s \"Essence of Dataflow Programming\"
             in the form of the @ComonadZip@ class in the days before @Applicative@. Apply provides a weaker invariant, but for the comonads used for data flow programming (found in the streams package), this invariant is preserved. Applicative function composition forms a semigroupoid.
             .
             Similarly many structures are nearly a comonad, but not quite, for instance lists provide a reasonable '\''extend'\'' operation in the form of '\''tails'\'', but do not always contain a value.
             .
             .
             Ideally the following relationships would hold:
             .
             > Traversable <---- Foldable <--- Functor ------> Alt ---------> Plus           Semigroupoid
             >      |               |            |                              |                  |
             >      v               v            v                              v                  v
             > Traversable1 <--- Foldable1     Apply --------> Applicative -> Alternative      Category
             >                                   |               |              |                  |
             >                                   v               v              v                  v
             >                                 Bind ---------> Monad -------> MonadPlus          Arrow
             >
             .
             Apply, Bind, and Extend (not shown) give rise the Static, Kleisli and Cokleisli semigroupoids respectively.
             .
             This lets us remove many of the restrictions from various monad transformers
             as in many cases the binding operation or @\<*\>@ operation does not require them.
             .
             Finally, to work with these weaker structures it is beneficial to have containers
             that can provide stronger guarantees about their contents, so versions of '\''Traversable'\''
             and '\''Foldable'\'' that can be folded with just a '\''Semigroup'\'' are added.
category: Control, Comonads
author: Edward A. Kmett
pkgpath: devel/hs-semigroupoids
exposed: True
exposed-modules: Data.Functor.Alt Data.Functor.Apply
                 Data.Functor.Bind Data.Functor.Bind.Trans Data.Functor.Plus
                 Data.Functor.Extend Data.Semigroup.Foldable
                 Data.Semigroup.Traversable Data.Semigroupoid Data.Semigroupoid.Dual
                 Data.Semigroupoid.Static Data.Traversable.Instances
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/semigroupoids-3.0.3
library-dirs: /usr/local/lib/ghc/semigroupoids-3.0.3
hs-libraries: HSsemigroupoids-3.0.3
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         comonad-3.0.3-97c2b9aaa661ce271befc6b439457331
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         contravariant-0.2.0.2-e8d546716fa930b4966f18f08040d2fa
         semigroups-0.9.2-51d976447c6408479cabc66ac9867fc6
         transformers-0.3.0.0-948c0bbaafc952a144be4248ffa27cb1
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-semigroupoids-3.0.3/html/semigroupoids.haddock
haddock-html: /usr/local/share/doc/hs-semigroupoids-3.0.3/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
