/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import net.sourceforge.nanoxml.XMLElement;

class Node {
    private XMLElement xml;
    private Node next;
    private Node[] children;
    private List<String> attributeNames = null;

    Node(XMLElement xml) {
        this.xml = xml;
    }

    Node getFirstChild() {
        if (this.children == null) {
            this.getChildNodes();
        }
        if (this.children.length == 0) {
            return null;
        }
        return this.children[0];
    }

    Node getNextSibling() {
        return this.next;
    }

    void normalize() {
    }

    String getNodeValue() {
        return this.xml.getContent();
    }

    Node[] getChildNodes() {
        if (this.children == null) {
            ArrayList<Node> list = new ArrayList<Node>();
            Enumeration e = this.xml.enumerateChildren();
            while (e.hasMoreElements()) {
                list.add(new Node((XMLElement)e.nextElement()));
            }
            this.children = list.toArray(new Node[list.size()]);
            for (int i = 0; i < this.children.length - 1; ++i) {
                this.children[i].next = this.children[i + 1];
            }
        }
        return this.children;
    }

    List<String> getAttributeNames() {
        if (this.attributeNames == null) {
            this.attributeNames = new ArrayList<String>();
            Enumeration e = this.xml.enumerateAttributeNames();
            while (e.hasMoreElements()) {
                this.attributeNames.add(new String((String)e.nextElement()));
            }
        }
        return this.attributeNames;
    }

    String getAttribute(String name) {
        return (String)this.xml.getAttribute(name);
    }

    String getNodeName() {
        if (this.xml.getName() == null) {
            return "";
        }
        return this.xml.getName();
    }

    public String toString() {
        return this.getNodeName();
    }
}

