/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.Launcher;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.viewer.CertificateViewer;
import net.sourceforge.jnlp.services.ServiceUtil;

public final class Boot
implements PrivilegedAction<Void> {
    private static final String name = Boot.class.getPackage().getImplementationTitle();
    private static final String version = Boot.class.getPackage().getImplementationVersion();
    private static final String aboutMessage = "" + name + " " + version + "\n" + Translator.R("BLaunchAbout");
    private static final String miniLicense = "\n   netx - an open-source JNLP client.\n   Copyright (C) 2001-2003 Jon A. Maxwell (JAM)\n\n   // This library is free software; you can redistribute it and/or\n   modify it under the terms of the GNU Lesser General Public\n   License as published by the Free Software Foundation; either\n   version 2.1 of the License, or (at your option) any later version.\n\n   This library is distributed in the hope that it will be useful,\n   but WITHOUT ANY WARRANTY; without even the implied warranty of\n   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n   Lesser General Public License for more details.\n\n   You should have received a copy of the GNU Lesser General Public\n   License along with this library; if not, write to the Free Software\n   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n\n";
    private static final String helpMessage = "\nUsage:   " + Translator.R("BOUsage") + "\n" + "         " + Translator.R("BOUsage2") + "\n" + "\n" + "control-options:" + "\n" + "  -about                " + Translator.R("BOAbout") + "\n" + "  -viewer               " + Translator.R("BOViewer") + "\n" + "\n" + "run-options:" + "\n" + "  -arg arg              " + Translator.R("BOArg") + "\n" + "  -param name=value     " + Translator.R("BOParam") + "\n" + "  -property name=value  " + Translator.R("BOProperty") + "\n" + "  -update seconds       " + Translator.R("BOUpdate") + "\n" + "  -license              " + Translator.R("BOLicense") + "\n" + "  -verbose              " + Translator.R("BOVerbose") + "\n" + "  -nosecurity           " + Translator.R("BONosecurity") + "\n" + "  -noupdate             " + Translator.R("BONoupdate") + "\n" + "  -headless             " + Translator.R("BOHeadless") + "\n" + "  -strict               " + Translator.R("BOStrict") + "\n" + "  -Xnofork              " + Translator.R("BXnofork") + "\n" + "  -Xclearcache          " + Translator.R("BXclearcache") + "\n" + "  -Xignoreheaders       " + Translator.R("BXignoreheaders") + "\n" + "  -help                 " + Translator.R("BOHelp") + "\n";
    private static final String doubleArgs = "-basedir -jnlp -arg -param -property -update";
    private static String[] args;

    public static void main(String[] argsIn) {
        args = argsIn;
        if (null != Boot.getOption("-viewer")) {
            try {
                CertificateViewer.main(null);
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (null != Boot.getOption("-license")) {
            System.out.println(miniLicense);
            System.exit(0);
        }
        if (null != Boot.getOption("-help")) {
            System.out.println(helpMessage);
            System.exit(0);
        }
        if (null != Boot.getOption("-about")) {
            System.out.println(aboutMessage);
        }
        if (null != Boot.getOption("-verbose")) {
            JNLPRuntime.setDebug(true);
        }
        if (null != Boot.getOption("-update")) {
            int value = Integer.parseInt(Boot.getOption("-update"));
            JNLPRuntime.setDefaultUpdatePolicy(new UpdatePolicy((long)value * 1000L));
        }
        if (null != Boot.getOption("-headless")) {
            JNLPRuntime.setHeadless(true);
        }
        if (null != Boot.getOption("-noupdate")) {
            JNLPRuntime.setDefaultUpdatePolicy(UpdatePolicy.NEVER);
        }
        if (null != Boot.getOption("-Xnofork")) {
            JNLPRuntime.setForksAllowed(false);
        }
        if (null != Boot.getOption("-Xtrustall")) {
            JNLPRuntime.setTrustAll(true);
        }
        if (null != Boot.getOption("-Xignoreheaders")) {
            JNLPRuntime.setIgnoreHeaders(true);
        }
        JNLPRuntime.setInitialArgments(Arrays.asList(argsIn));
        AccessController.doPrivileged(new Boot());
    }

    @Override
    public Void run() {
        JNLPRuntime.setSecurityEnabled(null == Boot.getOption("-nosecurity"));
        JNLPRuntime.initialize(true);
        if (null != Boot.getOption("-Xclearcache")) {
            CacheUtil.clearCache();
            return null;
        }
        HashMap<String, String[]> extra = new HashMap<String, String[]>();
        extra.put("arguments", Boot.getOptions("-arg"));
        extra.put("parameters", Boot.getOptions("-param"));
        extra.put("properties", Boot.getOptions("-property"));
        boolean strict = null != Boot.getOption("-strict");
        ParserSettings settings = new ParserSettings(strict);
        try {
            Launcher launcher = new Launcher(false);
            launcher.setParserSettings(settings);
            launcher.setInformationToMerge(extra);
            launcher.launch(Boot.getFileLocation(), true);
        }
        catch (LaunchException ex) {
        }
        catch (Exception ex) {
            if (JNLPRuntime.isDebug()) {
                ex.printStackTrace();
            }
            Boot.fatalError(Translator.R("RUnexpected", ex.toString(), ex.getStackTrace()[0]));
        }
        return null;
    }

    private static void fatalError(String message) {
        System.err.println("netx: " + message);
        System.exit(1);
    }

    private static String getAboutFile() {
        ClassLoader cl = Boot.class.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try {
            String s = cl.getResource("net/sourceforge/jnlp/runtime/Boot.class").toString();
            s = s.substring(0, s.indexOf("!"));
            s = s.substring(s.indexOf(":") + 1);
            s = s.substring(s.indexOf(":") + 1);
            s = "file://" + s.replace("netx.jar", "about.jnlp");
            if (JNLPRuntime.isDebug()) {
                System.out.println("Using " + s + " as about.jnlp URL");
            }
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static URL getFileLocation() {
        URL url;
        block7: {
            String location = Boot.getJNLPFile();
            if (Boot.getOption("-about") != null) {
                location = Boot.getAboutFile();
                if (location == null) {
                    Boot.fatalError(Translator.R("RNoAboutJnlp"));
                }
            } else {
                location = Boot.getJNLPFile();
            }
            if (location == null) {
                System.out.println(helpMessage);
                System.exit(1);
            }
            if (JNLPRuntime.isDebug()) {
                System.out.println(Translator.R("BFileLoc") + ": " + location);
            }
            url = null;
            try {
                url = new File(location).exists() ? new File(location).toURL() : new URL(ServiceUtil.getBasicService().getCodeBase(), location);
            }
            catch (Exception e) {
                Boot.fatalError("Invalid jnlp file " + location);
                if (!JNLPRuntime.isDebug()) break block7;
                e.printStackTrace();
            }
        }
        return url;
    }

    private static String getJNLPFile() {
        if (args.length == 0) {
            System.out.println(helpMessage);
            System.exit(0);
        } else {
            if (args.length == 1) {
                return args[args.length - 1];
            }
            String lastArg = args[args.length - 1];
            String secondLastArg = args[args.length - 2];
            if (doubleArgs.indexOf(secondLastArg) == -1) {
                return lastArg;
            }
            System.out.println(helpMessage);
            System.exit(0);
        }
        return null;
    }

    private static String getOption(String option) {
        String[] result = Boot.getOptions(option);
        if (result.length == 0) {
            return null;
        }
        return result[0];
    }

    private static String[] getOptions(String option) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (option.equals(args[i])) {
                if (-1 == doubleArgs.indexOf(option)) {
                    result.add(option);
                } else if (i + 1 < args.length) {
                    result.add(args[i + 1]);
                }
            }
            if (!args[i].startsWith("-") || -1 == doubleArgs.indexOf(args[i])) continue;
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }
}

