/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.X509Certificate;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyObjectAdapter;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.SSL;
import org.jruby.ext.openssl.SSLContext;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class SSLSocket
extends RubyObject {
    private static final long serialVersionUID = -2276327900350542644L;
    private static ObjectAllocator SSLSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new SSLSocket(runtime, klass);
        }
    };
    private static RubyObjectAdapter api = JavaEmbedUtils.newObjectAdapter();
    private SSLContext rubyCtx;
    private SSLEngine engine;
    private RubyIO io = null;
    private ByteBuffer peerAppData;
    private ByteBuffer peerNetData;
    private ByteBuffer netData;
    private ByteBuffer dummy;
    private boolean initialHandshake = false;
    private SSLEngineResult.HandshakeStatus hsStatus;
    private SSLEngineResult.Status status = null;
    int verifyResult = 0;

    public static void createSSLSocket(Ruby runtime, RubyModule mSSL) {
        RubyClass cSSLSocket = mSSL.defineClassUnder("SSLSocket", runtime.getObject(), SSLSOCKET_ALLOCATOR);
        cSSLSocket.addReadWriteAttribute(runtime.getCurrentContext(), "io");
        cSSLSocket.addReadWriteAttribute(runtime.getCurrentContext(), "context");
        cSSLSocket.addReadWriteAttribute(runtime.getCurrentContext(), "sync_close");
        cSSLSocket.addReadWriteAttribute(runtime.getCurrentContext(), "hostname");
        cSSLSocket.defineAlias("to_io", "io");
        cSSLSocket.defineAnnotatedMethods(SSLSocket.class);
    }

    public SSLSocket(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public static RaiseException newSSLError(Ruby runtime, String message) {
        return Utils.newError(runtime, "OpenSSL::SSL::SSLError", message, false);
    }

    public static RaiseException newSSLErrorReadable(Ruby runtime, String message) {
        return Utils.newError(runtime, "OpenSSL::SSL::SSLErrorWaitReadable", message, false);
    }

    public static RaiseException newSSLErrorWritable(Ruby runtime, String message) {
        return Utils.newError(runtime, "OpenSSL::SSL::SSLErrorWaitWritable", message, false);
    }

    @JRubyMethod(name={"initialize"}, rest=true, frame=true)
    public IRubyObject _initialize(IRubyObject[] args, Block unused) {
        if (Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)1, (int)2) == 1) {
            RubyClass sslContext = Utils.getClassFromPath(this.getRuntime(), "OpenSSL::SSL::SSLContext");
            this.rubyCtx = (SSLContext)api.callMethod((IRubyObject)sslContext, "new");
        } else {
            this.rubyCtx = (SSLContext)args[1];
        }
        Utils.checkKind(this.getRuntime(), args[0], "IO");
        this.io = (RubyIO)args[0];
        api.callMethod((IRubyObject)this, "io=", (IRubyObject)this.io);
        api.callMethod((IRubyObject)this, "hostname=", (IRubyObject)this.getRuntime().newString(""));
        api.callMethod((IRubyObject)this.io, "sync=", (IRubyObject)this.getRuntime().getTrue());
        api.callMethod((IRubyObject)this, "context=", (IRubyObject)this.rubyCtx);
        api.callMethod((IRubyObject)this, "sync_close=", (IRubyObject)this.getRuntime().getFalse());
        this.rubyCtx.setup();
        return api.callSuper((IRubyObject)this, args);
    }

    private void ossl_ssl_setup() throws NoSuchAlgorithmException, KeyManagementException, IOException {
        if (null == this.engine) {
            Socket socket = this.getSocketChannel().socket();
            String peerHost = api.callMethod((IRubyObject)this, "hostname").convertToString().toString();
            int peerPort = socket.getPort();
            this.engine = this.rubyCtx.createSSLEngine(peerHost, peerPort);
            SSLSession session = this.engine.getSession();
            this.peerNetData = ByteBuffer.allocate(session.getPacketBufferSize());
            this.peerAppData = ByteBuffer.allocate(session.getApplicationBufferSize());
            this.netData = ByteBuffer.allocate(session.getPacketBufferSize());
            this.peerNetData.limit(0);
            this.peerAppData.limit(0);
            this.netData.limit(0);
            this.dummy = ByteBuffer.allocate(0);
        }
    }

    @JRubyMethod
    public IRubyObject connect(ThreadContext context) {
        return this.connectCommon(context, true);
    }

    @JRubyMethod
    public IRubyObject connect_nonblock(ThreadContext context) {
        return this.connectCommon(context, false);
    }

    private IRubyObject connectCommon(ThreadContext context, boolean blocking) {
        Ruby runtime = context.runtime;
        if (!this.rubyCtx.isProtocolForClient()) {
            throw SSLSocket.newSSLError(runtime, "called a function you should not call");
        }
        try {
            if (!this.initialHandshake) {
                this.ossl_ssl_setup();
                this.engine.setUseClientMode(true);
                this.engine.beginHandshake();
                this.hsStatus = this.engine.getHandshakeStatus();
                this.initialHandshake = true;
            }
            this.doHandshake(blocking);
        }
        catch (SSLHandshakeException e) {
            this.forceClose();
            Throwable v = e;
            while (v.getCause() != null && v instanceof SSLHandshakeException) {
                v = v.getCause();
            }
            throw SSL.newSSLError(runtime, v);
        }
        catch (NoSuchAlgorithmException ex) {
            this.forceClose();
            throw SSL.newSSLError(runtime, ex);
        }
        catch (KeyManagementException ex) {
            this.forceClose();
            throw SSL.newSSLError(runtime, ex);
        }
        catch (IOException ex) {
            this.forceClose();
            throw SSL.newSSLError(runtime, ex);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject accept(ThreadContext context) {
        return this.acceptCommon(context, true);
    }

    @JRubyMethod
    public IRubyObject accept_nonblock(ThreadContext context) {
        return this.acceptCommon(context, false);
    }

    public IRubyObject acceptCommon(ThreadContext context, boolean blocking) {
        Ruby runtime = context.runtime;
        if (!this.rubyCtx.isProtocolForServer()) {
            throw SSLSocket.newSSLError(runtime, "called a function you should not call");
        }
        try {
            int vfy = 0;
            if (!this.initialHandshake) {
                this.ossl_ssl_setup();
                this.engine.setUseClientMode(false);
                if (!this.rubyCtx.isNil() && !this.rubyCtx.callMethod(context, "verify_mode").isNil()) {
                    vfy = RubyNumeric.fix2int((IRubyObject)this.rubyCtx.callMethod(context, "verify_mode"));
                    if (vfy == 0) {
                        this.engine.setNeedClientAuth(false);
                        this.engine.setWantClientAuth(false);
                    }
                    if ((vfy & 1) != 0) {
                        this.engine.setWantClientAuth(true);
                    }
                    if ((vfy & 2) != 0) {
                        this.engine.setNeedClientAuth(true);
                    }
                }
                this.engine.beginHandshake();
                this.hsStatus = this.engine.getHandshakeStatus();
                this.initialHandshake = true;
            }
            this.doHandshake(blocking);
        }
        catch (SSLHandshakeException e) {
            throw SSL.newSSLError(runtime, e);
        }
        catch (NoSuchAlgorithmException ex) {
            throw SSL.newSSLError(runtime, ex);
        }
        catch (KeyManagementException ex) {
            throw SSL.newSSLError(runtime, ex);
        }
        catch (IOException ex) {
            throw SSL.newSSLError(runtime, ex);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject verify_result() {
        if (this.engine == null) {
            this.getRuntime().getWarnings().warn("SSL session is not started yet.");
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.verifyResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitSelect(final int operations, final boolean blocking) throws IOException {
        if (!(this.io.getChannel() instanceof SelectableChannel)) {
            return true;
        }
        final Ruby runtime = this.getRuntime();
        RubyThread thread = runtime.getCurrentContext().getThread();
        SelectableChannel selectable = (SelectableChannel)this.io.getChannel();
        selectable.configureBlocking(false);
        final Selector selector = runtime.getSelectorPool().get();
        final SelectionKey key = selectable.register(selector, operations);
        try {
            Set<SelectionKey> keySet;
            this.io.addBlockingThread(thread);
            final int[] result = new int[1];
            thread.executeBlockingTask(new RubyThread.BlockingTask(){

                public void run() throws InterruptedException {
                    try {
                        if (!blocking) {
                            result[0] = selector.selectNow();
                            if (result[0] == 0) {
                                if ((operations & 1) != 0 && (operations & 4) != 0) {
                                    if (key.isReadable()) {
                                        SSLSocket.this.writeWouldBlock();
                                    } else if (key.isWritable()) {
                                        SSLSocket.this.readWouldBlock();
                                    } else {
                                        SSLSocket.this.readWouldBlock();
                                    }
                                } else if ((operations & 1) != 0) {
                                    SSLSocket.this.readWouldBlock();
                                } else if ((operations & 4) != 0) {
                                    SSLSocket.this.writeWouldBlock();
                                }
                            }
                        } else {
                            result[0] = selector.select();
                        }
                    }
                    catch (IOException ioe) {
                        throw runtime.newRuntimeError("Error with selector: " + ioe.getMessage());
                    }
                }

                public void wakeup() {
                    selector.wakeup();
                }
            });
            if (result[0] >= 1 && (keySet = selector.selectedKeys()).iterator().next() == key) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (key != null) {
                    key.cancel();
                }
                if (selector != null) {
                    selector.selectNow();
                }
            }
            catch (Exception e) {}
            try {
                if (selector != null) {
                    runtime.getSelectorPool().put(selector);
                }
            }
            catch (Exception e) {}
            this.io.removeBlockingThread(thread);
            thread.afterBlockingCall();
        }
    }

    private void readWouldBlock() {
        Ruby runtime = this.getRuntime();
        throw SSLSocket.newSSLErrorReadable(runtime, "read would block");
    }

    private void writeWouldBlock() {
        Ruby runtime = this.getRuntime();
        throw SSLSocket.newSSLErrorWritable(runtime, "write would block");
    }

    private void doHandshake(boolean blocking) throws IOException {
        block7: while (true) {
            boolean ready = this.waitSelect(5, blocking);
            if (!blocking && !ready) {
                Ruby runtime = this.getRuntime();
                throw runtime.newErrnoEAGAINError("Resource temporarily unavailable");
            }
            switch (this.hsStatus) {
                case FINISHED: {
                    if (this.initialHandshake) {
                        this.finishInitialHandshake();
                    }
                    return;
                }
                case NEED_TASK: {
                    this.doTasks();
                    continue block7;
                }
                case NEED_UNWRAP: {
                    if (this.readAndUnwrap(blocking) == -1 && this.hsStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
                        throw new SSLHandshakeException("Socket closed");
                    }
                    if (!this.initialHandshake || this.status != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue block7;
                    this.waitSelect(1, blocking);
                    continue block7;
                }
                case NEED_WRAP: {
                    if (this.netData.hasRemaining()) {
                        while (this.flushData(blocking)) {
                        }
                    }
                    this.netData.clear();
                    SSLEngineResult res = this.engine.wrap(this.dummy, this.netData);
                    this.hsStatus = res.getHandshakeStatus();
                    this.netData.flip();
                    this.flushData(blocking);
                    continue block7;
                }
                case NOT_HANDSHAKING: {
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException("Unknown handshaking status: " + (Object)((Object)this.hsStatus));
    }

    private void doTasks() {
        Runnable task;
        while ((task = this.engine.getDelegatedTask()) != null) {
            task.run();
        }
        this.hsStatus = this.engine.getHandshakeStatus();
        this.verifyResult = this.rubyCtx.getLastVerifyResult();
    }

    private boolean flushData(boolean blocking) throws IOException {
        try {
            this.writeToChannel(this.netData, blocking);
        }
        catch (IOException ioe) {
            this.netData.position(this.netData.limit());
            throw ioe;
        }
        return this.netData.hasRemaining();
    }

    private int writeToChannel(ByteBuffer buffer, boolean blocking) throws IOException {
        int totalWritten = 0;
        while (buffer.hasRemaining()) {
            totalWritten += this.getSocketChannel().write(buffer);
            if (blocking) continue;
            break;
        }
        return totalWritten;
    }

    private void finishInitialHandshake() {
        this.initialHandshake = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src, boolean blocking) throws SSLException, IOException {
        if (this.initialHandshake) {
            throw new IOException("Writing not possible during handshake");
        }
        SocketChannel selectable = this.getSocketChannel();
        boolean blockingMode = ((SelectableChannel)selectable).isBlocking();
        if (!blocking) {
            ((SelectableChannel)selectable).configureBlocking(false);
        }
        try {
            if (this.netData.hasRemaining()) {
                this.flushData(blocking);
            }
            this.netData.clear();
            SSLEngineResult res = this.engine.wrap(src, this.netData);
            this.netData.flip();
            this.flushData(blocking);
            int n = res.bytesConsumed();
            return n;
        }
        finally {
            if (!blocking) {
                ((SelectableChannel)selectable).configureBlocking(blockingMode);
            }
        }
    }

    public int read(ByteBuffer dst, boolean blocking) throws IOException {
        int appBytesProduced;
        if (this.initialHandshake) {
            return 0;
        }
        if (this.engine.isInboundDone()) {
            return -1;
        }
        if (!(this.peerAppData.hasRemaining() || (appBytesProduced = this.readAndUnwrap(blocking)) != -1 && appBytesProduced != 0)) {
            return appBytesProduced;
        }
        int limit = Math.min(this.peerAppData.remaining(), dst.remaining());
        this.peerAppData.get(dst.array(), dst.arrayOffset(), limit);
        dst.position(dst.arrayOffset() + limit);
        return limit;
    }

    private int readAndUnwrap(boolean blocking) throws IOException {
        SSLEngineResult res;
        int bytesRead = this.getSocketChannel().read(this.peerNetData);
        if (!(bytesRead != -1 || this.peerNetData.hasRemaining() && this.status != SSLEngineResult.Status.BUFFER_UNDERFLOW)) {
            this.closeInbound();
            return -1;
        }
        this.peerAppData.clear();
        this.peerNetData.flip();
        while ((res = this.engine.unwrap(this.peerNetData, this.peerAppData)).getStatus() == SSLEngineResult.Status.OK && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && res.bytesProduced() == 0) {
        }
        if (res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.finishInitialHandshake();
        }
        if (this.peerAppData.position() == 0 && res.getStatus() == SSLEngineResult.Status.OK && this.peerNetData.hasRemaining()) {
            res = this.engine.unwrap(this.peerNetData, this.peerAppData);
        }
        this.status = res.getStatus();
        this.hsStatus = res.getHandshakeStatus();
        if (bytesRead == -1 && !this.peerNetData.hasRemaining()) {
            this.closeInbound();
        }
        if (this.status == SSLEngineResult.Status.CLOSED) {
            this.doShutdown();
            return -1;
        }
        this.peerNetData.compact();
        this.peerAppData.flip();
        if (!(this.initialHandshake || this.hsStatus != SSLEngineResult.HandshakeStatus.NEED_TASK && this.hsStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP && this.hsStatus != SSLEngineResult.HandshakeStatus.FINISHED)) {
            this.doHandshake(blocking);
        }
        return this.peerAppData.remaining();
    }

    private void closeInbound() {
        try {
            this.engine.closeInbound();
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
    }

    private void doShutdown() throws IOException {
        if (this.engine.isOutboundDone()) {
            return;
        }
        this.netData.clear();
        try {
            this.engine.wrap(this.dummy, this.netData);
        }
        catch (Exception e1) {
            return;
        }
        this.netData.flip();
        this.flushData(true);
    }

    private IRubyObject do_sysread(ThreadContext context, IRubyObject[] args, boolean blocking) {
        Ruby runtime = context.runtime;
        int len = RubyNumeric.fix2int((IRubyObject)args[0]);
        RubyString str = null;
        str = args.length == 2 && !args[1].isNil() ? args[1].convertToString() : this.getRuntime().newString("");
        if (len == 0) {
            str.clear();
            return str;
        }
        if (len < 0) {
            throw runtime.newArgumentError("negative string size (or size too big)");
        }
        try {
            if (this.engine == null || !this.peerAppData.hasRemaining() && this.peerNetData.position() <= 0) {
                this.waitSelect(1, blocking);
            }
            ByteBuffer dst = ByteBuffer.allocate(len);
            int rr = -1;
            while (rr <= 0) {
                rr = this.engine == null ? this.getSocketChannel().read(dst) : this.read(dst, blocking);
                if (rr != -1) continue;
                throw this.getRuntime().newEOFError();
            }
            byte[] bss = new byte[rr];
            dst.position(dst.position() - rr);
            dst.get(bss);
            str.setValue(new ByteList(bss));
            return str;
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOError(ioe.getMessage());
        }
    }

    @JRubyMethod(rest=true, required=1, optional=1)
    public IRubyObject sysread(ThreadContext context, IRubyObject[] args) {
        return this.do_sysread(context, args, true);
    }

    @JRubyMethod(rest=true, required=1, optional=1)
    public IRubyObject sysread_nonblock(ThreadContext context, IRubyObject[] args) {
        return this.do_sysread(context, args, false);
    }

    private IRubyObject do_syswrite(ThreadContext context, IRubyObject arg, boolean blocking) {
        Ruby runtime = context.runtime;
        try {
            this.checkClosed();
            this.waitSelect(4, blocking);
            ByteList bls = arg.convertToString().getByteList();
            ByteBuffer b1 = ByteBuffer.wrap(bls.getUnsafeBytes(), bls.getBegin(), bls.getRealSize());
            int written = this.engine == null ? this.writeToChannel(b1, blocking) : this.write(b1, blocking);
            ((RubyIO)api.callMethod((IRubyObject)this, "io")).flush();
            return this.getRuntime().newFixnum(written);
        }
        catch (IOException ioe) {
            throw runtime.newIOError(ioe.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject syswrite(ThreadContext context, IRubyObject arg) {
        return this.do_syswrite(context, arg, true);
    }

    @JRubyMethod
    public IRubyObject syswrite_nonblock(ThreadContext context, IRubyObject arg) {
        return this.do_syswrite(context, arg, false);
    }

    private void checkClosed() {
        if (!this.getSocketChannel().isOpen()) {
            throw this.getRuntime().newIOError("closed stream");
        }
    }

    private void forceClose() {
        this.close(true);
    }

    private void close(boolean force) {
        if (this.engine == null) {
            throw this.getRuntime().newEOFError();
        }
        this.engine.closeOutbound();
        if (!force && this.netData.hasRemaining()) {
            return;
        }
        try {
            this.doShutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @JRubyMethod
    public IRubyObject sysclose() {
        this.close(this.rubyCtx.isProtocolForClient());
        ThreadContext tc = this.getRuntime().getCurrentContext();
        if (this.callMethod(tc, "sync_close").isTrue()) {
            this.callMethod(tc, "io").callMethod(tc, "close");
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject cert() {
        if (this.engine == null) {
            return this.getRuntime().getNil();
        }
        try {
            Certificate[] cert2 = this.engine.getSession().getLocalCertificates();
            if (cert2 != null && cert2.length > 0) {
                return X509Cert.wrap(this.getRuntime(), cert2[0]);
            }
        }
        catch (java.security.cert.CertificateEncodingException ex) {
            throw X509Cert.newCertificateError(this.getRuntime(), ex);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject peer_cert() {
        block5: {
            if (this.engine == null) {
                return this.getRuntime().getNil();
            }
            try {
                Certificate[] cert2 = this.engine.getSession().getPeerCertificates();
                if (cert2.length > 0) {
                    return X509Cert.wrap(this.getRuntime(), cert2[0]);
                }
            }
            catch (java.security.cert.CertificateEncodingException ex) {
                throw X509Cert.newCertificateError(this.getRuntime(), ex);
            }
            catch (SSLPeerUnverifiedException ex) {
                if (!this.getRuntime().isVerbose()) break block5;
                this.getRuntime().getWarnings().warning(String.format("%s: %s", ex.getClass().getName(), ex.getMessage()));
            }
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject peer_cert_chain() {
        if (this.engine == null) {
            return this.getRuntime().getNil();
        }
        try {
            X509Certificate[] certs = this.engine.getSession().getPeerCertificateChain();
            RubyArray arr = this.getRuntime().newArray(certs.length);
            for (int i2 = 0; i2 < certs.length; ++i2) {
                arr.add((Object)X509Cert.wrap(this.getRuntime(), certs[i2]));
            }
            return arr;
        }
        catch (CertificateEncodingException e) {
            throw X509Cert.newCertificateError(this.getRuntime(), e);
        }
        catch (SSLPeerUnverifiedException ex) {
            if (this.getRuntime().isVerbose()) {
                this.getRuntime().getWarnings().warning(String.format("%s: %s", ex.getClass().getName(), ex.getMessage()));
            }
            return this.getRuntime().getNil();
        }
    }

    @JRubyMethod
    public IRubyObject cipher() {
        return this.getRuntime().newString(this.engine.getSession().getCipherSuite());
    }

    @JRubyMethod
    public IRubyObject state() {
        System.err.println("WARNING: unimplemented method called: SSLSocket#state");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject pending() {
        System.err.println("WARNING: unimplemented method called: SSLSocket#pending");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject session_reused_p() {
        throw new UnsupportedOperationException();
    }

    @JRubyMethod
    public synchronized IRubyObject session_set(IRubyObject aSession) {
        throw new UnsupportedOperationException();
    }

    private SocketChannel getSocketChannel() {
        return (SocketChannel)this.io.getChannel();
    }
}

