/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.java;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptDescriptor {
    private String m_name;
    private String m_methodName;
    private String m_className;
    private List<String> m_classpath;
    private ArrayList<Class<?>> m_argumentTypes = new ArrayList(11);

    public ScriptDescriptor(String string) throws IllegalArgumentException {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw new IllegalArgumentException("Invalid method name");
        }
        this.m_name = string;
        this.m_methodName = string.substring(n + 1);
        this.m_className = string.substring(0, n);
    }

    public String getName() {
        return this.m_name;
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getMethodName() {
        return this.m_methodName;
    }

    public void setClasspath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreElements()) {
            this.m_classpath.add((String)stringTokenizer.nextElement());
        }
    }

    public void setClasspath(List<String> list) {
        this.m_classpath = list;
    }

    public List<String> getClasspath() {
        return this.m_classpath;
    }

    public synchronized void addArgumentType(Class<?> clazz) {
        this.m_argumentTypes.add(clazz);
    }

    public synchronized void addArgumentTypes(Class<?>[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            this.addArgumentType(classArray[i]);
        }
    }

    public synchronized Class<?>[] getArgumentTypes() {
        if (this.m_argumentTypes.size() > 0) {
            return this.m_argumentTypes.toArray(new Class[this.m_argumentTypes.size()]);
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.m_name);
        Class<?>[] classArray = this.getArgumentTypes();
        stringBuffer.append(" (");
        if (classArray != null) {
            for (int i = 0; i < classArray.length - 1; ++i) {
                stringBuffer.append(classArray[i].getName());
                stringBuffer.append(", ");
            }
            stringBuffer.append(classArray[classArray.length - 1].getName());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

