/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.agenda;

import com.sun.star.awt.TextEvent;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNamed;
import com.sun.star.document.XDocumentProperties;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.Locale;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.table.XCell;
import com.sun.star.table.XTableRows;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextSection;
import com.sun.star.text.XTextSectionsSupplier;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTableCursor;
import com.sun.star.text.XTextTablesSupplier;
import com.sun.star.uno.Any;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.Date;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.util.XNumberFormatter;
import com.sun.star.util.XSearchDescriptor;
import com.sun.star.util.XSearchable;
import com.sun.star.wizards.agenda.AgendaElement;
import com.sun.star.wizards.agenda.AgendaItem;
import com.sun.star.wizards.agenda.AgendaWizardDialogResources;
import com.sun.star.wizards.agenda.CGAgenda;
import com.sun.star.wizards.agenda.PlaceholderElement;
import com.sun.star.wizards.agenda.PlaceholderTextElement;
import com.sun.star.wizards.agenda.TableCellFormatter;
import com.sun.star.wizards.agenda.TemplateConsts;
import com.sun.star.wizards.agenda.TextElement;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.document.OfficeDocument;
import com.sun.star.wizards.text.TextDocument;
import com.sun.star.wizards.text.TextSectionHandler;
import com.sun.star.wizards.ui.UnoDialog2;
import com.sun.star.wizards.ui.event.DataAware;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgendaTemplate
extends TextDocument
implements TemplateConsts,
DataAware.Listener {
    AgendaWizardDialogResources resources;
    CGAgenda agenda;
    Object document;
    XMultiServiceFactory docMSF;
    String template;
    TextSectionHandler textSectionHandler;
    XComponentLoader xComponentLoader;
    ItemsTable[] itemsTables;
    Topics topics;
    Map<String, AgendaItem> itemsCache;
    Map<String, ItemsTable> itemsMap = new HashMap<String, ItemsTable>(11);
    List<XTextRange> _allItems = new ArrayList<XTextRange>();
    List<XTextRange> constItems = new ArrayList<XTextRange>();
    TextElement teTitle;
    TextElement teDate;
    TextElement teTime;
    TextElement teLocation;
    XTextRange trTitle;
    XTextRange trDate;
    XTextRange trTime;
    XTextRange trLocation;
    TextElement teDateTitle;
    TextElement teTimeTitle;
    TextElement teLocationTitle;
    TextElement teTopics;
    TextElement teNum;
    TextElement teTopicHeader;
    TextElement teResponsibleHeader;
    TextElement teTimeHeader;
    TextElement teAdditionalInformation;
    TextElement teMinutesFor;
    TextElement teDiscussion;
    TextElement teConclusion;
    TextElement teToDo;
    TextElement teResponsibleParty;
    TextElement teDeadline;
    XTextRange trDateTitle;
    XTextRange trTimeTitle;
    XTextRange trLocationTitle;
    XTextRange trTopics;
    XTextRange trNum;
    XTextRange trTopicHeader;
    XTextRange trResponsibleHeader;
    XTextRange trTimeHeader;
    XTextRange trAdditionalInformation;
    XTextRange trMinutesFor;
    XTextRange trDiscussion;
    XTextRange trConclusion;
    XTextRange trToDo;
    XTextRange trResponsibleParty;
    XTextRange trDeadline;
    List<TextElement> teTopicList = new ArrayList<TextElement>();
    List<TextElement> teResponsibleList = new ArrayList<TextElement>();
    List<TextElement> teTimeList = new ArrayList<TextElement>();
    List<XTextRange> trTopicList = new ArrayList<XTextRange>();
    List<XTextRange> trResponsibleList = new ArrayList<XTextRange>();
    List<XTextRange> trTimeList = new ArrayList<XTextRange>();
    int dateFormat;
    int timeFormat;
    XNumberFormatter dateFormatter;
    XNumberFormatter timeFormatter;
    long docNullTime;
    Calendar calendar;
    private XDocumentProperties m_xDocProps;
    private static long DAY_IN_MILLIS = 86400000L;

    public void clearConstants() {
        this.teDateTitle = null;
        this.teTimeTitle = null;
        this.teLocationTitle = null;
        this.teTopics = null;
        this.teNum = null;
        this.teAdditionalInformation = null;
        this.teMinutesFor = null;
        this.teDiscussion = null;
        this.teConclusion = null;
        this.teToDo = null;
        this.teResponsibleParty = null;
        this.teDeadline = null;
        this.trDateTitle = null;
        this.trTimeTitle = null;
        this.trLocationTitle = null;
        this.trTopics = null;
        this.trNum = null;
        this.trAdditionalInformation = null;
        this.trMinutesFor = null;
        this.trDiscussion = null;
        this.trConclusion = null;
        this.trToDo = null;
        this.trResponsibleParty = null;
        this.trDeadline = null;
    }

    public void clearTopicConstants() {
        this.teTopicList.clear();
        this.teResponsibleList.clear();
        this.teTimeList.clear();
        this.trTopicList.clear();
        this.trResponsibleList.clear();
        this.trTimeList.clear();
    }

    public synchronized void load(String string, List<PropertyValue[]> list) {
        this.template = this.calcTemplateName(string);
        this.document = this.loadAsPreview(string, false);
        this.docMSF = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.document);
        this.xFrame.getComponentWindow().setEnable(false);
        this.xTextDocument.lockControllers();
        this.initialize();
        this.initializeData(list);
        this.xTextDocument.unlockControllers();
    }

    private String calcTemplateName(String string) {
        return FileAccess.connectURLs(FileAccess.getParentDir(string), FileAccess.getFilename(string).substring(3));
    }

    private void initializeData(List<PropertyValue[]> list) {
        for (int i = 0; i < this.itemsTables.length - 1; ++i) {
            try {
                this.itemsTables[i].write(PropertyNames.EMPTY_STRING);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.redrawTitle("txtTitle");
        this.redrawTitle("txtDate");
        this.redrawTitle("txtTime");
        this.redrawTitle("cbLocation");
        this.topics.writeAll(list);
        this.setTemplateTitle(this.agenda.cp_TemplateName);
    }

    public synchronized void redraw(String string) {
        try {
            ItemsTable itemsTable = this.itemsMap.get(string);
            itemsTable.write(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    synchronized void setTemplateTitle(String string) {
        this.m_xDocProps.setTitle(string);
    }

    AgendaTemplate(XMultiServiceFactory xMultiServiceFactory, CGAgenda cGAgenda, AgendaWizardDialogResources agendaWizardDialogResources, XTerminateListener xTerminateListener) {
        super(xMultiServiceFactory, xTerminateListener, "WIZARD_LIVE_PREVIEW");
        this.agenda = cGAgenda;
        this.resources = agendaWizardDialogResources;
        if (this.itemsCache == null) {
            this.initItemsCache();
        }
        this._allItems.clear();
        this.constItems.clear();
    }

    boolean isShowItem(String string) {
        if (string.equals("<meeting-type>")) {
            return this.agenda.cp_ShowMeetingType;
        }
        if (string.equals("<read>")) {
            return this.agenda.cp_ShowRead;
        }
        if (string.equals("<bring>")) {
            return this.agenda.cp_ShowBring;
        }
        if (string.equals("<notes>")) {
            return this.agenda.cp_ShowNotes;
        }
        if (string.equals("<facilitator>")) {
            return this.agenda.cp_ShowFacilitator;
        }
        if (string.equals("<timekeeper>")) {
            return this.agenda.cp_ShowTimekeeper;
        }
        if (string.equals("<notetaker>")) {
            return this.agenda.cp_ShowNotetaker;
        }
        if (string.equals("<attendees>")) {
            return this.agenda.cp_ShowAttendees;
        }
        if (string.equals("<called-by>")) {
            return this.agenda.cp_ShowCalledBy;
        }
        if (string.equals("<observers>")) {
            return this.agenda.cp_ShowObservers;
        }
        if (string.equals("<resource-persons>")) {
            return this.agenda.cp_ShowResourcePersons;
        }
        throw new IllegalArgumentException("No such item");
    }

    private void initItemsCache() {
        this.itemsCache = new HashMap<String, AgendaItem>(11);
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.document);
        this.itemsCache.put("<meeting-type>", new AgendaItem("<meeting-type>", new TextElement(this.resources.itemMeetingType, "MeetingType"), new PlaceholderElement("MeetingTypeText", this.resources.reschkMeetingTitle_value, this.resources.resPlaceHolderHint, xMultiServiceFactory)));
        this.itemsCache.put("<bring>", new AgendaItem("<bring>", new TextElement(this.resources.itemBring, "Bring"), new PlaceholderElement("BringText", this.resources.reschkBring_value, this.resources.resPlaceHolderHint, xMultiServiceFactory)));
        this.itemsCache.put("<read>", new AgendaItem("<read>", new TextElement(this.resources.itemRead, "Read"), new PlaceholderElement("ReadText", this.resources.reschkRead_value, this.resources.resPlaceHolderHint, xMultiServiceFactory)));
        this.itemsCache.put("<notes>", new AgendaItem("<notes>", new TextElement(this.resources.itemNote, "Notes"), new PlaceholderElement("NotesText", this.resources.reschkNotes_value, this.resources.resPlaceHolderHint, xMultiServiceFactory)));
        this.itemsCache.put("<called-by>", new AgendaItem("<called-by>", new TextElement(this.resources.itemCalledBy, "CalledBy"), new PlaceholderElement("CalledByText", this.resources.reschkConvenedBy_value, this.resources.resPlaceHolderHint, xMultiServiceFactory)));
        this.itemsCache.put("<facilitator>", new AgendaItem("<facilitator>", new TextElement(this.resources.itemFacilitator, "Facilitator"), new PlaceholderElement("FacilitatorText", this.resources.reschkPresiding_value, this.resources.resPlaceHolderHint, xMultiServiceFactory)));
        this.itemsCache.put("<attendees>", new AgendaItem("<attendees>", new TextElement(this.resources.itemAttendees, "Attendees"), new PlaceholderElement("AttendeesText", this.resources.reschkAttendees_value, this.resources.resPlaceHolderHint, xMultiServiceFactory)));
        this.itemsCache.put("<notetaker>", new AgendaItem("<notetaker>", new TextElement(this.resources.itemNotetaker, "Notetaker"), new PlaceholderElement("NotetakerText", this.resources.reschkNoteTaker_value, this.resources.resPlaceHolderHint, xMultiServiceFactory)));
        this.itemsCache.put("<timekeeper>", new AgendaItem("<timekeeper>", new TextElement(this.resources.itemTimekeeper, "Timekeeper"), new PlaceholderElement("TimekeeperText", this.resources.reschkTimekeeper_value, this.resources.resPlaceHolderHint, xMultiServiceFactory)));
        this.itemsCache.put("<observers>", new AgendaItem("<observers>", new TextElement(this.resources.itemObservers, "Observers"), new PlaceholderElement("ObserversText", this.resources.reschkObservers_value, this.resources.resPlaceHolderHint, xMultiServiceFactory)));
        this.itemsCache.put("<resource-persons>", new AgendaItem("<resource-persons>", new TextElement(this.resources.itemResource, "ResourcePersons"), new PlaceholderElement("ResourcePersonsText", this.resources.reschkResourcePersons_value, this.resources.resPlaceHolderHint, xMultiServiceFactory)));
    }

    private void initialize() {
        Object object;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.document);
        try {
            this.clearConstants();
            this.clearTopicConstants();
            object = xMultiServiceFactory.createInstance("com.sun.star.text.Defaults");
            Locale locale = (Locale)Helper.getUnoStructValue(object, "CharLocale");
            java.util.Locale locale2 = new java.util.Locale(locale.Language, locale.Country, locale.Variant);
            this.calendar = Calendar.getInstance(locale2);
            XNumberFormatsSupplier xNumberFormatsSupplier = (XNumberFormatsSupplier)UnoRuntime.queryInterface(XNumberFormatsSupplier.class, (Object)this.document);
            XPropertySet xPropertySet = xNumberFormatsSupplier.getNumberFormatSettings();
            Date date = (Date)Helper.getUnoPropertyValue(xPropertySet, "NullDate");
            this.calendar.set(date.Year, date.Month - 1, date.Day);
            this.docNullTime = JavaTools.getTimeInMillis(this.calendar);
            this.dateFormat = NumberFormatter.getNumberFormatterKey(xNumberFormatsSupplier, (short)19);
            this.timeFormat = NumberFormatter.getNumberFormatterKey(xNumberFormatsSupplier, (short)39);
            this.dateFormatter = NumberFormatter.createNumberFormatter(this.xMSF, xNumberFormatsSupplier);
            this.timeFormatter = NumberFormatter.createNumberFormatter(this.xMSF, xNumberFormatsSupplier);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new NullPointerException("Fatal Error: could not initialize locale or date/time formats.");
        }
        this.m_xDocProps = OfficeDocument.getDocumentProperties(this.document);
        this.initItemsCache();
        this.initializeItems();
        this.initializeTitles();
        this.initializeConstantTitles();
        this.initializeConstantTopicTitles();
        this.initializeItemsSections();
        object = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.document);
        this.textSectionHandler = new TextSectionHandler((XMultiServiceFactory)object, (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)this.document));
        this.initializeTopics();
        this.drawConstants();
        this.drawTopicConstants();
        this._allItems.clear();
        this.constItems.clear();
    }

    private void initializeTitles() {
        XTextRange xTextRange = null;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.document);
        for (int i = 0; i < this._allItems.size(); ++i) {
            xTextRange = this._allItems.get(i);
            String string = xTextRange.getString().trim().toLowerCase();
            if (string.equals("<title>")) {
                this.teTitle = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderTitle, this.resources.resPlaceHolderHint, xMultiServiceFactory);
                this.trTitle = xTextRange;
                this._allItems.remove(i--);
                continue;
            }
            if (string.equals("<date>")) {
                this.teDate = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderDate, this.resources.resPlaceHolderHint, xMultiServiceFactory);
                this.trDate = xTextRange;
                this._allItems.remove(i--);
                continue;
            }
            if (string.equals("<time>")) {
                this.teTime = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderTime, this.resources.resPlaceHolderHint, xMultiServiceFactory);
                this.trTime = xTextRange;
                this._allItems.remove(i--);
                continue;
            }
            if (!string.equals("<location>")) continue;
            this.teLocation = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderLocation, this.resources.resPlaceHolderHint, xMultiServiceFactory);
            this.trLocation = xTextRange;
            this._allItems.remove(i--);
        }
    }

    private void initializeConstantTitles() {
        XTextRange xTextRange = null;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.document);
        for (int i = 0; i < this.constItems.size(); ++i) {
            xTextRange = this.constItems.get(i);
            String string = xTextRange.getString().trim().toLowerCase();
            if (string.equals("#datetitle#")) {
                this.teDateTitle = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderDateTitle, this.resources.resPlaceHolderHint, xMultiServiceFactory);
                this.trDateTitle = xTextRange;
                this.constItems.remove(i--);
                continue;
            }
            if (string.equals("#timetitle#")) {
                this.teTimeTitle = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderTimeTitle, this.resources.resPlaceHolderHint, xMultiServiceFactory);
                this.trTimeTitle = xTextRange;
                this.constItems.remove(i--);
                continue;
            }
            if (string.equals("#locationtitle#")) {
                this.teLocationTitle = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderLocationTitle, this.resources.resPlaceHolderHint, xMultiServiceFactory);
                this.trLocationTitle = xTextRange;
                this.constItems.remove(i--);
                continue;
            }
            if (string.equals("#topics#")) {
                this.teTopics = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderTopics, this.resources.resPlaceHolderHint, xMultiServiceFactory);
                this.trTopics = xTextRange;
                this.constItems.remove(i--);
                continue;
            }
            if (string.equals("#num.#")) {
                this.teNum = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderNum, this.resources.resPlaceHolderHint, xMultiServiceFactory);
                this.trNum = xTextRange;
                this.constItems.remove(i--);
                continue;
            }
            if (string.equals("#additional-information#")) {
                this.teAdditionalInformation = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderAdditionalInformation, this.resources.resPlaceHolderHint, xMultiServiceFactory);
                this.trAdditionalInformation = xTextRange;
                this.constItems.remove(i--);
                continue;
            }
            if (string.equals("#minutes-for#")) {
                this.teMinutesFor = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderMinutesFor, this.resources.resPlaceHolderHint, xMultiServiceFactory);
                this.trMinutesFor = xTextRange;
                this.constItems.remove(i--);
                continue;
            }
            if (string.equals("#discussion#")) {
                this.teDiscussion = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderDiscussion, this.resources.resPlaceHolderHint, xMultiServiceFactory);
                this.trDiscussion = xTextRange;
                this.constItems.remove(i--);
                continue;
            }
            if (string.equals("#conclusion#")) {
                this.teConclusion = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderConclusion, this.resources.resPlaceHolderHint, xMultiServiceFactory);
                this.trConclusion = xTextRange;
                this.constItems.remove(i--);
                continue;
            }
            if (string.equals("#to-do#")) {
                this.teToDo = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderToDo, this.resources.resPlaceHolderHint, xMultiServiceFactory);
                this.trToDo = xTextRange;
                this.constItems.remove(i--);
                continue;
            }
            if (string.equals("#responsible-party#")) {
                this.teResponsibleParty = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderResponsibleParty, this.resources.resPlaceHolderHint, xMultiServiceFactory);
                this.trResponsibleParty = xTextRange;
                this.constItems.remove(i--);
                continue;
            }
            if (!string.equals("#deadline#")) continue;
            this.teDeadline = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderDeadline, this.resources.resPlaceHolderHint, xMultiServiceFactory);
            this.trDeadline = xTextRange;
            this.constItems.remove(i--);
        }
    }

    private void initializeConstantTopicTitles() {
        XTextRange xTextRange = null;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.document);
        for (int i = 0; i < this.constItems.size(); ++i) {
            xTextRange = this.constItems.get(i);
            String string = xTextRange.getString().trim().toLowerCase();
            if (string.equals("#topicheader#")) {
                this.teTopicHeader = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderTopic, this.resources.resPlaceHolderHint, xMultiServiceFactory);
                this.trTopicHeader = xTextRange;
                this.teTopicList.add(this.teTopicHeader);
                this.trTopicList.add(this.trTopicHeader);
                this.constItems.remove(i--);
                continue;
            }
            if (string.equals("#responsibleheader#")) {
                this.teResponsibleHeader = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderResponsible, this.resources.resPlaceHolderHint, xMultiServiceFactory);
                this.trResponsibleHeader = xTextRange;
                this.teResponsibleList.add(this.teResponsibleHeader);
                this.trResponsibleList.add(this.trResponsibleHeader);
                this.constItems.remove(i--);
                continue;
            }
            if (!string.equals("#timeheader#")) continue;
            this.teTimeHeader = new PlaceholderTextElement(xTextRange, this.resources.resPlaceHolderTime, this.resources.resPlaceHolderHint, xMultiServiceFactory);
            this.trTimeHeader = xTextRange;
            this.teTimeList.add(this.teTimeHeader);
            this.trTimeList.add(this.trTimeHeader);
            this.constItems.remove(i--);
        }
    }

    private void initializeTopics() {
        this.topics = new Topics();
    }

    public void refreshTopicConstants() {
        this.constItems = this.searchFillInItems(1);
        this.clearConstants();
        this.initializeConstantTopicTitles();
        this.drawTopicConstants();
    }

    public void refreshConstants() {
        this.constItems = this.searchFillInItems(1);
        this.clearTopicConstants();
        this.initializeConstantTitles();
        this.drawConstants();
    }

    private void initializeItems() {
        this._allItems = this.searchFillInItems(0);
        this.constItems = this.searchFillInItems(1);
    }

    private List<XTextRange> searchFillInItems(int n) {
        try {
            XSearchable xSearchable = (XSearchable)UnoRuntime.queryInterface(XSearchable.class, (Object)this.document);
            XSearchDescriptor xSearchDescriptor = xSearchable.createSearchDescriptor();
            if (n == 0) {
                xSearchDescriptor.setSearchString("<[^>]+>");
            } else if (n == 1) {
                xSearchDescriptor.setSearchString("#[^#]+#");
            }
            xSearchDescriptor.setPropertyValue("SearchRegularExpression", (Object)Boolean.TRUE);
            xSearchDescriptor.setPropertyValue("SearchWords", (Object)Boolean.TRUE);
            XIndexAccess xIndexAccess = xSearchable.findAll(xSearchDescriptor);
            ArrayList<XTextRange> arrayList = new ArrayList<XTextRange>(xIndexAccess.getCount());
            for (int i = 0; i < xIndexAccess.getCount(); ++i) {
                try {
                    arrayList.add((XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)xIndexAccess.getByIndex(i)));
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("Nonfatal Error in finding fillins.");
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException("Fatal Error: Loading template failed: searching fillins failed");
        }
    }

    private void initializeItemsSections() {
        String[] stringArray = this.getSections(this.document, "AGENDA_ITEMS");
        this.itemsTables = new ItemsTable[stringArray.length];
        for (int i = 0; i < this.itemsTables.length; ++i) {
            try {
                this.itemsTables[i] = new ItemsTable(this.getSection(stringArray[i]), this.getTable(stringArray[i]));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IllegalArgumentException("Fatal Error while initialilzing Template: items table in section " + stringArray[i]);
            }
        }
    }

    private String[] getSections(Object object, String string) {
        XTextSectionsSupplier xTextSectionsSupplier = (XTextSectionsSupplier)UnoRuntime.queryInterface(XTextSectionsSupplier.class, (Object)object);
        String[] stringArray = xTextSectionsSupplier.getTextSections().getElementNames();
        return AgendaTemplate.getNamesWhichStartWith(stringArray, string);
    }

    Object getSection(String string) throws NoSuchElementException, WrappedTargetException {
        XTextSectionsSupplier xTextSectionsSupplier = (XTextSectionsSupplier)UnoRuntime.queryInterface(XTextSectionsSupplier.class, (Object)this.document);
        return ((Any)xTextSectionsSupplier.getTextSections().getByName(string)).getObject();
    }

    Object getTable(String string) throws NoSuchElementException, WrappedTargetException {
        XTextTablesSupplier xTextTablesSupplier = (XTextTablesSupplier)UnoRuntime.queryInterface(XTextTablesSupplier.class, (Object)this.document);
        return ((Any)xTextTablesSupplier.getTextTables().getByName(string)).getObject();
    }

    @Override
    public synchronized void eventPerformed(Object object) {
        TextEvent textEvent = (TextEvent)object;
        String string = (String)Helper.getUnoPropertyValue(UnoDialog2.getModel(textEvent.Source), PropertyNames.PROPERTY_NAME);
        this.redrawTitle(string);
    }

    private synchronized void redrawTitle(String string) {
        if (string.equals("txtTitle")) {
            this.writeTitle(this.teTitle, this.trTitle, this.agenda.cp_Title);
        } else if (string.equals("txtDate")) {
            this.writeTitle(this.teDate, this.trDate, this.getDateString(this.agenda.cp_Date));
        } else if (string.equals("txtTime")) {
            this.writeTitle(this.teTime, this.trTime, this.getTimeString(this.agenda.cp_Time));
        } else if (string.equals("cbLocation")) {
            this.writeTitle(this.teLocation, this.trLocation, this.agenda.cp_Location);
        } else {
            throw new IllegalArgumentException("No such title control...");
        }
    }

    public void drawConstants() {
        if (this.teDateTitle != null) {
            this.writeTitle(this.teDateTitle, this.trDateTitle, this.resources.resPlaceHolderDateTitle);
        }
        if (this.teTimeTitle != null) {
            this.writeTitle(this.teTimeTitle, this.trTimeTitle, this.resources.resPlaceHolderTimeTitle);
        }
        if (this.teLocationTitle != null) {
            this.writeTitle(this.teLocationTitle, this.trLocationTitle, this.resources.resPlaceHolderLocationTitle);
        }
        if (this.teTopics != null) {
            this.writeTitle(this.teTopics, this.trTopics, this.resources.resPlaceHolderTopics);
        }
        if (this.teNum != null) {
            this.writeTitle(this.teNum, this.trNum, this.resources.resPlaceHolderNum);
        }
        if (this.teAdditionalInformation != null) {
            this.writeTitle(this.teAdditionalInformation, this.trAdditionalInformation, this.resources.resPlaceHolderAdditionalInformation);
        }
        if (this.teMinutesFor != null) {
            this.writeTitle(this.teMinutesFor, this.trMinutesFor, this.resources.resPlaceHolderMinutesFor);
        }
        if (this.teDiscussion != null) {
            this.writeTitle(this.teDiscussion, this.trDiscussion, this.resources.resPlaceHolderDiscussion);
        }
        if (this.teConclusion != null) {
            this.writeTitle(this.teConclusion, this.trConclusion, this.resources.resPlaceHolderConclusion);
        }
        if (this.teToDo != null) {
            this.writeTitle(this.teToDo, this.trToDo, this.resources.resPlaceHolderToDo);
        }
        if (this.teResponsibleParty != null) {
            this.writeTitle(this.teResponsibleParty, this.trResponsibleParty, this.resources.resPlaceHolderResponsibleParty);
        }
        if (this.teDeadline != null) {
            this.writeTitle(this.teDeadline, this.trDeadline, this.resources.resPlaceHolderDeadline);
        }
    }

    public void drawTopicConstants() {
        int n;
        if (this.teTopicList != null) {
            for (n = 0; n < this.teTopicList.size(); ++n) {
                this.writeTitle(this.teTopicList.get(n), this.trTopicList.get(n), this.resources.resPlaceHolderTopic);
            }
        }
        if (this.teResponsibleList != null) {
            for (n = 0; n < this.teResponsibleList.size(); ++n) {
                this.writeTitle(this.teResponsibleList.get(n), this.trResponsibleList.get(n), this.resources.resPlaceHolderResponsible);
            }
        }
        if (this.teTimeList != null) {
            for (n = 0; n < this.teTimeList.size(); ++n) {
                this.writeTitle(this.teTimeList.get(n), this.trTimeList.get(n), this.resources.resPlaceHolderTimeHeader);
            }
        }
    }

    private void writeTitle(TextElement textElement, XTextRange xTextRange, String string) {
        textElement.text = string == null ? PropertyNames.EMPTY_STRING : string;
        textElement.write(xTextRange);
    }

    private String getDateString(String string) {
        if (string == null || string.equals(PropertyNames.EMPTY_STRING)) {
            return PropertyNames.EMPTY_STRING;
        }
        int n = Integer.parseInt(string);
        this.calendar.clear();
        this.calendar.set(n / 10000, n % 10000 / 100 - 1, n % 100);
        long l = JavaTools.getTimeInMillis(this.calendar);
        double d = (l - this.docNullTime) / DAY_IN_MILLIS + 1L;
        return this.dateFormatter.convertNumberToString(this.dateFormat, d);
    }

    private String getTimeString(String string) {
        if (string == null || string.equals(PropertyNames.EMPTY_STRING)) {
            return PropertyNames.EMPTY_STRING;
        }
        int n = Integer.parseInt(string);
        double d = (double)(n / 1000000) / 24.0 + (double)(n % 1000000 / 1000) / 1440.0;
        return this.timeFormatter.convertNumberToString(this.timeFormat, d);
    }

    public synchronized void finish(List<PropertyValue[]> list) {
        this.createMinutes(list);
        this.deleteHiddenSections();
        this.textSectionHandler.removeAllTextSections();
    }

    private void deleteHiddenSections() {
        XTextSectionsSupplier xTextSectionsSupplier = (XTextSectionsSupplier)UnoRuntime.queryInterface(XTextSectionsSupplier.class, (Object)this.document);
        String[] stringArray = xTextSectionsSupplier.getTextSections().getElementNames();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                Object object = this.getSection(stringArray[i]);
                boolean bl = (Boolean)Helper.getUnoPropertyValue(object, "IsVisible");
                if (bl) continue;
                ((XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)object)).getAnchor().setString(PropertyNames.EMPTY_STRING);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void createMinutes(List<PropertyValue[]> list) {
        if (!this.agenda.cp_IncludeMinutes || list.size() <= 1) {
            try {
                Object object = this.getSection("MINUTES_ALL");
                XTextSection xTextSection = (XTextSection)UnoRuntime.queryInterface(XTextSection.class, (Object)object);
                xTextSection.getAnchor().setString(PropertyNames.EMPTY_STRING);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                String string;
                XTextRange xTextRange;
                int n;
                int n2 = 0;
                try {
                    n2 = Integer.parseInt(this.agenda.cp_Time);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                List<XTextRange> list2 = this.searchFillInItems(0);
                for (n = 0; n < list2.size(); ++n) {
                    xTextRange = list2.get(n);
                    string = xTextRange.getString().trim().toLowerCase();
                    if (string.equals("<minutes-title>")) {
                        this.fillMinutesItem(xTextRange, this.agenda.cp_Title, this.resources.resPlaceHolderTitle);
                        continue;
                    }
                    if (string.equals("<minutes-location>")) {
                        this.fillMinutesItem(xTextRange, this.agenda.cp_Location, this.resources.resPlaceHolderLocation);
                        continue;
                    }
                    if (string.equals("<minutes-date>")) {
                        this.fillMinutesItem(xTextRange, this.getDateString(this.agenda.cp_Date), this.resources.resPlaceHolderDate);
                        continue;
                    }
                    if (!string.equals("<minutes-time>")) continue;
                    this.fillMinutesItem(xTextRange, this.getTimeString(this.agenda.cp_Time), this.resources.resPlaceHolderTime);
                }
                list2.clear();
                for (n = 0; n < list.size() - 1; ++n) {
                    PropertyValue[] propertyValueArray = list.get(n);
                    list2 = this.searchFillInItems(0);
                    for (int i = 0; i < list2.size(); ++i) {
                        String string2;
                        xTextRange = list2.get(i);
                        string = xTextRange.getString().trim().toLowerCase();
                        if (string.equals("<mnum>")) {
                            this.fillMinutesItem(xTextRange, propertyValueArray[0].Value, PropertyNames.EMPTY_STRING);
                            continue;
                        }
                        if (string.equals("<mtopic>")) {
                            this.fillMinutesItem(xTextRange, propertyValueArray[1].Value, PropertyNames.EMPTY_STRING);
                            continue;
                        }
                        if (string.equals("<mresponsible>")) {
                            this.fillMinutesItem(xTextRange, propertyValueArray[2].Value, PropertyNames.EMPTY_STRING);
                            continue;
                        }
                        if (!string.equals("<mtime>")) continue;
                        int n3 = 0;
                        try {
                            n3 = new Integer((String)propertyValueArray[3].Value);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (n3 == 0 || n2 == 0) {
                            string2 = (String)propertyValueArray[3].Value;
                        } else {
                            string2 = this.getTimeString(String.valueOf(n2)) + " - ";
                            string2 = string2 + this.getTimeString(String.valueOf(n2 += n3 * 1000));
                        }
                        this.fillMinutesItem(xTextRange, string2, PropertyNames.EMPTY_STRING);
                    }
                    this.textSectionHandler.removeTextSectionbyName("MINUTES");
                    if (n >= list.size() - 2) continue;
                    this.textSectionHandler.insertTextSection("MINUTES", this.template, false);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void fillMinutesItem(XTextRange xTextRange, Object object, String string) {
        String string2 = (String)Helper.getUnoPropertyValue(xTextRange, "ParaStyleName");
        xTextRange.setString((String)object);
        Helper.setUnoPropertyValue(xTextRange, "ParaStyleName", string2);
        if ((object == null || object.equals(PropertyNames.EMPTY_STRING)) && string != null && !string.equals(PropertyNames.EMPTY_STRING)) {
            XTextContent xTextContent = AgendaTemplate.createPlaceHolder(this.docMSF, string, this.resources.resPlaceHolderHint);
            try {
                xTextRange.getStart().getText().insertTextContent(xTextRange.getStart(), xTextContent, true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static XTextContent createPlaceHolder(XMultiServiceFactory xMultiServiceFactory, String string, String string2) {
        Object object;
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.text.TextField.JumpEdit");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        Helper.setUnoPropertyValue(object, "PlaceHolder", string);
        Helper.setUnoPropertyValue(object, "Hint", string2);
        Helper.setUnoPropertyValue(object, "PlaceHolderType", new Short(0));
        return (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)object);
    }

    public static String[] getNamesWhichStartWith(String[] stringArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = new String[arrayList.size()];
        return arrayList.toArray(stringArray2);
    }

    public static String getName(Object object) {
        return ((XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)object)).getName();
    }

    public static void removeTableRows(Object object, int n, int n2) {
        XTableRows xTableRows = ((XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)object)).getRows();
    }

    public static void insertTableRows(Object object, int n, int n2) {
        XTableRows xTableRows = ((XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)object)).getRows();
        xTableRows.insertByIndex(n, n2);
    }

    public static int getRowIndex(XTextTableCursor xTextTableCursor) {
        return AgendaTemplate.getRowIndex(xTextTableCursor.getRangeName());
    }

    public static int getRowIndex(String string) {
        return Integer.parseInt(string.substring(1));
    }

    public static int getRowCount(XTextTable xTextTable) {
        String[] stringArray = xTextTable.getCellNames();
        return AgendaTemplate.getRowIndex(stringArray[stringArray.length - 1]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Topics {
        XTextTable table;
        List<TableCellFormatter> firstRowFormat = new ArrayList<TableCellFormatter>();
        List<TableCellFormatter> lastRowFormat = new ArrayList<TableCellFormatter>();
        List<TableCellFormatter> topicCellFormats = new ArrayList<TableCellFormatter>();
        List<AgendaElement> topicCells = new ArrayList<AgendaElement>();
        int rowsPerTopic;
        int numCell = -1;
        int topicCell = -1;
        int responsibleCell = -1;
        int timeCell = -1;
        List<String> writtenTopics = new ArrayList<String>();

        public Topics() {
            Object object;
            int n;
            Object object2;
            HashMap<String, TextElement> hashMap = new HashMap<String, TextElement>(4);
            try {
                object2 = AgendaTemplate.this.getTable("AGENDA_TOPICS");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IllegalArgumentException("Fatal error while loading template: table AGENDA_TOPICS could not load.");
            }
            this.table = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)object2);
            HashMap<Object, XTextRange> hashMap2 = new HashMap<Object, XTextRange>();
            for (n = 0; n < AgendaTemplate.this._allItems.size(); ++n) {
                XTextRange xTextRange = AgendaTemplate.this._allItems.get(n);
                object2 = Helper.getUnoPropertyValue(xTextRange, "TextTable");
                if (!(object2 instanceof Any) || ((Any)object2).getObject() != this.table) continue;
                object = Helper.getUnoPropertyValue(xTextRange, "Cell");
                hashMap2.put(((Any)object).getObject(), xTextRange);
            }
            n = AgendaTemplate.getRowCount(this.table);
            this.rowsPerTopic = (n - 1) / 3;
            String string = "A" + (1 + this.rowsPerTopic + 1);
            String string2 = "A" + (1 + this.rowsPerTopic * 2 + 1);
            XTextTableCursor xTextTableCursor = this.table.createCursorByCellName(string);
            while (!xTextTableCursor.getRangeName().equals(string2)) {
                object = this.table.getCellByName(xTextTableCursor.getRangeName());
                XTextRange xTextRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)object);
                TextElement textElement = new TextElement(xTextRange);
                XTextRange xTextRange2 = (XTextRange)hashMap2.get(object);
                if (xTextRange2 != null) {
                    hashMap.put(xTextRange.getString().toLowerCase().trim(), textElement);
                }
                this.topicCells.add(textElement);
                this.topicCellFormats.add(new TableCellFormatter(this.table.getCellByName(xTextTableCursor.getRangeName())));
                xTextTableCursor.goRight((short)1, false);
            }
            this.numCell = this.topicCells.indexOf(hashMap.get("<num>"));
            this.topicCell = this.topicCells.indexOf(hashMap.get("<topic>"));
            this.responsibleCell = this.topicCells.indexOf(hashMap.get("<responsible>"));
            this.timeCell = this.topicCells.indexOf(hashMap.get("<topic-time>"));
            xTextTableCursor.gotoStart(false);
            do {
                this.firstRowFormat.add(new TableCellFormatter(this.table.getCellByName(xTextTableCursor.getRangeName())));
                xTextTableCursor.goRight((short)1, false);
            } while (!xTextTableCursor.getRangeName().startsWith("A"));
            xTextTableCursor.gotoEnd(false);
            while (!xTextTableCursor.getRangeName().startsWith("A")) {
                this.lastRowFormat.add(new TableCellFormatter(this.table.getCellByName(xTextTableCursor.getRangeName())));
                xTextTableCursor.goLeft((short)1, false);
            }
            this.lastRowFormat.add(new TableCellFormatter(this.table.getCellByName(xTextTableCursor.getRangeName())));
            AgendaTemplate.removeTableRows(this.table, 1 + this.rowsPerTopic, n - this.rowsPerTopic - 1);
        }

        private int write2(int n, PropertyValue[] propertyValueArray) throws Exception {
            while (n >= this.writtenTopics.size()) {
                this.writtenTopics.add(null);
            }
            this.writtenTopics.set(n, PropertyNames.EMPTY_STRING);
            int n2 = AgendaTemplate.getRowCount(this.table);
            int n3 = 1 + (n + 1) * this.rowsPerTopic;
            int n4 = n3 - this.rowsPerTopic + 1;
            int n5 = n3 - n2;
            if (n5 > 0) {
                AgendaTemplate.insertTableRows(this.table, n2, n5);
            }
            this.setItemText(this.numCell, propertyValueArray[0].Value);
            this.setItemText(this.topicCell, propertyValueArray[1].Value);
            this.setItemText(this.responsibleCell, propertyValueArray[2].Value);
            this.setItemText(this.timeCell, propertyValueArray[3].Value);
            XTextTableCursor xTextTableCursor = this.table.createCursorByCellName("A" + n4);
            for (int i = 0; i < this.topicCells.size(); ++i) {
                this.topicCells.get(i).write(this.table.getCellByName(xTextTableCursor.getRangeName()));
                xTextTableCursor.goRight((short)1, false);
            }
            xTextTableCursor.gotoCellByName("A" + n4, false);
            this.formatTable(xTextTableCursor, this.topicCellFormats, false);
            return n5;
        }

        private boolean isWritten(int n) {
            return this.writtenTopics.size() > n && this.writtenTopics.get(n) != null;
        }

        public void writeCell(int n, int n2, PropertyValue[] propertyValueArray) throws Exception {
            if (!this.isWritten(n)) {
                this.write(n, propertyValueArray);
            } else {
                int n3 = 1 + n * this.rowsPerTopic + 1;
                XTextTableCursor xTextTableCursor = this.table.createCursorByCellName("A" + n3);
                TextElement textElement = null;
                int n4 = 0;
                switch (n2) {
                    case 0: {
                        textElement = this.setItemText(this.numCell, propertyValueArray[0].Value);
                        n4 = this.numCell;
                        break;
                    }
                    case 1: {
                        textElement = this.setItemText(this.topicCell, propertyValueArray[1].Value);
                        n4 = this.topicCell;
                        break;
                    }
                    case 2: {
                        textElement = this.setItemText(this.responsibleCell, propertyValueArray[2].Value);
                        n4 = this.responsibleCell;
                        break;
                    }
                    case 3: {
                        textElement = this.setItemText(this.timeCell, propertyValueArray[3].Value);
                        n4 = this.timeCell;
                    }
                }
                if (textElement != null) {
                    xTextTableCursor.goRight((short)n4, false);
                    XCell xCell = this.table.getCellByName(xTextTableCursor.getRangeName());
                    textElement.write(xCell);
                    this.topicCellFormats.get(n4).format(xCell);
                }
            }
        }

        public void write(int n, PropertyValue[] propertyValueArray) throws Exception {
            int n2 = this.write2(n, propertyValueArray);
            if (n == 0) {
                this.formatFirstRow();
            }
            if (n2 > 0) {
                this.formatLastRow();
            }
        }

        public void writeAll(List<PropertyValue[]> list) {
            try {
                for (int i = 0; i < list.size() - 1; ++i) {
                    this.write2(i, list.get(i));
                }
                this.formatLastRow();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void reduceDocumentTo(int n) throws Exception {
            if (n <= 0) {
                n = 1;
            }
            XTableRows xTableRows = this.table.getRows();
            int n2 = n * this.rowsPerTopic + 1;
            this.formatLastRow();
            while (this.writtenTopics.size() > n) {
                this.writtenTopics.remove(n);
            }
        }

        private void formatFirstRow() {
            XTextTableCursor xTextTableCursor = this.table.createCursorByCellName("A1");
            this.formatTable(xTextTableCursor, this.firstRowFormat, false);
        }

        private void formatLastRow() {
            XTextTableCursor xTextTableCursor = this.table.createCursorByCellName("A1");
            xTextTableCursor.gotoEnd(false);
            this.formatTable(xTextTableCursor, this.lastRowFormat, true);
        }

        private TextElement setItemText(int n, Object object) {
            if (n >= 0) {
                TextElement textElement = (TextElement)this.topicCells.get(n);
                if (textElement != null) {
                    textElement.text = object.toString();
                }
                return textElement;
            }
            return null;
        }

        private void formatTable(XTextTableCursor xTextTableCursor, List<TableCellFormatter> list, boolean bl) {
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).format(this.table.getCellByName(xTextTableCursor.getRangeName()));
                if (bl) {
                    xTextTableCursor.goLeft((short)1, false);
                    continue;
                }
                xTextTableCursor.goRight((short)1, false);
            }
        }
    }

    public class ItemsTable {
        Object table;
        Object section;
        List<AgendaItem> items = new ArrayList<AgendaItem>(6);

        public ItemsTable(Object object, Object object2) {
            this.table = object2;
            this.section = object;
            for (int i = 0; i < AgendaTemplate.this._allItems.size(); ++i) {
                XTextRange xTextRange = AgendaTemplate.this._allItems.get(i);
                Object object3 = Helper.getUnoPropertyValue(xTextRange, "TextTable");
                if (!(object3 instanceof Any) || ((Any)object3).getObject() != this.table) continue;
                String string = xTextRange.getString().toLowerCase().trim();
                AgendaItem agendaItem = AgendaTemplate.this.itemsCache.get(xTextRange.getString().toLowerCase().trim());
                if (agendaItem == null) continue;
                this.items.add(agendaItem);
                AgendaTemplate.this._allItems.remove(i--);
                AgendaTemplate.this.itemsMap.put(string, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void write(Object object) throws Exception {
            ItemsTable itemsTable = this;
            synchronized (itemsTable) {
                String string = AgendaTemplate.getName(this.section);
                AgendaTemplate.this.textSectionHandler.linkSectiontoTemplate(this.section, AgendaTemplate.this.template, string);
                AgendaTemplate.this.textSectionHandler.breakLinkOfTextSection(this.section);
                this.table = AgendaTemplate.this.getTable(string);
                this.section = AgendaTemplate.this.getSection(string);
                XTextTable xTextTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)this.table);
                XTextTableCursor xTextTableCursor = xTextTable.createCursorByCellName("A1");
                boolean bl = false;
                String string2 = PropertyNames.EMPTY_STRING;
                for (int i = 0; i < this.items.size(); ++i) {
                    AgendaItem agendaItem = this.items.get(i);
                    if (!AgendaTemplate.this.isShowItem(agendaItem.name)) continue;
                    bl = true;
                    agendaItem.table = this.table;
                    agendaItem.write(xTextTableCursor);
                    string2 = xTextTableCursor.getRangeName();
                    xTextTableCursor.goRight((short)1, false);
                }
                Helper.setUnoPropertyValue(this.section, "IsVisible", bl ? Boolean.TRUE : Boolean.FALSE);
                if (!bl) {
                    return;
                }
                if (string2.equals(xTextTableCursor.getRangeName())) {
                    return;
                }
                while (!string2.equals(xTextTableCursor.getRangeName()) && !xTextTableCursor.getRangeName().startsWith("A")) {
                    XCell xCell = xTextTable.getCellByName(xTextTableCursor.getRangeName());
                    ((XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)xCell)).setString(PropertyNames.EMPTY_STRING);
                    string2 = xTextTableCursor.getRangeName();
                    xTextTableCursor.goRight((short)1, false);
                }
                if (string2.equals(xTextTableCursor.getRangeName())) {
                    return;
                }
                int n = AgendaTemplate.getRowIndex(xTextTableCursor);
                int n2 = AgendaTemplate.getRowCount((XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)this.table));
                xTextTableCursor.gotoStart(false);
                if (n2 >= n) {
                    AgendaTemplate.removeTableRows(this.table, n - 1, n2 - n + 1);
                }
            }
        }
    }
}

