/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XHierarchicalPropertySet;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNameReplace;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XChangesBatch;
import com.sun.star.wizards.common.ConfigNode;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.PropertyNames;

public abstract class Configuration {
    public static int getInt(String string, Object object) throws Exception {
        Object object2 = Configuration.getNode(string, object);
        if (AnyConverter.isVoid((Object)object2)) {
            return 0;
        }
        return AnyConverter.toInt((Object)object2);
    }

    public static short getShort(String string, Object object) throws Exception {
        Object object2 = Configuration.getNode(string, object);
        if (AnyConverter.isVoid((Object)object2)) {
            return 0;
        }
        return AnyConverter.toShort((Object)object2);
    }

    public static float getFloat(String string, Object object) throws Exception {
        Object object2 = Configuration.getNode(string, object);
        if (AnyConverter.isVoid((Object)object2)) {
            return 0.0f;
        }
        return AnyConverter.toFloat((Object)object2);
    }

    public static double getDouble(String string, Object object) throws Exception {
        Object object2 = Configuration.getNode(string, object);
        if (AnyConverter.isVoid((Object)object2)) {
            return 0.0;
        }
        return AnyConverter.toDouble((Object)object2);
    }

    public static String getString(String string, Object object) throws Exception {
        Object object2 = Configuration.getNode(string, object);
        if (AnyConverter.isVoid((Object)object2)) {
            return PropertyNames.EMPTY_STRING;
        }
        return (String)object2;
    }

    public static boolean getBoolean(String string, Object object) throws Exception {
        Object object2 = Configuration.getNode(string, object);
        if (AnyConverter.isVoid((Object)object2)) {
            return false;
        }
        return AnyConverter.toBoolean((Object)object2);
    }

    public static Object getNode(String string, Object object) throws Exception {
        return ((XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)object)).getByName(string);
    }

    public static void set(int n, String string, Object object) throws Exception {
        Configuration.set(new Integer(n), string, object);
    }

    public static void set(short s, String string, Object object) throws Exception {
        Configuration.set(new Short(s), string, object);
    }

    public static void set(String string, String string2, Object object) throws Exception {
        Configuration.set((Object)string, string2, object);
    }

    public static void set(boolean bl, String string, Object object) throws Exception {
        if (bl) {
            Configuration.set(Boolean.TRUE, string, object);
        } else {
            Configuration.set(Boolean.FALSE, string, object);
        }
    }

    public static void set(Object object, String string, Object object2) throws IllegalArgumentException, PropertyVetoException, UnknownPropertyException, WrappedTargetException {
        ((XHierarchicalPropertySet)UnoRuntime.queryInterface(XHierarchicalPropertySet.class, (Object)object2)).setHierarchicalPropertyValue(string, object);
    }

    public static Object getConfigurationNode(String string, Object object) throws Exception {
        return ((XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)object)).getByName(string);
    }

    public static Object getConfigurationRoot(XMultiServiceFactory xMultiServiceFactory, String string, boolean bl) throws Exception {
        Object object = xMultiServiceFactory.createInstance("com.sun.star.configuration.ConfigurationProvider");
        XMultiServiceFactory xMultiServiceFactory2 = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)object);
        String string2 = bl ? "com.sun.star.configuration.ConfigurationUpdateAccess" : "com.sun.star.configuration.ConfigurationAccess";
        Object[] objectArray = new Object[bl ? 2 : 1];
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = "nodepath";
        propertyValue.Value = string;
        objectArray[0] = propertyValue;
        if (bl) {
            PropertyValue propertyValue2 = new PropertyValue();
            propertyValue2.Name = "lazywrite";
            propertyValue2.Value = Boolean.FALSE;
            objectArray[1] = propertyValue2;
        }
        return xMultiServiceFactory2.createInstanceWithArguments(string2, objectArray);
    }

    public static String[] getChildrenNames(Object object) {
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)object);
        return xNameAccess.getElementNames();
    }

    public static String getProductName(XMultiServiceFactory xMultiServiceFactory) {
        try {
            Object object = Configuration.getConfigurationRoot(xMultiServiceFactory, "org.openoffice.Setup/Product", false);
            return (String)Helper.getUnoObjectbyName(object, "ooName");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static String getOfficeLocaleString(XMultiServiceFactory xMultiServiceFactory) {
        String string = PropertyNames.EMPTY_STRING;
        try {
            Locale locale = new Locale();
            Object object = Configuration.getConfigurationRoot(xMultiServiceFactory, "org.openoffice.Setup/L10N/", false);
            string = (String)Helper.getUnoObjectbyName(object, "ooLocale");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return string;
    }

    public static Locale getOfficeLocale(XMultiServiceFactory xMultiServiceFactory) {
        Locale locale = new Locale();
        String string = Configuration.getOfficeLocaleString(xMultiServiceFactory);
        String[] stringArray = JavaTools.ArrayoutofString(string, "-");
        locale.Language = stringArray[0];
        if (stringArray.length > 1) {
            locale.Country = stringArray[1];
        }
        return locale;
    }

    public static String getOfficeLinguistic(XMultiServiceFactory xMultiServiceFactory) {
        try {
            Object object = Configuration.getConfigurationRoot(xMultiServiceFactory, "org.openoffice.Setup/L10N/", false);
            return (String)Helper.getUnoObjectbyName(object, "ooLocale");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object addConfigNode(Object object, String string) throws WrappedTargetException, ElementExistException, NoSuchElementException, Exception {
        XNameContainer xNameContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)object);
        if (xNameContainer == null) {
            XNameReplace xNameReplace = (XNameReplace)UnoRuntime.queryInterface(XNameReplace.class, (Object)object);
            return xNameReplace.getByName(string);
        }
        XSingleServiceFactory xSingleServiceFactory = (XSingleServiceFactory)UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)object);
        Object object2 = xSingleServiceFactory.createInstance();
        xNameContainer.insertByName(string, object2);
        return object2;
    }

    public static void removeNode(Object object, String string) throws NoSuchElementException, WrappedTargetException {
        XNameContainer xNameContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)object);
        if (xNameContainer.hasByName(string)) {
            xNameContainer.removeByName(string);
        }
    }

    public static void commit(Object object) throws WrappedTargetException {
        XChangesBatch xChangesBatch = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)object);
        xChangesBatch.commitChanges();
    }

    public static void updateConfiguration(XMultiServiceFactory xMultiServiceFactory, String string, String string2, ConfigNode configNode, Object object) throws Exception, ElementExistException, NoSuchElementException, WrappedTargetException {
        Object object2 = Configuration.getConfigurationRoot(xMultiServiceFactory, string, true);
        Configuration.addConfigNode(string, string2);
        configNode.writeConfiguration(object2, object);
        XChangesBatch xChangesBatch = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)object2);
        xChangesBatch.commitChanges();
    }

    public static void removeNode(XMultiServiceFactory xMultiServiceFactory, String string, String string2) throws Exception, ElementExistException, NoSuchElementException, WrappedTargetException {
        Object object = Configuration.getConfigurationRoot(xMultiServiceFactory, string, true);
        Configuration.removeNode(object, string2);
        XChangesBatch xChangesBatch = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)object);
        xChangesBatch.commitChanges();
    }

    public static String[] getNodeDisplayNames(XNameAccess xNameAccess) {
        Object var1_1 = null;
        return Configuration.getNodeChildNames(xNameAccess, PropertyNames.PROPERTY_NAME);
    }

    public static String[] getNodeChildNames(XNameAccess xNameAccess, String string) {
        String[] stringArray = null;
        try {
            stringArray = xNameAccess.getElementNames();
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Object object = Helper.getUnoPropertyValue(xNameAccess.getByName(stringArray[i]), string);
                stringArray2[i] = !AnyConverter.isVoid((Object)object) ? (String)Helper.getUnoPropertyValue(xNameAccess.getByName(stringArray[i]), string) : stringArray[i];
            }
            return stringArray2;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return stringArray;
        }
    }

    public static XNameAccess getChildNodebyIndex(XNameAccess xNameAccess, int n) {
        try {
            String[] stringArray = xNameAccess.getElementNames();
            Object object = xNameAccess.getByName(stringArray[n]);
            return (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)object);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static XNameAccess getChildNodebyName(XNameAccess xNameAccess, String string) {
        try {
            if (xNameAccess.hasByName(string)) {
                return (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xNameAccess.getByName(string));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return null;
    }

    public static XNameAccess getChildNodebyDisplayName(XNameAccess xNameAccess, String string) {
        Object var2_2 = null;
        return Configuration.getChildNodebyDisplayName(xNameAccess, string, PropertyNames.PROPERTY_NAME);
    }

    public static XNameAccess getChildNodebyDisplayName(XNameAccess xNameAccess, String string, String string2) {
        String[] stringArray = null;
        try {
            stringArray = xNameAccess.getElementNames();
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = (String)Helper.getUnoPropertyValue(xNameAccess.getByName(stringArray[i]), string2);
                if (!string3.equals(string)) continue;
                return (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xNameAccess.getByName(stringArray[i]));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return null;
    }

    public static XNameAccess getChildNodebyDisplayName(XMultiServiceFactory xMultiServiceFactory, Locale locale, XNameAccess xNameAccess, String string, String string2, int n) {
        String[] stringArray = null;
        try {
            stringArray = xNameAccess.getElementNames();
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = (String)Helper.getUnoPropertyValue(xNameAccess.getByName(stringArray[i]), string2);
                if (n > 0 && n < string3.length()) {
                    string3 = string3.substring(0, n);
                }
                if (!(string3 = Desktop.removeSpecialCharacters(xMultiServiceFactory, locale, string3)).equals(string)) continue;
                return (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xNameAccess.getByName(stringArray[i]));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return null;
    }
}

