/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui.event;

import com.sun.star.wizards.ui.event.TaskEvent;
import com.sun.star.wizards.ui.event.TaskListener;
import java.util.ArrayList;
import java.util.List;

public class Task {
    private int successfull = 0;
    private int failed = 0;
    private int max = 0;
    private String taskName;
    private List<TaskListener> listeners = new ArrayList<TaskListener>();
    private String subtaskName;

    public Task(String string, String string2, int n) {
        this.taskName = string;
        this.subtaskName = string2;
        this.max = n;
    }

    public void start() {
        this.fireTaskStarted();
    }

    public void fail() {
        this.fireTaskFailed();
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int n) {
        this.max = n;
        this.fireTaskStatusChanged();
    }

    public void advance(boolean bl) {
        if (bl) {
            ++this.successfull;
        } else {
            ++this.failed;
        }
        this.fireTaskStatusChanged();
        if (this.failed + this.successfull == this.max) {
            this.fireTaskFinished();
        }
    }

    public void advance(boolean bl, String string) {
        this.advance(bl);
        this.setSubtaskName(string);
    }

    public int getStatus() {
        return this.successfull + this.failed;
    }

    public void addTaskListener(TaskListener taskListener) {
        this.listeners.add(taskListener);
    }

    public void removeTaskListener(TaskListener taskListener) {
        this.listeners.remove(taskListener);
    }

    protected void fireTaskStatusChanged() {
        TaskEvent taskEvent = new TaskEvent(this, 3);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).taskStatusChanged(taskEvent);
        }
    }

    protected void fireTaskStarted() {
        TaskEvent taskEvent = new TaskEvent(this, 1);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).taskStarted(taskEvent);
        }
    }

    protected void fireTaskFailed() {
        TaskEvent taskEvent = new TaskEvent(this, 5);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).taskFinished(taskEvent);
        }
    }

    protected void fireTaskFinished() {
        TaskEvent taskEvent = new TaskEvent(this, 2);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).taskFinished(taskEvent);
        }
    }

    protected void fireSubtaskNameChanged() {
        TaskEvent taskEvent = new TaskEvent(this, 4);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).subtaskNameChanged(taskEvent);
        }
    }

    public String getSubtaskName() {
        return this.subtaskName;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setSubtaskName(String string) {
        this.subtaskName = string;
        this.fireSubtaskNameChanged();
    }

    public int getFailed() {
        return this.failed;
    }

    public int getSuccessfull() {
        return this.successfull;
    }
}

