/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.report.pentaho.parser.rpt;

import com.sun.star.report.pentaho.model.ReportElement;
import com.sun.star.report.pentaho.parser.ElementReadHandler;
import com.sun.star.report.pentaho.parser.rpt.ConditionalPrintExpressionReadHandler;
import com.sun.star.report.pentaho.parser.rpt.FormatConditionReadHandler;
import org.jfree.report.structure.Element;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReportElementReadHandler
extends ElementReadHandler {
    private final ReportElement element;

    public ReportElementReadHandler(ReportElement reportElement) {
        if (reportElement == null) {
            throw new NullPointerException();
        }
        this.element = reportElement;
    }

    public Element getElement() {
        return this.element;
    }

    protected void startParsing(Attributes attributes) throws SAXException {
        super.startParsing(attributes);
        String string = attributes.getValue("http://openoffice.org/2005/report", "print-when-group-change");
        this.element.setPrintWhenGroupChange("true".equals(string));
        String string2 = attributes.getValue("http://openoffice.org/2005/report", "print-repeated-values");
        this.element.setPrintRepeatedValues(string2 == null || "true".equals(string2));
    }

    protected XmlReadHandler getHandlerForChild(String string, String string2, Attributes attributes) throws SAXException {
        if (!"http://openoffice.org/2005/report".equals(string)) {
            return null;
        }
        if ("conditional-print-expression".equals(string2)) {
            return new ConditionalPrintExpressionReadHandler(this.element);
        }
        if ("format-condition".equals(string2)) {
            return new FormatConditionReadHandler(this.element);
        }
        if ("report-component".equals(string2)) {
            return new IgnoreAnyChildReadHandler();
        }
        return null;
    }
}

