/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.java;

import com.sun.star.lib.uno.Proxy;
import com.sun.star.uno.IEnvironment;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public final class java_environment
implements IEnvironment {
    private static final Registry localObjects = new Registry();
    private final Object context;
    private final Registry proxies = new Registry();

    public java_environment(Object object) {
        this.context = object;
    }

    public Object getContext() {
        return this.context;
    }

    public String getName() {
        return "java";
    }

    public Object registerInterface(Object object, String[] stringArray, Type type) {
        if (stringArray[0] == null) {
            stringArray[0] = UnoRuntime.generateOid(object);
        }
        return (this.isProxy(object) ? this.proxies : localObjects).register(object, stringArray[0], type);
    }

    public void revokeInterface(String string, Type type) {
        if (!this.proxies.revoke(string, type)) {
            localObjects.revoke(string, type);
        }
    }

    public Object getRegisteredInterface(String string, Type type) {
        Object object = this.proxies.get(string, type);
        if (object == null) {
            object = localObjects.get(string, type);
        }
        return object;
    }

    public String getRegisteredObjectIdentifier(Object object) {
        return UnoRuntime.generateOid(object);
    }

    public void list() {
    }

    public void revokeAllProxies() {
        this.proxies.clear();
    }

    public boolean equals(Object object) {
        return false;
    }

    private boolean isProxy(Object object) {
        return object instanceof Proxy;
    }

    private static final class Registry {
        private final HashMap<String, Level1Entry> level1map = new HashMap();
        private final ReferenceQueue<Object> queue = new ReferenceQueue();

        private Registry() {
        }

        public synchronized Object register(Object object, String string, Type type) {
            Object t;
            Level2Entry level2Entry;
            this.cleanUp();
            Level1Entry level1Entry = this.level1map.get(string);
            if (level1Entry != null && (level2Entry = level1Entry.level2map.get(type)) != null && (t = level2Entry.get()) != null) {
                level2Entry.acquire();
                return t;
            }
            if (level1Entry == null) {
                level1Entry = new Level1Entry();
                this.level1map.put(string, level1Entry);
            }
            level1Entry.level2map.put(type, new Level2Entry(string, type, object, this.queue));
            return object;
        }

        public synchronized boolean revoke(String string, Type type) {
            Level1Entry level1Entry = this.level1map.get(string);
            Level2Entry level2Entry = null;
            if (level1Entry != null && (level2Entry = level1Entry.level2map.get(type)) != null && level2Entry.release()) {
                this.removeLevel2Entry(level1Entry, string, type);
            }
            this.cleanUp();
            return level2Entry != null;
        }

        public synchronized Object get(String string, Type type) {
            Level1Entry level1Entry = this.level1map.get(string);
            return level1Entry == null ? null : level1Entry.find(type);
        }

        public synchronized void clear() {
            this.level1map.clear();
            this.cleanUp();
        }

        private void cleanUp() {
            Level2Entry level2Entry;
            while ((level2Entry = (Level2Entry)this.queue.poll()) != null) {
                Level1Entry level1Entry = this.level1map.get(level2Entry.oid);
                if (level1Entry == null || level1Entry.level2map.get(level2Entry.type) != level2Entry) continue;
                this.removeLevel2Entry(level1Entry, level2Entry.oid, level2Entry.type);
            }
        }

        private void removeLevel2Entry(Level1Entry level1Entry, String string, Type type) {
            level1Entry.level2map.remove(type);
            if (level1Entry.level2map.isEmpty()) {
                this.level1map.remove(string);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class Level2Entry
        extends WeakReference<Object> {
            public final String oid;
            public final Type type;
            private int count = 1;

            public Level2Entry(String string, Type type, Object object, ReferenceQueue<Object> referenceQueue) {
                super(object, referenceQueue);
                this.oid = string;
                this.type = type;
            }

            public void acquire() {
                ++this.count;
            }

            public boolean release() {
                return --this.count == 0;
            }
        }

        private static final class Level1Entry {
            public final HashMap<Type, Level2Entry> level2map = new HashMap();

            private Level1Entry() {
            }

            public Object find(Type type) {
                Object object;
                Level2Entry level2Entry2 = this.level2map.get(type);
                if (level2Entry2 != null && (object = level2Entry2.get()) != null) {
                    return object;
                }
                for (Level2Entry level2Entry2 : this.level2map.values()) {
                    Object t;
                    if (!type.isSupertypeOf(level2Entry2.type) || (t = level2Entry2.get()) == null) continue;
                    return t;
                }
                return null;
            }
        }
    }
}

