/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxw.pocketword;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.converter.xml.ParaStyle;
import org.openoffice.xmerge.converter.xml.TextStyle;
import org.openoffice.xmerge.converter.xml.sxw.pocketword.DocumentDescriptor;
import org.openoffice.xmerge.converter.xml.sxw.pocketword.Paragraph;
import org.openoffice.xmerge.converter.xml.sxw.pocketword.PocketWordConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PocketWordDocument
implements Document,
PocketWordConstants {
    private String docName;
    private byte[] preamble;
    private ArrayList<Object> fonts;
    private DocumentDescriptor descriptor;
    private ArrayList<Paragraph> paragraphs;
    private Paragraph currentPara;
    private static final byte[] trailer = new byte[]{-126, 0, 9, 0, 3, 0, -126, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public PocketWordDocument(String string) {
        this.docName = this.trimDocumentName(string);
        this.preamble = new byte[52];
        this.fonts = new ArrayList();
        this.descriptor = new DocumentDescriptor();
        this.paragraphs = new ArrayList();
    }

    @Override
    public void read(InputStream inputStream) throws IOException {
        int n;
        if (inputStream == null) {
            throw new IOException("No input stream to convert");
        }
        int n2 = inputStream.read(this.preamble);
        if (n2 == -1) {
            System.err.println("Error:invalid input stream");
            return;
        }
        byte[] byArray = new byte[80];
        do {
            inputStream.read(byArray);
            String string = new String(byArray, 0, 64, "UTF-16LE");
            this.fonts.add(string.trim());
        } while (byArray[76] != 5 || byArray[77] != 0 || byArray[78] != 1 || byArray[79] != 0);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        for (int i = 0; i < byArray2.length; i += 4) {
            if (byArray2[i + 2] == -1 && byArray2[i + 3] == -1 && !bl) {
                n3 = i - 8;
                bl = true;
                continue;
            }
            if (byArray2[i + 2] != -1 || byArray2[i + 3] != -1 || !bl) continue;
            n4 = i - 8;
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            byteArrayOutputStream2.write(byArray2, n3, n4 - n3);
            this.paragraphs.add(new Paragraph(byteArrayOutputStream2.toByteArray()));
            bl = false;
            i -= 4;
        }
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        if (byArray2[byArray2.length - 19] == 0) {
            byteArrayOutputStream3.write(byArray2, n3, byArray2.length - n3 - 20);
        } else {
            byteArrayOutputStream3.write(byArray2, n3, byArray2.length - n3 - 18);
        }
        this.paragraphs.add(new Paragraph(byteArrayOutputStream3.toByteArray()));
    }

    private String trimDocumentName(String string) {
        String string2 = string.toLowerCase();
        if (string2.endsWith(".psw")) {
            int n = string.length();
            int n2 = n - ".psw".length();
            string = string.substring(0, n2);
        }
        return string;
    }

    public Iterator<Paragraph> getParagraphEnumeration() {
        return this.paragraphs.iterator();
    }

    @Override
    public String getName() {
        return this.docName;
    }

    @Override
    public String getFileName() {
        return new String(this.docName + ".psw");
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        Object object;
        int n;
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        this.initPreamble();
        dataOutputStream.write(this.preamble);
        this.loadFonts();
        for (n = 0; n < this.fonts.size(); ++n) {
            object = (ByteArrayOutputStream)this.fonts.get(n);
            dataOutputStream.write(((ByteArrayOutputStream)object).toByteArray());
        }
        for (n = 0; n < this.paragraphs.size(); ++n) {
            object = this.paragraphs.get(n);
            this.descriptor.addParagraph((short)((Paragraph)object).getTextLength(), ((Paragraph)object).getLines());
        }
        dataOutputStream.write(this.descriptor.getDescriptor());
        for (n = 0; n < this.paragraphs.size(); ++n) {
            object = this.paragraphs.get(n);
            if (n + 1 == this.paragraphs.size()) {
                ((Paragraph)object).setLastParagraph(true);
            }
            dataOutputStream.write(((Paragraph)object).getParagraphData());
        }
        if (dataOutputStream.size() % 4 == 0) {
            dataOutputStream.write(0);
            dataOutputStream.write(0);
        }
        dataOutputStream.write(trailer);
        dataOutputStream.flush();
        dataOutputStream.close();
    }

    public void addParagraph(ParaStyle paraStyle, boolean bl) {
        Paragraph paragraph = new Paragraph(paraStyle);
        this.paragraphs.add(paragraph);
        this.currentPara = paragraph;
        if (bl) {
            paragraph.setBullets(true);
        }
    }

    public void addParagraphData(String string, TextStyle textStyle) {
        if (this.currentPara == null) {
            this.addParagraph(null, false);
        }
        this.currentPara.addTextSegment(string, textStyle);
    }

    private void initPreamble() {
        this.preamble = new byte[]{123, 92, 112, 119, 105, 21, 0, 0, 1, 1, 6, 0, 0, 0, 0, 0, 2, 0, 44, 0, 1, 0, 10, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private void loadFonts() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(new String("Tahoma").getBytes("UTF-16LE"));
            byteArrayOutputStream.write(new byte[52]);
            byteArrayOutputStream.write(new byte[]{2, 0, 1, 0});
            byteArrayOutputStream.write(new byte[]{0, 0, 1, 0});
            byteArrayOutputStream.write(new byte[]{0, 0, 0, 0});
            byteArrayOutputStream.write(new byte[]{0, 0, 0, 0});
            this.fonts.add(byteArrayOutputStream);
            byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(new String("Courier New").getBytes("UTF-16LE"));
            byteArrayOutputStream.write(new byte[42]);
            byteArrayOutputStream.write(new byte[]{20, 0, 4, 0});
            byteArrayOutputStream.write(new byte[]{1, 0, 0, 0});
            byteArrayOutputStream.write(new byte[]{0, 0, 21, 0});
            byteArrayOutputStream.write(new byte[]{5, 0, 1, 0});
            this.fonts.add(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

