/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.converter.xml.sxc.BookSettings;
import org.openoffice.xmerge.converter.xml.sxc.ColumnRowInfo;
import org.openoffice.xmerge.converter.xml.sxc.Format;
import org.openoffice.xmerge.converter.xml.sxc.NameDefinition;
import org.openoffice.xmerge.converter.xml.sxc.SpreadsheetDecoder;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.CellValue;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.ColInfo;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.DefinedName;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.ExtendedFormat;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.FloatNumber;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.FontDescription;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Formula;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Row;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Workbook;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Worksheet;
import org.openoffice.xmerge.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PocketExcelDecoder
extends SpreadsheetDecoder {
    private Workbook wb;
    private Worksheet ws;
    private CellValue cell;
    private int maxRows = 0;
    private int maxCols = 0;
    private int wsIndex;
    private Iterator<BIFFRecord> cellValue;
    private Format fmt = new Format();

    PocketExcelDecoder() {
    }

    @Override
    public void addDeviceContent(ConvertData convertData) throws IOException {
        Iterator<Object> iterator = convertData.getDocumentEnumeration();
        this.wb = (Workbook)iterator.next();
    }

    @Override
    public int getNumberOfSheets() {
        ArrayList<Object> arrayList = this.wb.getWorksheetNames();
        Debug.log(4, "Total Number of Sheets : " + arrayList.size());
        return arrayList.size();
    }

    @Override
    public Iterator<NameDefinition> getNameDefinitions() {
        Iterator<DefinedName> iterator = this.wb.getDefinedNames();
        ArrayList<NameDefinition> arrayList = new ArrayList<NameDefinition>();
        while (iterator.hasNext()) {
            DefinedName definedName = iterator.next();
            NameDefinition nameDefinition = definedName.getNameDefinition();
            arrayList.add(nameDefinition);
        }
        Debug.log(4, "Getting " + arrayList.size() + " DefinedName records");
        return arrayList.iterator();
    }

    @Override
    public BookSettings getSettings() {
        return this.wb.getSettings();
    }

    @Override
    public Iterator<ColumnRowInfo> getColumnRowInfos() {
        ColumnRowInfo columnRowInfo;
        int n;
        BIFFRecord bIFFRecord;
        ArrayList<ColumnRowInfo> arrayList = new ArrayList<ColumnRowInfo>();
        Iterator<BIFFRecord> iterator = this.ws.getColInfos();
        while (iterator.hasNext()) {
            bIFFRecord = iterator.next();
            n = ((ColInfo)bIFFRecord).getLast() - ((ColInfo)bIFFRecord).getFirst() + 1;
            columnRowInfo = new ColumnRowInfo(((ColInfo)bIFFRecord).getColWidth(), n, 1);
            arrayList.add(columnRowInfo);
        }
        iterator = this.ws.getRows();
        while (iterator.hasNext()) {
            bIFFRecord = (Row)iterator.next();
            n = ((Row)bIFFRecord).getRowNumber();
            columnRowInfo = new ColumnRowInfo(((Row)bIFFRecord).getRowHeight(), n, 2);
            arrayList.add(columnRowInfo);
        }
        Debug.log(4, "Getting " + arrayList.size() + " ColRowInfo records");
        return arrayList.iterator();
    }

    @Override
    public void setWorksheet(int n) throws IOException {
        Debug.log(4, "Setting to worksheet : " + n);
        this.ws = this.wb.getWorksheet(n);
        this.cellValue = this.ws.getCellEnumerator();
        this.wsIndex = n;
        while (this.goToNextCell()) {
            this.maxRows = Math.max(this.maxRows, this.cell.getRow());
            this.maxCols = Math.max(this.maxCols, this.cell.getCol());
        }
        this.cellValue = this.ws.getCellEnumerator();
        Debug.log(4, "Max Cols : " + this.maxCols + " MaxRows : " + this.maxRows);
    }

    @Override
    public String getSheetName() {
        String string = this.wb.getSheetName(this.wsIndex);
        Debug.log(4, "The name of the current Worksheet is : " + string);
        return string;
    }

    @Override
    public boolean goToNextCell() throws IOException {
        boolean bl = false;
        try {
            this.cell = (CellValue)this.cellValue.next();
            Debug.log(4, "Current Cell : " + this.cell.getString());
            this.readCellFormat();
            bl = true;
        }
        catch (NoSuchElementException noSuchElementException) {
            Debug.log(4, "Could't find current cell");
        }
        return bl;
    }

    @Override
    public int getRowNumber() {
        int n = -1;
        if (this.cell != null) {
            n = this.cell.getRow();
            Debug.log(4, "cell row is " + n);
        }
        return n;
    }

    @Override
    public int getNumberOfRows() {
        return this.maxRows;
    }

    @Override
    public int getNumberOfColumns() {
        return this.maxCols;
    }

    @Override
    public int getColNumber() {
        int n = -1;
        if (this.cell != null) {
            n = this.cell.getCol();
            Debug.log(4, "cell col is " + n);
        }
        return n;
    }

    @Override
    public String getCellContents() {
        String string = new String("");
        if (this.cell != null) {
            try {
                string = this.cell.getString();
                if (string.startsWith("=")) {
                    string = this.parseFormula(string);
                }
            }
            catch (IOException iOException) {
                System.err.println("Could Not retrieve Cell contents");
                System.err.println("Setting contents of cell(" + this.cell.getRow() + "," + this.cell.getCol() + ") to an empty string");
                System.err.println("Error msg: " + iOException.getMessage());
            }
        }
        return string;
    }

    protected String parseFormula(String string) {
        string = string.replace(',', ';');
        string = string.replace('!', '.');
        return string;
    }

    @Override
    public String getCellValue() {
        String string = new String("");
        if (this.cell != null) {
            try {
                string = ((Formula)this.cell).getValue();
            }
            catch (IOException iOException) {
                System.err.println("Could Not retrieve Cell value");
                System.err.println("Setting value of cell(" + this.cell.getRow() + "," + this.cell.getCol() + ") to an empty string");
                System.err.println("Error msg: " + iOException.getMessage());
            }
        }
        return string;
    }

    @Override
    public String getCellDataType() {
        String string = "string";
        if (this.cell instanceof FloatNumber) {
            string = "float";
        }
        if (this.cell instanceof Formula) {
            string = "float";
        }
        return string;
    }

    @Override
    public Format getCellFormat() {
        return new Format(this.fmt);
    }

    private void readCellFormat() throws IOException {
        this.fmt.clearFormatting();
        Debug.log(4, " ixfe for Current Cell " + this.cell.getIxfe());
        ExtendedFormat extendedFormat = this.wb.getExtendedFormat(this.cell.getIxfe());
        Debug.log(4, " ixfnt for Current Cell " + extendedFormat.getFontIndex());
        FontDescription fontDescription = this.wb.getFontDescription(extendedFormat.getFontIndex());
        this.fmt.setAttribute(2, fontDescription.isItalic());
        this.fmt.setAttribute(1, fontDescription.isBold());
        this.fmt.setAttribute(4, fontDescription.isUnderline());
        this.fmt.setForeground(fontDescription.getForeground());
        this.fmt.setBackground(extendedFormat.getBackground());
        this.fmt.setAlign(extendedFormat.getAlign());
        this.fmt.setVertAlign(extendedFormat.getVertAlign());
        this.fmt.setAttribute(1024, extendedFormat.isWordWrap());
        this.fmt.setAttribute(256, extendedFormat.isBorder(1));
        this.fmt.setAttribute(512, extendedFormat.isBorder(4));
        this.fmt.setAttribute(128, extendedFormat.isBorder(8));
        this.fmt.setAttribute(64, extendedFormat.isBorder(2));
        this.fmt.setFontName(fontDescription.getFont());
        this.fmt.setFontSize(fontDescription.getFontSize());
        this.fmt.setCategory(this.getCellDataType());
    }
}

