/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class DefColWidth
implements BIFFRecord {
    private byte[] grbit = new byte[2];
    private byte[] coldx = new byte[2];
    private byte[] ixfe = new byte[2];

    public DefColWidth() {
        this.grbit = new byte[]{0, 0};
        this.coldx = new byte[]{0, 9};
        this.ixfe = new byte[]{0, 0};
    }

    public DefColWidth(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public short getBiffType() {
        return 85;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        outputStream.write(this.grbit);
        outputStream.write(this.coldx);
        outputStream.write(this.ixfe);
        Debug.log(4, "Writing DefColWidth record");
    }

    public int read(InputStream inputStream) throws IOException {
        int n = inputStream.read(this.grbit);
        n += inputStream.read(this.coldx);
        n += inputStream.read(this.ixfe);
        Debug.log(4, "\tgrbit : " + EndianConverter.readShort(this.grbit) + " coldx : " + EndianConverter.readShort(this.coldx) + " ixfe : " + EndianConverter.readShort(this.ixfe));
        return 0;
    }
}

