/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class Window1
implements BIFFRecord {
    private byte[] grbit = new byte[2];
    private byte[] itabCur = new byte[2];

    public Window1() {
        this.grbit = EndianConverter.writeShort((short)0);
        this.itabCur = EndianConverter.writeShort((short)0);
    }

    public Window1(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public void setActiveSheet(int n) {
        this.itabCur = EndianConverter.writeShort((short)n);
    }

    public int getActiveSheet() {
        return EndianConverter.readShort(this.itabCur);
    }

    public short getBiffType() {
        return 61;
    }

    public int read(InputStream inputStream) throws IOException {
        int n = inputStream.read(this.grbit);
        Debug.log(4, "\tgrbit : " + EndianConverter.readShort(this.grbit) + " itabCur : " + EndianConverter.readShort(this.itabCur));
        return n += inputStream.read(this.itabCur);
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        outputStream.write(this.grbit);
        outputStream.write(this.itabCur);
        Debug.log(4, "Writing Window1 record");
    }
}

