/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.sxc.BookSettings;
import org.openoffice.xmerge.converter.xml.sxc.ColumnRowInfo;
import org.openoffice.xmerge.converter.xml.sxc.Format;
import org.openoffice.xmerge.converter.xml.sxc.NameDefinition;
import org.openoffice.xmerge.converter.xml.sxc.SheetSettings;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BeginningOfFile;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BlankCell;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BoolErrCell;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BoundSheet;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.CodePage;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.ColInfo;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.DefinedName;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Eof;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.ExtendedFormat;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.FloatNumber;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.FontDescription;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Formula;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.LabelCell;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Row;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.StringValue;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Window1;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Worksheet;
import org.openoffice.xmerge.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workbook
implements Document,
OfficeConstants {
    private ArrayList<FontDescription> fonts = new ArrayList();
    private ArrayList<ExtendedFormat> extendedFormats = new ArrayList();
    private ArrayList<Worksheet> worksheets = new ArrayList();
    private ArrayList<BoundSheet> boundsheets = new ArrayList();
    private ArrayList<DefinedName> definedNames = new ArrayList();
    private static final CodePage cp = new CodePage();
    private static final Window1 win1 = new Window1();
    private static final BeginningOfFile bof = new BeginningOfFile(true);
    private static final Eof eof = new Eof();
    private String fileName;

    public Workbook(String string) throws IOException {
        this.fileName = string + ".pxl";
        Format format = new Format();
        FontDescription fontDescription = new FontDescription(format);
        this.fonts.add(fontDescription);
        ExtendedFormat extendedFormat = new ExtendedFormat(0, format);
        this.extendedFormats.add(extendedFormat);
    }

    public Workbook(String string, InputStream inputStream) throws IOException {
        this.read(inputStream);
        this.fileName = string;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        bof.write(outputStream);
        cp.write(outputStream);
        for (DefinedName object : this.definedNames) {
            object.write(outputStream);
        }
        win1.write(outputStream);
        for (FontDescription fontDescription : this.fonts) {
            fontDescription.write(outputStream);
        }
        for (ExtendedFormat extendedFormat : this.extendedFormats) {
            extendedFormat.write(outputStream);
        }
        for (BoundSheet boundSheet : this.boundsheets) {
            boundSheet.write(outputStream);
        }
        eof.write(outputStream);
        for (Worksheet worksheet : this.worksheets) {
            worksheet.write(outputStream);
        }
    }

    @Override
    public void read(InputStream inputStream) throws IOException {
        boolean bl = false;
        int n = 0;
        block10: while (!bl) {
            n = inputStream.read();
            if (n == -1) {
                Debug.log(4, "End of file reached");
                break;
            }
            switch (n) {
                case 24: {
                    Debug.log(4, "NAME: Defined Name (18h)");
                    DefinedName definedName = new DefinedName(inputStream, this);
                    this.definedNames.add(definedName);
                    continue block10;
                }
                case 9: {
                    Debug.log(4, "BOF Record");
                    bof.read(inputStream);
                    continue block10;
                }
                case 10: {
                    Debug.log(4, "EOF Marker");
                    eof.read(inputStream);
                    Worksheet worksheet = new Worksheet(this);
                    while (worksheet.read(inputStream)) {
                        this.worksheets.add(worksheet);
                        worksheet = new Worksheet(this);
                    }
                    continue block10;
                }
                case 49: {
                    Debug.log(4, "FONT: Font Description (31h)");
                    FontDescription fontDescription = new FontDescription(inputStream);
                    this.fonts.add(fontDescription);
                    continue block10;
                }
                case 61: {
                    Debug.log(4, "WINDOW1: Window Information (3Dh) [PXL 2.0]");
                    win1.read(inputStream);
                    continue block10;
                }
                case 66: {
                    Debug.log(4, "CODEPAGE : Codepage and unknown fields (42h)");
                    cp.read(inputStream);
                    continue block10;
                }
                case 133: {
                    Debug.log(4, "BOUNDSHEET: Sheet Information (85h)");
                    BoundSheet boundSheet = new BoundSheet(inputStream);
                    this.boundsheets.add(boundSheet);
                    continue block10;
                }
                case 224: {
                    Debug.log(4, "XF: Extended Format (E0h) [PXL 2.0]");
                    ExtendedFormat extendedFormat = new ExtendedFormat(inputStream);
                    this.extendedFormats.add(extendedFormat);
                    continue block10;
                }
            }
            n = inputStream.read();
        }
        inputStream.close();
    }

    public int addFont(FontDescription fontDescription) {
        boolean bl = false;
        int n = 0;
        for (FontDescription fontDescription2 : this.fonts) {
            if (fontDescription2.compareTo(fontDescription)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.fonts.add(fontDescription);
        }
        return n;
    }

    public int addExtendedFormat(Format format) throws IOException {
        FontDescription fontDescription = new FontDescription(format);
        int n = this.addFont(fontDescription);
        ExtendedFormat extendedFormat = new ExtendedFormat(n, format);
        boolean bl = false;
        int n2 = 0;
        for (ExtendedFormat extendedFormat2 : this.extendedFormats) {
            if (extendedFormat.compareTo(extendedFormat2)) {
                bl = true;
                break;
            }
            if (bl) continue;
            ++n2;
        }
        if (!bl) {
            this.extendedFormats.add(extendedFormat);
        }
        return n2;
    }

    public Worksheet getWorksheet(int n) {
        return this.worksheets.get(n);
    }

    public FontDescription getFontDescription(int n) {
        return this.fonts.get(n);
    }

    public ExtendedFormat getExtendedFormat(int n) {
        return this.extendedFormats.get(n);
    }

    public Iterator<DefinedName> getDefinedNames() {
        return this.definedNames.iterator();
    }

    public BookSettings getSettings() {
        ArrayList<SheetSettings> arrayList = new ArrayList<SheetSettings>();
        int n = 0;
        for (Worksheet object2 : this.worksheets) {
            SheetSettings sheetSettings = object2.getSettings();
            sheetSettings.setSheetName(this.getSheetName(n++));
            arrayList.add(sheetSettings);
        }
        BookSettings bookSettings = new BookSettings(arrayList);
        String string = this.getSheetName(win1.getActiveSheet());
        bookSettings.setActiveSheet(string);
        return bookSettings;
    }

    public ArrayList<Object> getWorksheetNames() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.boundsheets.size(); ++i) {
            arrayList.add(this.getSheetName(i));
        }
        return arrayList;
    }

    public String getSheetName(int n) {
        BoundSheet boundSheet = this.boundsheets.get(n);
        return boundSheet.getSheetName();
    }

    public void addWorksheet(String string) throws IOException {
        BoundSheet boundSheet = new BoundSheet(string);
        this.boundsheets.add(boundSheet);
        Worksheet worksheet = new Worksheet();
        this.worksheets.add(worksheet);
    }

    public void addCell(int n, int n2, Format format, String string) throws IOException {
        Worksheet worksheet = this.worksheets.get(this.worksheets.size() - 1);
        int n3 = this.addExtendedFormat(format);
        String string2 = format.getCategory();
        Debug.log(4, "Cell Format: " + format);
        Debug.log(4, "Row : " + n);
        Debug.log(4, "Col : " + n2);
        if (string.startsWith("=")) {
            try {
                Formula formula = new Formula(n, n2, string, n3, format, this);
                worksheet.addCell(formula);
                if (string2.equalsIgnoreCase("string")) {
                    StringValue stringValue = new StringValue(format.getValue());
                    worksheet.addCell(stringValue);
                }
            }
            catch (Exception exception) {
                Debug.log(4, "Parsing Exception thrown : " + exception.getMessage());
                BoolErrCell boolErrCell = new BoolErrCell(n, n2, n3, 42, 1);
                worksheet.addCell(boolErrCell);
            }
        } else if (string2.equalsIgnoreCase("float")) {
            try {
                FloatNumber floatNumber = new FloatNumber(n, n2, string, n3);
                worksheet.addCell(floatNumber);
            }
            catch (Exception exception) {
                Debug.log(4, "Error could not parse Float " + string);
                LabelCell labelCell = new LabelCell(n, n2, string, n3);
                worksheet.addCell(labelCell);
            }
        } else if (string.length() == 0) {
            Debug.log(4, "Blank Cell");
            BlankCell blankCell = new BlankCell(n, n2, n3);
            worksheet.addCell(blankCell);
        } else {
            Debug.log(4, "Label Cell : " + string);
            LabelCell labelCell = new LabelCell(n, n2, string, n3);
            worksheet.addCell(labelCell);
        }
    }

    public void addColInfo(ArrayList<ColumnRowInfo> arrayList) throws IOException {
        Worksheet worksheet = this.worksheets.get(this.worksheets.size() - 1);
        int n = 0;
        int n2 = 0;
        Debug.log(4, "Workbook: addColInfo()");
        for (ColumnRowInfo columnRowInfo : arrayList) {
            int n3 = 0;
            int n4 = columnRowInfo.getSize();
            int n5 = columnRowInfo.getRepeated();
            if (columnRowInfo.isColumn()) {
                Debug.log(4, "Workbook: adding ColInfo width = " + n4);
                ColInfo colInfo = new ColInfo(n, n + n5 - 1, n4, n3);
                worksheet.addCol(colInfo);
                n += n5;
                continue;
            }
            if (!columnRowInfo.isRow()) continue;
            Debug.log(4, "Workbook: adding Row Height = " + n4);
            if (!columnRowInfo.isDefaultSize()) {
                for (int i = 0; i < n5; ++i) {
                    Row row = new Row(n2++, n4, columnRowInfo.isUserDefined());
                    worksheet.addRow(row);
                }
                continue;
            }
            n2 += n5;
        }
    }

    public void addNameDefinition(NameDefinition nameDefinition) throws IOException {
        DefinedName definedName = new DefinedName(nameDefinition, this);
        this.definedNames.add(definedName);
    }

    public void addSettings(BookSettings bookSettings) throws IOException {
        int n = 0;
        ArrayList<SheetSettings> arrayList = bookSettings.getSheetSettings();
        String string = bookSettings.getActiveSheet();
        for (Worksheet worksheet : this.worksheets) {
            String string2;
            if (string.equals(string2 = this.getSheetName(n++))) {
                win1.setActiveSheet(n - 1);
            }
            for (SheetSettings sheetSettings : arrayList) {
                if (!string2.equals(sheetSettings.getSheetName())) continue;
                worksheet.addSettings(sheetSettings);
            }
        }
    }

    @Override
    public String getName() {
        int n = this.fileName.lastIndexOf(".");
        String string = n >= 0 ? this.fileName.substring(0, n) : this.fileName;
        return string;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }
}

