/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Stack;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.Token;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.TokenFactory;
import org.openoffice.xmerge.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormulaCompiler {
    private boolean isPercent(Token token) {
        return token.getTokenID() == 20;
    }

    private boolean isOpenBrace(Token token) {
        return token.getTokenID() == 21;
    }

    private boolean isCloseBrace(Token token) {
        return token.getValue().compareTo(")") == 0;
    }

    private boolean isParamDelimiter(Token token) {
        return token.getTokenID() == 4097;
    }

    public ArrayList<Token> RPN2Infix(ArrayList<Token> arrayList) {
        ListIterator<Token> listIterator = arrayList.listIterator();
        Stack stack = new Stack();
        Stack<ArrayList<Token>> stack2 = new Stack<ArrayList<Token>>();
        while (listIterator.hasNext()) {
            Token token = listIterator.next();
            if (token.isOperand()) {
                ArrayList<Token> arrayList2 = new ArrayList<Token>(5);
                arrayList2.add(token);
                stack.push(arrayList2);
                continue;
            }
            if (!token.isOperator() && !token.isFunction()) continue;
            stack2.clear();
            for (int i = 0; i < token.getNumArgs(); ++i) {
                stack2.push((ArrayList<Token>)stack.pop());
            }
            stack.push(this.makeExpression(token, stack2));
        }
        return (ArrayList)stack.elementAt(0);
    }

    public ArrayList<Token> infix2RPN(ArrayList<Token> arrayList) {
        Token token;
        ArrayList<Token> arrayList2 = new ArrayList<Token>(15);
        Stack<Token> stack = new Stack<Token>();
        ListIterator<Token> listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            Object object;
            token = listIterator.next();
            if (token.isOperand()) {
                arrayList2.add(token);
                continue;
            }
            if (token.isFunction() || this.isParamDelimiter(token) || this.isOpenBrace(token)) {
                stack.push(token);
                if (token.isFunction()) {
                    listIterator.next();
                }
                object = this.extractParameter(listIterator);
                Debug.log(4, "Extracted parameter " + object);
                arrayList2.addAll(this.infix2RPN((ArrayList<Token>)object));
                continue;
            }
            if (this.isCloseBrace(token)) {
                object = null;
                boolean bl = true;
                while (bl) {
                    if (stack.isEmpty()) {
                        bl = false;
                        continue;
                    }
                    object = (Token)stack.pop();
                    if (!this.isParamDelimiter((Token)object)) {
                        arrayList2.add((Token)object);
                    }
                    if (!((Token)object).isFunction() && !this.isOpenBrace((Token)object)) continue;
                    bl = false;
                }
                continue;
            }
            if (!stack.isEmpty()) {
                while (!(stack.isEmpty() || ((Token)stack.peek()).getTokenPriority() < token.getTokenPriority() || ((Token)(object = (Token)stack.peek())).isFunction() || this.isOpenBrace((Token)object))) {
                    arrayList2.add((Token)stack.pop());
                }
            }
            stack.push(token);
        }
        while (!stack.isEmpty()) {
            token = (Token)stack.peek();
            if (!this.isOpenBrace(token) && !this.isParamDelimiter(token)) {
                arrayList2.add((Token)stack.pop());
                continue;
            }
            stack.pop();
        }
        return arrayList2;
    }

    protected ArrayList<Token> extractParameter(ListIterator<Token> listIterator) {
        ArrayList<Token> arrayList = new ArrayList<Token>(5);
        int n = 0;
        while (listIterator.hasNext()) {
            Token token = listIterator.next();
            Debug.log(4, "Token is " + token + " and subExprCount is " + n);
            if (this.isOpenBrace(token)) {
                ++n;
                arrayList.add(token);
                continue;
            }
            if (this.isCloseBrace(token)) {
                if (n == 0) {
                    listIterator.previous();
                    return arrayList;
                }
                --n;
                arrayList.add(token);
                continue;
            }
            if (this.isParamDelimiter(token) && n == 0) {
                listIterator.previous();
                return arrayList;
            }
            arrayList.add(token);
        }
        return arrayList;
    }

    protected ArrayList<Token> makeExpression(Token token, Stack<ArrayList<Token>> stack) {
        ArrayList<Token> arrayList = new ArrayList<Token>(5);
        TokenFactory tokenFactory = new TokenFactory();
        if (token.isOperator()) {
            if (token.getNumArgs() == 2) {
                arrayList.addAll((Collection<Token>)stack.pop());
                arrayList.add(token);
                arrayList.addAll((Collection<Token>)stack.pop());
            } else if (token.getNumArgs() == 1) {
                if (this.isPercent(token)) {
                    arrayList.addAll((Collection)stack.elementAt(0));
                    arrayList.add(token);
                } else {
                    arrayList.add(token);
                    arrayList.addAll((Collection)stack.elementAt(0));
                }
                if (this.isOpenBrace(token)) {
                    arrayList.add(tokenFactory.getOperatorToken(")", 1));
                }
            }
        } else if (token.isFunction()) {
            ArrayList<Token> arrayList2;
            arrayList.add(token);
            arrayList.add(tokenFactory.getOperatorToken("(", 1));
            if (!stack.isEmpty()) {
                arrayList2 = stack.pop();
                arrayList.addAll(arrayList2);
            }
            while (!stack.isEmpty()) {
                arrayList.add(tokenFactory.getOperatorToken(",", 1));
                arrayList2 = stack.pop();
                arrayList.addAll(arrayList2);
            }
            arrayList.add(tokenFactory.getOperatorToken(")", 1));
        }
        return arrayList;
    }
}

