/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import processing.app.Base;
import processing.app.EditorConsole;
import processing.app.EditorHeader;
import processing.app.EditorLineStatus;
import processing.app.EditorStatus;
import processing.app.EditorToolbar;
import processing.app.FindReplace;
import processing.app.Formatter;
import processing.app.Mode;
import processing.app.Preferences;
import processing.app.RunnerListener;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.SketchException;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.PdeTextAreaDefaults;
import processing.app.syntax.SyntaxDocument;
import processing.app.syntax.TextAreaPainter;
import processing.app.tools.Tool;
import processing.core.PApplet;

public abstract class Editor
extends JFrame
implements RunnerListener {
    protected Base base;
    protected Mode mode;
    protected static final String EMPTY = "                                                                                                                                                                                                               ";
    boolean untitled;
    private PageFormat pageFormat;
    private PrinterJob printerJob;
    private JMenu fileMenu;
    private JMenuItem saveMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenu sketchMenu;
    protected EditorHeader header;
    protected EditorToolbar toolbar;
    protected JEditTextArea textarea;
    protected EditorStatus status;
    protected JSplitPane splitPane;
    protected JPanel consolePanel;
    protected EditorConsole console;
    protected EditorLineStatus lineStatus;
    protected Sketch sketch;
    private Point sketchWindowLocation;
    private JMenuItem undoItem;
    private JMenuItem redoItem;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    private UndoManager undo;
    private CompoundEdit compoundEdit;
    private final Stack<Integer> caretUndoStack = new Stack();
    private final Stack<Integer> caretRedoStack = new Stack();
    private FindReplace find;
    JMenu modeMenu;

    protected Editor(final Base base, String path, int[] location, final Mode mode) {
        super("Processing");
        this.base = base;
        this.mode = mode;
        Base.setIcon(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                base.handleClose(Editor.this, false);
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                base.handleActivated(Editor.this);
                Editor.this.fileMenu.insert(base.getSketchbookMenu(), 2);
                Editor.this.sketchMenu.insert(mode.getImportMenu(), 4);
            }

            public void windowDeactivated(WindowEvent e) {
                Editor.this.fileMenu.remove(base.getSketchbookMenu());
                Editor.this.sketchMenu.remove(mode.getImportMenu());
            }
        });
        this.buildMenuBar();
        Container contentPain = this.getContentPane();
        contentPain.setLayout(new BorderLayout());
        JPanel pain = new JPanel();
        pain.setLayout(new BorderLayout());
        contentPain.add((Component)pain, "Center");
        Box box = Box.createVerticalBox();
        Box upper = Box.createVerticalBox();
        this.initModeMenu();
        this.toolbar = this.createToolbar();
        upper.add(this.toolbar);
        this.header = new EditorHeader(this);
        upper.add(this.header);
        this.textarea = new JEditTextArea(new PdeTextAreaDefaults(mode));
        this.textarea.setRightClickPopup(new TextAreaPopup());
        this.textarea.setHorizontalOffset(6);
        this.consolePanel = new JPanel();
        this.consolePanel.setLayout(new BorderLayout());
        this.status = new EditorStatus(this);
        this.consolePanel.add((Component)this.status, "North");
        this.console = new EditorConsole(this);
        this.console.setBorder(null);
        this.consolePanel.add((Component)this.console, "Center");
        this.lineStatus = new EditorLineStatus(this);
        this.consolePanel.add((Component)this.lineStatus, "South");
        upper.add(this.textarea);
        this.splitPane = new JSplitPane(0, upper, this.consolePanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setBorder(null);
        int dividerSize = Preferences.getInteger("editor.divider.size");
        if (dividerSize != 0) {
            this.splitPane.setDividerSize(dividerSize);
        }
        box.add(this.splitPane);
        pain.add(box);
        this.textarea.addKeyListener(this.toolbar);
        pain.setTransferHandler(new FileDropHandler());
        this.pack();
        this.setPlacement(location);
        this.setMinimumSize(new Dimension(Preferences.getInteger("editor.window.width.min"), Preferences.getInteger("editor.window.height.min")));
        this.applyPreferences();
        this.addWindowFocusListener(new WindowAdapter(){

            public void windowGainedFocus(WindowEvent e) {
                Editor.this.textarea.requestFocusInWindow();
            }
        });
        boolean loaded = this.handleOpenInternal(path);
        if (!loaded) {
            this.sketch = null;
        }
    }

    public Base getBase() {
        return this.base;
    }

    public Mode getMode() {
        return this.mode;
    }

    protected void initModeMenu() {
        this.modeMenu = new JMenu();
        for (final Mode m : this.base.getModeList()) {
            JMenuItem item;
            if (this.mode == m) {
                item = new JCheckBoxMenuItem(m.getTitle());
                item.setSelected(true);
                this.modeMenu.add(item);
                continue;
            }
            item = new JMenuItem(m.getTitle());
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.base.changeMode(m);
                }
            });
            this.modeMenu.add(item);
        }
    }

    public JMenu getModeMenu() {
        return this.modeMenu;
    }

    public abstract EditorToolbar createToolbar();

    public abstract Formatter createFormatter();

    protected void setPlacement(int[] location) {
        this.setBounds(location[0], location[1], location[2], location[3]);
        if (location[4] != 0) {
            this.splitPane.setDividerLocation(location[4]);
        }
    }

    protected int[] getPlacement() {
        int[] location = new int[5];
        Rectangle bounds = this.getBounds();
        location[0] = bounds.x;
        location[1] = bounds.y;
        location[2] = bounds.width;
        location[3] = bounds.height;
        location[4] = this.splitPane.getDividerLocation();
        return location;
    }

    protected void applyPreferences() {
        boolean external = Preferences.getBoolean("editor.external");
        this.textarea.setEditable(!external);
        this.saveMenuItem.setEnabled(!external);
        this.saveAsMenuItem.setEnabled(!external);
        TextAreaPainter painter = this.textarea.getPainter();
        if (external) {
            Color color = this.mode.getColor("editor.external.bgcolor");
            painter.setBackground(color);
            painter.setLineHighlightEnabled(false);
            this.textarea.setCaretVisible(false);
        } else {
            Color color = this.mode.getColor("editor.bgcolor");
            painter.setBackground(color);
            boolean highlight = Preferences.getBoolean("editor.linehighlight");
            painter.setLineHighlightEnabled(highlight);
            this.textarea.setCaretVisible(true);
        }
        painter.setFont(Preferences.getFont("editor.font"));
    }

    protected void buildMenuBar() {
        JMenuBar menubar = new JMenuBar();
        menubar = new JMenuBar();
        this.fileMenu = this.buildFileMenu();
        menubar.add(this.fileMenu);
        menubar.add(this.buildEditMenu());
        menubar.add(this.buildSketchMenu());
        menubar.add(this.buildToolsMenu());
        JMenu modeMenu = this.buildModeMenu();
        if (modeMenu != null) {
            menubar.add(modeMenu);
        }
        menubar.add(this.buildHelpMenu());
        this.setJMenuBar(menubar);
    }

    public abstract JMenu buildFileMenu();

    protected JMenu buildFileMenu(JMenuItem[] exportItems) {
        JMenu fileMenu = new JMenu("File");
        JMenuItem item = Base.newJMenuItem("New", 78);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.base.handleNew();
            }
        });
        fileMenu.add(item);
        item = Base.newJMenuItem("Open...", 79);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.base.handleOpenPrompt();
            }
        });
        fileMenu.add(item);
        fileMenu.add(this.base.getSketchbookMenu());
        item = new JMenuItem("Examples...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.mode.showExamplesFrame();
            }
        });
        fileMenu.add(item);
        item = Base.newJMenuItem("Close", 87);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.base.handleClose(Editor.this, false);
            }
        });
        fileMenu.add(item);
        item = Base.newJMenuItem("Save", 83);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleSaveRequest(false);
            }
        });
        this.saveMenuItem = item;
        fileMenu.add(item);
        item = Base.newJMenuItemShift("Save As...", 83);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleSaveAs();
            }
        });
        this.saveAsMenuItem = item;
        fileMenu.add(item);
        if (exportItems != null) {
            for (JMenuItem ei : exportItems) {
                fileMenu.add(ei);
            }
        }
        fileMenu.addSeparator();
        item = Base.newJMenuItemShift("Page Setup", 80);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handlePageSetup();
            }
        });
        fileMenu.add(item);
        item = Base.newJMenuItem("Print", 80);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handlePrint();
            }
        });
        fileMenu.add(item);
        if (!Base.isMacOS()) {
            fileMenu.addSeparator();
            item = Base.newJMenuItem("Preferences", 44);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.base.handlePrefs();
                }
            });
            fileMenu.add(item);
            fileMenu.addSeparator();
            item = Base.newJMenuItem("Quit", 81);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.base.handleQuit();
                }
            });
            fileMenu.add(item);
        }
        return fileMenu;
    }

    protected JMenu buildEditMenu() {
        JMenu menu = new JMenu("Edit");
        this.undoItem = Base.newJMenuItem("Undo", 90);
        this.undoAction = new UndoAction();
        this.undoItem.addActionListener(this.undoAction);
        menu.add(this.undoItem);
        this.redoItem = Base.isWindows() ? Base.newJMenuItem("Redo", 89) : Base.newJMenuItemShift("Redo", 90);
        this.redoAction = new RedoAction();
        this.redoItem.addActionListener(this.redoAction);
        menu.add(this.redoItem);
        menu.addSeparator();
        JMenuItem item = Base.newJMenuItem("Cut", 88);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleCut();
            }
        });
        menu.add(item);
        item = Base.newJMenuItem("Copy", 67);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.textarea.copy();
            }
        });
        menu.add(item);
        item = Base.newJMenuItemShift("Copy as HTML", 67);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleCopyAsHTML();
            }
        });
        menu.add(item);
        item = Base.newJMenuItem("Paste", 86);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.textarea.paste();
                Editor.this.sketch.setModified(true);
            }
        });
        menu.add(item);
        item = Base.newJMenuItem("Select All", 65);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.textarea.selectAll();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = Base.newJMenuItem("Auto Format", 84);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleAutoFormat();
            }
        });
        menu.add(item);
        item = Base.newJMenuItem("Comment/Uncomment", 47);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleCommentUncomment();
            }
        });
        menu.add(item);
        item = Base.newJMenuItem("Increase Indent", 93);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleIndentOutdent(true);
            }
        });
        menu.add(item);
        item = Base.newJMenuItem("Decrease Indent", 91);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleIndentOutdent(false);
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = Base.newJMenuItem("Find...", 70);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Editor.this.find == null) {
                    Editor.this.find = new FindReplace(Editor.this);
                }
                Editor.this.find.setVisible(true);
            }
        });
        menu.add(item);
        item = Base.newJMenuItem("Find Next", 71);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Editor.this.find != null) {
                    Editor.this.find.findNext();
                }
            }
        });
        menu.add(item);
        item = Base.newJMenuItemShift("Find Previous", 71);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Editor.this.find != null) {
                    Editor.this.find.findPrevious();
                }
            }
        });
        menu.add(item);
        item = Base.newJMenuItemAlt("Use Selection for Find", 70);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Editor.this.find == null) {
                    Editor.this.find = new FindReplace(Editor.this);
                }
                Editor.this.find.setFindText(Editor.this.getSelectedText());
            }
        });
        menu.add(item);
        return menu;
    }

    public abstract JMenu buildSketchMenu();

    protected JMenu buildSketchMenu(JMenuItem[] runItems) {
        this.sketchMenu = new JMenu("Sketch");
        for (JMenuItem mi : runItems) {
            this.sketchMenu.add(mi);
        }
        this.sketchMenu.addSeparator();
        this.sketchMenu.add(this.mode.getImportMenu());
        JMenuItem item = Base.newJMenuItem("Show Sketch Folder", 75);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openFolder(Editor.this.sketch.getFolder());
            }
        });
        this.sketchMenu.add(item);
        item.setEnabled(Base.openFolderAvailable());
        item = new JMenuItem("Add File...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.sketch.handleAddFile();
            }
        });
        this.sketchMenu.add(item);
        return this.sketchMenu;
    }

    public abstract void handleImportLibrary(String var1);

    protected JMenu buildToolsMenu() {
        JMenu menu = new JMenu("Tools");
        this.addInternalTools(menu);
        this.addTools(menu, this.base.getToolsFolder());
        File sketchbookTools = new File(this.base.getSketchbookFolder(), "tools");
        this.addTools(menu, sketchbookTools);
        return menu;
    }

    protected void addTools(JMenu menu, File sourceFolder) {
        HashMap<String, JMenuItem> toolItems = new HashMap<String, JMenuItem>();
        File[] folders = sourceFolder.listFiles(new FileFilter(){

            public boolean accept(File folder) {
                if (folder.isDirectory()) {
                    File subfolder = new File(folder, "tool");
                    return subfolder.exists();
                }
                return false;
            }
        });
        if (folders == null || folders.length == 0) {
            return;
        }
        for (int i = 0; i < folders.length; ++i) {
            File toolDirectory = new File(folders[i], "tool");
            try {
                File[] archives = toolDirectory.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".jar") || name.toLowerCase().endsWith(".zip");
                    }
                });
                URL[] urlList = new URL[archives.length];
                for (int j = 0; j < urlList.length; ++j) {
                    urlList[j] = archives[j].toURI().toURL();
                }
                URLClassLoader loader = new URLClassLoader(urlList);
                String className = null;
                for (int j = 0; j < archives.length && (className = this.findClassInZipFile(folders[i].getName(), archives[j])) == null; ++j) {
                }
                if (className == null) continue;
                Class<?> toolClass = Class.forName(className, true, loader);
                final Tool tool = (Tool)toolClass.newInstance();
                tool.init(this);
                String title = tool.getMenuTitle();
                JMenuItem item = new JMenuItem(title);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(tool);
                    }
                });
                toolItems.put(title, item);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList toolList = new ArrayList(toolItems.keySet());
        if (toolList.size() == 0) {
            return;
        }
        menu.addSeparator();
        Collections.sort(toolList);
        for (String title : toolList) {
            menu.add((JMenuItem)toolItems.get(title));
        }
    }

    public JMenu buildModeMenu() {
        return null;
    }

    protected String findClassInZipFile(String base, File file) {
        String classFileName = "/" + base + ".class";
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String name;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).endsWith(classFileName)) continue;
                return name.substring(0, name.length() - 6).replace('/', '.');
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected JMenuItem createToolMenuItem(String className) {
        try {
            Class<?> toolClass = Class.forName(className);
            final Tool tool = (Tool)toolClass.newInstance();
            JMenuItem item = new JMenuItem(tool.getMenuTitle());
            tool.init(this);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(tool);
                }
            });
            return item;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected JMenu addInternalTools(JMenu menu) {
        menu.add(this.createToolMenuItem("processing.app.tools.CreateFont"));
        menu.add(this.createToolMenuItem("processing.app.tools.ColorSelector"));
        menu.add(this.createToolMenuItem("processing.app.tools.Archiver"));
        menu.add(this.createToolMenuItem("processing.app.tools.FixEncoding"));
        if (Base.DEBUG) {
            menu.add(this.createToolMenuItem("processing.app.tools.ExportExamples"));
        }
        return menu;
    }

    public abstract JMenu buildHelpMenu();

    public void showReference(String filename) {
        File file = new File(this.mode.getReferenceFolder(), filename);
        Base.openURL(file.getAbsolutePath());
    }

    public static void showChanges() {
        Base.openURL("http://wiki.processing.org/w/Changes");
    }

    public Sketch getSketch() {
        return this.sketch;
    }

    public JEditTextArea getTextArea() {
        return this.textarea;
    }

    public String getText() {
        return this.textarea.getText();
    }

    public String getText(int start, int stop) {
        return this.textarea.getText(start, stop - start);
    }

    public void setText(String what) {
        this.startCompoundEdit();
        this.textarea.setText(what);
        this.stopCompoundEdit();
    }

    public void insertText(String what) {
        this.startCompoundEdit();
        int caret = this.getCaretOffset();
        this.setSelection(caret, caret);
        this.textarea.setSelectedText(what);
        this.stopCompoundEdit();
    }

    public String getSelectedText() {
        return this.textarea.getSelectedText();
    }

    public void setSelectedText(String what) {
        this.textarea.setSelectedText(what);
    }

    public void setSelection(int start, int stop) {
        start = PApplet.constrain((int)start, (int)0, (int)this.textarea.getDocumentLength());
        stop = PApplet.constrain((int)stop, (int)0, (int)this.textarea.getDocumentLength());
        this.textarea.select(start, stop);
    }

    public int getCaretOffset() {
        return this.textarea.getCaretPosition();
    }

    public boolean isSelectionActive() {
        return this.textarea.isSelectionActive();
    }

    public int getSelectionStart() {
        return this.textarea.getSelectionStart();
    }

    public int getSelectionStop() {
        return this.textarea.getSelectionStop();
    }

    public String getLineText(int line) {
        return this.textarea.getLineText(line);
    }

    public void setLineText(int line, String what) {
        this.startCompoundEdit();
        this.textarea.select(this.getLineStartOffset(line), this.getLineStopOffset(line));
        this.textarea.setSelectedText(what);
        this.stopCompoundEdit();
    }

    public int getLineStartOffset(int line) {
        return this.textarea.getLineStartOffset(line);
    }

    public int getLineStopOffset(int line) {
        return this.textarea.getLineStopOffset(line);
    }

    public int getLineCount() {
        return this.textarea.getLineCount();
    }

    public void startCompoundEdit() {
        this.compoundEdit = new CompoundEdit();
    }

    public void stopCompoundEdit() {
        this.compoundEdit.end();
        this.undo.addEdit(this.compoundEdit);
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
        this.compoundEdit = null;
    }

    public int getScrollPosition() {
        return this.textarea.getScrollPosition();
    }

    protected void setCode(SketchCode code) {
        SyntaxDocument document = (SyntaxDocument)code.getDocument();
        if (document == null) {
            document = new SyntaxDocument();
            code.setDocument(document);
            document.setTokenMarker(this.mode.getTokenMarker());
            try {
                document.insertString(0, code.getProgram(), null);
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
            document.addUndoableEditListener(new UndoableEditListener(){

                public void undoableEditHappened(UndoableEditEvent e) {
                    if (Editor.this.compoundEdit != null) {
                        Editor.this.compoundEdit.addEdit(e.getEdit());
                    } else if (Editor.this.undo != null) {
                        Editor.this.caretUndoStack.push(Editor.this.textarea.getCaretPosition());
                        Editor.this.caretRedoStack.clear();
                        Editor.this.undo.addEdit(e.getEdit());
                        Editor.this.undoAction.updateUndoState();
                        Editor.this.redoAction.updateRedoState();
                    }
                }
            });
        }
        this.textarea.setDocument(document, code.getSelectionStart(), code.getSelectionStop(), code.getScrollPosition());
        this.textarea.requestFocusInWindow();
        this.undo = code.getUndo();
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    }

    public void handleCut() {
        this.textarea.cut();
        this.sketch.setModified(true);
    }

    public void handleCopy() {
        this.textarea.copy();
    }

    public void handleCopyAsHTML() {
        this.textarea.copyAsHTML();
        this.statusNotice("Code formatted as HTML has been copied to the clipboard.");
    }

    public void handlePaste() {
        this.textarea.paste();
        this.sketch.setModified(true);
    }

    public void handleSelectAll() {
        this.textarea.selectAll();
    }

    public void handleAutoFormat() {
        String source = this.getText();
        try {
            String formattedText = this.createFormatter().format(source);
            int selectionEnd = this.getSelectionStop();
            if (formattedText.length() < selectionEnd - 1) {
                selectionEnd = formattedText.length() - 1;
            }
            if (formattedText.equals(source)) {
                this.statusNotice("No changes necessary for Auto Format.");
            } else {
                this.setText(formattedText);
                this.setSelection(selectionEnd, selectionEnd);
                this.getSketch().setModified(true);
                this.statusNotice("Auto Format finished.");
            }
        }
        catch (Exception e) {
            this.statusError(e);
        }
    }

    public abstract String getCommentPrefix();

    protected void handleCommentUncomment() {
        this.startCompoundEdit();
        String prefix = this.getCommentPrefix();
        int prefixLen = prefix.length();
        int startLine = this.textarea.getSelectionStartLine();
        int stopLine = this.textarea.getSelectionStopLine();
        int lastLineStart = this.textarea.getLineStartOffset(stopLine);
        int selectionStop = this.textarea.getSelectionStop();
        if (selectionStop == lastLineStart && this.textarea.isSelectionActive()) {
            --stopLine;
        }
        int length = this.textarea.getDocumentLength();
        boolean commented = true;
        for (int i = startLine; commented && i <= stopLine; ++i) {
            int pos = this.textarea.getLineStartOffset(i);
            if (pos + prefixLen > length) {
                commented = false;
                continue;
            }
            String begin = this.textarea.getText(pos, 2);
            commented = begin.equals(prefix);
        }
        for (int line = startLine; line <= stopLine; ++line) {
            int location = this.textarea.getLineStartOffset(line);
            if (commented) {
                this.textarea.select(location, location + prefixLen);
                if (!this.textarea.getSelectedText().equals(prefix)) continue;
                this.textarea.setSelectedText("");
                continue;
            }
            this.textarea.select(location, location);
            this.textarea.setSelectedText(prefix);
        }
        this.textarea.select(this.textarea.getLineStartOffset(startLine), this.textarea.getLineStopOffset(stopLine) - 1);
        this.stopCompoundEdit();
    }

    public void handleIndent() {
        this.handleIndentOutdent(true);
    }

    public void handleOutdent() {
        this.handleIndentOutdent(false);
    }

    public void handleIndentOutdent(boolean indent) {
        int tabSize = Preferences.getInteger("editor.tabs.size");
        String tabString = EMPTY.substring(0, tabSize);
        this.startCompoundEdit();
        int startLine = this.textarea.getSelectionStartLine();
        int stopLine = this.textarea.getSelectionStopLine();
        int lastLineStart = this.textarea.getLineStartOffset(stopLine);
        int selectionStop = this.textarea.getSelectionStop();
        if (selectionStop == lastLineStart && this.textarea.isSelectionActive()) {
            --stopLine;
        }
        for (int line = startLine; line <= stopLine; ++line) {
            int location = this.textarea.getLineStartOffset(line);
            if (indent) {
                this.textarea.select(location, location);
                this.textarea.setSelectedText(tabString);
                continue;
            }
            this.textarea.select(location, location + tabSize);
            if (!this.textarea.getSelectedText().equals(tabString)) continue;
            this.textarea.setSelectedText("");
        }
        this.textarea.select(this.textarea.getLineStartOffset(startLine), this.textarea.getLineStopOffset(stopLine) - 1);
        this.stopCompoundEdit();
    }

    protected void handleFindReference() {
        String text = this.textarea.getSelectedText().trim();
        if (text.length() == 0) {
            this.statusNotice("First select a word to find in the reference.");
        } else {
            String referenceFile = this.mode.lookupReference(text);
            if (referenceFile == null) {
                this.statusNotice("No reference available for \"" + text + "\"");
            } else {
                this.showReference(referenceFile + ".html");
            }
        }
    }

    public void setSketchLocation(Point p) {
        this.sketchWindowLocation = p;
    }

    public Point getSketchLocation() {
        return this.sketchWindowLocation;
    }

    protected boolean checkModified() {
        if (!this.sketch.isModified()) {
            return true;
        }
        String prompt = "Save changes to " + this.sketch.getName() + "?  ";
        if (!Base.isMacOS()) {
            int result = JOptionPane.showConfirmDialog(this, prompt, "Close", 1, 3);
            if (result == 0) {
                return this.handleSaveRequest(true);
            }
            if (result == 1) {
                return true;
            }
            if (result == 2) {
                return false;
            }
            throw new IllegalStateException();
        }
        JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>Do you want to save changes to this sketch<BR> before closing?</b><p>If you don't save, your changes will be lost.", 3);
        Object[] options = new String[]{"Save", "Cancel", "Don't Save"};
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
        JDialog dialog = pane.createDialog(this, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        if (result == options[0]) {
            return this.handleSaveRequest(true);
        }
        return result == options[2];
    }

    protected boolean handleOpenInternal(String path) {
        File file = new File(path);
        File parentFile = new File(file.getParent());
        String parentName = parentFile.getName();
        String pdeName = parentName + ".pde";
        File altFile = new File(file.getParent(), pdeName);
        if (!pdeName.equals(file.getName())) {
            if (altFile.exists()) {
                path = altFile.getAbsolutePath();
            } else {
                if (!path.endsWith(".pde")) {
                    Base.showWarning("Bad file selected", "Processing can only open its own sketches\nand other files ending in .pde", null);
                    return false;
                }
                String properParent = file.getName().substring(0, file.getName().length() - 4);
                Object[] options = new Object[]{"OK", "Cancel"};
                String prompt = "The file \"" + file.getName() + "\" needs to be inside\n" + "a sketch folder named \"" + properParent + "\".\n" + "Create this folder, move the file, and continue?";
                int result = JOptionPane.showOptionDialog(this, prompt, "Moving", 0, 3, null, options, options[0]);
                if (result == 0) {
                    File properFolder = new File(file.getParent(), properParent);
                    if (properFolder.exists()) {
                        Base.showWarning("Error", "A folder named \"" + properParent + "\" " + "already exists. Can't open sketch.", null);
                        return false;
                    }
                    if (!properFolder.mkdirs()) {
                        Base.showWarning("Error", "Could not create the sketch folder.", null);
                        return false;
                    }
                    File properPdeFile = new File(properFolder, file.getName());
                    File origPdeFile = new File(path);
                    try {
                        Base.copyFile(origPdeFile, properPdeFile);
                    }
                    catch (IOException e) {
                        Base.showWarning("Error", "Could not copy to a proper location.", e);
                        return false;
                    }
                    origPdeFile.delete();
                    path = properPdeFile.getAbsolutePath();
                } else if (result == 1) {
                    return false;
                }
            }
        }
        try {
            this.sketch = new Sketch(this, path);
        }
        catch (IOException e) {
            Base.showWarning("Error", "Could not create the sketch.", e);
            return false;
        }
        this.header.rebuild();
        this.setTitle();
        this.untitled = false;
        this.base.storeSketches();
        Preferences.save();
        return true;
    }

    public void setTitle() {
        this.setTitle(this.sketch.getName() + " | Processing " + Base.VERSION_NAME);
    }

    public boolean handleSaveRequest(boolean immediately) {
        if (this.untitled) {
            return this.handleSaveAs();
        }
        if (immediately) {
            this.handleSave();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Editor.this.handleSave();
                }
            });
        }
        return true;
    }

    public void handleSave() {
        this.statusNotice("Saving...");
        try {
            if (this.sketch.save()) {
                this.statusNotice("Done Saving.");
            } else {
                this.statusEmpty();
            }
        }
        catch (Exception e) {
            this.statusError(e);
        }
    }

    public boolean handleSaveAs() {
        this.statusNotice("Saving...");
        try {
            if (!this.sketch.saveAs()) {
                this.statusNotice("Save Canceled.");
                return false;
            }
            this.statusNotice("Done Saving.");
        }
        catch (Exception e) {
            this.statusError(e);
        }
        return true;
    }

    public void handlePageSetup() {
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        if (this.pageFormat == null) {
            this.pageFormat = this.printerJob.defaultPage();
        }
        this.pageFormat = this.printerJob.pageDialog(this.pageFormat);
    }

    public void handlePrint() {
        this.statusNotice("Printing...");
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        if (this.pageFormat != null) {
            this.printerJob.setPrintable(this.textarea.getPainter(), this.pageFormat);
        } else {
            this.printerJob.setPrintable(this.textarea.getPainter());
        }
        this.printerJob.setJobName(this.sketch.getCurrentCode().getPrettyName());
        if (this.printerJob.printDialog()) {
            try {
                this.printerJob.print();
                this.statusNotice("Done printing.");
            }
            catch (PrinterException pe) {
                this.statusError("Error while printing.");
                pe.printStackTrace();
            }
        } else {
            this.statusNotice("Printing canceled.");
        }
    }

    public void prepareRun() {
        this.internalCloseRunner();
        this.statusEmpty();
        for (int i = 0; i < 10; ++i) {
            System.out.println();
        }
        if (Preferences.getBoolean("console.auto_clear")) {
            this.console.clear();
        }
        this.sketch.ensureExistence();
        this.sketch.getCurrentCode().setProgram(this.getText());
        if (Preferences.getBoolean("editor.external")) {
            this.sketch.reload();
        }
    }

    public abstract void internalCloseRunner();

    public abstract void deactivateRun();

    public void statusError(String what) {
        this.status.error(what);
    }

    public void statusError(Exception e) {
        String mess;
        e.printStackTrace();
        if (e instanceof SketchException) {
            SketchException re = (SketchException)e;
            if (re.hasCodeIndex()) {
                this.sketch.setCurrentCode(re.getCodeIndex());
            }
            if (re.hasCodeLine()) {
                int line = re.getCodeLine();
                if (line >= this.textarea.getLineCount() && this.textarea.getLineText(line = this.textarea.getLineCount() - 1).length() == 0) {
                    --line;
                }
                if (line < 0 || line >= this.textarea.getLineCount()) {
                    System.err.println("Bad error line: " + line);
                } else {
                    this.textarea.select(this.textarea.getLineStartOffset(line), this.textarea.getLineStopOffset(line) - 1);
                }
            }
        }
        if ((mess = e.getMessage()) != null) {
            String rxString;
            String javaLang = "java.lang.";
            if (mess.indexOf(javaLang) == 0) {
                mess = mess.substring(javaLang.length());
            }
            if (mess.startsWith(rxString = "RuntimeException: ")) {
                mess = mess.substring(rxString.length());
            }
            this.statusError(mess);
        }
    }

    public void statusNotice(String msg) {
        this.status.notice(msg);
    }

    public void clearNotice(String msg) {
        if (this.status.message.equals(msg)) {
            this.statusEmpty();
        }
    }

    public void statusEmpty() {
        this.statusNotice(EMPTY);
    }

    public void startIndeterminate() {
        this.status.startIndeterminate();
    }

    public void stopIndeterminate() {
        this.status.stopIndeterminate();
    }

    public void statusHalt() {
    }

    public boolean isHalted() {
        return false;
    }

    class TextAreaPopup
    extends JPopupMenu {
        JMenuItem cutItem = new JMenuItem("Cut");
        JMenuItem copyItem;
        JMenuItem discourseItem;
        JMenuItem referenceItem;

        public TextAreaPopup() {
            this.cutItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleCut();
                }
            });
            this.add(this.cutItem);
            this.copyItem = new JMenuItem("Copy");
            this.copyItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleCopy();
                }
            });
            this.add(this.copyItem);
            this.discourseItem = new JMenuItem("Copy as HTML");
            this.discourseItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleCopyAsHTML();
                }
            });
            this.add(this.discourseItem);
            JMenuItem item = new JMenuItem("Paste");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handlePaste();
                }
            });
            this.add(item);
            item = new JMenuItem("Select All");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleSelectAll();
                }
            });
            this.add(item);
            this.addSeparator();
            item = new JMenuItem("Comment/Uncomment");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleCommentUncomment();
                }
            });
            this.add(item);
            item = new JMenuItem("Increase Indent");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleIndentOutdent(true);
                }
            });
            this.add(item);
            item = new JMenuItem("Decrease Indent");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleIndentOutdent(false);
                }
            });
            this.add(item);
            this.addSeparator();
            this.referenceItem = new JMenuItem("Find in Reference");
            this.referenceItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleFindReference();
                }
            });
            this.add(this.referenceItem);
        }

        public void show(Component component, int x, int y) {
            if (Editor.this.textarea.isSelectionActive()) {
                this.cutItem.setEnabled(true);
                this.copyItem.setEnabled(true);
                this.discourseItem.setEnabled(true);
                String sel = Editor.this.textarea.getSelectedText().trim();
                String referenceFile = Editor.this.mode.lookupReference(sel);
                this.referenceItem.setEnabled(referenceFile != null);
            } else {
                this.cutItem.setEnabled(false);
                this.copyItem.setEnabled(false);
                this.discourseItem.setEnabled(false);
                this.referenceItem.setEnabled(false);
            }
            super.show(component, x, y);
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Editor.this.undo.redo();
            }
            catch (CannotRedoException ex) {
                // empty catch block
            }
            try {
                Integer caret = (Integer)Editor.this.caretRedoStack.pop();
                Editor.this.caretUndoStack.push(caret);
                Editor.this.textarea.setCaretPosition(caret);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updateRedoState();
            Editor.this.undoAction.updateUndoState();
            if (Editor.this.sketch != null) {
                Editor.this.sketch.setModified(!Editor.this.getText().equals(Editor.this.sketch.getCurrentCode().getSavedProgram()));
            }
        }

        protected void updateRedoState() {
            if (Editor.this.undo.canRedo()) {
                Editor.this.redoItem.setEnabled(true);
                Editor.this.redoItem.setText(Editor.this.undo.getRedoPresentationName());
                this.putValue("Name", Editor.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                Editor.this.redoItem.setEnabled(false);
                Editor.this.redoItem.setText("Redo");
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Integer caret = (Integer)Editor.this.caretUndoStack.pop();
                Editor.this.caretRedoStack.push(caret);
                Editor.this.textarea.setCaretPosition(caret);
                Editor.this.textarea.scrollToCaret();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                Editor.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.updateUndoState();
            Editor.this.redoAction.updateRedoState();
            if (Editor.this.sketch != null) {
                Editor.this.sketch.setModified(!Editor.this.getText().equals(Editor.this.sketch.getCurrentCode().getSavedProgram()));
            }
        }

        protected void updateUndoState() {
            if (Editor.this.undo.canUndo()) {
                this.setEnabled(true);
                Editor.this.undoItem.setEnabled(true);
                Editor.this.undoItem.setText(Editor.this.undo.getUndoPresentationName());
                this.putValue("Name", Editor.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                Editor.this.undoItem.setEnabled(false);
                Editor.this.undoItem.setText("Undo");
                this.putValue("Name", "Undo");
            }
        }
    }

    class FileDropHandler
    extends TransferHandler {
        FileDropHandler() {
        }

        public boolean canImport(JComponent dest, DataFlavor[] flavors) {
            return true;
        }

        public boolean importData(JComponent src, Transferable transferable) {
            int successful = 0;
            try {
                DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (int i = 0; i < list.size(); ++i) {
                        File file = (File)list.get(i);
                        if (!Editor.this.sketch.addFile(file)) continue;
                        ++successful;
                    }
                } else if (transferable.isDataFlavorSupported(uriListFlavor)) {
                    String data = (String)transferable.getTransferData(uriListFlavor);
                    String[] pieces = PApplet.splitTokens((String)data, (String)"\r\n");
                    for (int i = 0; i < pieces.length; ++i) {
                        if (pieces[i].startsWith("#")) continue;
                        String path = null;
                        if (pieces[i].startsWith("file:///")) {
                            path = pieces[i].substring(7);
                        } else if (pieces[i].startsWith("file:/")) {
                            path = pieces[i].substring(5);
                        }
                        if (!Editor.this.sketch.addFile(new File(path))) continue;
                        ++successful;
                    }
                }
            }
            catch (Exception e) {
                Base.showWarning("Drag & Drop Problem", "An error occurred while trying to add files to the sketch.", e);
                return false;
            }
            if (successful == 0) {
                Editor.this.statusError("No files were added to the sketch.");
            } else if (successful == 1) {
                Editor.this.statusNotice("One file added to the sketch.");
            } else {
                Editor.this.statusNotice(successful + " files added to the sketch.");
            }
            return true;
        }
    }
}

