/*
 * Decompiled with CFR 0.152.
 */
package com.projity.contrib;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.UIManager;

public class ClassLoaderUtils {
    protected static ClassLoaderTransformer transformer;
    private static Method messageMethod;
    private static boolean modifClassloader;
    private static String javaVersion;

    public static ClassLoaderTransformer getTransformer() {
        return transformer;
    }

    public static void setTransformer(ClassLoaderTransformer classLoaderTransformer) {
        transformer = classLoaderTransformer;
    }

    public static ClassLoader getLocalClassLoader() {
        return ClassLoaderUtils.getModifiedClassLoader(ClassLoaderUtils.class.getClassLoader());
    }

    public static ClassLoader getModifiedClassLoader(ClassLoader classLoader) {
        if (transformer == null || !ClassLoaderUtils.needModifiedClassloader()) {
            return classLoader;
        }
        return transformer.transform(classLoader);
    }

    public static ResourceBundle getBundle(String string) {
        return ResourceBundle.getBundle(string, Locale.getDefault(), ClassLoaderUtils.getLocalClassLoader());
    }

    public static Class forName(String string) throws ClassNotFoundException {
        return Class.forName(string, true, ClassLoaderUtils.getLocalClassLoader());
    }

    public static String getString(String string) {
        Object object;
        if (messageMethod == null) {
            try {
                object = Class.forName("com.projity.strings.Messages");
                messageMethod = ((Class)object).getMethod("getString", String.class);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object = null;
        if (messageMethod != null) {
            try {
                object = (String)messageMethod.invoke(null, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.out.println("null message method");
        }
        if (object == null) {
            object = UIManager.getString(string);
        }
        return object;
    }

    public static int compareJavaVersionTo(String string) {
        return ClassLoaderUtils.compareJavaVersion(javaVersion, string);
    }

    public static int compareJavaVersion(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        while (stringTokenizer.hasMoreTokens() || stringTokenizer2.hasMoreTokens()) {
            int n = -1;
            try {
                n = stringTokenizer.hasMoreElements() ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n2 = -1;
            try {
                n2 = stringTokenizer2.hasMoreElements() ? Integer.parseInt(stringTokenizer2.nextToken()) : 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == 0 && n2 == -1) {
                return -1;
            }
            if (n == -1 && n2 == 0) {
                return 1;
            }
            if (n < n2) {
                return -1;
            }
            if (n <= n2) continue;
            return 1;
        }
        return 0;
    }

    public static boolean needModifiedClassloader() {
        if (javaVersion == null) {
            ClassLoaderUtils.getJavaVersion();
        }
        return modifClassloader;
    }

    public static String getJavaVersion() {
        if (javaVersion == null) {
            javaVersion = System.getProperty("java.specification.version");
            modifClassloader = ClassLoaderUtils.compareJavaVersionTo("1.6") < 0;
        }
        return javaVersion;
    }

    static {
        modifClassloader = false;
        javaVersion = null;
    }

    public static interface ClassLoaderTransformer {
        public ClassLoader transform(ClassLoader var1);
    }
}

