/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.calendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;

public class JXDatePickerFormatterFactory
extends JFormattedTextField.AbstractFormatterFactory {
    protected JFormattedTextField.AbstractFormatter formatter = null;

    public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
        if (this.formatter == null) {
            this.formatter = new JXDatePickerFormatter();
        }
        return this.formatter;
    }

    private class JXDatePickerFormatter
    extends JFormattedTextField.AbstractFormatter {
        private SimpleDateFormat[] _formats = new SimpleDateFormat[3];
        private int _formatIndex = 0;

        public JXDatePickerFormatter() {
            String string = UIManager.getString("JXDatePicker.longFormat");
            if (string == null) {
                string = "EEE MM/dd/yyyy";
            }
            this._formats[0] = new SimpleDateFormat(string);
            string = UIManager.getString("JXDatePicker.mediumFormat");
            if (string == null) {
                string = "MM/dd/yyyy";
            }
            this._formats[1] = new SimpleDateFormat(string);
            string = UIManager.getString("JXDatePicker.shortFormat");
            if (string == null) {
                string = "MM/dd";
            }
            this._formats[2] = new SimpleDateFormat(string);
        }

        public Object stringToValue(String string) throws ParseException {
            Date date = null;
            ParseException parseException = null;
            if (string == null || string.trim().length() == 0) {
                return null;
            }
            if (date == null) {
                for (int i = 0; i < this._formats.length; ++i) {
                    try {
                        date = this._formats[i].parse(string);
                        this._formatIndex = i;
                        parseException = null;
                        break;
                    }
                    catch (ParseException parseException2) {
                        parseException = parseException2;
                        continue;
                    }
                }
            }
            if (parseException != null) {
                throw parseException;
            }
            return date;
        }

        public String valueToString(Object object) throws ParseException {
            if (object != null) {
                return this._formats[this._formatIndex].format(object);
            }
            return null;
        }
    }
}

