/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class ClusteredXYBarRenderer
extends XYBarRenderer
implements Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = 5864462149177133147L;
    private boolean centerBarAtStartValue;

    public ClusteredXYBarRenderer() {
        this(0.0, false);
    }

    public ClusteredXYBarRenderer(double margin, boolean centerBarAtStartValue) {
        super(margin);
        this.centerBarAtStartValue = centerBarAtStartValue;
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        EntityCollection entities;
        double value1;
        double value0;
        IntervalXYDataset intervalDataset = (IntervalXYDataset)dataset;
        if (this.getUseYInterval()) {
            value0 = intervalDataset.getStartYValue(series, item);
            value1 = intervalDataset.getEndYValue(series, item);
        } else {
            value0 = this.getBase();
            value1 = intervalDataset.getYValue(series, item);
        }
        if (Double.isNaN(value0) || Double.isNaN(value1)) {
            return;
        }
        double translatedValue0 = rangeAxis.valueToJava2D(value0, dataArea, plot.getRangeAxisEdge());
        double translatedValue1 = rangeAxis.valueToJava2D(value1, dataArea, plot.getRangeAxisEdge());
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        double x1 = intervalDataset.getStartXValue(series, item);
        double translatedX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double x2 = intervalDataset.getEndXValue(series, item);
        double translatedX2 = domainAxis.valueToJava2D(x2, dataArea, xAxisLocation);
        double translatedWidth = Math.max(1.0, Math.abs(translatedX2 - translatedX1));
        double translatedHeight = Math.abs(translatedValue0 - translatedValue1);
        if (this.centerBarAtStartValue) {
            translatedX1 -= translatedWidth / 2.0;
        }
        PlotOrientation orientation = plot.getOrientation();
        double m = this.getMargin();
        if (m > 0.0) {
            double cut = translatedWidth * this.getMargin();
            translatedWidth -= cut;
            translatedX1 = orientation == PlotOrientation.HORIZONTAL ? (translatedX1 -= cut / 2.0) : (translatedX1 += cut / 2.0);
        }
        int numSeries = dataset.getSeriesCount();
        double seriesBarWidth = translatedWidth / (double)numSeries;
        Rectangle2D.Double bar = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            bar = new Rectangle2D.Double(Math.min(translatedValue0, translatedValue1), translatedX1 - seriesBarWidth * (double)(numSeries - series), translatedHeight, seriesBarWidth);
        } else if (orientation == PlotOrientation.VERTICAL) {
            bar = new Rectangle2D.Double(translatedX1 + seriesBarWidth * (double)series, Math.min(translatedValue0, translatedValue1), seriesBarWidth, translatedHeight);
        }
        Paint itemPaint = this.getItemPaint(series, item);
        if (this.getGradientPaintTransformer() != null && itemPaint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)itemPaint;
            itemPaint = this.getGradientPaintTransformer().transform(gp, bar);
        }
        g2.setPaint(itemPaint);
        g2.fill(bar);
        if (this.isDrawBarOutline() && Math.abs(translatedX2 - translatedX1) > 3.0) {
            g2.setStroke(this.getItemOutlineStroke(series, item));
            g2.setPaint(this.getItemOutlinePaint(series, item));
            g2.draw(bar);
        }
        if (this.isItemLabelVisible(series, item)) {
            XYItemLabelGenerator generator = this.getItemLabelGenerator(series, item);
            this.drawItemLabel(g2, dataset, series, item, plot, generator, bar, value1 < 0.0);
        }
        if (info != null && (entities = info.getOwner().getEntityCollection()) != null) {
            String tip = null;
            XYToolTipGenerator generator = this.getToolTipGenerator(series, item);
            if (generator != null) {
                tip = generator.generateToolTip(dataset, series, item);
            }
            String url = null;
            if (this.getURLGenerator() != null) {
                url = this.getURLGenerator().generateURL(dataset, series, item);
            }
            XYItemEntity entity = new XYItemEntity(bar, dataset, series, item, tip, url);
            entities.add(entity);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ClusteredXYBarRenderer)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ClusteredXYBarRenderer that = (ClusteredXYBarRenderer)obj;
        return this.centerBarAtStartValue == that.centerBarAtStartValue;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

